/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.DiscretizeProcess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IEMDiscretizer
implements Runnable {
    private LinkedList<ClassValuePair> myClassValues;
    private ArrayList<ClassValuePair> myClassValuesArray;
    LinkedList<Double> myBoundaryPoints;
    int myNumClasses;
    private boolean finished = false;
    private int triedCuts = 0;
    private boolean abort = false;
    private boolean killHelpers = false;
    private int triedCutPoints = 0;
    private int cutsMade = 0;
    private LinkedList<Task> tasks = null;
    private int numThreads = 0;
    private int waitingThreads = 0;
    private DiscretizeProcess.Interval[] in = null;

    public IEMDiscretizer(ArrayList<ClassValuePair> arrayList) {
        this.myClassValuesArray = arrayList;
        this.tasks = new LinkedList();
    }

    public void performDiscretization() {
        Collections.sort(this.myClassValuesArray);
        this.myClassValues = new LinkedList<ClassValuePair>(this.myClassValuesArray);
        this.myBoundaryPoints = this.findBoundaries(this.myClassValuesArray);
        this.myNumClasses = this.numClasses(this.myClassValues);
        Thread thread = new Thread(this);
        thread.start();
    }

    public void createHelperThreads(int n) {
        for (int i = 0; i < n; ++i) {
            Thread thread = new Thread(new HelperThread());
            thread.start();
            ++this.numThreads;
        }
    }

    public int getTriedCuts() {
        return this.triedCuts;
    }

    public int getCutsMade() {
        return this.cutsMade;
    }

    public boolean finished() {
        return this.finished;
    }

    public boolean canceled() {
        return this.abort;
    }

    public synchronized void cancel() {
        this.abort = true;
        this.killHelpers = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        LinkedList<ClassValuePair> linkedList = this.myClassValues;
        List<Double> list = Collections.synchronizedList(new LinkedList());
        LinkedList<Double> linkedList2 = this.myBoundaryPoints;
        int n = this.myNumClasses;
        this.addTask(new RecurseTask(n, list, linkedList2, linkedList));
        while (true) {
            Object object2;
            if ((object = this.getTaskBlockWait(100)) != null) {
                if (object instanceof RecurseTask) {
                    object.compute();
                } else if (object instanceof IterateTask && !((IterateTask)(object2 = (IterateTask)object)).completed) {
                    ((IterateTask)object2).compute();
                }
            }
            object2 = this.tasks;
            synchronized (object2) {
                if (this.waitingThreads == this.numThreads && this.tasks.size() == 0 || this.abort || this.killHelpers) {
                    break;
                }
            }
        }
        object = this.tasks;
        synchronized (object) {
            this.killHelpers = true;
            this.tasks.notifyAll();
        }
        object = this;
        synchronized (object) {
            if (this.abort) {
                return;
            }
            Collections.sort(list);
            int n2 = list.size();
            int n3 = n2 > 0 ? n2 + 1 : 1;
            this.in = new DiscretizeProcess.Interval[n3];
            double d = Double.POSITIVE_INFINITY;
            if (n3 == 1) {
                DiscretizeProcess.Interval interval;
                this.in[0] = interval = new DiscretizeProcess.Interval(-d, d);
            } else {
                for (int i = 0; i < n3; ++i) {
                    DiscretizeProcess.Interval interval = null;
                    interval = i == 0 ? (list.size() > i + 1 ? new DiscretizeProcess.Interval(-d, list.get(i) + (list.get(i + 1) - list.get(i)) / 2.0) : new DiscretizeProcess.Interval(-d, list.get(i))) : (i == n3 - 1 ? (list.size() > i ? new DiscretizeProcess.Interval(list.get(i - 1) + (list.get(i) - list.get(i - 1)) / 2.0, d) : new DiscretizeProcess.Interval(list.get(i - 1), d)) : (list.size() > i + 1 ? new DiscretizeProcess.Interval(list.get(i - 1) + (list.get(i) - list.get(i - 1)) / 2.0, list.get(i) + (list.get(i + 1) - list.get(i)) / 2.0) : new DiscretizeProcess.Interval(list.get(i - 1) + (list.get(i) - list.get(i - 1)) / 2.0, list.get(i))));
                    this.in[i] = interval;
                }
            }
            this.finished = true;
            System.out.println("cuts made=" + this.cutsMade + "     cuts tried=" + this.triedCuts);
        }
    }

    public DiscretizeProcess.Interval[] getIntervals() {
        return this.in;
    }

    private LinkedList<Double> findBoundaries(ArrayList<ClassValuePair> arrayList) {
        LinkedList<Double> linkedList = new LinkedList<Double>();
        for (int i = 0; i < arrayList.size(); ++i) {
            double d;
            ClassValuePair classValuePair = arrayList.get(i);
            int[] nArray = new int[]{i};
            boolean bl = this.hasMoreThanOneClass(i, arrayList, nArray);
            int n = nArray[0];
            ClassValuePair classValuePair2 = arrayList.get(n);
            if (bl) {
                d = (classValuePair.value + classValuePair2.value) / 2.0;
                i = --n;
                if (linkedList.size() != 0 && linkedList.getLast() == d) continue;
                linkedList.add(new Double(d));
                continue;
            }
            if (classValuePair.cls == classValuePair2.cls && !this.hasMoreThanOneClass(n, arrayList, nArray)) continue;
            n = nArray[0];
            classValuePair2 = arrayList.get(n);
            d = (classValuePair.value + classValuePair2.value) / 2.0;
            if (linkedList.size() == 0 || linkedList.getLast() != d) {
                linkedList.add(new Double(d));
            }
            i = --n;
        }
        return linkedList;
    }

    private boolean hasMoreThanOneClass(int n, List<ClassValuePair> list, int[] nArray) {
        if (n == list.size() - 1) {
            return false;
        }
        boolean bl = false;
        ClassValuePair classValuePair = list.get(n);
        int n2 = n + 1;
        ClassValuePair classValuePair2 = list.get(n2);
        while (n2 < list.size() - 1 && classValuePair.value == classValuePair2.value) {
            if (classValuePair.cls != classValuePair2.cls) {
                bl = true;
            }
            classValuePair2 = list.get(++n2);
        }
        nArray[0] = n2;
        return bl;
    }

    private int numClasses(List<ClassValuePair> list) {
        int n = 0;
        for (ClassValuePair classValuePair : list) {
            if (classValuePair.cls <= n) continue;
            n = classValuePair.cls;
        }
        Object object = new int[n + 1];
        int n2 = 0;
        for (ClassValuePair classValuePair : list) {
            if (object[classValuePair.cls] != false) continue;
            object[classValuePair.cls] = true;
            ++n2;
        }
        return n2;
    }

    private double entropy(int n, LinkedList<ClassValuePair> linkedList) {
        int[] nArray = new int[n];
        for (ClassValuePair classValuePair : linkedList) {
            nArray[classValuePair.cls] = nArray[classValuePair.cls] + 1;
        }
        int n2 = linkedList.size();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == 0 || n2 == 0) continue;
            double d2 = (double)nArray[i] / (double)n2;
            d += d2 * Math.log(d2) / Math.log(2.0);
        }
        return -d;
    }

    private synchronized void incCutsMade() {
        ++this.cutsMade;
    }

    private synchronized void incTriedCuts() {
        ++this.triedCuts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(Task task) {
        LinkedList<Task> linkedList = this.tasks;
        synchronized (linkedList) {
            this.tasks.add(task);
            this.tasks.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task getTask() {
        LinkedList<Task> linkedList = this.tasks;
        synchronized (linkedList) {
            while (!this.abort && !this.killHelpers) {
                if (this.tasks.size() > 0) {
                    return this.tasks.removeFirst();
                }
                ++this.waitingThreads;
                try {
                    this.tasks.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                --this.waitingThreads;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task getTaskBlockWait(int n) {
        LinkedList<Task> linkedList = this.tasks;
        synchronized (linkedList) {
            if (!this.abort && !this.killHelpers && this.tasks.size() > 0) {
                return this.tasks.removeFirst();
            }
            try {
                this.tasks.wait(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.abort && !this.killHelpers && this.tasks.size() > 0) {
                return this.tasks.removeFirst();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassValuePair
    implements Comparable<ClassValuePair> {
        public int cls;
        public double value;

        public ClassValuePair(int n, double d) {
            this.cls = n;
            this.value = d;
        }

        @Override
        public int compareTo(ClassValuePair classValuePair) {
            if (this.value < classValuePair.value) {
                return -1;
            }
            if (this.value > classValuePair.value) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "" + this.cls + "       " + this.value + "\n";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IterateTask
    implements Task {
        private LinkedList<Double> boundaryPoints;
        private double entropyEntireSet;
        private int numClasses;
        private boolean completed = false;
        private int classValuesSize;
        private double bestGain;
        public LinkedList<ClassValuePair> S1;
        public LinkedList<ClassValuePair> S2;
        public LinkedList<Double> BP1;
        public LinkedList<Double> BP2;
        Double bestPoint = null;
        double bestS1Entropy;
        double bestS2Entropy;

        public IterateTask(LinkedList<Double> linkedList, int n, LinkedList<ClassValuePair> linkedList2, LinkedList<ClassValuePair> linkedList3, LinkedList<Double> linkedList4, LinkedList<Double> linkedList5, double d, int n2) {
            this.boundaryPoints = linkedList;
            this.S1 = linkedList2;
            this.S2 = linkedList3;
            this.BP1 = linkedList4;
            this.BP2 = linkedList5;
            this.entropyEntireSet = d;
            this.numClasses = n2;
            this.classValuesSize = n;
        }

        @Override
        public synchronized void compute() {
            if (this.completed) {
                return;
            }
            this.bestGain = -1.0;
            this.bestS1Entropy = 0.0;
            this.bestS2Entropy = 0.0;
            LinkedList<Object> linkedList = new LinkedList();
            LinkedList<Object> linkedList2 = new LinkedList();
            LinkedList<Object> linkedList3 = new LinkedList();
            LinkedList<Object> linkedList4 = new LinkedList();
            for (Double d : this.boundaryPoints) {
                double d2;
                Comparable<ClassValuePair> comparable;
                if (IEMDiscretizer.this.abort) {
                    this.completed = true;
                    return;
                }
                IEMDiscretizer.this.incTriedCuts();
                double d3 = d;
                if (this.S1.size() > 0 && this.S1.getLast().value > d3) {
                    while (this.S1.size() > 0) {
                        comparable = this.S1.removeLast();
                        if (((ClassValuePair)comparable).value > d3) {
                            this.S2.addFirst((ClassValuePair)comparable);
                            continue;
                        }
                        this.S1.add((ClassValuePair)comparable);
                        break;
                    }
                } else if (this.S2.size() > 0 && this.S2.getFirst().value < d3) {
                    while (this.S2.size() > 0) {
                        ClassValuePair classValuePair = this.S2.removeFirst();
                        if (classValuePair.value < d3) {
                            this.S1.add(classValuePair);
                            continue;
                        }
                        this.S2.addFirst(classValuePair);
                        break;
                    }
                }
                if (this.BP1.size() > 0 && this.BP1.getLast() > d) {
                    while (this.BP1.size() > 0) {
                        comparable = this.BP1.removeLast();
                        if ((Double)comparable > d) {
                            this.BP2.addFirst((Double)comparable);
                            continue;
                        }
                        this.BP1.add((Double)comparable);
                        break;
                    }
                } else if (this.BP2.size() > 0 && this.BP2.getFirst() < d) {
                    while (this.BP2.size() > 0) {
                        comparable = this.BP2.removeFirst();
                        if ((Double)comparable < d) {
                            this.BP1.add((Double)comparable);
                            continue;
                        }
                        this.BP2.addFirst((Double)comparable);
                        break;
                    }
                }
                double d4 = IEMDiscretizer.this.entropy(this.numClasses, this.S1);
                double d5 = IEMDiscretizer.this.entropy(this.numClasses, this.S2);
                double d6 = this.entropyEntireSet;
                double d7 = (double)this.S1.size() / (double)this.classValuesSize * d4;
                if (!((d6 -= d7 + (d2 = (double)this.S2.size() / (double)this.classValuesSize * d5)) > this.bestGain)) continue;
                this.bestGain = d6;
                this.bestPoint = d;
                linkedList = new LinkedList<ClassValuePair>(this.S1);
                linkedList2 = new LinkedList<Double>(this.BP1);
                this.bestS1Entropy = d4;
                linkedList3 = new LinkedList<ClassValuePair>(this.S2);
                linkedList4 = new LinkedList<Double>(this.BP2);
                this.bestS2Entropy = d5;
            }
            this.S1 = linkedList;
            this.S2 = linkedList3;
            this.BP1 = linkedList2;
            this.BP2 = linkedList4;
            this.completed = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RecurseTask
    implements Task {
        public int numClasses;
        public List<Double> cutPoints;
        public LinkedList<Double> boundaryPoints;
        public LinkedList<ClassValuePair> classValues;

        public RecurseTask(int n, List<Double> list, LinkedList<Double> linkedList, LinkedList<ClassValuePair> linkedList2) {
            this.numClasses = n;
            this.cutPoints = list;
            this.boundaryPoints = linkedList;
            this.classValues = linkedList2;
        }

        @Override
        public synchronized void compute() {
            int n;
            Object object;
            double d = IEMDiscretizer.this.entropy(this.numClasses, this.classValues);
            LinkedList<Double> linkedList = new LinkedList<Double>(this.boundaryPoints);
            LinkedList<Object> linkedList2 = new LinkedList<Object>();
            if (IEMDiscretizer.this.numThreads > 0 && this.boundaryPoints.size() > 20) {
                int n2 = this.boundaryPoints.size() / (IEMDiscretizer.this.numThreads + 1);
                while (this.boundaryPoints.size() > n2 && !IEMDiscretizer.this.abort && !IEMDiscretizer.this.killHelpers) {
                    LinkedList<Double> linkedList3 = new LinkedList<Double>();
                    for (int i = 0; i < n2; ++i) {
                        linkedList3.add(this.boundaryPoints.removeFirst());
                    }
                    object = new IterateTask(linkedList3, this.classValues.size(), new LinkedList<ClassValuePair>(this.classValues), new LinkedList<ClassValuePair>(), new LinkedList<Double>(linkedList), new LinkedList<Double>(), d, this.numClasses);
                    IEMDiscretizer.this.addTask((Task)object);
                    linkedList2.add(object);
                }
            }
            IterateTask iterateTask = new IterateTask(this.boundaryPoints, this.classValues.size(), new LinkedList<ClassValuePair>(this.classValues), new LinkedList<ClassValuePair>(), linkedList, new LinkedList<Double>(), d, this.numClasses);
            linkedList2.add(iterateTask);
            iterateTask.compute();
            do {
                n = 0;
                for (IterateTask iterateTask2 : linkedList2) {
                    if (iterateTask2.completed) {
                        ++n;
                        continue;
                    }
                    iterateTask2.compute();
                }
            } while (n != linkedList2.size());
            IterateTask iterateTask3 = null;
            for (IterateTask iterateTask2 : linkedList2) {
                if (iterateTask3 == null) {
                    iterateTask3 = iterateTask2;
                    continue;
                }
                if (!(iterateTask2.bestGain > iterateTask3.bestGain)) continue;
                iterateTask3 = iterateTask2;
            }
            object = iterateTask3.bestPoint;
            double d2 = iterateTask3.bestS1Entropy;
            double d3 = iterateTask3.bestS2Entropy;
            LinkedList<ClassValuePair> linkedList3 = iterateTask3.S1;
            LinkedList<Double> linkedList4 = iterateTask3.BP1;
            LinkedList<ClassValuePair> linkedList5 = iterateTask3.S2;
            LinkedList<Double> linkedList6 = iterateTask3.BP2;
            double d4 = iterateTask3.bestGain;
            int n2 = this.numClasses;
            int n3 = IEMDiscretizer.this.numClasses(linkedList3);
            int n4 = IEMDiscretizer.this.numClasses(linkedList5);
            double d5 = 0.0;
            if (n2 > 0) {
                d5 = Math.log(Math.pow(3.0, n2) - 2.0) / Math.log(2.0);
            }
            d5 -= (double)n2 * d - (double)n3 * d2 - (double)n4 * d3;
            double d6 = this.classValues.size();
            double d7 = Math.log(d6 - 1.0) / Math.log(2.0) / d6 + d5 / d6;
            if (d4 > d7) {
                this.cutPoints.add((Double)object);
                IEMDiscretizer.this.incCutsMade();
                if (n3 > 1) {
                    IEMDiscretizer.this.addTask(new RecurseTask(this.numClasses, this.cutPoints, linkedList4, linkedList3));
                }
                if (n4 > 1) {
                    IEMDiscretizer.this.addTask(new RecurseTask(this.numClasses, this.cutPoints, linkedList6, linkedList5));
                }
            }
        }
    }

    private static interface Task {
        public void compute();
    }

    private class HelperThread
    implements Runnable {
        public void run() {
            Task task = IEMDiscretizer.this.getTask();
            while (task != null && !IEMDiscretizer.this.killHelpers && !IEMDiscretizer.this.abort) {
                IterateTask iterateTask;
                if (task instanceof RecurseTask) {
                    task.compute();
                } else if (task instanceof IterateTask && !(iterateTask = (IterateTask)task).completed) {
                    iterateTask.compute();
                }
                task = IEMDiscretizer.this.getTask();
            }
        }
    }
}

