/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HGUI.BMPFile;
import COM.hugin.HGUI.BeliefMonitor;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.InstanceNode;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.NodeTable;
import COM.hugin.HGUI.NodeTableFrame;
import COM.hugin.HGUI.NodeTablePage;
import COM.hugin.HGUI.NodeTablePrintJob;
import COM.hugin.HGUI.TableHolder;
import COM.hugin.HGUI.VerticalFlowLayout;
import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.awt.print.PageFormat;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ImageExporter
extends Thread {
    static int bmpWidth = 600;
    static int titleHeight = 20;
    static int margin = 10;
    static final int SHOW_PROGRESS_ABOVE = 0x100000;
    private static final int PANEL = 0;
    private static final int TABLES = 1;
    private static final int PROBS = 2;
    private NetworkPanel panel;
    private File file;
    private TableHolder tablePanel;
    private int mode;
    private BMPProgress progress = null;
    private BMPFile result;
    protected static final int IMAGE_BMP = 0;
    protected static final int IMAGE_SVG = 1;
    protected static final int IMAGE_PDF = 2;
    private int imageMode = 0;
    boolean cancelled = false;

    public ImageExporter(NetworkPanel networkPanel, File file) {
        this.panel = networkPanel;
        this.file = file;
        this.mode = 0;
    }

    public ImageExporter(NetworkPanel networkPanel, File file, int n) {
        this.panel = networkPanel;
        this.file = file;
        this.mode = 0;
        this.imageMode = n;
    }

    public ImageExporter(TableHolder tableHolder, File file, int n) {
        this.tablePanel = tableHolder;
        this.file = file;
        this.mode = 1;
        this.imageMode = n;
    }

    public ImageExporter(NetworkPanel networkPanel, File file, boolean bl) {
        this.panel = networkPanel;
        this.file = file;
        this.mode = bl ? 2 : 0;
    }

    public void run() {
        try {
            block1 : switch (this.mode) {
                case 0: {
                    switch (this.imageMode) {
                        case 0: {
                            this.panel2BMP(this.panel, this.file);
                            break block1;
                        }
                        case 2: {
                            this.panel2PDF(this.panel, this.file);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.imageMode) {
                        case 0: {
                            System.out.println("BMP");
                            this.tables2BMP(this.tablePanel, this.file);
                            break block1;
                        }
                        case 2: {
                            System.out.println("PDF");
                            this.tables2PDF(Hugin.mainFrame.getSelectedProjectFrame().networkPanel, this.file);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.imageMode) {
                        case 0: {
                            this.probabilities2BMP(this.panel, this.file);
                            break block1;
                        }
                        case 2: {
                            this.probabilities2PDF(this.panel, this.file);
                        }
                    }
                    break;
                }
                default: {
                    new HuginGUIError(HuginGUIConstants.get("str_invalid_mode_unable_to_print"));
                    break;
                }
            }
        }
        catch (Exception exception) {
            new HuginGUIError(HuginGUIConstants.get("str_unable_to_save_image_ARG0", new String[]{exception.getMessage()}));
        }
        Hugin.mainFrame.repaint();
    }

    protected void dispose() {
        this.cancelled = true;
        this.result.close();
        this.progress.dispose();
    }

    private void panel2BMP(NetworkPanel networkPanel, File file) throws ExceptionHugin {
        String string;
        java.awt.Rectangle rectangle = networkPanel.getBoundingBox();
        rectangle.width = (int)((double)rectangle.width / networkPanel.getScaleFactor());
        rectangle.height = (int)((double)rectangle.height / networkPanel.getScaleFactor());
        BufferedImage bufferedImage = null;
        int n = 1;
        while (bufferedImage == null) {
            try {
                bufferedImage = new BufferedImage(rectangle.width / n + 1, rectangle.height / n + 1, 1);
            }
            catch (Error error) {
                n *= 2;
            }
        }
        if (n != 1 && JOptionPane.showConfirmDialog(Hugin.mainFrame, HuginGUIConstants.get("str_due_to_memory_constraints_hugin_has_split_image_into_ARG0_ARG0_subimages_lb_is_this_ok", new String[]{"" + (n *= 2)}), HuginGUIConstants.get("str_splitting_image"), 0) == 1) {
            return;
        }
        bufferedImage = new BufferedImage(rectangle.width / n + 1, rectangle.height / n + 1, 1);
        if (rectangle.width * rectangle.height > 0x100000) {
            this.progress = new BMPProgress(n * n);
            this.progress.pack();
            HuginGUIUtils.centerComponent(Hugin.mainFrame, (Window)this.progress);
            this.progress.setVisible(true);
        }
        if ((string = file.getAbsolutePath()).indexOf(".") > 0) {
            string = string.substring(0, string.lastIndexOf("."));
        }
        for (int i = 0; i < n && !this.cancelled; ++i) {
            for (int j = 0; j < n && !this.cancelled; ++j) {
                String string2;
                Graphics graphics = bufferedImage.getGraphics();
                if (graphics instanceof Graphics2D) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                }
                graphics.setClip(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
                networkPanel.printComponent(graphics, 1.0, -i * bufferedImage.getWidth() + 1, -j * bufferedImage.getHeight() + 1);
                if (n == 1) {
                    string2 = "";
                } else {
                    string2 = "_" + i + "_" + j;
                    this.progress.setPage(i, j, j + i * n);
                    this.progress.setProgress(0);
                }
                this.result = new BMPFile(string + string2 + ".bmp", bufferedImage, this);
                this.result.saveBitmap();
            }
        }
    }

    protected static void printPanel2BMP(NetworkPanel networkPanel, File file) throws ExceptionHugin {
        Object object;
        java.awt.Rectangle rectangle = networkPanel.getBoundingBox();
        rectangle.width = (int)((double)rectangle.width / networkPanel.getScaleFactor());
        rectangle.height = (int)((double)rectangle.height / networkPanel.getScaleFactor());
        BufferedImage bufferedImage = null;
        int n = 1;
        while (bufferedImage == null) {
            try {
                bufferedImage = new BufferedImage(rectangle.width / n + 1, rectangle.height / n + 1, 1);
            }
            catch (Error error) {
                n *= 2;
            }
        }
        if (n != 1 && JOptionPane.showConfirmDialog(Hugin.mainFrame, HuginGUIConstants.get("str_due_to_memory_constraints_hugin_has_split_image_into_ARG0_ARG0_subimages_lb_is_this_ok", new String[]{"" + (n *= 2)}), HuginGUIConstants.get("str_splitting_image"), 0) == 1) {
            return;
        }
        bufferedImage = new BufferedImage(rectangle.width / n + 1, rectangle.height / n + 1, 1);
        Graphics graphics = bufferedImage.getGraphics();
        if (graphics instanceof Graphics2D) {
            object = (Graphics2D)graphics;
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        graphics.setClip(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        networkPanel.printComponent(graphics, 1.0, 1, 1);
        object = file.getAbsolutePath();
        if (((String)object).indexOf(".") > 0) {
            object = ((String)object).substring(0, ((String)object).lastIndexOf("."));
        }
        BMPFile bMPFile = new BMPFile((String)object + ".bmp", bufferedImage);
        bMPFile.saveBitmap();
    }

    protected static void printNode2BMP(Node node, File file) throws ExceptionHugin {
        Object object;
        java.awt.Rectangle rectangle = null;
        rectangle = node instanceof InstanceNode ? ((InstanceNode)node).getExpandedBounds() : node.getBoundingBox(false);
        BufferedImage bufferedImage = null;
        bufferedImage = new BufferedImage(rectangle.width + 2, rectangle.height + 2, 1);
        Graphics graphics = bufferedImage.getGraphics();
        if (graphics instanceof Graphics2D) {
            object = (Graphics2D)graphics;
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        graphics.setClip(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        if (node instanceof InstanceNode) {
            ((InstanceNode)node).print(graphics, new Point(1 - rectangle.x, 1 - rectangle.y), false);
        } else {
            node.print(graphics, new Point(-rectangle.x, -rectangle.y));
        }
        object = file.getAbsolutePath();
        if (((String)object).indexOf(".") > 0) {
            object = ((String)object).substring(0, ((String)object).lastIndexOf("."));
        }
        BMPFile bMPFile = new BMPFile((String)object + ".bmp", bufferedImage);
        bMPFile.saveBitmap();
    }

    private Image tables2Image(TableHolder tableHolder) throws ExceptionHugin {
        Iterator iterator;
        LinkedList<NodeTableFrame> linkedList = tableHolder.getVisibleTables();
        LinkedList<BufferedImage> linkedList2 = new LinkedList<BufferedImage>();
        boolean bl = false;
        for (NodeTableFrame object22 : linkedList) {
            Object object;
            NodeTable nodeTable = object22.getTable();
            iterator = new NodeTablePrintJob(nodeTable, bmpWidth, 1.0);
            LinkedList<BufferedImage> linkedList3 = new LinkedList<BufferedImage>();
            BufferedImage bufferedImage = new BufferedImage(bmpWidth, titleHeight, 1);
            Graphics graphics = bufferedImage.getGraphics();
            if (graphics instanceof Graphics2D) {
                object = (Graphics2D)graphics;
                ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            this.drawTitle(graphics, nodeTable);
            linkedList3.add(bufferedImage);
            while (((NodeTablePrintJob)((Object)iterator)).hasNext()) {
                bufferedImage = new BufferedImage(bmpWidth, ((NodeTablePrintJob)((Object)iterator)).getHeight() + 10, 1);
                graphics = bufferedImage.getGraphics();
                if (graphics instanceof Graphics2D) {
                    object = (Graphics2D)graphics;
                    ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                }
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
                ((NodeTablePrintJob)((Object)iterator)).printNext(graphics);
                linkedList3.add(bufferedImage);
            }
            bufferedImage = new BufferedImage(bmpWidth + 2 * margin, 20 + (((NodeTablePrintJob)((Object)iterator)).getHeight() + 10) * (linkedList3.size() - 1), 1);
            graphics = bufferedImage.getGraphics();
            if (graphics instanceof Graphics2D) {
                object = (Graphics2D)graphics;
                ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            graphics.translate(margin, margin);
            for (BufferedImage bufferedImage2 : linkedList3) {
                graphics.drawImage(bufferedImage2, 0, 0, new JLabel());
                graphics.translate(0, bufferedImage2.getHeight());
            }
            linkedList2.add(bufferedImage);
        }
        int n = 0;
        for (BufferedImage bufferedImage : linkedList2) {
            n += bufferedImage.getHeight();
        }
        BufferedImage bufferedImage = new BufferedImage(bmpWidth + 2 * margin, n + 2 * margin, 1);
        Graphics graphics = bufferedImage.getGraphics();
        if (graphics instanceof Graphics2D) {
            iterator = (Graphics2D)graphics;
            ((Graphics2D)((Object)iterator)).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)((Object)iterator)).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            ((Graphics2D)((Object)iterator)).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        for (BufferedImage bufferedImage3 : linkedList2) {
            graphics.drawImage(bufferedImage3, 0, 0, new JLabel());
            graphics.translate(0, bufferedImage3.getHeight());
        }
        return bufferedImage;
    }

    private void tables2BMP(TableHolder tableHolder, File file) throws ExceptionHugin {
        Image image = this.tables2Image(tableHolder);
        this.result = new BMPFile(file.getAbsolutePath(), image);
        this.result.saveBitmap();
    }

    private void drawTitle(Graphics graphics, NodeTable nodeTable) throws ExceptionHugin {
        graphics.setFont(new Font(HuginGUIConstants.defaultFont.getName(), 0, 12));
        graphics.setColor(Color.black);
        String string = nodeTable.getNode().getLabel();
        string = string == null || string.length() == 0 ? nodeTable.getNode().getName() : string + "(" + nodeTable.getNode().getName() + ")";
        graphics.drawString(string, 0, 15);
        graphics.translate(0, 20);
    }

    private void probabilities2BMP(NetworkPanel networkPanel, File file) throws ExceptionHugin {
        Iterator iterator;
        Object object22;
        NetworkPanel.ListOfSelectedNodes listOfSelectedNodes = networkPanel.selectedNodes;
        ArrayList arrayList = new ArrayList();
        int n = 2 * margin;
        for (Object object22 : listOfSelectedNodes) {
            iterator = new BeliefMonitor((Node)object22, networkPanel.projectFrame);
            ((Component)((Object)iterator)).setSize(((JComponent)((Object)iterator)).getPreferredSize());
            n += ((JComponent)((Object)iterator)).getHeight() + margin;
            if (((Node)object22).monitor != null && ((Node)object22).monitor.isVisible()) {
                ((BeliefMonitor)((Object)iterator)).setDisplayMode(((Node)object22).monitor.getDisplayMode());
            }
            arrayList.add(iterator);
        }
        BufferedImage bufferedImage = new BufferedImage(bmpWidth, n, 1);
        object22 = bufferedImage.getGraphics();
        if (object22 instanceof Graphics2D) {
            iterator = (Graphics2D)object22;
            ((Graphics2D)((Object)iterator)).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)((Object)iterator)).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            ((Graphics2D)((Object)iterator)).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        ((Graphics)object22).setColor(Color.white);
        ((Graphics)object22).fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        ((Graphics)object22).translate(margin, margin);
        for (BeliefMonitor beliefMonitor : arrayList) {
            beliefMonitor.print((Graphics)object22);
            ((Graphics)object22).translate(0, beliefMonitor.getHeight() + margin);
        }
        this.result = new BMPFile(file.getAbsolutePath(), bufferedImage);
        this.result.saveBitmap();
    }

    private void panel2PDF(NetworkPanel networkPanel, File file) throws Exception {
        java.awt.Rectangle rectangle = networkPanel.getBoundingBox();
        rectangle.width = (int)((double)rectangle.width / networkPanel.getScaleFactor());
        rectangle.height = (int)((double)rectangle.height / networkPanel.getScaleFactor());
        Document document = new Document(new Rectangle(rectangle.width, rectangle.height));
        PdfWriter pdfWriter = null;
        pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(file));
        document.open();
        PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
        PdfTemplate pdfTemplate = pdfContentByte.createTemplate(rectangle.width, rectangle.height);
        Graphics2D graphics2D = pdfTemplate.createGraphics(rectangle.width, rectangle.height, new DefaultFontMapper());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setClip(0, 0, rectangle.width, rectangle.height);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
        networkPanel.printComponent(graphics2D, 1.0, 1, 1);
        graphics2D.dispose();
        pdfContentByte.addTemplate(pdfTemplate, 0.0f, 0.0f);
        document.close();
    }

    private void tables2PDF(NetworkPanel networkPanel, File file) throws Exception {
        try {
            PageFormat pageFormat = new PageFormat();
            NodeTablePage nodeTablePage = new NodeTablePage(networkPanel, 0, false, false, 1.0);
            java.awt.Rectangle rectangle = new java.awt.Rectangle((int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
            Document document = new Document(new Rectangle(rectangle.width, rectangle.height));
            PdfWriter pdfWriter = null;
            pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(file));
            document.open();
            int n = 0;
            int n2 = 0;
            while (n == 0) {
                if (n2 > 0) {
                    document.newPage();
                }
                PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
                PdfTemplate pdfTemplate = pdfContentByte.createTemplate(rectangle.width, rectangle.height);
                Graphics2D graphics2D = pdfTemplate.createGraphics(rectangle.width, rectangle.height, new DefaultFontMapper());
                n = nodeTablePage.print(graphics2D, pageFormat, n2);
                graphics2D.dispose();
                pdfContentByte.addTemplate(pdfTemplate, 0.0f, 0.0f);
                ++n2;
            }
            document.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    private void probabilities2PDF(NetworkPanel networkPanel, File file) throws ExceptionHugin {
    }

    protected void setProgress(int n) {
        if (this.progress != null) {
            this.progress.setProgress(n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Graphics2DOpBuffer
    extends Graphics2D {
        private Vector<Class> _classes;
        private Vector<Object> _objects;
        private java.awt.Rectangle _clip = null;
        private JLabel _jlabel = new JLabel();
        private Font _font = this._jlabel.getFont();
        private Color _color = Color.BLACK;
        private int _width;
        private int _height;
        private Vector<Object[]> _sig = new Vector();
        private Vector<Object[]> _par = new Vector();

        public Graphics2DOpBuffer(int n, int n2) {
            this._classes = new Vector();
            this._objects = new Vector();
            this._clip = new java.awt.Rectangle(0, 0, n, n2);
            this._width = n;
            this._height = n2;
        }

        private void addOp() {
            Class[] classArray = new Class[this._classes.size()];
            for (int i = 0; i < classArray.length; ++i) {
                classArray[i] = this._classes.get(i);
            }
            this._classes.clear();
            Object[] objectArray = new Object[this._objects.size()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this._objects.get(i);
            }
            this._objects.clear();
            Throwable throwable = new Throwable();
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            StackTraceElement stackTraceElement = stackTraceElementArray[1];
            Object[] objectArray2 = new Object[]{stackTraceElement.getMethodName(), classArray};
            this._sig.add(objectArray2);
            this._par.add(objectArray);
            System.out.print((String)objectArray2[0] + " (");
            for (Class clazz : classArray) {
                System.out.print(clazz.getName() + ", ");
            }
            System.out.println(")");
        }

        private void pushPar(int n) {
            Integer n2 = new Integer(n);
            this._objects.add(n2);
            this._classes.add(Integer.TYPE);
        }

        private void pushPar(float f) {
            Float f2 = new Float(f);
            this._objects.add(f2);
            this._classes.add(Float.TYPE);
        }

        private void pushPar(double d) {
            Double d2 = new Double(d);
            this._objects.add(d2);
            this._classes.add(Double.TYPE);
        }

        private void pushPar(Object object) {
            this._objects.add(object);
            this._classes.add(object.getClass());
        }

        private void pushPar(Object object, Class clazz) {
            this._objects.add(object);
            this._classes.add(clazz);
        }

        private void pushPar(boolean bl) {
            Boolean bl2 = new Boolean(bl);
            this._objects.add(bl2);
            this._classes.add(Boolean.TYPE);
        }

        public void paintGraphics(Graphics2D graphics2D) {
            System.out.println("\n\n paintGraphics:");
            int n = this._sig.size();
            for (int i = 0; i < n; ++i) {
                Object[] objectArray = this._sig.get(i);
                Object[] objectArray2 = this._par.get(i);
                String string = (String)objectArray[0];
                System.out.println(string);
                Class[] classArray = (Class[])objectArray[1];
                try {
                    Method method = Graphics2D.class.getMethod(string, classArray);
                    method.invoke((Object)graphics2D, objectArray2);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        private void dumpTrace() {
            Throwable throwable = new Throwable();
            throwable.printStackTrace();
        }

        @Override
        public Graphics create() {
            Graphics2DOpBuffer graphics2DOpBuffer = new Graphics2DOpBuffer(this._width, this._height);
            graphics2DOpBuffer._objects.addAll(this._objects);
            graphics2DOpBuffer._classes.addAll(this._classes);
            graphics2DOpBuffer._clip = this._clip;
            graphics2DOpBuffer._font = this._font;
            graphics2DOpBuffer._color = this._color;
            this.dumpTrace();
            return graphics2DOpBuffer;
        }

        @Override
        public Graphics create(int n, int n2, int n3, int n4) {
            Graphics2DOpBuffer graphics2DOpBuffer = (Graphics2DOpBuffer)this.create();
            graphics2DOpBuffer.translate(n, n2);
            graphics2DOpBuffer.setClip(0, 0, n3, n4);
            this.dumpTrace();
            return graphics2DOpBuffer;
        }

        @Override
        public Shape getClip() {
            this.dumpTrace();
            return null;
        }

        @Override
        public java.awt.Rectangle getClipBounds() {
            this.dumpTrace();
            return this._clip;
        }

        @Override
        public java.awt.Rectangle getClipBounds(java.awt.Rectangle rectangle) {
            this.dumpTrace();
            rectangle.x = this._clip.x;
            rectangle.y = this._clip.y;
            rectangle.width = this._clip.width;
            rectangle.height = this._clip.height;
            return rectangle;
        }

        @Override
        public Color getColor() {
            this.dumpTrace();
            return this._color;
        }

        @Override
        public Font getFont() {
            this.dumpTrace();
            return this._font;
        }

        @Override
        public FontMetrics getFontMetrics() {
            this.dumpTrace();
            return this._jlabel.getFontMetrics(this._font);
        }

        @Override
        public FontMetrics getFontMetrics(Font font) {
            this.dumpTrace();
            return this._jlabel.getFontMetrics(font);
        }

        @Override
        public boolean hitClip(int n, int n2, int n3, int n4) {
            this.dumpTrace();
            return false;
        }

        @Override
        public void clearRect(int n, int n2, int n3, int n4) {
            this.pushPar(n);
            this.pushPar(n2);
            this.pushPar(n3);
            this.pushPar(n4);
            this.addOp();
        }

        @Override
        public void clipRect(int n, int n2, int n3, int n4) {
            this.pushPar(n);
            this.pushPar(n2);
            this.pushPar(n3);
            this.pushPar(n4);
            this.addOp();
        }

        @Override
        public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
            this.pushPar(n);
            this.pushPar(n2);
            this.pushPar(n3);
            this.pushPar(n4);
            this.pushPar(n5);
            this.pushPar(n6);
            this.addOp();
        }

        @Override
        public void dispose() {
            this.dumpTrace();
        }

        @Override
        public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
            this.pushPar(n);
            this.pushPar(n2);
            this.pushPar(n3);
            this.pushPar(n4);
            this.pushPar(bl);
            this.addOp();
        }

        @Override
        public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
            this.pushPar(n);
            this.pushPar(n2);
            this.pushPar(n3);
            this.pushPar(n4);
            this.pushPar(n5);
            this.pushPar(n6);
            this.addOp();
        }

        @Override
        public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
            this.pushPar(byArray);
            this.pushPar(n);
            this.pushPar(n2);
            this.pushPar(n3);
            this.pushPar(n4);
            this.addOp();
        }

        @Override
        public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
            this.pushPar(cArray);
            this.pushPar(n);
            this.pushPar(n2);
            this.pushPar(n3);
            this.pushPar(n4);
            this.addOp();
        }

        @Override
        public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
            this.pushPar(image);
            this.pushPar(n);
            this.pushPar(n2);
            this.pushPar(color);
            this.pushPar(imageObserver);
            this.addOp();
            return true;
        }

        @Override
        public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
            this.pushPar(image);
            this.pushPar(n);
            this.pushPar(n2);
            this.pushPar(imageObserver);
            this.addOp();
            return true;
        }

        @Override
        public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
            this.pushPar(image);
            this.pushPar(n);
            this.pushPar(n2);
            this.pushPar(n3);
            this.pushPar(n4);
            this.pushPar(color);
            this.pushPar(imageObserver);
            this.addOp();
            return true;
        }

        @Override
        public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
            this.pushPar(image);
            this.pushPar(n);
            this.pushPar(n2);
            this.pushPar(n3);
            this.pushPar(n4);
            this.pushPar(imageObserver);
            this.addOp();
            return true;
        }

        @Override
        public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
            this.pushPar(image);
            this.pushPar(n);
            this.pushPar(n2);
            this.pushPar(n3);
            this.pushPar(n4);
            this.pushPar(n5);
            this.pushPar(n6);
            this.pushPar(n7);
            this.pushPar(n8);
            this.pushPar(color);
            this.pushPar(imageObserver);
            this.addOp();
            return true;
        }

        @Override
        public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
            this.pushPar(image);
            this.pushPar(n);
            this.pushPar(n2);
            this.pushPar(n3);
            this.pushPar(n4);
            this.pushPar(n5);
            this.pushPar(n6);
            this.pushPar(n7);
            this.pushPar(n8);
            this.pushPar(imageObserver);
            this.addOp();
            return true;
        }

        @Override
        public void drawLine(int n, int n2, int n3, int n4) {
            this.pushPar(n);
            this.pushPar(n2);
            this.pushPar(n3);
            this.pushPar(n4);
            this.addOp();
        }

        @Override
        public void drawOval(int n, int n2, int n3, int n4) {
            this.pushPar(n);
            this.pushPar(n2);
            this.pushPar(n3);
            this.pushPar(n4);
            this.addOp();
        }

        @Override
        public void drawPolygon(int[] nArray, int[] nArray2, int n) {
            this.pushPar(nArray);
            this.pushPar(nArray2);
            this.pushPar(n);
            this.addOp();
        }

        @Override
        public void drawPolygon(Polygon polygon) {
            this.pushPar(polygon);
        }

        @Override
        public void drawPolyline(int[] nArray, int[] nArray2, int n) {
            this.pushPar(nArray);
            this.pushPar(nArray2);
            this.pushPar(n);
            this.addOp();
        }

        @Override
        public void drawRect(int n, int n2, int n3, int n4) {
            this.pushPar(n);
            this.pushPar(n2);
            this.pushPar(n3);
            this.pushPar(n4);
            this.addOp();
        }

        @Override
        public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
            this.pushPar(n);
            this.pushPar(n2);
            this.pushPar(n3);
            this.pushPar(n4);
            this.pushPar(n5);
            this.pushPar(n6);
            this.addOp();
        }

        @Override
        public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
            this.pushPar(attributedCharacterIterator);
            this.pushPar(n);
            this.pushPar(n2);
            this.addOp();
        }

        @Override
        public void drawString(String string, int n, int n2) {
            this.pushPar(string);
            this.pushPar(n);
            this.pushPar(n2);
            this.addOp();
        }

        @Override
        public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
            this.pushPar(n);
            this.pushPar(n2);
            this.pushPar(n3);
            this.pushPar(n4);
            this.pushPar(bl);
            this.addOp();
        }

        @Override
        public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
            this.pushPar(n);
            this.pushPar(n2);
            this.pushPar(n3);
            this.pushPar(n4);
            this.pushPar(n5);
            this.pushPar(n6);
            this.addOp();
        }

        @Override
        public void fillOval(int n, int n2, int n3, int n4) {
            this.pushPar(n);
            this.pushPar(n2);
            this.pushPar(n3);
            this.pushPar(n4);
            this.addOp();
        }

        @Override
        public void fillPolygon(int[] nArray, int[] nArray2, int n) {
            this.pushPar(nArray);
            this.pushPar(nArray2);
            this.pushPar(n);
            this.addOp();
        }

        @Override
        public void fillPolygon(Polygon polygon) {
            this.pushPar(polygon);
            this.addOp();
        }

        @Override
        public void fillRect(int n, int n2, int n3, int n4) {
            this.pushPar(n);
            this.pushPar(n2);
            this.pushPar(n3);
            this.pushPar(n4);
            this.addOp();
        }

        @Override
        public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
            this.pushPar(n);
            this.pushPar(n2);
            this.pushPar(n3);
            this.pushPar(n4);
            this.pushPar(n5);
            this.pushPar(n6);
            this.addOp();
        }

        @Override
        public void setClip(int n, int n2, int n3, int n4) {
            this.pushPar(n);
            this.pushPar(n2);
            this.pushPar(n3);
            this.pushPar(n4);
            this.addOp();
            this._clip = new java.awt.Rectangle(n, n2, n3, n4);
        }

        @Override
        public void setClip(Shape shape) {
            this.pushPar(shape);
            this.addOp();
            if (shape == null) {
                this._clip = null;
            }
        }

        @Override
        public void setColor(Color color) {
            this.pushPar(color);
            this.addOp();
            this._color = color;
        }

        @Override
        public void setFont(Font font) {
            this.pushPar(font);
            this.addOp();
            this._font = font;
        }

        @Override
        public void setPaintMode() {
            this.addOp();
        }

        @Override
        public void setXORMode(Color color) {
            this.pushPar(color);
            this.addOp();
        }

        @Override
        public String toString() {
            return null;
        }

        @Override
        public void translate(int n, int n2) {
            this.pushPar(n);
            this.pushPar(n2);
            this.addOp();
        }

        @Override
        public Color getBackground() {
            this.dumpTrace();
            return null;
        }

        @Override
        public Composite getComposite() {
            this.dumpTrace();
            return null;
        }

        @Override
        public GraphicsConfiguration getDeviceConfiguration() {
            this.dumpTrace();
            return null;
        }

        @Override
        public FontRenderContext getFontRenderContext() {
            this.dumpTrace();
            return null;
        }

        @Override
        public Paint getPaint() {
            this.dumpTrace();
            return null;
        }

        @Override
        public Object getRenderingHint(RenderingHints.Key key) {
            this.dumpTrace();
            return null;
        }

        @Override
        public RenderingHints getRenderingHints() {
            this.dumpTrace();
            return null;
        }

        @Override
        public Stroke getStroke() {
            this.dumpTrace();
            return null;
        }

        @Override
        public AffineTransform getTransform() {
            this.dumpTrace();
            return null;
        }

        @Override
        public boolean hit(java.awt.Rectangle rectangle, Shape shape, boolean bl) {
            this.dumpTrace();
            return false;
        }

        @Override
        public void addRenderingHints(Map<?, ?> map) {
            this.pushPar(map);
            this.addOp();
        }

        @Override
        public void clip(Shape shape) {
            this.pushPar(shape);
            this.addOp();
        }

        @Override
        public void draw(Shape shape) {
            this.pushPar(shape);
            this.addOp();
        }

        @Override
        public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
            this.pushPar(glyphVector);
            this.pushPar(f);
            this.pushPar(f2);
            this.addOp();
        }

        @Override
        public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
            this.pushPar(bufferedImage);
            this.pushPar(bufferedImageOp);
            this.pushPar(n);
            this.pushPar(n2);
            this.addOp();
        }

        @Override
        public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
            this.pushPar(image);
            this.pushPar(affineTransform);
            this.pushPar(imageObserver);
            this.addOp();
            return true;
        }

        @Override
        public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
            this.pushPar(renderableImage);
            this.pushPar(affineTransform);
            this.addOp();
        }

        @Override
        public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
            this.pushPar(renderedImage);
            this.pushPar(affineTransform);
            this.addOp();
        }

        @Override
        public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
            this.pushPar(attributedCharacterIterator);
            this.pushPar(f);
            this.pushPar(f2);
            this.addOp();
        }

        @Override
        public void drawString(String string, float f, float f2) {
            this.pushPar(string);
            this.pushPar(f);
            this.pushPar(f2);
            this.addOp();
        }

        @Override
        public void fill(Shape shape) {
            this.pushPar(shape);
            this.addOp();
        }

        @Override
        public void rotate(double d) {
            this.pushPar(d);
            this.addOp();
        }

        @Override
        public void rotate(double d, double d2, double d3) {
            this.pushPar(d);
            this.pushPar(d2);
            this.pushPar(d3);
            this.addOp();
        }

        @Override
        public void scale(double d, double d2) {
            this.pushPar(d);
            this.pushPar(d2);
            this.addOp();
        }

        @Override
        public void setBackground(Color color) {
            this.pushPar(color);
            this.addOp();
        }

        @Override
        public void setComposite(Composite composite) {
            this.pushPar(composite);
            this.addOp();
        }

        @Override
        public void setPaint(Paint paint) {
            this.pushPar(paint);
            this.addOp();
        }

        @Override
        public void setRenderingHint(RenderingHints.Key key, Object object) {
            this.pushPar(key, RenderingHints.Key.class);
            this.pushPar(object, Object.class);
            this.addOp();
        }

        @Override
        public void setRenderingHints(Map<?, ?> map) {
            this.pushPar(map);
            this.addOp();
        }

        @Override
        public void setStroke(Stroke stroke) {
            this.pushPar(stroke);
            this.addOp();
        }

        @Override
        public void setTransform(AffineTransform affineTransform) {
            this.pushPar(affineTransform);
            this.addOp();
        }

        @Override
        public void shear(double d, double d2) {
            this.pushPar(d);
            this.pushPar(d2);
            this.addOp();
        }

        @Override
        public void transform(AffineTransform affineTransform) {
            this.pushPar(affineTransform);
            this.addOp();
        }

        @Override
        public void translate(double d, double d2) {
            this.pushPar(d);
            this.pushPar(d2);
            this.addOp();
        }
    }

    private static class VectorImage
    extends Image {
        private int _width;
        private int _height;
        private Graphics2DOpBuffer _g;

        public VectorImage(int n, int n2) {
            this._width = n;
            this._height = n2;
            this._g = new Graphics2DOpBuffer(this._width, this._height);
        }

        private void dumpTrace() {
            Throwable throwable = new Throwable();
            throwable.printStackTrace();
        }

        public void paintGraphics(Graphics2D graphics2D) {
            this._g.paintGraphics(graphics2D);
        }

        public void flush() {
            this.dumpTrace();
        }

        public float getAccelerationPriority() {
            this.dumpTrace();
            return 0.0f;
        }

        public ImageCapabilities getCapabilities(GraphicsConfiguration graphicsConfiguration) {
            this.dumpTrace();
            return null;
        }

        public Graphics getGraphics() {
            return this._g;
        }

        public int getHeight(ImageObserver imageObserver) {
            this.dumpTrace();
            return this._height;
        }

        public int getHeight() {
            return this._height;
        }

        public Object getProperty(String string, ImageObserver imageObserver) {
            this.dumpTrace();
            return null;
        }

        public Image getScaledInstance(int n, int n2, int n3) {
            this.dumpTrace();
            return null;
        }

        public ImageProducer getSource() {
            this.dumpTrace();
            return null;
        }

        public int getWidth(ImageObserver imageObserver) {
            this.dumpTrace();
            return this._width;
        }

        public int getWidth() {
            return this._width;
        }

        public void setAccelerationPriority(float f) {
            this.dumpTrace();
        }
    }

    private class BMPProgress
    extends JDialog {
        private JProgressBar progress;
        private JProgressBar totalProgress;
        private JLabel label;
        private int totalPages;
        private int currentPage;

        public BMPProgress(int n) {
            this.totalPages = n;
            this.currentPage = 0;
            this.setContentPane(this.createContent());
        }

        private JPanel createContent() {
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new VerticalFlowLayout());
            this.label = new JLabel(HuginGUIConstants.get("str_printing"));
            this.progress = new JProgressBar(0, 100);
            this.progress.setValue(0);
            this.progress.setStringPainted(true);
            this.totalProgress = new JProgressBar(0, 100);
            this.totalProgress.setValue(0);
            this.totalProgress.setStringPainted(true);
            jPanel2.add(this.label);
            jPanel2.add(this.progress);
            jPanel2.add(this.totalProgress);
            jPanel.add(jPanel2);
            JPanel jPanel3 = new JPanel(new FlowLayout(1));
            JButton jButton = new JButton(HuginGUIConstants.get("CANCEL_BUTTON_LABEL"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ImageExporter.this.dispose();
                }
            });
            jPanel3.add(jButton);
            jPanel.add((Component)jPanel3, "South");
            return jPanel;
        }

        protected void setPage(int n, int n2, int n3) {
            this.label.setText(HuginGUIConstants.get("str_printing") + " " + n + ", " + n2);
            this.currentPage = n3;
        }

        protected void setProgress(int n) {
            this.progress.setValue(n);
            this.totalProgress.setValue(100 * this.currentPage / this.totalPages + n / this.totalPages);
        }
    }
}

