/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.WizardNetworkPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ImportSettingsDialog
extends JDialog {
    NetworkModel to;
    NetworkModel from;
    boolean oldVersion;
    boolean cancelled = false;
    NetworkPanel panel;
    JCheckBox groups;
    JCheckBox size;
    JCheckBox description;
    JCheckBox position;
    JCheckBox labels;
    JCheckBox constraints = null;
    JButton ok;
    JButton cancel;

    public ImportSettingsDialog(NetworkModel networkModel, NetworkModel networkModel2, NetworkPanel networkPanel) {
        super(Hugin.mainFrame, HuginGUIConstants.get("IMPORT_SETTINGS"), true);
        this.to = networkModel2;
        this.from = networkModel;
        this.panel = networkPanel;
        this.setContentPane(this.createContent());
    }

    public boolean importSettings(boolean bl) {
        this.oldVersion = bl;
        this.setVisible(true);
        return !this.cancelled;
    }

    private JPanel createContent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        JLabel jLabel = new JLabel(HuginGUIConstants.get("IMPORT_SETTINGS_Label"));
        jLabel.setFont(new JTextField().getFont());
        jPanel2.add((Component)jLabel, "North");
        JPanel jPanel3 = new JPanel(new GridLayout(6, 1));
        this.position = new JCheckBox(HuginGUIConstants.get("IMPORT_SETTINGS_Positions"));
        this.position.setSelected(true);
        jPanel3.add(this.position);
        this.size = new JCheckBox(HuginGUIConstants.get("IMPORT_SETTINGS_Sizes"));
        this.size.setSelected(true);
        jPanel3.add(this.size);
        this.labels = new JCheckBox(HuginGUIConstants.get("IMPORT_SETTINGS_Labels"));
        this.labels.setSelected(true);
        jPanel3.add(this.labels);
        this.groups = new JCheckBox(HuginGUIConstants.get("IMPORT_SETTINGS_Groups"));
        this.groups.setSelected(true);
        jPanel3.add(this.groups);
        this.description = new JCheckBox(HuginGUIConstants.get("IMPORT_SETTINGS_Descriptions"));
        this.description.setSelected(true);
        jPanel3.add(this.description);
        try {
            String string = this.from.getAttribute("HR_Has_Constraints");
            if (string != null && string.equalsIgnoreCase("yes") && this.panel instanceof WizardNetworkPanel) {
                this.constraints = new JCheckBox(HuginGUIConstants.get("IMPORT_SETTINGS_Constraints"));
                this.constraints.setSelected(true);
                jPanel3.add(this.constraints);
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        jPanel2.add(jPanel3);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.getButtonPanel(), "South");
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.ok = new JButton(HuginGUIConstants.get("OK_button"));
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    System.out.println("Importing info .....!");
                    boolean bl = ImportSettingsDialog.this.constraints != null && ImportSettingsDialog.this.constraints.isSelected();
                    double d = ImportSettingsDialog.this.panel.getScaleFactor();
                    ImportSettingsDialog.this.panel.setScaleFactor(1.0);
                    HuginGUIUtils.importSettings(ImportSettingsDialog.this.from, ImportSettingsDialog.this.to, ImportSettingsDialog.this.position.isSelected(), ImportSettingsDialog.this.description.isSelected(), ImportSettingsDialog.this.labels.isSelected(), ImportSettingsDialog.this.size.isSelected(), ImportSettingsDialog.this.groups.isSelected(), bl, ImportSettingsDialog.this.oldVersion);
                    ImportSettingsDialog.this.panel.settingsImported();
                    ImportSettingsDialog.this.panel.setScaleFactor(d);
                    ImportSettingsDialog.this.dispose();
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        this.cancel = new JButton(HuginGUIConstants.get("cancel_button"));
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImportSettingsDialog.this.dispose();
                ImportSettingsDialog.this.cancelled = true;
            }
        });
        jPanel.add(this.ok);
        jPanel.add(this.cancel);
        return jPanel;
    }
}

