/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.LabelledDCNode;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.PastingTextField;
import COM.hugin.HGUI.SmallFontLabel;
import COM.hugin.HGUI.TitledPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class InsertLikelihoodPanel
extends JDialog {
    DiscreteNode node;
    PastingTextField enterValue;
    JButton ok;
    JButton cancel;
    JScrollPane scrollPaint;
    LikelihoodPainter painter;
    double[] oldFindings;
    static final int barWidth = 150;
    static final int barHeight = 15;
    static final int margin = 8;

    public InsertLikelihoodPanel(DiscreteNode discreteNode) {
        super(Hugin.mainFrame, HuginGUIConstants.get("MISCELLANEOUS_Insert_likelihood"), true);
        this.node = discreteNode;
        try {
            this.oldFindings = new double[discreteNode.getNumberOfStates()];
            for (int i = 0; i < this.oldFindings.length; ++i) {
                this.oldFindings[i] = discreteNode.getEnteredFinding(i);
            }
            this.createPanel();
            this.setResizable(true);
            this.setSize(400, 300);
            this.setLocation(200, 200);
            this.setVisible(true);
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    private void createPanel() {
        JLabel jLabel;
        Object object;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        TitledPanel titledPanel = new TitledPanel(HuginGUIConstants.get("INSERTLIKELIHOOD_node"));
        titledPanel.setLayout(new BoxLayout(titledPanel, 1));
        try {
            object = this.node.getLabel();
            if (((String)object).length() == 0) {
                object = this.node.getName();
            }
            jLabel = new JLabel("Name : " + (String)object);
        }
        catch (Exception exception) {
            jLabel = new JLabel("-");
        }
        jLabel.setAlignmentX(0.0f);
        titledPanel.add(jLabel);
        titledPanel.add(Box.createHorizontalGlue());
        TitledPanel titledPanel2 = new TitledPanel(HuginGUIConstants.get("INSERTLIKELIHOOD_likelihood"));
        titledPanel2.setLayout(new BorderLayout());
        this.scrollPaint = new JScrollPane();
        this.painter = new LikelihoodPainter(this.node);
        this.scrollPaint.setViewportView(this.painter);
        object = new LikelihoodListener(this.node);
        this.scrollPaint.addMouseListener((MouseListener)object);
        this.scrollPaint.addMouseMotionListener((MouseMotionListener)object);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        JButton jButton = new JButton(HuginGUIConstants.get("INSERTLIKELIHOOD_all") + " 1");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = InsertLikelihoodPanel.this.node.getNumberOfStates();
                    for (int i = 0; i < n; ++i) {
                        InsertLikelihoodPanel.this.node.enterFinding(i, 1.0);
                        InsertLikelihoodPanel.this.enterValue.setText("1.0");
                        InsertLikelihoodPanel.this.repaint();
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
                InsertLikelihoodPanel.this.updateButtonState();
            }
        });
        JButton jButton2 = new JButton(HuginGUIConstants.get("INSERTLIKELIHOOD_all") + " 0");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = InsertLikelihoodPanel.this.node.getNumberOfStates();
                    for (int i = 0; i < n; ++i) {
                        InsertLikelihoodPanel.this.node.enterFinding(i, 0.0);
                        InsertLikelihoodPanel.this.enterValue.setText("0");
                        InsertLikelihoodPanel.this.repaint();
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
                InsertLikelihoodPanel.this.updateButtonState();
            }
        });
        this.enterValue = new PastingTextField(10);
        this.enterValue.setEnabled(this.painter.selected != -1);
        this.enterValue.addCaretListener(new ValueListener(this.node, this.enterValue, this.painter));
        jPanel2.add(this.enterValue);
        jPanel2.add(jButton2);
        jPanel2.add(jButton);
        titledPanel2.add((Component)this.scrollPaint, "Center");
        titledPanel2.add((Component)jPanel2, "South");
        titledPanel.setAlignmentX(0.0f);
        titledPanel2.setAlignmentX(0.0f);
        jPanel.add(titledPanel);
        jPanel.add(titledPanel2);
        JPanel jPanel3 = new JPanel(new GridLayout(3, 1));
        this.ok = new JButton(HuginGUIConstants.get("OK_button"));
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InsertLikelihoodPanel.this.dispose();
            }
        });
        this.cancel = new JButton(HuginGUIConstants.get("cancel_button"));
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    for (int i = 0; i < InsertLikelihoodPanel.this.oldFindings.length; ++i) {
                        InsertLikelihoodPanel.this.node.enterFinding(i, InsertLikelihoodPanel.this.oldFindings[i]);
                    }
                    InsertLikelihoodPanel.this.dispose();
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        JLabel jLabel2 = new JLabel(new ImageIcon(ClassLoader.getSystemResource("icons/nodeicon.gif")));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jLabel2, "South");
        jPanel3.add(this.ok);
        jPanel3.add(this.cancel);
        jPanel3.add(jPanel4);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel3, "North");
        jPanel5.setAlignmentY(0.0f);
        jPanel.setAlignmentY(0.0f);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 0));
        this.getContentPane().add(jPanel);
        this.getContentPane().add(jPanel5);
    }

    void updateButtonState() {
        boolean bl = true;
        try {
            int n = this.node.getNumberOfStates();
            for (int i = 0; i < n; ++i) {
                bl = bl && this.node.getEnteredFinding(i) == 0.0;
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        this.ok.setEnabled(!bl);
    }

    public static void main(String[] stringArray) {
        try {
            Domain domain = new Domain();
            LabelledDCNode labelledDCNode = new LabelledDCNode(domain);
            labelledDCNode.setNumberOfStates(7);
            labelledDCNode.setStateLabel(0, "state 1");
            HuginGUIUtils.configureDomain(domain);
            domain.compile();
            new InsertLikelihoodPanel(labelledDCNode);
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    private class ValueListener
    implements CaretListener {
        DiscreteNode node;
        PastingTextField field;
        LikelihoodPainter painter;

        public ValueListener(DiscreteNode discreteNode, PastingTextField pastingTextField, LikelihoodPainter likelihoodPainter) {
            this.node = discreteNode;
            this.field = pastingTextField;
            this.painter = likelihoodPainter;
        }

        public void caretUpdate(CaretEvent caretEvent) {
            if (this.painter.selected != -1) {
                try {
                    double d = Double.parseDouble(this.field.getText());
                    if (d > 1.0 || d < 0.0) {
                        return;
                    }
                    this.node.enterFinding(this.painter.selected, d);
                    this.painter.repaint();
                    InsertLikelihoodPanel.this.updateButtonState();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class LikelihoodListener
    extends MouseAdapter
    implements MouseMotionListener {
        DiscreteNode node;
        JViewport view;

        public LikelihoodListener(DiscreteNode discreteNode) {
            this.node = discreteNode;
            this.view = InsertLikelihoodPanel.this.scrollPaint.getViewport();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.updateState(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.updateState(mouseEvent);
        }

        private void updateState(MouseEvent mouseEvent) {
            int n = this.getState(mouseEvent.getX(), mouseEvent.getY());
            int n2 = mouseEvent.getX();
            if (n > 0) {
                InsertLikelihoodPanel.this.painter.setSelected(n - 1);
                n2 = (int)((double)n2 + this.view.getViewPosition().getX());
                double d = (double)(n2 - 8) / 150.0;
                d = (double)((int)(d * 100.0)) / 100.0;
                if (d < 0.0) {
                    d = 0.0;
                }
                if (d > 1.0) {
                    d = 1.0;
                }
                try {
                    this.node.enterFinding(n - 1, d);
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
                InsertLikelihoodPanel.this.enterValue.setText("" + d);
            } else if (n < 0) {
                InsertLikelihoodPanel.this.painter.setSelected(-n - 1);
                try {
                    InsertLikelihoodPanel.this.enterValue.setText("" + this.node.getEnteredFinding(-n - 1));
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
            InsertLikelihoodPanel.this.updateButtonState();
            InsertLikelihoodPanel.this.repaint();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        private int getState(int n, int n2) {
            n2 = (int)((double)n2 + this.view.getViewPosition().getY());
            n = (int)((double)n + this.view.getViewPosition().getX());
            if ((n2 - 8) % 19 > 15) {
                return 0;
            }
            int n3 = (n2 - 8) / 19 + 1;
            try {
                if (n3 > this.node.getNumberOfStates()) {
                    n3 = 0;
                }
            }
            catch (Exception exception) {
                n3 = 0;
            }
            if (n > 173) {
                n3 = -n3;
            }
            return n3;
        }
    }

    private class LikelihoodPainter
    extends JPanel {
        DiscreteNode node;
        int selected = -1;
        JViewport view;

        public LikelihoodPainter(DiscreteNode discreteNode) {
            this.node = discreteNode;
            this.setBorder(BorderFactory.createBevelBorder(1));
            this.setBackground(Color.white);
            this.view = InsertLikelihoodPanel.this.scrollPaint.getViewport();
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            try {
                int n = this.node.getNumberOfStates();
                for (int i = 0; i < n; ++i) {
                    double d = this.node.getEnteredFinding(i);
                    graphics.setColor(Color.blue);
                    graphics.fillRect(8, i * 19 + 8, (int)(150.0 * d), 15);
                    String string = "" + d;
                    if (string.length() > 6) {
                        string = string.substring(0, 6);
                    }
                    graphics.setFont(new SmallFontLabel().getFont());
                    Rectangle2D.Float float_ = (Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(string, graphics);
                    graphics.setColor(Color.black);
                    graphics.drawString(string, 150 + (70 - (int)float_.getWidth()), (i + 1) * 19 + 4);
                    String string2 = HuginGUIUtils.getNodeStateLabel(this.node, i);
                    graphics.drawString(string2, 225, (i + 1) * 19 + 4);
                }
                if (this.selected >= 0) {
                    graphics.drawRect(1, this.selected * 19 + 8 - 2, (int)this.view.getViewSize().getWidth() - 1, 18);
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }

        public Dimension getPreferredSize() {
            int n = 220;
            Dimension dimension = new Dimension(n + 16 + 50, 100);
            try {
                Graphics graphics = this.getGraphics();
                int n2 = this.node.getNumberOfStates();
                for (int i = 0; i < n2; ++i) {
                    String string = HuginGUIUtils.getNodeStateLabel(this.node, i);
                    Rectangle2D.Float float_ = (Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(string, graphics);
                    if (220 + (int)float_.getWidth() <= n) continue;
                    n = 220 + (int)float_.getWidth();
                }
                dimension = new Dimension(n + 16, 19 * n2 + 16);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return dimension;
        }

        public void setSelected(int n) {
            this.selected = n;
            InsertLikelihoodPanel.this.enterValue.setEnabled(n != -1);
        }
    }
}

