/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Class;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionTwice;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.ContinuousChanceNode;
import COM.hugin.HGUI.DiscreteChanceNode;
import COM.hugin.HGUI.DiscreteDecisionNode;
import COM.hugin.HGUI.HStroke;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.IllegalCloneException;
import COM.hugin.HGUI.Link;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceNode
extends Node {
    private Domain instance = null;
    protected Class instanceOf = null;
    private boolean isCollapsed = true;
    protected double collapsedWidth;
    protected double collapsedHeight;
    protected static final int OUTER_MARGIN = 10;
    protected static final int INNER_MARGIN = 15;
    protected static final int NODE_DIST = 10;
    protected LinkedList<Node> inputs = new LinkedList();
    protected LinkedList<Node> outputs = new LinkedList();
    private double arcSize;
    public static int INTERFACE_PLACEMENT_HORIZONTAL = 1;
    public static int INTERFACE_PLACEMENT_VERTICAL = 2;
    private int interfacePlacement = INTERFACE_PLACEMENT_HORIZONTAL;
    public LinkedList<InstanceNodeListener> instanceNodeListeners = null;

    protected boolean isCollapsed() {
        return this.isCollapsed;
    }

    protected boolean isExpanded() {
        return !this.isCollapsed;
    }

    protected int getCollapsedWidth() {
        return (int)this.collapsedWidth;
    }

    protected int getCollapsedHeight() {
        return (int)this.collapsedHeight;
    }

    protected double getArcSize() {
        return this.arcSize;
    }

    public InstanceNode(NetworkPanel networkPanel, Point point, Class clazz, int n) {
        super(networkPanel, point, "", "");
        try {
            String string;
            String string2 = clazz.getName() + "_" + n;
            if (this.getAPINode() != null && (string = this.getAPINode().getAttribute("HR_isCollapsed")) != null) {
                this.isCollapsed = string.equals("true");
            }
            this.initialize(clazz, string2, this.label, this.isCollapsed);
            this.name = string2;
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
    }

    public InstanceNode(NetworkPanel networkPanel, Point point, Class clazz, InstanceNode instanceNode, LinkedList<Node> linkedList, LinkedList<Node> linkedList2, String string, String string2, boolean bl) {
        super(networkPanel, point, string, string2);
        this.cloneOf = instanceNode;
        try {
            this.initialize(clazz, string, string2, bl);
            this.recordCloneOfInfo(linkedList, linkedList2);
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
    }

    public InstanceNode(InstanceNode instanceNode) {
        super(instanceNode);
        this.inputs = Node.cloneNodeList(instanceNode.inputs);
        this.outputs = Node.cloneNodeList(instanceNode.outputs);
        this.type = 5;
        this.isCollapsed = instanceNode.isCollapsed;
        this.instanceOf = instanceNode.instanceOf;
        this.setResizable(this.isCollapsed);
        this.collapsedWidth = instanceNode.collapsedWidth;
        this.collapsedHeight = instanceNode.collapsedHeight;
        this.interfacePlacement = instanceNode.interfacePlacement;
        try {
            this.setDimensionsAndLocations();
            if (!this.isCollapsed) {
                this.width = instanceNode.width;
                this.height = instanceNode.height;
            }
            this.x = instanceNode.center.x - this.width / 2.0;
            this.y = instanceNode.center.y - this.height / 2.0;
            this.setDimensionsAndLocations();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    @Override
    protected void initialize(NetworkPanel networkPanel, Point point) {
        this.panel = networkPanel;
        this.home = networkPanel.getHome();
        this.scaleFactor = networkPanel.getScaleFactor();
        this.font = networkPanel.getNodeFont();
        this.center = new Point2D.Double(point.x, point.y);
        super.setSizeFromAttribute();
        this.drawText = this.height >= (double)this.minHeightForText && this.width >= (double)this.minWidthForText;
        this.x = this.center.x - this.width / 2.0;
        this.y = this.center.y - this.height / 2.0;
        this.boundingBox = new Node.BoundingBox(this, this.x, this.y, this.width, this.height);
        this.setStroke();
        this.checkLocation();
    }

    public InstanceNode(NetworkPanel networkPanel, COM.hugin.HAPI.InstanceNode instanceNode) {
        super(networkPanel, instanceNode);
        try {
            this.instanceOf = instanceNode.getInstanceClass();
            this.inputs = this.createInterfaceNodes(this.instanceOf.getInputs(), 1);
            this.outputs = this.createInterfaceNodes(instanceNode.getOutputs(), 2);
            this.setInterfaceOrdering(instanceNode.getAttribute("HR_Input_Order"), true);
            this.setInterfaceOrdering(instanceNode.getAttribute("HR_Output_Order"), false);
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        this.type = 5;
        this.collapsedWidth = this.width;
        this.collapsedHeight = this.height;
        this.width = this.computeExpandedWidth();
        this.height = this.computeExpandedHeight();
        this.isCollapsed = true;
        try {
            String string = instanceNode.getAttribute("HR_isCollapsed");
            if (string != null) {
                this.isCollapsed = string.equals("true");
            }
            if (!this.isCollapsed) {
                this.x = this.center.x - this.width / 2.0;
                this.y = this.center.y - this.height / 2.0;
            } else {
                this.x = this.center.x - this.collapsedWidth / 2.0;
                this.y = this.center.y - this.collapsedHeight / 2.0;
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        this.boundingBox = new Node.BoundingBox(this, this.x, this.y, this.width, this.height);
        this.setStroke();
        this.setResizable(this.isCollapsed);
        try {
            this.setDimensionsAndLocations();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        this.colorAttribute = "HR_Color_Instance";
        this.updateColor();
    }

    private void initialize(Class clazz, String string, String string2, boolean bl) throws ExceptionHugin {
        this.instanceOf = clazz;
        this.colorAttribute = "HR_Color_Instance";
        this.setAPINode(new COM.hugin.HAPI.InstanceNode(this.getHomeClass(), clazz));
        this.storePosition();
        this.getAPINode().setName(string);
        this.getAPINode().setLabel(string2);
        this.updateColor();
        this.inputs = this.createInterfaceNodes(this.instanceOf.getInputs(), 1);
        this.outputs = this.createInterfaceNodes(((COM.hugin.HAPI.InstanceNode)this.getAPINode()).getOutputs(), 2);
        this.type = 5;
        this.isCollapsed = bl;
        this.setResizable(bl);
        this.collapsedWidth = this.scaleFactor * this.panel.getNodeWidth();
        this.collapsedHeight = this.scaleFactor * this.panel.getNodeHeight();
        this.setDimensionsAndLocations();
        String string3 = clazz.getAttribute("HR_Instantiated_in");
        string3 = string3 == null || string3.length() == 0 ? "\"" + this.getHomeClass().getName() + "\"" : string3 + ", \"" + this.getHomeClass().getName() + "\"";
        clazz.setAttribute("HR_Instantiated_in", string3);
    }

    private void recordCloneOfInfo(LinkedList<Node> linkedList, LinkedList<Node> linkedList2) throws ExceptionHugin {
        for (Node node : this.inputs) {
            for (Node object : linkedList) {
                if (!node.name.equals(object.name)) continue;
                node.cloneOf = object;
                break;
            }
            if (node.cloneOf != null) continue;
            new HuginGUIError("InstanceNode.recordCloneInfo (1)", HuginGUIConstants.get("str_couldnt_identify_master_node"));
            return;
        }
        for (Node node : this.outputs) {
            String string = node.getAPINode().getInstance().getName();
            String string2 = this.cloneOf.name;
            String string3 = node.name.substring(string.length() + 1);
            for (Node node2 : linkedList2) {
                String string4 = string2;
                String string5 = node2.name.substring(string4.length() + 1);
                if (!string3.equals(string5)) continue;
                node.cloneOf = node2;
                break;
            }
            if (node.cloneOf != null) continue;
            return;
        }
    }

    private LinkedList<Node> createInterfaceNodes(NodeList nodeList, int n) throws ExceptionHugin {
        String string = this.getAPINode().getAttribute("HR_InterfaceNode_placement");
        if (string != null) {
            this.interfacePlacement = string.toLowerCase().trim().equals("vertical") ? INTERFACE_PLACEMENT_VERTICAL : INTERFACE_PLACEMENT_HORIZONTAL;
        }
        String string2 = this.getAPINode().getAttribute("HR_InterfaceNode_size");
        Dimension dimension = null;
        if (string2 != null) {
            try {
                int n2 = string2.indexOf(",");
                if (n2 > 0) {
                    int n3 = Integer.parseInt(string2.substring(0, n2).trim());
                    int n4 = Integer.parseInt(string2.substring(n2 + 1).trim());
                    dimension = new Dimension(n3, n4);
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
        LinkedList<Node> linkedList = new LinkedList<Node>();
        Iterator iterator = nodeList.iterator();
        while (iterator.hasNext()) {
            Cloneable cloneable;
            String string3;
            String string4;
            COM.hugin.HAPI.Node node;
            Node node2 = this.containsAPINode(n == 2 ? this.outputs : this.inputs, node = (COM.hugin.HAPI.Node)iterator.next());
            if (node2 != null) {
                linkedList.add(node2);
                if (dimension == null) continue;
                node2.updateSize(dimension.width, dimension.height);
                continue;
            }
            if (Node.isInput(node)) {
                string4 = node.getName();
                string3 = node.getLabel();
            } else {
                cloneable = node.getMaster();
                string4 = node.getName();
                string3 = ((COM.hugin.HAPI.Node)cloneable).getLabel();
                if (string3 == null || string3.trim().length() == 0) {
                    string3 = ((COM.hugin.HAPI.Node)cloneable).getName();
                }
            }
            cloneable = null;
            if (node instanceof DiscreteNode) {
                cloneable = node instanceof COM.hugin.HAPI.DiscreteChanceNode ? new DiscreteChanceNode(this.panel, string4, string3) : new DiscreteDecisionNode(this.panel, string4, string3);
            } else if (node instanceof COM.hugin.HAPI.ContinuousChanceNode) {
                cloneable = new ContinuousChanceNode(this.panel, string4, string3);
            } else {
                new HuginGUIError("InstanceNode.createInterfaceNodes", HuginGUIConstants.get("str_attempted_to_create_interface_node_of_illegal_type"));
            }
            if (n == 2) {
                ((Node)cloneable).master = this.getMaster(node);
            } else {
                ((Node)cloneable).setStroke(HStroke.DASH_STROKE);
            }
            ((Node)cloneable).setAPINode(node);
            ((Node)cloneable).updateColor();
            linkedList.add((Node)cloneable);
        }
        return linkedList;
    }

    private Node containsAPINode(LinkedList<Node> linkedList, COM.hugin.HAPI.Node node) {
        for (Node node2 : linkedList) {
            if (node2.getAPINode() != node) continue;
            return node2;
        }
        return null;
    }

    protected void updateInputNode(COM.hugin.HAPI.Node node, COM.hugin.HAPI.Node node2) {
        for (Node node3 : this.inputs) {
            if (node3.getAPINode() != node) continue;
            node3.setAPINode(node2);
            return;
        }
        new HuginGUIError("InstanceNode.updateInputNode()", HuginGUIConstants.get("str_input_node_has_wrong_api_node"));
    }

    protected void replaceInAttribute(String string, String string2) throws ExceptionHugin {
        COM.hugin.HAPI.InstanceNode instanceNode = (COM.hugin.HAPI.InstanceNode)this.getAPINode();
        String string3 = instanceNode.getInstanceClass().getAttribute("HR_Instantiated_in");
        string3 = string3 == null || string3.length() == 0 ? "\"" + string2 + "\"" : (string3.indexOf("\"" + string + "\"") >= 0 ? string3.replaceAll("\"" + string + "\"", "\"" + string2 + "\"") : string3 + "\"" + string2 + "\"");
        instanceNode.getInstanceClass().setAttribute("HR_Instantiated_in", string3);
    }

    @Override
    protected void kill() throws ExceptionHugin {
        COM.hugin.HAPI.InstanceNode instanceNode = (COM.hugin.HAPI.InstanceNode)this.getAPINode();
        String string = instanceNode.getInstanceClass().getAttribute("HR_Instantiated_in");
        if (string != null && string.length() > 0) {
            string = string.replaceAll("\"" + instanceNode.getHomeClass().getName() + "\"", "");
            if ((string = string.trim()).length() > 0 && string.charAt(string.length() - 1) == ',') {
                string = string.substring(0, string.length() - 1);
            }
            string = string.replaceAll(", ,", ",");
        }
        instanceNode.getInstanceClass().setAttribute("HR_Instantiated_in", string);
        super.kill();
    }

    protected Node getInterfaceNode(Node node) {
        for (Node node2 : this.inputs) {
            if (node2.getAPINode() != node.getAPINode()) continue;
            return node2;
        }
        for (Node node2 : this.outputs) {
            try {
                if (node2.getAPINode() != node.getOutputClone(this.getAPINode())) continue;
                return node2;
            }
            catch (ExceptionHugin exceptionHugin) {
                exceptionHugin.printStackTrace();
            }
        }
        new HuginGUIError(HuginGUIConstants.get("InstanceNode_getInterfaceNode"), HuginGUIConstants.get("Interface_node_not_found"));
        return null;
    }

    private Node getMaster(COM.hugin.HAPI.Node node) throws ExceptionHugin {
        COM.hugin.HAPI.Node node2 = node.getMaster();
        NetworkPanel networkPanel = HuginGUIFrame.getNetworkPanel(node2.getHomeClass());
        return networkPanel.getNode(node2);
    }

    protected Rectangle update(Node node, int n) throws ExceptionHugin {
        Cloneable cloneable;
        Node node2 = null;
        if (n != 0) {
            if (node.type == 1) {
                node2 = new DiscreteChanceNode(this.panel, "", "");
            } else if (node.type == 2) {
                node2 = new ContinuousChanceNode(this.panel, "", "");
            } else if (node.type == 4) {
                node2 = new DiscreteDecisionNode(this.panel, "", "");
            } else {
                new HuginGUIError(new Exception(HuginGUIConstants.get("str_internal_error")));
            }
            node2.updateColor();
            if (n == 1) {
                node2.setAPINode(node.getAPINode());
                this.inputs.add(node2);
                node2.name = node2.getAPINode().getName();
                node2.label = node2.getAPINode().getLabel();
                node2.setStroke(HStroke.DASH_STROKE);
            } else if (n == 2) {
                node2.setAPINode(node.getOutputClone(this.getAPINode()));
                node2.master = this.getMaster(node2.getAPINode());
                this.outputs.add(node2);
                cloneable = node2.getAPINode().getMaster();
                node2.name = node2.getAPINode().getName();
                node2.label = ((COM.hugin.HAPI.Node)cloneable).getLabel();
                if (node2.label == null || node2.label.trim().length() == 0) {
                    node2.label = ((COM.hugin.HAPI.Node)cloneable).getName();
                }
            }
        }
        if (node.isInput()) {
            this.inputs.remove(NetworkPanel.getNode(node.getAPINode(), this.inputs));
        } else if (node.isOutput() && (cloneable = this.getOutputClone(node)) != null) {
            this.outputs.remove(this.getOutputClone(node));
        }
        this.setDimensionsAndLocations();
        return this.updateLinks();
    }

    private Node getOutputClone(Node node) {
        if (node != null) {
            for (Node node2 : this.outputs) {
                if (node2.master != node) continue;
                return node2;
            }
        }
        return null;
    }

    protected Rectangle updateLinks() {
        Rectangle rectangle = new Rectangle(this.boundingBox);
        try {
            NetworkPanel networkPanel = HuginGUIFrame.getNetworkPanel(this.getAPINode().getHome());
            if (networkPanel == null) {
                return rectangle;
            }
            for (Link link : networkPanel.linkList) {
                if (link.child.host != this && link.parent.host != this) continue;
                rectangle.add(link.update());
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        return rectangle;
    }

    protected Rectangle getExpandedBounds() {
        double d;
        double d2;
        int n;
        if (!this.isCollapsed) {
            return (Rectangle)this.boundingBox.clone();
        }
        int n2 = Math.max(1, Math.max(this.inputs.size(), this.outputs.size()));
        int n3 = this.inputs.size() > 0 && this.outputs.size() > 0 ? 2 : (n = this.inputs.size() > 0 || this.outputs.size() > 0 ? 1 : 0);
        if (this.getInterfacePlacement() == INTERFACE_PLACEMENT_HORIZONTAL) {
            d2 = (double)(n2 * this.getInterfaceNodeWidth()) + this.scaleFactor * (double)(20 + (n2 - 1) * 10);
            d = (double)this.getInterfaceNodeHeight() + this.scaleFactor * (double)(n * 10);
            if (n > 0) {
                d += (double)((n - 1) * this.getInterfaceNodeHeight()) + this.scaleFactor * 30.0 + (double)this.font.getSize();
            }
        } else {
            d2 = (double)this.getInterfaceNodeWidth() + this.scaleFactor * (double)(n * 10);
            if (n > 0) {
                d2 += (double)((n - 1) * this.getInterfaceNodeWidth()) + this.scaleFactor * 30.0 + (double)this.font.getSize();
            }
            d = (double)(n2 * this.getInterfaceNodeHeight()) + this.scaleFactor * (double)(20 + (n2 - 1) * 10);
        }
        return new Rectangle((int)this.x, (int)this.y, (int)d2, (int)d);
    }

    protected double computeExpandedWidth() {
        int n = Math.max(1, Math.max(this.inputs.size(), this.outputs.size()));
        int n2 = this.inputs.size() > 0 && this.outputs.size() > 0 ? 2 : (this.inputs.size() > 0 || this.outputs.size() > 0 ? 1 : 0);
        double d = 0.0;
        if (this.getInterfacePlacement() == INTERFACE_PLACEMENT_HORIZONTAL) {
            d = (double)(n * this.getInterfaceNodeWidth()) + this.scaleFactor * (double)(20 + (n - 1) * 10);
        } else {
            d = (double)this.getInterfaceNodeWidth() + this.scaleFactor * (double)(n2 * 10);
            if (n2 > 0) {
                d += (double)((n2 - 1) * this.getInterfaceNodeWidth()) + this.scaleFactor * 30.0 + (double)this.font.getSize();
            }
        }
        return d;
    }

    protected double computeExpandedHeight() {
        int n = Math.max(1, Math.max(this.inputs.size(), this.outputs.size()));
        int n2 = this.inputs.size() > 0 && this.outputs.size() > 0 ? 2 : (this.inputs.size() > 0 || this.outputs.size() > 0 ? 1 : 0);
        double d = 0.0;
        if (this.getInterfacePlacement() == INTERFACE_PLACEMENT_HORIZONTAL) {
            d = (double)this.getInterfaceNodeHeight() + this.scaleFactor * (double)(n2 * 10);
            if (n2 > 0) {
                d += (double)((n2 - 1) * this.getInterfaceNodeHeight()) + this.scaleFactor * 30.0 + (double)this.font.getSize();
            }
        } else {
            d = (double)(n * this.getInterfaceNodeHeight()) + this.scaleFactor * (double)(20 + (n - 1) * 10);
        }
        return d;
    }

    private void setDimensionsAndLocations() throws ExceptionHugin {
        if (this.isCollapsed) {
            this.width = this.collapsedWidth;
            this.height = this.collapsedHeight;
        } else {
            this.width = this.computeExpandedWidth();
            this.height = this.computeExpandedHeight();
        }
        this.arcSize = this.scaleFactor * this.panel.getArcSize();
        this.checkLocation();
        this.boundingBox.setBounds(this.x, this.y, this.width, this.height);
        this.setInterfaceLocations();
        this.shape = new RoundRectangle2D.Double(this.x, this.y, this.width, this.height, this.arcSize, this.arcSize);
        ((RoundRectangle2D)this.shape).setFrame(this.x, this.y, this.width, this.height);
    }

    @Override
    protected void checkLocation() {
        this.center.setLocation(this.x + this.width / 2.0, this.y + this.height / 2.0);
        this.boundingBox.setLocation(this.x, this.y);
    }

    @Override
    protected Point2D.Double textLocation() {
        int n;
        if (this.isCollapsed) {
            return this.center;
        }
        int n2 = this.inputs.size() > 0 && this.outputs.size() > 0 ? 2 : (n = this.inputs.size() > 0 || this.outputs.size() > 0 ? 1 : 0);
        if (n != 1) {
            return this.center;
        }
        int n3 = 15 + this.font.getSize() / 2;
        if (this.inputs.size() > 0) {
            return new Point2D.Double(this.center.x, this.y + this.height - (double)n3);
        }
        return new Point2D.Double(this.center.x, this.y + (double)n3);
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        super.paint(graphics2D);
        if (!this.isGhost && this.drawText) {
            this.paintText(graphics2D);
        }
        graphics2D.setPaint(Color.black);
        graphics2D.drawRoundRect((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)this.arcSize, (int)this.arcSize);
        if (!this.isCollapsed) {
            for (Node node : this.inputs) {
                node.paint(graphics2D);
            }
            for (Node node : this.outputs) {
                node.paint(graphics2D);
            }
        }
    }

    @Override
    public void print(Graphics graphics, Point point) throws ExceptionHugin {
        this.print(graphics, point, this.isCollapsed);
    }

    public void print(Graphics graphics, Point point, boolean bl) throws ExceptionHugin {
        boolean bl2;
        boolean bl3 = bl && bl != this.isCollapsed;
        boolean bl4 = bl2 = !bl && bl != this.isCollapsed;
        if (bl3) {
            this.collapse();
        }
        if (bl2) {
            this.expand();
        }
        graphics.setColor(this.fillColor);
        graphics.fillRoundRect((int)this.x + point.x, (int)this.y + point.y, (int)this.width, (int)this.height, (int)this.arcSize, (int)this.arcSize);
        graphics.setColor(Color.black);
        graphics.drawRoundRect((int)this.x + point.x, (int)this.y + point.y, (int)this.width, (int)this.height, (int)this.arcSize, (int)this.arcSize);
        this.printText(graphics, point);
        if (!bl) {
            for (Node node : this.inputs) {
                node.printInInstance(graphics, point, 1);
            }
            for (Node node : this.outputs) {
                node.printInInstance(graphics, point, 2);
            }
        }
        if (bl3) {
            this.expand();
        }
        if (bl2) {
            this.collapse();
        }
    }

    @Override
    protected void updateColor() {
        super.updateColor();
        for (Node node : this.inputs) {
            node.updateColor();
        }
        for (Node node : this.outputs) {
            node.updateColor();
        }
    }

    @Override
    protected void setFont(Font font) {
        super.setFont(font);
        for (Node node : this.inputs) {
            node.setFont(font);
        }
        for (Node node : this.outputs) {
            node.setFont(font);
        }
    }

    protected boolean almostTouches(Point point) {
        return !this.contains(point) && this.boundingBox.contains(point);
    }

    protected Rectangle swapDisplayMode() throws ExceptionHugin {
        if (this.isCollapsed) {
            this.expand();
        } else {
            this.collapse();
        }
        return new Rectangle((int)this.x, (int)this.y, (int)this.collapsedWidth, (int)this.collapsedHeight);
    }

    protected Rectangle expand() throws ExceptionHugin {
        if (!this.isCollapsed) {
            return new Rectangle();
        }
        Rectangle rectangle = new Rectangle(this.boundingBox);
        this.isCollapsed = false;
        this.center.x = this.x + this.computeExpandedWidth() / 2.0;
        this.center.y = this.y + this.computeExpandedHeight() / 2.0;
        this.storePosition();
        this.getAPINode().setAttribute("HR_isCollapsed", "false");
        this.setResizable(this.isCollapsed);
        this.setDimensionsAndLocations();
        rectangle.add(this.boundingBox);
        rectangle.add(this.updateLinks());
        return rectangle;
    }

    protected Rectangle collapse() throws ExceptionHugin {
        if (this.isCollapsed) {
            return new Rectangle();
        }
        Rectangle rectangle = new Rectangle(this.boundingBox);
        this.isCollapsed = true;
        this.center.x = this.x + this.collapsedWidth / 2.0;
        this.center.y = this.y + this.collapsedHeight / 2.0;
        this.storePosition();
        this.getAPINode().setAttribute("HR_isCollapsed", "true");
        this.setResizable(this.isCollapsed);
        this.setDimensionsAndLocations();
        rectangle.add(this.updateLinks());
        this.deselectLinks();
        return rectangle;
    }

    private void deselectLinks() {
        for (Link link : this.panel.linkList) {
            if (link.child.host != this && link.parent.host != this || !link.isSelected()) continue;
            link.deselect();
        }
    }

    @Override
    public void moveTo(double d, double d2) throws ExceptionHugin {
        super.moveTo(d, d2);
        this.setInterfaceLocations();
        ((RoundRectangle2D)this.shape).setFrame(this.x, this.y, this.width, this.height);
    }

    @Override
    public void moveTo(int n, int n2) throws ExceptionHugin {
        this.moveTo((double)n, (double)n2);
    }

    @Override
    protected void updateSize() throws ExceptionHugin {
        for (Node node : this.inputs) {
            node.updateSize();
        }
        for (Node node : this.outputs) {
            node.updateSize();
        }
        this.setDimensionsAndLocations();
    }

    @Override
    protected void updateSize(int n, int n2) throws ExceptionHugin {
        this.collapsedWidth = this.scaleFactor * (double)n;
        this.collapsedHeight = this.scaleFactor * (double)n2;
        if (this.isCollapsed) {
            this.width = this.collapsedWidth;
            this.height = this.collapsedHeight;
            this.drawText = this.height >= (double)this.minHeightForText && this.width >= (double)this.minWidthForText;
            this.move(0, 0);
            this.boundingBox.setSize(this.width, this.height);
            this.panel.nodeChangedSize(this);
        }
        this.getAPINode().setAttribute("HR_NodeSize", "(" + n + ", " + n2 + ")");
    }

    @Override
    protected void setSpecialSize(String string) throws ExceptionHugin {
        this.getAPINode().setAttribute("HR_NodeSize", string);
        if (this.isExpanded()) {
            this.collapsedWidth = this.scaleFactor * HuginGUIUtils.parseDouble(string, "(", ",");
            this.collapsedHeight = this.scaleFactor * HuginGUIUtils.parseDouble(string, ",", ")");
        } else {
            this.parseSizeSpec(string);
            this.updateSize((int)(this.width / this.scaleFactor), (int)(this.height / this.scaleFactor));
            this.updateLinks();
        }
    }

    @Override
    protected void scale(double d) throws ExceptionHugin {
        super.scale(d);
        this.collapsedWidth *= d;
        this.collapsedHeight *= d;
        for (Node node : this.inputs) {
            node.scale(d);
        }
        for (Node node : this.outputs) {
            node.scale(d);
        }
        this.setInterfaceLocations();
        this.arcSize *= d;
    }

    public Rectangle setInterfacePlacement(int n) {
        Rectangle rectangle = this.getBoundingBox(false);
        int n2 = this.interfacePlacement;
        this.interfacePlacement = n;
        try {
            this.getAPINode().setAttribute("HR_InterfaceNode_placement", n == INTERFACE_PLACEMENT_HORIZONTAL ? "horizontal" : "vertical");
            this.setDimensionsAndLocations();
        }
        catch (Exception exception) {
            new HuginGUIError(HuginGUIConstants.get("str_unable_to_change_placement_of_interface_nodes"));
            this.interfacePlacement = n;
        }
        rectangle.add(this.getBoundingBox(false));
        return rectangle;
    }

    public int getInterfacePlacement() {
        return this.interfacePlacement;
    }

    protected int getInterfaceNodeWidth() {
        if (this.inputs.size() > 0) {
            return this.inputs.get(0).getWidth();
        }
        if (this.outputs.size() > 0) {
            return this.outputs.get(0).getWidth();
        }
        return (int)this.panel.getNodeWidth();
    }

    protected int getInterfaceNodeHeight() {
        if (this.inputs.size() > 0) {
            return this.inputs.get(0).getHeight();
        }
        if (this.outputs.size() > 0) {
            return this.outputs.get(0).getHeight();
        }
        return (int)this.panel.getNodeHeight();
    }

    private void setInterfaceLocations() throws ExceptionHugin {
        double d;
        double d2;
        double d3;
        double d4;
        Point2D.Double double_ = new Point2D.Double(this.x, this.y);
        double d5 = double_.x + (this.scaleFactor * 10.0 + (double)(this.getInterfaceNodeWidth() / 2));
        double d6 = double_.y + (this.scaleFactor * 10.0 + (double)(this.getInterfaceNodeHeight() / 2));
        int n = this.outputs.size() - this.inputs.size();
        if (this.getInterfacePlacement() == INTERFACE_PLACEMENT_HORIZONTAL) {
            d4 = (double)this.getInterfaceNodeWidth() + 10.0 * this.scaleFactor;
            d3 = 0.0;
            d2 = (double)n * d4 / 2.0;
            d = 0.0;
        } else {
            d4 = 0.0;
            d3 = (double)this.getInterfaceNodeHeight() + 10.0 * this.scaleFactor;
            d2 = 0.0;
            d = (double)n * d3 / 2.0;
        }
        if (n > 0) {
            d5 += d2;
            d6 += d;
        }
        for (Node node : this.inputs) {
            node.host = this;
            node.moveTo(d5, d6);
            d5 += d4;
            d6 += d3;
        }
        if (this.getInterfacePlacement() == INTERFACE_PLACEMENT_HORIZONTAL) {
            d5 = double_.x + (10.0 * this.scaleFactor + (double)(this.getInterfaceNodeWidth() / 2));
            d6 = double_.y + this.height - (10.0 * this.scaleFactor + (double)(this.getInterfaceNodeHeight() / 2));
        } else {
            d5 = double_.x + this.width - (10.0 * this.scaleFactor + (double)(this.getInterfaceNodeWidth() / 2));
            d6 = double_.y + (10.0 * this.scaleFactor + (double)(this.getInterfaceNodeHeight() / 2));
        }
        if (n < 0) {
            d5 += -d2;
            d6 += -d;
        }
        for (Node node : this.outputs) {
            node.host = this;
            node.moveTo(d5, d6);
            d5 += d4;
            d6 += d3;
        }
    }

    public Rectangle setInterfaceNodeSize(Dimension dimension) throws ExceptionHugin {
        Rectangle rectangle = this.getBoundingBox(false);
        for (Node node : this.inputs) {
            node.updateSize(dimension.width, dimension.height);
        }
        for (Node node : this.outputs) {
            node.updateSize(dimension.width, dimension.height);
        }
        this.getAPINode().setAttribute("HR_InterfaceNode_size", dimension.width + "," + dimension.height);
        this.setDimensionsAndLocations();
        return rectangle;
    }

    @Override
    public void setGhost(boolean bl) {
        super.setGhost(bl);
        for (Node node : this.inputs) {
            node.setGhost(bl);
        }
        for (Node node : this.outputs) {
            node.setGhost(bl);
        }
    }

    @Override
    public Object clone() {
        InstanceNode instanceNode = new InstanceNode(this);
        instanceNode.name = this.name;
        instanceNode.cloneOf = this;
        return instanceNode;
    }

    @Override
    public Object clone(NetworkPanel networkPanel, Point point) throws IllegalCloneException {
        if (networkPanel.getHomeClass() == null) {
            throw new IllegalCloneException(HuginGUIConstants.get("V57_NETS_CANT_CONTAIN_OOBN_NODES"));
        }
        if (networkPanel.containsContinuousNodes() && HuginGUIFrame.getNetworkPanel(((InstanceNode)this.cloneOf).instanceOf).isLIMIDs()) {
            throw new IllegalCloneException(HuginGUIConstants.get("CG_NETS_CANT_CONTAIN_ID_NODES"));
        }
        if (networkPanel.isLIMIDs() && HuginGUIFrame.getNetworkPanel(((InstanceNode)this.cloneOf).instanceOf).containsContinuousNodes()) {
            throw new IllegalCloneException(HuginGUIConstants.get("IDS_CANT_CONTAIN_CG_NODES"));
        }
        int n = this.cloneOf.cloneId(networkPanel);
        InstanceNode instanceNode = new InstanceNode(networkPanel, point, ((InstanceNode)this.cloneOf).instanceOf, this, this.inputs, this.outputs, this.cloneOf.cloneName(n), this.cloneOf.cloneLabel(n), ((InstanceNode)this.cloneOf).isCollapsed());
        instanceNode.cloneOf = this;
        instanceNode.setGroup(this.cloneOf.group);
        return instanceNode;
    }

    public Node getInterfaceNodeAt(Point point) {
        for (Node node : this.inputs) {
            if (!node.contains(point)) continue;
            return node;
        }
        for (Node node : this.outputs) {
            if (!node.contains(point)) continue;
            return node;
        }
        return null;
    }

    protected Rectangle moveInterfaceNode(Node node, boolean bl) throws ExceptionHugin {
        Rectangle rectangle = null;
        LinkedList<Node> linkedList = this.inputs.contains(node) ? this.inputs : this.outputs;
        int n = linkedList.size();
        if (n > 1) {
            int n2 = linkedList.indexOf(node);
            int n3 = bl ? (n2 + 1) % linkedList.size() : (n2 == 0 ? linkedList.size() - 1 : n2 - 1);
            linkedList.set(n2, linkedList.get(n3));
            linkedList.set(n3, node);
            this.setInterfaceLocations();
            rectangle = new Rectangle(this.boundingBox);
            rectangle.add(this.updateLinks());
        }
        return rectangle;
    }

    private void moveInterfaceNode(String string, int n, boolean bl) {
        int n2;
        LinkedList<Node> linkedList = bl ? this.inputs : this.outputs;
        Node node = null;
        for (n2 = 0; n2 < linkedList.size(); ++n2) {
            node = linkedList.get(n2);
            if (node.name.equals(string)) break;
        }
        if (n2 >= linkedList.size() || n >= linkedList.size() || n == n2) {
            return;
        }
        Node node2 = linkedList.get(n);
        linkedList.set(n, node);
        linkedList.set(n2, node2);
    }

    protected boolean isInput(Node node) {
        return this.inputs.contains(node);
    }

    protected boolean isOutput(Node node) {
        return this.outputs.contains(node);
    }

    protected String getInterfaceOrdering(boolean bl) {
        String string = "";
        for (Node node : bl ? this.inputs : this.outputs) {
            string = string + node.name + "\t";
        }
        return string;
    }

    protected void setInterfaceOrdering(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = string.indexOf("\t", n2);
            String string2 = string.substring(n2, n3);
            n2 = n3 + 1;
            this.moveInterfaceNode(string2, n, bl);
            ++n;
        }
    }

    protected boolean isContinuous() {
        for (Node node : this.inputs) {
            if (!node.isContinuousChance()) continue;
            return true;
        }
        for (Node node : this.outputs) {
            if (!node.isContinuousChance()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isDecision() {
        for (Node node : this.inputs) {
            if (!node.isDecision()) continue;
            return true;
        }
        for (Node node : this.outputs) {
            if (!node.isDecision()) continue;
            return true;
        }
        return false;
    }

    protected void selectClassFrame() {
        try {
            HuginGUIFrame cfr_ignored_0 = this.panel.guiFrame;
            HuginGUIFrame.getProjectFrame(this.instanceOf.getName()).setSelected(true);
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    @Override
    protected void setName(String string) throws ExceptionHugin {
        String string2 = this.name;
        super.setName(string);
        for (Node node : this.outputs) {
            try {
                String string3 = string + "_" + node.name.substring(string2.length() + 1);
                node.setName(string3);
            }
            catch (ExceptionTwice exceptionTwice) {}
        }
    }

    protected void replaceClass(Class clazz) throws ExceptionHugin {
        this.fireClassToBeReplaced();
        COM.hugin.HAPI.InstanceNode instanceNode = (COM.hugin.HAPI.InstanceNode)this.getAPINode();
        try {
            this.instanceOf = clazz;
            instanceNode.substituteClass(clazz);
        }
        catch (ExceptionHugin exceptionHugin) {
            this.fireClassReplaced();
            throw exceptionHugin;
        }
        this.inputs.clear();
        this.inputs = this.createInterfaceNodes(this.instanceOf.getInputs(), 1);
        this.outputs = this.createInterfaceNodes(instanceNode.getOutputs(), 2);
        this.setDimensionsAndLocations();
        this.fireClassReplaced();
    }

    protected LinkedList<Node> getInputs() {
        return new LinkedList<Node>(this.inputs);
    }

    protected LinkedList<Node> getOutputs() {
        return new LinkedList<Node>(this.outputs);
    }

    public void addInstanceNodeListener(InstanceNodeListener instanceNodeListener) {
        if (this.instanceNodeListeners == null) {
            this.instanceNodeListeners = new LinkedList();
        }
        if (!this.instanceNodeListeners.contains(instanceNodeListener)) {
            this.instanceNodeListeners.add(instanceNodeListener);
        }
    }

    public void removeInstanceNodeListener(InstanceNodeListener instanceNodeListener) {
        if (this.instanceNodeListeners != null) {
            this.instanceNodeListeners.remove(instanceNodeListener);
        }
    }

    protected void fireClassToBeReplaced() throws ExceptionHugin {
        if (this.instanceNodeListeners != null) {
            for (InstanceNodeListener instanceNodeListener : this.instanceNodeListeners) {
                instanceNodeListener.classToBeReplaced(this);
            }
        }
    }

    protected void fireClassReplaced() throws ExceptionHugin {
        if (this.instanceNodeListeners != null) {
            for (InstanceNodeListener instanceNodeListener : this.instanceNodeListeners) {
                instanceNodeListener.classReplaced(this);
            }
        }
    }

    public static interface InstanceNodeListener {
        public void classReplaced(InstanceNode var1) throws ExceptionHugin;

        public void classToBeReplaced(InstanceNode var1) throws ExceptionHugin;
    }
}

