/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.table.AbstractTableModel;

public class InternalNodeTableModel
extends AbstractTableModel {
    String[][] modelData;
    String[] headers;
    int tabel_type;
    boolean expressionTable;

    InternalNodeTableModel(String[][] stringArray, int n, int n2) {
        this.modelData = stringArray;
        this.headers = this.modelData[0];
        this.tabel_type = n;
        this.expressionTable = n2 == 2;
    }

    public int getRowCount() {
        return this.modelData.length;
    }

    public int getColumnCount() {
        return this.headers.length;
    }

    public Object getValueAt(int n, int n2) {
        return this.modelData[n][n2];
    }

    public String getColumnName(int n) {
        return this.headers[n];
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (this.expressionTable) {
            this.setExpressionValueAt(object, n, n2);
        } else {
            this.setNumberValueAt(object, n, n2);
        }
    }

    private void setNumberValueAt(Object object, int n, int n2) {
        try {
            String string = (String)object;
            if (this.tabel_type != 4) {
                double d = new Double(string);
                this.modelData[n][n2] = InternalNodeTableModel.formatDouble(d);
                if (d == Double.NEGATIVE_INFINITY) {
                    this.modelData[n][n2] = "-inf";
                }
                if (d == Double.POSITIVE_INFINITY) {
                    this.modelData[n][n2] = "inf";
                }
                this.fireTableCellUpdated(n, n2);
            } else {
                this.modelData[n][n2] = string;
                this.fireTableCellUpdated(n, n2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected static String formatDouble(double d) {
        try {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
            decimalFormat.setGroupingUsed(false);
            if (Math.abs(d) >= 1.0E-6) {
                decimalFormat.setMaximumFractionDigits(6);
            } else if (Math.abs(d) > 0.0) {
                decimalFormat.applyPattern("0.##E0");
            }
            return decimalFormat.format(d);
        }
        catch (NumberFormatException numberFormatException) {
            return "0.0";
        }
    }

    private void setExpressionValueAt(Object object, int n, int n2) {
        this.modelData[n][n2] = (String)object;
        this.fireTableCellUpdated(n, n2);
    }

    public void updateModel(String[][] stringArray) {
        this.modelData = stringArray;
        this.headers = this.modelData[0];
        this.fireTableStructureChanged();
    }
}

