/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.Table;
import COM.hugin.HGUI.ColorChart;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.Node;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Random;

public class IntervalChart
extends ColorChart {
    private float[][] myData = null;
    private Table myTable = null;
    DiscreteChanceNode parent;
    DiscreteChanceNode child;

    public IntervalChart(DiscreteChanceNode discreteChanceNode, DiscreteChanceNode discreteChanceNode2, float[][] fArray) {
        super((Node)null);
        MouseListener[] mouseListenerArray;
        this.myData = fArray;
        this.parent = discreteChanceNode2;
        this.child = discreteChanceNode;
        for (MouseListener mouseListener : mouseListenerArray = this.getMouseListeners()) {
            this.removeMouseListener(mouseListener);
        }
    }

    public IntervalChart(DiscreteChanceNode discreteChanceNode, DiscreteChanceNode discreteChanceNode2, Table table) {
        super((Node)null);
        MouseListener[] mouseListenerArray;
        this.myTable = table;
        this.parent = discreteChanceNode2;
        this.child = discreteChanceNode;
        for (MouseListener mouseListener : mouseListenerArray = this.getMouseListeners()) {
            this.removeMouseListener(mouseListener);
        }
    }

    public float getValue(int n, int n2) {
        try {
            if (this.myData != null) {
                return this.myData[n][n2];
            }
            NodeList nodeList = this.myTable.getNodes();
            int[] nArray = new int[nodeList.size()];
            for (int i = 0; i < nodeList.size(); ++i) {
                COM.hugin.HAPI.Node node = (COM.hugin.HAPI.Node)nodeList.get(i);
                nArray[i] = node == this.child ? n2 : (node == this.parent ? n : -1);
            }
            return (float)this.myTable.getDataItem(this.myTable.getIndex(nArray));
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            return 0.0f;
        }
    }

    public int computeHeight() throws ExceptionHugin {
        return this.child.getNumberOfStates();
    }

    public int computeWidth() throws ExceptionHugin {
        return this.parent.getNumberOfStates();
    }

    public boolean shouldPaint() {
        return true;
    }

    public void paintChart(Graphics2D graphics2D, int n, int n2, float f) {
        try {
            int n3;
            int[] nArray = new int[this.parent.getNumberOfStates()];
            int n4 = this.computeStateWidths(this.parent, nArray);
            int[] nArray2 = new int[this.child.getNumberOfStates()];
            int n5 = this.computeStateWidths(this.child, nArray2);
            double d = (double)this.graphWidth / (double)n4;
            double d2 = (double)this.getHeight() / (double)n5;
            graphics2D.scale(d, d2);
            graphics2D.setColor(this.baseColor);
            graphics2D.fillRect(0, 0, n4, n5);
            Color color = this.errorColor;
            int n6 = 0;
            for (int i = 0; i < n2; ++i) {
                n3 = 0;
                for (int j = 0; j < n; ++j) {
                    Random random = new Random();
                    float f2 = this.getValue(j, i);
                    color = f2 >= 0.0f ? ((f2 /= f) <= 1.0f ? new Color(this.fillColorPosR, this.fillColorPosG, this.fillColorPosB, f2) : this.errorColor) : ((f2 = Math.abs(f2 / f)) <= 1.0f ? new Color(this.fillColorNegR, this.fillColorNegG, this.fillColorNegB, f2) : this.errorColor);
                    graphics2D.setColor(color);
                    graphics2D.fillRect(n3, n6, nArray[j], nArray2[i]);
                    n3 += nArray[j];
                }
                n6 += nArray2[i];
            }
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(this.thinStroke);
            graphics2D.setColor(Color.BLACK);
            n3 = 0;
            for (int n7 : nArray) {
                graphics2D.drawLine(n3 += n7, 0, n3, n6);
            }
            n6 = 0;
            for (int n7 : nArray2) {
                graphics2D.drawLine(0, n6 += n7, n3, n6);
            }
            graphics2D.setStroke(stroke);
            d = (double)n4 / (double)this.graphWidth;
            d2 = (double)n5 / (double)this.getHeight();
            graphics2D.scale(d, d2);
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
    }

    private int computeStateWidths(DiscreteChanceNode discreteChanceNode, int[] nArray) throws ExceptionHugin {
        if (discreteChanceNode instanceof IntervalDCNode) {
            int n;
            IntervalDCNode intervalDCNode = (IntervalDCNode)discreteChanceNode;
            boolean bl = false;
            boolean bl2 = false;
            double d = intervalDCNode.getStateValue(0);
            for (int i = 0; i < intervalDCNode.getNumberOfStates() && (d = intervalDCNode.getStateValue(i)) == -NetworkModel.INFINITY(); ++i) {
                bl = true;
            }
            double d2 = intervalDCNode.getStateValue(intervalDCNode.getNumberOfStates());
            if (d2 == NetworkModel.INFINITY()) {
                bl2 = true;
                d2 = intervalDCNode.getStateValue(intervalDCNode.getNumberOfStates() - 1);
            }
            double d3 = d2 - d;
            int n2 = 1;
            while (d3 * (double)n2 < (double)intervalDCNode.getNumberOfStates()) {
                n2 += n2;
            }
            double d4 = 0.0;
            int n3 = 0;
            int n4 = 0;
            if (bl) {
                n4 = 1;
            }
            int n5 = intervalDCNode.getNumberOfStates();
            if (bl2) {
                --n5;
            }
            for (n = n4; n < n5; ++n) {
                d4 = Math.max((intervalDCNode.getStateValue(n + 1) - intervalDCNode.getStateValue(n)) * (double)n2, d4);
            }
            d4 *= 2.0;
            for (n = n4; n < n5; ++n) {
                nArray[n] = (int)((intervalDCNode.getStateValue(n + 1) - intervalDCNode.getStateValue(n)) * (double)n2);
                n3 += nArray[n];
            }
            if (bl) {
                nArray[0] = (int)d4;
                n3 += (int)d4;
            }
            if (bl2) {
                nArray[intervalDCNode.getNumberOfStates() - 1] = (int)d4;
                n3 += (int)d4;
            }
            return n3;
        }
        for (int i = 0; i < discreteChanceNode.getNumberOfStates(); ++i) {
            nArray[i] = 1;
        }
        return discreteChanceNode.getNumberOfStates();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (mouseEvent.getX() >= this.graphWidth) {
            return null;
        }
        try {
            int[] nArray = new int[this.parent.getNumberOfStates()];
            int n = this.computeStateWidths(this.parent, nArray);
            int[] nArray2 = new int[this.child.getNumberOfStates()];
            int n2 = this.computeStateWidths(this.child, nArray2);
            double d = (double)n / (double)this.graphWidth;
            double d2 = (double)n2 / (double)this.getHeight();
            int n3 = (int)((double)mouseEvent.getX() * d);
            int n4 = (int)((double)mouseEvent.getY() * d2);
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            for (int n9 : nArray) {
                if (n3 >= n7 && n3 < n7 + n9) break;
                n7 += n9;
                ++n5;
            }
            for (int n9 : nArray2) {
                if (n4 >= n8 && n4 < n8 + n9) break;
                n8 += n9;
                ++n6;
            }
            return "[" + HuginGUIUtils.getNodeStateLabel(this.parent, n5) + ", " + HuginGUIUtils.getNodeStateLabel(this.child, n6) + "] = " + this.getValue(n5, n6);
        }
        catch (Exception exception) {
            return "error";
        }
    }
}

