/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.DataSourceException;
import COM.hugin.HGUI.DatabaseDataSource;
import COM.hugin.HGUI.DatabaseException;
import COM.hugin.HGUI.DatabaseTable;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCDataSource
extends DatabaseDataSource {
    private String url;
    private String user;
    private String password;
    private String path;
    private int lineNumber = 0;
    private Connection conn;
    private static final Class[] parameters = new Class[]{URL.class};
    private Vector<String[]> databaseData;
    private int dataIndex;
    private String[] names;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JDBCDataSource(String string, String string2, String string3, String string4) throws DatabaseException {
        try {
            this.url = string2;
            this.password = string4;
            this.user = string3;
            this.path = string;
            this.databaseData = null;
            this.dataIndex = 0;
            this.names = null;
            if (string.length() == 0) throw new DatabaseException("Unable to use the database.\nMake sure the database driver directory is set in preferences.\n");
            ArrayList<String> arrayList = this.loadDrivers(string);
            if (arrayList.size() <= 0) throw new DatabaseException("Unable to use the database.\nThe classes for the driver could not be found.\nMake sure that your classpath is set up to include these.");
            for (int i = 0; i < arrayList.size(); ++i) {
                Class.forName(arrayList.get(i));
            }
            this.conn = this.database = DriverManager.getConnection(string2, string3, string4);
            this.statement = null;
            return;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new DatabaseException(noClassDefFoundError.getMessage());
        }
        catch (DatabaseException databaseException) {
            throw new DatabaseException(databaseException.getMessage());
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage() + " " + " Unable to connect to database \n");
        }
    }

    @Override
    protected String getUser() {
        return this.user;
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    protected Vector<DatabaseTable> getTables() throws SQLException {
        Vector<DatabaseTable> vector = new Vector<DatabaseTable>();
        DatabaseMetaData databaseMetaData = this.database.getMetaData();
        String[] stringArray = new String[]{"TABLE", "VIEW"};
        ResultSet resultSet = databaseMetaData.getTables(null, null, null, stringArray);
        while (resultSet.next()) {
            String string = resultSet.getString(2);
            if (string != null) {
                if (string.equalsIgnoreCase("SYSTEM") || string.equalsIgnoreCase("SYS")) continue;
                if (!string.equalsIgnoreCase(this.user)) {
                    vector.add(new DatabaseTable(resultSet.getString(2) + "." + resultSet.getString(3)));
                    continue;
                }
                vector.add(new DatabaseTable(resultSet.getString(3)));
                continue;
            }
            vector.add(new DatabaseTable(resultSet.getString(3)));
        }
        resultSet.close();
        this.fillInVariables(vector);
        return vector;
    }

    @Override
    public String[] readLine() throws DataSourceException {
        try {
            if (this.databaseData == null) {
                this.databaseData = new Vector();
                while (!this.resultSetExhausted()) {
                    this.databaseData.add(super.readLine());
                }
            }
            ++this.dataIndex;
            return this.databaseData.get(this.dataIndex - 1);
        }
        catch (DataSourceException dataSourceException) {
            throw new DataSourceException(dataSourceException.getMessage());
        }
        catch (Exception exception) {
            throw new DataSourceException(exception.getMessage());
        }
    }

    @Override
    public void reset() throws DataSourceException {
        boolean bl = false;
        try {
            if (this.databaseData == null && !this.resultSetAtBeginning()) {
                super.reset();
            }
            this.dataIndex = 0;
        }
        catch (DataSourceException dataSourceException) {
            throw new DataSourceException(dataSourceException.getMessage());
        }
    }

    @Override
    public String[] getNames() throws DataSourceException {
        try {
            this.databaseData = null;
            return super.getNames();
        }
        catch (DataSourceException dataSourceException) {
            throw new DataSourceException(dataSourceException.getMessage());
        }
    }
}

