/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionMemory;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.Table;
import COM.hugin.HGUI.BeliefBarPanel;
import COM.hugin.HGUI.HuginAnalysisDialog;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.HuginTableModel;
import COM.hugin.HGUI.NumberField;
import COM.hugin.HGUI.TableSorter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JointDialog
extends HuginAnalysisDialog {
    JPanel jointResult;
    JTextArea targetEntropy = null;
    Domain domain = null;
    private JTabbedPane tabs = null;
    private int jointAnalysisIndex = 0;
    private int kMostIndex = 1;
    private int infoVarsIndex = 2;
    private HuginTableModel jointTableModel = null;
    private TableSorter jointSorter = null;
    private JTable jointTable = null;
    private JSpinner numConfs;
    private NumberField pThreshold = null;
    private HuginTableModel kMostTableModel = null;
    private TableSorter kMostSorter = null;
    private JTable kMostTable = null;

    public JointDialog(HuginProjectFrame huginProjectFrame) {
        super(huginProjectFrame, HuginGUIConstants.get("Joint_Analysis"), true);
        this.domain = huginProjectFrame.getBeliefBarPanel().getDomain();
        this.helpPage = "help/jointHelp.html";
        this.setResizable(true);
        try {
            this.setContentPane(this.createContent());
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
            this.dispose();
        }
        this.groupDefiner = new HuginAnalysisDialog.GroupDefiner(this, this, huginProjectFrame.getNetworkPanel(), null);
        this.groupDefiner.pack();
    }

    @Override
    protected JPanel createContent() throws ExceptionHugin {
        return this.createContent(HuginGUIConstants.get("Joint_Analysis"), HuginGUIConstants.get("Joint_kMost"), HuginGUIConstants.get("Joint_Variables"));
    }

    protected JPanel createContent(String string, String string2, String string3) throws ExceptionHugin {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tabs = new JTabbedPane();
        this.tabs.add((Component)this.createAnalysisTab(), string);
        this.tabs.add((Component)this.createKMostTab(), string2);
        this.tabs.add((Component)this.createInfoVarsTab(), string3);
        this.tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JointDialog.this.perform.setEnabled(JointDialog.this.tabs.getSelectedIndex() != JointDialog.this.infoVarsIndex);
            }
        });
        jPanel.add(this.tabs);
        jPanel.add((Component)this.getButtonPanel(1), "South");
        this.pack();
        return jPanel;
    }

    protected JPanel createAnalysisTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.jointTableModel = new HuginTableModel(HuginGUIConstants.get("Joint_Probability_of_configurations"));
        this.jointSorter = new TableSorter(this.jointTableModel);
        JTable jTable = new JTable(this.jointSorter);
        this.jointSorter.setTableHeader(jTable.getTableHeader());
        jTable.setPreferredScrollableViewportSize(new Dimension(500, 120));
        HuginAnalysisDialog.DoubleTableRenderer doubleTableRenderer = new HuginAnalysisDialog.DoubleTableRenderer(this.projectFrame.guiFrame.preferences.precision);
        jTable.setDefaultRenderer(Double.class, doubleTableRenderer);
        JScrollPane jScrollPane = new JScrollPane(jTable, 22, 31);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("Joint_Probability_of_configurations") + ":"));
        jPanel2.add(jScrollPane);
        jPanel.add(jPanel2);
        return jPanel;
    }

    protected JPanel createKMostTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout());
        this.pThreshold = new NumberField(new Double(1.0E-4));
        this.pThreshold.setHorizontalAlignment(4);
        jPanel2.add(new JLabel(HuginGUIConstants.get("Joint_Probability_threshold") + " : "));
        jPanel2.add(this.pThreshold);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.kMostTableModel = new HuginTableModel(HuginGUIConstants.get("Joint_Probability_of_kmost_configurations"));
        this.kMostSorter = new TableSorter(this.kMostTableModel);
        JTable jTable = new JTable(this.kMostSorter);
        this.kMostSorter.setTableHeader(jTable.getTableHeader());
        jTable.setPreferredScrollableViewportSize(new Dimension(500, 120));
        HuginAnalysisDialog.DoubleTableRenderer doubleTableRenderer = new HuginAnalysisDialog.DoubleTableRenderer(this.projectFrame.guiFrame.preferences.precision);
        jTable.setDefaultRenderer(Double.class, doubleTableRenderer);
        JScrollPane jScrollPane = new JScrollPane(jTable, 22, 31);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("Joint_Probability_of_kmost_configurations") + ":"));
        jPanel3.add(jScrollPane);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add(jPanel3);
        return jPanel;
    }

    @Override
    protected JButton getPerformButton() {
        JButton jButton = new JButton(HuginGUIConstants.get("ANALYSIS_Calculate"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    System.err.println("1");
                    NodeList nodeList = JointDialog.this.getSelectedVariables();
                    if (JointDialog.this.tabs.getSelectedIndex() == JointDialog.this.jointAnalysisIndex) {
                        Object object;
                        int n;
                        Table table = JointDialog.this.domain.getMarginal(nodeList);
                        JointDialog.this.jointTableModel.resize(table.getSize(), nodeList.size() + 1);
                        for (n = 0; n < nodeList.size(); ++n) {
                            object = HuginGUIUtils.getNodeTitle((Node)nodeList.get(n));
                            JointDialog.this.jointTableModel.setColumnName(n, (String)object);
                        }
                        JointDialog.this.jointTableModel.setColumnName(nodeList.size(), HuginGUIConstants.get("Joint_Probability_of_configurations"));
                        for (n = 0; n < table.getSize(); ++n) {
                            object = new int[nodeList.size()];
                            table.getConfiguration((int[])object, n);
                            for (int i = 0; i < nodeList.size(); ++i) {
                                String string = HuginGUIUtils.getNodeStateLabel((Node)nodeList.get(i), (int)object[i]);
                                JointDialog.this.jointTableModel.setValueAt(string, n, i);
                            }
                            Double d = new Double(HuginGUIUtils.printDouble(table.getDataItem(n), JointDialog.this.projectFrame.guiFrame.preferences.precision));
                            JointDialog.this.jointTableModel.setValueAt(d, n, nodeList.size());
                        }
                        JointDialog.this.jointTableModel.fireTableStructureChanged();
                        table.delete();
                    } else if (JointDialog.this.tabs.getSelectedIndex() == JointDialog.this.kMostIndex) {
                        Object object;
                        int n;
                        JointDialog.this.domain.findMAPConfigurations(nodeList, JointDialog.this.pThreshold.getNumber());
                        int n2 = JointDialog.this.domain.getNumberOfMAPConfigurations();
                        JointDialog.this.kMostTableModel.resize(n2, nodeList.size() + 1);
                        for (n = 0; n < nodeList.size(); ++n) {
                            object = HuginGUIUtils.getNodeTitle((Node)nodeList.get(n));
                            JointDialog.this.kMostTableModel.setColumnName(n, (String)object);
                        }
                        JointDialog.this.kMostTableModel.setColumnName(nodeList.size(), HuginGUIConstants.get("Joint_Probability_of_kmost_configurations"));
                        for (n = 0; n < n2; ++n) {
                            object = JointDialog.this.domain.getMAPConfiguration(n);
                            for (int i = 0; i < nodeList.size(); ++i) {
                                String string = HuginGUIUtils.getNodeStateLabel((Node)nodeList.get(i), (int)object[i]);
                                JointDialog.this.kMostTableModel.setValueAt(string, n, i);
                            }
                            Double d = new Double(HuginGUIUtils.printDouble(JointDialog.this.domain.getProbabilityOfMAPConfiguration(n), JointDialog.this.projectFrame.guiFrame.preferences.precision));
                            JointDialog.this.kMostTableModel.setValueAt(d, n, nodeList.size());
                        }
                        JointDialog.this.kMostTableModel.fireTableStructureChanged();
                    }
                }
                catch (ExceptionMemory exceptionMemory) {
                    new HuginGUIError(exceptionMemory.getMessage());
                }
                catch (ExceptionHugin exceptionHugin) {
                    new HuginGUIError(exceptionHugin.getMessage());
                    exceptionHugin.printStackTrace();
                }
            }
        });
        return jButton;
    }

    @Override
    protected Vector<HuginAnalysisDialog.ListItem> customGroupNodes(Node node) {
        Vector<HuginAnalysisDialog.ListItem> vector = new Vector<HuginAnalysisDialog.ListItem>();
        BeliefBarPanel beliefBarPanel = this.projectFrame.getBeliefBarPanel();
        try {
            for (Node node2 : beliefBarPanel.getDomain().getNodes()) {
                if (!(node2 instanceof DiscreteChanceNode) || node2 == node || node2.evidenceIsEntered()) continue;
                vector.add(new HuginAnalysisDialog.ListItem(this, (DiscreteChanceNode)node2));
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
        return vector;
    }

    private NodeList getSelectedVariables() {
        NodeList nodeList = new NodeList();
        if (this.checks != null) {
            if (this.checks[this.checks.length - 1].isSelected()) {
                for (Object object : this.customGroupData) {
                    nodeList.add((DiscreteChanceNode)((HuginAnalysisDialog.ListItem)object).getNode());
                }
            }
            for (int i = 0; i < this.checks.length - 1; ++i) {
                if (!this.checks[i].isSelected()) continue;
                for (Node node : this.groups[i].getNodes()) {
                    try {
                        if (!(node instanceof DiscreteChanceNode) || node.evidenceIsEntered() || nodeList.contains(node)) continue;
                        nodeList.add(node);
                    }
                    catch (ExceptionHugin exceptionHugin) {
                        new HuginGUIError(exceptionHugin.getMessage());
                    }
                }
            }
        }
        return nodeList;
    }
}

