/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.Clique;
import COM.hugin.HGUI.CliqueEvent;
import COM.hugin.HGUI.CliqueSelectionListener;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.JunctionTreeEvent;
import COM.hugin.HGUI.JunctionTreeLayout;
import COM.hugin.HGUI.JunctionTreeListener;
import COM.hugin.HGUI.JunctionTreeModel;
import COM.hugin.HGUI.zoom.ZoomableComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JunctionTree
extends JPanel
implements ZoomableComponent {
    private JunctionTreeModel model;
    private CliqueSelectionListener selectionListener;
    private LinkedList<JunctionTreeListener> jtListeners;
    private int index = 0;
    private JunctionTreeStatusBar statusBar;
    private double scaleFactor = 1.0;
    private boolean isID = false;
    private LinkedList<Clique> selectedCliques = null;

    public JunctionTree(COM.hugin.HAPI.JunctionTree junctionTree, int n) throws ExceptionHugin {
        this(junctionTree, n, false);
    }

    public JunctionTree(COM.hugin.HAPI.JunctionTree junctionTree, int n, boolean bl) throws ExceptionHugin {
        super(new JunctionTreeLayout());
        this.model = new JunctionTreeModel(junctionTree);
        this.index = n;
        this.setBackground(Color.white);
        this.initSelectionListener();
        this.addCliques(this.model.getRoot(), bl);
        this.jtListeners = new LinkedList();
        this.selectedCliques = new LinkedList();
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                for (Clique clique : JunctionTree.this.selectedCliques) {
                    clique.setSelected(false);
                }
                JunctionTree.this.selectedCliques.clear();
                try {
                    JunctionTree.this.fireSelectionChanged(JunctionTree.this.selectedCliques);
                }
                catch (ExceptionHugin exceptionHugin) {
                    new HuginGUIError(exceptionHugin);
                }
            }
        });
        this.statusBar = new JunctionTreeStatusBar(this);
    }

    private void initSelectionListener() {
        this.selectionListener = new CliqueSelectionListener(){

            public void selectionChanged(CliqueEvent cliqueEvent) {
                block6: {
                    block5: {
                        if (cliqueEvent.getID() == 0) break block5;
                        if (cliqueEvent.getID() != 1) break block6;
                    }
                    Clique clique = (Clique)cliqueEvent.getSource();
                    try {
                        if (cliqueEvent.getID() == 0) {
                            for (Clique clique2 : JunctionTree.this.selectedCliques) {
                                if (clique2 == clique) continue;
                                clique2.setSelected(false);
                            }
                            JunctionTree.this.selectedCliques.clear();
                        }
                        clique.setSelected(true);
                        JunctionTree.this.selectedCliques.add(clique);
                        JunctionTree.this.fireSelectionChanged(JunctionTree.this.selectedCliques);
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                    }
                    JunctionTree.this.repaint();
                }
            }
        };
    }

    public void setID(boolean bl) throws ExceptionHugin {
        this.isID = bl;
        this.model.setID(bl);
        this.model.getRoot().setID(bl);
        this.setRoot(this.model.getRoot());
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public void setRoot(Clique clique) throws ExceptionHugin {
        int n = this.getRoot().getEvidenceMode();
        this.model.setRoot(clique);
        this.removeAll();
        this.addCliques(this.model.getRoot());
        this.getRoot().setScaleFactor(this.scaleFactor);
        this.getRoot().setEvidenceMode(n);
        this.setBounds(0, 0, this.getPreferredSize().width, this.getPreferredSize().height);
    }

    public Clique getRoot() {
        return this.model.getRoot();
    }

    public COM.hugin.HAPI.JunctionTree getAPIJunctionTree() {
        return this.model.getAPIJunctionTree();
    }

    @Override
    public String getName() {
        return "- " + this.index + " -";
    }

    public int getIndex() {
        return this.index;
    }

    public JunctionTreeModel getModel() {
        return this.model;
    }

    public void writeStatus(String string) {
        this.statusBar.writeText(string);
    }

    private void addCliques(Clique clique) {
        this.addCliques(clique, false);
    }

    private void addCliques(Clique clique, boolean bl) {
        this.add(clique);
        clique.addSelectionListener(this.selectionListener);
        if (bl) {
            clique.setPrintable();
        }
        if (clique.getLink() != null) {
            this.add(clique.getLink());
        }
        if (clique.getChildren() == null) {
            return;
        }
        for (Clique clique2 : clique.getChildren()) {
            this.addCliques(clique2, bl);
        }
    }

    public void addJunctionTreeListener(JunctionTreeListener junctionTreeListener) {
        if (!this.jtListeners.contains(junctionTreeListener)) {
            this.jtListeners.add(junctionTreeListener);
        }
    }

    public void removeJunctionTreeListener(JunctionTreeListener junctionTreeListener) {
        this.jtListeners.remove(junctionTreeListener);
    }

    protected void fireSelectionChanged(LinkedList<Clique> linkedList) throws ExceptionHugin {
        NodeList nodeList = new NodeList();
        for (Clique object : linkedList) {
            for (Node node : object.getMembers()) {
                if (nodeList.contains(node)) continue;
                nodeList.add(node);
            }
        }
        JunctionTreeEvent junctionTreeEvent = new JunctionTreeEvent(this, 0, nodeList);
        for (JunctionTreeListener junctionTreeListener : this.jtListeners) {
            junctionTreeListener.stateChanged(junctionTreeEvent);
        }
    }

    @Override
    public double getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public void setScaleFactor(double d) {
        this.scaleFactor = d;
        this.invalidate();
        ((JunctionTreeLayout)this.getLayout()).setScaleFactor(d);
        this.model.getRoot().setScaleFactor(d);
        this.setBounds(0, 0, this.getPreferredSize().width, this.getPreferredSize().height);
        this.validate();
    }

    public Clique makeActiveCliqueRoot() throws ExceptionHugin {
        this.setRoot(this.selectedCliques.getFirst());
        this.update();
        return this.model.getRoot();
    }

    public double getConflict() throws ExceptionHugin {
        return this.model.getConflict();
    }

    public double getMaxConflict() throws ExceptionHugin {
        return this.model.getRoot().getModel().getMaxConflict();
    }

    public NodeList getNodes() throws ExceptionHugin {
        return this.model.getNodes();
    }

    public LinkedList<Clique> getSelected() {
        return new LinkedList<Clique>(this.selectedCliques);
    }

    protected JunctionTreeStatusBar getStatusBar() {
        return this.statusBar;
    }

    protected int getNumberOfCliques() {
        return this.model.getNumberOfCliques();
    }

    public void setEvidenceMode(int n) {
        this.model.getRoot().setEvidenceMode(n);
        this.update();
    }

    public void update() {
        this.revalidate();
        this.repaint();
    }

    public int getMaxCliqueWidth() {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        this.model.getRoot().getMaxCliqueWidth(linkedList, 0);
        int n = 0;
        for (Integer n2 : linkedList) {
            n = Math.max(n, n2);
        }
        return n;
    }

    public int getTreeDepth() throws ExceptionHugin {
        return this.getModel().getDepth();
    }

    public static void paintConflictBar(Graphics graphics, double d, double d2, int n, int n2, boolean bl) {
        int n3 = 4;
        int n4 = 1 + (int)d2;
        int n5 = n - (int)Math.rint(2 * n3);
        graphics.setColor(Color.black);
        if (bl) {
            graphics.setColor(UIManager.getDefaults().getColor("Panel.background"));
            graphics.fillRect(0, 0, n, n2);
            return;
        }
        if (d2 < Double.POSITIVE_INFINITY) {
            int n6;
            if (d != 0.0) {
                int n7;
                n6 = Math.max(n / 2, n / 2 + (int)Math.rint((double)(n5 / 2) * d / (double)n4));
                for (int i = n7 = Math.min(n / 2, n / 2 + (int)Math.rint((double)(n5 / 2) * d / (double)n4)); i < n6; ++i) {
                    int n8 = i < n / 2 ? (int)Math.max(0.0, Math.min(255.0, Math.rint(255 - 255 * Math.abs(i - n / 2) / (n5 / 2)))) : 255;
                    int n9 = i > n / 2 ? (int)Math.max(0.0, Math.min(255.0, Math.rint(255 - 255 * (i - n / 2) / (n5 / 2)))) : 255;
                    graphics.setColor(new Color(n8, n9, 0));
                    graphics.drawLine(i, 0, i, (int)Math.rint((double)n2 / 2.5));
                }
                graphics.setColor(Color.black);
            }
            graphics.drawLine(n3, (int)Math.rint((double)n2 / 2.5), n - n3, (int)Math.rint((double)n2 / 2.5));
            for (n6 = 0; n6 < 3; ++n6) {
                graphics.drawLine(n3 + (int)Math.rint((double)(n6 * (n - n3 * 2)) / 2.0), 0, n3 + (int)Math.rint((double)(n6 * (n - n3 * 2)) / 2.0), (int)Math.rint(n2 / 2));
            }
            graphics.setFont(graphics.getFont().deriveFont(9.0f));
            String string = "-" + n4;
            graphics.drawString(string, n3, n2 - 2);
            string = "0";
            n6 = SwingUtilities.computeStringWidth(graphics.getFontMetrics(), string);
            graphics.drawString(string, (n - n6) / 2, n2 - 2);
            string = "" + n4;
            n6 = SwingUtilities.computeStringWidth(graphics.getFontMetrics(), string);
            graphics.drawString(string, n - n3 - n6, n2 - 2);
        } else {
            graphics.setFont(graphics.getFont().deriveFont(9.0f));
            String string = "";
            if (d == Double.NEGATIVE_INFINITY) {
                string = string + "-infinify";
            }
            if (d == Double.POSITIVE_INFINITY) {
                string = string + "infinify";
            }
            graphics.drawString(string, n3, n2 - 5);
        }
    }

    private class JunctionTreeConflictBar
    extends JPanel {
        private JunctionTree tree;
        private int width = 100;
        private int height = 20;

        public JunctionTreeConflictBar(JunctionTree junctionTree2) {
            this.tree = junctionTree2;
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.width, this.height);
        }

        public String getToolTipText() {
            try {
                double d = this.tree.getConflict();
                boolean bl = Math.abs(d) < 0.001;
                return HuginGUIConstants.get("CONFLICT_LABEL") + HuginGUIUtils.printDouble(d, 3, bl);
            }
            catch (Exception exception) {
                return "";
            }
        }

        public void paintComponent(Graphics graphics) {
            graphics.setColor(UIManager.getDefaults().getColor("Panel.background"));
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            try {
                if (this.tree.getModel().cgEvidenceIsPropagated()) {
                    JunctionTree.paintConflictBar(graphics, 0.0, 0.0, this.getWidth(), this.getHeight(), true);
                } else {
                    JunctionTree.paintConflictBar(graphics, this.tree.getConflict(), this.tree.getMaxConflict(), this.getWidth(), this.getHeight(), JunctionTree.this.isID);
                }
            }
            catch (ExceptionHugin exceptionHugin) {
                // empty catch block
            }
        }
    }

    private class JunctionTreeStatusBar
    extends JPanel {
        private JunctionTree tree;
        private JTextField msg;
        private JunctionTreeConflictBar conflictBar;

        public JunctionTreeStatusBar(JunctionTree junctionTree2) {
            super(new BorderLayout());
            this.tree = junctionTree2;
            this.conflictBar = new JunctionTreeConflictBar(junctionTree2);
            this.conflictBar.setBorder(BorderFactory.createLoweredBevelBorder());
            this.add((Component)this.conflictBar, "East");
            this.msg = new JTextField();
            this.msg.setEditable(false);
            this.msg.setEnabled(false);
            this.msg.setBorder(BorderFactory.createLoweredBevelBorder());
            this.msg.setDisabledTextColor(Color.black);
            this.add(this.msg);
        }

        public void clearText() {
            this.msg.setText("");
        }

        public void writeText(String string) {
            this.msg.setText(string);
        }
    }
}

