/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Class;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionIO;
import COM.hugin.HAPI.ExceptionInvalidProbabilityPotential;
import COM.hugin.HAPI.ExceptionMemory;
import COM.hugin.HAPI.ExceptionObjectNotAlive;
import COM.hugin.HAPI.ExceptionUsage;
import COM.hugin.HAPI.Node;
import COM.hugin.HGUI.AnalysisWizard;
import COM.hugin.HGUI.CasePreprocess;
import COM.hugin.HGUI.DataAcquisitionPanel;
import COM.hugin.HGUI.DataDependencesPanel;
import COM.hugin.HGUI.DataPreprocessingPanel;
import COM.hugin.HGUI.DataSource;
import COM.hugin.HGUI.DataSourceException;
import COM.hugin.HGUI.DataStream;
import COM.hugin.HGUI.DatabaseConfigurationPanel;
import COM.hugin.HGUI.DatabaseDataSource;
import COM.hugin.HGUI.DatabaseException;
import COM.hugin.HGUI.DatabaseJoin;
import COM.hugin.HGUI.EMLearningPanel;
import COM.hugin.HGUI.HelpPanel;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.JDBCDataSource;
import COM.hugin.HGUI.NetworkNamingPane;
import COM.hugin.HGUI.ODBCDataSource;
import COM.hugin.HGUI.OracleDataSource;
import COM.hugin.HGUI.PreProcessingException;
import COM.hugin.HGUI.Preferences;
import COM.hugin.HGUI.PriorDistributionsPanel;
import COM.hugin.HGUI.PronelLearningPanel;
import COM.hugin.HGUI.SampleCasesProcess;
import COM.hugin.HGUI.StreamData;
import COM.hugin.HGUI.StructuralConstraintsPanel;
import COM.hugin.HGUI.StructuralLearningPanel;
import COM.hugin.HGUI.TextfileDataSource;
import COM.hugin.HGUI.Variable;
import COM.hugin.HGUI.WizardError;
import COM.hugin.HGUI.WizardPanel;
import COM.hugin.HGUI.WizardStatus;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileNotFoundException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LearningWizard
extends JDialog {
    String networkName = "wizard";
    DataAcquisitionPanel page1 = null;
    DatabaseConfigurationPanel page2 = null;
    DataPreprocessingPanel page3b = null;
    StructuralConstraintsPanel page4 = null;
    StructuralLearningPanel page5 = null;
    PronelLearningPanel page6 = null;
    DataDependencesPanel page7 = null;
    PriorDistributionsPanel page8 = null;
    EMLearningPanel page9 = null;
    private WizardPanel currentPanel = null;
    static final int NEXT_BUTTON = 2;
    DataSource dataSource = null;
    DataStream dataStream = null;
    Preferences prefs = null;
    String driverdir = "";
    HelpPanel helpPanel;
    Domain domain;
    LoadData loader = null;
    Connect connecter = null;
    RetrieveData retriever = null;
    boolean stop = true;
    boolean existingDomain;
    AnalysisWizard aw;
    boolean finished = false;
    String filename;
    WizardStatus status;
    int activeStep = 0;
    JFrame owner;
    private ChangeListener casesListener;

    public LearningWizard(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.owner = jFrame;
        this.domain = null;
        this.driverdir = "";
        this.filename = "";
        this.existingDomain = false;
        this.aw = null;
        WizardPanel.setWizardSize(new Dimension(620, 550));
        this.status = new WizardStatus(new String[]{"Data Acquisition", "Data Preprocessing", "Structure Constraints", "Structure Learning", "Structure Uncertainties", "Data Dependences", "Prior Distribution Knowledge", "EM-Learning"}, Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("images/structuralWizard.png")));
        this.page1 = this.getAcquisitionPanel();
        this.page1.setStatus(this.status);
        this.status.setActiveStep(0);
        this.currentPanel = this.page1;
        this.helpPanel = new HelpPanel(this);
        this.getContentPane().add(this.page1);
        this.pack();
        if (System.getProperty("os.name").equals("Linux")) {
            this.setSize((int)this.getPreferredSize().getWidth() + 10, (int)this.getPreferredSize().getHeight() + 30);
        }
        this.addKeyListener(new WizardKeyListener());
        this.setResizable(true);
        this.addComponentListener(new ResizedListener(this));
    }

    public LearningWizard(JFrame jFrame, Preferences preferences) {
        super((Frame)jFrame, true);
        this.domain = null;
        this.prefs = preferences;
        this.driverdir = preferences.driverdir;
        this.existingDomain = false;
        this.aw = null;
        this.filename = "";
        WizardPanel.setWizardSize(new Dimension(620, 550));
        this.status = new WizardStatus(new String[]{"Data Acquisition", "Data Preprocessing", "Structure Constraints", "Structure Learning", "Structure Uncertainties", "Data Dependences", "Prior Distribution Knowledge", "EM-Learning"}, Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("images/structuralWizard.png")));
        this.page1 = this.getAcquisitionPanel();
        this.page1.setStatus(this.status);
        this.status.setActiveStep(0);
        this.currentPanel = this.page1;
        this.helpPanel = new HelpPanel(this);
        this.getContentPane().add(this.page1);
        this.pack();
        if (System.getProperty("os.name").equals("Linux")) {
            this.setSize((int)this.getPreferredSize().getWidth() + 10, (int)this.getPreferredSize().getHeight() + 30);
        }
        this.addKeyListener(new WizardKeyListener());
        this.setResizable(true);
        this.addComponentListener(new ResizedListener(this));
    }

    public LearningWizard(JDialog jDialog, Preferences preferences, Domain domain, ChangeListener changeListener) {
        super((Dialog)jDialog, true);
        this.domain = domain;
        this.existingDomain = true;
        this.prefs = preferences;
        this.driverdir = preferences.driverdir;
        this.casesListener = changeListener;
        this.filename = "";
        WizardPanel.setWizardSize(new Dimension(620, 550));
        this.status = new WizardStatus(new String[]{"Data Acquisition", "Data Preprocessing"}, Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("images/structuralWizard.png")));
        this.page1 = this.getAcquisitionPanel();
        this.page1.setStatus(this.status);
        this.status.setActiveStep(0);
        this.currentPanel = this.page1;
        this.helpPanel = new HelpPanel(this);
        this.getContentPane().add(this.page1);
        this.pack();
        if (System.getProperty("os.name").equals("Linux")) {
            this.setSize((int)this.getPreferredSize().getWidth() + 10, (int)this.getPreferredSize().getHeight() + 30);
        }
        this.addKeyListener(new WizardKeyListener());
        this.setResizable(true);
        this.addComponentListener(new ResizedListener(this));
    }

    public String getTitle() {
        if (this.existingDomain) {
            return HuginGUIConstants.get("str_data_acquisition");
        }
        return HuginGUIConstants.get("str_learning_wizard");
    }

    public Dimension getPreferredSize() {
        return new Dimension(620, 550);
    }

    protected Domain getDomain() {
        if (!this.finished) {
            return null;
        }
        return this.domain;
    }

    protected Class getResult() throws ExceptionObjectNotAlive, ExceptionHugin {
        if (!this.finished) {
            return null;
        }
        Domain domain = null;
        if (this.page8 != null) {
            domain = this.page8.getDomain();
        } else if (this.page7 != null) {
            domain = this.page7.getDomain();
        } else if (this.page5 != null) {
            domain = this.page5.getDomain();
        }
        String string = domain.getLogFile();
        domain.closeLogFile();
        Class clazz = Hugin.mainFrame.cc.addDomain(domain, this.networkName);
        clazz.openLogFile(string, true);
        return clazz;
    }

    private DataAcquisitionPanel getAcquisitionPanel() {
        JButton[] jButtonArray = new JButton[4];
        jButtonArray[0] = new JButton("Help");
        jButtonArray[0].addActionListener(new HelpListener("help/dataAcquisitionHelp.html"));
        jButtonArray[0].setEnabled(true);
        jButtonArray[1] = new JButton("< Back");
        jButtonArray[1].setEnabled(false);
        jButtonArray[2] = new JButton("Next >");
        jButtonArray[2].setEnabled(false);
        jButtonArray[2].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearningWizard.this.connecter = new Connect(LearningWizard.this.page1);
                LearningWizard.this.connecter.start();
            }
        });
        jButtonArray[3] = new JButton("Cancel");
        jButtonArray[3].addActionListener(new CancelListener());
        DataAcquisitionPanel dataAcquisitionPanel = new DataAcquisitionPanel(jButtonArray, 2);
        dataAcquisitionPanel.setPreferences(this.prefs);
        return dataAcquisitionPanel;
    }

    private DatabaseConfigurationPanel getDatabaseConfigPanel() {
        JButton[] jButtonArray = new JButton[4];
        jButtonArray[0] = new JButton("Help");
        jButtonArray[0].addActionListener(new HelpListener("help/databaseConfigurationHelp.html"));
        jButtonArray[0].setEnabled(true);
        jButtonArray[1] = new JButton("< Back");
        jButtonArray[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearningWizard.this.page2.back();
                try {
                    LearningWizard.this.dataStream.removeCasePreprocess(new SampleCasesProcess());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LearningWizard.this.status.removeItemAt(1);
                LearningWizard.this.currentPanel = LearningWizard.this.page1;
                LearningWizard.this.activeStep = 0;
                LearningWizard.this.currentPanel.setStatus(LearningWizard.this.status);
                LearningWizard.this.status.setActiveStep(LearningWizard.this.activeStep);
                LearningWizard.this.getContentPane().invalidate();
                LearningWizard.this.getContentPane().removeAll();
                LearningWizard.this.getContentPane().add(LearningWizard.this.page1);
                LearningWizard.this.validate();
                LearningWizard.this.repaint();
            }
        });
        jButtonArray[2] = new JButton("Next >");
        jButtonArray[2].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearningWizard.this.retriever = new RetrieveData(LearningWizard.this.page2);
                LearningWizard.this.retriever.start();
            }
        });
        jButtonArray[3] = new JButton("Cancel");
        jButtonArray[3].addActionListener(new CancelListener());
        return new DatabaseConfigurationPanel(jButtonArray, 2, this);
    }

    private DataPreprocessingPanel getDataPreprocessingPanel() {
        JButton[] jButtonArray = new JButton[4];
        Object var2_2 = null;
        jButtonArray[0] = new JButton("Help");
        jButtonArray[0].addActionListener(new HelpListener("help/dataPreprocessingHelp.html"));
        jButtonArray[0].setEnabled(true);
        jButtonArray[1] = new JButton("< Back");
        jButtonArray[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (LearningWizard.this.loader != null) {
                    LearningWizard.this.loader.stopLoading();
                    LearningWizard.this.loader = null;
                }
                if (LearningWizard.this.existingDomain) {
                    LearningWizard.this.page3b.back(false);
                } else {
                    LearningWizard.this.page3b.back();
                }
                LearningWizard.this.currentPanel = LearningWizard.this.page3b.getPrevious();
                int n = LearningWizard.this.activeStep = LearningWizard.this.currentPanel == LearningWizard.this.page2 ? 1 : 0;
                if (LearningWizard.this.activeStep == 0) {
                    try {
                        LearningWizard.this.dataStream.removeCasePreprocess(new SampleCasesProcess());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                LearningWizard.this.status.setActiveStep(LearningWizard.this.activeStep);
                LearningWizard.this.currentPanel.setStatus(LearningWizard.this.status);
                LearningWizard.this.getContentPane().invalidate();
                LearningWizard.this.getContentPane().removeAll();
                LearningWizard.this.getContentPane().add(LearningWizard.this.page3b.getPrevious());
                LearningWizard.this.validate();
                LearningWizard.this.repaint();
            }
        });
        jButtonArray[2] = this.existingDomain ? new JButton("Finish") : new JButton("Next >");
        jButtonArray[2].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (LearningWizard.this.existingDomain) {
                        LearningWizard.this.loader = new LoadData(LearningWizard.this.page3b);
                        LearningWizard.this.loader.start();
                    } else {
                        Domain domain = LearningWizard.this.dataStream.getCaseTemplate().getDomain();
                        domain.openLogFile(Hugin.mainFrame.getLogFileDir() + LearningWizard.this.networkName + ".hlg");
                        LearningWizard.this.page3b.insertCases();
                        LearningWizard.this.page4 = LearningWizard.this.getStructuralConstraintsPanel(domain);
                        LearningWizard.this.currentPanel = LearningWizard.this.page4;
                        LearningWizard.this.page4.setPrevious(LearningWizard.this.page3b);
                        LearningWizard.this.page4.setStatus(LearningWizard.this.status);
                        LearningWizard.this.status.setActiveStep(++LearningWizard.this.activeStep);
                        LearningWizard.this.getContentPane().removeAll();
                        LearningWizard.this.getContentPane().add(LearningWizard.this.page4);
                        LearningWizard.this.validate();
                        LearningWizard.this.repaint();
                    }
                }
                catch (ExceptionMemory exceptionMemory) {
                    new HuginGUIError(exceptionMemory.getMessage());
                    LearningWizard.this.getContentPane().invalidate();
                    LearningWizard.this.getContentPane().removeAll();
                    LearningWizard.this.getContentPane().add(LearningWizard.this.page3b);
                    LearningWizard.this.validate();
                    LearningWizard.this.repaint();
                }
                catch (DataSourceException dataSourceException) {
                    new HuginGUIError(dataSourceException.getMessage());
                    LearningWizard.this.getContentPane().invalidate();
                    LearningWizard.this.getContentPane().removeAll();
                    LearningWizard.this.getContentPane().add(LearningWizard.this.page3b);
                    LearningWizard.this.validate();
                    LearningWizard.this.repaint();
                }
                catch (PreProcessingException preProcessingException) {
                    new HuginGUIError(preProcessingException.getMessage());
                    LearningWizard.this.getContentPane().invalidate();
                    LearningWizard.this.getContentPane().removeAll();
                    LearningWizard.this.getContentPane().add(LearningWizard.this.page3b);
                    LearningWizard.this.validate();
                    LearningWizard.this.repaint();
                }
                catch (ExceptionIO exceptionIO) {
                    new HuginGUIError(exceptionIO.getMessage() + HuginGUIConstants.get("str_lb_lb_this_io_not_able_open_log_file_") + Hugin.mainFrame.getLogFileDir() + LearningWizard.this.networkName + ".hlg");
                    LearningWizard.this.getContentPane().invalidate();
                    LearningWizard.this.getContentPane().removeAll();
                    LearningWizard.this.getContentPane().add(LearningWizard.this.page3b);
                    LearningWizard.this.validate();
                    LearningWizard.this.repaint();
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                    LearningWizard.this.getContentPane().invalidate();
                    LearningWizard.this.getContentPane().removeAll();
                    LearningWizard.this.getContentPane().add(LearningWizard.this.page3b);
                    LearningWizard.this.validate();
                    LearningWizard.this.repaint();
                }
            }
        });
        jButtonArray[3] = new JButton("Cancel");
        jButtonArray[3].addActionListener(new CancelListener());
        DataPreprocessingPanel dataPreprocessingPanel = new DataPreprocessingPanel(jButtonArray, 2, true, this.existingDomain);
        dataPreprocessingPanel.setPreferences(this.prefs);
        return dataPreprocessingPanel;
    }

    private StructuralConstraintsPanel getStructuralConstraintsPanel(Domain domain) throws ExceptionHugin {
        JButton[] jButtonArray = new JButton[4];
        jButtonArray[0] = new JButton("Help");
        jButtonArray[0].addActionListener(new HelpListener("help/structuralConstraintsHelp.html"));
        jButtonArray[0].setEnabled(true);
        jButtonArray[1] = new JButton("< Back");
        jButtonArray[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearningWizard.this.page4.back();
                LearningWizard.this.currentPanel = LearningWizard.this.page4.getPrevious();
                --LearningWizard.this.activeStep;
                LearningWizard.this.status.setActiveStep(LearningWizard.this.activeStep);
                LearningWizard.this.currentPanel.setStatus(LearningWizard.this.status);
                LearningWizard.this.getContentPane().invalidate();
                LearningWizard.this.getContentPane().removeAll();
                LearningWizard.this.getContentPane().add(LearningWizard.this.page4.getPrevious());
                LearningWizard.this.validate();
                LearningWizard.this.repaint();
            }
        });
        jButtonArray[2] = new JButton("Next >");
        jButtonArray[2].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearningWizard.this.page5 = LearningWizard.this.getStructuralLearningPanel();
                LearningWizard.this.currentPanel = LearningWizard.this.page5;
                LearningWizard.this.page5.setPrevious(LearningWizard.this.page4);
                LearningWizard.this.page5.setStatus(LearningWizard.this.status);
                LearningWizard.this.status.setActiveStep(++LearningWizard.this.activeStep);
                LearningWizard.this.getContentPane().removeAll();
                LearningWizard.this.getContentPane().add(LearningWizard.this.page5);
                LearningWizard.this.validate();
                LearningWizard.this.repaint();
            }
        });
        jButtonArray[3] = new JButton("Cancel");
        jButtonArray[3].addActionListener(new CancelListener());
        return new StructuralConstraintsPanel(domain, jButtonArray);
    }

    private StructuralLearningPanel getStructuralLearningPanel() {
        JButton[] jButtonArray = new JButton[4];
        jButtonArray[0] = new JButton("Help");
        jButtonArray[0].addActionListener(new HelpListener("help/structuralLearningHelp.html"));
        jButtonArray[0].setEnabled(true);
        jButtonArray[1] = new JButton("< Back");
        jButtonArray[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearningWizard.this.page5.back();
                LearningWizard.this.page4.reinitialize();
                LearningWizard.this.currentPanel = LearningWizard.this.page4;
                --LearningWizard.this.activeStep;
                LearningWizard.this.status.setActiveStep(LearningWizard.this.activeStep);
                LearningWizard.this.currentPanel.setStatus(LearningWizard.this.status);
                LearningWizard.this.getContentPane().invalidate();
                LearningWizard.this.getContentPane().removeAll();
                if (LearningWizard.this.page7 != null) {
                    LearningWizard.this.page4.setNetworkPanel(LearningWizard.this.page7.getNetworkPanel());
                }
                if (LearningWizard.this.page6 != null) {
                    try {
                        double d = LearningWizard.this.page6.getNetworkPanel().getScaleFactor();
                        LearningWizard.this.page4.getNetworkPanel().setScaleFactor(1.0, false);
                        LearningWizard.this.page6.getNetworkPanel().setScaleFactor(1.0, true);
                        LearningWizard.this.page4.getNetworkPanel().settingsImported();
                        LearningWizard.this.page4.getNetworkPanel().setScaleFactor(d);
                    }
                    catch (Exception exception) {
                        new HuginGUIError(HuginGUIConstants.get("str_unable_to_transfer_model_information_back"));
                    }
                    LearningWizard.this.page4.getNetworkPanel().showGrid(LearningWizard.this.page6.getNetworkPanel().showGrid());
                    LearningWizard.this.page4.getNetworkPanel().snapToGrid(LearningWizard.this.page6.getNetworkPanel().snapToGrid());
                }
                LearningWizard.this.getContentPane().add(LearningWizard.this.page4);
                LearningWizard.this.validate();
                LearningWizard.this.repaint();
            }
        });
        jButtonArray[2] = new JButton("Next >");
        jButtonArray[2].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (LearningWizard.this.page5.getSkip()) {
                    try {
                        LearningWizard.this.page4.getNetworkPanel().writeConstraintsToDomain();
                        LearningWizard.this.page5.skipLearning((Domain)LearningWizard.this.page4.getNetworkPanel().getHome());
                        LearningWizard.this.finished = true;
                        LearningWizard.this.dispose();
                    }
                    catch (Exception exception) {
                        new HuginGUIError(HuginGUIConstants.get("str_unable_to_skip"));
                    }
                } else {
                    try {
                        int n = LearningWizard.this.page5.getSelectedLearningAlgorithm();
                        LearningWizard.this.page5.learnStructure(LearningWizard.this.dataStream, n);
                        switch (n) {
                            case 2: {
                                try {
                                    if (LearningWizard.unresolvedLinks(LearningWizard.this.page5.getDomain())) {
                                        LearningWizard.this.page6 = LearningWizard.this.getPronelLearningPanel(LearningWizard.this.page5.getDomain());
                                        LearningWizard.this.currentPanel = LearningWizard.this.page6;
                                        LearningWizard.this.page6.setPrevious(LearningWizard.this.page5);
                                        LearningWizard.this.page6.setStatus(LearningWizard.this.status);
                                        LearningWizard.this.status.setActiveStep(++LearningWizard.this.activeStep);
                                        double d = LearningWizard.this.page4.getNetworkPanel().getScaleFactor();
                                        LearningWizard.this.page6.getNetworkPanel().setScaleFactor(1.0, false);
                                        LearningWizard.this.page4.getNetworkPanel().setScaleFactor(1.0, true);
                                        LearningWizard.this.page6.getNetworkPanel().settingsImported();
                                        LearningWizard.this.page6.getNetworkPanel().setScaleFactor(d);
                                        LearningWizard.this.page6.getNetworkPanel().showGrid(LearningWizard.this.page4.getNetworkPanel().showGrid());
                                        LearningWizard.this.page6.getNetworkPanel().snapToGrid(LearningWizard.this.page4.getNetworkPanel().snapToGrid());
                                        LearningWizard.this.getContentPane().removeAll();
                                        LearningWizard.this.getContentPane().add(LearningWizard.this.page6);
                                        LearningWizard.this.page6.networkPanel.setGraphicsSize();
                                        break;
                                    }
                                    LearningWizard.this.page5.getDomain().decideAutomatically();
                                    LearningWizard.this.page7 = LearningWizard.this.getDataDependencesPanel(LearningWizard.this.page5.getDomain());
                                    LearningWizard.this.currentPanel = LearningWizard.this.page7;
                                    LearningWizard.this.page7.setPrevious(LearningWizard.this.page5);
                                    LearningWizard.this.page7.setStatus(LearningWizard.this.status);
                                    ++LearningWizard.this.activeStep;
                                    LearningWizard.this.status.setActiveStep(++LearningWizard.this.activeStep);
                                    double d = LearningWizard.this.page4.getNetworkPanel().getScaleFactor();
                                    LearningWizard.this.page7.getNetworkPanel().setScaleFactor(1.0, false);
                                    LearningWizard.this.page4.getNetworkPanel().setScaleFactor(1.0, true);
                                    LearningWizard.this.page7.getNetworkPanel().settingsImported();
                                    LearningWizard.this.page7.getNetworkPanel().setScaleFactor(d);
                                    LearningWizard.this.page7.getNetworkPanel().showGrid(LearningWizard.this.page4.getNetworkPanel().showGrid());
                                    LearningWizard.this.page7.getNetworkPanel().snapToGrid(LearningWizard.this.page4.getNetworkPanel().snapToGrid());
                                    LearningWizard.this.getContentPane().removeAll();
                                    LearningWizard.this.getContentPane().add(LearningWizard.this.page7);
                                }
                                catch (Exception exception) {
                                    new HuginGUIError(HuginGUIConstants.get("str_unable_to_run_npc_on_selected_data_reselect_algorithm"));
                                }
                                break;
                            }
                            case 1: 
                            case 4: 
                            case 5: {
                                LearningWizard.this.page7 = LearningWizard.this.getDataDependencesPanel(LearningWizard.this.page5.getDomain());
                                LearningWizard.this.currentPanel = LearningWizard.this.page7;
                                LearningWizard.this.page7.setPrevious(LearningWizard.this.page5);
                                LearningWizard.this.page7.setStatus(LearningWizard.this.status);
                                ++LearningWizard.this.activeStep;
                                LearningWizard.this.status.setActiveStep(++LearningWizard.this.activeStep);
                                double d = LearningWizard.this.page4.getNetworkPanel().getScaleFactor();
                                LearningWizard.this.page7.getNetworkPanel().setScaleFactor(1.0, false);
                                LearningWizard.this.page4.getNetworkPanel().setScaleFactor(1.0, true);
                                LearningWizard.this.page7.getNetworkPanel().settingsImported();
                                LearningWizard.this.page7.getNetworkPanel().setScaleFactor(d);
                                LearningWizard.this.page7.getNetworkPanel().showGrid(LearningWizard.this.page4.getNetworkPanel().showGrid());
                                LearningWizard.this.page7.getNetworkPanel().snapToGrid(LearningWizard.this.page4.getNetworkPanel().snapToGrid());
                                LearningWizard.this.getContentPane().removeAll();
                                LearningWizard.this.getContentPane().add(LearningWizard.this.page7);
                                break;
                            }
                            default: {
                                new HuginGUIError("LearningWizard.getStructuralLearningPanel()", HuginGUIConstants.get("str_unknown_algorithm"));
                            }
                        }
                        LearningWizard.this.validate();
                        LearningWizard.this.repaint();
                    }
                    catch (ExceptionMemory exceptionMemory) {
                        new HuginGUIError(exceptionMemory.getMessage());
                        LearningWizard.this.getContentPane().invalidate();
                        LearningWizard.this.getContentPane().removeAll();
                        LearningWizard.this.getContentPane().add(LearningWizard.this.page5);
                        LearningWizard.this.validate();
                        LearningWizard.this.repaint();
                    }
                    catch (ExceptionHugin exceptionHugin) {
                        new HuginGUIError(exceptionHugin.getMessage());
                        LearningWizard.this.getContentPane().invalidate();
                        LearningWizard.this.getContentPane().removeAll();
                        LearningWizard.this.getContentPane().add(LearningWizard.this.page5);
                        LearningWizard.this.validate();
                        LearningWizard.this.repaint();
                    }
                    catch (DataSourceException dataSourceException) {
                        WizardError.showError(HuginGUIConstants.get("str_error"), "Structure learning was not able to complete:\n" + dataSourceException.getMessage(), LearningWizard.this);
                        LearningWizard.this.getContentPane().invalidate();
                        LearningWizard.this.getContentPane().removeAll();
                        LearningWizard.this.getContentPane().add(LearningWizard.this.page5);
                        LearningWizard.this.validate();
                        LearningWizard.this.repaint();
                    }
                    catch (PreProcessingException preProcessingException) {
                        WizardError.showError(HuginGUIConstants.get("str_error"), "Structure learning was not able to complete:\n" + preProcessingException.getMessage(), LearningWizard.this);
                        LearningWizard.this.getContentPane().invalidate();
                        LearningWizard.this.getContentPane().removeAll();
                        LearningWizard.this.getContentPane().add(LearningWizard.this.page5);
                        LearningWizard.this.validate();
                        LearningWizard.this.repaint();
                    }
                }
            }
        });
        jButtonArray[3] = new JButton("Cancel");
        jButtonArray[3].addActionListener(new CancelListener());
        return new StructuralLearningPanel(this.page4.getNetworkPanel(), jButtonArray, 2);
    }

    private PronelLearningPanel getPronelLearningPanel(Domain domain) {
        JButton[] jButtonArray = new JButton[4];
        jButtonArray[0] = new JButton("Help");
        jButtonArray[0].addActionListener(new HelpListener("help/structuralUncertaintiesHelp.html"));
        jButtonArray[0].setEnabled(true);
        jButtonArray[1] = new JButton("< Back");
        jButtonArray[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearningWizard.this.page6.back();
                LearningWizard.this.currentPanel = LearningWizard.this.page5;
                --LearningWizard.this.activeStep;
                LearningWizard.this.status.setActiveStep(LearningWizard.this.activeStep);
                LearningWizard.this.currentPanel.setStatus(LearningWizard.this.status);
                LearningWizard.this.getContentPane().invalidate();
                LearningWizard.this.getContentPane().removeAll();
                LearningWizard.this.getContentPane().add(LearningWizard.this.page5);
                try {
                    double d = LearningWizard.this.page6.getNetworkPanel().getScaleFactor();
                    LearningWizard.this.page4.getNetworkPanel().setScaleFactor(1.0, false);
                    LearningWizard.this.page6.getNetworkPanel().setScaleFactor(1.0, true);
                    LearningWizard.this.page4.getNetworkPanel().settingsImported();
                    LearningWizard.this.page4.getNetworkPanel().setScaleFactor(d);
                    LearningWizard.this.page4.getNetworkPanel().showGrid(LearningWizard.this.page6.getNetworkPanel().showGrid());
                    LearningWizard.this.page4.getNetworkPanel().snapToGrid(LearningWizard.this.page6.getNetworkPanel().snapToGrid());
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
                LearningWizard.this.validate();
                LearningWizard.this.repaint();
            }
        });
        jButtonArray[2] = new JButton("Next >");
        jButtonArray[2].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    LearningWizard.this.page6.finish();
                    LearningWizard.this.page7 = LearningWizard.this.getDataDependencesPanel(LearningWizard.this.page6.getDomain());
                    LearningWizard.this.currentPanel = LearningWizard.this.page7;
                    LearningWizard.this.page7.setPrevious(LearningWizard.this.page5);
                    LearningWizard.this.page7.setStatus(LearningWizard.this.status);
                    LearningWizard.this.status.setActiveStep(++LearningWizard.this.activeStep);
                    double d = LearningWizard.this.page6.getNetworkPanel().getScaleFactor();
                    LearningWizard.this.page7.getNetworkPanel().setScaleFactor(1.0, false);
                    LearningWizard.this.page6.getNetworkPanel().setScaleFactor(1.0, true);
                    LearningWizard.this.page7.getNetworkPanel().settingsImported();
                    LearningWizard.this.page7.getNetworkPanel().setScaleFactor(d);
                    LearningWizard.this.page7.getNetworkPanel().showGrid(LearningWizard.this.page6.getNetworkPanel().showGrid());
                    LearningWizard.this.page7.getNetworkPanel().snapToGrid(LearningWizard.this.page6.getNetworkPanel().snapToGrid());
                    LearningWizard.this.getContentPane().removeAll();
                    LearningWizard.this.getContentPane().add(LearningWizard.this.page7);
                    LearningWizard.this.validate();
                    LearningWizard.this.repaint();
                }
                catch (ExceptionMemory exceptionMemory) {
                    new HuginGUIError(exceptionMemory.getMessage());
                    LearningWizard.this.getContentPane().invalidate();
                    LearningWizard.this.getContentPane().removeAll();
                    LearningWizard.this.getContentPane().add(LearningWizard.this.page6);
                    LearningWizard.this.validate();
                    LearningWizard.this.repaint();
                }
                catch (ExceptionHugin exceptionHugin) {
                    new HuginGUIError(exceptionHugin);
                    LearningWizard.this.getContentPane().invalidate();
                    LearningWizard.this.getContentPane().removeAll();
                    LearningWizard.this.getContentPane().add(LearningWizard.this.page6);
                    LearningWizard.this.validate();
                    LearningWizard.this.repaint();
                }
            }
        });
        jButtonArray[3] = new JButton("Cancel");
        jButtonArray[3].addActionListener(new CancelListener());
        return new PronelLearningPanel(domain, jButtonArray);
    }

    private DataDependencesPanel getDataDependencesPanel(Domain domain) {
        JButton[] jButtonArray = new JButton[5];
        jButtonArray[0] = new JButton("Help");
        jButtonArray[0].addActionListener(new HelpListener("help/dataDependencesHelp.html"));
        jButtonArray[0].setEnabled(true);
        jButtonArray[1] = new JButton("Finish");
        jButtonArray[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearningWizard.this.finished = true;
                LearningWizard.this.dispose();
            }
        });
        jButtonArray[2] = new JButton("< Back");
        jButtonArray[2].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearningWizard.this.page7.back();
                LearningWizard.this.currentPanel = LearningWizard.this.page7.getPrevious();
                --LearningWizard.this.activeStep;
                --LearningWizard.this.activeStep;
                LearningWizard.this.status.setActiveStep(LearningWizard.this.activeStep);
                LearningWizard.this.currentPanel.setStatus(LearningWizard.this.status);
                LearningWizard.this.getContentPane().invalidate();
                LearningWizard.this.getContentPane().removeAll();
                LearningWizard.this.getContentPane().add(LearningWizard.this.page7.getPrevious());
                if (LearningWizard.this.page6 != null) {
                    try {
                        double d = LearningWizard.this.page7.getNetworkPanel().getScaleFactor();
                        LearningWizard.this.page6.getNetworkPanel().setScaleFactor(1.0, false);
                        LearningWizard.this.page7.getNetworkPanel().setScaleFactor(1.0, true);
                        LearningWizard.this.page6.getNetworkPanel().settingsImported();
                        LearningWizard.this.page6.getNetworkPanel().setScaleFactor(d);
                    }
                    catch (Exception exception) {
                        new HuginGUIError(HuginGUIConstants.get("str_unable_to_transfer_model_information_back"));
                    }
                    LearningWizard.this.page6.getNetworkPanel().showGrid(LearningWizard.this.page7.getNetworkPanel().showGrid());
                    LearningWizard.this.page6.getNetworkPanel().snapToGrid(LearningWizard.this.page7.getNetworkPanel().snapToGrid());
                }
                LearningWizard.this.validate();
                LearningWizard.this.repaint();
            }
        });
        jButtonArray[3] = new JButton("Next >");
        jButtonArray[3].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                long l = LearningWizard.this.page7.getNetworkPanel().getModelSize();
                if (l > 50000000L && LearningWizard.this.dontProceed(l)) {
                    return;
                }
                try {
                    for (Node node : LearningWizard.this.page7.getDomain().getNodes()) {
                        if (!(node instanceof DiscreteChanceNode)) continue;
                        ((DiscreteChanceNode)node).getExperienceTable();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LearningWizard.this.page8 = LearningWizard.this.getPriorDistributionsPanel(LearningWizard.this.page7.getDomain());
                LearningWizard.this.currentPanel = LearningWizard.this.page8;
                LearningWizard.this.page8.setPrevious(LearningWizard.this.page7);
                LearningWizard.this.page8.setStatus(LearningWizard.this.status);
                LearningWizard.this.status.setActiveStep(++LearningWizard.this.activeStep);
                LearningWizard.this.getContentPane().removeAll();
                LearningWizard.this.getContentPane().add(LearningWizard.this.page8);
                LearningWizard.this.validate();
                LearningWizard.this.repaint();
            }
        });
        jButtonArray[4] = new JButton("Cancel");
        jButtonArray[4].addActionListener(new CancelListener());
        return new DataDependencesPanel(this.page4.getNetworkPanel(), jButtonArray);
    }

    private PriorDistributionsPanel getPriorDistributionsPanel(Domain domain) {
        JButton[] jButtonArray = new JButton[4];
        jButtonArray[0] = new JButton("Help");
        jButtonArray[0].addActionListener(new HelpListener("help/priorDistributionsHelp.html"));
        jButtonArray[0].setEnabled(true);
        jButtonArray[1] = new JButton("< Back");
        jButtonArray[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearningWizard.this.page8.back();
                LearningWizard.this.currentPanel = LearningWizard.this.page7;
                --LearningWizard.this.activeStep;
                LearningWizard.this.status.setActiveStep(LearningWizard.this.activeStep);
                LearningWizard.this.currentPanel.setStatus(LearningWizard.this.status);
                LearningWizard.this.getContentPane().invalidate();
                LearningWizard.this.getContentPane().removeAll();
                LearningWizard.this.getContentPane().add(LearningWizard.this.page8.getPrevious());
                LearningWizard.this.validate();
                LearningWizard.this.repaint();
            }
        });
        jButtonArray[2] = new JButton("Next >");
        jButtonArray[2].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearningWizard.this.page9 = LearningWizard.this.getEMLearningPanel(LearningWizard.this.page8.getDomain());
                LearningWizard.this.currentPanel = LearningWizard.this.page9;
                LearningWizard.this.page9.setPrevious(LearningWizard.this.page8);
                LearningWizard.this.page9.setStatus(LearningWizard.this.status);
                LearningWizard.this.status.setActiveStep(++LearningWizard.this.activeStep);
                LearningWizard.this.getContentPane().removeAll();
                LearningWizard.this.getContentPane().add(LearningWizard.this.page9);
                LearningWizard.this.validate();
                LearningWizard.this.repaint();
            }
        });
        jButtonArray[3] = new JButton("Cancel");
        jButtonArray[3].addActionListener(new CancelListener());
        return new PriorDistributionsPanel(domain, jButtonArray);
    }

    private EMLearningPanel getEMLearningPanel(Domain domain) {
        JButton[] jButtonArray = new JButton[4];
        jButtonArray[0] = new JButton("Help");
        jButtonArray[0].setEnabled(true);
        jButtonArray[0].addActionListener(new HelpListener("help/emLearningHelp.html"));
        jButtonArray[1] = new JButton("< Back");
        jButtonArray[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearningWizard.this.page9.back();
                LearningWizard.this.currentPanel = LearningWizard.this.page8;
                --LearningWizard.this.activeStep;
                LearningWizard.this.status.setActiveStep(LearningWizard.this.activeStep);
                LearningWizard.this.currentPanel.setStatus(LearningWizard.this.status);
                LearningWizard.this.getContentPane().invalidate();
                LearningWizard.this.getContentPane().removeAll();
                LearningWizard.this.getContentPane().add(LearningWizard.this.page9.getPrevious());
                LearningWizard.this.validate();
                LearningWizard.this.repaint();
            }
        });
        jButtonArray[2] = new JButton("Finish");
        jButtonArray[2].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    LearningWizard.this.page9.learnTables();
                    LearningWizard.this.finished = true;
                    LearningWizard.this.dispose();
                }
                catch (ExceptionInvalidProbabilityPotential exceptionInvalidProbabilityPotential) {
                    new HuginGUIError(exceptionInvalidProbabilityPotential.getMessage());
                    LearningWizard.this.getContentPane().invalidate();
                    LearningWizard.this.getContentPane().removeAll();
                    LearningWizard.this.getContentPane().add(LearningWizard.this.page5);
                    LearningWizard.this.validate();
                    LearningWizard.this.repaint();
                }
                catch (ExceptionMemory exceptionMemory) {
                    new HuginGUIError(exceptionMemory.getMessage());
                    LearningWizard.this.getContentPane().invalidate();
                    LearningWizard.this.getContentPane().removeAll();
                    LearningWizard.this.getContentPane().add(LearningWizard.this.page9);
                    LearningWizard.this.validate();
                    LearningWizard.this.repaint();
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                    LearningWizard.this.getContentPane().invalidate();
                    LearningWizard.this.getContentPane().removeAll();
                    LearningWizard.this.getContentPane().add(LearningWizard.this.page9);
                    LearningWizard.this.validate();
                    LearningWizard.this.repaint();
                }
            }
        });
        jButtonArray[3] = new JButton("Cancel");
        jButtonArray[3].addActionListener(new CancelListener());
        return new EMLearningPanel(domain, jButtonArray, 2, this.dataStream.getMissingValuesCount());
    }

    protected static boolean unresolvedLinks(Domain domain) throws ExceptionUsage {
        try {
            for (Node node : domain.getNodes()) {
                if (node.getPdagNeighbors().size() <= 0 && domain.getAmbiguousRegions().size() <= 0) continue;
                return true;
            }
            return false;
        }
        catch (ExceptionUsage exceptionUsage) {
            throw exceptionUsage;
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            return false;
        }
    }

    private boolean dontProceed(long l) {
        int n = JOptionPane.showConfirmDialog(this, "This model is very large (sum of sizes of CPTs will be " + l + ").\nMemory will be allocated for all CPTs if you proceed to the next stage.\n\nDo you really wish to proceed?", "Confirm CPT Creation", 0);
        return n == 1;
    }

    private void load(DataPreprocessingPanel dataPreprocessingPanel) {
        try {
            dataPreprocessingPanel.insertCases();
            this.finished = true;
            StreamData streamData = null;
            streamData = dataPreprocessingPanel.getStreamData();
            streamData.setSourceName(this.page1.getFileOrDatabaseName());
            streamData.setFilePath(this.page1.getFileName());
            if (this.casesListener != null && !this.stop) {
                this.casesListener.stateChanged(new ChangeEvent(streamData));
            }
            if (!this.stop) {
                this.dispose();
            }
        }
        catch (ExceptionMemory exceptionMemory) {
            new HuginGUIError(exceptionMemory.getMessage());
            this.getContentPane().invalidate();
            this.getContentPane().removeAll();
            this.getContentPane().add(dataPreprocessingPanel);
            this.validate();
            this.repaint();
        }
        catch (DataSourceException dataSourceException) {
            new HuginGUIError(dataSourceException.getMessage());
            this.getContentPane().invalidate();
            this.getContentPane().removeAll();
            this.getContentPane().add(dataPreprocessingPanel);
            this.validate();
            this.repaint();
        }
        catch (PreProcessingException preProcessingException) {
            new HuginGUIError(preProcessingException.getMessage());
            this.getContentPane().invalidate();
            this.getContentPane().removeAll();
            this.getContentPane().add(dataPreprocessingPanel);
            this.validate();
            this.repaint();
        }
        catch (ExceptionIO exceptionIO) {
            new HuginGUIError(exceptionIO.getMessage() + HuginGUIConstants.get("str_lb_lb_this_io_not_able_open_log_file_") + Hugin.mainFrame.getLogFileDir() + this.networkName + ".hlg");
            this.getContentPane().invalidate();
            this.getContentPane().removeAll();
            this.getContentPane().add(dataPreprocessingPanel);
            this.validate();
            this.repaint();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            this.getContentPane().invalidate();
            this.getContentPane().removeAll();
            this.getContentPane().add(dataPreprocessingPanel);
            this.validate();
            this.repaint();
        }
    }

    private void displayMessage(Variable[] variableArray) {
        if (variableArray == null) {
            return;
        }
        int n = variableArray.length;
        if (n > 0) {
            String string = "";
            int n2 = 0;
            for (int i = 0; i < variableArray.length; ++i) {
                if (variableArray[i].containsNode()) continue;
                string = string + variableArray[i].getNodeName() + " ";
                if (++n2 == n) {
                    string = string + ". ";
                    continue;
                }
                if (n2 == 3 && n > 3) {
                    i = variableArray.length;
                    string = string + ", ... ";
                    continue;
                }
                string = string + ", ";
            }
            JOptionPane.showMessageDialog(this, HuginGUIConstants.get("str_following_nodes_not_exist_lb_ARG0", new String[]{string}), HuginGUIConstants.get("str_alert"), 0);
        }
    }

    public void connect(DataAcquisitionPanel dataAcquisitionPanel) {
        try {
            DataAcquisitionPanel dataAcquisitionPanel2 = dataAcquisitionPanel;
            int n = dataAcquisitionPanel2.getAcquisitionMethod();
            WizardPanel wizardPanel = null;
            switch (n) {
                case 0: {
                    this.dataSource = new TextfileDataSource(dataAcquisitionPanel2.getFileName(), null, dataAcquisitionPanel2.getEncoding());
                    ((TextfileDataSource)this.dataSource).readNamesFromFile(dataAcquisitionPanel2.getReadNames());
                    if (dataAcquisitionPanel2.useSeparator()) {
                        ((TextfileDataSource)this.dataSource).setSeparators(dataAcquisitionPanel2.getSeparator());
                    }
                    this.networkName = dataAcquisitionPanel2.getFileName();
                    int n2 = this.networkName.lastIndexOf(System.getProperty("file.separator"));
                    if (n2 > 0) {
                        this.networkName = this.networkName.substring(n2 + 1);
                    }
                    if ((n2 = this.networkName.lastIndexOf(".")) > 0) {
                        this.networkName = NetworkNamingPane.legalize(this.networkName.substring(0, n2));
                    }
                    if (this.existingDomain) {
                        this.dataStream = new DataStream(this.dataSource, this.domain, false);
                        Variable[] variableArray = this.dataStream.getExtraVariables();
                        this.displayMessage(variableArray);
                    } else {
                        this.dataStream = new DataStream(this.dataSource);
                    }
                    CasePreprocess casePreprocess = dataAcquisitionPanel2.getSampleProcess();
                    if (casePreprocess != null) {
                        this.dataStream.addCasePreprocess(casePreprocess);
                    }
                    this.page3b = this.getDataPreprocessingPanel();
                    this.page3b.setStatus(this.status);
                    this.status.setActiveStep(++this.activeStep);
                    this.page3b.setPrevious(dataAcquisitionPanel2);
                    this.page3b.setDataStream(this.dataStream);
                    wizardPanel = this.page3b;
                    break;
                }
                case 1: {
                    switch (dataAcquisitionPanel2.getDatabaseType()) {
                        case 0: {
                            this.dataSource = new OracleDataSource(this.prefs.driverdir, dataAcquisitionPanel2.getHost(), dataAcquisitionPanel2.getPort(), dataAcquisitionPanel2.getSID(), dataAcquisitionPanel2.getUser(), dataAcquisitionPanel2.getPassword());
                            break;
                        }
                        case 1: {
                            this.dataSource = new ODBCDataSource(dataAcquisitionPanel2.getDatabaseName());
                            break;
                        }
                        case 2: {
                            this.dataSource = new JDBCDataSource(this.prefs.driverdir, dataAcquisitionPanel2.getUrl(), dataAcquisitionPanel2.getJDBCUsername(), dataAcquisitionPanel2.getJDBCPassword());
                        }
                    }
                    this.dataStream = this.existingDomain ? new DataStream(this.dataSource, this.domain, false) : new DataStream(this.dataSource);
                    CasePreprocess casePreprocess = dataAcquisitionPanel2.getSampleProcess();
                    if (casePreprocess != null) {
                        this.dataStream.addCasePreprocess(casePreprocess);
                    }
                    this.page2 = this.getDatabaseConfigPanel();
                    this.page2.setDatabase((DatabaseDataSource)this.dataSource);
                    this.page2.setStatus(this.status);
                    this.page2.setPrevious(dataAcquisitionPanel2);
                    this.status.insertItemAt("Database Configuration", 1);
                    this.status.setActiveStep(++this.activeStep);
                    wizardPanel = this.page2;
                }
            }
            this.currentPanel = this.page2;
            this.getContentPane().invalidate();
            this.getContentPane().removeAll();
            this.getContentPane().add(wizardPanel);
            this.validate();
            this.repaint();
        }
        catch (DatabaseException databaseException) {
            new HuginGUIError(databaseException.getMessage());
            if (this.dataSource != null) {
                this.dataSource = null;
            }
            this.getContentPane().invalidate();
            this.getContentPane().removeAll();
            this.getContentPane().add(this.page1);
            this.validate();
            this.repaint();
        }
        catch (DataSourceException dataSourceException) {
            new HuginGUIError(dataSourceException.getMessage());
            this.getContentPane().invalidate();
            this.getContentPane().removeAll();
            this.getContentPane().add(this.page1);
            this.validate();
            this.repaint();
        }
        catch (PreProcessingException preProcessingException) {
            new HuginGUIError(preProcessingException.getMessage());
            this.getContentPane().invalidate();
            this.getContentPane().removeAll();
            this.getContentPane().add(this.page1);
            this.validate();
            this.repaint();
        }
        catch (FileNotFoundException fileNotFoundException) {
            new HuginGUIError(fileNotFoundException.getMessage());
            this.getContentPane().invalidate();
            this.getContentPane().removeAll();
            this.getContentPane().add(this.page1);
            this.validate();
            this.repaint();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            this.getContentPane().invalidate();
            this.getContentPane().removeAll();
            this.getContentPane().add(this.page1);
            this.validate();
            this.repaint();
        }
    }

    private void retrieve(DatabaseConfigurationPanel databaseConfigurationPanel) {
        DatabaseConfigurationPanel databaseConfigurationPanel2 = databaseConfigurationPanel;
        DatabaseJoin databaseJoin = databaseConfigurationPanel2.getJoin();
        String[] stringArray = databaseConfigurationPanel2.getTables();
        if (databaseJoin == null && stringArray.length > 1) {
            new HuginGUIError(HuginGUIConstants.get("str_unable_to_proceed_with_specified_joins"));
            return;
        }
        if (this.stop) {
            return;
        }
        ((DatabaseDataSource)this.dataSource).setJoin(databaseJoin);
        if (this.stop) {
            return;
        }
        ((DatabaseDataSource)this.dataSource).setTables(stringArray);
        if (this.stop) {
            return;
        }
        this.getContentPane().invalidate();
        if (this.stop) {
            return;
        }
        try {
            this.dataStream.initialize();
            if (this.stop) {
                return;
            }
            for (int i = 0; i < stringArray.length - 1; ++i) {
                this.networkName = this.networkName + stringArray[i] + "_";
            }
            this.networkName = this.networkName + stringArray[stringArray.length - 1];
            this.networkName = NetworkNamingPane.legalize(this.networkName);
            this.page3b = this.getDataPreprocessingPanel();
            this.page3b.setPrevious(databaseConfigurationPanel2);
            this.page3b.setDataStream(this.dataStream);
            if (this.stop) {
                return;
            }
            this.page3b.setStatus(this.status);
            this.status.setActiveStep(++this.activeStep);
            this.getContentPane().removeAll();
            this.getContentPane().add(this.page3b);
            this.currentPanel = this.page3b;
        }
        catch (DataSourceException dataSourceException) {
            if (this.stop) {
                return;
            }
            new HuginGUIError(dataSourceException.getMessage());
            this.getContentPane().invalidate();
            this.getContentPane().removeAll();
            this.getContentPane().add(databaseConfigurationPanel2);
            this.validate();
            this.repaint();
        }
        catch (Exception exception) {
            if (this.stop) {
                return;
            }
            new HuginGUIError(exception);
            this.getContentPane().invalidate();
            this.getContentPane().removeAll();
            this.getContentPane().add(databaseConfigurationPanel2);
            this.validate();
            this.repaint();
        }
        if (this.stop) {
            return;
        }
        this.validate();
        this.repaint();
    }

    private void stopThreads() {
        if (this.loader != null && this.loader.isAlive()) {
            this.loader.stopLoading();
            this.page3b.setCursor(this.loader.cursor);
            this.dataStream = null;
            this.page3b.setEnableComponents(true);
            this.loader = null;
        }
        if (this.retriever != null && this.retriever.isAlive()) {
            this.retriever.stopRetrieving();
            if (this.dataStream != null) {
                this.dataStream.stop();
            }
            this.page2.setCursor(this.retriever.cursor);
            this.dataStream = null;
            this.page2.setEnableComponents(true);
            this.retriever = null;
        }
        if (this.connecter != null && this.connecter.isAlive()) {
            this.connecter.stopConnecting();
            if (this.dataStream != null) {
                this.dataStream.stop();
            }
            this.page1.setCursor(this.connecter.cursor);
            this.dataStream = null;
            this.page1.setEnableComponents(true);
            this.connecter = null;
        }
    }

    private class CloseListener
    implements WindowListener {
        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
            LearningWizard.this.stopThreads();
        }

        public void windowClosing(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }
    }

    class RetrieveData
    extends Thread {
        DatabaseConfigurationPanel page2;
        Cursor cursor;

        public RetrieveData(DatabaseConfigurationPanel databaseConfigurationPanel) {
            this.page2 = databaseConfigurationPanel;
            this.cursor = this.page2.getCursor();
        }

        public void run() {
            this.page2.setCursor(Cursor.getPredefinedCursor(3));
            this.page2.setEnableComponents(false);
            this.page2.validate();
            LearningWizard.this.stop = false;
            LearningWizard.this.retrieve(this.page2);
            this.page2.setCursor(this.cursor);
            this.page2.setEnableComponents(true);
        }

        public void stopRetrieving() {
            LearningWizard.this.stop = true;
        }
    }

    class LoadData
    extends Thread {
        DataPreprocessingPanel page3b;
        Cursor cursor;

        public LoadData(DataPreprocessingPanel dataPreprocessingPanel) {
            this.page3b = dataPreprocessingPanel;
            this.cursor = this.page3b.getCursor();
        }

        public void run() {
            this.page3b.setCursor(Cursor.getPredefinedCursor(3));
            this.page3b.setEnableComponents(false);
            this.page3b.validate();
            LearningWizard.this.stop = false;
            LearningWizard.this.load(this.page3b);
            this.page3b.setCursor(this.cursor);
            this.page3b.setEnableComponents(true);
        }

        public void stopLoading() {
            LearningWizard.this.stop = true;
        }
    }

    class Connect
    extends Thread {
        DataAcquisitionPanel page1;
        Cursor cursor;

        public Connect(DataAcquisitionPanel dataAcquisitionPanel) {
            this.page1 = dataAcquisitionPanel;
            this.cursor = this.page1.getCursor();
        }

        public void run() {
            this.page1.setCursor(Cursor.getPredefinedCursor(3));
            this.page1.setEnableComponents(false);
            this.page1.validate();
            LearningWizard.this.stop = false;
            LearningWizard.this.connect(this.page1);
            this.page1.setCursor(this.cursor);
            this.page1.setEnableComponents(true);
        }

        public void stopConnecting() {
            LearningWizard.this.stop = true;
        }
    }

    private class WizardKeyListener
    extends KeyAdapter {
        private int pressedEvent = 0;

        private WizardKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.pressedEvent = keyEvent.getKeyCode();
            if (LearningWizard.this.currentPanel != null) {
                LearningWizard.this.currentPanel.receiveKeyEvent(keyEvent);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() != this.pressedEvent && LearningWizard.this.currentPanel != null) {
                LearningWizard.this.currentPanel.receiveKeyEvent(keyEvent);
            }
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                LearningWizard.this.stopThreads();
                if (LearningWizard.this.dataStream != null && LearningWizard.this.dataStream.getCaseTemplate() != null && !LearningWizard.this.existingDomain) {
                    LearningWizard.this.dataStream.getCaseTemplate().getDomain().delete();
                }
            }
            catch (ExceptionObjectNotAlive exceptionObjectNotAlive) {
            }
            catch (ExceptionHugin exceptionHugin) {
                new HuginGUIError(exceptionHugin);
            }
            LearningWizard.this.dispose();
        }
    }

    private class HelpListener
    implements ActionListener {
        String helpPage;

        public HelpListener(String string) {
            this.helpPage = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LearningWizard.this.helpPanel.setHelpPage(this.helpPage);
            if (!LearningWizard.this.helpPanel.isVisible()) {
                int n = LearningWizard.this.getX() - LearningWizard.this.helpPanel.getWidth();
                if (n < 5 && (n = LearningWizard.this.getX() + LearningWizard.this.getWidth()) + LearningWizard.this.helpPanel.getWidth() > Toolkit.getDefaultToolkit().getScreenSize().width - 5) {
                    n = 5;
                }
                LearningWizard.this.helpPanel.setLocation(n, LearningWizard.this.getY());
                LearningWizard.this.helpPanel.setVisible(true);
            }
        }
    }

    private class ResizedListener
    extends ComponentAdapter {
        LearningWizard frame;

        public ResizedListener(LearningWizard learningWizard2) {
            this.frame = learningWizard2;
        }

        public void componentResized(ComponentEvent componentEvent) {
            int n = this.frame.getWidth();
            int n2 = this.frame.getHeight();
            boolean bl = false;
            if (n < 620) {
                n = 620;
                bl = true;
            }
            if (n2 < 550) {
                n2 = 550;
                bl = true;
            }
            if (bl) {
                this.frame.setSize(n, n2);
            }
        }
    }
}

