/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.ExceptionArgumentNotAlive;
import COM.hugin.HAPI.ExceptionEnumeration;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionNotCompiled;
import COM.hugin.HAPI.ExceptionObjectNotAlive;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.UtilityNode;
import COM.hugin.HGUI.Bspline;
import COM.hugin.HGUI.CDVTLink;
import COM.hugin.HGUI.HStroke;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.InstanceNode;
import COM.hugin.HGUI.InvalidPointException;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.PolygonNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Link
extends Line2D.Float
implements Cloneable {
    private Stroke stroke;
    protected Color color;
    private boolean isDirected;
    private double strength = 0.0;
    protected boolean selected;
    protected boolean selectable = true;
    protected boolean isGhost;
    private boolean isVisible = true;
    protected static final int ARROW_WIDTH = 4;
    protected static final int ARROW_HEIGHT = 10;
    protected int[] arrowHeadXpoints = new int[3];
    protected int[] arrowHeadYpoints = new int[3];
    private double scaleFactor = 1.0;
    protected Node parent;
    protected Node child;
    private static final double MAX_DIST = 3.0;
    protected Rectangle myBoundingBox = null;
    Link cloneOf;
    protected static final int REVERSE_ERROR = -1;
    protected static final int REVERSABLE = 0;
    protected static final int INPUT_IRREVERSABLE = 1;
    protected static final int OUTPUT_IRREVERSABLE = 2;
    protected static final int CONTINUOUS_IRREVERSABLE = 3;
    protected static final int INFO_IRREVERSABLE = 4;
    protected static final int UTILITY_IRREVERSABLE = 5;
    protected static final int DIR_PATH_IRREVERSABLE = 6;
    private Point2D.Float dT = new Point2D.Float();
    private Point2D.Float dEdgeT = new Point2D.Float();
    private static final Point NE_NORMAL = new Point(-1, -1);
    private static final Point SE_NORMAL = new Point(1, -1);
    private static final Point SW_NORMAL = new Point(1, 1);
    private static final Point NW_NORMAL = new Point(-1, 1);
    private static Point northOrigin = new Point();
    private static Point eastOrigin = new Point();
    private static Point southOrigin = new Point();
    private static Point westOrigin = new Point();
    private static Point point = new Point();
    private static Point u = new Point();
    private static Point v = new Point();
    private static final int NORTH = 0;
    private static final int SOUTH = 1;
    private static final int EAST = 2;
    private static final int WEST = 3;
    private static final int NW = 0;
    private static final int NE = 1;
    private static final int SE = 2;
    private static final int SW = 3;
    private static Point cornerPoint = new Point();
    Bspline spline;
    public static final int NORMAL_MODE = 0;
    public static final int SPLINE_MODE = 1;
    public static final int EDGE_MODE = 2;
    private int mode = 0;
    boolean modeChange = false;
    private boolean movingControlPoint = false;

    protected boolean isDirected() {
        return this.isDirected;
    }

    protected void isDirected(boolean bl) {
        this.isDirected = bl;
    }

    protected double getStrength() {
        return this.strength;
    }

    protected void setStrength(double d) {
        this.strength = d;
    }

    protected void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    protected boolean isVisible() {
        return this.isVisible;
    }

    protected double getScaleFactor() {
        return this.scaleFactor;
    }

    public Link() {
    }

    public Link(Point2D point2D, Point2D point2D2) {
        super(point2D, point2D2);
        this.initLink(true);
    }

    public Link(Node node, Node node2, double d) {
        this.initLink(false);
        this.parent = node;
        this.child = node2;
        this.scaleFactor = d;
        this.restorePoints();
        this.computePoints();
        this.restorePoints();
    }

    public Link(Node node, Node node2, double d, Bspline bspline, int n) {
        this(node, node2, d);
        this.mode = n;
        if (bspline == null) {
            return;
        }
        if (this.spline == null) {
            this.spline = new Bspline((int)this.x1, (int)this.y1, (int)this.x2, (int)this.y2);
        }
        this.setSpline(bspline);
        try {
            this.setMode(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Link(Node node, Node node2) {
        this.initLink(true);
        this.parent = node;
        this.child = node2;
        this.computePoints();
    }

    private void initLink(boolean bl) {
        this.color = Color.black;
        this.isDirected = true;
        this.selected = false;
        this.isGhost = bl;
    }

    protected Rectangle kill() throws ExceptionHugin {
        return this.kill(true);
    }

    protected Rectangle kill(boolean bl) throws ExceptionHugin {
        if (this.parent.getAPINode().getMaster() != null) {
            HuginGUIUtils.setLinkControlPointsInstance(this.parent.getAPINode().getInstance(), this.parent.getAPINode().getName(), this.child.getAPINode().getName(), null);
            HuginGUIUtils.setLinkModeInstance(this.parent.getAPINode().getInstance(), this.parent.getAPINode().getName(), this.child.getAPINode().getName(), null);
        } else {
            HuginGUIUtils.setLinkControlPoints(this.parent.getAPINode(), this.child.getAPINode().getName(), null);
            HuginGUIUtils.setLinkMode(this.parent.getAPINode(), this.child.getAPINode().getName(), null);
        }
        if (this.child.host != null) {
            ((COM.hugin.HAPI.InstanceNode)this.child.host.getAPINode()).unsetInput(this.child.getAPINode());
        } else {
            boolean bl2 = this.child.getTable() != null;
            this.child.disposeTable();
            if (bl) {
                this.child.backupTemporaryExpressions();
                this.child.getAPINode().removeParent(this.parent.getAPINode());
                this.child.restoreFromTemporaryExpressions();
            }
            if (bl2) {
                this.child.updateTable();
                this.child.showTable();
            }
        }
        return this.getBoundingBox();
    }

    @Override
    public Object clone() {
        if (this.isGhost) {
            return new Link(this.parent, this.child);
        }
        return new Link(this.parent, this.child, this.scaleFactor, this.getSpline(), this.getMode());
    }

    public void paint(Graphics2D graphics2D) {
        if (!this.isVisible || this.x1 == this.x2 && this.y1 == this.y2) {
            return;
        }
        graphics2D.setPaint(this.color);
        this.setStroke();
        graphics2D.setStroke(this.stroke);
        if (this.mode == 0) {
            if (this.isDirected && !this.isGhost) {
                int n = (int)Math.rint(this.scaleFactor * (double)((BasicStroke)this.stroke).getLineWidth());
                double d = Point2D.distance(this.x1, this.y1, this.x2, this.y2);
                double d2 = (double)(this.x2 - this.x1) / d;
                double d3 = (double)(this.y2 - this.y1) / d;
                graphics2D.drawLine((int)this.x1, (int)this.y1, (int)((double)this.x2 - (double)n * d2), (int)((double)this.y2 - (double)n * d3));
                this.drawArrowHead(graphics2D, (double)this.x1, (double)this.y1, (double)this.x2, (double)this.y2, n);
            } else {
                graphics2D.drawLine((int)this.x1, (int)this.y1, (int)this.x2, (int)this.y2);
            }
        }
        if (this.mode == 1 || this.mode == 2) {
            this.paintSpline(graphics2D);
            Point point = this.spline.getSecondLastPoint();
            Point point2 = this.spline.getLastPoint();
            int n = (int)Math.rint(this.scaleFactor * (double)((BasicStroke)this.stroke).getLineWidth());
            this.drawArrowHead(graphics2D, point.getX(), point.getY(), point2.getX(), point2.getY(), n);
        }
    }

    public void print(Graphics graphics, Point point) {
        if (!this.isVisible || this.x1 == this.x2 && this.y1 == this.y2) {
            return;
        }
        float f = this.x1 + (float)point.x;
        float f2 = this.y1 + (float)point.y;
        float f3 = this.x2 + (float)point.x;
        float f4 = this.y2 + (float)point.y;
        graphics.setColor(this.color);
        Stroke stroke = ((Graphics2D)graphics).getStroke();
        this.setStroke();
        ((Graphics2D)graphics).setStroke(this.stroke);
        if (this.mode == 0) {
            if (this.isDirected && !this.isGhost) {
                double d = Point2D.distance(f, f2, f3, f4);
                double d2 = (double)(f3 - f) / d;
                double d3 = (double)(f4 - f2) / d;
                boolean bl = true;
                graphics.drawLine((int)f, (int)f2, (int)((double)f3 - (double)bl * d2), (int)((double)f4 - (double)bl * d3));
                ((Graphics2D)graphics).setStroke(stroke);
                this.drawArrowHead(graphics, d2, d3, point);
            } else {
                graphics.drawLine((int)f, (int)f2, (int)f3, (int)f4);
            }
        }
        if (this.mode == 1 || this.mode == 2) {
            this.printSpline(graphics, point);
            Point point2 = this.spline.getSecondLastPoint();
            Point point3 = this.spline.getLastPoint();
            if (this.stroke == null) {
                this.setStroke();
            }
            int n = (int)Math.rint(this.scaleFactor * (double)((BasicStroke)this.stroke).getLineWidth());
            ((Graphics2D)graphics).setStroke(stroke);
            this.drawArrowHead(graphics, point2.getX(), point2.getY(), point3.getX(), point3.getY(), point);
        }
        ((Graphics2D)graphics).setStroke(stroke);
    }

    public void select() {
        if (!this.selected) {
            this.selected = true;
            this.setStroke();
            if (this.spline != null) {
                this.spline.setSelected(true);
            }
        }
    }

    public void deselect() {
        if (this.selected) {
            this.selected = false;
            this.setStroke();
            if (this.spline != null) {
                this.spline.setSelected(false);
            }
        }
    }

    protected boolean isSelected() {
        return this.selected;
    }

    protected boolean isSelectable() {
        return this.selectable && !this.selected && !this.atCollapsedNode();
    }

    protected int reverse(LinkedList<Link> linkedList) {
        return this.reverse(linkedList, true);
    }

    protected int reverse(LinkedList<Link> linkedList, boolean bl) {
        int n = this.reversable();
        if (n != 0) {
            return n;
        }
        try {
            int n2;
            if (!(this.child.getAPINode() instanceof ContinuousChanceNode) && bl && (this.child.getAPINode().getModel() != null || this.child.getAPINode() instanceof DiscreteChanceNode && (((DiscreteChanceNode)this.child.getAPINode()).hasExperienceTable() || ((DiscreteChanceNode)this.child.getAPINode()).hasFadingTable()) || this.parent.getAPINode().getModel() != null || this.parent.getAPINode() instanceof DiscreteChanceNode && (((DiscreteChanceNode)this.parent.getAPINode()).hasExperienceTable() || ((DiscreteChanceNode)this.parent.getAPINode()).hasFadingTable())) && (n2 = JOptionPane.showConfirmDialog(Hugin.mainFrame, HuginGUIConstants.get("MENU_EDIT_Reverse_will_erase"), HuginGUIConstants.get("MISCELLANEOUS_Warning"), 0)) == 1) {
                return -1;
            }
            if (!(this.child.getAPINode() instanceof ContinuousChanceNode) && this.child.getAPINode().getModel() != null) {
                COM.hugin.HAPI.Node node = this.child.getAPINode();
                if (node instanceof DiscreteChanceNode) {
                    ((DiscreteChanceNode)node).generateTable();
                }
                if (node instanceof UtilityNode) {
                    ((UtilityNode)node).generateTable();
                }
                this.child.getOrCreateCPT();
                this.child.setCPTMode(0);
            }
            if (!(this.child.getAPINode() instanceof ContinuousChanceNode) && this.parent.getAPINode().getModel() != null) {
                COM.hugin.HAPI.Node node = this.parent.getAPINode();
                if (node instanceof DiscreteChanceNode) {
                    ((DiscreteChanceNode)node).generateTable();
                }
                if (node instanceof UtilityNode) {
                    ((UtilityNode)node).generateTable();
                }
                this.parent.getOrCreateCPT();
                this.parent.setCPTMode(0);
            }
            this.child.getAPINode().reverseEdge(this.parent.getAPINode());
        }
        catch (ExceptionNotCompiled exceptionNotCompiled) {
            new HuginGUIError(exceptionNotCompiled.getMessage());
            return -1;
        }
        catch (ExceptionEnumeration exceptionEnumeration) {
            new HuginGUIError(exceptionEnumeration.getMessage());
            return -1;
        }
        catch (ExceptionObjectNotAlive exceptionObjectNotAlive) {
            new HuginGUIError(exceptionObjectNotAlive);
            return -1;
        }
        catch (ExceptionArgumentNotAlive exceptionArgumentNotAlive) {
            new HuginGUIError(exceptionArgumentNotAlive);
            return -1;
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
            return -1;
        }
        try {
            NodeList nodeList = this.child.getAPINode().getParents();
            NodeList nodeList2 = this.parent.getAPINode().getParents();
            for (COM.hugin.HAPI.Node node : nodeList) {
                linkedList.add(new Link(this.child.panel.getNode(node), this.child, this.scaleFactor));
            }
            for (COM.hugin.HAPI.Node node : nodeList2) {
                linkedList.add(new Link(this.parent.panel.getNode(node), this.parent, this.scaleFactor));
            }
            Node node = this.parent;
            this.parent = this.child;
            this.child = node;
            this.setLine(this.x2, this.y2, this.x1, this.y1);
            if (this.spline != null) {
                this.spline.reverse();
            }
            this.computePoints();
        }
        catch (Exception exception) {
            new HuginGUIError(exception.getMessage());
            return -1;
        }
        return 0;
    }

    protected int reversable() {
        if (this.child.host != null) {
            return 1;
        }
        if (this.parent.host != null) {
            return 2;
        }
        if (this.child.isDecision()) {
            return 4;
        }
        if (this.child.isUtility()) {
            return 5;
        }
        if (this.child.isContinuousChance() && !this.parent.isContinuousChance()) {
            return 3;
        }
        if (this.parent.isInput()) {
            return 1;
        }
        if (this.parent.directedPath(this.child, this)) {
            return 6;
        }
        return 0;
    }

    private void setStroke() {
        this.stroke = this.isGhost ? HStroke.DASH_STROKE : (this.selected ? HStroke.HILIT_STROKE : HStroke.BASIC_STROKE);
        int n = (int)Math.rint(this.scaleFactor * (double)((BasicStroke)this.stroke).getLineWidth());
        if (n <= 1) {
            n = 1 + (this.selected ? 1 : 0);
        } else if (n > 9) {
            n = 9;
        }
        this.stroke = this instanceof CDVTLink ? HStroke.DASH_STROKES[n] : (this.isGhost ? HStroke.DASH_STROKES[n] : HStroke.STROKES[n]);
    }

    protected void computeBoundingBox() {
        if (this.mode == 1 || this.mode == 2) {
            this.myBoundingBox = this.spline.getBounds();
            return;
        }
        int n = (int)Math.rint(this.scaleFactor * 4.0) * 2;
        int n2 = (int)Math.min(this.x1, this.x2);
        int n3 = (int)Math.min(this.y1, this.y2);
        int n4 = (int)Math.abs(this.x1 - this.x2);
        int n5 = (int)Math.abs(this.y1 - this.y2);
        int n6 = 2 * n;
        int n7 = 2 * n6;
        this.myBoundingBox = new Rectangle(n2 - n6, n3 - n6, n4 + n7, n5 + n7);
    }

    protected Rectangle getBoundingBox() {
        if (!this.isGhost) {
            return this.myBoundingBox;
        }
        this.computeBoundingBox();
        return this.myBoundingBox;
    }

    public void computePoints() {
        Node node;
        if (!this.modeChange && this.mode == 0) {
            this.spline = null;
        }
        if (this.parent == null || this.child == null) {
            return;
        }
        Node node2 = this.parent.host != null && this.parent.host.isCollapsed() ? this.parent.host : this.parent;
        Node node3 = node = this.child.host != null && this.child.host.isCollapsed() ? this.child.host : this.child;
        if (node2 instanceof PolygonNode || node instanceof PolygonNode) {
            this.linkToPolygon(node2, node);
        } else {
            this.linkNodes(node2, node);
        }
        this.computeBoundingBox();
    }

    protected boolean intersects(Rectangle rectangle) {
        if (this.isGhost) {
            return true;
        }
        if (this.mode == 0 || !this.spline.hasCurve()) {
            return super.intersects(rectangle);
        }
        return this.spline.intersects(rectangle);
    }

    protected boolean intersects(Rectangle rectangle, Point point) {
        if (this.isGhost) {
            return true;
        }
        if (this.mode == 0 || !this.spline.hasCurve()) {
            return super.intersects(rectangle);
        }
        return this.spline.intersects(rectangle, point);
    }

    protected void scale(double d) {
        this.computePoints();
        this.scaleFactor *= d;
        if (this.spline != null) {
            this.spline.setScaleFactor(this.scaleFactor);
            this.storePoints();
        }
        this.computePoints();
    }

    protected Rectangle update() {
        Rectangle rectangle = this.getBoundingBox();
        this.computePoints();
        rectangle.add(this.getBoundingBox());
        return rectangle;
    }

    public void setStart(Point point) {
        this.setLine(point.x, point.y, this.x2, this.y2);
    }

    public void setEnd(Point point) {
        this.setLine(this.x1, this.y1, point.x, point.y);
    }

    public void moveStart(int n, int n2) {
        this.setLine(this.x1 + (float)n, this.y1 + (float)n2, this.x2, this.y2);
    }

    public void moveEnd(int n, int n2) {
        this.setLine(this.x1, this.y1, this.x2 + (float)n, this.y2 + (float)n2);
    }

    public void move(int n, int n2) {
        this.setLine(this.x1 + (float)n, this.y1 + (float)n2, this.x2 + (float)n, this.y2 + (float)n2);
        if (this.spline != null) {
            this.spline.move(n, n2);
        }
    }

    protected void drawArrowHead(Graphics graphics, double d, double d2, double d3, double d4, Point point) {
        double d5 = Point2D.distance(d, d2, d3, d4);
        double d6 = (d3 - d) / d5;
        double d7 = (d4 - d2) / d5;
        this.drawArrowHead(graphics, d6, d7, point);
    }

    protected void drawArrowHead(Graphics2D graphics2D, double d, double d2, double d3, double d4, int n) {
        double d5 = Point2D.distance(d, d2, d3, d4);
        double d6 = (d3 - d) / d5;
        double d7 = (d4 - d2) / d5;
        this.drawArrowHead(graphics2D, d6, d7, n);
    }

    protected void drawArrowHead(Graphics2D graphics2D, double d, double d2, int n) {
        double d3 = -d2;
        double d4 = d;
        double d5 = -this.scaleFactor * 10.0 * d;
        double d6 = -this.scaleFactor * 10.0 * d2;
        double d7 = -this.scaleFactor * 4.0 * d3;
        double d8 = -this.scaleFactor * 4.0 * d4;
        double d9 = (double)this.x2 - (double)(n / 2) * d;
        double d10 = (double)this.y2 - (double)(n / 2) * d2;
        this.arrowHeadXpoints[0] = (int)d9;
        this.arrowHeadYpoints[0] = (int)d10;
        this.arrowHeadXpoints[1] = (int)(d9 + d5 + d7);
        this.arrowHeadYpoints[1] = (int)(d10 + d6 + d8);
        this.arrowHeadXpoints[2] = (int)(d9 + d5 - d7);
        this.arrowHeadYpoints[2] = (int)(d10 + d6 - d8);
        Polygon polygon = new Polygon(this.arrowHeadXpoints, this.arrowHeadYpoints, 3);
        Stroke stroke = graphics2D.getStroke();
        int n2 = 0;
        if (stroke instanceof HStroke.HBasicStroke) {
            n2 = ((HStroke.HBasicStroke)stroke).getLineJoin();
            ((HStroke.HBasicStroke)stroke).setLineJoin(0);
        }
        graphics2D.fill(polygon);
        graphics2D.draw(polygon);
        if (stroke instanceof HStroke.HBasicStroke) {
            ((HStroke.HBasicStroke)stroke).setLineJoin(n2);
        }
    }

    private void drawArrowHead(Graphics graphics, double d, double d2, Point point) {
        double d3 = -d2;
        double d4 = d;
        double d5 = -this.scaleFactor * 10.0 * d;
        double d6 = -this.scaleFactor * 10.0 * d2;
        double d7 = -this.scaleFactor * 4.0 * d3;
        double d8 = -this.scaleFactor * 4.0 * d4;
        this.arrowHeadXpoints[0] = (int)this.x2 + point.x;
        this.arrowHeadYpoints[0] = (int)this.y2 + point.y;
        this.arrowHeadXpoints[1] = (int)((double)(this.x2 + (float)point.x) + d5 + d7);
        this.arrowHeadYpoints[1] = (int)((double)(this.y2 + (float)point.y) + d6 + d8);
        this.arrowHeadXpoints[2] = (int)((double)(this.x2 + (float)point.x) + d5 - d7);
        this.arrowHeadYpoints[2] = (int)((double)(this.y2 + (float)point.y) + d6 - d8);
        graphics.fillPolygon(this.arrowHeadXpoints, this.arrowHeadYpoints, 3);
        graphics.drawPolygon(this.arrowHeadXpoints, this.arrowHeadYpoints, 3);
    }

    private void linkNodes(Node node, Node node2) {
        Point point = new Point((int)node.center.x, (int)node.center.y);
        Point point2 = new Point((int)node2.center.x, (int)node2.center.y);
        Point point3 = null;
        Point point4 = null;
        if (this.mode == 0) {
            point3 = this.findNodePoint(node, point2);
            point4 = this.findNodePoint(node2, point);
        }
        if (this.mode == 1 || this.mode == 2) {
            point3 = this.findNodePoint(node, this.spline.getSecondPoint());
            point4 = this.findNodePoint(node2, this.spline.getSecondLastPoint());
        }
        this.setLine(point3.x, point3.y, point4.x, point4.y);
    }

    private Point findNodePoint(Node node, Point point) {
        Point point2 = new Point((int)node.center.x, (int)node.center.y);
        if (node.isEllipse()) {
            return this.findEllipsePoint(point2, point, node.getRadii());
        }
        return this.findRectPoint(node, point, node.isInstance());
    }

    private void linkToPolygon(Node node, Node node2) {
        Point point = null;
        Point point2 = new Point((int)node2.center.x, (int)node2.center.y);
        if (this.mode == 0) {
            point = node instanceof PolygonNode ? this.findPolygonPoint((PolygonNode)node, node2.center) : this.findNodePoint(node, point2);
            point2 = node2 instanceof PolygonNode ? this.findPolygonPoint((PolygonNode)node2, point) : this.findNodePoint(node2, point);
        }
        if (this.mode == 1 || this.mode == 2) {
            point = node instanceof PolygonNode ? this.findPolygonPoint((PolygonNode)node, this.spline.getSecondPoint()) : this.findNodePoint(node, this.spline.getSecondPoint());
            point2 = node2 instanceof PolygonNode ? this.findPolygonPoint((PolygonNode)node2, this.spline.getSecondLastPoint()) : this.findNodePoint(node2, this.spline.getSecondLastPoint());
        }
        this.setLine(point.x, point.y, point2.x, point2.y);
    }

    private Point findPolygonPoint(PolygonNode polygonNode, Point2D point2D) {
        double d;
        double d2;
        double d3;
        double d4;
        Point point = new Point();
        double d5 = Double.MAX_VALUE;
        double d6 = polygonNode.north.distance(point2D);
        if (d4 < d5) {
            point.setLocation(polygonNode.north);
            d5 = d6;
        }
        d6 = polygonNode.south.distance(point2D);
        if (d3 < d5) {
            point.setLocation(polygonNode.south);
            d5 = d6;
        }
        d6 = polygonNode.east.distance(point2D);
        if (d2 < d5) {
            point.setLocation(polygonNode.east);
            d5 = d6;
        }
        d6 = polygonNode.west.distance(point2D);
        if (d < d5) {
            point.setLocation(polygonNode.west);
        }
        return point;
    }

    private Point findEllipsePoint(Point point, Point point2, Point point3) {
        if (point.equals(point2)) {
            return point;
        }
        float f = (float)(2.0 / (double)point3.x);
        float f2 = (float)(2.0 / (double)point3.y);
        this.dT.x = (float)(point2.x - point.x) * f;
        this.dT.y = (float)(point2.y - point.y) * f2;
        double d = this.dT.distance(0.0, 0.0);
        this.dEdgeT.x = (float)((double)this.dT.x / d);
        this.dEdgeT.y = (float)((double)this.dT.y / d);
        return new Point((int)((float)point.x + this.dEdgeT.x / f), (int)((float)point.y + this.dEdgeT.y / f2));
    }

    private Point findRectPoint(Node node, Point point, boolean bl) {
        if ((double)point.x == node.center.x && (double)point.y == node.center.y) {
            return point;
        }
        int n = 0;
        int n2 = this.whichArea(point, (int)node.x, (int)node.y, (int)node.width, (int)node.height);
        int n3 = bl ? (int)(((InstanceNode)node).getArcSize() / 2.0) : (int)Math.rint(10.0 * this.scaleFactor);
        if (n2 == 0 || n2 == 1) {
            u.setLocation(1, 0);
            n = (int)(node.width / 2.0 - (double)n3);
        } else {
            u.setLocation(0, 1);
            n = (int)(node.height / 2.0 - (double)n3);
        }
        v.setLocation((int)((double)point.x - node.center.x), (int)((double)point.y - node.center.y));
        double d = Math.acos((double)this.innerProduct(u, v) / (this.norm(u) * this.norm(v)));
        double d2 = n2 == 0 || n2 == 1 ? node.height / 2.0 : node.width / 2.0;
        double d3 = Math.abs(d - 1.5707963267948966) < 0.001 ? 0.0 : d2 * Math.cos(d) / Math.sin(d);
        Point point2 = new Point();
        if (Math.abs(d3) > (double)n) {
            point2.setLocation(this.computeCornerPoint(node, n2, d3 > (double)n, v, bl));
        } else {
            switch (n2) {
                case 0: {
                    point2.setLocation((int)(node.center.x + d3), (int)node.y);
                    break;
                }
                case 1: {
                    point2.setLocation((int)(node.center.x + d3), (int)(node.y + node.height));
                    break;
                }
                case 2: {
                    point2.setLocation((int)(node.x + node.width), (int)(node.center.y + d3));
                    break;
                }
                case 3: {
                    point2.setLocation((int)node.x, (int)(node.center.y + d3));
                }
            }
        }
        return point2;
    }

    private int whichArea(Point point, int n, int n2, int n3, int n4) {
        int n5 = Math.min(n3, n4);
        int n6 = n5 == n4 ? n + n3 - n5 / 2 : n + n3 / 2;
        int n7 = n5 == n4 ? n + n5 / 2 : n + n3 / 2;
        int n8 = n5 == n4 ? n2 + n4 / 2 : n2 + n4 - n5 / 2;
        int n9 = n5 == n4 ? n2 + n4 / 2 : n2 + n5 / 2;
        int n10 = n5 == n4 ? n2 + n4 + (n3 / 2 - n5) : n9;
        northOrigin.setLocation(n + n3 / 2, n10);
        int n11 = n5 == n4 ? n2 - (n3 / 2 - n5) : n8;
        southOrigin.setLocation(n + n3 / 2, n11);
        int n12 = n5 == n4 ? n6 : n - (n4 / 2 - n5);
        eastOrigin.setLocation(n12, n2 + n4 / 2);
        int n13 = n5 == n4 ? n7 : n + n3 + (n4 / 2 - n5);
        westOrigin.setLocation(n13, n2 + n4 / 2);
        Link.point.setLocation(point.x - Link.northOrigin.x, point.y - Link.northOrigin.y);
        if (this.innerProduct(Link.point, NW_NORMAL) <= 0 && this.innerProduct(Link.point, NE_NORMAL) >= 0) {
            if (point.y <= n9) {
                return 0;
            }
            if (point.y >= n8) {
                return 1;
            }
            if (point.x >= n6) {
                return 2;
            }
            return 3;
        }
        Link.point.setLocation(point.x - Link.eastOrigin.x, point.y - Link.eastOrigin.y);
        if (this.innerProduct(Link.point, NE_NORMAL) <= 0 && this.innerProduct(Link.point, SE_NORMAL) >= 0) {
            if (point.x >= n6) {
                return 2;
            }
            if (point.x <= n7) {
                return 3;
            }
            if (point.y >= n8) {
                return 1;
            }
            return 0;
        }
        Link.point.setLocation(point.x - Link.southOrigin.x, point.y - Link.southOrigin.y);
        if (this.innerProduct(Link.point, SE_NORMAL) <= 0 && this.innerProduct(Link.point, SW_NORMAL) >= 0) {
            if (point.y >= n8) {
                return 1;
            }
            if (point.y <= n9) {
                return 0;
            }
            if (point.x >= n6) {
                return 2;
            }
            return 3;
        }
        Link.point.setLocation(point.x - Link.westOrigin.x, point.y - Link.westOrigin.y);
        if (this.innerProduct(Link.point, SW_NORMAL) <= 0 && this.innerProduct(Link.point, NW_NORMAL) >= 0) {
            if (point.x <= n7) {
                return 3;
            }
            if (point.x >= n6) {
                return 2;
            }
            if (point.y >= n8) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    private int whichCorner(int n, boolean bl) {
        switch (n) {
            case 0: {
                return bl ? 1 : 0;
            }
            case 1: {
                return bl ? 2 : 3;
            }
            case 2: {
                return bl ? 2 : 1;
            }
            case 3: {
                return bl ? 3 : 0;
            }
        }
        return -1;
    }

    private Point computeCornerPoint(Node node, int n, boolean bl, Point point, boolean bl2) {
        if (bl2) {
            return this.computeRoundedCornerPoint(node, this.whichCorner(n, bl), point);
        }
        return this.computeSharpCornerPoint(node, this.whichCorner(n, bl));
    }

    private Point computeRoundedCornerPoint(Node node, int n, Point point) {
        Point point2 = cornerPoint;
        int n2 = (int)(((InstanceNode)node).getArcSize() / 2.0);
        int n3 = 0;
        int n4 = 0;
        switch (n) {
            case 0: {
                n3 = (int)(-node.width / 2.0 + (double)n2);
                n4 = (int)(-node.height / 2.0 + (double)n2);
                break;
            }
            case 1: {
                n3 = (int)(node.width / 2.0 - (double)n2);
                n4 = (int)(-node.height / 2.0 + (double)n2);
                break;
            }
            case 2: {
                n3 = (int)(node.width / 2.0 - (double)n2);
                n4 = (int)(node.height / 2.0 - (double)n2);
                break;
            }
            case 3: {
                n3 = (int)(-node.width / 2.0 + (double)n2);
                n4 = (int)(node.height / 2.0 - (double)n2);
            }
        }
        u.setLocation(point.x - n3, point.y - n4);
        int n5 = (int)((double)(n2 * Link.u.x) / this.norm(u));
        int n6 = (int)((double)(n2 * Link.u.y) / this.norm(u));
        point2.setLocation((int)node.center.x + n3 + n5, (int)node.center.y + n4 + n6);
        return point2;
    }

    private Point computeSharpCornerPoint(Node node, int n) {
        Point point = cornerPoint;
        switch (n) {
            case 0: {
                point.setLocation((int)node.x, (int)node.y);
                break;
            }
            case 1: {
                point.setLocation((int)(node.x + node.width), (int)node.y);
                break;
            }
            case 2: {
                point.setLocation((int)(node.x + node.width), (int)(node.y + node.height));
                break;
            }
            case 3: {
                point.setLocation((int)node.x, (int)(node.y + node.height));
            }
        }
        return point;
    }

    private int innerProduct(Point point, Point point2) {
        return point.x * point2.x + point.y * point2.y;
    }

    private double norm(Point point) {
        return Math.sqrt(point.x * point.x + point.y * point.y);
    }

    public Node getParentGhost(LinkedList<Node> linkedList) {
        InstanceNode instanceNode = (InstanceNode)this.parent.host.getGhost(linkedList);
        Node node = this.parent.getGhost(instanceNode.outputs);
        if (node != null) {
            return node;
        }
        return this.parent.getGhost(instanceNode.inputs);
    }

    public Node getChildGhost(LinkedList<Node> linkedList) {
        InstanceNode instanceNode = (InstanceNode)this.child.host.getGhost(linkedList);
        Node node = this.child.getGhost(instanceNode.inputs);
        if (node != null) {
            return node;
        }
        return this.child.getGhost(instanceNode.outputs);
    }

    protected boolean contains(Point point) {
        if (this.mode == 0) {
            int n = (int)(-(this.y2 - this.y1));
            int n2 = (int)(this.x2 - this.x1);
            Point point2 = new Point(n2, -n);
            Point point3 = new Point(point.x - (int)this.x1, point.y - (int)this.y1);
            double d = (double)Math.abs(n * point3.x + n2 * point3.y) / Math.sqrt(n * n + n2 * n2);
            Point point4 = new Point(point2.x - point3.x, point2.y - point3.y);
            boolean bl = this.dot(point2, point3) > 0 && this.dot(point2, point4) > 0;
            return d < 3.0 && bl;
        }
        if (this.mode == 1 || this.mode == 2) {
            return this.spline.contains(point);
        }
        return false;
    }

    private int dot(Point point, Point point2) {
        return point.x * point2.x + point.y * point2.y;
    }

    public String getDescription() {
        String string = this.isBinding() ? HuginGUIConstants.get("str_binding_link_") : HuginGUIConstants.get("str_link_");
        String string2 = this.parent.host != null ? this.parent.host.name + "." + this.parent.name : this.parent.name;
        String string3 = this.child.host != null ? this.child.host.name + "." + this.child.name : this.child.name;
        return string + string2 + " -> " + string3;
    }

    public boolean isBinding() {
        return this.child.host != null;
    }

    protected boolean atCollapsedNode() {
        return this.parent.host != null && this.parent.host.isCollapsed() || this.child.host != null && this.child.host.isCollapsed();
    }

    protected boolean hasBeenRemoved() throws ExceptionHugin {
        if (this.child.host != null) {
            return ((COM.hugin.HAPI.InstanceNode)this.child.host.getAPINode()).getInput(this.child.getAPINode()).getParents().contains(this.parent.getAPINode());
        }
        return !this.child.getAPINode().getParents().contains(this.parent.getAPINode());
    }

    public Link(Node node, Node node2, Link link) {
        this(node, node2);
        this.cloneOf = link;
        try {
            this.setMode(link.getMode());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mode != 0) {
            this.setSpline(link.getSpline());
        }
    }

    @Override
    public void setLine(float f, float f2, float f3, float f4) {
        super.setLine(f, f2, f3, f4);
        if (this.spline != null) {
            this.spline.setStart((int)f, (int)f2);
            this.spline.setEnd((int)f3, (int)f4);
        }
    }

    public void setSpline(Bspline bspline) {
        this.spline.setPts(bspline.getPts());
    }

    public Bspline getSpline() {
        return this.spline;
    }

    public void setMode(int n) throws ExceptionHugin {
        this.mode = n;
        this.modeChange = true;
        switch (n) {
            case 0: {
                this.computePoints();
                break;
            }
            case 1: {
                if (this.spline == null) {
                    this.spline = new Bspline((int)this.x1, (int)this.y1, (int)this.x2, (int)this.y2);
                }
                this.spline.setMode(n);
                this.spline.setSelected(this.selected);
                this.spline.setScaleFactor(this.scaleFactor);
                this.computePoints();
                break;
            }
            case 2: {
                if (this.spline == null) {
                    this.spline = new Bspline((int)this.x1, (int)this.y1, (int)this.x2, (int)this.y2);
                }
                this.spline.setMode(n);
                this.spline.setSelected(this.selected);
                this.spline.setScaleFactor(this.scaleFactor);
                this.computePoints();
            }
        }
        if (!this.isGhost) {
            HuginGUIUtils.setLinkMode(this.parent.getAPINode(), this.child.getAPINode().getName(), "" + n);
        }
        this.modeChange = false;
    }

    private void storePoints() {
        if (this.isGhost) {
            return;
        }
        try {
            if (this.spline == null) {
                return;
            }
            if (this.parent.getAPINode().getMaster() != null) {
                HuginGUIUtils.setLinkControlPointsInstance(this.parent.getAPINode().getInstance(), this.parent.getAPINode().getName(), this.child.getAPINode().getName(), this.spline.toString());
                HuginGUIUtils.setLinkModeInstance(this.parent.getAPINode().getInstance(), this.parent.getAPINode().getName(), this.child.getAPINode().getName(), "" + this.mode);
            } else {
                HuginGUIUtils.setLinkControlPoints(this.parent.getAPINode(), this.child.getAPINode().getName(), this.spline.toString());
                HuginGUIUtils.setLinkMode(this.parent.getAPINode(), this.child.getAPINode().getName(), "" + this.mode);
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    protected void restorePoints() {
        try {
            String string;
            String string2;
            if (this.parent.getAPINode().getMaster() != null) {
                string2 = HuginGUIUtils.getLinkControlPointsInstance(this.parent.getAPINode().getInstance(), this.parent.getAPINode().getName(), this.child.getAPINode().getName());
                string = HuginGUIUtils.getLinkModeInstance(this.parent.getAPINode().getInstance(), this.parent.getAPINode().getName(), this.child.getAPINode().getName());
            } else {
                string2 = HuginGUIUtils.getLinkControlPoints(this.parent.getAPINode(), this.child.getAPINode().getName());
                string = HuginGUIUtils.getLinkMode(this.parent.getAPINode(), this.child.getAPINode().getName());
            }
            if (string2 != null && string2.length() > 0) {
                if (this.spline == null) {
                    this.spline = new Bspline((int)this.x1, (int)this.y1, (int)this.x2, (int)this.y2);
                }
                this.spline.insertPoints(string2);
            } else {
                this.spline = null;
            }
            if (string != null && string.length() > 0) {
                this.setMode(Integer.parseInt(string));
            } else {
                this.setMode(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getMode() {
        return this.mode;
    }

    public boolean closeTo(Point point) {
        if (this.spline == null) {
            return false;
        }
        return this.spline.closeTo(point);
    }

    public boolean atControlPoint(Point point) {
        return this.atControlPoint(point, false);
    }

    public boolean atControlPoint(Point point, boolean bl) {
        if (this.movingControlPoint) {
            return true;
        }
        if (this.spline == null) {
            return false;
        }
        if (!bl) {
            return this.spline.selectPoint((int)point.getX(), (int)point.getY()) >= 0 || this.spline.closeTo(point);
        }
        return this.spline.selectPoint((int)point.getX(), (int)point.getY()) >= 0;
    }

    public void addControlPoint(Point point) {
        if (this.spline == null) {
            return;
        }
        this.spline.addPoint(point.getX(), point.getY());
        this.storePoints();
    }

    public void removeControlPoint() {
        this.spline.removePoint();
        this.computePoints();
        this.storePoints();
    }

    public void setPoints(Link link) {
        this.setLine(link.x1, link.y1, link.x2, link.y2);
        if (this.spline != null && link.getSpline() != null) {
            this.spline.setPts(link.getSpline().getPts());
        }
        this.computePoints();
    }

    public void updateActiveControlPoint(Point point) throws ExceptionHugin, InvalidPointException {
        if (this.spline == null) {
            return;
        }
        this.movingControlPoint = true;
        this.spline.setPoint((int)point.getX(), (int)point.getY());
        this.computePoints();
    }

    public Rectangle endControlPointUpdate() {
        this.movingControlPoint = false;
        if (this.spline != null) {
            this.spline.trim();
        }
        this.storePoints();
        return this.getBoundingBox();
    }

    public void paintSpline(Graphics2D graphics2D) {
        this.spline.paint(graphics2D);
    }

    public void printSpline(Graphics graphics, Point point) {
        this.spline.paint(graphics, point);
    }

    public boolean equals(Object object) {
        return object instanceof Link && ((Link)object).parent == this.parent && ((Link)object).child == this.child;
    }

    public Node getChild() {
        return this.child;
    }

    public Node getParent() {
        return this.parent;
    }
}

