/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIEventHandler;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginHelpButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Caret;

public class LogFileView
extends JPanel
implements HuginHelpButton.FinalHelpComponent {
    private NetworkModel model;
    private String logFileName;
    private JTextArea fileView;
    private JTextArea userView;
    private LogFileReader reader;
    private SearchPanel searcher;
    private HuginGUIFrame.LogMessageListener logListener;
    private JTabbedPane tabs;

    public LogFileView(Exception exception) {
        super(new BorderLayout());
        this.fileView = new JTextArea();
        this.fileView.setText(HuginGUIConstants.get("str_log_unavailable_lb") + exception.getMessage());
        this.fileView.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.fileView);
        this.tabs = new JTabbedPane();
        this.tabs.add(HuginGUIConstants.get("str_network_log"), jScrollPane);
        this.add(this.tabs);
        try {
            this.createUserView();
            JScrollPane jScrollPane2 = new JScrollPane(this.userView);
            this.tabs.add(HuginGUIConstants.get("str_usage_log"), jScrollPane2);
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    public LogFileView(NetworkModel networkModel) throws ExceptionHugin, FileNotFoundException {
        super(new BorderLayout());
        this.model = networkModel;
        this.tabs = new JTabbedPane();
        this.fileView = new JTextArea();
        this.fileView.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.fileView);
        this.tabs.add(HuginGUIConstants.get("str_network_log"), jScrollPane);
        this.createUserView();
        JScrollPane jScrollPane2 = new JScrollPane(this.userView);
        this.tabs.add(HuginGUIConstants.get("str_usage_log"), jScrollPane2);
        this.add(this.tabs);
        this.reader = new LogFileReader(this.fileView, jScrollPane);
        this.reader.addLogListener(new LogListener(){

            public void logClosed(Exception exception) {
                LogFileView.this.fileView.setText(LogFileView.this.fileView.getText() + "\n" + "========================================\n" + HuginGUIConstants.get("str_log_file_unavailable_") + exception.getMessage() + "========================================");
            }
        });
        this.reader.setFile(networkModel.getLogFile());
        this.searcher = new SearchPanel(this.fileView);
        this.searcher.addSearchListener(new SearchListener(){

            public void search(Search search) {
                if (LogFileView.this.performSearch(search, false) < 0 && JOptionPane.showConfirmDialog(Hugin.mainFrame, HuginGUIConstants.get("str_ARG0_not_found_wrap_search_", new String[]{"" + search.expression}), HuginGUIConstants.get("str_not_found"), 0) == 0 && LogFileView.this.performSearch(search, true) < 0) {
                    JOptionPane.showMessageDialog(Hugin.mainFrame, HuginGUIConstants.get("str_ARG0_not_found", new String[]{"" + search.expression}), HuginGUIConstants.get("str_not_found"), 1);
                }
            }
        });
        this.add((Component)this.searcher, "South");
    }

    public void setNetworkModel(NetworkModel networkModel) {
        try {
            this.model = networkModel;
            this.reader.updateFile(networkModel.getLogFile());
        }
        catch (Exception exception) {
            this.fileView.setText(HuginGUIConstants.get("str_log_unavailable_lb") + exception.getMessage());
        }
    }

    private int performSearch(Search search, boolean bl) {
        JTextArea jTextArea = (JTextArea)((JScrollPane)this.tabs.getSelectedComponent()).getViewport().getView();
        String string = jTextArea.getText();
        Caret caret = jTextArea.getCaret();
        if (bl) {
            caret.setDot(search.direction == 5 ? 0 : string.length());
        }
        int n = search.direction == 5 ? string.indexOf(search.expression, caret.getDot()) : string.substring(0, Math.max(0, caret.getDot() - 1)).lastIndexOf(search.expression);
        caret.setDot(n);
        caret.moveDot(n + search.expression.length());
        caret.setSelectionVisible(n >= 0);
        return n;
    }

    private void createUserView() {
        this.userView = new JTextArea(new Date() + "\n--------------------------------------------------\n");
        this.userView.setEditable(false);
        this.logListener = new HuginGUIFrame.LogMessageListener(){

            public void messageEntered(String string) {
                LogFileView.this.userView.append(string + "\n");
                Dimension dimension = LogFileView.this.userView.getSize();
                int n = (int)dimension.getHeight();
                LogFileView.this.userView.scrollRectToVisible(new Rectangle(0, n - 10, 10, n));
                Hugin.mainFrame.validate();
                Hugin.mainFrame.repaint();
            }
        };
        Hugin.mainFrame.getStatusBar().addLogMessageListener(this.logListener);
    }

    public void close() {
        if (this.reader != null) {
            this.reader.logStopped();
        }
        Hugin.mainFrame.getStatusBar().removeLogMessageListener(this.logListener);
    }

    public Dimension getPreferredSize() {
        return new Dimension(10, 100);
    }

    public JTextArea getActiveView() {
        return (JTextArea)((JScrollPane)this.tabs.getSelectedComponent()).getViewport().getView();
    }

    private class Search {
        int direction;
        String expression;

        public Search(int n, String string) {
            this.direction = n;
            this.expression = string;
        }
    }

    public static interface SearchListener {
        public void search(Search var1);
    }

    public static interface LogListener {
        public void logClosed(Exception var1);
    }

    private class LogFileReader
    extends Thread {
        private BufferedInputStream file;
        private boolean stopped = false;
        JTextArea view;
        JScrollPane scroller;
        private static final int CHUNKSIZE = 4096;
        private LinkedList<LogListener> logListeners = null;

        public LogFileReader(JTextArea jTextArea, JScrollPane jScrollPane) {
            this.view = jTextArea;
            this.scroller = jScrollPane;
        }

        public void setFile(String string) throws FileNotFoundException {
            this.file = new BufferedInputStream(new FileInputStream(string));
            this.start();
        }

        public void updateFile(String string) throws FileNotFoundException {
            BufferedInputStream bufferedInputStream = this.file;
            this.file = new BufferedInputStream(new FileInputStream(string));
        }

        public void logStopped() {
            this.stopped = true;
        }

        public void run() {
            int n = 0;
            byte[] byArray = new byte[4096];
            try {
                while (!this.stopped) {
                    n = Math.min(4096, this.file.available());
                    if (n > 0) {
                        byte[] byArray2;
                        long l = System.currentTimeMillis();
                        this.file.read(byArray, 0, n);
                        if (n < 4096) {
                            byArray2 = new byte[n];
                            for (int i = 0; i < n; ++i) {
                                byArray2[i] = byArray[i];
                            }
                        } else {
                            byArray2 = byArray;
                        }
                        this.view.append(new String(byArray2));
                        Dimension dimension = this.view.getPreferredSize();
                        this.view.setBounds(this.view.getX(), this.view.getY(), dimension.width, dimension.height);
                        Dimension dimension2 = this.scroller.getViewport().getExtentSize();
                        this.scroller.getViewport().setViewPosition(new Point(0, dimension.height - dimension2.height));
                        this.scroller.paintImmediately(0, 0, this.scroller.getWidth(), this.scroller.getHeight());
                        continue;
                    }
                    LogFileReader.sleep(1000L);
                }
                this.file.close();
            }
            catch (Exception exception) {
                try {
                    this.file.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this.fireLogClosed(exception);
            }
        }

        public void addLogListener(LogListener logListener) {
            if (this.logListeners == null) {
                this.logListeners = new LinkedList();
            }
            if (!this.logListeners.contains(logListener)) {
                this.logListeners.add(logListener);
            }
        }

        public void removeLogListener(LogListener logListener) {
            if (this.logListeners != null) {
                this.logListeners.remove(logListener);
            }
        }

        protected void fireLogClosed(Exception exception) {
            if (this.logListeners != null) {
                for (LogListener logListener : this.logListeners) {
                    logListener.logClosed(exception);
                }
            }
        }
    }

    private class SearchPanel
    extends JPanel {
        private JTextField search;
        private JButton doSearch;
        private JButton print;
        private JToggleButton up;
        private JToggleButton down;
        private JTextArea text;
        private LinkedList<SearchListener> searchListeners = null;

        public SearchPanel(JTextArea jTextArea) {
            this.setLayout(new BoxLayout(this, 0));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            this.text = jTextArea;
            this.search = new JTextField(30);
            this.search.setMaximumSize(this.search.getPreferredSize());
            this.doSearch = new JButton(HuginGUIConstants.get("str_search"));
            this.doSearch.setMaximumSize(this.doSearch.getPreferredSize());
            this.doSearch.setEnabled(false);
            this.search.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent caretEvent) {
                    SearchPanel.this.doSearch.setEnabled(SearchPanel.this.search.getText().length() > 0);
                }
            });
            this.doSearch.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SearchPanel.this.fireSearchPerformed(new Search(SearchPanel.this.up.isSelected() ? 1 : 5, SearchPanel.this.search.getText()));
                }
            });
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            this.up = new DirectionButton(1);
            this.up.setMaximumSize(new Dimension(20, 13));
            this.up.setToolTipText(HuginGUIConstants.get("str_search_up"));
            this.down = new DirectionButton(5);
            this.down.setMaximumSize(new Dimension(20, 13));
            this.down.setToolTipText(HuginGUIConstants.get("str_search_down"));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.up);
            buttonGroup.add(this.down);
            this.down.setSelected(true);
            jPanel2.add(this.up);
            jPanel2.add(this.down);
            JPanel jPanel3 = new JPanel(new FlowLayout(0));
            this.print = new JButton(new HuginGUIEventHandler.LOG_VIEW_Print_LogAction(LogFileView.this)){

                public Insets getInsets() {
                    return new Insets(2, 2, 2, 2);
                }
            };
            this.print.setText(null);
            jPanel.add(this.search);
            jPanel.add(this.doSearch);
            jPanel.add(jPanel2);
            jPanel3.add(this.print);
            this.add(jPanel3);
            this.add(jPanel);
        }

        public void addSearchListener(SearchListener searchListener) {
            if (this.searchListeners == null) {
                this.searchListeners = new LinkedList();
            }
            if (!this.searchListeners.contains(searchListener)) {
                this.searchListeners.add(searchListener);
            }
        }

        public void removeSearchListener(SearchListener searchListener) {
            if (this.searchListeners == null) {
                return;
            }
            this.searchListeners.remove(searchListener);
        }

        protected void fireSearchPerformed(Search search) {
            if (this.searchListeners != null) {
                for (SearchListener searchListener : this.searchListeners) {
                    searchListener.search(search);
                }
            }
        }

        private class DirectionButton
        extends JToggleButton {
            int direction;
            Color shadow;
            Color highlight;
            Color darkShadow;

            public DirectionButton(int n) {
                super("");
                this.direction = n;
                this.shadow = UIManager.getColor("controlShadow");
                this.darkShadow = UIManager.getColor("controlDkShadow");
                this.highlight = UIManager.getColor("controlLtHighlight");
                this.setPreferredSize(new Dimension(16, 12));
            }

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Dimension dimension = this.getSize();
                if (dimension == null) {
                    return;
                }
                int n = Math.min(dimension.width, dimension.height) / 3;
                this.paintTriangle(graphics, (dimension.width - n) / 2, (dimension.height - n) / 2, n, this.direction, this.isEnabled());
            }

            public void paintTriangle(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
                Color color = graphics.getColor();
                int n5 = 0;
                n3 = Math.max(n3, 2);
                int n6 = n3 / 2 - 1;
                graphics.translate(n, n2);
                if (bl) {
                    graphics.setColor(this.darkShadow);
                } else {
                    graphics.setColor(this.shadow);
                }
                switch (n4) {
                    case 1: {
                        int n7;
                        for (n7 = 0; n7 < n3; ++n7) {
                            graphics.drawLine(n6 - n7, n7, n6 + n7, n7);
                        }
                        if (bl) break;
                        graphics.setColor(this.highlight);
                        graphics.drawLine(n6 - n7 + 2, n7, n6 + n7, n7);
                        break;
                    }
                    case 5: {
                        int n8;
                        if (!bl) {
                            graphics.translate(1, 1);
                            graphics.setColor(this.highlight);
                            n8 = n3 - 1;
                            while (n8 >= 0) {
                                graphics.drawLine(n6 - n8, n5, n6 + n8, n5);
                                --n8;
                                ++n5;
                            }
                            graphics.translate(-1, -1);
                            graphics.setColor(this.shadow);
                        }
                        n8 = n3 - 1;
                        n5 = 0;
                        while (n8 >= 0) {
                            graphics.drawLine(n6 - n8, n5, n6 + n8, n5);
                            --n8;
                            ++n5;
                        }
                        break;
                    }
                }
                graphics.translate(-n, -n2);
                graphics.setColor(color);
            }
        }
    }
}

