/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.ScrollButtons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;

public class MultiToolbarPanel
extends JPanel {
    private Vector<Component> bars = new Vector();
    private LinkedList<Component> lineBreaks = new LinkedList();
    private EtchedBorder etch;
    private DragListener dragListener = null;
    private boolean draggable = true;
    private Component draggingBar = null;
    private Point dragPoint = null;
    private int yOffset = 0;
    private BufferedImage dragImage;

    public MultiToolbarPanel() {
        this(true);
    }

    public MultiToolbarPanel(boolean bl) {
        super(new MultiToolbarLayout());
        if (bl) {
            this.dragListener = new DragListener(){

                public void barDragged(Component component, Point point) {
                    MultiToolbarPanel.this.setBarPosition(component.getParent(), point);
                    MultiToolbarPanel.this.revalidate();
                }

                public void endDrag() {
                    MultiToolbarPanel.this.endBarDrag();
                }
            };
        }
        this.draggable = bl;
    }

    public void add(JComponent jComponent) {
        this.add(jComponent, false);
    }

    public void add(JComponent jComponent, boolean bl) {
        this.invalidate();
        DraggablePanel draggablePanel = new DraggablePanel(jComponent, this.dragListener, this.draggable);
        if (!bl) {
            draggablePanel.addSpace();
        }
        this.bars.add(draggablePanel);
        super.add(draggablePanel);
        if (bl && this.bars.size() > 1) {
            this.lineBreaks.add(draggablePanel);
        }
        HierarchyEvent hierarchyEvent = new HierarchyEvent(this, 1400, this, this.getParent(), 4L);
        this.dispatchEvent(hierarchyEvent);
        this.revalidate();
    }

    public void remove(JComponent jComponent) {
        this.invalidate();
        this.bars.remove(jComponent.getParent());
        this.lineBreaks.remove(jComponent.getParent());
        super.remove(jComponent.getParent());
        HierarchyEvent hierarchyEvent = new HierarchyEvent(this, 1400, this, this.getParent(), 4L);
        this.dispatchEvent(hierarchyEvent);
        this.revalidate();
        this.repaint();
    }

    public void clear() {
        this.invalidate();
        this.bars.clear();
        this.lineBreaks.clear();
        super.removeAll();
        HierarchyEvent hierarchyEvent = new HierarchyEvent(this, 1400, this, this.getParent(), 4L);
        this.dispatchEvent(hierarchyEvent);
        this.revalidate();
        this.repaint();
    }

    protected void setBarPosition(Component component, Point point) {
        if (this.draggingBar != component) {
            this.dragImage = new BufferedImage(component.getWidth(), component.getHeight(), 6);
            Graphics graphics = this.dragImage.getGraphics();
            Color color = component.getBackground();
            color = color.darker();
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 50));
            graphics.fillRect(0, 0, component.getWidth(), component.getHeight());
            BorderFactory.createEtchedBorder().paintBorder(component, graphics, 0, 0, component.getWidth(), component.getHeight());
        }
        this.draggingBar = component;
        this.dragPoint = SwingUtilities.convertPoint(component, point, this);
        this.dragPoint.y = ((MultiToolbarLayout)this.getLayout()).getLinePosition(this.dragPoint, this);
        ((MultiToolbarLayout)this.getLayout()).setBarPosition(component, SwingUtilities.convertPoint(component, point, this));
        this.repaint();
    }

    protected void endBarDrag() {
        this.invalidate();
        ((MultiToolbarLayout)this.getLayout()).endBarDrag();
        this.draggingBar = null;
        this.dragPoint = null;
        this.revalidate();
        this.repaint();
    }

    public int getBarCount() {
        return this.bars.size();
    }

    public Component getBarAt(int n) {
        return this.bars.get(n);
    }

    public boolean lineBreakAt(Component component) {
        return this.lineBreaks.contains(component);
    }

    public void setLineBreakAt(Component component) {
        if (!this.lineBreaks.contains(component)) {
            this.lineBreaks.add(component);
        }
    }

    protected void setLineBreakAfter(Component component) {
        int n = this.bars.indexOf(component);
        if (n == this.bars.size() - 1) {
            return;
        }
        Component component2 = this.bars.get(n + 1);
        if (!this.lineBreaks.contains(component2)) {
            this.lineBreaks.add(component2);
        }
    }

    public void removeLineBreakAt(Component component) {
        this.lineBreaks.remove(component);
    }

    protected void setBarAt(Component component, int n) {
        int n2 = this.bars.indexOf(component);
        if (n > n2) {
            --n;
        }
        this.bars.remove(component);
        this.bars.add(n, component);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.draggingBar != null && this.dragPoint != null) {
            graphics.setClip(0, 0, this.getWidth(), this.getHeight());
            graphics.drawImage(this.dragImage, this.dragPoint.x, this.dragPoint.y, this);
        }
    }

    private static interface DragListener {
        public void barDragged(Component var1, Point var2);

        public void endDrag();
    }

    private static class DragButton
    extends JLabel {
        private LinkedList<DragListener> dragListeners;
        private boolean dragCommenced = false;

        public DragButton() {
            super(" ");
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseDragged(MouseEvent mouseEvent) {
                    DragButton.this.fireDrag(mouseEvent);
                    DragButton.this.dragCommenced = true;
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (DragButton.this.dragCommenced) {
                        DragButton.this.fireDragEnded();
                    }
                    DragButton.this.dragCommenced = false;
                }
            });
            this.dragListeners = new LinkedList();
            this.setBorder(BorderFactory.createEtchedBorder(0));
        }

        public void addDragListener(DragListener dragListener) {
            if (!this.dragListeners.contains(dragListener)) {
                this.dragListeners.add(dragListener);
            }
        }

        public void removeDragListener(DragListener dragListener) {
            if (this.dragListeners.contains(dragListener)) {
                this.dragListeners.remove(dragListener);
            }
        }

        private void fireDrag(MouseEvent mouseEvent) {
            for (DragListener dragListener : this.dragListeners) {
                dragListener.barDragged(this, new Point(mouseEvent.getX(), mouseEvent.getY()));
            }
        }

        private void fireDragEnded() {
            for (DragListener dragListener : this.dragListeners) {
                dragListener.endDrag();
            }
        }
    }

    private static class MultiToolbarLayout
    implements LayoutManager {
        private Component bar = null;
        private Point position = null;
        private int vgap = 0;

        private MultiToolbarLayout() {
        }

        public void setBarPosition(Component component, Point point) {
            Container container;
            if (this.bar == null && (container = component.getParent()) instanceof MultiToolbarPanel && ((MultiToolbarPanel)container).lineBreakAt(component)) {
                ((MultiToolbarPanel)container).setLineBreakAfter(component);
            }
            this.bar = component;
            this.position = point;
        }

        public void endBarDrag() {
            this.fixPositions(this.bar.getParent());
            this.bar = null;
            this.position = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLayoutComponent(String string, Component component) {
            Object object = component.getTreeLock();
            synchronized (object) {
            }
        }

        private void fixPositions(Container container) {
            if (!(container instanceof MultiToolbarPanel)) {
                return;
            }
            MultiToolbarPanel multiToolbarPanel = (MultiToolbarPanel)container;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            Dimension dimension = new Dimension(0, 0);
            int n4 = 0;
            for (n4 = 0; n4 < multiToolbarPanel.getBarCount(); ++n4) {
                Component component = multiToolbarPanel.getBarAt(n4);
                if (this.bar == component) continue;
                dimension = component.getPreferredSize();
                if (this.position.x > n && this.position.x < n + dimension.width && this.position.y > n2 && this.position.y < n2 + dimension.height) {
                    multiToolbarPanel.setBarAt(this.bar, n4);
                    return;
                }
                if (multiToolbarPanel.lineBreakAt(component)) {
                    n = 0;
                    n2 += n3 + this.vgap;
                    n3 = 0;
                    if (this.position.x < dimension.width && this.position.y > n2 && this.position.y < n2 + dimension.height) {
                        multiToolbarPanel.setBarAt(this.bar, n4);
                        multiToolbarPanel.removeLineBreakAt(component);
                        multiToolbarPanel.setLineBreakAt(this.bar);
                        return;
                    }
                }
                n3 = Math.max(n3, dimension.height);
                n += dimension.width;
            }
            if (this.position.x > n && this.position.y > n2 && this.position.y < n2 + dimension.height || this.position.y > n2 + dimension.height) {
                multiToolbarPanel.setBarAt(this.bar, n4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                if (!(container instanceof MultiToolbarPanel)) {
                    return;
                }
                MultiToolbarPanel multiToolbarPanel = (MultiToolbarPanel)container;
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                Dimension dimension = new Dimension(0, 0);
                int n4 = 0;
                int n5 = this.getLineHeight(0, multiToolbarPanel);
                for (n4 = 0; n4 < multiToolbarPanel.getBarCount(); ++n4) {
                    Component component = multiToolbarPanel.getBarAt(n4);
                    if (this.bar == component) continue;
                    dimension = component instanceof DraggablePanel ? ((DraggablePanel)component).getLayoutSize() : component.getPreferredSize();
                    if (this.bar != null && this.position.x > n && this.position.x < n + dimension.width && this.position.y > n2 && this.position.y < n2 + dimension.height) {
                        dimension = this.bar.getPreferredSize();
                        multiToolbarPanel.removeLineBreakAt(this.bar);
                        this.bar.setBounds(n, n2, dimension.width, dimension.height);
                        n3 = Math.max(n3, dimension.height);
                        n += dimension.width;
                        dimension = component.getPreferredSize();
                    }
                    if (multiToolbarPanel.lineBreakAt(component)) {
                        n = 0;
                        n2 += n3 + this.vgap;
                        n3 = 0;
                        if (this.bar != null && this.position.x < dimension.width && this.position.y > n2 && this.position.y < n2 + dimension.height) {
                            multiToolbarPanel.removeLineBreakAt(this.bar);
                            this.bar.setBounds(n, n2, this.bar.getPreferredSize().width, this.bar.getPreferredSize().height);
                            n += this.bar.getPreferredSize().width;
                        }
                        n5 = this.getLineHeight(n4, multiToolbarPanel);
                    }
                    if (n + component.getMinimumSize().width >= container.getWidth()) {
                        n = 0;
                        n2 += n3 + this.vgap;
                        n3 = 0;
                    } else if (n + dimension.width > container.getWidth()) {
                        dimension.width = container.getWidth() - n;
                    }
                    component.setBounds(n, n2 + (n5 - dimension.height) / 2, dimension.width, dimension.height);
                    n3 = Math.max(n3, dimension.height);
                    n += dimension.width;
                }
                if (this.bar != null) {
                    if (this.position.x > n && this.position.x < n + dimension.width && this.position.y > n2 && this.position.y < n2 + dimension.height) {
                        dimension = this.bar.getPreferredSize();
                        multiToolbarPanel.removeLineBreakAt(this.bar);
                        this.bar.setBounds(n, n2, dimension.width, dimension.height);
                    }
                    if (this.position.y > n2 + dimension.height) {
                        dimension = this.bar.getPreferredSize();
                        this.bar.setBounds(0, n2 + n3 + this.vgap, dimension.width, dimension.height);
                        multiToolbarPanel.setLineBreakAt(this.bar);
                    }
                }
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container container) {
            if (!(container instanceof MultiToolbarPanel)) {
                return new Dimension(0, 0);
            }
            MultiToolbarPanel multiToolbarPanel = (MultiToolbarPanel)container;
            Dimension dimension = new Dimension(0, 0);
            int n = 0;
            int n2 = 0;
            int n3 = this.getLineHeight(0, multiToolbarPanel);
            for (int i = 0; i < multiToolbarPanel.getBarCount(); ++i) {
                Component component = multiToolbarPanel.getBarAt(i);
                Dimension dimension2 = component.getPreferredSize();
                if (multiToolbarPanel.lineBreakAt(component)) {
                    n3 = this.getLineHeight(i, multiToolbarPanel);
                }
                if (multiToolbarPanel.lineBreakAt(component) || component.getLocation().y >= n2 + n3 || multiToolbarPanel.getWidth() > 0 && multiToolbarPanel.getWidth() < n + component.getMinimumSize().width) {
                    n2 = dimension.height + this.vgap;
                    n = 0;
                }
                dimension.width = Math.max(dimension.width, n += dimension2.width);
                dimension.height = Math.max(dimension.height, n2 + n3);
            }
            return dimension;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLayoutComponent(Component component) {
            Object object = component.getTreeLock();
            synchronized (object) {
            }
        }

        private int getLineHeight(int n, MultiToolbarPanel multiToolbarPanel) {
            int n2;
            Component component = multiToolbarPanel.getBarAt(n);
            int n3 = component.getPreferredSize().height;
            if (!multiToolbarPanel.lineBreakAt(component)) {
                for (n2 = n - 1; n2 >= 0; --n2) {
                    component = multiToolbarPanel.getBarAt(n2);
                    if (component.getPreferredSize().height > n3) {
                        n3 = component.getPreferredSize().height;
                    }
                    if (multiToolbarPanel.lineBreakAt(component)) break;
                }
            }
            for (n2 = n + 1; n2 < multiToolbarPanel.getBarCount() && !multiToolbarPanel.lineBreakAt(component = multiToolbarPanel.getBarAt(n2)); ++n2) {
                if (component.getPreferredSize().height <= n3) continue;
                n3 = component.getPreferredSize().height;
            }
            return n3;
        }

        public int getLinePosition(Point point, Container container) {
            MultiToolbarPanel multiToolbarPanel = (MultiToolbarPanel)container;
            for (int i = 0; i < multiToolbarPanel.getBarCount(); ++i) {
                Component component = multiToolbarPanel.getBarAt(i);
                if (component.getY() >= point.y || component.getY() + component.getHeight() <= point.y) continue;
                return component.getY();
            }
            return -1;
        }
    }

    private class DraggablePanel
    extends JPanel {
        private JComponent drag;
        private JComponent bar;

        public DraggablePanel(JComponent jComponent, DragListener dragListener, boolean bl) {
            this.setLayout(new BorderLayout());
            if (bl) {
                this.drag = new DragButton();
                if (dragListener != null) {
                    ((DragButton)this.drag).addDragListener(dragListener);
                }
                this.add((Component)this.drag, "West");
            }
            this.add(jComponent);
            this.bar = jComponent;
        }

        public void addSpace() {
            this.drag = new JSeparator(1);
            this.add((Component)this.drag, "West");
        }

        public Dimension getLayoutSize() {
            Dimension dimension = this.drag != null ? this.drag.getPreferredSize() : new Dimension(0, 0);
            if (this.bar instanceof ScrollButtons) {
                Component component = ((ScrollButtons)this.bar).getInternal();
                Dimension dimension2 = component == null ? new Dimension(0, 0) : component.getPreferredSize();
                return new Dimension(dimension.width + dimension2.width, Math.max(dimension.height, dimension2.height));
            }
            Dimension dimension3 = this.bar.getPreferredSize();
            dimension.width += dimension3.width;
            dimension.height = Math.max(dimension3.height, dimension.height);
            return dimension;
        }
    }
}

