/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.PastingTextArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class NetworkInformationPane
extends JDialog {
    NetworkInformationPane self;
    JTabbedPane pane;
    JPanel logPanel;
    String title;
    HuginProjectFrame projectFrame;
    Domain domain;

    public NetworkInformationPane(String string, HuginProjectFrame huginProjectFrame) throws ExceptionHugin {
        super(Hugin.mainFrame, string, true);
        this.setResizable(true);
        this.self = this;
        this.title = string;
        this.projectFrame = huginProjectFrame;
        this.domain = null;
        this.init();
    }

    public NetworkInformationPane(String string, Domain domain) throws ExceptionHugin {
        super(Hugin.mainFrame, string, true);
        this.setResizable(true);
        this.self = this;
        this.title = string;
        this.projectFrame = null;
        this.domain = domain;
        this.init();
    }

    private void init() throws ExceptionHugin {
        this.pane = new JTabbedPane();
        this.drawLogPane();
        this.pane.add((Component)this.logPanel, HuginGUIConstants.get("LOG_compilation_log"));
        JButton jButton = new JButton(HuginGUIConstants.get("ABOUT_ok"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetworkInformationPane.this.self.dispose();
            }
        });
        Box box = new Box(0);
        box.add(Box.createHorizontalGlue());
        box.add(jButton);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(10, 10));
        container.add((Component)this.pane, "Center");
        container.add((Component)box, "South");
        if (System.getProperty("os.name").equals("Linux")) {
            this.setSize((int)this.getPreferredSize().getWidth() + 10, (int)this.getPreferredSize().getHeight() + 30);
        }
        this.getRootPane().setDefaultButton(jButton);
    }

    public void drawLogPane() throws ExceptionHugin {
        Object object;
        Object object2;
        this.logPanel = new JPanel(new BorderLayout(10, 10)){

            public Insets getInsets() {
                return new Insets(10, 10, 10, 10);
            }
        };
        Box box = new Box(0);
        JLabel jLabel = new JLabel(new ImageIcon(ClassLoader.getSystemResource("icons/nodeicon.gif")));
        String string = !this.title.equals(HuginGUIConstants.get("MISCELLANEOUS_not_available")) ? (this.domain == null ? this.projectFrame.getLogFile().getPath() : this.domain.getLogFile()) : this.title;
        JLabel jLabel2 = new JLabel(string);
        jLabel2.setAlignmentY(0.5f);
        jLabel.setAlignmentY(0.5f);
        box.add(jLabel);
        box.add(Box.createRigidArea(new Dimension(10, 10)));
        box.add(jLabel2);
        PastingTextArea pastingTextArea = new PastingTextArea();
        pastingTextArea.setBorder(BorderFactory.createLoweredBevelBorder());
        pastingTextArea.setBackground(Color.white);
        pastingTextArea.setEditable(false);
        try {
            object2 = this.domain == null ? new BufferedReader(new FileReader(this.projectFrame.getLogFile().getPath())) : new BufferedReader(new FileReader(this.domain.getLogFile()));
            object = ((BufferedReader)object2).readLine();
            while (object != null) {
                if (((String)object).indexOf("HR_Syntax_Error") < 0) {
                    pastingTextArea.append((String)object + "\n");
                } else {
                    int n = ((String)object).indexOf(32) + 1;
                    int n2 = ((String)object).indexOf(32, n);
                    pastingTextArea.append(HuginGUIConstants.get("str_a_syntax_error_has_been_detected_in_expression_for_node_") + ((String)object).substring(n, n2) + "\n");
                }
                object = ((BufferedReader)object2).readLine();
            }
        }
        catch (IOException iOException) {
            new HuginGUIError(iOException.getMessage());
        }
        pastingTextArea.setCaretPosition(0);
        object2 = new JScrollPane(pastingTextArea);
        ((JComponent)object2).setPreferredSize(new Dimension(400, 200));
        object = new Box(1);
        PastingTextArea pastingTextArea2 = new PastingTextArea(HuginGUIConstants.get("LOG_log_information"));
        pastingTextArea2.setLineWrap(true);
        pastingTextArea2.setWrapStyleWord(true);
        pastingTextArea2.setEditable(false);
        pastingTextArea2.setBackground(this.logPanel.getBackground());
        pastingTextArea2.setAlignmentX(0.0f);
        ((Container)object).add(pastingTextArea2);
        Box box2 = new Box(0);
        box2.add(Box.createRigidArea(new Dimension(10, 10)));
        box2.add((Component)object);
        this.logPanel.add((Component)box, "North");
        this.logPanel.add((Component)object2, "Center");
        this.logPanel.add((Component)box2, "South");
    }
}

