/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Class;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.PastingTextField;
import COM.hugin.HGUI.PronelPanel;
import COM.hugin.HGUI.TitledPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class NetworkNamingPane
extends JDialog {
    private NetworkNamingPane self = this;
    private PastingTextField nameField;
    private Class home;
    private HuginProjectFrame project;
    private String oldName;
    protected static final int LEGAL_NAME = 0;
    protected static final int ILLEGAL_NAME_SYNTAX = 1;
    protected static final int ILLEGAL_NAME_EXTENSION = 2;
    protected static final int ILLEGAL_NAME_EXISTS = 3;
    protected static final int ILLEGAL_NODE_NAME = 4;
    private static final String V57_EXT = "_v57";

    public NetworkNamingPane(HuginProjectFrame huginProjectFrame) {
        super(Hugin.mainFrame, HuginGUIConstants.get("NETWORK_NAMING_PANE_TITLE"), true);
        this.project = huginProjectFrame;
        this.home = huginProjectFrame.getNetworkPanel().getHomeClass();
        try {
            TitledPanel titledPanel = new TitledPanel(HuginGUIConstants.get("NETWORK_RENAMING"));
            JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 5));
            this.oldName = huginProjectFrame.getShortFileName();
            this.nameField = new PastingTextField(this.oldName);
            this.nameField.setHorizontalAlignment(2);
            this.nameField.setBackground(Color.white);
            jPanel.add(new JLabel(HuginGUIConstants.get("NETWORK_NAME_LABEL")));
            jPanel.add(this.nameField);
            JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
            JButton jButton = new JButton(HuginGUIConstants.get("OK_button"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HuginProjectFrame huginProjectFrame;
                    String string = NetworkNamingPane.this.nameField.getText();
                    int n = NetworkNamingPane.nameStatus(string, (huginProjectFrame = NetworkNamingPane.this.project).getFileType(), huginProjectFrame);
                    if (n == 0) {
                        if (!NetworkNamingPane.this.oldName.equals(string)) {
                            try {
                                huginProjectFrame.setProjectName(string);
                                huginProjectFrame.isSaved(false);
                                huginProjectFrame.getNetworkPanel().containsUnsavedChanges(true);
                                huginProjectFrame.guiFrame.statusBar.write(HuginGUIConstants.get("NETWORK_RENAMING_RENAMED"));
                            }
                            catch (Exception exception) {
                                NetworkNamingPane.illegalName(NetworkNamingPane.this, 3);
                            }
                        } else {
                            huginProjectFrame.guiFrame.statusBar.clear();
                        }
                        NetworkNamingPane.this.self.dispose();
                    } else {
                        NetworkNamingPane.illegalName(NetworkNamingPane.this, n);
                    }
                }
            });
            JButton jButton2 = new JButton(HuginGUIConstants.get("cancel_button"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((NetworkNamingPane)NetworkNamingPane.this).project.guiFrame.statusBar.clear();
                    NetworkNamingPane.this.self.dispose();
                }
            });
            this.getRootPane().setDefaultButton(jButton);
            jPanel2.add(jButton);
            jPanel2.add(jButton2);
            titledPanel.setLayout(new BorderLayout(0, 5));
            titledPanel.add((Component)jPanel, "Center");
            titledPanel.add((Component)jPanel2, "South");
            this.getContentPane().setLayout(new BorderLayout(0, 5));
            this.getContentPane().add((Component)titledPanel, "Center");
            if (System.getProperty("os.name").equals("Linux")) {
                this.setSize((int)this.getPreferredSize().getWidth() + 10, (int)this.getPreferredSize().getHeight() + 30);
            }
            this.setResizable(false);
        }
        catch (Exception exception) {
            this.showError(HuginGUIConstants.get("str_unexpected_error_lb") + exception.getMessage());
        }
    }

    protected static int nameStatus(String string, int n, HuginProjectFrame huginProjectFrame) {
        String string2;
        boolean bl;
        if (string == null || string == "") {
            return 1;
        }
        if (huginProjectFrame == null || n == 4 || n == 5 || n == 12 || n == 1) {
            return 0;
        }
        int n2 = 0;
        boolean bl2 = bl = n != -1;
        if (bl && (n2 = string.lastIndexOf(46)) > 0 && !NetworkNamingPane.legalExtension(string.substring(n2 + 1), n)) {
            return 2;
        }
        String string3 = string2 = bl && n2 > 0 ? string.substring(0, n2) : string;
        if (NetworkNamingPane.nameExists(string2, huginProjectFrame)) {
            return 3;
        }
        return NetworkNamingPane.nameIsLegal(string2) ? 0 : 1;
    }

    private static boolean nameExists(String string, HuginProjectFrame huginProjectFrame) {
        for (HuginProjectFrame huginProjectFrame2 : HuginGUIFrame.getProjectFrames()) {
            if (huginProjectFrame != null && huginProjectFrame2.equals(huginProjectFrame) || huginProjectFrame2.getNetworkPanel() == null) continue;
            try {
                if (!(huginProjectFrame2.getNetworkPanel() instanceof PronelPanel ? huginProjectFrame2.getNetName().equals(string) : huginProjectFrame2.getNetworkPanel().getHomeClass() != null && huginProjectFrame2.getNetworkPanel().getHomeClass().getName().equals(string))) continue;
                return true;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
        return false;
    }

    protected static boolean nameIsLegal(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < string.length(); ++i) {
            if (NetworkNamingPane.legalChar(cArray[i], i == 0)) continue;
            return false;
        }
        return true;
    }

    protected static String legalize(String string) {
        return NetworkNamingPane.legalize(string, false, null, false);
    }

    protected static String legalize(String string, boolean bl) {
        return NetworkNamingPane.legalize(string, false, null, bl);
    }

    protected static String legalize(String string, boolean bl, boolean bl2) {
        return NetworkNamingPane.legalize(string, bl, null, bl2);
    }

    protected static String legalize(String string, HuginProjectFrame huginProjectFrame) {
        return NetworkNamingPane.legalize(string, false, huginProjectFrame, huginProjectFrame.isPre60());
    }

    private static String legalize(String string, boolean bl, HuginProjectFrame huginProjectFrame, boolean bl2) {
        int n;
        String string2 = "";
        if (string == null || string.trim().length() == 0) {
            String string3 = "N1";
            int n2 = 2;
            while (NetworkNamingPane.nameExists(string3, null)) {
                string3 = "N" + n2;
                ++n2;
            }
            return string3 + string2;
        }
        int n3 = string.lastIndexOf(46);
        if (n3 > 0 && NetworkNamingPane.legalExtension(string.substring(n3 + 1), 0)) {
            string = string.substring(0, n3);
        }
        if (!NetworkNamingPane.legalChar(string.charAt(0), true)) {
            string = "N" + string;
        }
        char[] cArray = string.toCharArray();
        for (n = 1; n < string.length(); ++n) {
            if (NetworkNamingPane.legalChar(cArray[n], n == 0)) continue;
            cArray[n] = 95;
        }
        String string4 = new String(cArray);
        if (!bl) {
            n = 2;
            while (NetworkNamingPane.nameExists(string4, huginProjectFrame)) {
                string4 = new String(cArray) + "_" + n;
                ++n;
            }
        }
        return string4 + string2;
    }

    private static boolean legalExtension(String string, int n) {
        return n == 0 && (string.equals("oobn") || string.equals("net") || string.equals("hkb")) || n == 3 && (string.equals("oobn") || string.equals("net")) || n == 4 && string.equals("net") || n == 5 && string.equals("hkb");
    }

    private static boolean legalChar(char c, boolean bl) {
        if (bl) {
            return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
        }
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_';
    }

    protected static void illegalName(Component component, int n) {
        String string = n == 1 ? HuginGUIConstants.get("NETWORK_NAME_ILLEGAL_SYNTAX_DESC") : (n == 2 ? HuginGUIConstants.get("NETWORK_NAME_ILLEGAL_EXT_DESC") : (n == 3 ? HuginGUIConstants.get("NETWORK_NAME_ILLEGAL_EXISTS_DESC") : (n == 4 ? HuginGUIConstants.get("NODE_NAME_ILLEGAL_SYNTAX_DESC") : HuginGUIConstants.get("str_internal_error_unkown_status"))));
        new JOptionPane();
        JOptionPane.showMessageDialog(component, string, HuginGUIConstants.get("NETWORK_NAMING_ERROR"), 0);
    }

    private void showError(String string) {
        JOptionPane jOptionPane = new JOptionPane();
        JOptionPane.showMessageDialog(this, string, HuginGUIConstants.get("NETWORK_NAMING_ERROR"), 0);
    }
}

