/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.BooleanDCNode;
import COM.hugin.HAPI.BooleanDDNode;
import COM.hugin.HAPI.Class;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionCyclicNetwork;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionMemory;
import COM.hugin.HAPI.ExceptionUsage;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HAPI.IntervalDDNode;
import COM.hugin.HAPI.LabelledDCNode;
import COM.hugin.HAPI.LabelledDDNode;
import COM.hugin.HAPI.Model;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.NumberedDCNode;
import COM.hugin.HAPI.NumberedDDNode;
import COM.hugin.HAPI.Table;
import COM.hugin.HGUI.BeliefBarPanel;
import COM.hugin.HGUI.BeliefMonitor;
import COM.hugin.HGUI.CDVTLink;
import COM.hugin.HGUI.ContinuousChanceNode;
import COM.hugin.HGUI.DSeparationDialog;
import COM.hugin.HGUI.DiscreteChanceNode;
import COM.hugin.HGUI.DiscreteDecisionNode;
import COM.hugin.HGUI.DiscreteNode;
import COM.hugin.HGUI.DomainAttributes;
import COM.hugin.HGUI.FunctionNode;
import COM.hugin.HGUI.HStroke;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIEventHandler;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginKeyListener;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.HyperlinkEventHandler;
import COM.hugin.HGUI.InstanceNode;
import COM.hugin.HGUI.InvalidPointException;
import COM.hugin.HGUI.Link;
import COM.hugin.HGUI.NetworkInformation;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.NodeTableFrame;
import COM.hugin.HGUI.PastingTextArea;
import COM.hugin.HGUI.PopupClassesList;
import COM.hugin.HGUI.RunModePoliciesWindow;
import COM.hugin.HGUI.TraversalFrame;
import COM.hugin.HGUI.UsefullList;
import COM.hugin.HGUI.UtilityNode;
import COM.hugin.HGUI.VerticalFlowLayout;
import COM.hugin.HGUI.ZoomingPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractList;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkPanel
extends JDesktopPane
implements MouseListener,
MouseMotionListener {
    protected HuginGUIFrame guiFrame = null;
    protected HuginProjectFrame projectFrame = null;
    protected NetworkModel home = null;
    private Class instanceNodeClass = null;
    private boolean isEmpty = true;
    protected Dimension graphicsSize = new Dimension(0, 0);
    protected boolean toggleScroll = true;
    protected boolean containsUnsavedChanges = false;
    protected boolean containsUncompiledChanges = false;
    private boolean nodeResizingInitiated = false;
    private int cornerPoint = -1;
    private Node resizingNode = null;
    private Rectangle nodeResizingBox = null;
    private boolean dragLinkControlPointInitiated = false;
    private boolean controlPointAdded = false;
    private boolean inEditMode = true;
    protected static final int SELECT_MODE = 0;
    protected static final int DISCRETE_CHANCE_MODE = 1;
    protected static final int CONTINUOUS_CHANCE_MODE = 2;
    protected static final int LINK_MODE = 3;
    protected static final int UTILITY_MODE = 4;
    protected static final int DISCRETE_DECISION_MODE = 5;
    protected static final int INSTANCE_MODE = 6;
    protected static final int FUNCTION_MODE = 7;
    private int mode = 0;
    private static final int NORMAL_MODE = 0;
    private static final int DSEPARATION_MODE = 1;
    private static final int NODE_RELATION_MODE = 2;
    private static final int MARKOV_BLANKET_MODE = 3;
    private static final int MINIMIZE_LIMID_MODE = 4;
    private int special_mode = 0;
    protected ListOfNodes nodeList = new ListOfNodes();
    protected ListOfSelectedNodes selectedNodes = new ListOfSelectedNodes();
    protected LinkedList<Node> secretListOfInstanceMembers = new LinkedList();
    protected int nodeListHash = this.nodeList.hashCode();
    private boolean graphsToUpdate = false;
    private boolean includeMonitors = false;
    private InstanceNode.InstanceNodeListener instanceNodeListener = new InstanceNode.InstanceNodeListener(){

        public void classToBeReplaced(InstanceNode instanceNode) throws ExceptionHugin {
            for (Node node : instanceNode.getInputs()) {
                NetworkPanel.this.deleteLinksFor(node);
            }
        }

        public void classReplaced(InstanceNode instanceNode) throws ExceptionHugin {
            NetworkPanel.this.createLinksFor(instanceNode.getAPINode());
            Rectangle rectangle = null;
            for (Node node : instanceNode.getOutputs()) {
                for (Link link : NetworkPanel.this.linkList) {
                    if (link.parent != node) continue;
                    if (rectangle == null) {
                        rectangle = link.getBoundingBox();
                    } else {
                        rectangle.add(link.getBoundingBox());
                    }
                    link.computePoints();
                    rectangle.add(link.getBoundingBox());
                }
            }
            if (rectangle != null) {
                NetworkPanel.this.repaint(rectangle);
            }
        }
    };
    private static LinkedList<Node> nodeBuffer = new LinkedList();
    private static LinkedList<Link> linkBuffer = new LinkedList();
    protected static Table nodeTableCopy = null;
    protected static Node nodeTableCopyFrom = null;
    private static boolean bufferedNodesAreCut;
    protected LinkedList<Link> linkList = new LinkedList();
    protected LinkedList<Link> selectedLinks = new LinkedList();
    protected int linkListHash = this.linkList.hashCode();
    protected LinkedList<Node> ghostNodes = new LinkedList();
    protected int ghostNodesHash = this.ghostNodes.hashCode();
    protected LinkedList<Link> ghostLinks = new LinkedList();
    protected Node sourceNode;
    protected Point mousePressedAt = new Point();
    protected SelectRegion selectRegion = null;
    protected Graphics2D g2 = null;
    protected Dimension grid = new Dimension();
    protected double gridWidth;
    protected double gridHeight;
    protected boolean snapToGrid;
    protected boolean showGrid;
    protected double scaleFactor = 1.0;
    private boolean showTables = false;
    protected static final int TABLE_MODE_CPT = 0;
    protected static final int TABLE_MODE_EXPERIENCE = 1;
    protected static final int TABLE_MODE_FADING = 2;
    private int tableMode = 0;
    private DescriptionFrame descriptionFrame = new DescriptionFrame();
    private static final Color NO_DESC_TEXT_COLOR;
    private static final Color DESC_TEXT_COLOR;
    private Color descriptionTextColor;
    protected Cursor defaultCursor;
    private Cursor dcnCursor;
    private Cursor ccnCursor;
    private Cursor ddnCursor;
    private Cursor utilCursor;
    private Cursor instanceCursor;
    private Cursor linkCursor;
    private Cursor functionCursor;
    protected Cursor selectCursor;
    protected Cursor moveCursor;
    private Cursor instanceCollapseCursor;
    private Cursor instanceExpandCursor;
    private Cursor interfaceLeftCursor;
    private Cursor interfaceRightCursor;
    protected Cursor hourglassCursor;
    protected Cursor resizeLowerLeftCursor;
    protected Cursor resizeLowerRightCursor;
    private Image background = null;
    protected int nodeWidth = 0;
    protected int nodeHeight = 0;
    protected boolean updateNodeSize = false;
    private double arcSize;
    String toolTipText = null;
    private boolean scrollToSelected = false;
    Rectangle dirtyRect = null;
    Image repaintImage = null;
    boolean forceRepaint = false;
    Rectangle oldSize = null;
    boolean wasAntiAliased = true;
    private Rectangle panelRect = new Rectangle();
    private InstanceNode almostTouchedInstanceNode = null;
    private Dimension graphicsDimension = new Dimension();
    private Dimension solidNodesDimension = new Dimension();
    private Dimension ghostNodesDimension = new Dimension();
    private Dimension monitorsDimension = new Dimension();
    private Dimension linksDimension = new Dimension();
    protected Rectangle ghostGraphBoundingBox = new Rectangle();
    protected Rectangle prevGhostGraphBoundingBox = new Rectangle();
    protected Rectangle ghostLinkBoundingBox = new Rectangle();
    protected Rectangle prevGhostLinkBoundingBox = new Rectangle();
    private Point prevPoint = new Point();
    private Point snapPoint = new Point();
    private Node targetNode;
    private Point startingDragPoint = null;
    protected boolean deleteInProgress = false;
    private int pasteNumber = 0;
    protected static final int DEFAULT_FONT_SIZE = 12;
    protected static final Font DEFAULT_FONT;
    private boolean alreadyCheckedForOOBNTrouble = false;
    LinkedList<SelectionListener> selectionListeners = null;

    protected NetworkModel getHome() {
        return this.home;
    }

    protected Class getHomeClass() {
        return this.home instanceof Class ? (Class)this.home : null;
    }

    protected int getMode() {
        return this.mode;
    }

    private int getSpecialMode() {
        return this.special_mode;
    }

    protected void setIncludeMonitors(boolean bl) {
        this.includeMonitors = bl;
    }

    protected static boolean clipBoardIsEmpty() {
        return nodeBuffer.size() == 0;
    }

    protected void setTableMode(int n) {
        if (n == 0 || n == 1 || n == 2) {
            this.tableMode = n;
        }
    }

    protected int getTableMode() {
        return this.tableMode;
    }

    protected void setNodeSize(Dimension dimension) {
        this.setNodeSize(dimension.width, dimension.height);
    }

    protected void setNodeSize(int n, int n2) {
        this.updateNodeSize = this.updateNodeSize || this.nodeWidth != 0 && this.nodeHeight != 0 && (n != this.nodeWidth || n2 != this.nodeHeight);
        this.nodeWidth = n;
        this.nodeHeight = n2;
        this.setArcSize();
    }

    protected void setNodeSize() {
        this.setNodeSize(this.getNodeSize());
    }

    protected double getNodeWidth() {
        return this.nodeWidth;
    }

    protected double getNodeHeight() {
        return this.nodeHeight;
    }

    private void setArcSize() {
        this.arcSize = (double)Math.min(this.nodeWidth, this.nodeHeight) * 0.75;
    }

    protected double getArcSize() {
        return this.arcSize;
    }

    public NetworkPanel(HuginProjectFrame huginProjectFrame, NetworkModel networkModel) {
        this(huginProjectFrame, networkModel, true);
    }

    public NetworkPanel(HuginProjectFrame huginProjectFrame, NetworkModel networkModel, boolean bl) {
        this.guiFrame = huginProjectFrame.guiFrame;
        this.projectFrame = huginProjectFrame;
        this.createCursors();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(new HuginKeyListener(this));
        this.setBackground(Color.white);
        this.add(this.descriptionFrame);
        this.loadNet(networkModel, bl);
        this.setToolTipText("Dummy");
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        return this.toolTipText;
    }

    public NetworkPanel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBackground() {
        if (this.home != null) {
            block13: {
                try {
                    String string = this.home.getAttribute("HR_Background_Image");
                    if (string != null) {
                        try {
                            ImageObserver imageObserver;
                            FileInputStream fileInputStream = new FileInputStream(string);
                            byte[] byArray = new byte[fileInputStream.available()];
                            fileInputStream.read(byArray);
                            fileInputStream.close();
                            ImageObserver imageObserver2 = imageObserver = new ImageObserver(){

                                public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
                                    if ((n & 0x20) != 0) {
                                        this.notify();
                                        return false;
                                    }
                                    if ((n & 0x80) != 0 || (n & 0x40) != 0) {
                                        this.notify();
                                        NetworkPanel.this.background = null;
                                        return false;
                                    }
                                    return true;
                                }
                            };
                            synchronized (imageObserver2) {
                                this.background = Toolkit.getDefaultToolkit().createImage(byArray);
                                if (this.background.getHeight(imageObserver) < 0) {
                                    imageObserver.wait();
                                }
                                if (this.background == null) {
                                    new HuginGUIError(HuginGUIConstants.get("str_file_is_not_a_gif_jpg_png_image_") + string);
                                }
                                break block13;
                            }
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            this.background = null;
                            new HuginGUIError(HuginGUIConstants.get("str_unable_to_read_the_file_") + fileNotFoundException.getMessage());
                        }
                        catch (IOException iOException) {
                            this.background = null;
                            new HuginGUIError(HuginGUIConstants.get("str_unable_to_read_the_file_") + iOException.getMessage());
                        }
                        catch (InterruptedException interruptedException) {
                            this.background = null;
                            new HuginGUIError(HuginGUIConstants.get("str_unable_to_read_the_file_") + interruptedException.getMessage());
                        }
                        break block13;
                    }
                    this.background = null;
                }
                catch (ExceptionHugin exceptionHugin) {
                    new HuginGUIError(exceptionHugin.getMessage());
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NetworkPanel.this.repaint();
                }
            });
        }
    }

    protected void createCursors() {
        try {
            Toolkit toolkit = this.getToolkit();
            Point point = HuginGUIConstants.TOOL_CURSORS_HOTSPOT;
            Image image = HuginGUIConstants.DCN_CURSOR_IMAGE;
            this.dcnCursor = toolkit.createCustomCursor(image, point, "DCN Cursor");
            image = HuginGUIConstants.FUNCTION_CURSOR_IMAGE;
            this.functionCursor = toolkit.createCustomCursor(image, point, "Function Cursor");
            image = HuginGUIConstants.CCN_CURSOR_IMAGE;
            this.ccnCursor = toolkit.createCustomCursor(image, point, "CCN Cursor");
            image = HuginGUIConstants.DDN_CURSOR_IMAGE;
            this.ddnCursor = toolkit.createCustomCursor(image, point, "DDN Cursor");
            image = HuginGUIConstants.UTIL_CURSOR_IMAGE;
            this.utilCursor = toolkit.createCustomCursor(image, point, "UTIL Cursor");
            image = HuginGUIConstants.INSTANCE_CURSOR_IMAGE;
            this.instanceCursor = toolkit.createCustomCursor(image, point, "INSTANCE Cursor");
            image = HuginGUIConstants.LINK_CURSOR_IMAGE;
            this.linkCursor = toolkit.createCustomCursor(image, point, "LINK Cursor");
            image = HuginGUIConstants.INSTANCE_COLLAPSE_CURSOR_IMAGE;
            point = HuginGUIConstants.INSTANCE_CURSORS_HOTSPOT;
            this.instanceCollapseCursor = toolkit.createCustomCursor(image, point, "INSTANCE COLLAPSE Cursor");
            image = HuginGUIConstants.INSTANCE_EXPAND_CURSOR_IMAGE;
            this.instanceExpandCursor = toolkit.createCustomCursor(image, point, "INSTANCE EXPAND Cursor");
            point = HuginGUIConstants.INTERFACE_CURSORS_HOTSPOT;
            image = HuginGUIConstants.INTERFACE_LEFT_CURSOR_IMAGE;
            this.interfaceLeftCursor = toolkit.createCustomCursor(image, point, "INTERFACE LEFT Cursor");
            image = HuginGUIConstants.INTERFACE_RIGHT_CURSOR_IMAGE;
            this.interfaceRightCursor = toolkit.createCustomCursor(image, point, "INTERFACE RIGHT Cursor");
            point = HuginGUIConstants.SELECT_CURSOR_HOTSPOT;
            image = HuginGUIConstants.SELECT_CURSOR_IMAGE;
            this.selectCursor = toolkit.createCustomCursor(image, point, "SELECT Cursor");
            image = HuginGUIConstants.MOVE_CURSOR_IMAGE;
            this.moveCursor = toolkit.createCustomCursor(image, point, "MOVE Cursor");
            image = HuginGUIConstants.HOURGLASS_CURSOR_IMAGE;
            this.hourglassCursor = toolkit.createCustomCursor(image, point, "HOURGLASS Cursor");
            this.defaultCursor = Cursor.getDefaultCursor();
        }
        catch (Exception exception) {
            new HuginGUIError("NetworkPanel.createCursors", HuginGUIConstants.get("str_failed_to_create_cursor"));
        }
    }

    protected void loadNet(NetworkModel networkModel) {
        this.loadNet(networkModel, true);
    }

    protected void loadNet(NetworkModel networkModel, boolean bl) {
        this.home = networkModel;
        try {
            HuginGUIUtils.convertLegacyLinkConfigurationAttributes(networkModel);
            this.readDomainAttributes();
            if (this.projectFrame.isPre60() && bl) {
                HuginProjectFrame.flipNet(networkModel);
            }
            NodeList nodeList = networkModel.getNodes();
            for (COM.hugin.HAPI.Node node : nodeList) {
                if (NetworkPanel.isOutputClone(node)) continue;
                Node node2 = this.createNodeFromAPINode(node);
                if (node2 != null) {
                    this.nodeList.add(node2);
                    if (networkModel instanceof Class) {
                        node2.setInterfaceType();
                    }
                    this.isEmpty(false);
                    continue;
                }
                new HuginGUIError("NetworkPanel.loadNet", HuginGUIConstants.get("str_unkown_node_class"));
            }
            for (COM.hugin.HAPI.Node node : nodeList) {
                this.createLinksFor(node);
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            this.snapToGrid = true;
            this.showGrid = false;
        }
        this.readNodeAttributes();
        this.updateButtonAndMenuStates();
        this.setGraphicsSize();
    }

    private void createLinksFor(COM.hugin.HAPI.Node node) throws ExceptionHugin {
        for (Cloneable cloneable : node.getChildren()) {
            this.linkList.add(new Link(this.getNode(node), this.getNode((COM.hugin.HAPI.Node)cloneable), this.scaleFactor));
        }
        if (node instanceof COM.hugin.HAPI.InstanceNode) {
            Cloneable cloneable;
            COM.hugin.HAPI.InstanceNode instanceNode = (COM.hugin.HAPI.InstanceNode)node;
            cloneable = (InstanceNode)this.getNode(instanceNode);
            for (Node node2 : ((InstanceNode)cloneable).inputs) {
                COM.hugin.HAPI.Node node3 = instanceNode.getInput(node2.getAPINode());
                if (node3 == null) continue;
                Node node4 = this.getNode(node3);
                this.linkList.add(new Link(node4, node2, this.scaleFactor));
            }
        }
    }

    private void deleteLinksFor(Node node) throws ExceptionHugin {
        ListIterator listIterator = this.linkList.listIterator();
        while (listIterator.hasNext()) {
            boolean bl;
            Link link = (Link)listIterator.next();
            boolean bl2 = link.child == node || link.child == node;
            boolean bl3 = bl = link.parent == node || link.parent == node;
            if (!bl2 && !bl) continue;
            listIterator.remove();
        }
    }

    protected void layoutNodes() throws ExceptionHugin {
        this.layoutNodes(false);
    }

    protected void layoutNodes(boolean bl) throws ExceptionHugin {
        HuginGUIUtils.layoutNodes(this.getHome().getNodes(), 0, 0, 160, 80);
        if (bl) {
            this.updateNodePositions();
        }
    }

    protected void updateNodePositions() throws ExceptionHugin {
        this.rereadNodePositions();
        for (Link link : this.linkList) {
            link.restorePoints();
            link.computePoints();
            link.restorePoints();
        }
    }

    protected Node createNodeFromAPINode(COM.hugin.HAPI.Node node) {
        if (node instanceof COM.hugin.HAPI.DiscreteChanceNode) {
            return new DiscreteChanceNode(this, (COM.hugin.HAPI.DiscreteChanceNode)node);
        }
        if (node instanceof COM.hugin.HAPI.ContinuousChanceNode) {
            return new ContinuousChanceNode(this, (COM.hugin.HAPI.ContinuousChanceNode)node);
        }
        if (node instanceof COM.hugin.HAPI.DiscreteDecisionNode) {
            return new DiscreteDecisionNode(this, (COM.hugin.HAPI.DiscreteDecisionNode)node);
        }
        if (node instanceof COM.hugin.HAPI.UtilityNode) {
            return new UtilityNode(this, (COM.hugin.HAPI.UtilityNode)node);
        }
        if (node instanceof COM.hugin.HAPI.FunctionNode) {
            return new FunctionNode(this, (COM.hugin.HAPI.FunctionNode)node);
        }
        if (node instanceof COM.hugin.HAPI.InstanceNode) {
            InstanceNode instanceNode = new InstanceNode(this, (COM.hugin.HAPI.InstanceNode)node);
            instanceNode.addInstanceNodeListener(this.instanceNodeListener);
            return instanceNode;
        }
        return null;
    }

    protected void setClassName(String string) throws ExceptionHugin {
        if (this.checkForOOBNTrouble()) {
            return;
        }
        String string2 = this.getHomeClass().getName();
        this.getHomeClass().setName(string);
        NodeList nodeList = this.getHomeClass().getInstances();
        for (Cloneable cloneable : nodeList) {
            COM.hugin.HAPI.InstanceNode instanceNode = (COM.hugin.HAPI.InstanceNode)cloneable;
            NetworkPanel networkPanel = HuginGUIFrame.getNetworkPanel(instanceNode.getHome());
            InstanceNode instanceNode2 = (InstanceNode)networkPanel.getNode(instanceNode);
            String string3 = instanceNode.getName();
            if (string3.indexOf(string2 + "_") != 0) continue;
            String string4 = string + string3.substring(string2.length());
            if (networkPanel.getNode(string4) != null) {
                string4 = string4 + "_" + networkPanel.getNodeId(string4);
            }
            instanceNode2.setName(string4);
            networkPanel.repaint(instanceNode2);
        }
        for (Cloneable cloneable : this.nodeList) {
            if (!(cloneable instanceof InstanceNode)) continue;
            ((InstanceNode)cloneable).replaceInAttribute(string2, string);
        }
    }

    protected boolean isEmpty() {
        return this.isEmpty;
    }

    protected void isEmpty(boolean bl) {
        this.isEmpty = bl;
    }

    protected boolean containsUnsavedChanges() {
        return this.containsUnsavedChanges;
    }

    protected void containsUnsavedChanges(boolean bl) {
        this.containsUnsavedChanges = bl;
        this.updateButtonAndMenuStates();
        if (!bl) {
            return;
        }
        if (this.guiFrame != null) {
            for (JInternalFrame jInternalFrame : this.guiFrame.desktop.getAllFrames()) {
                NetworkPanel networkPanel = ((HuginProjectFrame)jInternalFrame).getNetworkPanel();
                if (!networkPanel.containsInstanceOf(this.getHomeClass())) continue;
                networkPanel.containsUnsavedChanges(true);
                networkPanel.containsUncompiledChanges(true);
            }
        }
    }

    protected boolean containsUncompiledChanges() {
        return this.containsUncompiledChanges;
    }

    protected void containsUncompiledChanges(boolean bl) {
        this.containsUncompiledChanges = bl;
        if (!bl) {
            if (!this.inEditMode) {
                this.projectFrame.stopBlinker();
            }
            return;
        }
        if (this.guiFrame != null) {
            for (JInternalFrame jInternalFrame : this.guiFrame.desktop.getAllFrames()) {
                NetworkPanel networkPanel = ((HuginProjectFrame)jInternalFrame).getNetworkPanel();
                if (networkPanel.containsInstanceOf(this.getHomeClass())) {
                    networkPanel.containsUncompiledChanges(true);
                }
                if (!(networkPanel.projectFrame instanceof TraversalFrame)) continue;
                TraversalFrame traversalFrame = (TraversalFrame)networkPanel.projectFrame;
                traversalFrame.closeIfInstanceRemoved();
                if (this.projectFrame instanceof TraversalFrame || networkPanel.containsUncompiledChanges()) continue;
                for (COM.hugin.HAPI.Node node : traversalFrame.myTraverseRootPath) {
                    try {
                        if (this.getHomeClass() != ((COM.hugin.HAPI.InstanceNode)node).getInstanceClass()) continue;
                        networkPanel.containsUncompiledChanges(true);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    protected boolean isInEditMode() {
        return this.inEditMode;
    }

    protected void isInEditMode(boolean bl) {
        this.inEditMode = bl;
        this.deselectLinks();
        this.updateButtonAndMenuStates();
    }

    protected void setEditMode(int n) {
        this.setEditMode(n, null);
    }

    private void setEditMode(int n, Point point) {
        this.mode = n;
        switch (n) {
            case 0: {
                if (point != null) {
                    Node node = this.whichNode(point);
                    if (node != null) {
                        this.setCursor(this.selectCursor);
                        break;
                    }
                    Link link = this.whichLink(point);
                    if (link != null) {
                        this.setCursor(link.isSelectable() ? this.selectCursor : this.defaultCursor);
                        break;
                    }
                    this.setCursor(this.defaultCursor);
                    break;
                }
                this.setCursor(this.defaultCursor);
                break;
            }
            case 1: {
                this.setCursor(this.dcnCursor);
                break;
            }
            case 2: {
                this.setCursor(this.ccnCursor);
                break;
            }
            case 3: {
                this.setCursor(this.linkCursor);
                break;
            }
            case 4: {
                this.setCursor(this.utilCursor);
                break;
            }
            case 7: {
                this.setCursor(this.functionCursor);
                break;
            }
            case 5: {
                this.setCursor(this.ddnCursor);
                break;
            }
            case 6: {
                this.setCursor(this.instanceCursor);
                break;
            }
            default: {
                new HuginGUIError("NetworkPanel.setEditMode", HuginGUIConstants.get("str_unknown_mode"));
            }
        }
        this.setToolButtonSelection();
    }

    protected void setInstanceNodeClass(Class clazz) {
        this.instanceNodeClass = clazz;
    }

    protected double getScaleFactor() {
        return this.scaleFactor;
    }

    private void setScaleFactor() throws ExceptionHugin {
        String string = this.getHome().getAttribute("HR_Zoom_ZoomFactor");
        if (string == null || string.equals("")) {
            return;
        }
        int n = Integer.parseInt(string);
        if (n == 0) {
            n = 100;
        }
        this.scaleFactor = (double)n / 100.0;
    }

    protected double zoom(double d) {
        double d2 = d * this.scaleFactor;
        if (d2 > 100.0 || d2 < 0.01) {
            return -1.0;
        }
        return this.setScaleFactor(d * this.scaleFactor);
    }

    private void setScaleFactor(double d, boolean bl) {
        double d2 = d / this.scaleFactor;
        Rectangle rectangle = null;
        boolean bl2 = false;
        if (bl) {
            rectangle = this.showGrid ? new Rectangle(0, 0, this.getWidth(), this.getHeight()) : this.computeBoundingBox();
        }
        for (Node cloneable : this.nodeList) {
            try {
                cloneable.scale(d2);
            }
            catch (Exception exception) {
                if (!bl2) {
                    new HuginGUIError(exception);
                }
                bl2 = true;
            }
        }
        for (Link link : this.linkList) {
            link.scale(d2);
        }
        if (!this.inEditMode) {
            for (Node node : this.nodeList) {
                if (node.monitor == null) continue;
                node.monitor.setScaleFactor(d2 * node.monitor.getScaleFactor());
                node.setMonitorLocation(d2, true);
            }
        }
        this.gridWidth *= d2;
        this.gridHeight *= d2;
        this.scaleFactor = d;
        if (bl) {
            try {
                this.getHome().setAttribute("HR_Zoom_ZoomFactor", String.valueOf((int)(100.0 * this.scaleFactor)));
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            if (!this.showGrid) {
                rectangle.add(this.computeBoundingBox());
            }
            this.repaintRectangle(rectangle);
            this.containsUnsavedChanges(true);
        }
    }

    protected double setScaleFactor(double d) {
        this.setScaleFactor(d, true);
        return this.scaleFactor;
    }

    protected void scrollToSelected() {
        this.scrollToSelected = true;
    }

    private boolean scrollToSelectedNow() {
        Rectangle rectangle = null;
        for (Node node : this.selectedNodes) {
            if (rectangle == null) {
                rectangle = node.getBoundingBox(false);
                continue;
            }
            rectangle.add(node.getBoundingBox(false));
        }
        this.scrollToSelected = rectangle == null ? false : !this.projectFrame.scrollTo(new Point(rectangle.x, rectangle.y));
        return !this.scrollToSelected;
    }

    protected boolean showGrid() {
        return this.showGrid;
    }

    protected void showGrid(boolean bl) {
        if (this.showGrid == bl) {
            return;
        }
        try {
            this.getHome().setAttribute("HR_Grid_GridShow", String.valueOf(bl ? 1 : 0));
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            return;
        }
        this.showGrid = bl;
        this.containsUnsavedChanges(true);
        this.repaint();
    }

    protected boolean snapToGrid() {
        return this.snapToGrid;
    }

    protected void snapToGrid(boolean bl) {
        if (this.snapToGrid == bl) {
            return;
        }
        try {
            this.getHome().setAttribute("HR_Grid_GridSnap", String.valueOf(bl ? 1 : 0));
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        this.snapToGrid = bl;
        this.containsUnsavedChanges(true);
    }

    protected void setToolButtonSelection() {
        String string = null;
        switch (this.getMode()) {
            case 0: {
                string = "SelectTool";
                break;
            }
            case 1: {
                string = "DCNodeTool";
                break;
            }
            case 2: {
                string = "CCNodeTool";
                break;
            }
            case 3: {
                string = "LinkTool";
                break;
            }
            case 4: {
                string = "UtilityTool";
                break;
            }
            case 7: {
                string = "FunctionTool";
                break;
            }
            case 5: {
                string = "DecisionTool";
                break;
            }
            case 6: {
                string = "InstanceTool";
                break;
            }
            default: {
                new HuginGUIError("NetworkPanel.setToolButtonSelection", HuginGUIConstants.get("str_unknown_mode"));
            }
        }
        this.projectFrame.getEditButton(string).setSelected(true);
    }

    protected void setGraphicsSize() {
        this.computeGraphicsDimension();
        this.graphicsSize.setSize(this.graphicsDimension);
        this.toggleScroll = true;
    }

    protected void setGraphicsSize(Rectangle rectangle) {
        if (rectangle.x + rectangle.width < this.graphicsDimension.width || rectangle.y + rectangle.height < this.graphicsDimension.height) {
            this.setGraphicsSize();
            return;
        }
        if (rectangle.x + rectangle.width > this.graphicsDimension.width) {
            this.graphicsDimension.width = rectangle.x + rectangle.width;
        }
        if (rectangle.y + rectangle.height > this.graphicsDimension.height) {
            this.graphicsDimension.height = rectangle.y + rectangle.height;
        }
        this.graphicsSize.setSize(this.graphicsDimension);
        this.toggleScroll = true;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.dirtyRect == null) {
            this.dirtyRect = this.getViewRect();
        }
        if (this.dirtyRect.width == 0) {
            super.paint(graphics);
            this.dirtyRect = this.getViewRect();
        }
        super.paint(graphics);
    }

    @Override
    public void paintImmediately(int n, int n2, int n3, int n4) {
        this.dirtyRect = new Rectangle(n, n2, n3, n4);
        super.paintImmediately(n, n2, n3, n4);
    }

    @Override
    public void repaint(Rectangle rectangle) {
        super.repaint(rectangle);
        this.dirtyRect = RepaintManager.currentManager(this).getDirtyRegion(this);
        this.forceRepaint = true;
    }

    @Override
    public void repaint() {
        super.repaint();
        this.dirtyRect = RepaintManager.currentManager(this).getDirtyRegion(this);
        this.forceRepaint = true;
    }

    @Override
    public void repaint(long l) {
        super.repaint(l);
        this.dirtyRect = RepaintManager.currentManager(this).getDirtyRegion(this);
    }

    @Override
    public void repaint(int n, int n2, int n3, int n4) {
        super.repaint(n, n2, n3, n4);
        this.dirtyRect = RepaintManager.currentManager(this).getDirtyRegion(this);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.toggleScroll) {
            this.setPreferredSize(this.graphicsSize);
            this.revalidate();
        }
        if (this.scrollToSelected && !this.scrollToSelectedNow()) {
            return;
        }
        Rectangle rectangle = this.dirtyRect;
        this.dirtyRect = null;
        if (rectangle == null || rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        Rectangle rectangle2 = this.getViewRect();
        if (Hugin.mainFrame.preferences.antiAliasing != this.wasAntiAliased) {
            this.repaintImage = null;
        }
        this.wasAntiAliased = Hugin.mainFrame.preferences.antiAliasing;
        if (this.oldSize != null && (this.oldSize.getWidth() < rectangle2.getWidth() || this.oldSize.getHeight() < rectangle2.getHeight())) {
            this.repaintImage = null;
        }
        this.oldSize = rectangle2;
        if ((rectangle2.width == rectangle.width && rectangle2.height == rectangle.height && !this.forceRepaint || this.selectRegion != null && rectangle2.width >= rectangle.width && rectangle2.height >= rectangle.height || (this.ghostNodes.size() > 0 || this.ghostLinks.size() > 0) && rectangle2.width >= rectangle.width && rectangle2.height >= rectangle.height) && this.repaintImage != null) {
            graphics.drawImage(this.repaintImage, rectangle2.x, rectangle2.y, this);
            if (this.selectRegion != null) {
                this.selectRegion.paint((Graphics2D)graphics);
            }
            this.drawGhostGraph((Graphics2D)graphics, rectangle2);
            return;
        }
        if (rectangle.getWidth() > rectangle2.getWidth() || rectangle.getHeight() > rectangle2.getHeight()) {
            rectangle = rectangle2;
        }
        if (this.repaintImage == null) {
            this.repaintImage = this.createImage(rectangle2.width, rectangle2.height);
        }
        Graphics graphics2 = graphics;
        graphics = this.repaintImage.getGraphics();
        graphics.translate(-rectangle2.x, -rectangle2.y);
        graphics.setClip(rectangle);
        super.paintComponent(graphics);
        if (this.background != null) {
            graphics.drawImage(this.background, 0, 0, this);
        }
        this.g2 = (Graphics2D)graphics;
        if (this.showGrid) {
            this.paintGrid();
        }
        if (Hugin.mainFrame.preferences.antiAliasing) {
            this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.drawInstanceNodes(rectangle);
        this.drawLinks(rectangle);
        this.drawBasicNodes(rectangle);
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2.drawImage(this.repaintImage, rectangle2.x, rectangle2.y, this);
        if (this.selectRegion != null) {
            this.selectRegion.paint((Graphics2D)graphics2);
        }
        this.drawGhostGraph((Graphics2D)graphics2, rectangle);
        this.forceRepaint = false;
    }

    protected Rectangle getViewRect() {
        return this.projectFrame.getNetworkScroller().getViewport().getViewRect();
    }

    public void printComponent(Graphics graphics, double d, int n, int n2) throws ExceptionHugin {
        HuginGUIUtils.pauseEventQueue();
        double d2 = this.scaleFactor;
        this.setScaleFactor(d, false);
        Rectangle rectangle = this.getBoundingBox();
        Point point = new Point(n - rectangle.x, n2 - rectangle.y);
        this.printInstanceNodes(graphics, point);
        this.printLinkBetweenBasicNodes(graphics, point);
        this.printLinksToAndFromInstanceNodes(graphics, point);
        this.printBasicNodes(graphics, point);
        this.printBasicNodesMonitors(graphics, point);
        this.setScaleFactor(d2, false);
        HuginGUIUtils.resumeEventQueue();
    }

    private Point getMinCoordinates() {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        for (Node node : this.nodeList) {
            n = Math.min(n, (int)node.x);
            n2 = Math.min(n2, (int)node.y);
        }
        return new Point(n, n2);
    }

    protected void drawLinks(Rectangle rectangle) {
        this.drawLinksBetweenBasicNodes(rectangle);
        this.drawLinksToAndFromInstanceNodes(rectangle);
    }

    protected void drawLinksBetweenBasicNodes(Rectangle rectangle) {
        Shape shape = this.g2.getClip();
        for (Link link : this.linkList) {
            if (link.parent.host == null && link.child.host == null && link.intersects(rectangle)) {
                this.g2.setClip(link.getBoundingBox());
            }
            link.paint(this.g2);
        }
        this.g2.setClip(shape);
    }

    private void drawLinksToAndFromInstanceNodes(Rectangle rectangle) {
        for (Link link : this.linkList) {
            if (link.parent.host == null && link.child.host == null || !link.intersects(rectangle)) continue;
            link.paint(this.g2);
        }
    }

    private void drawInstanceNodes(Rectangle rectangle) {
        for (Node node : this.nodeList) {
            if (!node.isInstance() || !node.intersects(rectangle)) continue;
            node.paint(this.g2);
        }
    }

    protected void drawBasicNodes(Rectangle rectangle) {
        for (Node node : this.nodeList) {
            if (node.isInstance() || !node.intersects(rectangle)) continue;
            node.paint(this.g2);
        }
    }

    protected void drawGhostGraph(Graphics2D graphics2D, Rectangle rectangle) {
        for (Link cloneable : this.ghostLinks) {
            if (!cloneable.intersects(rectangle)) continue;
            cloneable.paint(graphics2D);
        }
        for (Node node : this.ghostNodes) {
            if (!node.intersects(rectangle)) continue;
            node.paint(graphics2D);
        }
    }

    private void printLinkBetweenBasicNodes(Graphics graphics, Point point) throws ExceptionHugin {
        Rectangle rectangle = graphics.getClipBounds();
        rectangle.setLocation((int)(rectangle.getX() - point.getX()), (int)(rectangle.getY() - point.getY()));
        for (Link link : this.linkList) {
            if (link.parent.host != null || link.child.host != null || !link.intersects(rectangle, point)) continue;
            link.print(graphics, point);
        }
    }

    private void printInstanceNodes(Graphics graphics, Point point) throws ExceptionHugin {
        Rectangle rectangle = graphics.getClipBounds();
        rectangle.setLocation((int)(rectangle.getX() - point.getX()), (int)(rectangle.getY() - point.getY()));
        for (Node node : this.nodeList) {
            if (!node.isInstance() || !node.intersects(rectangle)) continue;
            node.print(graphics, point);
        }
    }

    private void printLinksToAndFromInstanceNodes(Graphics graphics, Point point) throws ExceptionHugin {
        Rectangle rectangle = graphics.getClipBounds();
        rectangle.setLocation((int)(rectangle.getX() - point.getX()), (int)(rectangle.getY() - point.getY()));
        for (Link link : this.linkList) {
            if (link.parent.host == null && link.child.host == null || !link.intersects(rectangle)) continue;
            link.print(graphics, point);
        }
    }

    private void printBasicNodes(Graphics graphics, Point point) throws ExceptionHugin {
        Rectangle rectangle = graphics.getClipBounds();
        rectangle.setLocation((int)(rectangle.getX() - point.getX()), (int)(rectangle.getY() - point.getY()));
        for (Node node : this.nodeList) {
            if (node.isInstance() || !node.intersects(rectangle)) continue;
            node.print(graphics, point);
        }
    }

    private void printBasicNodesMonitors(Graphics graphics, Point point) throws ExceptionHugin {
        Rectangle rectangle = graphics.getClipBounds();
        rectangle.setLocation((int)(rectangle.getX() - point.getX()), (int)(rectangle.getY() - point.getY()));
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.addAll(this.nodeList);
        linkedList.addAll(this.secretListOfInstanceMembers);
        for (Node node : linkedList) {
            if (node.isInstance() || !this.includeMonitors || node.monitor == null || !node.monitor.isVisible() || !node.monitor.getBounds().intersects(rectangle)) continue;
            int n = 1 + (int)(node.monitor.getLocation().getX() + (double)point.x);
            int n2 = (int)(node.monitor.getLocation().getY() + (double)point.y);
            graphics.translate(n, n2);
            node.monitor.printVisibleMonitor(graphics, this.scaleFactor);
            graphics.translate(-n, -n2);
        }
    }

    protected void paintGrid() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        float f = (float)this.gridWidth;
        float f2 = (float)this.gridHeight;
        Rectangle rectangle = this.g2.getClipBounds();
        n = (int)rectangle.getWidth();
        n2 = (int)rectangle.getHeight();
        float f3 = (float)(rectangle.getX() - rectangle.getX() % (double)f);
        float f4 = (float)(rectangle.getY() - rectangle.getY() % (double)f2);
        if (f < 3.0f || f2 < 3.0f) {
            return;
        }
        int n3 = 1;
        int n4 = 1;
        int n5 = f < f2 ? Math.round(f) : Math.round(f2);
        int n6 = 3;
        int n7 = n5 > 5 * n6 ? 1 : 3;
        this.g2.setPaint(Color.black);
        this.g2.setStroke(HStroke.BASIC_STROKE);
        switch (n7) {
            case 1: {
                for (float f5 = f4; f5 < f4 + (float)n2 + f2; f5 += f2) {
                    for (float f6 = f3; f6 < f3 + (float)n + f; f6 += f) {
                        this.g2.drawLine(Math.round(f6) - n3, Math.round(f5), Math.round(f6) + n3, Math.round(f5));
                        this.g2.drawLine(Math.round(f6), Math.round(f5) - n4, Math.round(f6), Math.round(f5) + n4);
                    }
                }
                break;
            }
            case 2: {
                float f7 = 0.0f;
                for (float f8 = f4; f8 < f4 + (float)n2 + f2; f8 += f2) {
                    for (float f9 = f3; f9 < f3 + (float)n + f; f9 += f) {
                        for (int i = -n4; i <= n4; ++i) {
                            this.g2.drawLine(Math.round(f9) - n3, Math.round(f8) + i, Math.round(f9) + n3, Math.round(f8) + i);
                        }
                    }
                }
                break;
            }
            case 3: {
                for (float f10 = f4; f10 < f4 + (float)n2 + f2; f10 += f2) {
                    for (float f11 = f3; f11 < f3 + (float)n + f; f11 += f) {
                        this.g2.drawLine(Math.round(f11), Math.round(f10), Math.round(f11), Math.round(f10));
                    }
                }
                break;
            }
            default: {
                new HuginGUIError("NetworkPanel.paintGrid", HuginGUIConstants.get("str_unknown_grid_type_of_point"));
            }
        }
    }

    protected void repaint(Node node) {
        this.repaint(node.boundingBox);
    }

    private Rectangle getRect() {
        this.panelRect.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return this.panelRect;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.descriptionFrame.isVisible() && !this.getRect().contains(mouseEvent.getPoint())) {
            this.descriptionFrame.setVisible(false);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.getMode() != 0) {
            return;
        }
        Point point = mouseEvent.getPoint();
        boolean bl = false;
        this.toolTipText = null;
        Object object = this.nodeList.listIterator(this.nodeList.size());
        while (object.hasPrevious()) {
            InstanceNode instanceNode;
            Object object2 = (Node)object.previous();
            int n = ((Node)object2).getCornerPointAt(point);
            if (this.selectedNodes.size() == 1 && ((Node)object2).isSelected() && n != -1) {
                switch (n) {
                    case 0: {
                        this.setCursor(Cursor.getPredefinedCursor(6));
                        break;
                    }
                    case 1: {
                        this.setCursor(Cursor.getPredefinedCursor(4));
                        break;
                    }
                    case 2: {
                        this.setCursor(Cursor.getPredefinedCursor(7));
                        break;
                    }
                    case 3: {
                        this.setCursor(Cursor.getPredefinedCursor(5));
                    }
                }
                bl = true;
                continue;
            }
            if (((Node)object2).contains(point)) {
                if (((Node)object2).titleIsWide || this.scaleFactor < 0.7) {
                    try {
                        this.toolTipText = ((Node)object2).getTitle();
                    }
                    catch (Exception exception) {
                        this.toolTipText = null;
                    }
                } else {
                    this.toolTipText = null;
                }
                if (((Node)object2).isInstance()) {
                    InstanceNode instanceNode2 = (InstanceNode)object2;
                    if (instanceNode2.isExpanded() && (object2 = instanceNode2.getInterfaceNodeAt(mouseEvent.getPoint())) != null) {
                        if (instanceNode2.inputs.contains(object2) && instanceNode2.inputs.size() > 1 || instanceNode2.outputs.contains(object2) && instanceNode2.outputs.size() > 1) {
                            this.setCursor(mouseEvent.isShiftDown() ? this.interfaceRightCursor : this.interfaceLeftCursor);
                        }
                        if (((Node)object2).titleIsWide || this.scaleFactor < 0.7) {
                            try {
                                this.toolTipText = ((Node)object2).getTitle();
                            }
                            catch (Exception exception) {
                                this.toolTipText = null;
                            }
                        } else {
                            this.toolTipText = null;
                        }
                    } else {
                        this.setCursor(this.selectCursor);
                    }
                } else {
                    this.setCursor(this.selectCursor);
                }
                bl = true;
                break;
            }
            if (!((Node)object2).isInstance() || !(instanceNode = (InstanceNode)object2).almostTouches(point)) continue;
            this.setCursor(instanceNode.isCollapsed() ? this.instanceExpandCursor : this.instanceCollapseCursor);
            this.almostTouchedInstanceNode = instanceNode;
            bl = true;
            return;
        }
        if (this.almostTouchedInstanceNode != null) {
            this.almostTouchedInstanceNode = null;
        }
        if (!bl) {
            object = this.whichLink(point);
            this.setCursor(object != null && ((Link)object).isSelectable() ? this.selectCursor : this.defaultCursor);
            for (Link link : this.selectedLinks) {
                if (!link.atControlPoint(point)) continue;
                this.setCursor(this.selectCursor);
                this.repaint(link.getBounds());
                break;
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!((HuginProjectFrame)this.guiFrame.desktop.getSelectedFrame()).equals(this.projectFrame)) {
            this.projectFrame.setSelected(true);
        }
        if (this.descriptionFrame.isVisible()) {
            this.descriptionFrame.setVisible(false);
        }
        if (SwingUtilities.isRightMouseButton(mouseEvent) && !mouseEvent.isAltDown()) {
            if (mouseEvent.isShiftDown()) {
                this.popupDescription(mouseEvent.getPoint());
            } else {
                this.guiFrame.popupNetworkMenu.restructure(mouseEvent, this.home, this.selectedNodes, this.selectedLinks, this.projectFrame.runMode);
                BeliefMonitor.showPopupCorrectly(this.guiFrame.popupNetworkMenu, mouseEvent);
            }
        } else {
            this.leftMousePressed(mouseEvent);
        }
    }

    private void leftMousePressed(MouseEvent mouseEvent) {
        Rectangle rectangle = null;
        try {
            switch (this.getMode()) {
                case 0: {
                    for (Link link : this.selectedLinks) {
                        if (!link.atControlPoint(new Point(mouseEvent.getX(), mouseEvent.getY()))) continue;
                        this.dragLinkControlPointInitiated = true;
                    }
                    if (this.almostTouchedInstanceNode != null) {
                        rectangle = this.swapDisplayMode(this.almostTouchedInstanceNode);
                        break;
                    }
                    rectangle = this.swapInterfaceNodes(mouseEvent);
                    if (rectangle == null) {
                        rectangle = this.controlSelections(mouseEvent);
                    }
                    break;
                }
                case 1: {
                    rectangle = this.createDiscreteChanceNode(mouseEvent);
                    break;
                }
                case 2: {
                    rectangle = this.createContinuousChanceNode(mouseEvent);
                    break;
                }
                case 3: {
                    this.initLink(mouseEvent);
                    break;
                }
                case 4: {
                    rectangle = this.createUtilityNode(mouseEvent);
                    break;
                }
                case 7: {
                    rectangle = this.createFunctionNode(mouseEvent);
                    break;
                }
                case 5: {
                    rectangle = this.createDiscreteDecisionNode(mouseEvent);
                    break;
                }
                case 6: {
                    rectangle = this.createInstanceNode(mouseEvent);
                    break;
                }
                default: {
                    new HuginGUIError("NetworkPanel.leftMousePressed", HuginGUIConstants.get("str_unknown_mode"));
                    break;
                }
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        if (rectangle != null && this.getMode() != 0) {
            this.containsUnsavedChanges(true);
            this.containsUncompiledChanges(true);
        }
        this.repaintRectangle(rectangle);
        this.updateButtonAndMenuStates();
    }

    protected void repaintRectangle(Rectangle rectangle) {
        this.repaintRectangle(rectangle, null);
    }

    protected void repaintRectangle(Rectangle rectangle, Point point) {
        this.toggleScroll = false;
        if (rectangle == null) {
            return;
        }
        this.computeGraphicsDimension();
        if (this.graphicsDimension.width != this.graphicsSize.width) {
            this.toggleScroll = true;
            this.graphicsSize.width = this.graphicsDimension.width;
        }
        if (this.graphicsDimension.height != this.graphicsSize.height) {
            this.toggleScroll = true;
            this.graphicsSize.height = this.graphicsDimension.height;
        }
        Rectangle rectangle2 = this.getViewRect();
        if (point != null && !rectangle2.contains(point)) {
            int n;
            int n2 = point.x < rectangle2.x ? point.x - rectangle2.x : (n = point.x > rectangle2.x + rectangle2.width ? point.x - (rectangle2.x + rectangle2.width) : 0);
            int n3 = point.y < rectangle2.y ? point.y - rectangle2.y : (point.y > rectangle2.y + rectangle2.height ? point.y - (rectangle2.y + rectangle2.height) : 0);
            rectangle2.translate(n, n3);
        }
        rectangle = rectangle.intersection(rectangle2);
        this.scrollRectToVisible(rectangle);
        if (this.toggleScroll) {
            this.setPreferredSize(this.graphicsSize);
            this.revalidate();
        }
        this.repaint(rectangle);
    }

    private void computeGraphicsDimension() {
        int n;
        int n2;
        int n3 = this.changedOrRepositioned(this.nodeList.listIterator());
        if (n3 != this.nodeListHash) {
            this.nodeListHash = n3;
            this.computeNodesDimension(this.solidNodesDimension, this.nodeList);
        }
        if ((n2 = this.changedOrRepositioned(this.ghostNodes.listIterator())) != this.ghostNodesHash) {
            this.ghostNodesHash = n2;
            this.computeNodesDimension(this.ghostNodesDimension, this.ghostNodes);
        }
        if ((n = this.changedOrRepositioned(this.linkList.listIterator())) != this.linkListHash) {
            this.linkListHash = n;
            this.computeLinksDimension(this.linksDimension, this.linkList);
        }
        this.graphicsDimension.setSize(Math.max(this.linksDimension.width, Math.max(this.solidNodesDimension.width, this.ghostNodesDimension.width)), Math.max(this.linksDimension.height, Math.max(this.solidNodesDimension.height, this.ghostNodesDimension.height)));
        if (!this.inEditMode) {
            this.computeMonitorsDimension(this.nodeList);
            this.graphicsDimension.setSize(Math.max(this.linksDimension.width, Math.max(this.graphicsDimension.width, this.monitorsDimension.width)), Math.max(this.linksDimension.height, Math.max(this.graphicsDimension.height, this.monitorsDimension.height)));
            this.computeMonitorsDimension(this.secretListOfInstanceMembers);
            this.graphicsDimension.setSize(Math.max(this.linksDimension.width, Math.max(this.graphicsDimension.width, this.monitorsDimension.width)), Math.max(this.linksDimension.height, Math.max(this.graphicsDimension.height, this.monitorsDimension.height)));
        }
    }

    private int changedOrRepositioned(ListIterator listIterator) {
        int n = 1;
        while (listIterator.hasNext()) {
            Cloneable cloneable;
            Object e = listIterator.next();
            n = 31 * n + (e == null ? 0 : e.hashCode());
            if (e instanceof Node) {
                cloneable = (Node)e;
                n += (int)cloneable.x + (int)cloneable.y + (int)cloneable.height + (int)cloneable.width;
                continue;
            }
            if (!(e instanceof Link)) continue;
            cloneable = (Link)e;
            n += ((Link)cloneable).myBoundingBox.x + ((Link)cloneable).myBoundingBox.y + ((Link)cloneable).myBoundingBox.height + ((Link)cloneable).myBoundingBox.width;
        }
        return n;
    }

    private void computeMonitorsDimension(LinkedList<Node> linkedList) {
        this.monitorsDimension.setSize(0, 0);
        for (Node node : linkedList) {
            if (node.monitor == null) continue;
            int n = node.monitor.getX() + node.monitor.getWidth();
            int n2 = node.monitor.getY() + node.monitor.getHeight();
            if (n > this.monitorsDimension.width) {
                this.monitorsDimension.width = n;
            }
            if (n2 <= this.monitorsDimension.height) continue;
            this.monitorsDimension.height = n2;
        }
    }

    private void computeNodesDimension(Dimension dimension, LinkedList<Node> linkedList) {
        int n = 0;
        int n2 = 0;
        for (Node node : linkedList) {
            n = Math.max(n, (int)(node.x + node.width));
            n2 = Math.max(n2, (int)(node.y + node.height));
        }
        dimension.setSize(n, n2);
    }

    private void computeLinksDimension(Dimension dimension, LinkedList<Link> linkedList) {
        int n = 0;
        int n2 = 0;
        for (Link link : linkedList) {
            Rectangle rectangle = link.getBoundingBox();
            n = Math.max(n, (int)(rectangle.getX() + rectangle.getWidth()));
            n2 = Math.max(n2, (int)(rectangle.getY() + rectangle.getHeight()));
        }
        dimension.setSize(n, n2);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        boolean bl = false;
        switch (this.getMode()) {
            case 0: {
                if (this.nodeResizingInitiated) {
                    try {
                        this.nodeResizingBox = this.resizingNode.getBoundingBox(false);
                        Point point = mouseEvent.getPoint();
                        point = this.resizingNode.getValidCornerPoint(this.cornerPoint, point, this.snapToGrid, mouseEvent.isShiftDown(), this.gridWidth, this.gridHeight);
                        this.resizingNode.setCornerPointPosition(this.cornerPoint, point, mouseEvent.isShiftDown());
                        this.containsUnsavedChanges(true);
                        this.writeStatus(HuginGUIConstants.get("SET_NODE_SIZE") + (int)Math.rint((double)this.resizingNode.getWidth() / this.scaleFactor) + " x " + (int)Math.rint((double)this.resizingNode.getHeight() / this.scaleFactor));
                    }
                    catch (Exception exception) {
                        this.nodeResizingInitiated = false;
                    }
                } else {
                    this.dragNodesOrRegion(mouseEvent.getPoint(), mouseEvent.isShiftDown());
                }
                bl = true;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                try {
                    bl = this.dragLink(mouseEvent.getPoint());
                }
                catch (Exception exception) {
                    bl = true;
                    new HuginGUIError(exception);
                }
                break;
            }
            case 4: {
                break;
            }
            case 7: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            default: {
                new HuginGUIError("NetworkPanel.mouseDragged", HuginGUIConstants.get("str_unknown_mode"));
            }
        }
        if (bl) {
            this.repaintRectangle(this.computeChangedDragRectangle(), mouseEvent.getPoint());
        }
    }

    private Rectangle computeChangedDragRectangle() {
        if (this.getMode() == 0) {
            if (this.nodeResizingInitiated) {
                return this.resizingNode.getBoundingBox(false).union(this.nodeResizingBox);
            }
            if (this.dragLinkControlPointInitiated && this.selectedLinks.size() == 1) {
                return this.newGhostLinkBoundingBox().union(this.prevGhostLinkBoundingBox);
            }
            if (this.selectRegion != null) {
                return this.selectRegion.getBoundingBox().union(this.selectRegion.previous);
            }
            return this.newGhostGraphBoundingBox().union(this.prevGhostGraphBoundingBox);
        }
        if (this.getMode() == 3) {
            return this.prevGhostLinkBoundingBox.union(this.newGhostLinkBoundingBox());
        }
        return null;
    }

    protected Rectangle newGhostGraphBoundingBox() {
        this.prevGhostGraphBoundingBox.setBounds(this.ghostGraphBoundingBox);
        if (this.ghostNodes.size() == 0) {
            return this.ghostGraphBoundingBox;
        }
        this.ghostGraphBoundingBox.setBounds(this.ghostNodes.get((int)0).boundingBox);
        for (Node cloneable : this.ghostNodes) {
            this.ghostGraphBoundingBox.add(cloneable.boundingBox);
        }
        for (Link link : this.ghostLinks) {
            this.ghostGraphBoundingBox.add(link.getBoundingBox());
        }
        return this.ghostGraphBoundingBox;
    }

    protected Rectangle newGhostLinkBoundingBox() {
        this.prevGhostLinkBoundingBox.setBounds(this.ghostLinkBoundingBox);
        if (this.ghostLinks.size() == 0) {
            this.ghostLinkBoundingBox.setBounds(this.selectedLinks.getFirst().getBoundingBox());
        } else {
            this.ghostLinkBoundingBox.setBounds(this.ghostLinks.getFirst().getBoundingBox());
        }
        return this.ghostLinkBoundingBox;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Rectangle rectangle = null;
        switch (this.getMode()) {
            case 0: {
                rectangle = this.selectOrRelocateObjects(mouseEvent.getPoint());
                if (rectangle == null && this.dragLinkControlPointInitiated) {
                    rectangle = this.endLinkControlPointDrag();
                }
                if (!this.nodeResizingInitiated) break;
                this.nodeResizingInitiated = false;
                this.resizingNode.endCornerPointMove();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                try {
                    rectangle = this.createLink(mouseEvent.getPoint());
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
                break;
            }
            case 4: {
                break;
            }
            case 7: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            default: {
                new HuginGUIError("NetworkPanel.mouseReleased", HuginGUIConstants.get("str_unknown_mode"));
            }
        }
        if (!mouseEvent.isShiftDown()) {
            this.setEditMode(0, mouseEvent.getPoint());
        }
        if (rectangle != null) {
            this.repaintRectangle(rectangle);
        }
    }

    protected Node whichNode(Point point) {
        ListIterator listIterator = this.nodeList.listIterator(this.nodeList.size());
        while (listIterator.hasPrevious()) {
            Node node = (Node)listIterator.previous();
            if (!node.contains(point)) continue;
            return node;
        }
        return null;
    }

    protected Link whichLink(Point point) {
        ListIterator<Link> listIterator = this.linkList.listIterator(this.linkList.size());
        while (listIterator.hasPrevious()) {
            Link link = listIterator.previous();
            if (!link.isVisible() || !link.contains(point)) continue;
            return link;
        }
        return null;
    }

    protected Rectangle controlSelections(MouseEvent mouseEvent) {
        Cloneable cloneable2;
        Object object;
        boolean bl;
        if (this.getSpecialMode() != 0) {
            this.setNormalMode();
        }
        Node node = this.whichNode(mouseEvent.getPoint());
        Rectangle rectangle = new Rectangle(mouseEvent.getPoint());
        boolean bl2 = true;
        if (node != null && node.isInstance() && mouseEvent.isAltDown()) {
            ((InstanceNode)node).selectClassFrame();
            return rectangle;
        }
        Link link = null;
        if (node != null || this.selectedLinks.size() > 0 && !mouseEvent.isShiftDown()) {
            bl = node != null;
            object = this.selectedLinks.listIterator();
            while (object.hasNext()) {
                cloneable2 = (Link)object.next();
                if (bl || !cloneable2.atControlPoint(new Point(mouseEvent.getX(), mouseEvent.getY()))) {
                    rectangle.add(cloneable2.getBoundingBox());
                    cloneable2.deselect();
                    object.remove();
                    continue;
                }
                link = cloneable2;
            }
        }
        if (node != null) {
            bl = node.isSelected();
            try {
                if (mouseEvent.isControlDown() && this.inEditMode && Hugin.mainFrame.preferences.node_table_connection_mode == 1) {
                    if (!this.showTables()) {
                        this.projectFrame.toggleTableWindow();
                    }
                    node.activateTable();
                    return rectangle;
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            this.cornerPoint = -1;
            if (bl) {
                this.cornerPoint = node.getCornerPointAt(mouseEvent.getPoint());
            }
            if (!bl) {
                if (!mouseEvent.isShiftDown() && this.selectedNodes.size() > 0) {
                    rectangle.add(this.deselectNodes(null));
                }
                this.selectedNodes.add(node);
                this.projectFrame.scrollTo(node.getBoundingBox(false));
                for (Cloneable cloneable2 : this.selectedNodes) {
                    rectangle.add(((Node)cloneable2).boundingBox);
                }
                if (this.selectedNodes.size() == 1) {
                    node.reportSelection(!this.inEditMode);
                }
            } else if (this.cornerPoint != -1) {
                this.resizingNode = node;
                this.nodeResizingInitiated = true;
            } else if (mouseEvent.isShiftDown()) {
                this.selectedNodes.remove(node);
                rectangle.add(node.boundingBox);
                if (this.selectedNodes.size() == 1) {
                    ((Node)this.selectedNodes.getFirst()).reportSelection(!this.inEditMode);
                    rectangle.add(((Node)this.selectedNodes.getFirst()).boundingBox);
                }
            }
            if (mouseEvent.isShiftDown() && this.selectedNodes.size() > 1) {
                this.writeStatus(this.selectedNodes.size() + HuginGUIConstants.get("str__nodes_selected") + HuginGUIConstants.get("str__total_cpt_size_") + this.getCPTSizeForSelectedNodes() + ")");
            }
            if (this.guiFrame != null && !mouseEvent.isShiftDown() && mouseEvent.getClickCount() % 2 == 0) {
                this.guiFrame.activateNodePropertiesPane(this.selectedNodes.size() == 1);
            }
            if (this.cornerPoint == -1) {
                this.setCursor(this.moveCursor);
            } else {
                switch (this.cornerPoint) {
                    case 0: {
                        this.setCursor(Cursor.getPredefinedCursor(6));
                        break;
                    }
                    case 1: {
                        this.setCursor(Cursor.getPredefinedCursor(4));
                        break;
                    }
                    case 2: {
                        this.setCursor(Cursor.getPredefinedCursor(7));
                        break;
                    }
                    case 3: {
                        this.setCursor(Cursor.getPredefinedCursor(5));
                    }
                }
            }
        } else if (this.guiFrame != null && mouseEvent.getClickCount() % 2 == 0) {
            this.guiFrame.activateNetworkPropertiesPane();
        } else {
            Link link2 = this.whichLink(mouseEvent.getPoint());
            if (!mouseEvent.isShiftDown() && this.selectedNodes.size() > 0 || this.selectedNodes.size() > 0 && link2 != null) {
                rectangle.add(this.deselectNodes(null));
            }
            if (link2 != null && link == null) {
                if (!link2.atCollapsedNode()) {
                    link2.select();
                    if (!mouseEvent.isShiftDown()) {
                        this.selectedLinks.clear();
                    }
                    this.selectedLinks.add(link2);
                    rectangle.add(link2.getBoundingBox());
                    if (this.inEditMode || !(link2.parent.getAPINode() instanceof COM.hugin.HAPI.DiscreteChanceNode) || !(link2.child.getAPINode() instanceof COM.hugin.HAPI.DiscreteChanceNode)) {
                        this.writeStatus(link2.getDescription() + HuginGUIConstants.get("str__selected"));
                    } else {
                        object = (COM.hugin.HAPI.DiscreteChanceNode)this.projectFrame.beliefBars.getDomainNodeFor(link2.parent.getAPINode());
                        cloneable2 = (COM.hugin.HAPI.DiscreteChanceNode)this.projectFrame.beliefBars.getDomainNodeFor(link2.child.getAPINode());
                        try {
                            double d = ((COM.hugin.HAPI.Node)object).getMutualInformation((COM.hugin.HAPI.Node)cloneable2);
                            String string = HuginGUIUtils.getNodeTitle((COM.hugin.HAPI.Node)object);
                            String string2 = HuginGUIUtils.getNodeTitle((COM.hugin.HAPI.Node)cloneable2);
                            this.writeStatus(link2.getDescription() + HuginGUIConstants.get("str__selected__i_") + string + ", " + string2 + HuginGUIConstants.get("str__evidence__") + HuginGUIUtils.printDouble(d, this.guiFrame.preferences.precision) + " )");
                        }
                        catch (ExceptionHugin exceptionHugin) {}
                    }
                } else {
                    this.writeErrorStatus(HuginGUIConstants.get("CANT_SELECT_LINK_AT_COLLAPSED_NODE"));
                    bl2 = false;
                }
            }
        }
        this.mousePressedAt.setLocation(mouseEvent.getPoint());
        if (bl2 && this.selectedNodes.size() == 0 && this.selectedLinks.size() == 0) {
            this.clearStatus();
        }
        if (rectangle.width == 0) {
            return null;
        }
        return rectangle;
    }

    private void updateTableNodesList() throws ExceptionHugin {
        for (Node node : this.nodeList) {
            node.updateTableNodeNames();
        }
    }

    private Rectangle createDiscreteChanceNode(MouseEvent mouseEvent) throws ExceptionHugin {
        String string = "C" + this.getNodeId("C");
        try {
            DiscreteChanceNode discreteChanceNode = new DiscreteChanceNode(this, mouseEvent.getPoint(), string);
            if (this.snapToGrid) {
                discreteChanceNode.snapTo(this.grid);
            }
            this.updateTableNodesList();
            this.nodeList.add(discreteChanceNode);
            this.writeStatus(HuginGUIConstants.get("str_discrete_chance_node_") + discreteChanceNode.name + HuginGUIConstants.get("str__created"));
            this.isEmpty(false);
            return discreteChanceNode.boundingBox;
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            return null;
        }
    }

    private Rectangle createContinuousChanceNode(MouseEvent mouseEvent) throws ExceptionHugin {
        String string = "C" + this.getNodeId("C");
        ContinuousChanceNode continuousChanceNode = new ContinuousChanceNode(this, mouseEvent.getPoint(), string);
        if (this.snapToGrid) {
            continuousChanceNode.snapTo(this.grid);
        }
        this.updateTableNodesList();
        this.nodeList.add(continuousChanceNode);
        this.writeStatus(HuginGUIConstants.get("str_continuous_chance_node_") + continuousChanceNode.name + HuginGUIConstants.get("str__created"));
        this.isEmpty(false);
        return continuousChanceNode.boundingBox;
    }

    private Rectangle createUtilityNode(MouseEvent mouseEvent) throws ExceptionHugin {
        UtilityNode utilityNode = new UtilityNode(this, mouseEvent.getPoint(), this.getNodeId("U"));
        if (this.snapToGrid) {
            utilityNode.snapTo(this.grid);
        }
        this.updateTableNodesList();
        this.nodeList.add(utilityNode);
        this.writeStatus(HuginGUIConstants.get("str_utility_node_") + utilityNode.name + HuginGUIConstants.get("str__created"));
        this.isEmpty(false);
        return utilityNode.boundingBox;
    }

    private Rectangle createFunctionNode(MouseEvent mouseEvent) throws ExceptionHugin {
        FunctionNode functionNode = new FunctionNode(this, mouseEvent.getPoint(), this.getNodeId("F"));
        if (this.snapToGrid) {
            functionNode.snapTo(this.grid);
        }
        this.updateTableNodesList();
        this.nodeList.add(functionNode);
        this.writeStatus(HuginGUIConstants.get("str_function_node_") + functionNode.name + HuginGUIConstants.get("str__created"));
        this.isEmpty(false);
        return functionNode.boundingBox;
    }

    private Rectangle createDiscreteDecisionNode(MouseEvent mouseEvent) throws ExceptionHugin {
        String string = "D" + this.getNodeId("D");
        DiscreteDecisionNode discreteDecisionNode = new DiscreteDecisionNode(this, mouseEvent.getPoint(), string);
        if (this.snapToGrid) {
            discreteDecisionNode.snapTo(this.grid);
        }
        this.updateTableNodesList();
        this.nodeList.add(discreteDecisionNode);
        this.writeStatus(HuginGUIConstants.get("str_decision_node_") + discreteDecisionNode.name + HuginGUIConstants.get("str__created"));
        this.isEmpty(false);
        return discreteDecisionNode.boundingBox;
    }

    private int getNodeId(String string) {
        int n = 1;
        while (this.getNode(string + n) != null) {
            ++n;
        }
        return n;
    }

    private Rectangle createInstanceNode(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        InstanceNode instanceNode = new InstanceNode(this, point, this.instanceNodeClass, this.getInstanceId());
        instanceNode.addInstanceNodeListener(this.instanceNodeListener);
        try {
            if (this.snapToGrid) {
                instanceNode.snapTo(this.grid);
            }
        }
        catch (Exception exception) {
            new HuginGUIError(HuginGUIConstants.get("str_unable_to_snap_to_grid_") + exception.getMessage());
        }
        this.nodeList.add(instanceNode);
        this.writeStatus(HuginGUIConstants.get("str_instance_node_") + instanceNode.name + HuginGUIConstants.get("str__created"));
        this.isEmpty(false);
        return instanceNode.boundingBox;
    }

    private int getInstanceId() {
        String string = "";
        try {
            string = this.instanceNodeClass.getName() + "_";
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        int n = 1;
        while (this.getNode(string + n) != null) {
            ++n;
        }
        return n;
    }

    protected Rectangle deselectNodes(Node node) {
        Rectangle rectangle = new Rectangle(0, 0);
        for (Node node2 : this.selectedNodes) {
            if (node2 == node) continue;
            if (rectangle.width == 0) {
                rectangle.setBounds(node2.boundingBox);
                continue;
            }
            rectangle.add(node2.boundingBox);
        }
        this.selectedNodes.clear();
        if (node != null) {
            this.selectedNodes.add(node);
        }
        return rectangle;
    }

    protected void deselectNodes() {
        this.selectedNodes.clear();
    }

    protected void deselectLink() {
        this.deselectLinks();
    }

    protected void deselectLinks() {
        if (this.selectedLinks.size() != 0) {
            for (Link link : this.selectedLinks) {
                link.deselect();
            }
            this.selectedLinks.clear();
        }
    }

    protected void initLink(MouseEvent mouseEvent) {
        this.sourceNode = this.whichNode(mouseEvent.getPoint());
        if (this.sourceNode == null || this.sourceNode.isUtility()) {
            return;
        }
        if (this.sourceNode.isInstance()) {
            this.sourceNode = ((InstanceNode)this.sourceNode).getInterfaceNodeAt(mouseEvent.getPoint());
        }
    }

    protected void dragNodesOrRegion(Point point, boolean bl) {
        try {
            if (this.dragLinkControlPointInitiated && this.selectedLinks.size() == 1) {
                Link link = this.selectedLinks.getFirst();
                if (this.controlPointAdded || link.atControlPoint(point, true)) {
                    point.x = Math.max(point.x, 0);
                    point.y = Math.max(point.y, 0);
                    link.updateActiveControlPoint(point);
                } else {
                    link.addControlPoint(point);
                    this.controlPointAdded = true;
                    this.containsUnsavedChanges(true);
                }
            } else if (this.selectRegion != null || this.ghostNodes.size() == 0 && this.whichNode(point) == null) {
                this.dragRegion(point);
            } else {
                this.dragSelectedNodes(point, bl);
            }
        }
        catch (InvalidPointException invalidPointException) {
            new HuginGUIError(invalidPointException.getMessage());
            this.dragLinkControlPointInitiated = false;
            this.controlPointAdded = false;
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
            this.dragLinkControlPointInitiated = false;
            this.controlPointAdded = false;
        }
    }

    protected Rectangle endLinkControlPointDrag() {
        this.dragLinkControlPointInitiated = false;
        this.controlPointAdded = false;
        if (this.selectedLinks.size() == 0) {
            return null;
        }
        this.containsUnsavedChanges(true);
        return this.selectedLinks.getFirst().endControlPointUpdate();
    }

    private void dragSelectedNodes(Point point, boolean bl) {
        if (this.ghostNodes.size() == 0) {
            Node node = this.whichNode(point);
            try {
                this.startingDragPoint = node == null ? (Point)point.clone() : new Point((int)node.center.x, (int)node.center.y);
                this.createGhostGraph(point);
            }
            catch (Exception exception) {}
        } else {
            this.moveGhostGraph(point, bl);
        }
        this.prevPoint.setLocation(point);
    }

    private void createGhostGraph(Point point) {
        Node node = this.whichNode(point);
        if (this.snapToGrid) {
            this.snapPoint.setLocation(point);
        }
        for (Node cloneable : this.selectedNodes) {
            Node node2 = (Node)cloneable.clone();
            node2.setGhost(true);
            this.ghostNodes.add(node2);
            if (!this.snapToGrid || cloneable != node) continue;
            this.targetNode = node2;
        }
        for (Link link : this.linkList) {
            boolean bl;
            if (!link.isVisible()) continue;
            boolean bl2 = this.selectedNodes.contains(link.parent) || this.selectedNodes.contains(link.parent.host);
            boolean bl3 = bl = this.selectedNodes.contains(link.child) || this.selectedNodes.contains(link.child.host);
            if (!bl2 && !bl) continue;
            Node node3 = bl2 ? (link.parent.host != null ? link.getParentGhost(this.ghostNodes) : link.parent.getGhost(this.ghostNodes)) : link.parent;
            Node node4 = bl ? (link.child.host != null ? link.getChildGhost(this.ghostNodes) : link.child.getGhost(this.ghostNodes)) : link.child;
            this.ghostLinks.add(new Link(node3, node4, link));
        }
    }

    protected Point nearestGridPoint(Point point) {
        float f = (float)this.gridWidth;
        float f2 = (float)this.gridHeight;
        return new Point(Math.round((float)Math.round((float)point.x / f) * f), Math.round((float)Math.round((float)point.y / f2) * f2));
    }

    private void moveGhostGraph(Point point, boolean bl) {
        int n;
        int n2;
        if (this.snapToGrid) {
            Point iterator;
            Point point2 = new Point((int)this.targetNode.center.x + (point.x - this.snapPoint.x), (int)this.targetNode.center.y + (point.y - this.snapPoint.y));
            if (bl) {
                if (Math.abs(point2.x - this.startingDragPoint.x) > Math.abs(point2.y - this.startingDragPoint.y)) {
                    point2.setLocation(point2.x, this.startingDragPoint.y);
                } else {
                    point2.setLocation(this.startingDragPoint.x, point2.y);
                }
            }
            if ((iterator = this.nearestGridPoint(point2)).equals(this.targetNode.nearestGridPoint(this.grid))) {
                n2 = 0;
                n = 0;
            } else {
                n = (int)((double)iterator.x - this.targetNode.center.x);
                n2 = (int)((double)iterator.y - this.targetNode.center.y);
                this.snapPoint.setLocation(iterator);
            }
        } else {
            if (bl) {
                if (Math.abs(this.startingDragPoint.x - point.x) > Math.abs(this.startingDragPoint.y - point.y)) {
                    point.y = this.startingDragPoint.y;
                } else {
                    point.x = this.startingDragPoint.x;
                }
            }
            n = point.x - this.prevPoint.x;
            n2 = point.y - this.prevPoint.y;
        }
        for (Node node : this.ghostNodes) {
            if (node.x + (double)n < 0.0) {
                n = 0;
            }
            if (!(node.y + (double)n2 < 0.0)) continue;
            n2 = 0;
        }
        for (Link link : this.ghostLinks) {
            if (!link.child.isGhost || !link.parent.isGhost) continue;
            Rectangle rectangle = link.getBoundingBox();
            if (rectangle.x + n < 0) {
                n = 0;
            }
            if (rectangle.y + n2 >= 0) continue;
            n2 = 0;
        }
        if (n > 0 && point.x < 0) {
            n = 0;
        }
        if (n2 > 0 && point.y < 0) {
            n2 = 0;
        }
        boolean bl2 = false;
        for (Node node : this.ghostNodes) {
            try {
                node.move(n, n2);
            }
            catch (Exception exception) {
                if (!bl2) {
                    new HuginGUIError(exception);
                }
                bl2 = true;
            }
        }
        for (Link link : this.ghostLinks) {
            if (this.nodeList.contains(link.parent) || this.nodeList.contains(link.parent.host) || this.nodeList.contains(link.child) || this.nodeList.contains(link.child.host)) {
                link.computePoints();
                continue;
            }
            link.move(n, n2);
        }
    }

    private void dragRegion(Point point) {
        int n = this.mousePressedAt.x;
        int n2 = this.mousePressedAt.y;
        int n3 = point.x;
        int n4 = point.y;
        int n5 = Math.min(n, n3);
        int n6 = Math.min(n2, n4);
        int n7 = Math.abs(n - n3);
        int n8 = Math.abs(n2 - n4);
        if (this.selectRegion == null) {
            this.selectRegion = new SelectRegion(n5, n6, n7, n8);
        } else {
            this.selectRegion.setBounds(n5, n6, n7, n8);
        }
    }

    protected Rectangle selectOrRelocateObjects(Point point) {
        if (this.selectRegion != null) {
            return this.selectOrDeselectNodesInRegion(point);
        }
        if (this.ghostNodes.size() > 0) {
            return this.relocateSelectedNodes();
        }
        return null;
    }

    private Rectangle selectOrDeselectNodesInRegion(Point point) {
        int n = this.mousePressedAt.x;
        int n2 = this.mousePressedAt.y;
        int n3 = point.x;
        int n4 = point.y;
        int n5 = Math.min(n, n3);
        int n6 = Math.min(n2, n4);
        int n7 = Math.abs(n - n3);
        int n8 = Math.abs(n2 - n4);
        this.selectRegion.setBounds(n5, n6, n7, n8);
        Rectangle rectangle = new Rectangle(this.selectRegion.getBoundingBox());
        LinkedList linkedList = new LinkedList();
        for (Object object : this.nodeList) {
            if (((Node)object).intersects(n5, n6, n7, n8)) {
                linkedList.add(object);
            }
            rectangle.add(((Node)object).boundingBox);
        }
        int n9 = 0;
        for (Node node : linkedList) {
            if (node.isSelected()) continue;
            ++n9;
        }
        if (this.inEditMode && !this.confirmNodeSelection(n9, this.selectedNodes.size() > 0)) {
            this.selectRegion = null;
            this.updateButtonAndMenuStates();
            return rectangle;
        }
        for (Node node : linkedList) {
            if (node.isSelected()) {
                this.selectedNodes.remove(node);
                continue;
            }
            this.selectedNodes.add(node);
        }
        int n10 = this.selectedNodes.size();
        if (n10 == 0) {
            this.clearStatus();
        } else if (n10 == 1) {
            ((Node)this.selectedNodes.getFirst()).reportSelection(!this.inEditMode);
        } else {
            this.writeStatus(n10 + HuginGUIConstants.get("str__nodes_selected") + HuginGUIConstants.get("str__total_cpt_size_") + this.getCPTSizeForSelectedNodes() + ")");
        }
        this.selectRegion = null;
        this.updateButtonAndMenuStates();
        return rectangle;
    }

    protected boolean confirmNodeSelection(int n) {
        return this.confirmNodeSelection(n, true, false);
    }

    protected boolean confirmNodeSelection(int n, boolean bl) {
        return this.confirmNodeSelection(n, false, bl);
    }

    private boolean confirmNodeSelection(int n, boolean bl, boolean bl2) {
        if (this.inEditMode) {
            return this.confirmDisplayOfCPTs(n, bl, bl2);
        }
        return this.confirmDisplayOfMonitors(n, bl2);
    }

    private boolean confirmDisplayOfCPTs(int n, boolean bl, boolean bl2) {
        int n2;
        return Hugin.mainFrame.preferences.node_table_connection_mode != 0 || !this.showTables && !bl || n <= 10 || (n2 = JOptionPane.showConfirmDialog(this.projectFrame, HuginGUIConstants.get("SHOW_TABLES_Confirm_message1") + n + (bl2 ? HuginGUIConstants.get("SHOW_TABLES_Confirm_message3") : HuginGUIConstants.get("SHOW_TABLES_Confirm_message2")), HuginGUIConstants.get("SHOW_TABLES_Confirm"), 0)) != 1;
    }

    private boolean confirmDisplayOfMonitors(int n, boolean bl) {
        int n2;
        return n <= 25 || (n2 = JOptionPane.showConfirmDialog(this.projectFrame, HuginGUIConstants.get("SHOW_MONITORS_Confirm_message1") + n + (bl ? HuginGUIConstants.get("SHOW_MONITORS_Confirm_message3") : HuginGUIConstants.get("SHOW_MONITORS_Confirm_message2")), HuginGUIConstants.get("SHOW_MONITORS_Confirm"), 0)) != 1;
    }

    private Rectangle relocateSelectedNodes() {
        Rectangle rectangle = this.computeBoundingBoxForSelectedNodes();
        if (this.ghostLinks.size() > 0) {
            rectangle.add(this.computeBoundingBoxForSelectedLinks());
        }
        boolean bl = false;
        String string = "";
        for (Node node : this.ghostNodes) {
            Node node2 = node.cloneOf;
            try {
                node2.moveTo(node.center.x, node.center.y);
                node2.storePosition();
                string = string + " " + node2.getName();
            }
            catch (Exception exception) {
                if (!bl) {
                    new HuginGUIError(exception);
                }
                bl = false;
            }
        }
        this.relocateLinksForSelectedNodes();
        rectangle.add(this.computeBoundingBoxForSelectedNodes());
        if (this.ghostLinks.size() > 0) {
            rectangle.add(this.computeBoundingBoxForSelectedLinks());
        }
        this.ghostNodes.clear();
        this.ghostLinks.clear();
        this.containsUnsavedChanges(true);
        int n = this.selectedNodes.size();
        if (n == 1) {
            this.writeStatus(HuginGUIConstants.get("str_node") + string + HuginGUIConstants.get("str__relocated"));
        } else {
            this.writeStatus(n + HuginGUIConstants.get("str__nodes") + string + HuginGUIConstants.get("str__relocated"));
        }
        return rectangle;
    }

    private void relocateLinksForSelectedNodes() {
        for (Link link : this.linkList) {
            if (!this.selectedNodes.contains(link.parent) && !this.selectedNodes.contains(link.parent.host) && !this.selectedNodes.contains(link.child.host) && !this.selectedNodes.contains(link.child)) continue;
            link.computePoints();
        }
        for (Link link : this.ghostLinks) {
            link.cloneOf.setPoints(link);
        }
    }

    protected void relocateLinks() {
        for (Link link : this.linkList) {
            link.computePoints();
        }
    }

    protected Rectangle getBoundingBoxForSelectedNodes() {
        return this.computeBoundingBoxForSelectedNodes();
    }

    private Rectangle computeBoundingBoxForSelectedNodes() {
        if (this.selectedNodes.size() == 0) {
            return new Rectangle();
        }
        Rectangle rectangle = null;
        for (Node cloneable : this.selectedNodes) {
            if (rectangle == null) {
                rectangle = new Rectangle(cloneable.boundingBox);
                continue;
            }
            rectangle.add(cloneable.boundingBox);
        }
        for (Link link : this.linkList) {
            boolean bl;
            boolean bl2 = this.selectedNodes.contains(link.parent) || this.selectedNodes.contains(link.parent.host);
            if (bl2 == (bl = this.selectedNodes.contains(link.child) || this.selectedNodes.contains(link.child.host))) continue;
            if (bl2) {
                if (link.child.host == null) {
                    rectangle.add(link.child.boundingBox);
                    continue;
                }
                rectangle.add(link.child.host.boundingBox);
                continue;
            }
            if (link.parent.host == null) {
                rectangle.add(link.parent.boundingBox);
                continue;
            }
            rectangle.add(link.parent.host.boundingBox);
        }
        return rectangle;
    }

    private Rectangle computeBoundingBoxForSelectedLinks() {
        Rectangle rectangle = null;
        for (Link link : this.linkList) {
            if (rectangle == null) {
                rectangle = link.getBoundingBox();
                continue;
            }
            rectangle.add(link.getBoundingBox());
        }
        return rectangle;
    }

    protected Rectangle getBoundingBox() {
        return this.computeBoundingBox(false, false);
    }

    protected Rectangle getTightBoundingBox(boolean bl) {
        return this.computeBoundingBox(bl, true);
    }

    Rectangle computeBoundingBox() {
        return this.computeBoundingBox(false, false);
    }

    private Rectangle computeBoundingBox(boolean bl, boolean bl2) {
        if (this.nodeList.size() == 0) {
            return new Rectangle();
        }
        Rectangle rectangle = bl ? new Rectangle(0, 0, 0, 0) : new Rectangle(((Node)this.nodeList.getFirst()).getBoundingBox(bl2));
        for (Node cloneable : this.nodeList) {
            rectangle.add(cloneable.getBoundingBox(bl2));
            if (!this.includeMonitors || cloneable.monitor == null || !cloneable.monitor.isVisible()) continue;
            rectangle.add(cloneable.monitor.getBounds());
        }
        for (Link link : this.linkList) {
            rectangle.add(link.getBoundingBox());
        }
        if (this.includeMonitors) {
            for (Node node : this.secretListOfInstanceMembers) {
                if (node.monitor == null || !node.monitor.isVisible()) continue;
                rectangle.add(node.monitor.getBounds());
            }
        }
        return rectangle;
    }

    protected boolean dragLink(Point point) {
        if (this.sourceNode == null) {
            return false;
        }
        if (this.ghostLinks.size() == 0) {
            this.ghostLinks.add(new Link(this.sourceNode.center, point));
        } else {
            this.ghostLinks.getFirst().setEnd(point);
        }
        return true;
    }

    private Rectangle createLink(Point point) throws ExceptionHugin {
        String string;
        Link link;
        Node node;
        block27: {
            Node node2;
            if (this.sourceNode == null || this.ghostLinks.size() < 1) {
                this.clearStatus();
                return null;
            }
            Link link2 = this.ghostLinks.getFirst();
            this.ghostLinks.clear();
            node = this.whichNode(point);
            if (node != null && node.getAPINode().getAttribute("HR_CDVT_parent") != null) {
                this.clearStatus();
                return link2.getBoundingBox();
            }
            if (node != null && node.isInstance()) {
                node = ((InstanceNode)node).getInterfaceNodeAt(point);
            }
            if (node == null) {
                this.clearStatus();
                return link2.getBoundingBox();
            }
            Node node3 = node.host == null ? node : node.host;
            Node node4 = node2 = this.sourceNode.host == null ? this.sourceNode : this.sourceNode.host;
            if (node3.directedPath(node2)) {
                this.writeErrorStatus(HuginGUIConstants.get("str_cannot_create_linke_introduce_directed_cycle"));
                return link2.getBoundingBox();
            }
            link = new Link(this.sourceNode, node, this.scaleFactor);
            string = "";
            try {
                if (node.host != null) {
                    Object object;
                    boolean bl = true;
                    try {
                        object = this.home.getAttribute("HR_OOBN_CheckConsistency");
                        bl = object == null || ((String)object).equals("1");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!this.sourceNode.consistentWith(node)) {
                        if (!bl) {
                            string = string + HuginGUIConstants.get("str__warning_nodes_are_incompatible");
                        } else {
                            throw new ExceptionInconsistentNodes();
                        }
                    }
                    if ((object = ((COM.hugin.HAPI.InstanceNode)node.host.getAPINode()).getInput(node.getAPINode())) == null) {
                        ((COM.hugin.HAPI.InstanceNode)node.host.getAPINode()).setInput(node.getAPINode(), this.sourceNode.getAPINode());
                        break block27;
                    }
                    throw new ExceptionCyclicNetwork();
                }
                if (!node.getAPINode().getParents().contains(this.sourceNode.getAPINode())) {
                    node.getAPINode().addParent(this.sourceNode.getAPINode());
                    break block27;
                }
                throw new ExceptionCyclicNetwork();
            }
            catch (ExceptionInconsistentNodes exceptionInconsistentNodes) {
                if (this.sourceNode.type != node.type) {
                    this.writeErrorStatus(HuginGUIConstants.get("BINDING_INCONSISTENT_TYPE"));
                } else if (this.sourceNode.isDiscrete()) {
                    this.writeErrorStatus(HuginGUIConstants.get("BINDING_STRONGLY_INCONSISTENT"));
                }
                return link2.getBoundingBox();
            }
            catch (ExceptionCyclicNetwork exceptionCyclicNetwork) {
                this.writeErrorStatus(HuginGUIConstants.get("str_already_connected"));
                return link2.getBoundingBox();
            }
            catch (ExceptionUsage exceptionUsage) {
                this.writeErrorStatus(HuginGUIConstants.get("str_illegal_link"));
                return link2.getBoundingBox();
            }
            catch (ExceptionMemory exceptionMemory) {
                this.writeErrorStatus(HuginGUIConstants.get("str_hugin_ran_out_of_memory_most_likely_cause_node_table_too_large"));
                return link2.getBoundingBox();
            }
            catch (ExceptionHugin exceptionHugin) {
                new HuginGUIError(exceptionHugin);
                return link2.getBoundingBox();
            }
        }
        Rectangle rectangle = new Rectangle(link.getBoundingBox());
        if (this.sourceNode.host == null) {
            rectangle.add(this.sourceNode.boundingBox);
        } else {
            rectangle.add(this.sourceNode.host.boundingBox);
        }
        if (node.host == null) {
            rectangle.add(node.boundingBox);
        } else {
            rectangle.add(node.host.boundingBox);
        }
        if (node.host == null) {
            node.updateTable(this.showTables);
        }
        this.writeStatus(link.getDescription() + HuginGUIConstants.get("str__created_model_size_") + this.getModelSize() + ")" + string);
        this.linkList.add(link);
        this.containsUnsavedChanges(true);
        this.containsUncompiledChanges(true);
        return rectangle;
    }

    protected void removeDeletedLinks() throws ExceptionHugin {
        Rectangle rectangle = null;
        try {
            for (Link link : this.linkList) {
            }
            this.writeStatus(HuginGUIConstants.get("str_model_minimalized"));
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        this.repaintRectangle(rectangle);
    }

    protected void deleteSelectedObjects() throws ExceptionHugin {
        if (!this.inEditMode) {
            return;
        }
        this.deleteInProgress = true;
        if (this.selectedLinks.size() != 0) {
            this.deleteSelectedLinks();
        } else {
            this.deleteSelectedNodes(false);
        }
        this.deleteInProgress = false;
        this.updateButtonAndMenuStates();
    }

    protected void deleteSelectedLinks() {
        if (!this.inEditMode) {
            return;
        }
        Rectangle rectangle = null;
        try {
            for (Link link : this.selectedLinks) {
                this.linkList.remove(link);
                if (rectangle == null) {
                    rectangle = link.kill();
                    continue;
                }
                rectangle.add(link.kill());
            }
            this.containsUnsavedChanges(true);
            this.containsUncompiledChanges(true);
            this.writeStatus(HuginGUIConstants.get("str_link") + (this.selectedLinks.size() > 1 ? HuginGUIConstants.get("str_s") : "") + HuginGUIConstants.get("str__deleted_model_size_") + this.getModelSize() + ")");
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        this.selectedLinks.clear();
        this.repaintRectangle(rectangle);
    }

    private void deleteSelectedNodes(boolean bl) throws ExceptionHugin {
        Object object3;
        Object object22;
        if (this.selectedNodes.size() == 0 || !this.inEditMode) {
            return;
        }
        boolean bl2 = false;
        for (Object object22 : this.selectedNodes) {
            if (!((Node)object22).isInterface()) continue;
            try {
                if (this.checkForOOBNTrouble()) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            bl2 = true;
            break;
        }
        Rectangle rectangle = this.computeBoundingBoxForSelectedNodes();
        if (bl) {
            nodeBuffer.clear();
            linkBuffer.clear();
            for (Object object3 : this.selectedNodes) {
                nodeBuffer.add((Node)object3);
                ((Node)object3).saveNodeInfo();
            }
        }
        for (Object object3 : this.selectedNodes) {
            this.nodeList.remove(object3);
            ((Node)object3).disposeTable();
        }
        for (Object object3 : this.selectedNodes) {
            ((Node)object3).kill();
        }
        object22 = this.linkList.listIterator();
        while (object22.hasNext()) {
            boolean bl3;
            object3 = (Link)object22.next();
            boolean bl4 = this.selectedNodes.contains(((Link)object3).child) || this.selectedNodes.contains(((Link)object3).child.host);
            boolean bl5 = bl3 = this.selectedNodes.contains(((Link)object3).parent) || this.selectedNodes.contains(((Link)object3).parent.host);
            if (!bl4 && !bl3) continue;
            if (bl && bl4 && bl3) {
                linkBuffer.add((Link)object3);
            }
            rectangle.add(((Link)object3).getBoundingBox());
            object22.remove();
        }
        this.updateTableNodesList();
        int n = this.selectedNodes.size();
        object3 = (n == 1 ? HuginGUIConstants.get("str_Node_") : n + HuginGUIConstants.get("str__nodes_")) + (bl ? HuginGUIConstants.get("str_cut_to_clipboard") : HuginGUIConstants.get("str_deleted_not_placed_on_clipboard"));
        this.writeStatus((String)object3);
        this.selectedNodes.clear();
        bufferedNodesAreCut = bl;
        if (this.projectFrame.beliefBars != null) {
            this.projectFrame.beliefBars.setSelectedNode(null);
        }
        this.containsUnsavedChanges(true);
        this.containsUncompiledChanges(true);
        this.repaintRectangle(rectangle);
        this.updateButtonAndMenuStates();
        if (bl) {
            this.resetPasteNumbers();
        }
    }

    protected void updateButtonAndMenuStates() {
        boolean bl;
        Object object;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        COM.hugin.HAPI.Node node;
        COM.hugin.HAPI.Node node2;
        Cloneable cloneable;
        Cloneable cloneable2;
        Cloneable cloneable3;
        boolean bl5;
        Domain domain;
        if (this.guiFrame == null || this.deleteInProgress) {
            return;
        }
        boolean bl6 = this.nodeList.size() > 0;
        boolean bl7 = this.selectedNodes.size() == 1;
        boolean bl8 = this.selectedNodes.size() == 2;
        boolean bl9 = this.selectedNodes.size() == 3;
        boolean bl10 = this.containsContinuousNodes();
        boolean bl11 = this.isLIMIDs();
        boolean bl12 = false;
        if (bl11 && this.projectFrame.getBeliefBarPanel() != null && (domain = this.projectFrame.getBeliefBarPanel().getDomain()) != null) {
            bl12 = HuginGUIUtils.allDecisionsInstantiated(domain);
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        for (Node node3 : this.nodeList) {
            COM.hugin.HAPI.Node node4 = node3.getAPINode();
            if (node4 instanceof COM.hugin.HAPI.FunctionNode) {
                ++n;
                continue;
            }
            if (node4 instanceof COM.hugin.HAPI.ContinuousChanceNode) {
                ++n2;
                continue;
            }
            if (node4 instanceof COM.hugin.HAPI.UtilityNode) {
                ++n3;
                continue;
            }
            if (node4 instanceof BooleanDCNode) {
                ++n4;
                continue;
            }
            if (node4 instanceof IntervalDCNode) {
                ++n5;
                continue;
            }
            if (node4 instanceof LabelledDCNode) {
                ++n6;
                continue;
            }
            if (node4 instanceof NumberedDCNode) {
                ++n7;
                continue;
            }
            if (node4 instanceof BooleanDDNode) {
                ++n8;
                continue;
            }
            if (node4 instanceof IntervalDDNode) {
                ++n9;
                continue;
            }
            if (node4 instanceof LabelledDDNode) {
                ++n10;
                continue;
            }
            if (!(node4 instanceof NumberedDDNode)) continue;
            ++n11;
        }
        int n12 = n4 + n5 + n6 + n7;
        int n13 = n8 + n9 + n10 + n11;
        boolean bl13 = false;
        try {
            bl13 = this.projectFrame.getBeliefBarPanel().isCompressed();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl14 = bl10 || bl11;
        JMenuItem jMenuItem = this.guiFrame.saveFileMenuItem;
        jMenuItem.setEnabled(true);
        jMenuItem.getAction().setEnabled(true);
        jMenuItem = this.guiFrame.saveAsFileMenuItem;
        jMenuItem.setEnabled(true);
        jMenuItem.getAction().setEnabled(true);
        this.guiFrame.getButton(2).setEnabled(true);
        jMenuItem = this.guiFrame.printNetFileMenuItem;
        jMenuItem.setEnabled(bl6);
        jMenuItem.getAction().setEnabled(bl6);
        this.projectFrame.getEditButton("PrintNetwork").setEnabled(bl6);
        jMenuItem = this.guiFrame.printNodeTableFileMenuItem;
        jMenuItem.setEnabled(bl6);
        jMenuItem.getAction().setEnabled(bl6);
        this.projectFrame.getEditButton("PrintNodeTable").setEnabled(bl6);
        boolean bl15 = this.selectedNodes.size() > 0 && !this.inEditMode;
        jMenuItem = this.guiFrame.printProbabilitesFileMenuItem;
        jMenuItem.setEnabled(bl15);
        jMenuItem.getAction().setEnabled(bl15);
        this.projectFrame.getRunButton(HuginGUIConstants.get("MENU_FILE_Print_Probabilities")).setEnabled(bl15);
        this.guiFrame.saveNetworkToBMPFileMenuItem.setEnabled(bl6);
        this.guiFrame.saveNetworkToBMPFileMenuItem.getAction().setEnabled(bl6);
        this.guiFrame.saveTablesToBMPFileMenuItem.setEnabled(this.projectFrame.getTablePanel().getVisibleTables().size() > 0 && this.showTables && this.inEditMode);
        this.guiFrame.saveTablesToBMPFileMenuItem.getAction().setEnabled(this.projectFrame.getTablePanel().getVisibleTables().size() > 0 && this.showTables && this.inEditMode);
        this.guiFrame.saveProbabilitiesToBMPFileMenuItem.setEnabled(bl15);
        this.guiFrame.saveNetworkToBMPWMonitorsFileMenuItem.setEnabled(this.projectFrame.runMode);
        this.guiFrame.saveProbabilitiesToBMPFileMenuItem.getAction().setEnabled(bl15);
        jMenuItem = this.guiFrame.simulateCasesFileMenuItem;
        jMenuItem.setEnabled(!this.inEditMode && !bl11);
        jMenuItem.getAction().setEnabled(!this.inEditMode && !bl11);
        this.projectFrame.getRunButton(HuginGUIConstants.get("MENU_FILE_Simulate_Cases")).setEnabled(!this.inEditMode && !bl11);
        jMenuItem = this.guiFrame.saveCaseFileMenuItem;
        try {
            jMenuItem.setEnabled(!this.inEditMode && this.projectFrame.getBeliefBarPanel().evidenceIsEntered());
        }
        catch (Exception exception) {
            jMenuItem.setEnabled(false);
        }
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.loadCaseFileMenuItem;
        jMenuItem.setEnabled(!this.inEditMode);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        boolean bl16 = this.inEditMode && this.selectedNodes.size() > 0;
        boolean bl17 = this.inEditMode && (this.selectedNodes.size() > 0 || this.selectedLinks.size() > 0);
        boolean bl18 = bl17 && this.selectedNodes.size() > 0;
        boolean bl19 = this.inEditMode && nodeBuffer.size() > 0;
        Link link = this.selectedLinks.size() == 1 ? this.selectedLinks.getFirst() : null;
        boolean bl20 = this.inEditMode && link != null && link.reversable() == 0;
        boolean bl21 = false;
        if (!(this.inEditMode || bl11 && !bl12 || this.projectFrame.getBeliefBarPanel() == null)) {
            Domain domain2 = this.projectFrame.getBeliefBarPanel().getDomain();
            try {
                bl21 = !domain2.evidenceToPropagate() && domain2.evidenceModeIs(Domain.H_EVIDENCE_MODE_NORMAL) && domain2.equilibriumIs(Domain.H_EQUILIBRIUM_SUM);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean bl22 = false;
        if (!this.inEditMode && this.projectFrame.getBeliefBarPanel() != null) {
            Domain domain3 = this.projectFrame.getBeliefBarPanel().getDomain();
            try {
                bl22 = !domain3.evidenceToPropagate() && domain3.evidenceModeIs(Domain.H_EVIDENCE_MODE_NORMAL) && domain3.equilibriumIs(Domain.H_EQUILIBRIUM_SUM);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean bl23 = bl7 && !this.inEditMode && !bl13 && this.projectFrame.beliefBars.getSelectedNode() != null && (this.projectFrame.beliefBars.getSelectedNode() instanceof COM.hugin.HAPI.DiscreteChanceNode && !bl11 || this.projectFrame.beliefBars.getSelectedNode() instanceof COM.hugin.HAPI.DiscreteDecisionNode);
        try {
            bl23 = bl23 && !this.projectFrame.getBeliefBarPanel().getDomain().evidenceToPropagate();
        }
        catch (Exception exception) {
            bl23 = false;
        }
        boolean bl24 = bl7 && !this.inEditMode && bl22 && this.projectFrame.beliefBars.getSelectedNode() != null && this.projectFrame.beliefBars.getSelectedNode() instanceof COM.hugin.HAPI.DiscreteChanceNode;
        try {
            bl24 = bl24 && this.projectFrame.beliefBars.evidenceIsEntered();
        }
        catch (Exception exception) {
            bl24 = false;
        }
        boolean bl25 = bl11 && this.inEditMode;
        boolean bl26 = false;
        try {
            String string = this.getHome().getAttribute("HR_Instantiated_in");
            if (string != null && string.trim().length() > 0 || this.containsInstanceNodes()) {
                bl26 = true;
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        boolean bl27 = bl5 = bl8 && this.inEditMode && !bl26;
        if (bl5 && !this.isInEditMode()) {
            try {
                cloneable3 = this.projectFrame.getBeliefBarPanel().getDomain();
                bl5 = bl5 && !((Domain)cloneable3).evidenceToPropagate() && ((Domain)cloneable3).evidenceModeIs(Domain.H_EVIDENCE_MODE_NORMAL) && ((Domain)cloneable3).equilibriumIs(Domain.H_EQUILIBRIUM_SUM);
            }
            catch (Exception exception) {
                bl5 = false;
            }
        }
        if (bl5) {
            cloneable3 = ((Node)this.selectedNodes.getFirst()).getAPINode();
            cloneable2 = ((Node)this.selectedNodes.getLast()).getAPINode();
            cloneable = null;
            node2 = null;
            if (!this.isInEditMode()) {
                if (cloneable3 instanceof IntervalDCNode) {
                    cloneable = (IntervalDCNode)this.projectFrame.beliefBars.getDomainNodeFor((COM.hugin.HAPI.Node)cloneable3);
                } else if (cloneable3 instanceof COM.hugin.HAPI.ContinuousChanceNode) {
                    node2 = (COM.hugin.HAPI.ContinuousChanceNode)this.projectFrame.beliefBars.getDomainNodeFor((COM.hugin.HAPI.Node)cloneable3);
                }
                if (cloneable2 instanceof IntervalDCNode) {
                    cloneable = (IntervalDCNode)this.projectFrame.beliefBars.getDomainNodeFor((COM.hugin.HAPI.Node)cloneable2);
                } else if (cloneable2 instanceof COM.hugin.HAPI.ContinuousChanceNode) {
                    node2 = (COM.hugin.HAPI.ContinuousChanceNode)this.projectFrame.beliefBars.getDomainNodeFor((COM.hugin.HAPI.Node)cloneable2);
                }
            } else {
                if (cloneable3 instanceof IntervalDCNode) {
                    cloneable = (IntervalDCNode)cloneable3;
                } else if (cloneable3 instanceof COM.hugin.HAPI.ContinuousChanceNode) {
                    node2 = (COM.hugin.HAPI.ContinuousChanceNode)cloneable3;
                }
                if (cloneable2 instanceof IntervalDCNode) {
                    cloneable = (IntervalDCNode)cloneable2;
                } else if (cloneable2 instanceof COM.hugin.HAPI.ContinuousChanceNode) {
                    node2 = (COM.hugin.HAPI.ContinuousChanceNode)cloneable2;
                }
            }
            boolean bl28 = bl5 = node2 != null && cloneable != null;
            if (bl5) {
                try {
                    boolean bl29 = bl5 = ((IntervalDCNode)cloneable).getStateValue(0) == -Domain.INFINITY() && ((IntervalDCNode)cloneable).getStateValue(((COM.hugin.HAPI.DiscreteNode)cloneable).getNumberOfStates()) == Domain.INFINITY() && ((COM.hugin.HAPI.Node)cloneable).getParents().size() == 0;
                    if (bl5 && !this.isInEditMode()) {
                        bl5 = !node2.evidenceIsEntered() && !((COM.hugin.HAPI.Node)cloneable).evidenceIsEntered();
                    }
                }
                catch (Exception exception) {
                    bl5 = false;
                }
            }
        }
        boolean bl30 = bl8;
        try {
            cloneable2 = this.projectFrame.getBeliefBarPanel().getDomain();
            bl30 = bl30 && !((Domain)cloneable2).evidenceToPropagate() && ((Domain)cloneable2).evidenceModeIs(Domain.H_EVIDENCE_MODE_NORMAL) && ((Domain)cloneable2).equilibriumIs(Domain.H_EQUILIBRIUM_SUM);
        }
        catch (Exception exception) {
            bl30 = false;
        }
        if (bl30 && !this.inEditMode && !bl13) {
            cloneable2 = ((Node)this.selectedNodes.getFirst()).getAPINode();
            cloneable = ((Node)this.selectedNodes.getLast()).getAPINode();
            boolean bl31 = bl30 = cloneable2 instanceof NumberedDCNode && cloneable instanceof IntervalDCNode || cloneable instanceof NumberedDCNode && cloneable2 instanceof IntervalDCNode;
            if (bl30) {
                try {
                    node2 = (COM.hugin.HAPI.DiscreteChanceNode)this.projectFrame.beliefBars.getDomainNodeFor((COM.hugin.HAPI.Node)cloneable2);
                    node = (COM.hugin.HAPI.DiscreteChanceNode)this.projectFrame.beliefBars.getDomainNodeFor((COM.hugin.HAPI.Node)cloneable);
                    bl30 = !node2.evidenceIsEntered() && !node.evidenceIsEntered();
                }
                catch (Exception exception) {
                    bl30 = false;
                }
            }
        }
        boolean bl32 = false;
        try {
            cloneable = this.projectFrame.getBeliefBarPanel().getDomain();
            bl32 = !((Domain)cloneable).evidenceToPropagate() && ((Domain)cloneable).evidenceModeIs(Domain.H_EVIDENCE_MODE_NORMAL) && ((Domain)cloneable).equilibriumIs(Domain.H_EQUILIBRIUM_SUM);
        }
        catch (Exception exception) {
            bl32 = false;
        }
        if (bl32) {
            bl32 = bl9 && !this.inEditMode && !bl13;
        }
        cloneable = null;
        node2 = null;
        node = null;
        if (bl32) {
            cloneable = ((Node)this.selectedNodes.getFirst()).getAPINode();
            node2 = ((Node)this.selectedNodes.get(1)).getAPINode();
            node = ((Node)this.selectedNodes.getLast()).getAPINode();
            try {
                if (cloneable instanceof COM.hugin.HAPI.DiscreteChanceNode && node2 instanceof COM.hugin.HAPI.DiscreteChanceNode && node instanceof COM.hugin.HAPI.DiscreteChanceNode) {
                    COM.hugin.HAPI.DiscreteChanceNode discreteChanceNode = (COM.hugin.HAPI.DiscreteChanceNode)this.projectFrame.beliefBars.getDomainNodeFor((COM.hugin.HAPI.Node)cloneable);
                    COM.hugin.HAPI.DiscreteChanceNode discreteChanceNode2 = (COM.hugin.HAPI.DiscreteChanceNode)this.projectFrame.beliefBars.getDomainNodeFor(node2);
                    COM.hugin.HAPI.DiscreteChanceNode discreteChanceNode3 = (COM.hugin.HAPI.DiscreteChanceNode)this.projectFrame.beliefBars.getDomainNodeFor(node);
                    bl32 = !discreteChanceNode.evidenceIsEntered() && !discreteChanceNode2.evidenceIsEntered() && !discreteChanceNode3.evidenceIsEntered();
                } else {
                    bl32 = false;
                }
            }
            catch (Exception exception) {
                bl32 = false;
            }
        }
        if (bl32) {
            int n14 = 0;
            int n15 = 0;
            int n16 = 0;
            bl4 = false;
            bl3 = false;
            if (cloneable instanceof BooleanDCNode) {
                ++n14;
            }
            if (node2 instanceof BooleanDCNode) {
                ++n14;
            }
            if (node instanceof BooleanDCNode) {
                ++n14;
            }
            try {
                if (cloneable instanceof NumberedDCNode) {
                    ++n15;
                    if (((NumberedDCNode)cloneable).getStateValue(0) < 0.0) {
                        bl3 = true;
                    }
                }
                if (node2 instanceof NumberedDCNode) {
                    ++n15;
                    if (((NumberedDCNode)node2).getStateValue(0) < 0.0) {
                        bl3 = true;
                    }
                }
                if (node instanceof NumberedDCNode) {
                    ++n15;
                    if (((NumberedDCNode)node).getStateValue(0) < 0.0) {
                        bl3 = true;
                    }
                }
                if (cloneable instanceof IntervalDCNode) {
                    ++n16;
                    if (((IntervalDCNode)cloneable).getStateValue(0) < 0.0) {
                        bl4 += 1;
                    }
                }
                if (node2 instanceof IntervalDCNode) {
                    ++n16;
                    if (((IntervalDCNode)node2).getStateValue(0) < 0.0) {
                        bl4 += 1;
                    }
                }
                if (node instanceof IntervalDCNode) {
                    ++n16;
                    if (((IntervalDCNode)node).getStateValue(0) < 0.0) {
                        bl4 += 1;
                    }
                }
                bl32 = n14 == 1 && n15 <= 1 && (n16 == 1 || n16 == 2) && bl4 <= true;
            }
            catch (ExceptionHugin exceptionHugin) {
                bl32 = false;
            }
        }
        boolean bl33 = (!this.inEditMode || this.inEditMode && this.projectFrame.isPre60()) && !bl11 && !this.containsInstanceNodes() && this.selectedNodes.size() == 2 && ((Node)this.selectedNodes.getFirst()).canDoDSeparation() && ((Node)this.selectedNodes.getLast()).canDoDSeparation();
        boolean bl34 = (!this.inEditMode || this.inEditMode && this.projectFrame.isPre60()) && !bl11 && !this.containsInstanceNodes() && this.selectedNodes.size() == 1 && ((Node)this.selectedNodes.getFirst()).canDoDSeparation();
        boolean bl35 = (!this.inEditMode || this.inEditMode && this.projectFrame.isPre60()) && !bl11 && !this.containsInstanceNodes();
        bl4 = false;
        bl3 = false;
        boolean bl36 = false;
        if (this.inEditMode && this.selectedNodes.size() > 0 && this.home instanceof Class) {
            bl4 = true;
            bl3 = true;
            bl36 = true;
            for (Node node5 : this.selectedNodes) {
                bl4 = bl4 && !(node5 instanceof UtilityNode) && !(node5 instanceof FunctionNode) && node5.getParents().size() <= 0 && !(node5 instanceof InstanceNode);
                bl3 = bl3 && !(node5 instanceof UtilityNode) && !(node5 instanceof FunctionNode) && !(node5 instanceof InstanceNode);
                bl36 = bl36 && !(node5 instanceof UtilityNode) && !(node5 instanceof FunctionNode) && !(node5 instanceof InstanceNode);
            }
        }
        bl22 = bl22 && !this.containsCDVTLinks();
        bl23 = bl23 && !this.containsCDVTLinks();
        bl24 = bl24 && !this.containsCDVTLinks();
        bl33 = bl33 && !this.containsCDVTLinks();
        bl34 = bl34 && !this.containsCDVTLinks();
        bl35 = bl35 && !this.containsCDVTLinks();
        bl20 = bl20 && !(link instanceof CDVTLink);
        jMenuItem = this.guiFrame.makeInputEditMenu;
        jMenuItem.setEnabled(bl4);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.makeOutputEditMenu;
        jMenuItem.setEnabled(bl3);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.makePrivateEditMenu;
        jMenuItem.setEnabled(bl36);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        boolean bl37 = bl2 = this.inEditMode && !this.projectFrame.isPre60() && PopupClassesList.getClassCount((Class)this.home) > 0;
        if (this.hasCDVT()) {
            bl2 = false;
        }
        boolean bl38 = this.projectFrame.getEditButton("ShowTableWindow").isSelected() && this.projectFrame.tablePanel.getSelectedTable() != null;
        boolean bl39 = this.inEditMode && (bl7 && ((Node)this.selectedNodes.getFirst()).canAddOrDeleteState() && !bl38 || bl38 && this.projectFrame.tablePanel.getSelectedTable().getNode().canAddOrDeleteState());
        jMenuItem = this.guiFrame.copyEditMenuItem;
        jMenuItem.setEnabled(bl16);
        jMenuItem.getAction().setEnabled(bl16);
        this.guiFrame.getButton(3).setEnabled(bl16);
        jMenuItem = this.guiFrame.cutEditMenuItem;
        jMenuItem.setEnabled(bl18);
        jMenuItem.getAction().setEnabled(bl18);
        this.guiFrame.getButton(4).setEnabled(bl18);
        jMenuItem = this.guiFrame.deleteEditMenuItem;
        jMenuItem.setEnabled(bl17);
        jMenuItem.getAction().setEnabled(bl17);
        this.guiFrame.getButton(6).setEnabled(bl17);
        jMenuItem = this.guiFrame.pasteEditMenuItem;
        jMenuItem.setEnabled(bl19);
        jMenuItem.getAction().setEnabled(bl19);
        this.guiFrame.getButton(5).setEnabled(bl19);
        this.projectFrame.getEditButton("ReverseLink").setEnabled(bl20);
        this.projectFrame.getEditButton("AddState").setEnabled(bl39);
        this.projectFrame.getEditButton("RemoveState").setEnabled(bl39 && this.atLeastTwoStates());
        boolean bl40 = false;
        boolean bl41 = false;
        try {
            bl40 = this.isPartOfContinuousNet();
            bl41 = this.isPartOfInfluenceDiagram();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.projectFrame.getEditButton("CCNodeTool").setEnabled(!bl11 && !bl41 && this.inEditMode);
        this.projectFrame.getEditButton("UtilityTool").setEnabled(!bl10 && !bl40 && this.inEditMode);
        this.projectFrame.getEditButton("DecisionTool").setEnabled(!bl10 && !bl40 && this.inEditMode);
        this.projectFrame.getEditButton("InstanceTool").setEnabled(bl2);
        if (this.inEditMode) {
            this.projectFrame.getEditButton("NodeProperties").setEnabled(bl7);
        } else {
            this.projectFrame.getRunButton(HuginGUIConstants.get("MENU_EDIT_Node_Properties")).setEnabled(bl7);
        }
        boolean bl42 = false;
        for (Node node6 : this.selectedNodes) {
            if (node6 instanceof UtilityNode) continue;
            bl42 = true;
            break;
        }
        boolean bl43 = !this.inEditMode && bl42;
        boolean bl44 = !this.inEditMode && this.areSomeMonitorsOpen();
        boolean bl45 = !this.inEditMode && this.graphsToUpdate && bl10;
        boolean bl46 = bl7 && ((Node)this.selectedNodes.getFirst()).isInstance();
        jMenuItem = this.guiFrame.toggleTableViewMenuItem;
        jMenuItem.setEnabled(this.inEditMode);
        jMenuItem.getAction().setEnabled(this.inEditMode);
        ((HuginGUIEventHandler.MENU_VIEW_Toggle_TablesAction)jMenuItem.getAction()).setShowing(this.showTables());
        this.projectFrame.getEditButton("ShowTableWindow").setSelected(this.showTables());
        jMenuItem = this.guiFrame.showTablesViewMenuItem;
        jMenuItem.setEnabled(this.inEditMode && this.selectedNodes.size() > 0);
        jMenuItem.getAction().setEnabled(this.inEditMode && this.selectedNodes.size() > 0);
        jMenuItem = this.guiFrame.closeTablesViewMenuItem;
        jMenuItem.setEnabled(this.inEditMode && this.selectedNodes.size() > 0 && this.showTables());
        jMenuItem.getAction().setEnabled(this.inEditMode && this.selectedNodes.size() > 0 && this.showTables());
        jMenuItem = this.guiFrame.nodeLocatorViewMenuItem;
        ((HuginGUIEventHandler.MENU_VIEW_Node_LocatorAction)jMenuItem.getAction()).setMark(this.projectFrame.showNodeLocator());
        this.projectFrame.enableNodeLocator(bl6);
        jMenuItem = this.guiFrame.toggleBeliefBarViewMenuItem;
        jMenuItem.setEnabled(!this.inEditMode);
        jMenuItem.getAction().setEnabled(!this.inEditMode);
        jMenuItem = this.guiFrame.expandNodeListViewMenuItem;
        jMenuItem.setEnabled(!this.inEditMode && this.projectFrame.beliefBarsIsShown());
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.collapseNodeListViewMenuItem;
        jMenuItem.setEnabled(!this.inEditMode && this.projectFrame.beliefBarsIsShown());
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.togglePrivateNodesMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.collapseInstanceNodesViewMenuItem;
        jMenuItem.setEnabled(this.containsInstanceNodes());
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.expandInstanceNodesViewMenuItem;
        jMenuItem.setEnabled(this.containsInstanceNodes());
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.showClassViewMenuItem;
        jMenuItem.setEnabled(bl46);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.showMonitorsViewMenuItem;
        jMenuItem.setEnabled(bl43);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.hideMonitorsViewMenuItem;
        jMenuItem.setEnabled(bl44);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.lockEvidenceViewMenuItem;
        jMenuItem.setEnabled(!this.inEditMode);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.updateMonitorGraphsViewMenuItem;
        jMenuItem.setEnabled(bl45);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        this.projectFrame.getRunButton(HuginGUIConstants.get("MENU_VIEW_Update_All_Monitor_Graphs")).setEnabled(bl45);
        jMenuItem = this.guiFrame.showLastErrorViewMenuItem;
        jMenuItem.setEnabled(true);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.beliefPrecisionViewMenu;
        jMenuItem.setEnabled(!this.inEditMode);
        jMenuItem.getAction().setEnabled(!this.inEditMode);
        jMenuItem = this.guiFrame.showJunctionTreeViewMenuItem;
        jMenuItem.setEnabled(!this.inEditMode);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.reportBeliefsViewMenuItem;
        jMenuItem.setEnabled(!this.inEditMode);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        Node node7 = bl7 ? (Node)this.selectedNodes.getFirst() : null;
        boolean bl47 = bl7 && !this.inEditMode && this.projectFrame.beliefBars != null && this.projectFrame.beliefBars.getSelectedNode() != null && this.projectFrame.beliefBars.getSelectedNode() instanceof COM.hugin.HAPI.DiscreteChanceNode;
        boolean bl48 = !this.inEditMode && this.projectFrame.beliefBars != null && this.projectFrame.beliefBars.getSelectedNode() != null;
        try {
            if (bl48 && bl7) {
                object = this.projectFrame.beliefBars.getSelectedNode();
                bl48 = bl48 && (object instanceof COM.hugin.HAPI.ContinuousChanceNode || object instanceof COM.hugin.HAPI.DiscreteNode) && ((COM.hugin.HAPI.Node)object).evidenceIsEntered();
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        jMenuItem = this.guiFrame.initializeNetworkMenuItem;
        jMenuItem.setEnabled(!this.inEditMode);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.propSumNormalNetworkMenuItem;
        jMenuItem.setEnabled(!this.inEditMode);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.propMaxNormalNetworkMenuItem;
        jMenuItem.setEnabled(!this.inEditMode && !bl14);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        this.projectFrame.getRunButton(HuginGUIConstants.get("MENU_NETWORK_Prop_Max_Normal")).setEnabled(!this.inEditMode && !bl14);
        jMenuItem = this.guiFrame.propSumFastRetractNetworkMenuItem;
        jMenuItem.setEnabled(!this.inEditMode && !bl14);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.propMaxFastRetractNetworkMenuItem;
        jMenuItem.setEnabled(!this.inEditMode && !bl14);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.updatePoliciesNetworkMenuItem;
        jMenuItem.setEnabled(false);
        try {
            jMenuItem.setEnabled(!this.inEditMode && bl11 && this.projectFrame.getBeliefBarPanel() != null && this.projectFrame.getBeliefBarPanel().getDomain() != null && !this.projectFrame.getBeliefBarPanel().getDomain().evidenceToPropagate() && !this.projectFrame.getBeliefBarPanel().getDomain().tablesToPropagate());
        }
        catch (Exception exception) {
            // empty catch block
        }
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        this.projectFrame.getRunButton(HuginGUIConstants.get("MENU_NETWORK_Update_Policies")).setEnabled(jMenuItem.isEnabled());
        this.projectFrame.getRunButton(HuginGUIConstants.get("MENU_NETWORK_Recall_Policies")).setEnabled(false);
        try {
            this.projectFrame.getRunButton(HuginGUIConstants.get("MENU_NETWORK_Recall_Policies")).setEnabled(!this.inEditMode && bl11 && this.projectFrame.getBeliefBarPanel().storedPoliciesCompatible());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.projectFrame.getRunButton(HuginGUIConstants.get("MENU_NETWORK_Store_Policies")).setEnabled(false);
        try {
            this.projectFrame.getRunButton(HuginGUIConstants.get("MENU_NETWORK_Store_Policies")).setEnabled(!this.inEditMode && bl11);
        }
        catch (Exception exception) {
            // empty catch block
        }
        jMenuItem = this.guiFrame.enterLikelihoodNetworkMenuItem;
        jMenuItem.setEnabled(bl47);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        this.projectFrame.getRunButton(HuginGUIConstants.get("MENU_NETWORK_Enter_Likelihood")).setEnabled(bl47);
        jMenuItem = this.guiFrame.retractEvidNetworkMenuItem;
        jMenuItem.setEnabled(bl48);
        jMenuItem.getAction().setEnabled(bl48);
        jMenuItem = this.guiFrame.dSeparationNetworkMenuItem;
        jMenuItem.setEnabled(bl34);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.dConnectionNetworkMenuItem;
        jMenuItem.setEnabled(bl35);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.dRelationNetworkMenuItem;
        jMenuItem.setEnabled(bl33);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.markovBlanketNetworkMenuItem;
        jMenuItem.setEnabled(!bl11 && !this.containsInstanceNodes() && this.selectedNodes.size() == 1);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.limidsRequisiteParentsMenuItem;
        jMenuItem.setEnabled((!this.inEditMode || this.inEditMode && this.projectFrame.isPre60()) && this.selectedNodes.size() == 1 && node7 instanceof DiscreteDecisionNode);
        jMenuItem = this.guiFrame.traverseInstanceNetworkMenuItem;
        jMenuItem.setEnabled(!this.inEditMode && bl7 && node7 instanceof InstanceNode);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.editNetworkMenuItem;
        jMenuItem.setEnabled(!this.inEditMode);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.compileNetworkMenuItem;
        jMenuItem.setVisible(!this.inEditMode);
        jMenuItem = this.guiFrame.runNetworkMenuItem;
        jMenuItem.setVisible(this.inEditMode);
        jMenuItem = this.guiFrame.compileNetworkMenuItem;
        jMenuItem.setEnabled(bl6);
        jMenuItem.getAction().setEnabled(bl6);
        jMenuItem = this.guiFrame.runNetworkMenuItem;
        jMenuItem.setEnabled(bl6);
        jMenuItem.getAction().setEnabled(bl6);
        this.projectFrame.getEditButton("RunMode").setEnabled(bl6);
        jMenuItem = this.guiFrame.saveEliminationOrderMenuItem;
        jMenuItem.setEnabled(!this.inEditMode);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.importModelInformationNetworkMenuItem;
        jMenuItem.setEnabled(this.inEditMode);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.valueOfInformationAnalysisMenuItem;
        jMenuItem.setEnabled(bl23);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.seAnalysisMenuItem;
        jMenuItem.setEnabled(bl24);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.PMIActionNetworkMenuItem;
        jMenuItem.setEnabled(bl5);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        object = this.projectFrame.getEditButton(HuginGUIConstants.get("MENU_NETWORK_PMI"));
        if (object != null) {
            ((AbstractButton)object).setEnabled(bl5);
        }
        jMenuItem = this.guiFrame.convolutionNetworkMenuItem;
        jMenuItem.setEnabled(bl30);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.xoiModelNetworkMenuItem;
        jMenuItem.setEnabled(bl32);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.jointAnalysisNetworkMenuItem;
        jMenuItem.setEnabled(bl21);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.correlationNetworkMenuItem;
        jMenuItem.setEnabled(bl21);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.simulateMenuItem;
        jMenuItem.setEnabled(bl22);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.renameNetworkMenuItem;
        jMenuItem.setEnabled(true);
        jMenuItem.getAction().setEnabled(true);
        jMenuItem = this.guiFrame.propertiesNetworkMenuItem;
        jMenuItem.setEnabled(true);
        jMenuItem.getAction().setEnabled(true);
        try {
            bl = this.projectFrame.beliefBars != null && this.projectFrame.beliefBars.evidenceIsEntered();
        }
        catch (Exception exception) {
            bl = false;
        }
        boolean bl49 = NetworkInformation.hasExperienceTables(this.home) && !this.containsInstanceNodes() && !this.containsCDVTLinks();
        boolean bl50 = bl6 && !NetworkInformation.isDecision(this.home) && this.inEditMode && !this.containsCDVTLinks();
        jMenuItem = this.guiFrame.emLearningNetworkMenuItem;
        jMenuItem.setEnabled(bl50 && NetworkInformation.hasExperienceTablesInSomeClass(this.home));
        jMenuItem.getAction().setEnabled(bl50 && NetworkInformation.hasExperienceTablesInSomeClass(this.home));
        this.projectFrame.getEditButton("LearnTables").setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.adaptationNetworkMenuItem;
        jMenuItem.setEnabled(!this.inEditMode && bl49 && bl);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        this.projectFrame.getRunButton(HuginGUIConstants.get("MENU_NETWORK_Adaptation")).setEnabled(jMenuItem.isEnabled());
        boolean bl51 = false;
        try {
            Domain domain4 = this.projectFrame.getBeliefBarPanel().getDomain();
            bl51 = !this.inEditMode && domain4.equilibriumIs(Domain.H_EQUILIBRIUM_SUM) && domain4.evidenceIsPropagated() && !this.isLIMIDs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        bl51 = bl51 && !this.containsCDVTLinks();
        jMenuItem = this.guiFrame.getConflictResolutionsNetworkMenuItem;
        jMenuItem.setEnabled(bl51);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        this.projectFrame.getRunButton(HuginGUIConstants.get("MENU_NETWORK_Get_Conflict_Resolutions")).setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.alignOptionsMenu;
        jMenuItem.setEnabled(this.selectedNodes.size() > 1);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        boolean bl52 = !this.guiFrame.menuIsMinimized();
        jMenuItem = this.guiFrame.cascadeWindowsMenuItem;
        jMenuItem.setEnabled(bl52);
        jMenuItem.getAction().setEnabled(bl52);
        this.guiFrame.getButton(9).setEnabled(bl52);
        jMenuItem = this.guiFrame.tileHorizontalWindowsMenuItem;
        jMenuItem.setEnabled(bl52);
        jMenuItem.getAction().setEnabled(bl52);
        this.guiFrame.getButton(7).setEnabled(bl52);
        jMenuItem = this.guiFrame.tileVerticalWindowsMenuItem;
        jMenuItem.setEnabled(bl52);
        jMenuItem.getAction().setEnabled(bl52);
        this.guiFrame.getButton(8).setEnabled(bl52);
        jMenuItem = this.guiFrame.closeAllWindowsMenuItem;
        jMenuItem.setEnabled(bl52);
        jMenuItem.getAction().setEnabled(bl52);
        jMenuItem = this.guiFrame.emLearningWizardsMenuItem;
        jMenuItem.setEnabled(bl50);
        jMenuItem.getAction().setEnabled(bl50);
        boolean bl53 = false;
        boolean bl54 = false;
        boolean bl55 = false;
        boolean bl56 = false;
        NetworkModel networkModel = null;
        HuginProjectFrame huginProjectFrame = Hugin.mainFrame.getSelectedProjectFrame();
        try {
            Object object2;
            if (huginProjectFrame.runMode && huginProjectFrame.getBeliefBarPanel().getDomain() != null && huginProjectFrame.getBeliefBarPanel().getDomain().isCompiled() && !huginProjectFrame.getBeliefBarPanel().getDomain().isCompressed()) {
                bl53 = true;
                bl55 = true;
                networkModel = huginProjectFrame.getBeliefBarPanel().getDomain();
            } else {
                bl53 = false;
                bl55 = false;
            }
            if (bl53) {
                COM.hugin.HAPI.Node node8;
                object2 = networkModel.getNodes();
                Iterator iterator = ((AbstractSequentialList)object2).iterator();
                while (iterator.hasNext()) {
                    node8 = (COM.hugin.HAPI.Node)iterator.next();
                    if (!(node8 instanceof COM.hugin.HAPI.DiscreteChanceNode)) continue;
                    bl54 = true;
                    bl56 = true;
                }
                if (!bl56) {
                    bl55 = false;
                }
                iterator = ((AbstractSequentialList)object2).iterator();
                while (iterator.hasNext()) {
                    node8 = (COM.hugin.HAPI.Node)iterator.next();
                    if (!(node8 instanceof COM.hugin.HAPI.DiscreteDecisionNode) && !(node8 instanceof COM.hugin.HAPI.UtilityNode)) continue;
                    bl54 = false;
                }
            }
            if (bl55 && ((object2 = this.getHome().getAttribute("HR_Instantiated_in")) != null && ((String)object2).trim().length() > 0 || this.containsInstanceNodes())) {
                bl55 = false;
            }
            if (huginProjectFrame.getBeliefBarPanel().getDomain().evidenceToPropagate()) {
                bl55 = false;
                bl53 = false;
            }
        }
        catch (Exception exception) {
            bl54 = false;
            bl53 = false;
            bl55 = false;
        }
        if (!bl54) {
            bl53 = false;
        }
        if (this.hasCDVT()) {
            bl53 = false;
            bl55 = false;
        }
        this.guiFrame.analysisWizardsMenuItem.getAction().setEnabled(bl53);
        boolean bl57 = bl6 && !NetworkInformation.isDecision(this.home) && !this.containsInstanceNodes() && n12 - n4 > 0 && NetworkInformation.hasExperienceTables(this.home) && this.inEditMode && !this.containsCDVTLinks();
        this.guiFrame.hiddenNodeAnalyzerMenuItem.getAction().setEnabled(bl57);
        boolean bl58 = bl6 && !NetworkInformation.isDecision(this.home) && !this.containsInstanceNodes() && this.inEditMode && !this.containsCDVTLinks();
        this.guiFrame.featureSelectionAnalyzerMenuItem.getAction().setEnabled(bl58);
        boolean bl59 = !this.containsInstanceNodes() && !this.containsCDVTLinks() && this.containsDiscreteChanceNodes() && this.projectFrame.runMode;
        this.guiFrame.adaptationWizardsMenuItem.getAction().setEnabled(bl59);
        this.guiFrame.sensitivityWizardsMenuItem.getAction().setEnabled(bl55);
        this.setToolButtonSelection();
        Hugin.mainFrame.reportNetworkMenuItem.setEnabled(this.inEditMode);
        Hugin.mainFrame.flipNetworkMenuItem.setEnabled(this.inEditMode);
        Hugin.mainFrame.layoutNetworkMenuItem.setEnabled(true);
        Hugin.mainFrame.documentNetworkMenuItem.setEnabled(true);
        Hugin.mainFrame.documentNetworkMenuItem.setEnabled(true);
        if (this.containsUncompiledChanges() && !this.inEditMode) {
            this.projectFrame.startBlinker();
        }
    }

    protected void updateInstanceNodeTool() {
        boolean bl = this.home instanceof Class && this.inEditMode && PopupClassesList.getClassCount((Class)this.home) > 0;
        JMenuItem jMenuItem = this.guiFrame.instanceToolEditMenuItem;
        jMenuItem.setEnabled(bl);
        jMenuItem.getAction().setEnabled(bl);
        this.projectFrame.getEditButton("InstanceTool").setEnabled(bl);
    }

    protected boolean isLIMIDs() {
        try {
            if (this.home.getNumberOfDecisionNodes() > 0 || this.home.getNumberOfUtilityNodes() > 0) {
                return true;
            }
            if (this.home.getNumberOfInstanceNodes() > 0) {
                ArrayList<Class> arrayList = new ArrayList<Class>();
                ArrayList<Class> arrayList2 = new ArrayList<Class>();
                ArrayList<Class> arrayList3 = new ArrayList<Class>();
                for (COM.hugin.HAPI.Node object : this.home.getNodes()) {
                    if (!(object instanceof COM.hugin.HAPI.InstanceNode)) continue;
                    arrayList.add(((COM.hugin.HAPI.InstanceNode)object).getInstanceClass());
                }
                while (arrayList.size() > 0) {
                    arrayList2.addAll(arrayList);
                    arrayList3.addAll(arrayList);
                    arrayList.clear();
                    for (NetworkModel networkModel : arrayList2) {
                        if (networkModel.getNumberOfDecisionNodes() > 0 || networkModel.getNumberOfUtilityNodes() > 0) {
                            return true;
                        }
                        if (networkModel.getNumberOfInstanceNodes() <= 0) continue;
                        for (COM.hugin.HAPI.Node node : networkModel.getNodes()) {
                            Class clazz;
                            if (!(node instanceof COM.hugin.HAPI.InstanceNode) || arrayList3.contains(clazz = ((COM.hugin.HAPI.InstanceNode)node).getInstanceClass())) continue;
                            arrayList.add(clazz);
                        }
                    }
                }
            }
            return false;
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
            return false;
        }
    }

    private boolean containsInstanceOf(Class clazz) {
        if (this.getHomeClass() == null) {
            return false;
        }
        return HuginProjectFrame.containsInstanceOf(this.getHomeClass(), clazz);
    }

    protected boolean containsContinuousNodes() {
        if (this.nodeList == null) {
            return false;
        }
        for (Node node : this.nodeList) {
            try {
                if (!node.isContinuousChance() && (!(node instanceof InstanceNode) || !HuginGUIFrame.getNetworkPanel(((InstanceNode)node).instanceOf).containsContinuousNodes())) continue;
                return true;
            }
            catch (NullPointerException nullPointerException) {
            }
        }
        return false;
    }

    protected boolean containsDiscreteChanceNodes() {
        for (Node node : this.nodeList) {
            if (!node.isDiscreteChance()) continue;
            return true;
        }
        return false;
    }

    protected boolean isPartOfContinuousNet() throws ExceptionHugin {
        if (this.home instanceof Class) {
            for (NetworkPanel networkPanel : HuginGUIUtils.getContainers((Class)this.home)) {
                if (!networkPanel.containsContinuousNodes()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isPartOfInfluenceDiagram() throws ExceptionHugin {
        if (this.home instanceof Class) {
            for (NetworkPanel networkPanel : HuginGUIUtils.getContainers((Class)this.home)) {
                if (!networkPanel.isLIMIDs()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean containsInstanceNodes() {
        for (Node node : this.nodeList) {
            if (!node.isInstance()) continue;
            return true;
        }
        return false;
    }

    protected boolean containsCDVTLinks() {
        for (Link link : this.linkList) {
            if (!(link instanceof CDVTLink)) continue;
            return true;
        }
        return false;
    }

    protected boolean containsInterfaceNodes() {
        for (Node node : this.nodeList) {
            if (!node.isInterface()) continue;
            return true;
        }
        return false;
    }

    protected boolean isClassNet() {
        for (Node node : this.nodeList) {
            if (!node.isInterface() && !node.isInstance()) continue;
            return true;
        }
        return false;
    }

    protected void selectAllNodes() {
        this.selectAllNodes(false);
    }

    protected void selectAllNodes(boolean bl) {
        if (bl) {
            this.nodeList.passiveSelectAll();
        } else {
            this.nodeList.selectAll();
        }
        if (this.selectedNodes.size() > 0) {
            this.repaintRectangle(this.computeBoundingBoxForSelectedNodes());
            this.updateButtonAndMenuStates();
        }
    }

    protected void deselectAllNodes() {
        this.deselectAllNodes(false);
    }

    protected void deselectAllNodes(boolean bl) {
        if (this.selectedNodes.size() > 0) {
            Rectangle rectangle = this.computeBoundingBoxForSelectedNodes();
            if (bl) {
                this.selectedNodes.passiveClear();
            } else {
                this.selectedNodes.clear();
            }
            this.updateButtonAndMenuStates();
            this.repaintRectangle(rectangle);
        }
    }

    protected void copySelectedNodes() throws ExceptionHugin {
        if (this.selectedNodes.size() == 0) {
            return;
        }
        nodeBuffer.clear();
        linkBuffer.clear();
        for (Node cloneable : this.selectedNodes) {
            nodeBuffer.add(cloneable.copy());
        }
        for (Link link : this.linkList) {
            if (!this.selectedNodes.contains(link.child) && !this.selectedNodes.contains(link.child.host) || !this.selectedNodes.contains(link.parent) && !this.selectedNodes.contains(link.parent.host)) continue;
            linkBuffer.add((Link)link.clone());
        }
        if (this.selectedNodes.size() == 1) {
            this.writeStatus(HuginGUIConstants.get("str_node_copied_to_clipboard"));
        } else {
            this.writeStatus(this.selectedNodes.size() + HuginGUIConstants.get("str__nodes_copied_to_clipboard"));
        }
        bufferedNodesAreCut = false;
        this.updateButtonAndMenuStates();
        this.resetPasteNumbers();
    }

    protected void resetPasteNumber() {
        this.pasteNumber = 0;
    }

    protected void resetPasteNumbers() {
        NetworkPanel networkPanel = this;
        for (HuginProjectFrame huginProjectFrame : networkPanel.guiFrame.getProjectFrames()) {
            huginProjectFrame.getNetworkPanel().resetPasteNumber();
        }
    }

    protected void pasteBufferedNodes() throws ExceptionHugin {
        Object object3;
        String[] stringArray;
        Object object2;
        if (nodeBuffer.size() == 0 || this.projectFrame.runMode) {
            return;
        }
        boolean bl = false;
        try {
            object2 = this.getHome().getAttribute("HR_Instantiated_in");
            if (object2 != null && ((String)object2).trim().length() > 0 || this.containsInstanceNodes()) {
                bl = true;
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        for (Link cloneable2 : linkBuffer) {
            if (!(cloneable2 instanceof CDVTLink) || !this.containsInstanceNodes() || !bl) continue;
            nodeBuffer.clear();
            linkBuffer.clear();
            this.writeStatus(HuginGUIConstants.get("str_cannot_create_nodes_with_cdvt_links_in_instantiated_classes_or_classes_containing_instance_nodes_"));
            return;
        }
        object2 = this.deselectNodes(null);
        LinkedList<Node> linkedList = new LinkedList<Node>();
        NetworkPanel networkPanel = NetworkPanel.nodeBuffer.getFirst().panel;
        double d = networkPanel.getNodeWidth();
        double d2 = networkPanel.getNodeHeight();
        double d3 = this.scaleFactor / networkPanel.getScaleFactor();
        double d4 = d3 * ((double)this.nodeWidth / d);
        double d5 = d3 * ((double)this.nodeHeight / d2);
        ++this.pasteNumber;
        for (Node n : nodeBuffer) {
            if (n instanceof InstanceNode && this.hasCDVT()) {
                nodeBuffer.clear();
                linkBuffer.clear();
                this.writeStatus(HuginGUIConstants.get("str_cannot_create_instance_nodes_in_a_network_containing_cdvt_node_pairs"));
                return;
            }
            if (n.isInstance() && ((InstanceNode)n.cloneOf).instanceOf == this.home) {
                new HuginGUIError(HuginGUIConstants.get("str_cannot_paste_") + n.cloneOf.name + HuginGUIConstants.get("str___as_it_is_an_instance_of_this_network"));
                continue;
            }
            int n2 = (int)(d4 * n.center.x);
            int n3 = (int)(d5 * n.center.y);
            if (!bufferedNodesAreCut) {
                int exception = n.home == this.home ? this.pasteNumber : this.pasteNumber - 1;
                n2 = (int)((double)n2 + (double)exception * this.scaleFactor * (double)this.nodeWidth);
                n3 = (int)((double)n3 + (double)exception * this.scaleFactor * (double)this.nodeHeight);
            }
            try {
                linkedList.add((Node)n.clone(this, new Point(n2 -= (n.getWidth() - this.nodeWidth) / 2, n3 -= (n.getHeight() - this.nodeHeight) / 2)));
            }
            catch (Exception node) {
                new HuginGUIError(HuginGUIConstants.get("str_unable_to_paste_") + n.getName() + ":\n" + node.getMessage());
            }
        }
        for (Link link : linkBuffer) {
            Node node = this.getClone(this.getClone(link.parent, nodeBuffer), linkedList);
            Node node2 = this.getClone(this.getClone(link.child, nodeBuffer), linkedList);
            if (node2 == null || node == null) continue;
            Link node3 = null;
            node3 = link instanceof CDVTLink ? new CDVTLink(node, node2) : new Link(node, node2, this.scaleFactor, link.getSpline(), link.getMode());
            if (!bufferedNodesAreCut) {
                int n = (int)(this.scaleFactor * (double)this.nodeWidth);
                int n4 = (int)(this.scaleFactor * (double)this.nodeHeight);
                if (link.getSpline() != null) {
                    link.getSpline().move(n, n4);
                }
            }
            this.linkList.add(node3);
            if (link instanceof CDVTLink) continue;
            if (node2.host == null) {
                node2.getAPINode().addParent(node.getAPINode());
                continue;
            }
            ((COM.hugin.HAPI.InstanceNode)node2.host.getAPINode()).setInput(node2.getAPINode(), node.getAPINode());
        }
        if (linkedList.size() > 0 && ((Node)linkedList.getFirst()).cloneOf.panel.equals(this)) {
            for (Node node : linkedList) {
                if (node.isInstance()) continue;
                stringArray = node.getOriginalParents();
                LinkedList<Node> linkedList2 = node.cloneOf.getNodeInfo().getParents();
                for (Node node4 : linkedList2) {
                    if (stringArray.contains(node4) || !this.nodeList.contains(node4) && (node4.host == null || !this.nodeList.contains(node4.host))) continue;
                    node.getAPINode().addParent(node4.getAPINode());
                    this.linkList.add(new Link(node4, node, this.scaleFactor));
                }
            }
        }
        boolean bl2 = false;
        for (Node node : nodeBuffer) {
            if (node == null || node.getNodeInfo() == null || node.getNodeInfo().modelNodes == null) continue;
            NodeList nodeList = new NodeList();
            for (Node node5 : node.getNodeInfo().modelNodes) {
                object3 = this.getClone(node5, nodeBuffer);
                if (object3 != null) {
                    object3 = this.getClone((Node)object3, linkedList);
                    nodeList.add(((Node)object3).getAPINode());
                    continue;
                }
                if (!linkedList.getFirst().cloneOf.panel.equals(this)) continue;
                nodeList.add(node5.getAPINode());
            }
            Model model = new Model(this.getClone(node, linkedList).getAPINode(), nodeList);
            stringArray = new String[node.cloneOf.getParents().size() * 2];
            int n = 0;
            for (Object object3 : node.cloneOf.getParents()) {
                Node node6 = this.getClone((Node)object3, nodeBuffer);
                if (node6 != null) {
                    Node node7 = this.getClone(node6, linkedList);
                    stringArray[n++] = ((Node)object3).getName();
                    stringArray[n++] = node7.getName();
                    continue;
                }
                if (!linkedList.getFirst().cloneOf.panel.equals(this)) continue;
                stringArray[n++] = ((Node)object3).getName();
                stringArray[n++] = ((Node)object3).getName();
            }
            node.getNodeInfo().setModelNodeMap(stringArray);
        }
        Object object4 = null;
        Iterator iterator = linkedList.listIterator();
        while (iterator.hasNext()) {
            object4 = (Node)iterator.next();
            try {
                ((Node)object4).restoreSavedCardinality();
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                try {
                    iterator.remove();
                    ((Node)object4).kill();
                }
                catch (Exception exception2) {}
            }
        }
        if (linkedList.size() == 0) {
            return;
        }
        iterator = linkedList.listIterator();
        while (iterator.hasNext()) {
            try {
                ((Node)iterator.next()).restoreSavedNodeInfo();
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                try {
                    iterator.remove();
                    ((Node)object4).kill();
                }
                catch (Exception exception3) {}
            }
        }
        this.nodeList.addAll(linkedList);
        this.selectedNodes.addAll((AbstractList<Node>)linkedList);
        for (Node node : linkedList) {
            node.createInterfaceType();
        }
        if (bufferedNodesAreCut) {
            this.copySelectedNodes();
        }
        if (this.selectedNodes.size() == 1) {
            this.writeStatus(HuginGUIConstants.get("str_node_pasted_from_clipboard"));
        } else if (this.selectedNodes.size() > 1) {
            this.writeStatus(this.selectedNodes.size() + HuginGUIConstants.get("str__nodes_pasted_from_clipboard"));
        }
        for (Node node : linkedList) {
            String string = node.getAPINode().getAttribute("HR_CDVT_parent");
            if (string == null) continue;
            boolean bl3 = true;
            for (Link link : this.linkList) {
                if (!(link instanceof CDVTLink) || ((CDVTLink)link).child != node) continue;
                bl3 = false;
            }
            object3 = this.getNode(string);
            if (bl3 && (object3 == null || this.containsInstanceNodes())) {
                bl3 = false;
                try {
                    node.getAPINode().setAttribute("HR_CDVT_parent", null);
                }
                catch (ExceptionHugin exceptionHugin) {
                    new HuginGUIError(exceptionHugin);
                }
            }
            if (!bl3 || this.containsInstanceNodes() || linkedList.contains(object3)) continue;
            this.linkList.add(new CDVTLink((Node)object3, node));
        }
        for (Link link : this.linkList) {
            if (!(link instanceof CDVTLink)) continue;
            ((CDVTLink)link).registerAttributes();
        }
        this.containsUnsavedChanges(true);
        this.containsUncompiledChanges(true);
        ((Rectangle)object2).add(this.computeBoundingBoxForSelectedNodes());
        this.repaintRectangle((Rectangle)object2);
        this.updateButtonAndMenuStates();
    }

    protected void cutSelectedNodes() throws ExceptionHugin {
        this.deleteInProgress = true;
        this.deleteSelectedNodes(true);
        this.deleteInProgress = false;
    }

    protected void reverseSelectedLink() throws ExceptionHugin {
        if (this.selectedLinks.size() != 1) {
            return;
        }
        Link link = this.selectedLinks.getFirst();
        LinkedList<Link> linkedList = new LinkedList<Link>();
        int n = link.reverse(linkedList);
        switch (n) {
            case -1: {
                break;
            }
            case 0: {
                this.containsUnsavedChanges(true);
                this.containsUncompiledChanges(true);
                link.child.updateTable(this.showTables);
                link.parent.updateTable(this.showTables);
                for (Link object : linkedList) {
                    if (this.linkList.contains(object)) continue;
                    this.linkList.add(object);
                }
                Rectangle rectangle = link.getBoundingBox();
                for (Link link2 : linkedList) {
                    rectangle.add(link2.getBoundingBox());
                }
                this.repaintRectangle(rectangle);
                this.writeStatus(link.getDescription() + HuginGUIConstants.get("str__reversed_model_size_") + this.getModelSize() + ")");
                break;
            }
            case 1: {
                this.writeErrorStatus(HuginGUIConstants.get("str_binding_links_cannot_be_reversed"));
                break;
            }
            case 2: {
                this.writeErrorStatus(HuginGUIConstants.get("str_cannot_reverse_link_as_output_nodes_cannot_have_outside_parents"));
                break;
            }
            case 4: {
                this.writeErrorStatus(HuginGUIConstants.get("str_information_links_cannot_be_reversed"));
                break;
            }
            case 5: {
                this.writeErrorStatus(HuginGUIConstants.get("str_cannot_reverse_link_utility_nodes_cannot_be_parents"));
                break;
            }
            case 3: {
                this.writeErrorStatus(HuginGUIConstants.get("str_cannot_reverse_link_as_cont_nodes_are_not_allowed_to_be_parents"));
                break;
            }
            case 6: {
                this.writeErrorStatus(HuginGUIConstants.get("str_cannot_reverse_link_as_this_would_introduce_a_directed_cycle"));
                break;
            }
        }
    }

    protected void alignSelectedNodesLeft() throws ExceptionHugin {
        Rectangle rectangle = this.computeBoundingBoxForSelectedNodes();
        int n = 0;
        for (Node node : this.selectedNodes) {
            if (n != 0 && !(node.x < (double)n)) continue;
            n = (int)node.x;
        }
        for (Node node : this.selectedNodes) {
            node.move(n - (int)node.x, 0);
        }
        this.relocateLinksForSelectedNodes();
        this.repaintRectangle(rectangle);
        this.containsUnsavedChanges(true);
    }

    protected void alignSelectedNodesRight() throws ExceptionHugin {
        Rectangle rectangle = this.computeBoundingBoxForSelectedNodes();
        int n = 0;
        for (Node node : this.selectedNodes) {
            if (n != 0 && !(node.x > (double)n)) continue;
            n = (int)node.x;
        }
        for (Node node : this.selectedNodes) {
            node.move(n - (int)node.x, 0);
        }
        this.relocateLinksForSelectedNodes();
        this.repaintRectangle(rectangle);
        this.containsUnsavedChanges(true);
    }

    protected void alignSelectedNodesTop() throws ExceptionHugin {
        Rectangle rectangle = this.computeBoundingBoxForSelectedNodes();
        int n = 0;
        for (Node node : this.selectedNodes) {
            if (n != 0 && !(node.y < (double)n)) continue;
            n = (int)node.y;
        }
        for (Node node : this.selectedNodes) {
            node.move(0, n - (int)node.y);
        }
        this.relocateLinksForSelectedNodes();
        this.repaintRectangle(rectangle);
        this.containsUnsavedChanges(true);
    }

    protected void alignSelectedNodesBottom() throws ExceptionHugin {
        Rectangle rectangle = this.computeBoundingBoxForSelectedNodes();
        int n = 0;
        for (Node node : this.selectedNodes) {
            if (n != 0 && !(node.y > (double)n)) continue;
            n = (int)node.y;
        }
        for (Node node : this.selectedNodes) {
            node.move(0, n - (int)node.y);
        }
        this.relocateLinksForSelectedNodes();
        this.repaintRectangle(rectangle);
        this.containsUnsavedChanges(true);
    }

    protected boolean snapSelectedNodesToGrid() {
        if (this.selectedNodes.size() == 0) {
            return false;
        }
        Rectangle rectangle = this.computeBoundingBoxForSelectedNodes();
        boolean bl = false;
        for (Node node : this.selectedNodes) {
            try {
                node.snapTo(this.grid);
            }
            catch (Exception exception) {
                if (!bl) {
                    new HuginGUIError(HuginGUIConstants.get("str_unable_to_snap_to_node_") + exception.getMessage());
                }
                bl = true;
            }
        }
        this.relocateLinksForSelectedNodes();
        rectangle.add(this.computeBoundingBoxForSelectedNodes());
        this.repaintRectangle(rectangle);
        this.containsUnsavedChanges(true);
        return true;
    }

    protected void showPolicies() {
        for (Node node : this.selectedNodes) {
            try {
                if (this.projectFrame instanceof TraversalFrame) {
                    COM.hugin.HAPI.Node node2 = this.projectFrame.getBeliefBarPanel().getDomainNodeFor(node.getAPINode());
                    if (node2 == null) {
                        node2 = this.projectFrame.getBeliefBarPanel().getDomain().getNodeByName(node.getName());
                    }
                    if (node2 == null) continue;
                    this.showInstancePolicy(node2);
                    if (!node.isInput()) continue;
                    Point2D point2D = node.getAPINode().getPosition();
                    Point point = new Point((int)point2D.getX(), (int)point2D.getY());
                    this.getSecretNode(node2).setPoliciesWindowLocation(point);
                    continue;
                }
                if (!(node instanceof DiscreteDecisionNode) || !this.nodeList.contains(node)) continue;
                if (node.policiesWindow == null) {
                    node.policiesWindow = new RunModePoliciesWindow(node, this.projectFrame);
                    this.add(node.policiesWindow);
                    node.policiesWindow.setVisible(true);
                    this.projectFrame.beliefBars.addPolicyUpdateListener(node.policiesWindow.myUpdateListener);
                    continue;
                }
                node.policiesWindow.updateApiNode();
                node.policiesWindow.setVisible(true);
                node.policiesWindow.display = true;
                this.projectFrame.beliefBars.addPolicyUpdateListener(node.policiesWindow.myUpdateListener);
            }
            catch (ExceptionHugin exceptionHugin) {
                new HuginGUIError(exceptionHugin);
            }
        }
    }

    protected void showInstancePolicy(COM.hugin.HAPI.Node node) {
        Node node2 = this.getSecretNode(node);
        try {
            if (node2 instanceof DiscreteDecisionNode) {
                if (node2.policiesWindow == null) {
                    Cloneable cloneable;
                    node2.policiesWindow = new RunModePoliciesWindow(node2, this.projectFrame);
                    this.add(node2.policiesWindow);
                    node2.policiesWindow.setVisible(true);
                    this.projectFrame.beliefBars.addPolicyUpdateListener(node2.policiesWindow.myUpdateListener);
                    Point2D point2D = null;
                    NodeList nodeList = node.getSource();
                    while (nodeList.size() > 0) {
                        cloneable = (COM.hugin.HAPI.Node)nodeList.removeLast();
                        if (this.projectFrame instanceof TraversalFrame && cloneable instanceof COM.hugin.HAPI.InstanceNode && ((COM.hugin.HAPI.InstanceNode)cloneable).getInstanceClass() == ((TraversalFrame)this.projectFrame).getInstanceClass()) break;
                        point2D = cloneable.getPosition();
                    }
                    if (point2D != null) {
                        cloneable = new Point((int)point2D.getX(), (int)point2D.getY());
                        node2.setPoliciesWindowLocation((Point)cloneable);
                    }
                } else {
                    node2.policiesWindow.updateApiNode();
                    node2.policiesWindow.setVisible(true);
                    node2.policiesWindow.display = true;
                    this.projectFrame.beliefBars.addPolicyUpdateListener(node2.policiesWindow.myUpdateListener);
                }
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
    }

    protected void hidePolicies() {
        for (Node node : this.nodeList) {
            if (!(node instanceof DiscreteDecisionNode) || node.policiesWindow == null || !node.policiesWindow.display) continue;
            node.policiesWindow.setVisible(false);
            node.policiesWindow.setNotAlive();
            this.projectFrame.beliefBars.removePolicyUpdateListener(node.policiesWindow.myUpdateListener);
        }
        for (Node node : this.secretListOfInstanceMembers) {
            if (!(node instanceof DiscreteDecisionNode) || node.policiesWindow == null || !node.policiesWindow.display) continue;
            node.policiesWindow.setVisible(false);
            node.policiesWindow.setNotAlive();
            this.projectFrame.beliefBars.removePolicyUpdateListener(node.policiesWindow.myUpdateListener);
        }
    }

    protected void restorePolicies() {
        for (Node node : this.nodeList) {
            if (!(node instanceof DiscreteDecisionNode) || node.policiesWindow == null || !node.policiesWindow.display) continue;
            node.policiesWindow.updateApiNode();
            node.policiesWindow.setVisible(true);
            node.policiesWindow.updateSize();
            this.projectFrame.beliefBars.addPolicyUpdateListener(node.policiesWindow.myUpdateListener);
        }
        for (Node node : this.secretListOfInstanceMembers) {
            if (!(node instanceof DiscreteDecisionNode) || node.policiesWindow == null || !node.policiesWindow.display) continue;
            node.policiesWindow.updateApiNode();
            node.policiesWindow.setVisible(true);
            node.policiesWindow.updateSize();
            this.projectFrame.beliefBars.addPolicyUpdateListener(node.policiesWindow.myUpdateListener);
        }
    }

    protected void showMonitors() throws ExceptionHugin {
        if (!this.confirmNodeSelection(this.numberOfAdditionalMonitors(), this.numberOfOpenMonitors() > 0)) {
            return;
        }
        this.showMonitors(this.selectedNodes);
        this.updateButtonAndMenuStates();
    }

    protected void showMonitors(LinkedList<Node> linkedList) throws ExceptionHugin {
        double d = this.scaleFactor;
        for (Node node : this.nodeList) {
            if (node.monitor == null) continue;
            d = node.monitor.getScaleFactor();
            break;
        }
        for (Node node : linkedList) {
            if (this.projectFrame instanceof TraversalFrame) {
                COM.hugin.HAPI.Node node2 = this.projectFrame.getBeliefBarPanel().getDomainNodeFor(node.getAPINode());
                if (node2 == null) {
                    node2 = this.projectFrame.getBeliefBarPanel().getDomain().getNodeByName(node.getName());
                }
                if (node2 == null) continue;
                this.showInstanceMonitor(node2);
                if (!node.isInput()) continue;
                Point2D point2D = node.getAPINode().getPosition();
                Point point = new Point((int)point2D.getX(), (int)point2D.getY());
                this.getSecretNode(node2).setMonitorLocation(point);
                continue;
            }
            if (!this.nodeList.contains(node) && !this.secretListOfInstanceMembers.contains(node)) continue;
            if (node.monitor == null && !(node instanceof InstanceNode)) {
                node.monitor = new BeliefMonitor(node, this.projectFrame);
                node.monitor.setScaleFactor(d);
                node.setMonitorLocation(false);
                this.add(node.monitor);
                this.setGraphicsSize(node.monitor.getBounds());
                node.monitor.setVisible(true);
            }
            if (node.monitor == null) continue;
            node.monitor.updateApiNode();
            node.monitor.setVisible(true);
        }
    }

    protected Node getSecretNode(COM.hugin.HAPI.Node node) {
        try {
            Node node2 = null;
            for (Node node3 : this.secretListOfInstanceMembers) {
                if (!node3.getName().equals(node.getName())) continue;
                node2 = node3;
                break;
            }
            if (node2 == null) {
                node2 = this.createNodeFromAPINode(node);
                node2.home = node.getHome();
                if (node2 != null) {
                    this.secretListOfInstanceMembers.add(node2);
                }
            }
            if (node2 != null) {
                return node2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    protected void showInstanceMonitor(COM.hugin.HAPI.Node node) {
        try {
            Node node2 = this.getSecretNode(node);
            if (node2.monitor == null && !(node2 instanceof InstanceNode)) {
                Cloneable cloneable;
                node2.monitor = new BeliefMonitor(node2, this.projectFrame);
                node2.monitor.setScaleFactor(this.scaleFactor);
                node2.setMonitorLocation(false);
                Point2D point2D = null;
                NodeList nodeList = node.getSource();
                while (nodeList.size() > 0) {
                    cloneable = (COM.hugin.HAPI.Node)nodeList.removeLast();
                    if (this.projectFrame instanceof TraversalFrame && cloneable instanceof COM.hugin.HAPI.InstanceNode && ((COM.hugin.HAPI.InstanceNode)cloneable).getInstanceClass() == ((TraversalFrame)this.projectFrame).getInstanceClass()) break;
                    point2D = cloneable.getPosition();
                }
                if (point2D != null) {
                    cloneable = new Point((int)point2D.getX(), (int)point2D.getY());
                    node2.setMonitorLocation((Point)cloneable);
                }
                this.add(node2.monitor);
                this.setGraphicsSize(node2.monitor.getBounds());
                node2.monitor.setVisible(true);
            }
            if (node2.monitor != null) {
                node2.monitor.updateApiNode();
                node2.monitor.setVisible(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean areSomeMonitorsOpen() {
        for (Node node : this.nodeList) {
            if (node.monitor == null || !node.monitor.isVisible()) continue;
            return true;
        }
        return false;
    }

    private int numberOfOpenMonitors() {
        int n = 0;
        for (Node node : this.nodeList) {
            if (node.monitor == null || !node.monitor.isVisible()) continue;
            ++n;
        }
        return n;
    }

    private int numberOfAdditionalMonitors() {
        int n = 0;
        for (Node node : this.selectedNodes) {
            if (node.isInstance() || node.isUtility() || node.monitor != null) continue;
            ++n;
        }
        return n;
    }

    protected void updateMonitors() {
        this.updateMonitors(false);
    }

    protected void updateMonitors(boolean bl) {
        boolean bl2 = false;
        try {
            String string = this.home.getAttribute("HR_Monitor_AutoUpdGraph");
            bl2 = string != null && string.equals("1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Node node : this.nodeList) {
            if (node.monitor == null) continue;
            node.monitor.update(bl);
            this.graphsToUpdate = !bl2 && (this.graphsToUpdate || bl);
        }
    }

    protected void updateSecretNodes() {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        Domain domain = this.projectFrame.getBeliefBarPanel().getDomain();
        for (Node node : this.secretListOfInstanceMembers) {
            try {
                String string = node.getName();
                if (string.indexOf(46) < 0) continue;
                COM.hugin.HAPI.Node node2 = domain.getNodeByName(string);
                if (node2 == null) {
                    linkedList.add(node);
                    continue;
                }
                node.setAPINode(node2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        for (Node node : linkedList) {
            if (node.monitor != null) {
                this.remove(node.monitor);
            }
            if (node.policiesWindow != null) {
                this.remove(node.policiesWindow);
            }
            this.secretListOfInstanceMembers.remove(node);
        }
    }

    protected void updateMonitorGraphs() {
        this.graphsToUpdate = false;
        for (Node node : this.nodeList) {
            if (node.monitor == null) continue;
            node.monitor.updateGraph();
        }
        for (Node node : this.secretListOfInstanceMembers) {
            if (node.monitor == null) continue;
            node.monitor.updateGraph();
        }
        this.updateButtonAndMenuStates();
    }

    protected void updateMonitorNodes() {
        for (Node node : this.nodeList) {
            if (node.monitor == null) continue;
            node.monitor.updateApiNode();
        }
        for (Node node : this.secretListOfInstanceMembers) {
            if (node.monitor == null) continue;
            node.monitor.updateApiNode();
        }
    }

    protected void repaintMonitors() {
        for (Node node : this.nodeList) {
            if (node.monitor == null) continue;
            node.monitor.repaint();
        }
        for (Node node : this.secretListOfInstanceMembers) {
            if (node.monitor == null) continue;
            node.monitor.repaint();
        }
    }

    protected void disableMonitors() {
        for (Node node : this.nodeList) {
            if (node.monitor == null) continue;
            node.monitor.setNotAlive();
        }
        for (Node node : this.secretListOfInstanceMembers) {
            if (node.monitor == null) continue;
            node.monitor.setNotAlive();
        }
    }

    protected void closeMonitors() {
        this.closeMonitors(this.nodeList);
        this.closeMonitors(this.secretListOfInstanceMembers);
    }

    protected void closeMonitors(AbstractList<Node> abstractList) {
        for (Node node : abstractList) {
            if (node.monitor == null) continue;
            node.closeMonitor();
            node.monitor.setNotAlive();
        }
    }

    protected double scaleMonitors(double d) {
        double d2 = 0.0;
        if (!this.inEditMode) {
            for (Node node : this.nodeList) {
                if (node.monitor == null) continue;
                d2 = d * node.monitor.getScaleFactor();
                if (d2 > 100.0 || d2 < 0.01) {
                    return -1.0;
                }
                node.monitor.setScaleFactor(d2);
                node.setMonitorLocation(d, false);
            }
        }
        return d2;
    }

    protected boolean snapMonitorsToNodes() {
        boolean bl = false;
        if (this.projectFrame.runMode) {
            for (Node node : this.selectedNodes) {
                if (node.monitor == null) continue;
                node.setMonitorLocation(true);
                bl = true;
            }
        }
        return bl;
    }

    private Node getClone(Node node, LinkedList<Node> linkedList) {
        if (node == null) {
            return null;
        }
        boolean bl = node.host != null;
        for (Node node2 : linkedList) {
            if (bl && node2.isInstance()) {
                for (Node node3 : ((InstanceNode)node2).inputs) {
                    if (node3.cloneOf == null || node3.cloneOf != node) continue;
                    return node3;
                }
                for (Node node3 : ((InstanceNode)node2).outputs) {
                    if (node3.cloneOf == null || node3.cloneOf != node) continue;
                    return node3;
                }
                continue;
            }
            if (node2.cloneOf == null || node2.cloneOf != node) continue;
            return node2;
        }
        return null;
    }

    protected Node getNode(String string) {
        try {
            return this.getNode(this.home.getNodeByName(string));
        }
        catch (ExceptionHugin exceptionHugin) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Node getNode(COM.hugin.HAPI.Node node) {
        if (node == null) {
            return null;
        }
        Node node2 = (Node)node.getGUINode();
        if (node2 != null && node2.panel == this) {
            return node2;
        }
        return NetworkPanel.getNode(node, this.nodeList);
    }

    protected Node getInputNode(COM.hugin.HAPI.Node node, InstanceNode instanceNode) {
        return NetworkPanel.getNode(node, instanceNode.inputs);
    }

    protected static Node getNode(COM.hugin.HAPI.Node node, LinkedList<Node> linkedList) {
        for (Node node2 : linkedList) {
            Node node3;
            if (node2.getAPINode() != null && node2.getAPINode() == node) {
                return node2;
            }
            if (!node2.isInstance() || (node3 = NetworkPanel.getNode(node, ((InstanceNode)node2).inputs)) == null && (node3 = NetworkPanel.getNode(node, ((InstanceNode)node2).outputs)) == null) continue;
            return node3;
        }
        return null;
    }

    protected LinkedList<Node> getInstanceNodes() {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (Node node : this.nodeList) {
            if (!node.isInstance()) continue;
            linkedList.add(node);
        }
        return linkedList;
    }

    protected LinkedList<Class> getInstanceNets() {
        LinkedList<Class> linkedList = new LinkedList<Class>();
        for (Node node : this.getInstanceNodes()) {
            InstanceNode instanceNode = (InstanceNode)node;
            if (linkedList.contains(instanceNode.instanceOf)) continue;
            linkedList.add(instanceNode.instanceOf);
        }
        return linkedList;
    }

    protected void readAttributes() {
        Rectangle rectangle = this.readDomainAttributes();
        this.readNodeAttributes();
        rectangle.add(this.computeBoundingBox());
        this.repaintRectangle(rectangle);
    }

    protected Rectangle readDomainAttributes() {
        boolean bl;
        boolean bl2;
        Dimension dimension = new Dimension();
        Rectangle rectangle = new Rectangle();
        try {
            this.convertGroupFormat();
            DomainAttributes.set(this);
            this.setNodeSize();
            dimension.width = Integer.parseInt(this.getHome().getAttribute("HR_Grid_X"));
            this.gridWidth = this.scaleFactor * (double)dimension.width;
            dimension.height = Integer.parseInt(this.getHome().getAttribute("HR_Grid_Y"));
            this.gridHeight = this.scaleFactor * (double)dimension.height;
            bl2 = this.getHome().getAttribute("HR_Grid_GridSnap").equals("1");
            bl = this.getHome().getAttribute("HR_Grid_GridShow").equals("1");
            this.setScaleFactor();
            this.updateBackground();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            return rectangle;
        }
        rectangle.setBounds(this.computeBoundingBox());
        if (this.showGrid != bl || !this.grid.equals(dimension)) {
            rectangle.setBounds(0, 0, this.getWidth(), this.getHeight());
        }
        this.grid.setSize(dimension);
        this.showGrid = bl;
        this.snapToGrid = bl2;
        return rectangle;
    }

    protected void readNodeAttributes() {
        Font font = this.getNodeFont();
        this.setNodeSize();
        boolean bl = false;
        for (Node node : this.nodeList) {
            block6: {
                try {
                    node.setSpecialSize();
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
                if (this.updateNodeSize) {
                    try {
                        node.updateSize();
                    }
                    catch (Exception exception) {
                        if (bl) break block6;
                        new HuginGUIError(HuginGUIConstants.get("str_unable_to_set_size_") + exception.getMessage());
                    }
                }
            }
            node.setFont(font);
            node.getGroup();
        }
        this.updateNodeSize = false;
        this.relocateLinks();
    }

    private void convertGroupFormat() throws ExceptionHugin {
        String string;
        String string2 = this.getHome().getAttribute("HR_Groups_GroupNames");
        if (string2 == null || string2.trim().length() == 0) {
            return;
        }
        String string3 = this.getHome().getAttribute("HR_Groups_GroupColors");
        if (string3 == null) {
            string3 = "";
        }
        if ((string = this.getHome().getAttribute("HR_Groups_UserGroupsNo")) == null || string.length() == 0) {
            string = "0";
        }
        int n = Integer.parseInt(string);
        int n2 = -1;
        int n3 = 0;
        String string4 = "";
        for (int i = 0; i < n; ++i) {
            int n4 = string2.indexOf(9, n2 + 1);
            if (n4 < 0 || n4 > string2.length()) {
                n4 = string2.length();
            }
            string4 = string4 + (i + 1) + (i >= n - 1 ? "" : ",");
            this.getHome().setAttribute("HR_Group_" + (i + 1) + "_Name", string2.substring(n2 + 1, n4));
            this.getHome().setAttribute("HR_Group_" + (i + 1) + "_Color", "" + Integer.parseInt(string3.substring(n3 * 2, n3 * 2 + 2)));
            ++n3;
            n2 = n4;
        }
        this.getHome().setAttribute("HR_Groups_IDs", string4);
        this.getHome().setAttribute("HR_Groups_GroupNames", null);
        this.getHome().setAttribute("HR_Groups_GroupColors", null);
        this.getHome().setAttribute("HR_Groups_UserGroupsNo", null);
    }

    protected Dimension getNodeSize() {
        Dimension dimension = new Dimension(this.nodeWidth, this.nodeHeight);
        try {
            Point2D point2D = this.getHome().getNodeSize();
            dimension.setSize((int)point2D.getX(), (int)point2D.getY());
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        return dimension;
    }

    protected Font getNodeFont() {
        int n = 12;
        Font font = DEFAULT_FONT;
        try {
            String string = this.getHome().getAttribute("HR_Font_Italic");
            if (string == null) {
                string = "0";
            }
            int n2 = Integer.parseInt(string);
            String string2 = this.getHome().getAttribute("HR_Font_Weight");
            if (string2 == null) {
                string2 = "400";
            }
            int n3 = Integer.parseInt(string2);
            String string3 = this.getHome().getAttribute("HR_Font_Size");
            if (string3 == null) {
                string3 = "-12";
            }
            n = -Integer.parseInt(string3);
            boolean bl = n3 >= 700;
            boolean bl2 = n2 > 0;
            String string4 = this.getHome().getAttribute("HR_Font_Name");
            if (string4 == null) {
                string4 = HuginGUIConstants.DEFAULT_HR_Font_Name;
            }
            int n4 = bl2 && bl ? 3 : (bl2 ? 2 : (bl ? 1 : 0));
            font = new Font(string4, n4, n);
        }
        catch (NumberFormatException numberFormatException) {
            new HuginGUIError(numberFormatException);
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        return font.deriveFont((float)((double)n * this.scaleFactor));
    }

    protected void assignSelectedNodesToGroup(int n) {
        for (Node node : this.selectedNodes) {
            node.setGroup(n);
        }
        this.repaintRectangle(this.computeBoundingBoxForSelectedNodes());
    }

    protected void selectGroup(int n) {
        Rectangle rectangle = null;
        if (this.selectedNodes.size() > 0) {
            rectangle = this.computeBoundingBoxForSelectedNodes();
            this.selectedNodes.clear();
        }
        for (Node node : this.nodeList.toArray(new Node[this.nodeList.size()])) {
            if (node.group == n) {
                this.selectedNodes.add(node);
                continue;
            }
            if (n == -1 && node instanceof DiscreteChanceNode) {
                this.selectedNodes.add(node);
                continue;
            }
            if (n == -2 && node instanceof ContinuousChanceNode) {
                this.selectedNodes.add(node);
                continue;
            }
            if (n == -4 && node instanceof DiscreteDecisionNode) {
                this.selectedNodes.add(node);
                continue;
            }
            if (n == -3 && node instanceof UtilityNode) {
                this.selectedNodes.add(node);
                continue;
            }
            if (n == -5 && node instanceof InstanceNode) {
                this.selectedNodes.add(node);
                continue;
            }
            if (n != -7 || !(node instanceof FunctionNode)) continue;
            this.selectedNodes.add(node);
        }
        if (this.selectedNodes.size() > 0) {
            if (rectangle != null) {
                rectangle.add(this.computeBoundingBoxForSelectedNodes());
            } else {
                rectangle = this.computeBoundingBoxForSelectedNodes();
            }
            this.updateButtonAndMenuStates();
            this.writeStatus(HuginGUIConstants.get("str_group_selected_total_cpt_size_") + this.getCPTSizeForSelectedNodes() + ")");
        }
        if (rectangle != null) {
            this.repaintRectangle(rectangle);
        }
    }

    protected static boolean isOutputClone(COM.hugin.HAPI.Node node) throws ExceptionHugin {
        return node.getMaster() != null;
    }

    protected void addStateToRelevantNode() throws ExceptionHugin {
        boolean bl;
        Node node;
        boolean bl2 = this.projectFrame.getEditButton("ShowTableWindow").isSelected();
        NodeTableFrame nodeTableFrame = this.projectFrame.tablePanel.getSelectedTable();
        if (bl2 && nodeTableFrame != null) {
            node = nodeTableFrame.getNode();
        } else {
            if (this.selectedNodes.size() != 1) {
                return;
            }
            node = (Node)this.selectedNodes.getFirst();
        }
        boolean bl3 = bl = !this.atLeastTwoStates(node);
        if (node.isInterface() && this.checkForOOBNTrouble()) {
            return;
        }
        int n = 0;
        if (node instanceof DiscreteNode) {
            ((DiscreteNode)((Object)node)).incrementNumberOfStates();
            n = ((DiscreteNode)((Object)node)).getNumberOfStates();
        }
        node.updateTable(this.showTables);
        node.updateChildTables();
        this.containsUnsavedChanges(true);
        this.containsUncompiledChanges(true);
        if (bl) {
            this.updateButtonAndMenuStates();
        }
        this.writeStatus(HuginGUIConstants.get("str_state_added_to_node_") + node.getString() + " (" + n + HuginGUIConstants.get("str__states_"));
    }

    protected void deleteStateFromRelevantNode() throws ExceptionHugin {
        Node node;
        boolean bl = this.projectFrame.getEditButton("ShowTableWindow").isSelected();
        NodeTableFrame nodeTableFrame = this.projectFrame.tablePanel.getSelectedTable();
        if (bl && nodeTableFrame != null) {
            node = nodeTableFrame.getNode();
        } else {
            if (this.selectedNodes.size() != 1) {
                return;
            }
            node = (Node)this.selectedNodes.getFirst();
        }
        if (node.isInterface() && this.checkForOOBNTrouble()) {
            return;
        }
        int n = 0;
        if (node instanceof DiscreteNode) {
            ((DiscreteNode)((Object)node)).decrementNumberOfStates();
            n = ((DiscreteNode)((Object)node)).getNumberOfStates();
        }
        node.updateTable(this.showTables);
        node.updateChildTables();
        this.containsUnsavedChanges(true);
        this.containsUncompiledChanges(true);
        if (!this.atLeastTwoStates(node)) {
            this.updateButtonAndMenuStates();
        }
        this.writeStatus("State deleted from node " + node.getString() + " (" + n + " states)");
    }

    protected void toggleTablesDisplayMode() {
    }

    private boolean atLeastTwoStates() {
        Node node;
        boolean bl = this.projectFrame.getEditButton("ShowTableWindow").isSelected();
        NodeTableFrame nodeTableFrame = this.projectFrame.tablePanel.getSelectedTable();
        if (bl && nodeTableFrame != null) {
            node = nodeTableFrame.getNode();
        } else {
            if (this.selectedNodes.size() != 1) {
                return false;
            }
            node = (Node)this.selectedNodes.getFirst();
        }
        return this.atLeastTwoStates(node);
    }

    private boolean atLeastTwoStates(Node node) {
        return node instanceof DiscreteNode && ((DiscreteNode)((Object)node)).getNumberOfStates() > 1;
    }

    protected void showTables(boolean bl) {
        this.showTables = bl;
        this.updateButtonAndMenuStates();
    }

    protected boolean showTables() {
        return this.showTables;
    }

    protected void showTablesForSelectedNodes() throws ExceptionHugin {
        if (!this.showTables() && Hugin.mainFrame.preferences.node_table_connection_mode == 1) {
            this.projectFrame.toggleTableWindow();
        }
        for (Node node : this.selectedNodes) {
            node.showTable(node.hasExperienceTable(), node.hasFadingTable());
        }
    }

    protected void hideTables() {
        for (Node node : this.selectedNodes) {
            node.hideTable();
        }
    }

    protected void selectNode(Node node) {
        if (this.selectedNodes.contains(node)) {
            return;
        }
        this.selectedNodes.add(node);
        for (Node node2 : this.selectedNodes) {
            this.repaint(node2.boundingBox);
        }
    }

    protected void selectNode(String string) {
        try {
            Node node = this.getNode(string);
            if (node == null || this.selectedNodes.contains(node)) {
                return;
            }
            this.selectedNodes.add(node);
            this.updateButtonAndMenuStates();
            this.repaint(node.boundingBox);
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    protected boolean nodeIsSelected(String string) {
        try {
            Node node = this.getNode(string);
            if (node == null) {
                return false;
            }
            return node.isSelected();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            return false;
        }
    }

    protected void deselectNode(Node node) {
        if (!this.selectedNodes.contains(node)) {
            return;
        }
        this.selectedNodes.remove(node);
        this.repaint(node.boundingBox);
    }

    protected void deselectNode(String string) {
        try {
            Node node = this.getNode(string);
            if (node == null || !this.selectedNodes.contains(node)) {
                return;
            }
            this.selectedNodes.remove(node);
            this.repaint(node.boundingBox);
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    private void popupDescription(Point point) {
        Node node = this.whichNode(point);
        try {
            if (node != null) {
                this.popupDescription(node.getAPINode().getAttribute("HR_Desc"), node.getAPINode().getAttribute("HR_HTML_Desc"), point, true);
            } else {
                this.popupDescription(this.getHome().getAttribute("HR_Desc"), this.getHome().getAttribute("HR_HTML_Desc"), point, false);
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError("NetworkPanel.popupDescription()", exceptionHugin.getMessage());
        }
    }

    private void popupDescription(String string, String string2, Point point, boolean bl) {
        Object object;
        int n = 225;
        int n2 = 30;
        Rectangle rectangle = this.getViewRect();
        int n3 = point.x + 10;
        int n4 = point.y + -10;
        if (string != null && string.toLowerCase().startsWith("<html") && ((String)(object = this.getPlainText(string))).trim().length() == 0) {
            string = null;
        }
        if (string == null || string.trim().length() == 0) {
            this.descriptionTextColor = NO_DESC_TEXT_COLOR;
            if (bl) {
                string = HuginGUIConstants.get("NO_NODE_DESCRIPTION");
                string2 = HuginGUIConstants.get("NO_NODE_DESCRIPTION");
            } else {
                string = HuginGUIConstants.get("NO_NETWORK_DESCRIPTION");
                string2 = HuginGUIConstants.get("NO_NETWORK_DESCRIPTION");
            }
        } else {
            this.descriptionTextColor = DESC_TEXT_COLOR;
            this.g2.setFont(this.descriptionFrame.getTextFont());
            object = this.g2.getFontRenderContext();
            Rectangle2D rectangle2D = this.g2.getFont().getStringBounds(string, (FontRenderContext)object);
            double d = rectangle2D.getWidth();
            double d2 = rectangle2D.getHeight();
            if (d > (double)(n - 20)) {
                n2 = (int)Math.rint(d2 * (double)((int)(d / (double)(n - 20) + 1.0))) + 14;
            }
            if (n2 > 150) {
                n2 = 150;
            }
        }
        if (n3 + n > rectangle.x + rectangle.width) {
            n3 = rectangle.x + rectangle.width - n - 10;
        }
        if (n4 + n2 > rectangle.y + rectangle.height) {
            n4 = rectangle.y + rectangle.height - n2 - 10;
        }
        this.descriptionFrame.setBounds(n3, n4, n, n2);
        this.descriptionFrame.setText(string, string2, this.descriptionTextColor, this.getHome());
        this.descriptionFrame.textArea.setCaretPosition(0);
        this.descriptionFrame.htmlTextArea.setCaretPosition(0);
        this.descriptionFrame.setVisible(true);
    }

    private String getPlainText(String string) {
        String string2 = string.toLowerCase();
        String string3 = "";
        try {
            string3 = string2.substring(string2.indexOf("<body>") + 6, string2.indexOf("</body>"));
            if (string3.contains("<p")) {
                string3 = string3.substring(string3.indexOf(">") + 1, string3.indexOf("</p"));
            }
        }
        catch (Exception exception) {
            return string2;
        }
        return string3;
    }

    protected void updateAllTables() throws ExceptionHugin {
        for (Node node : this.nodeList) {
            node.updateTable(this.showTables);
        }
    }

    protected void redisplayTables() throws ExceptionHugin {
        this.redisplayTables(false, false);
    }

    protected void redisplayTables(boolean bl, boolean bl2) throws ExceptionHugin {
        for (Node node : this.nodeList) {
            node.showTable(bl, bl2);
        }
    }

    private Rectangle swapDisplayMode(InstanceNode instanceNode) throws ExceptionHugin {
        int n = (int)instanceNode.width;
        int n2 = (int)instanceNode.height;
        Rectangle rectangle = null;
        if (this.selectedLinks.size() != 0) {
            for (Link shape2 : this.selectedLinks) {
                if (rectangle == null) {
                    rectangle = shape2.getBoundingBox();
                    continue;
                }
                rectangle.add(shape2.getBoundingBox());
            }
        }
        Rectangle rectangle2 = instanceNode.getBoundingBox(false);
        Rectangle rectangle3 = instanceNode.swapDisplayMode();
        rectangle2.add(instanceNode.getBoundingBox(false));
        if (rectangle != null) {
            rectangle2.add(rectangle);
        }
        String string = null;
        try {
            string = this.home.getAttribute("HR_OOBN_FitExpand");
        }
        catch (ExceptionHugin rectangle32) {
            // empty catch block
        }
        if (string == null || string.equals("0")) {
            Rectangle object = this.updateAffectedLinks(rectangle2);
            if (object != null) {
                rectangle2.add(object);
            }
            return rectangle2;
        }
        Object object = this.delocateAffectedNodes(instanceNode, rectangle3, (int)(instanceNode.width - (double)n), (int)(instanceNode.height - (double)n2));
        Rectangle rectangle4 = null;
        if (object == null) {
            object = rectangle2;
        } else {
            ((Rectangle)object).add(rectangle2);
        }
        --((Rectangle)object).x;
        --((Rectangle)object).y;
        ((Rectangle)object).width += 2;
        ((Rectangle)object).height += 2;
        rectangle4 = this.updateAffectedLinks((Rectangle)object);
        if (object == null) {
            object = rectangle2;
        } else {
            ((Rectangle)object).add(rectangle2);
        }
        if (rectangle4 != null) {
            ((Rectangle)object).add(rectangle4);
        }
        return object;
    }

    private LinkedList<Node> getNodesToRelocate(Rectangle rectangle, boolean bl) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (Node node : this.nodeList) {
            if (!rectangle.contains(new Point((int)node.x, (int)node.y))) continue;
            linkedList.add(node);
        }
        return linkedList;
    }

    protected Rectangle updateAffectedLinks(Rectangle rectangle) {
        if (rectangle == null) {
            return null;
        }
        Rectangle rectangle2 = null;
        for (Link link : this.linkList) {
            if (!link.intersects(rectangle)) continue;
            if (rectangle2 == null) {
                rectangle2 = link.getBoundingBox();
            } else {
                rectangle2.add(link.getBoundingBox());
            }
            link.computePoints();
            rectangle2.add(link.getBoundingBox());
        }
        return rectangle2;
    }

    private Rectangle delocateAffectedNodes(InstanceNode instanceNode, Rectangle rectangle, int n, int n2) {
        Rectangle rectangle2;
        LinkedList<Node> linkedList;
        Rectangle rectangle3 = null;
        boolean bl = false;
        try {
            linkedList = this.home.getAttribute("HR_OOBN_TransitiveFit");
            bl = linkedList != null && ((String)((Object)linkedList)).equals("1");
        }
        catch (ExceptionHugin exceptionHugin) {
            // empty catch block
        }
        linkedList = this.getNodesToRelocate(new Rectangle(rectangle.x, rectangle.y + rectangle.height, this.getWidth() - rectangle.x, this.getHeight() - rectangle.y), bl);
        linkedList.remove(instanceNode);
        boolean bl2 = false;
        for (Node node : linkedList) {
            rectangle2 = (Rectangle)node.getBoundingBox(false).clone();
            if (rectangle3 == null) {
                rectangle3 = rectangle2;
            } else {
                rectangle3.add(rectangle2);
            }
            try {
                node.move(0, n2);
            }
            catch (Exception exception) {
                if (!bl2) {
                    new HuginGUIError(exception);
                }
                bl2 = true;
            }
            rectangle3.add((Rectangle)node.getBoundingBox(false).clone());
        }
        linkedList = this.getNodesToRelocate(new Rectangle(rectangle.x + rectangle.width, rectangle.y, this.getWidth() - rectangle.x, this.getHeight() - rectangle.y + n2), bl);
        linkedList.remove(instanceNode);
        for (Node node : linkedList) {
            rectangle2 = (Rectangle)node.getBoundingBox(false).clone();
            if (rectangle3 == null) {
                rectangle3 = rectangle2;
            } else {
                rectangle3.add(rectangle2);
            }
            try {
                node.move(n, 0);
            }
            catch (Exception exception) {
                if (!bl2) {
                    new HuginGUIError(exception);
                }
                bl2 = true;
            }
            rectangle3.add((Rectangle)node.getBoundingBox(false).clone());
        }
        return rectangle3;
    }

    protected void collapseInstanceNode(InstanceNode instanceNode) throws ExceptionHugin {
        if (!instanceNode.isCollapsed()) {
            this.repaintRectangle(this.swapDisplayMode(instanceNode));
        }
    }

    protected void expandInstanceNode(InstanceNode instanceNode) throws ExceptionHugin {
        if (!instanceNode.isExpanded()) {
            this.repaintRectangle(this.swapDisplayMode(instanceNode));
        }
    }

    protected void collapseInstanceNodes() throws ExceptionHugin {
        Rectangle rectangle = null;
        for (Node node : this.nodeList) {
            if (!node.isInstance() || !((InstanceNode)node).isExpanded()) continue;
            if (rectangle == null) {
                rectangle = new Rectangle(this.swapDisplayMode((InstanceNode)node));
                continue;
            }
            rectangle.add(this.swapDisplayMode((InstanceNode)node));
        }
        if (rectangle != null) {
            this.repaint(rectangle);
        }
    }

    protected void expandInstanceNodes() throws ExceptionHugin {
        Rectangle rectangle = null;
        for (Node node : this.nodeList) {
            if (!node.isInstance() || !((InstanceNode)node).isCollapsed()) continue;
            if (rectangle == null) {
                rectangle = new Rectangle(this.swapDisplayMode((InstanceNode)node));
                continue;
            }
            rectangle.add(this.swapDisplayMode((InstanceNode)node));
        }
        if (rectangle != null) {
            this.repaint(rectangle);
        }
    }

    private Rectangle swapInterfaceNodes(MouseEvent mouseEvent) {
        InstanceNode instanceNode;
        Rectangle rectangle = null;
        Node node = this.whichNode(mouseEvent.getPoint());
        if (node != null && node.isInstance() && (instanceNode = (InstanceNode)node).isExpanded() && (node = instanceNode.getInterfaceNodeAt(mouseEvent.getPoint())) != null) {
            try {
                rectangle = instanceNode.moveInterfaceNode(node, mouseEvent.isShiftDown());
                boolean bl = instanceNode.isInput(node);
                String string = bl ? "HR_Input_Order" : "HR_Output_Order";
                instanceNode.getAPINode().setAttribute(string, instanceNode.getInterfaceOrdering(bl));
                this.containsUnsavedChanges(true);
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
        return rectangle;
    }

    public void swapInterfaceNodePlacement(InstanceNode instanceNode) {
        Rectangle rectangle = instanceNode.setInterfacePlacement(instanceNode.getInterfacePlacement() == InstanceNode.INTERFACE_PLACEMENT_HORIZONTAL ? InstanceNode.INTERFACE_PLACEMENT_VERTICAL : InstanceNode.INTERFACE_PLACEMENT_HORIZONTAL);
        Rectangle rectangle2 = this.updateAffectedLinks(rectangle);
        if (rectangle2 != null) {
            rectangle.add(rectangle2);
        }
        this.repaint(rectangle);
    }

    protected void graphsToUpdate(boolean bl) {
        this.graphsToUpdate = bl;
        this.updateButtonAndMenuStates();
    }

    protected boolean graphsToUpdate() {
        return this.graphsToUpdate;
    }

    protected void getTablesFrom(Domain domain) throws ExceptionHugin {
        for (COM.hugin.HAPI.Node node : domain.getNodes()) {
            COM.hugin.HAPI.Node node2;
            Object object;
            if (node instanceof COM.hugin.HAPI.ContinuousChanceNode) {
                object = (COM.hugin.HAPI.ContinuousChanceNode)node;
                node2 = (COM.hugin.HAPI.ContinuousChanceNode)((COM.hugin.HAPI.Node)object).getSource().getLast();
                node2.getTable().update(((COM.hugin.HAPI.Node)object).getTable());
                if (((COM.hugin.HAPI.ContinuousChanceNode)object).hasExperienceTable()) {
                    ((COM.hugin.HAPI.ContinuousChanceNode)node2).getExperienceTable().update(((COM.hugin.HAPI.ContinuousChanceNode)object).getExperienceTable());
                } else if (!((COM.hugin.HAPI.ContinuousChanceNode)object).hasExperienceTable() && ((COM.hugin.HAPI.ContinuousChanceNode)node2).hasExperienceTable()) {
                    ((COM.hugin.HAPI.ContinuousChanceNode)node2).getExperienceTable().delete();
                }
                this.getNode(node2).updateTable();
                continue;
            }
            if (!(node instanceof COM.hugin.HAPI.DiscreteChanceNode)) continue;
            object = node.getTable();
            node2 = (COM.hugin.HAPI.DiscreteChanceNode)node.getSource().getLast();
            node2.getTable().update((Table)object);
            if (((COM.hugin.HAPI.DiscreteChanceNode)node).hasExperienceTable()) {
                object = ((COM.hugin.HAPI.DiscreteChanceNode)node).getExperienceTable();
                ((COM.hugin.HAPI.DiscreteChanceNode)node2).getExperienceTable().update((Table)object);
            }
            this.getNode(node2).updateTable();
        }
    }

    protected void createGroup(int n, String string, int n2) {
        try {
            String string2 = this.getHome().getAttribute("HR_Groups_IDs");
            if (string2 == null) {
                string2 = "";
            }
            this.getHome().setAttribute("HR_Groups_IDs", string2 + "," + n);
            this.getHome().setAttribute("HR_Group_" + n + "_Name", string);
            this.getHome().setAttribute("HR_Group_" + n + "_Color", "" + n2);
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    private String colorString(int n) {
        return n < 10 ? "0" + n : "" + n;
    }

    protected void writeStatus(String string) {
        Hugin.mainFrame.statusBar.write(string);
    }

    protected void writeErrorStatus(String string) {
        this.writeStatus(string);
        HuginGUIUtils.beep();
    }

    protected void clearStatus() {
        if (this.guiFrame != null) {
            this.guiFrame.statusBar.clear();
        }
    }

    protected long getModelSize() {
        return this.getCPTSize(this.nodeList);
    }

    private long getCPTSizeForSelectedNodes() {
        return this.getCPTSize(this.selectedNodes);
    }

    private long getCPTSize(AbstractList<Node> abstractList) {
        long l = 0L;
        try {
            for (Node node : abstractList) {
                if (node instanceof DiscreteDecisionNode) continue;
                if (node instanceof InstanceNode) {
                    HuginProjectFrame huginProjectFrame = HuginGUIFrame.getProjectFrame(((InstanceNode)node).instanceOf.getName());
                    l += huginProjectFrame.getNetworkPanel().getModelSize();
                    continue;
                }
                l += (long)node.numberOfStates() * node.numberOfParentStates();
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            return 0L;
        }
        return l;
    }

    protected void setNormalMode() {
        this.special_mode = 0;
        Rectangle rectangle = null;
        for (Node node : this.nodeList) {
            node.setNormalMode();
            if (rectangle == null) {
                rectangle = node.getBoundingBox(false);
                continue;
            }
            rectangle.add(node.getBoundingBox(false));
        }
        if (rectangle != null) {
            this.repaintRectangle(rectangle);
        }
    }

    protected Rectangle setNodeRelationMode() {
        this.special_mode = 2;
        Rectangle rectangle = null;
        for (Node node : this.nodeList) {
            node.setEnabled(false);
            if (rectangle == null) {
                rectangle = node.getBoundingBox(false);
                continue;
            }
            rectangle.add(node.getBoundingBox(false));
        }
        return rectangle;
    }

    protected void setDSepMode(boolean bl) throws ExceptionHugin {
        this.setDSepMode(bl, null);
    }

    protected void setDSepMode(boolean bl, boolean[] blArray) throws ExceptionHugin {
        this.setNormalMode();
        this.special_mode = 1;
        Rectangle rectangle = null;
        for (Node node : this.selectedNodes) {
            if (node instanceof InstanceNode) continue;
            for (Node node2 : this.nodeList) {
                if (node2 instanceof InstanceNode || node2 == node || blArray != null && !blArray[node2.getGroupIndex() + 1]) continue;
                boolean bl2 = this.projectFrame.beliefBars.isSeparated(node.getAPINode(), node2.getAPINode());
                if ((!bl || !bl2) && (bl || bl2)) continue;
                node2.setDSepMode(bl);
                if (rectangle == null) {
                    rectangle = node2.getBoundingBox(false);
                    continue;
                }
                rectangle.add(node2.getBoundingBox(false));
            }
        }
        this.repaintRectangle(rectangle);
    }

    protected void setDSepMode() throws ExceptionHugin {
        this.setNormalMode();
        Rectangle rectangle = null;
        Node node = DSeparationDialog.getSourceNode(this);
        ListOfNodes listOfNodes = DSeparationDialog.getTargetNodes(this);
        DSeparationDialog.NodeGroups nodeGroups = DSeparationDialog.getEvidenceNodes(this, this.projectFrame.getBeliefBarPanel());
        LinkedList<Node> linkedList = nodeGroups.getGuiNodes();
        NodeList nodeList = nodeGroups.getApiNodes();
        if (node == null) {
            if (this.selectedNodes.size() == 0) {
                new HuginGUIError(HuginGUIConstants.get("str_unable_to_perform_d_separation_no_source_node_available"));
                return;
            }
            node = (Node)this.selectedNodes.getFirst();
        }
        if (listOfNodes == null) {
            listOfNodes = this.nodeList;
        }
        if (!(node instanceof InstanceNode)) {
            this.special_mode = 1;
            for (Node node2 : this.nodeList) {
                node2.setEnabled(false);
                if (rectangle == null) {
                    rectangle = node2.getBoundingBox(false);
                    continue;
                }
                rectangle.add(node2.getBoundingBox(false));
            }
            node.setEnabled(true);
            this.selectedNodes.add(node);
            for (Node node2 : listOfNodes) {
                if (node2 instanceof InstanceNode || node2 == node) continue;
                boolean bl = false;
                if (!this.projectFrame.getNetworkPanel().isInEditMode()) {
                    NodeList nodeList2 = new NodeList();
                    BeliefBarPanel beliefBarPanel = this.projectFrame.getBeliefBarPanel();
                    ListIterator listIterator = linkedList.listIterator();
                    while (listIterator.hasNext()) {
                        COM.hugin.HAPI.Node node3 = beliefBarPanel.getDomainNodeFor(((Node)listIterator.next()).getAPINode());
                        if (nodeList2.contains(node3)) continue;
                        nodeList2.add(node3);
                    }
                    bl = this.projectFrame.beliefBars.isSeparated(node.getAPINode(), node2.getAPINode(), nodeList2);
                } else {
                    bl = this.projectFrame.getClassInfo().getDomain().areNodesSeparated(node.getAPINode(), node2.getAPINode(), nodeList);
                }
                node2.setDSeparated(bl, false);
                if (rectangle == null) {
                    rectangle = node2.getBoundingBox(false);
                    continue;
                }
                rectangle.add(node2.getBoundingBox(false));
            }
            for (Node node2 : linkedList) {
                node2.setDSeparated(true, true);
            }
        }
        this.repaintRectangle(rectangle);
    }

    public void updateBackpointers() {
        try {
            for (Node node : this.nodeList) {
                node.getAPINode().setGUINode(node);
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    protected void setMinimizeLimidMode() {
        if (this.selectedNodes.size() != 1) {
            return;
        }
        Node node = (Node)this.selectedNodes.get(0);
        if (!(node instanceof DiscreteDecisionNode)) {
            return;
        }
        this.special_mode = 4;
        try {
            COM.hugin.HAPI.DiscreteDecisionNode discreteDecisionNode = (COM.hugin.HAPI.DiscreteDecisionNode)node.getAPINode();
            boolean bl = discreteDecisionNode.getHome() instanceof Class;
            if (bl) {
                discreteDecisionNode = (COM.hugin.HAPI.DiscreteDecisionNode)this.projectFrame.getBeliefBarPanel().getDomainNodeFor(discreteDecisionNode);
            }
            NodeList nodeList = discreteDecisionNode.getParents();
            NodeList nodeList2 = discreteDecisionNode.getRequisiteParents();
            for (COM.hugin.HAPI.Node node2 : nodeList) {
                ((Node)this.getNetworkPanelNodeFor(node2).getGUINode()).setMinimizeLimidMode(nodeList2.contains(node2));
            }
            node.setMinimizeLimidMode(true);
            this.repaint();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    public COM.hugin.HAPI.Node getNetworkPanelNodeFor(COM.hugin.HAPI.Node node) throws ExceptionHugin {
        if (node.getHome() == this.home) {
            return node;
        }
        return this.home.getNodeByName(node.getName());
    }

    protected void setMarkovBlanketMode() {
        if (this.special_mode == 1 && this.selectedNodes.size() > 0 || this.selectedNodes.size() == 1) {
            this.setNormalMode();
            this.special_mode = 3;
            try {
                Node node = (Node)this.selectedNodes.get(0);
                COM.hugin.HAPI.Node node2 = node.getAPINode();
                HashSet<COM.hugin.HAPI.Node> hashSet = new HashSet<COM.hugin.HAPI.Node>();
                hashSet.addAll(node2.getParents());
                hashSet.add(node2);
                for (COM.hugin.HAPI.Node node3 : node2.getChildren()) {
                    hashSet.add(node3);
                    hashSet.addAll(node3.getParents());
                }
                for (COM.hugin.HAPI.Node node3 : hashSet) {
                    Node node4 = (Node)node3.getGUINode();
                    node4.setMarkovBlanketMode(true);
                }
                this.repaint();
            }
            catch (ExceptionHugin exceptionHugin) {
                new HuginGUIError(exceptionHugin);
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
    }

    protected void receiveKeyEvent(KeyEvent keyEvent) {
        double d;
        int n = keyEvent.getKeyCode();
        if (n == 40 || n == 98) {
            if (keyEvent.isShiftDown()) {
                d = this.scaleMonitors(0.9);
                if (d > 0.0) {
                    this.writeStatus(HuginGUIConstants.get("str_monitors_scaled_to_") + (int)(100.0 * d) + "%");
                } else if (d < 0.0) {
                    this.writeStatus("Unable to scale monitor (1 <= scale factor <= 10000)");
                }
            } else if (keyEvent.isControlDown()) {
                d = this.zoom(0.9);
                if (d > 0.0) {
                    this.writeStatus(HuginGUIConstants.get("str_scale_factor_set_to_") + (int)(100.0 * d) + "%");
                } else {
                    this.writeStatus("Unable to scale network (1 <= scale factor <= 10000)");
                }
            }
        }
        if (n == 38 || n == 104) {
            if (keyEvent.isShiftDown()) {
                d = this.scaleMonitors(1.1111111111111112);
                if (d > 0.0) {
                    this.writeStatus(HuginGUIConstants.get("str_monitors_scaled_to_") + (int)(100.0 * d) + "%");
                } else if (d < 0.0) {
                    this.writeStatus("Unable to scale monitor (1 <= scale factor <= 10000)");
                }
            } else if (keyEvent.isControlDown()) {
                d = this.zoom(1.1111111111111112);
                if (d > 0.0) {
                    this.writeStatus(HuginGUIConstants.get("str_scale_factor_set_to_") + (int)(100.0 * d) + "%");
                } else {
                    this.writeStatus("Unable to scale network (1 <= scale factor <= 10000)");
                }
            }
        }
        switch (n) {
            case 36: {
                double d2 = 0.0;
                if (keyEvent.isControlDown()) {
                    d2 = 1.0;
                    this.setScaleFactor(1.0);
                }
                if (keyEvent.isShiftDown()) {
                    d2 = ZoomingPane.computeFitFactor(this);
                    this.setScaleFactor(d2);
                }
                if (!(d2 > 0.0)) break;
                this.writeStatus(HuginGUIConstants.get("str_scale_factor_set_to_") + (int)Math.rint(100.0 * d2) + "%");
                break;
            }
            case 46: {
                if (!keyEvent.isControlDown()) break;
                this.showGrid(!this.showGrid());
                String string = this.showGrid() ? HuginGUIConstants.get("str_on") : HuginGUIConstants.get("str_off");
                this.writeStatus(HuginGUIConstants.get("str_grid_") + string);
                break;
            }
            case 44: {
                if (keyEvent.isControlDown()) {
                    this.snapToGrid(!this.snapToGrid());
                    String string = this.snapToGrid() ? HuginGUIConstants.get("str_on") : HuginGUIConstants.get("str_off");
                    this.writeStatus(HuginGUIConstants.get("str_snap_to_grid_") + string);
                }
                if (keyEvent.isShiftDown() && this.snapSelectedNodesToGrid()) {
                    this.writeStatus(HuginGUIConstants.get("str_selected_nodes_snapped_to_grid"));
                }
                if (!keyEvent.isAltDown() || !this.snapMonitorsToNodes()) break;
                this.writeStatus(HuginGUIConstants.get("str_monitors_snapped_to_selected_nodes"));
                break;
            }
            case 35: {
                if (!keyEvent.isShiftDown()) break;
                this.setScaleFactor((double)ZoomingPane.computeSelectedFitZoom(this) / 100.0);
                this.scrollToSelected();
                this.writeStatus(HuginGUIConstants.get("str_zoomed_to_selected_nodes"));
                break;
            }
            case 70: {
                if (!keyEvent.isControlDown() || !keyEvent.isShiftDown()) break;
                try {
                    HuginProjectFrame.flipNet(this.home);
                    this.rereadNodePositions();
                }
                catch (ExceptionHugin exceptionHugin) {
                    new HuginGUIError(exceptionHugin);
                }
                this.repaint();
                break;
            }
        }
    }

    protected void settingsImported() throws ExceptionHugin {
        this.rereadNodePositions();
        this.readAttributes();
        this.repaintRectangle(new Rectangle(0, 0, this.graphicsDimension.width, this.graphicsDimension.height), new Point(0, 0));
    }

    protected void rereadNodePositions() throws ExceptionHugin {
        for (Node node : this.nodeList) {
            node.rereadPosition();
        }
        this.relocateLinks();
    }

    protected void nodeChangedSize(Node node) {
        Rectangle rectangle = node.getBoundingBox(false);
        for (Link link : this.linkList) {
            if (link.parent != node && link.child != node && (link.parent == null || link.parent.host != node) && (link.child == null || link.child.host != node)) continue;
            rectangle.add(link.getBoundingBox());
            link.computePoints();
            rectangle.add(link.getBoundingBox());
        }
        this.repaint(rectangle);
    }

    protected void removeInstancesFromBuffer(NetworkModel networkModel) throws ExceptionHugin {
        Cloneable cloneable;
        if (!(networkModel instanceof Class)) {
            return;
        }
        ListIterator listIterator = nodeBuffer.listIterator();
        while (listIterator.hasNext()) {
            cloneable = (Node)listIterator.next();
            if (!(cloneable instanceof InstanceNode) || ((InstanceNode)cloneable).instanceOf != networkModel) continue;
            listIterator.remove();
        }
        listIterator = linkBuffer.listIterator();
        while (listIterator.hasNext()) {
            cloneable = (Link)listIterator.next();
            if (((Link)cloneable).parent instanceof InstanceNode && ((InstanceNode)((Link)cloneable).parent).instanceOf == networkModel) {
                listIterator.remove();
            }
            if (!(((Link)cloneable).child instanceof InstanceNode) || ((InstanceNode)((Link)cloneable).child).instanceOf != networkModel) continue;
            listIterator.remove();
        }
    }

    protected void updateMinimizedDomain(Domain domain) throws ExceptionHugin {
        if (this.getHomeClass() != null) {
            this.updateLinksFromDomain(domain);
        }
        Rectangle rectangle = null;
        ListIterator listIterator = this.linkList.listIterator();
        while (listIterator.hasNext()) {
            Link link = (Link)listIterator.next();
            if (!link.hasBeenRemoved()) continue;
            if (rectangle == null) {
                rectangle = link.kill(false);
            } else {
                rectangle.add(link.kill(false));
            }
            listIterator.remove();
            this.containsUnsavedChanges(true);
            this.containsUncompiledChanges(true);
        }
        if (rectangle != null) {
            this.repaint(rectangle);
        }
    }

    private void updateLinksFromDomain(Domain domain) throws ExceptionHugin {
        NodeList nodeList = new NodeList();
        for (COM.hugin.HAPI.Node node : domain.getNodes()) {
            COM.hugin.HAPI.Node node2 = (COM.hugin.HAPI.Node)node.getSource().getLast();
            if (node2.getHome() != this.getHomeClass()) continue;
            nodeList.clear();
            for (COM.hugin.HAPI.Node node3 : node.getParents()) {
                NodeList nodeList2 = node3.getSource();
                COM.hugin.HAPI.Node node4 = (COM.hugin.HAPI.Node)nodeList2.getLast();
                if (node4.getHomeClass() != this.getHomeClass()) {
                    COM.hugin.HAPI.InstanceNode instanceNode = (COM.hugin.HAPI.InstanceNode)nodeList2.get(nodeList2.size() - 2);
                    node4 = instanceNode.getOutput(node4);
                }
                nodeList.add(node4);
            }
            for (COM.hugin.HAPI.Node node3 : node2.getParents()) {
                if (nodeList.contains(node3)) continue;
                node2.removeParent(node3);
            }
        }
    }

    public void updateAbsorbedNodeLinks(LinkedList linkedList, Node node) throws ExceptionHugin {
        this.updateAbsorbedNodeLinks(linkedList, node, true);
    }

    protected void updateAbsorbedNodeLinks(LinkedList linkedList, Node node, boolean bl) throws ExceptionHugin {
        Link link;
        this.containsUnsavedChanges(true);
        this.containsUncompiledChanges(true);
        Rectangle rectangle = null;
        Object object = linkedList.listIterator();
        while (object.hasNext()) {
            link = (Link)object.next();
            if (!this.linkList.contains(link)) {
                this.linkList.add(link);
            }
            link.child.disposeTable();
            link.child.updateTable(this.showTables);
            link.parent.disposeTable();
            link.parent.updateTable(this.showTables);
            if (rectangle == null) {
                rectangle = link.getBoundingBox();
                continue;
            }
            rectangle.add(link.getBoundingBox());
        }
        if (bl) {
            object = node.getAllLinks();
            ListIterator listIterator = ((AbstractList)object).listIterator();
            while (listIterator.hasNext()) {
                link = (Link)listIterator.next();
                this.linkList.remove(link);
                if (rectangle == null) {
                    rectangle = link.kill();
                    continue;
                }
                rectangle.add(link.kill());
            }
        }
        this.repaintRectangle(rectangle);
    }

    protected void setAlreadyCheckedForOOBNTrouble(boolean bl) {
        this.alreadyCheckedForOOBNTrouble = bl;
    }

    protected boolean checkForOOBNTrouble() throws ExceptionHugin {
        if (this.alreadyCheckedForOOBNTrouble || !Hugin.mainFrame.preferences.display_oobn_warnings) {
            return false;
        }
        String string = this.getHome().getAttribute("HR_Instantiated_in");
        if (string == null || string.length() == 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() < 2) continue;
            string2 = string2.substring(1, string2.length() - 1);
            if (this.getHomeClass().getClassCollection().getClassByName(string2) == null) {
                linkedList.add(string2);
                continue;
            }
            linkedList2.add(string2);
        }
        boolean bl = false;
        if (linkedList.size() > 0) {
            Iterator iterator = new TroublePanel(linkedList);
            ((Dialog)((Object)iterator)).setVisible(true);
            if (((TroublePanel)((Object)iterator)).abortOperation()) {
                bl = true;
            }
        }
        string = "";
        for (String string3 : linkedList2) {
            string = string + "\"" + string3 + "\", ";
        }
        for (String string3 : linkedList) {
            string = string + "\"" + string3 + "\", ";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 2);
        }
        if (string.length() == 0) {
            string = null;
        }
        this.getHome().setAttribute("HR_Instantiated_in", string);
        return bl;
    }

    protected void changeLink(Link link, Node node) {
        Node node2 = link.getChild();
        Node node3 = link.getParent();
        try {
            node2.getAPINode().switchParent(node3.getAPINode(), node.getAPINode());
            this.linkList.remove(link);
            Link link2 = new Link(node, node2, this.getScaleFactor());
            this.linkList.add(link2);
            this.deselectLinks();
            link2.select();
            this.selectedLinks.add(link2);
            node2.updateTable();
            this.containsUnsavedChanges(true);
            this.updateButtonAndMenuStates();
            this.repaint();
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
    }

    public void respawnCDVT() {
        try {
            Iterator iterator = this.linkList.listIterator();
            while (iterator.hasNext()) {
                if (!(iterator.next() instanceof CDVTLink)) continue;
                iterator.remove();
            }
            for (Node node : this.nodeList) {
                String string = node.getAPINode().getAttribute("HR_CDVT_parent");
                if (string == null) continue;
                this.linkList.add(new CDVTLink(this.getNode(string), node));
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
    }

    public boolean hasCDVT() {
        for (Link link : this.linkList) {
            if (!(link instanceof CDVTLink)) continue;
            return true;
        }
        return false;
    }

    public boolean recursiveCDVT() {
        if (this.hasCDVT()) {
            return true;
        }
        for (Node node : this.getInstanceNodes()) {
            InstanceNode instanceNode = (InstanceNode)node;
            Class clazz = instanceNode.instanceOf;
            NetworkPanel networkPanel = HuginGUIFrame.getNetworkPanel(clazz);
            if (networkPanel == null || !networkPanel.recursiveCDVT()) continue;
            return true;
        }
        return false;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        if (this.selectionListeners == null) {
            this.selectionListeners = new LinkedList();
        }
        this.selectionListeners.add(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        if (this.selectionListeners != null) {
            this.selectionListeners.remove(selectionListener);
        }
    }

    private void fireSelectionChanged(SelectionEvent selectionEvent) {
        if (this.selectionListeners != null) {
            for (SelectionListener selectionListener : this.selectionListeners) {
                selectionListener.selectionChanged(selectionEvent);
            }
        }
    }

    static {
        NO_DESC_TEXT_COLOR = HuginGUIConstants.NO_DESCRIPTION_TEXT_COLOR;
        DESC_TEXT_COLOR = HuginGUIConstants.DESCRIPTION_TEXT_COLOR;
        DEFAULT_FONT = new Font(HuginGUIConstants.defaultFont.getName(), 0, 12);
    }

    public class CustomHTMLEditorKit
    extends HTMLEditorKit {
        public static final int JUMP = 0;
        public static final int MOVE = 1;
        LinkController myController = new LinkController();

        public void install(JEditorPane jEditorPane) {
            jEditorPane.addMouseListener(this.myController);
            jEditorPane.addMouseMotionListener(this.myController);
        }

        public class LinkController
        extends MouseInputAdapter
        implements Serializable {
            URL currentUrl = null;

            public void mousePressed(MouseEvent mouseEvent) {
                Point point;
                int n;
                JEditorPane jEditorPane;
                if (mouseEvent != null && (jEditorPane = (JEditorPane)mouseEvent.getSource()) != null && !jEditorPane.isEditable() && (n = jEditorPane.viewToModel(point = new Point(mouseEvent.getX(), mouseEvent.getY()))) >= 0) {
                    this.activateLink(n, jEditorPane, 0);
                }
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                Point point;
                int n;
                JEditorPane jEditorPane;
                if (mouseEvent != null && (jEditorPane = (JEditorPane)mouseEvent.getSource()) != null && !jEditorPane.isEditable() && (n = jEditorPane.viewToModel(point = new Point(mouseEvent.getX(), mouseEvent.getY()))) >= 0) {
                    this.activateLink(n, jEditorPane, 1);
                }
            }

            protected void activateLink(int n, JEditorPane jEditorPane, int n2) {
                Document document = jEditorPane.getDocument();
                if (document instanceof HTMLDocument) {
                    HTMLDocument hTMLDocument = (HTMLDocument)document;
                    Element element = hTMLDocument.getCharacterElement(n);
                    AttributeSet attributeSet = element.getAttributes();
                    AttributeSet attributeSet2 = (AttributeSet)attributeSet.getAttribute(HTML.Tag.A);
                    String string = attributeSet2 != null ? (String)attributeSet2.getAttribute(HTML.Attribute.HREF) : null;
                    boolean bl = false;
                    HyperlinkEvent hyperlinkEvent = null;
                    if (string != null) {
                        URL uRL;
                        try {
                            uRL = new URL(hTMLDocument.getBase(), string);
                        }
                        catch (MalformedURLException malformedURLException) {
                            uRL = null;
                        }
                        if (n2 == 1 && !uRL.equals(this.currentUrl)) {
                            hyperlinkEvent = new HyperlinkEvent(jEditorPane, HyperlinkEvent.EventType.ENTERED, uRL, string);
                            this.currentUrl = uRL;
                            NetworkPanel.this.descriptionFrame.setCursor(new Cursor(12));
                        } else if (n2 == 0) {
                            hyperlinkEvent = new HyperlinkEvent(jEditorPane, HyperlinkEvent.EventType.ACTIVATED, uRL, string);
                            bl = true;
                            NetworkPanel.this.descriptionFrame.setCursor(new Cursor(0));
                        } else {
                            return;
                        }
                        jEditorPane.fireHyperlinkUpdate(hyperlinkEvent);
                    } else if (this.currentUrl != null) {
                        bl = true;
                    }
                    if (bl) {
                        hyperlinkEvent = new HyperlinkEvent(jEditorPane, HyperlinkEvent.EventType.EXITED, this.currentUrl, null);
                        jEditorPane.fireHyperlinkUpdate(hyperlinkEvent);
                        this.currentUrl = null;
                        NetworkPanel.this.descriptionFrame.setCursor(new Cursor(0));
                    }
                }
            }
        }
    }

    public static class SelectionEvent {
        public static final int SELECTION_TYPE_CLEARED = 0;
        public static final int SELECTION_TYPE_NODE_ADDED = 1;
        public static final int SELECTION_TYPE_NODE_REMOVED = 2;
        Node source;
        int selectionType;

        public SelectionEvent(Node node, int n) {
            this.source = node;
            this.selectionType = n;
        }

        public Node getSource() {
            return this.source;
        }

        public int getType() {
            return this.selectionType;
        }
    }

    public static abstract class SelectionListener {
        public abstract void selectionChanged(SelectionEvent var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TroublePanel
    extends JDialog {
        private boolean abortOperation;
        LinkedList<String> troubles;
        UsefullList list;

        public TroublePanel(LinkedList<String> linkedList) {
            super(Hugin.mainFrame, HuginGUIConstants.get("str_oobn_problems"), true);
            this.abortOperation = true;
            this.troubles = linkedList;
            this.setContentPane(this.getContents());
            this.pack();
            this.setPreferredSize(new Dimension(300, 300));
            this.setSize(new Dimension(300, 300));
            HuginGUIUtils.centerComponent(Hugin.mainFrame, (Window)this);
        }

        private JPanel getContents() {
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout());
            this.list = new UsefullList(this.troubles.toArray(new String[this.troubles.size()]));
            this.list.setSelectionMode(0);
            jPanel2.add(this.list);
            JTextArea jTextArea = new JTextArea(8, 20);
            jTextArea.setFont(new JLabel().getFont());
            jTextArea.setLineWrap(true);
            jTextArea.setEnabled(false);
            jTextArea.setDisabledTextColor(Color.black);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setBackground(UIManager.getDefaults().getColor("Panel.background"));
            jTextArea.setText(HuginGUIConstants.get("str_oobn_warning_1"));
            jPanel2.add((Component)jTextArea, "North");
            JPanel jPanel3 = new JPanel(new VerticalFlowLayout(0));
            JButton jButton = new JButton(HuginGUIConstants.get("REMOVE_BUTTON_LABEL"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (TroublePanel.this.list.getSelectedIndex() < 0) {
                        return;
                    }
                    TroublePanel.this.troubles.remove(TroublePanel.this.list.getSelectedIndex());
                    TroublePanel.this.list.removeElementAt(TroublePanel.this.list.getSelectedIndex());
                    if (TroublePanel.this.list.getModel().getSize() == 0) {
                        TroublePanel.this.abortOperation = false;
                        TroublePanel.this.dispose();
                    }
                }
            });
            jPanel3.add(jButton);
            jPanel2.add((Component)jPanel3, "East");
            jPanel.add(jPanel2);
            JPanel jPanel4 = new JPanel(new FlowLayout(1));
            JButton jButton2 = new JButton(HuginGUIConstants.get("str_abort"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TroublePanel.this.dispose();
                }
            });
            JButton jButton3 = new JButton(HuginGUIConstants.get("str_proceed"));
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TroublePanel.this.abortOperation = false;
                    TroublePanel.this.dispose();
                }
            });
            jPanel4.add(jButton2);
            jPanel4.add(jButton3);
            jPanel.add((Component)jPanel4, "South");
            return jPanel;
        }

        public boolean abortOperation() {
            return this.abortOperation;
        }

        public LinkedList<String> getClassList() {
            return this.troubles;
        }
    }

    private class DescriptionFrame
    extends JInternalFrame {
        PastingTextArea textArea;
        JEditorPane htmlTextArea;
        int textSize = 0;
        JScrollPane textScroller;
        int mouseX;
        int mouseY;
        DescriptionFrame frame = this;
        boolean htmlEnabled = false;
        boolean initialized = false;

        public DescriptionFrame() {
            ((BasicInternalFrameUI)this.getUI()).setNorthPane(null);
            this.setResizable(true);
            this.htmlTextArea = new JEditorPane();
            this.htmlTextArea.setEditable(false);
            this.htmlTextArea.setEnabled(true);
            this.htmlTextArea.setContentType("text/html");
            CustomHTMLEditorKit customHTMLEditorKit = new CustomHTMLEditorKit();
            customHTMLEditorKit.install(this.htmlTextArea);
            this.htmlTextArea.setEditorKitForContentType("text/html", new CustomHTMLEditorKit());
            this.htmlTextArea.setFont(HuginGUIConstants.DESCRIPTION_FRAME_FONT);
            this.htmlTextArea.setBackground(HuginGUIConstants.DESCRIPTION_FRAME_COLOR);
            this.htmlTextArea.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    DescriptionFrame.this.mouseX = mouseEvent.getX();
                    DescriptionFrame.this.mouseY = mouseEvent.getY();
                }
            });
            this.htmlTextArea.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseDragged(MouseEvent mouseEvent) {
                    DescriptionFrame.this.frame.setLocation(DescriptionFrame.this.getX() + (mouseEvent.getX() - DescriptionFrame.this.mouseX), DescriptionFrame.this.getY() + (mouseEvent.getY() - DescriptionFrame.this.mouseY));
                }
            });
            this.htmlTextArea.addHyperlinkListener(new HyperlinkEventHandler.DescHyperlinkListener());
            this.textArea = new PastingTextArea();
            this.textArea.setEditable(false);
            this.textArea.setEnabled(false);
            this.textArea.setFont(HuginGUIConstants.DESCRIPTION_FRAME_FONT);
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
            this.textArea.setBackground(HuginGUIConstants.DESCRIPTION_FRAME_COLOR);
            this.textArea.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    DescriptionFrame.this.mouseX = mouseEvent.getX();
                    DescriptionFrame.this.mouseY = mouseEvent.getY();
                }
            });
            this.textArea.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseDragged(MouseEvent mouseEvent) {
                    DescriptionFrame.this.frame.setLocation(DescriptionFrame.this.getX() + (mouseEvent.getX() - DescriptionFrame.this.mouseX), DescriptionFrame.this.getY() + (mouseEvent.getY() - DescriptionFrame.this.mouseY));
                }
            });
            this.initialize(null);
            this.pack();
        }

        public void initialize(NetworkModel networkModel) {
            try {
                if (networkModel != null) {
                    this.initialized = true;
                    String string = NetworkPanel.this.getHome().getAttribute("HR_Html_Desc");
                    if (string != null) {
                        this.htmlEnabled = string.equals("1");
                    }
                }
            }
            catch (ExceptionHugin exceptionHugin) {
                // empty catch block
            }
            if (this.getContentPane().getComponentCount() != 0) {
                this.getContentPane().remove(this.textScroller);
            }
            this.textScroller = this.htmlEnabled ? new JScrollPane(this.htmlTextArea) : new JScrollPane(this.textArea);
            this.textScroller.validate();
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.textScroller, "Center");
            this.getContentPane().validate();
        }

        public void setText(String string, String string2, Color color, NetworkModel networkModel) {
            this.initialize(networkModel);
            this.textSize = string.length();
            if (!this.htmlEnabled) {
                this.textArea.replaceRange(string, 0, this.textArea.getText().length());
                this.textArea.setDisabledTextColor(color);
            } else {
                if (string2 == null) {
                    string2 = this.addBreaks(string);
                }
                this.htmlTextArea.setText(string2);
                this.htmlTextArea.setDisabledTextColor(color);
            }
        }

        private String addBreaks(String string) {
            return string.replaceAll("\\\n", "\\<br\\>");
        }

        public Font getTextFont() {
            return this.htmlEnabled ? this.textArea.getFont() : this.htmlTextArea.getFont();
        }

        public void paintComponent(Graphics graphics) {
            ((Graphics2D)graphics).setStroke(HStroke.BASIC_STROKE);
            super.paintComponent(graphics);
        }

        public void setSelected(boolean bl) {
            this.toFront();
        }
    }

    private class ExceptionInconsistentNodes
    extends Exception {
        private ExceptionInconsistentNodes() {
        }
    }

    protected class SelectRegion
    extends Rectangle {
        protected Rectangle previous;

        public SelectRegion(int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
            this.previous = new Rectangle(n, n2, n3, n4);
        }

        public void paint(Graphics2D graphics2D) {
            graphics2D.setPaint(Color.black);
            graphics2D.setStroke(HStroke.DASH_STROKE);
            graphics2D.drawRect(this.x, this.y, this.width, this.height);
        }

        public Rectangle getBoundingBox() {
            return new Rectangle(this.x, this.y, this.width + 1, this.height + 1);
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            this.previous.setBounds(this.getBoundingBox());
            super.setBounds(n, n2, n3, n4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ListOfSelectedNodes
    extends LinkedList<Node> {
        @Override
        public boolean add(Node node) {
            return this.add(node, Hugin.mainFrame.preferences.node_table_connection_mode == 0);
        }

        public boolean add(Node node, boolean bl) {
            NetworkPanel.this.nodeList.remove(node);
            if (node == null) {
                return false;
            }
            NetworkPanel.this.nodeList.addLast(node);
            try {
                node.select(bl);
                NetworkPanel.this.fireSelectionChanged(new SelectionEvent(node, 1));
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            this.updateResizingAllowed(node);
            boolean bl2 = super.add(node);
            if (NetworkPanel.this.projectFrame != null) {
                NetworkPanel.this.projectFrame.showInitialTableTip();
            }
            return bl2;
        }

        public boolean remove(Node node) {
            NetworkPanel.this.nodeList.remove(node);
            if (node == null) {
                return false;
            }
            NetworkPanel.this.nodeList.addFirst(node);
            node.deselect();
            NetworkPanel.this.fireSelectionChanged(new SelectionEvent(node, 2));
            boolean bl = super.remove(node);
            if (this.size() == 1) {
                ((Node)this.get(0)).setResizeAllowed(NetworkPanel.this.projectFrame != null && !NetworkPanel.this.projectFrame.runMode);
            }
            return bl;
        }

        @Override
        public boolean addAll(AbstractList<Node> abstractList) {
            boolean bl;
            boolean bl2 = bl = !NetworkPanel.this.inEditMode && NetworkPanel.this.nodeList.size() > 100;
            if (bl) {
                NetworkPanel.this.setCursor(NetworkPanel.this.hourglassCursor);
            }
            try {
                for (Node node : abstractList) {
                    node.select(Hugin.mainFrame.preferences.node_table_connection_mode == 0);
                    NetworkPanel.this.fireSelectionChanged(new SelectionEvent(node, 1));
                    node.setResizeAllowed(abstractList.size() == 1 && this.size() == 0 && NetworkPanel.this.projectFrame != null && !NetworkPanel.this.projectFrame.runMode);
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            if (bl) {
                NetworkPanel.this.setCursor(NetworkPanel.this.defaultCursor);
            }
            boolean bl3 = super.addAll(abstractList);
            if (NetworkPanel.this.projectFrame != null) {
                NetworkPanel.this.projectFrame.showInitialTableTip();
            }
            return bl3;
        }

        public boolean passiveAddAll(Collection<Node> collection) {
            boolean bl;
            boolean bl2 = bl = !NetworkPanel.this.inEditMode && NetworkPanel.this.nodeList.size() > 100;
            if (bl) {
                NetworkPanel.this.setCursor(NetworkPanel.this.hourglassCursor);
            }
            for (Node node : collection) {
                node.passiveSelect();
                NetworkPanel.this.fireSelectionChanged(new SelectionEvent(node, 1));
                node.setResizeAllowed(collection.size() == 1 && this.size() == 0 && NetworkPanel.this.projectFrame != null && !NetworkPanel.this.projectFrame.runMode);
            }
            if (bl) {
                NetworkPanel.this.setCursor(NetworkPanel.this.defaultCursor);
            }
            return super.addAll(collection);
        }

        @Override
        public void clear() {
            boolean bl;
            boolean bl2 = bl = !NetworkPanel.this.inEditMode && NetworkPanel.this.nodeList.size() > 100;
            if (bl) {
                NetworkPanel.this.setCursor(NetworkPanel.this.hourglassCursor);
            }
            for (Node node : this) {
                node.deselect();
            }
            if (bl) {
                NetworkPanel.this.setCursor(NetworkPanel.this.defaultCursor);
            }
            NetworkPanel.this.fireSelectionChanged(new SelectionEvent(null, 0));
            super.clear();
        }

        public void passiveClear() {
            boolean bl;
            boolean bl2 = bl = !NetworkPanel.this.inEditMode && NetworkPanel.this.nodeList.size() > 100;
            if (bl) {
                NetworkPanel.this.setCursor(NetworkPanel.this.hourglassCursor);
            }
            for (Node node : this) {
                node.passiveDeselect();
            }
            if (bl) {
                NetworkPanel.this.setCursor(NetworkPanel.this.defaultCursor);
            }
            NetworkPanel.this.fireSelectionChanged(new SelectionEvent(null, 0));
            super.clear();
        }

        private void updateResizingAllowed(Node node) {
            boolean bl = this.size() == 0 && NetworkPanel.this.projectFrame != null && !NetworkPanel.this.projectFrame.runMode;
            for (Node node2 : this) {
                node2.setResizeAllowed(bl);
            }
            if (node != null) {
                node.setResizeAllowed(bl);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ListOfNodes
    extends LinkedList<Node> {
        public void selectAll() {
            if (NetworkPanel.this.inEditMode && NetworkPanel.this.showTables && !NetworkPanel.this.confirmNodeSelection(this.size(), NetworkPanel.this.selectedNodes.size() > 0)) {
                return;
            }
            NetworkPanel.this.selectedNodes.clear();
            NetworkPanel.this.selectedNodes.addAll(this);
        }

        public void passiveSelectAll() {
            if (NetworkPanel.this.inEditMode && NetworkPanel.this.showTables && !NetworkPanel.this.confirmNodeSelection(this.size(), NetworkPanel.this.selectedNodes.size() > 0)) {
                return;
            }
            NetworkPanel.this.selectedNodes.clear();
            NetworkPanel.this.selectedNodes.passiveAddAll(this);
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof ListOfNodes)) {
                return false;
            }
            if (((ListOfNodes)object).size() != this.size()) {
                return false;
            }
            for (Node node : (ListOfNodes)object) {
                if (this.contains(node)) continue;
                return false;
            }
            return true;
        }
    }
}

