/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.BooleanDCNode;
import COM.hugin.HAPI.BooleanDDNode;
import COM.hugin.HAPI.Class;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionInvalidExpression;
import COM.hugin.HAPI.ExceptionObjectNotAlive;
import COM.hugin.HAPI.ExceptionTwice;
import COM.hugin.HAPI.ExceptionUsage;
import COM.hugin.HAPI.Expression;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HAPI.IntervalDDNode;
import COM.hugin.HAPI.Model;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.NumberedDCNode;
import COM.hugin.HAPI.NumberedDDNode;
import COM.hugin.HGUI.BeliefBarPanel;
import COM.hugin.HGUI.BeliefMonitor;
import COM.hugin.HGUI.CDVTLink;
import COM.hugin.HGUI.ColorChart;
import COM.hugin.HGUI.ContinuousChanceNode;
import COM.hugin.HGUI.DiscreteChanceNode;
import COM.hugin.HGUI.DiscreteDecisionNode;
import COM.hugin.HGUI.DiscreteNode;
import COM.hugin.HGUI.DomainAttributes;
import COM.hugin.HGUI.FunctionNode;
import COM.hugin.HGUI.GraphicTable;
import COM.hugin.HGUI.HStroke;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.IllegalCloneException;
import COM.hugin.HGUI.InstanceNode;
import COM.hugin.HGUI.Link;
import COM.hugin.HGUI.NetworkNamingPane;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.NodeGroup;
import COM.hugin.HGUI.NodeInformation;
import COM.hugin.HGUI.NodeTableFrame;
import COM.hugin.HGUI.RunModePoliciesWindow;
import COM.hugin.HGUI.SensitivityNetworkPanel;
import COM.hugin.HGUI.UtilityNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node
implements Cloneable,
Comparable<Node> {
    protected NetworkPanel panel;
    protected NetworkModel home;
    protected static final int DISCRETE_CHANCE = 1;
    protected static final int CONTINUOUS_CHANCE = 2;
    protected static final int UTILITY = 3;
    protected static final int DISCRETE_DECISION = 4;
    protected static final int INSTANCE = 5;
    protected static final int FUNCTION = 6;
    protected String name = null;
    protected String label = null;
    protected boolean titleIsWide = false;
    protected Color textColor = Color.black;
    protected int type;
    private boolean resizable = true;
    private boolean resizeAllowed = false;
    private double maxSensitivityValue = 0.0;
    private double minSensitivityValue = 0.0;
    private double avgSensitivityValue = 0.0;
    private boolean visible = true;
    private boolean separatedFromHypothesis = false;
    private boolean barrenWrtHypothesis = false;
    protected Color posSensitivityColor = Color.blue;
    protected Color negSensitivityColor = Color.red;
    protected Color avgSensitivityColor = Color.white;
    private static final Dimension MIN_SIZE = new Dimension(10, 10);
    private static final Dimension MAX_SIZE = new Dimension(300, 300);
    private COM.hugin.HAPI.Node apiNode = null;
    String colorAttribute;
    protected BoundingBox boundingBox;
    protected double x;
    protected double y;
    protected double width;
    protected double height;
    protected double scaleFactor;
    protected boolean drawText;
    protected int minHeightForText = 10;
    protected int minWidthForText = 10;
    private static final int TEXT_WIDTH_MARGIN = 10;
    protected Point2D.Double center;
    protected Shape shape = null;
    protected Color fillColor;
    protected Color actualFillColor;
    protected Color interfaceColor;
    protected Stroke stroke;
    protected Stroke interfaceStroke = HStroke.INTERFACE_STROKE;
    protected int group = 0;
    protected static final int ORDINARY = 0;
    protected static final int INPUT = 1;
    protected static final int OUTPUT = 2;
    private int interfaceType = 0;
    protected Font font;
    protected boolean selected = false;
    protected boolean isGhost = false;
    protected Node cloneOf = null;
    protected InstanceNode host = null;
    protected Node master = null;
    protected BeliefMonitor monitor = null;
    private Point monitorLocation = null;
    private Point2D.Double monitorCenter = null;
    private static final int MAX_MONITOR_STICKING_DISTANCE = 10;
    protected RunModePoliciesWindow policiesWindow = null;
    private NodeTableFrame table;
    private ColorChart visualCPT = new GraphicTable(this);
    private NodeInformation savedNodeInfo = null;
    private boolean marked = false;
    private ArrayList<String> tempExpressions = null;
    public static final int CORNER_UPPER_LEFT = 0;
    public static final int CORNER_LOWER_LEFT = 1;
    public static final int CORNER_UPPER_RIGHT = 2;
    public static final int CORNER_LOWER_RIGHT = 3;
    public static final int CORNER_NO_CORNER = -1;
    private static final int CORNER_DISTANCE = 3;
    boolean firstCornerPoint = true;
    int tempCornerPointWidth;
    int tempCornerPointHeight;
    private static Point2D.Float nodePosition = new Point2D.Float();
    protected static final int CPT_MANUAL = 0;
    protected static final int CPT_EXPRESSION = 1;
    protected static final int NORMAL_MODE = 0;
    protected static final int DSEPARATION_MODE = 1;
    protected static final int MARKOV_BLANKET_MODE = 2;
    protected static final int MINIMZE_LIMID_REQUISITE_MODE = 3;
    protected static final int MINIMZE_LIMID_NOT_REQUISITE_MODE = 4;
    protected int mode = 0;
    protected Color highLightColor = Color.black;
    private boolean dSeparated = false;
    private boolean isDSepEvidence = false;
    Color oldText = null;
    boolean enabled = true;

    protected Class getHomeClass() {
        if (this.home instanceof Class) {
            return (Class)this.home;
        }
        return null;
    }

    protected NetworkModel getHome() {
        return this.home;
    }

    public boolean isResizable() {
        return this.resizable && this.resizeAllowed;
    }

    public void setResizable(boolean bl) {
        this.resizable = bl;
    }

    public boolean isResizeAllowed() {
        return this.resizeAllowed;
    }

    public void setResizeAllowed(boolean bl) {
        this.resizeAllowed = bl;
    }

    protected double getMaxSensitivityValue() {
        return this.maxSensitivityValue;
    }

    protected double getMinSensitivityValue() {
        return this.minSensitivityValue;
    }

    protected double getAvgSensitivityValue() {
        return this.avgSensitivityValue;
    }

    protected void setMaxSensitivityValue(double d) {
        this.maxSensitivityValue = d;
    }

    protected void setMinSensitivityValue(double d) {
        this.minSensitivityValue = d;
    }

    protected void setAvgSensitivityValue(double d) {
        this.avgSensitivityValue = d;
    }

    protected boolean isVisible() {
        return this.visible;
    }

    protected void setVisible(boolean bl) {
        this.visible = bl;
    }

    protected boolean barrenWrtHypothesis() {
        return this.barrenWrtHypothesis;
    }

    protected void setBarrenWrtHypothesis(boolean bl) {
        this.barrenWrtHypothesis = bl;
    }

    protected boolean separatedFromHypothesis() {
        return this.separatedFromHypothesis;
    }

    protected void setSeparatedFromHypothesis(boolean bl) {
        this.separatedFromHypothesis = bl;
    }

    protected Color getPosSensitivityColor() {
        return this.posSensitivityColor;
    }

    protected Color getNegSensitivityColor() {
        return this.posSensitivityColor;
    }

    protected Color getAvgSensitivityColor() {
        return this.posSensitivityColor;
    }

    protected void setPosSensitivityColor(Color color) {
        this.posSensitivityColor = color;
    }

    protected void setNegSensitivityColor(Color color) {
        this.negSensitivityColor = color;
    }

    protected void setAvgSensitivityColor(Color color) {
        this.avgSensitivityColor = color;
    }

    protected Color getSensitivityColor(double d, int n) {
        block7: {
            if (this instanceof DiscreteChanceNode) {
                try {
                    if (this.separatedFromHypothesis() && (!this.separatedFromHypothesis() || !this.getAPINode().evidenceIsEntered()) || this.barrenWrtHypothesis()) {
                        return Color.white;
                    }
                    break block7;
                }
                catch (ExceptionHugin exceptionHugin) {
                    return Color.white;
                }
            }
            return Color.white;
        }
        if (n == 0) {
            return this.posSensitivityColor;
        }
        if (n == 1) {
            return this.negSensitivityColor;
        }
        if (n == 2) {
            return this.avgSensitivityColor;
        }
        return Color.white;
    }

    protected void identifySensitivityColors(Node node, double d, double d2, double d3) {
        try {
            Domain domain = (Domain)this.getAPINode().getHome();
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 1.0f;
            Color color = Color.BLACK;
            Color color2 = Color.YELLOW;
            float f4 = 0.0f;
            if (this.getMaxSensitivityValue() == -1.7976931348623157E308) {
                this.posSensitivityColor = color2;
            } else {
                f4 = (float)(this.getMaxSensitivityValue() / d3);
                if (f4 <= 1.0f || new Float(f4).equals(Float.valueOf(Float.NaN))) {
                    try {
                        this.posSensitivityColor = new Color(f, f2, f3, f4);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        System.err.println(this.getName() + " " + f4 + " " + this.getMaxSensitivityValue());
                        this.posSensitivityColor = Color.WHITE;
                    }
                } else {
                    this.posSensitivityColor = color;
                }
            }
            f = 1.0f;
            f2 = 0.0f;
            f3 = 0.0f;
            if (this.getMinSensitivityValue() == Double.MAX_VALUE) {
                this.negSensitivityColor = color2;
            } else {
                f4 = Math.abs((float)(this.getMinSensitivityValue() / d));
                if (f4 == Float.POSITIVE_INFINITY) {
                    this.negSensitivityColor = Color.WHITE;
                } else if (f4 <= 1.0f || new Float(f4).equals(Float.valueOf(Float.NaN))) {
                    try {
                        this.negSensitivityColor = new Color(f, f2, f3, f4);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.negSensitivityColor = Color.WHITE;
                    }
                } else {
                    this.negSensitivityColor = color;
                }
            }
            f = 0.0f;
            f2 = 1.0f;
            f3 = 0.0f;
            if (this.getMaxSensitivityValue() == -1.7976931348623157E308) {
                this.avgSensitivityColor = color2;
            } else {
                f4 = (float)(this.getAvgSensitivityValue() / d2);
                if (f4 <= 1.0f || new Float(f4).equals(Float.valueOf(Float.NaN))) {
                    try {
                        this.avgSensitivityColor = new Color(f, f2, f3, f4);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.avgSensitivityColor = Color.WHITE;
                    }
                } else {
                    this.avgSensitivityColor = color;
                }
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
    }

    protected COM.hugin.HAPI.Node getAPINode() {
        return this.apiNode;
    }

    protected void setAPINode(COM.hugin.HAPI.Node node) {
        if (this.isInterface()) {
            try {
                this.updateInterfaceNodes(node);
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
        this.apiNode = node;
        this.apiNode.setGUINode(this);
        if (this.table != null) {
            try {
                this.table.update();
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
    }

    private void updateAPINode(InstanceNode instanceNode) {
        try {
            NodeList nodeList = ((COM.hugin.HAPI.InstanceNode)instanceNode.getAPINode()).getOutputs();
            for (COM.hugin.HAPI.Node node : nodeList) {
                String string = node.getName();
                if (!string.equals(this.name) && !this.getRootName(string, instanceNode.getName()).equals(this.name)) continue;
                this.setAPINode(node);
                return;
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            return;
        }
        new HuginGUIError("Node.updateAPINode()", HuginGUIConstants.get("Node_not_found") + "!");
    }

    private String getRootName(String string, String string2) {
        return string.substring(string.lastIndexOf(string2) + string2.length() + 1);
    }

    private void updateInterfaceNodes(COM.hugin.HAPI.Node node) throws ExceptionHugin {
        NodeList nodeList = ((Class)this.home).getInstances();
        for (COM.hugin.HAPI.Node node2 : nodeList) {
            COM.hugin.HAPI.InstanceNode instanceNode = (COM.hugin.HAPI.InstanceNode)node2;
            NetworkPanel networkPanel = HuginGUIFrame.getNetworkPanel(instanceNode.getHome());
            InstanceNode instanceNode2 = (InstanceNode)networkPanel.getNode(instanceNode);
            if (this.isInput()) {
                instanceNode2.updateInputNode(this.apiNode, node);
                continue;
            }
            instanceNode2.getInterfaceNode(this).updateAPINode(instanceNode2);
        }
    }

    protected Rectangle getBoundingBox(boolean bl) {
        return bl ? this.boundingBox.getBounds(true) : ((Rectangle)this.boundingBox.clone()).union(new Rectangle(this.getX() - 3, this.getY() - 3, this.getWidth() + 6, this.getHeight() + 6));
    }

    protected int getX() {
        return (int)Math.rint(this.x);
    }

    protected int getY() {
        return (int)Math.rint(this.y);
    }

    protected int getWidth() {
        return (int)Math.rint(this.width);
    }

    protected int getHeight() {
        return (int)Math.rint(this.height);
    }

    protected double getScaleFactor() {
        return this.scaleFactor;
    }

    protected NodeTableFrame getTable() {
        return this.table;
    }

    protected ColorChart getVisualCPT() {
        return this.visualCPT;
    }

    protected NodeInformation getNodeInfo() {
        return this.savedNodeInfo;
    }

    public Node(Node node) {
        this.initialize(node);
    }

    public Node(NetworkPanel networkPanel, Point point) {
        this.initialize(networkPanel, point);
    }

    public Node(NetworkPanel networkPanel, Point point, String string, String string2) {
        this.initialize(networkPanel, point);
        this.name = string;
        this.label = string2;
    }

    public Node(NetworkPanel networkPanel, String string, String string2) {
        this.initialize(networkPanel);
        this.name = string;
        this.label = string2;
    }

    public Node(NetworkPanel networkPanel, COM.hugin.HAPI.Node node) {
        try {
            this.name = node.getName();
            this.label = node.getLabel();
            this.setAPINode(node);
            this.initialize(networkPanel, new Point((int)node.getPosition().getX(), (int)node.getPosition().getY()));
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    private void initialize(Node node) {
        this.panel = node.panel;
        this.home = node.home;
        this.scaleFactor = node.scaleFactor;
        this.font = this.panel.getNodeFont();
        this.center = new Point2D.Double(node.center.x, node.center.y);
        this.width = node.width;
        this.height = node.height;
        this.x = this.center.x - this.width / 2.0;
        this.y = this.center.y - this.height / 2.0;
        this.boundingBox = new BoundingBox(this.x, this.y, this.width, this.height);
        this.setStroke();
        this.checkLocation();
    }

    protected void initialize(NetworkPanel networkPanel, Point point) {
        this.panel = networkPanel;
        this.home = networkPanel.getHome();
        this.scaleFactor = networkPanel.getScaleFactor();
        this.font = networkPanel.getNodeFont();
        this.center = new Point2D.Double(point.x, point.y);
        this.setSizeFromAttribute();
        this.drawText = this.height >= (double)this.minHeightForText && this.width >= (double)this.minWidthForText;
        this.x = this.center.x - this.width / 2.0;
        this.y = this.center.y - this.height / 2.0;
        this.boundingBox = new BoundingBox(this.x, this.y, this.width, this.height);
        this.setStroke();
        this.checkLocation();
    }

    private void initialize(NetworkPanel networkPanel) {
        this.panel = networkPanel;
        this.home = networkPanel.getHome();
        this.scaleFactor = networkPanel.getScaleFactor();
        this.font = networkPanel.getNodeFont();
        this.center = new Point2D.Double();
        this.setSizeFromAttribute();
        this.drawText = this.height >= (double)this.minHeightForText && this.width >= (double)this.minWidthForText;
        this.boundingBox = new BoundingBox(0.0, 0.0, this.width, this.height);
        this.setStroke();
    }

    protected void setSizeFromAttribute() {
        try {
            String string = this.getAPINode().getAttribute("HR_NodeSize");
            if (string != null && string.trim().length() > 0) {
                this.parseSizeSpec(string);
            } else {
                this.width = this.scaleFactor * this.panel.getNodeWidth();
                this.height = this.scaleFactor * this.panel.getNodeHeight();
            }
        }
        catch (Exception exception) {
            this.width = this.scaleFactor * this.panel.getNodeWidth();
            this.height = this.scaleFactor * this.panel.getNodeHeight();
        }
    }

    protected void parseSizeSpec(String string) {
        this.width = this.scaleFactor * HuginGUIUtils.parseDouble(string, "(", ",");
        this.height = this.scaleFactor * HuginGUIUtils.parseDouble(string, ",", ")");
    }

    private boolean hasSpecialSize() {
        try {
            String string = this.getAPINode().getAttribute("HR_NodeSize");
            return string != null && string.trim().length() != 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void setSpecialSize() throws ExceptionHugin {
        String string = this.getAPINode().getAttribute("HR_NodeSize");
        if (string == null) {
            return;
        }
        this.setSpecialSize(string);
    }

    protected void setSpecialSize(String string) throws ExceptionHugin {
        this.getAPINode().setAttribute("HR_NodeSize", string);
        this.parseSizeSpec(string);
        this.updateSize((int)(this.width / this.scaleFactor), (int)(this.height / this.scaleFactor));
    }

    protected void setFont(Font font) {
        this.font = font;
    }

    protected void updateSize() throws ExceptionHugin {
        if (this.hasSpecialSize()) {
            return;
        }
        this.width = this.scaleFactor * this.panel.getNodeWidth();
        this.height = this.scaleFactor * this.panel.getNodeHeight();
        this.drawText = this.height >= (double)this.minHeightForText && this.width >= (double)this.minWidthForText;
        this.moveTo(this.x + this.width / 2.0, this.y + this.height / 2.0);
        this.boundingBox.setSize(this.width, this.height);
    }

    protected void updateSize(int n, int n2) throws ExceptionHugin {
        this.width = this.scaleFactor * (double)n;
        this.height = this.scaleFactor * (double)n2;
        this.drawText = this.height >= (double)this.minHeightForText && this.width >= (double)this.minWidthForText;
        this.move(0, 0);
        this.boundingBox.setSize(this.width, this.height);
        this.getAPINode().setAttribute("HR_NodeSize", "(" + n + ", " + n2 + ")");
        this.panel.nodeChangedSize(this);
    }

    protected void kill() throws ExceptionHugin {
        Node node;
        Object object;
        Object object2 = this.panel.linkList.listIterator();
        while (object2.hasNext()) {
            object = (Link)object2.next();
            if (!(object instanceof CDVTLink) || ((Link)object).parent != this && ((Link)object).child != this) continue;
            ((CDVTLink)object).unregisterAttributes();
            object2.remove();
        }
        if (this.isInterface()) {
            this.setInterfaceType(0);
        }
        this.disposeTable();
        object2 = this.getChildren();
        object = ((AbstractSequentialList)object2).iterator();
        while (object.hasNext()) {
            node = (Node)object.next();
            node.backupTemporaryExpressions();
        }
        this.getAPINode().delete();
        this.cloneOf = this;
        object = ((AbstractSequentialList)object2).iterator();
        while (object.hasNext()) {
            node = (Node)object.next();
            node.restoreFromTemporaryExpressions();
            node.updateTableParentStateNames();
        }
    }

    protected void backupTemporaryExpressions() {
        try {
            this.tempExpressions = new ArrayList();
            if (this.getAPINode().isAlive() && this.getAPINode().getModel() != null) {
                for (int i = 0; i < this.getAPINode().getModel().getSize(); ++i) {
                    Expression expression = this.getAPINode().getModel().getExpression(i);
                    if (expression == null) continue;
                    this.tempExpressions.add("if (true, \"HR_Syntax_Error:\", \"" + expression.expressionToString() + "\")");
                }
            }
        }
        catch (ExceptionUsage exceptionUsage) {
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
    }

    protected void restoreFromTemporaryExpressions() {
        try {
            Model model = this.getAPINode().getModel();
            if (model != null) {
                int n = this.tempExpressions.size();
                for (int i = 0; i < n; ++i) {
                    String string;
                    if (model.getExpression(i) != null || (string = this.tempExpressions.get(i)) == null) continue;
                    Expression expression = Expression.stringToExpression(string, model, null);
                    model.setExpression(i, expression);
                }
            }
            this.tempExpressions = null;
        }
        catch (ExceptionObjectNotAlive exceptionObjectNotAlive) {
        }
        catch (ExceptionUsage exceptionUsage) {
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
    }

    protected NodeTableFrame getCPT() {
        return this.table;
    }

    protected void updateTableNodeNames() throws ExceptionHugin {
        this.updateTable();
    }

    protected void updateTableParentStateNames() throws ExceptionHugin {
        if (this.table != null) {
            this.table.updateStateNames();
        }
    }

    protected void updateChildTables() throws ExceptionHugin {
        for (Node jInternalFrameArray : this.getChildren()) {
            jInternalFrameArray.updateTable();
        }
        if (this.isOutput()) {
            NodeList nodeList = HuginGUIUtils.getOutputClones(this.getAPINode());
            JInternalFrame[] jInternalFrameArray = Hugin.mainFrame.desktop.getAllFrames();
            Iterator iterator = nodeList.iterator();
            block1: while (iterator.hasNext()) {
                COM.hugin.HAPI.Node node = (COM.hugin.HAPI.Node)iterator.next();
                for (JInternalFrame jInternalFrame : jInternalFrameArray) {
                    NetworkPanel networkPanel = ((HuginProjectFrame)jInternalFrame).getNetworkPanel();
                    Node node2 = networkPanel.getNode(node);
                    if (node2 == null) continue;
                    for (COM.hugin.HAPI.Node node3 : node2.getAPINode().getChildren()) {
                        networkPanel.getNode(node3).updateTable();
                    }
                    continue block1;
                }
            }
        }
    }

    protected NodeTableFrame getOrCreateCPT() throws ExceptionHugin {
        if (this.table == null) {
            if (this.panel == null) {
                this.setTable(new NodeTableFrame(this, 0, 0));
            } else {
                this.setTable(new NodeTableFrame(this, this.panel.getWidth(), 150));
                this.panel.projectFrame.getTablePanel().addTable(false, this.table);
            }
        }
        return this.table;
    }

    protected void saveNodeInfo() throws ExceptionHugin {
        this.savedNodeInfo = new NodeInformation(this);
    }

    protected void restoreSavedNodeInfo() {
        if (this.cloneOf != null && this.cloneOf.savedNodeInfo != null) {
            this.cloneOf.savedNodeInfo.restore(this);
        }
    }

    protected void restoreSavedCardinality() throws ExceptionHugin {
        if (this.cloneOf != null && this.cloneOf.savedNodeInfo != null) {
            this.cloneOf.savedNodeInfo.restoreCardinality(this);
        }
    }

    protected void checkLocation() {
        double d;
        double d2;
        this.x = this.center.x - this.width / 2.0;
        if (d2 < 0.0) {
            this.x = 0.0;
        }
        this.y = this.center.y - this.height / 2.0;
        if (d < 0.0) {
            this.y = 0.0;
        }
        this.center.setLocation(this.x + this.width / 2.0, this.y + this.height / 2.0);
        this.boundingBox.setLocation(this.x, this.y);
    }

    protected int getCornerPointAt(Point point) {
        if (!this.isResizable()) {
            return -1;
        }
        Point point2 = new Point(this.getX() - 3, this.getY() - 3);
        if (point.distance(point2) < 3.0) {
            return 0;
        }
        point2.setLocation(this.getX() - 3, this.getY() + this.getHeight() + 3);
        if (point.distance(point2) < 3.0) {
            return 1;
        }
        point2.setLocation(this.getX() + this.getWidth() + 3, this.getY() - 3);
        if (point.distance(point2) < 3.0) {
            return 2;
        }
        point2.setLocation(this.getX() + this.getWidth() + 3, this.getY() + this.getHeight() + 3);
        if (point.distance(point2) < 3.0) {
            return 3;
        }
        return -1;
    }

    public void endCornerPointMove() {
        this.firstCornerPoint = true;
    }

    public Point getValidCornerPoint(int n, Point point, boolean bl, boolean bl2, double d, double d2) throws ExceptionHugin {
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 0: {
                n2 = Math.round(this.getWidth() + (this.getX() - point.x));
                n3 = Math.round(this.getHeight() + (this.getY() - point.y));
                if (bl) {
                    n2 = (int)Math.round((double)((int)Math.round((double)n2 / d)) * d);
                    n3 = (int)Math.round((double)((int)Math.round((double)n3 / d2)) * d2);
                }
                return new Point(Math.max(0, this.getX() + this.getWidth() - n2), Math.max(0, this.getY() + this.getHeight() - n3));
            }
            case 1: {
                n2 = Math.round(this.getWidth() + (this.getX() - point.x));
                n3 = Math.round(point.y - this.getY());
                if (bl) {
                    n2 = (int)Math.round((double)((int)Math.round((double)n2 / d)) * d);
                    n3 = (int)Math.round((double)((int)Math.round((double)n3 / d2)) * d2);
                }
                return new Point(Math.max(0, this.getX() + this.getWidth() - n2), (int)Math.min(2.0 * this.center.y, (double)(this.getY() + n3)));
            }
            case 2: {
                n2 = Math.round(point.x - this.getX());
                n3 = Math.round(this.getHeight() + (this.getY() - point.y));
                if (bl) {
                    n2 = (int)Math.round((double)((int)Math.round((double)n2 / d)) * d);
                    n3 = (int)Math.round((double)((int)Math.round((double)n3 / d2)) * d2);
                }
                return new Point((int)Math.min(2.0 * this.center.x, (double)(this.getX() + n2)), Math.max(0, this.getY() + this.getHeight() - n3));
            }
            case 3: {
                n2 = Math.round(point.x - this.getX());
                n3 = Math.round(point.y - this.getY());
                if (bl) {
                    n2 = (int)Math.round((double)((int)Math.round((double)n2 / d)) * d);
                    n3 = (int)Math.round((double)((int)Math.round((double)n3 / d2)) * d2);
                }
                return new Point((int)Math.min(2.0 * this.center.x, (double)(this.getX() + n2)), (int)Math.min(2.0 * this.center.y, (double)(this.getY() + n3)));
            }
        }
        return new Point(this.getX(), this.getY());
    }

    public void setCornerPointPosition(int n, Point point, boolean bl) throws ExceptionHugin {
        if (this.firstCornerPoint) {
            this.firstCornerPoint = false;
            this.tempCornerPointWidth = this.getWidth();
            this.tempCornerPointHeight = this.getHeight();
        }
        switch (n) {
            case 0: {
                int n2 = this.getWidth();
                int n3 = this.getHeight();
                int n4 = (int)Math.rint(((double)(this.getX() + this.getWidth()) - point.getX()) / this.getScaleFactor());
                int n5 = (int)Math.rint(((double)(this.getY() + this.getHeight()) - point.getY()) / this.getScaleFactor());
                if (bl) {
                    if (Math.abs(n4 - this.tempCornerPointWidth) > Math.abs(n5 - this.tempCornerPointHeight)) {
                        n5 = this.tempCornerPointHeight;
                    } else {
                        n4 = this.tempCornerPointWidth;
                    }
                }
                this.updateSize(Math.min(Math.max(n4, Node.MIN_SIZE.width), Node.MAX_SIZE.width), Math.min(Math.max(n5, Node.MIN_SIZE.height), Node.MAX_SIZE.height));
                break;
            }
            case 1: {
                int n6 = this.getWidth();
                int n7 = (int)Math.rint(((double)(this.getX() + this.getWidth()) - point.getX()) / this.getScaleFactor());
                int n8 = (int)Math.rint((point.getY() - (double)this.getY()) / this.getScaleFactor());
                if (bl) {
                    if (Math.abs(n7 - this.tempCornerPointWidth) > Math.abs(n8 - this.tempCornerPointHeight)) {
                        n8 = this.tempCornerPointHeight;
                    } else {
                        n7 = this.tempCornerPointWidth;
                    }
                }
                this.updateSize(Math.min(Math.max(n7, Node.MIN_SIZE.width), Node.MAX_SIZE.width), Math.min(Math.max(n8, Node.MIN_SIZE.height), Node.MAX_SIZE.height));
                break;
            }
            case 2: {
                int n9 = this.getHeight();
                int n10 = (int)Math.rint((point.getX() - (double)this.getX()) / this.getScaleFactor());
                int n11 = (int)Math.rint(((double)(this.getY() + this.getHeight()) - point.getY()) / this.getScaleFactor());
                if (bl) {
                    if (Math.abs(n10 - this.tempCornerPointWidth) > Math.abs(n11 - this.tempCornerPointHeight)) {
                        n11 = this.tempCornerPointHeight;
                    } else {
                        n10 = this.tempCornerPointWidth;
                    }
                }
                this.updateSize(Math.min(Math.max(n10, Node.MIN_SIZE.width), Node.MAX_SIZE.width), Math.min(Math.max(n11, Node.MIN_SIZE.height), Node.MAX_SIZE.height));
                break;
            }
            case 3: {
                int n12 = (int)Math.rint((point.getX() - (double)this.getX()) / this.getScaleFactor());
                int n13 = (int)Math.rint((point.getY() - (double)this.getY()) / this.getScaleFactor());
                if (bl) {
                    if (Math.abs(n12 - this.tempCornerPointWidth) > Math.abs(n13 - this.tempCornerPointHeight)) {
                        n13 = this.tempCornerPointHeight;
                    } else {
                        n12 = this.tempCornerPointWidth;
                    }
                }
                this.updateSize(Math.min(Math.max(n12, Node.MIN_SIZE.width), Node.MAX_SIZE.width), Math.min(Math.max(n13, Node.MIN_SIZE.height), Node.MAX_SIZE.height));
            }
        }
    }

    protected void paint(Graphics2D graphics2D) {
        if (this.isSelected() && this.isResizable()) {
            int n = this.getX() - 3;
            int n2 = this.getX() + this.getWidth() + 3;
            int n3 = this.getY() - 3;
            int n4 = this.getY() + this.getHeight() + 3;
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(HStroke.BASIC_STROKE);
            graphics2D.drawLine(n, n3, n + 3, n3);
            graphics2D.drawLine(n, n3, n, n3 + 3);
            graphics2D.drawLine(n, n4, n + 3, n4);
            graphics2D.drawLine(n, n4, n, n4 - 3);
            graphics2D.drawLine(n2, n3, n2 - 3, n3);
            graphics2D.drawLine(n2, n3, n2, n3 + 3);
            graphics2D.drawLine(n2, n4, n2 - 3, n4);
            graphics2D.drawLine(n2, n4, n2, n4 - 3);
        }
        if (!this.isGhost) {
            graphics2D.setStroke(HStroke.NO_STROKE);
            graphics2D.setPaint(this.actualFillColor);
            graphics2D.fill(this.shape);
            if (this.panel instanceof SensitivityNetworkPanel && this.getAPINode() instanceof COM.hugin.HAPI.DiscreteChanceNode) {
                Shape shape = graphics2D.getClip();
                Color color = graphics2D.getColor();
                double d = 0.0;
                Color color2 = this.getSensitivityColor(d, 0);
                graphics2D.setClip(new Rectangle(this.getX(), this.getY(), this.getWidth() / 3, this.getHeight()));
                graphics2D.setColor(color2);
                graphics2D.fill(this.shape);
                Color color3 = this.getSensitivityColor(d, 1);
                graphics2D.setClip(new Rectangle(this.getX() + this.getWidth() / 3, this.getY(), this.getWidth() / 3, this.getHeight()));
                graphics2D.setColor(color3);
                graphics2D.fill(this.shape);
                Color color4 = this.getSensitivityColor(d, 2);
                graphics2D.setClip(new Rectangle(this.getX() + 2 * (this.getWidth() / 3), this.getY(), this.getWidth() / 3, this.getHeight()));
                graphics2D.setColor(color4);
                graphics2D.fill(this.shape);
                graphics2D.setClip(shape);
                graphics2D.setColor(color);
            }
            graphics2D.draw(this.shape);
        }
        graphics2D.setStroke(this.stroke);
    }

    protected void paintInfoField(Graphics2D graphics2D) {
        try {
            if (this.hasEvidence() || this.hasLikelihood()) {
                Stroke stroke = graphics2D.getStroke();
                Color color = graphics2D.getColor();
                graphics2D.setStroke(HStroke.BASIC_STROKE);
                graphics2D.setColor(Color.white);
                int n = (int)Math.round(12.0 * this.getScaleFactor());
                graphics2D.fillRect(this.getX() + this.getWidth() - n, this.getY() + this.getHeight() - n, n, n);
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(this.getX() + this.getWidth() - n, this.getY() + this.getHeight() - n, n, n);
                graphics2D.setStroke(stroke);
                graphics2D.setFont(graphics2D.getFont().deriveFont(1, (float)(12.0 * this.getScaleFactor())));
                if (this.hasLikelihood()) {
                    graphics2D.setColor(Hugin.mainFrame.preferences.barColors.get(3));
                    graphics2D.drawString("f", this.getX() + this.getWidth() - n + (int)Math.round(4.0 * this.getScaleFactor()), this.getY() + this.getHeight() - n + (int)Math.round(11.0 * this.getScaleFactor()));
                } else if (this.hasEvidence()) {
                    graphics2D.setColor(Hugin.mainFrame.preferences.barColors.get(1));
                    graphics2D.drawString("e", this.getX() + this.getWidth() - n + (int)Math.round(4.0 * this.getScaleFactor()), this.getY() + this.getHeight() - n + (int)Math.round(11.0 * this.getScaleFactor()));
                }
                graphics2D.setColor(color);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void paintText(Graphics2D graphics2D) {
        graphics2D.setPaint(this.textColor);
        graphics2D.setFont(this.font);
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.getTitle((short)1), "\n");
            int n = 0;
            int n2 = stringTokenizer.countTokens();
            while (stringTokenizer.hasMoreTokens()) {
                this.paintCenteredText(graphics2D, stringTokenizer.nextToken(), n++, n2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void print(Graphics graphics, Point point) throws ExceptionHugin {
    }

    protected void printInInstance(Graphics graphics, Point point, int n) throws ExceptionHugin {
    }

    protected String getTitle() throws ExceptionHugin {
        return this.getTitle((short)0);
    }

    protected String getTitle(short s) throws ExceptionHugin {
        String string;
        String string2 = string = this.label.length() > 0 ? this.label : this.name;
        if (this.host != null) {
            return string;
        }
        return HuginGUIUtils.getNodeTitle(this.apiNode, s);
    }

    protected void printText(Graphics graphics, Point point) throws ExceptionHugin {
        graphics.setColor(this.textColor);
        graphics.setFont(this.font);
        StringTokenizer stringTokenizer = new StringTokenizer(this.getTitle((short)1), "\n");
        int n = 0;
        int n2 = stringTokenizer.countTokens();
        while (stringTokenizer.hasMoreTokens()) {
            this.printCenteredText(graphics, stringTokenizer.nextToken(), n++, n2, point);
        }
    }

    protected void repaint() {
        this.panel.repaint(this);
    }

    protected void paintCenteredText(Graphics2D graphics2D, String string) {
        this.paintCenteredText(graphics2D, string, 0, 1);
    }

    protected void paintCenteredText(Graphics2D graphics2D, String string, int n, int n2) {
        Object object;
        Point2D.Double double_ = this.textLocation();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Rectangle2D rectangle2D = graphics2D.getFont().getStringBounds(string, fontRenderContext);
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getHeight() / 2.0;
        double d3 = this.width - 10.0 * this.scaleFactor;
        boolean bl = this.titleIsWide = d3 / d < 1.0;
        if (this.titleIsWide) {
            object = string.substring(0, (int)(d3 / d * (double)(string.length() - 2)));
            string = ((String)object).concat("...");
            rectangle2D = graphics2D.getFont().getStringBounds(string, fontRenderContext);
            d = (float)rectangle2D.getWidth();
        }
        object = graphics2D.getClip();
        graphics2D.setClip(this.getBoundingBox(true));
        graphics2D.drawString(string, (int)(double_.x - d / 2.0), (int)(double_.y + d2 / 2.0 - ((double)(n2 - 1) * d2 - (double)n * d2 * 2.0)));
        graphics2D.setClip((Shape)object);
    }

    protected void printCenteredText(Graphics graphics, String string, Point point) {
        this.printCenteredText(graphics, string, 0, 1, point);
    }

    protected void printCenteredText(Graphics graphics, String string, int n, int n2, Point point) {
        Point2D.Double double_ = this.textLocation();
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        Rectangle rectangle = new Rectangle(SwingUtilities.computeStringWidth(fontMetrics, string), fontMetrics.getHeight());
        double d = rectangle.getWidth();
        double d2 = rectangle.getHeight() / 2.0;
        double d3 = this.width - 10.0 * this.scaleFactor;
        boolean bl = this.titleIsWide = d3 / d < 1.0;
        if (this.titleIsWide) {
            String string2 = string.substring(0, (int)(d3 / d * (double)(string.length() - 2)));
            string = string2.concat("...");
            rectangle = new Rectangle(SwingUtilities.computeStringWidth(fontMetrics, string), fontMetrics.getHeight());
            d = (float)rectangle.getWidth();
        }
        graphics.drawString(string, (int)(double_.x + (double)point.x - d / 2.0), (int)(double_.y + (double)point.y + d2 / 2.0 - ((double)(n2 - 1) * d2 - (double)n * d2 * 2.0)));
    }

    protected Point2D.Double textLocation() {
        return this.center;
    }

    public Object clone() {
        Node node;
        Point point = new Point((int)this.center.x, (int)this.center.y);
        switch (this.type) {
            case 1: {
                node = new DiscreteChanceNode(this);
                break;
            }
            case 2: {
                node = new ContinuousChanceNode(this);
                break;
            }
            case 3: {
                node = new UtilityNode(this);
                break;
            }
            case 4: {
                node = new DiscreteDecisionNode(this);
                break;
            }
            case 6: {
                node = new FunctionNode(this);
                break;
            }
            default: {
                node = null;
            }
        }
        node.name = this.name;
        node.cloneOf = this;
        node.interfaceType = this.interfaceType;
        return node;
    }

    protected Node copy() throws ExceptionHugin {
        Node node = (Node)this.clone();
        node.savedNodeInfo = new NodeInformation(this);
        return node;
    }

    public Object clone(NetworkPanel networkPanel, Point point) throws ExceptionHugin, IllegalCloneException {
        if (this.cloneOf.isInterface() && networkPanel.getHomeClass() == null) {
            throw new IllegalCloneException(HuginGUIConstants.get("V57_NETS_CANT_CONTAIN_OOBN_NODES"));
        }
        if ((this.cloneOf.isDecision() || this.cloneOf.isUtility()) && networkPanel.containsContinuousNodes()) {
            throw new IllegalCloneException(HuginGUIConstants.get("CG_NETS_CANT_CONTAIN_ID_NODES"));
        }
        if (this.cloneOf.isContinuousChance() && networkPanel.isLIMIDs()) {
            throw new IllegalCloneException(HuginGUIConstants.get("IDS_CANT_CONTAIN_CG_NODES"));
        }
        int n = this.cloneOf.cloneId(networkPanel);
        Node node = this.createClone(networkPanel, point, this.cloneOf.cloneName(n), this.cloneOf.cloneLabel(n));
        node.cloneOf = this;
        if (this.cloneOf.group != 0 && node.getGroupIndex(this.cloneOf.group) < 0) {
            networkPanel.createGroup(this.cloneOf.group, this.cloneOf.getGroupName(), NodeGroup.color2index(this.cloneOf.fillColor));
        }
        node.setGroup(this.cloneOf.group);
        return node;
    }

    private Node createClone(NetworkPanel networkPanel, Point point, String string, String string2) throws ExceptionHugin {
        Node node;
        int n = this.isDiscrete() ? ((DiscreteNode)((Object)this)).getSubtype() : -1;
        switch (this.type) {
            case 1: {
                node = new DiscreteChanceNode(networkPanel, point, string, string2, n);
                break;
            }
            case 2: {
                node = new ContinuousChanceNode(networkPanel, point, string, string2);
                break;
            }
            case 3: {
                node = new UtilityNode(networkPanel, point, string, string2);
                break;
            }
            case 4: {
                node = new DiscreteDecisionNode(networkPanel, point, string, string2, n);
                break;
            }
            case 6: {
                node = new FunctionNode(networkPanel, point, string, string2);
                break;
            }
            default: {
                node = null;
            }
        }
        return node;
    }

    protected int cloneId(NetworkPanel networkPanel) {
        int n = 0;
        while (networkPanel.getNode(this.cloneName(n)) != null) {
            ++n;
        }
        return n;
    }

    protected String cloneName(int n) {
        return n == 0 ? this.name : this.name + "_" + n;
    }

    protected String cloneLabel(int n) {
        if (n == 0) {
            return this.label;
        }
        return this.label == null || this.label.length() == 0 ? "" : this.label + " (" + n + ")";
    }

    protected Node getGhost(LinkedList<Node> linkedList) {
        for (Node node : linkedList) {
            if (this != node.cloneOf) continue;
            return node;
        }
        return null;
    }

    protected void setGhost(boolean bl) {
        this.isGhost = bl;
        this.setStroke();
    }

    protected void setStroke() {
        this.stroke = this.isGhost ? HStroke.DASH_STROKE : (this.mode == 1 ? HStroke.BASIC_STROKE : (this.selected ? HStroke.HILIT_STROKE : (this.isInput() ? HStroke.DASH_STROKE : HStroke.BASIC_STROKE)));
        this.scaleStroke();
    }

    protected void setStroke(Stroke stroke) {
        this.stroke = stroke;
        this.scaleStroke();
    }

    private void scaleStroke() {
        int n = this.selected || this.mode == 1 ? 4 : 1;
        int n2 = (int)Math.rint(this.scaleFactor * (double)n);
        int n3 = (int)Math.rint(this.scaleFactor * 8.0);
        if (n2 <= 1) {
            n2 = 1 + (this.selected ? 1 : 0);
        } else if (n2 > 9) {
            n2 = 9;
        }
        if (n3 <= 1) {
            n3 = 2;
        } else if (n3 > 30) {
            n3 = 30;
        }
        this.stroke = HStroke.isDashed(this.stroke) ? HStroke.DASH_STROKES[n2] : HStroke.STROKES[n2];
        this.interfaceStroke = HStroke.STROKES[n3];
    }

    protected void getGroup() {
        int n = 0;
        try {
            String string;
            String string2 = this.getAPINode().getAttribute("HR_Group");
            if (string2 != null && !string2.equals("")) {
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                    this.getAPINode().setAttribute("HR_Group", null);
                }
                string = this.getGroupName(n);
            }
            if ((string2 = this.getAPINode().getAttribute("HR_Grp")) != null && !string2.equals("")) {
                int n2 = Integer.parseInt(string2);
                if (n2 + 1 != n) {
                    n = n2 + 1;
                    string = this.getGroupName(n);
                    this.getAPINode().setAttribute("HR_Group", "" + n);
                }
                this.getAPINode().setAttribute("HR_Grp", null);
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
            return;
        }
        this.group = n;
        this.updateColor();
    }

    protected String getGroupName() {
        return this.getGroupName(this.group);
    }

    protected void setGroup(int n) {
        try {
            this.getAPINode().setAttribute("HR_Group", "" + n);
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        if (this.group != n) {
            this.panel.containsUnsavedChanges(true);
            this.group = n;
        }
        this.updateColor();
    }

    private String getGroupName(int n) {
        try {
            return this.home.getAttribute("HR_Group_" + n + "_Name");
        }
        catch (Exception exception) {
            return HuginGUIConstants.get("NODE_PROPERTIES_no_group");
        }
    }

    protected int getGroupIndex() {
        return this.group;
    }

    protected int getGroupIndex(int n) {
        String string = this.getGroupName(n);
        if (string == null || string.length() == 0) {
            return -1;
        }
        return n;
    }

    protected void updateColor() {
        if (this.isGhost) {
            return;
        }
        try {
            String string;
            this.fillColor = this.getGroupColor(this.group);
            if (this.fillColor == null && this.getAPINode() != null && this.group != 0) {
                this.getAPINode().setAttribute("HR_Group", null);
                this.group = 0;
            }
            if (this.group == 0) {
                String string2 = this.home.getAttribute(this.colorAttribute);
                if (string2 == null || string2.equals("")) {
                    string2 = DomainAttributes.getValue(this.colorAttribute);
                }
                this.fillColor = NodeGroup.index2color(Integer.parseInt(string2));
            }
            if ((string = this.home.getAttribute("HR_Color_Interface")) == null || string.equals("")) {
                string = DomainAttributes.getValue("HR_Color_Interface");
            }
            this.interfaceColor = NodeGroup.index2color(Integer.parseInt(string));
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        this.textColor = this.hasDarkFillColor() ? Color.white : Color.black;
        this.actualFillColor = this.fillColor;
    }

    private boolean hasDarkFillColor() {
        int n = NodeGroup.color2index(this.fillColor);
        return (n + 6) % 16 <= 1 || (n + 2) % 16 <= 1 || (n + 9) % 16 == 0;
    }

    protected Color getTextColor() {
        return this.hasDarkFillColor() ? Color.white : Color.black;
    }

    protected Color getColor() {
        return this.fillColor;
    }

    private Color getGroupColor(int n) {
        String string;
        if (n <= 0) {
            return null;
        }
        try {
            string = this.home.getAttribute("HR_Group_" + n + "_Color");
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            return new Color(0, 0, 0);
        }
        if (string == null) {
            string = "";
        }
        Color color = null;
        try {
            color = NodeGroup.index2color(Integer.parseInt(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return color;
    }

    protected void storePosition() throws ExceptionHugin {
        nodePosition.setLocation((float)this.center.x, (float)this.center.y);
        this.getAPINode().setPosition(nodePosition);
    }

    protected void restorePosition() throws ExceptionHugin {
        Point2D.Double double_ = (Point2D.Double)this.getAPINode().getPosition();
        this.moveTo(double_.x, double_.y);
    }

    protected void move(int n, int n2) throws ExceptionHugin {
        this.moveTo(this.center.x + (double)n, this.center.y + (double)n2);
    }

    protected void moveTo(double d, double d2) throws ExceptionHugin {
        if (d - this.width / 2.0 < 0.0) {
            d = this.width / 2.0;
        }
        if (d2 - this.height / 2.0 < 0.0) {
            d2 = this.height / 2.0;
        }
        this.center.setLocation(d, d2);
        this.x = this.center.x - this.width / 2.0;
        this.y = this.center.y - this.height / 2.0;
        this.boundingBox.setLocation(this.x, this.y);
        if (this.apiNode != null && this.host == null) {
            this.storePosition();
        }
    }

    protected void moveTo(int n, int n2) throws ExceptionHugin {
        this.moveTo((double)n, (double)n2);
    }

    protected void moveTo(Point point) throws ExceptionHugin {
        this.moveTo((double)point.x, (double)point.y);
    }

    protected Point nearestGridPoint(Dimension dimension) {
        int n = (int)this.center.x;
        int n2 = (int)this.center.y;
        int n3 = (int)(this.scaleFactor * (double)dimension.width);
        int n4 = (int)(this.scaleFactor * (double)dimension.height);
        int n5 = n3 == 0 ? 0 : n3 * ((n + n % n3) / n3);
        int n6 = n4 == 0 ? 0 : n4 * ((n2 + n2 % n4) / n4);
        return new Point(n5, n6);
    }

    protected void snapTo(Dimension dimension) throws ExceptionHugin {
        this.moveTo(this.nearestGridPoint(dimension));
    }

    protected void scale(double d) throws ExceptionHugin {
        this.scale(d, true);
    }

    protected void scale(double d, boolean bl) throws ExceptionHugin {
        this.width *= d;
        this.height *= d;
        this.drawText = this.height >= (double)this.minHeightForText && this.width >= (double)this.minWidthForText;
        this.scaleFactor *= d;
        if (bl) {
            this.moveTo(d * this.center.x, d * this.center.y);
        }
        this.boundingBox.setSize(this.width, this.height);
        this.scaleStroke();
        String string = this.home.getAttribute("HR_Font_Size");
        if (string == null) {
            string = "-12";
        }
        int n = -Integer.parseInt(string);
        this.font = this.font.deriveFont((float)((double)n * this.scaleFactor));
    }

    protected Point getRadii() {
        return new Point((int)this.width, (int)this.height);
    }

    protected boolean contains(Point point) {
        if (this.isSelected() && this.isResizable() && (point.distance(this.getX() - 3, this.getY() - 3) < 3.0 || point.distance(this.getX() - 3, this.getY() + this.getHeight() + 3) < 3.0 || point.distance(this.getX() + this.getWidth() + 3, this.getY() - 3) < 3.0 || point.distance(this.getX() + this.getWidth() + 3, this.getY() + this.getHeight() + 3) < 3.0)) {
            return true;
        }
        return this.shape.contains(point);
    }

    protected boolean intersects(Rectangle rectangle) {
        if (this.isGhost) {
            return this.boundingBox.intersects(rectangle);
        }
        return this.shape.intersects(rectangle);
    }

    protected boolean intersects(int n, int n2, int n3, int n4) {
        if (this.isGhost) {
            return this.boundingBox.intersects(new Rectangle(n, n2, n3, n4));
        }
        return this.shape.intersects(n, n2, n3, n4);
    }

    protected void select(boolean bl) throws ExceptionHugin {
        if (this.selected) {
            return;
        }
        this.selected = true;
        this.setStroke();
        if (this.panel.isInEditMode()) {
            if (this.panel.showTables() && !this.isInstance() && bl) {
                this.showTable();
            }
        } else if (this.panel.projectFrame != null && this.panel.projectFrame.beliefBars != null) {
            this.panel.projectFrame.beliefBars.expandNode(this.getAPINode());
        }
    }

    protected void passiveSelect() {
        if (this.selected) {
            return;
        }
        this.selected = true;
        this.setStroke();
    }

    protected void deselect() {
        if (!this.selected) {
            return;
        }
        this.selected = false;
        this.setStroke();
        if (!this.panel.isInEditMode()) {
            this.panel.projectFrame.beliefBars.collapseNode(this.getAPINode());
        }
        if (Hugin.mainFrame.preferences.node_table_connection_mode == 0) {
            this.hideTable();
        }
    }

    protected void passiveDeselect() {
        if (!this.selected) {
            return;
        }
        this.selected = false;
        this.setStroke();
    }

    protected void activateTable() throws ExceptionHugin {
        if (this.getAPINode().getAttribute("HR_CDVT_parent") != null) {
            return;
        }
        if (this.isInstance()) {
            return;
        }
        if (this.table == null) {
            this.setTable(new NodeTableFrame(this, this.panel.getWidth(), 150));
        }
        this.panel.projectFrame.getTablePanel().addTable(false, this.table);
        this.panel.projectFrame.getTablePanel().showTable(this.table, true);
    }

    protected void showTable() throws ExceptionHugin {
        this.showTable(false, false);
    }

    protected void showTable(boolean bl, boolean bl2) throws ExceptionHugin {
        if (this.isInstance()) {
            return;
        }
        this.showTable(this.table, bl, bl2);
    }

    private void showTable(NodeTableFrame nodeTableFrame) throws ExceptionHugin {
        this.showTable(nodeTableFrame, false, false);
    }

    private void showTable(NodeTableFrame nodeTableFrame, boolean bl, boolean bl2) throws ExceptionHugin {
        if (this.getAPINode().getAttribute("HR_CDVT_parent") != null) {
            return;
        }
        if (this.isInstance()) {
            return;
        }
        if (nodeTableFrame == null) {
            this.setTable(new NodeTableFrame(this, this.panel.getWidth(), 150));
        }
        if (bl) {
            this.table.getTable().showExperience(true);
        }
        if (bl2) {
            this.table.getTable().showFading(true);
        }
        this.panel.projectFrame.getTablePanel().addTable(false, this.table);
        if (this.isSelected() || Hugin.mainFrame.preferences.node_table_connection_mode == 1) {
            this.panel.projectFrame.getTablePanel().showTable(this.table);
        }
    }

    protected void hideTable() {
        if (this.table != null && this.panel.projectFrame != null) {
            this.panel.projectFrame.getTablePanel().hideTable(this.table);
        }
    }

    private void hideTable(NodeTableFrame nodeTableFrame) {
        this.panel.projectFrame.getTablePanel().hideTable(nodeTableFrame);
    }

    protected void disposeTable() {
        if (this.table != null) {
            this.panel.projectFrame.getTablePanel().disposeTable(this.table);
            this.setTable(null);
        }
    }

    protected void updateTable() throws ExceptionHugin {
        if (!this.isInstance()) {
            this.updateTable(this.panel.showTables());
        }
    }

    protected void saveTable() {
    }

    protected void setCPTMode(int n) throws ExceptionHugin {
        if (this.table != null) {
            this.table.showExpressions(n == 1);
        }
    }

    protected void updateTable(boolean bl) throws ExceptionHugin {
        if (this.table != null) {
            this.table.update();
        }
    }

    protected void updateTableNodeNamesInAllTables() {
    }

    private void setTable(NodeTableFrame nodeTableFrame) {
        this.table = nodeTableFrame;
        if (nodeTableFrame != null) {
            this.table.addTableChangeListener(new NodeTableFrame.TableChangeListener(){

                public void tableChanged() {
                    Node.this.panel.containsUnsavedChanges(true);
                }
            });
        }
    }

    protected boolean hasExperienceTable() {
        if (this.type != 1) {
            return false;
        }
        try {
            return ((COM.hugin.HAPI.DiscreteChanceNode)this.getAPINode()).hasExperienceTable();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            return false;
        }
    }

    protected boolean hasFadingTable() {
        if (this.type != 1) {
            return false;
        }
        try {
            return ((COM.hugin.HAPI.DiscreteChanceNode)this.getAPINode()).hasFadingTable();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            return false;
        }
    }

    protected void deleteFadingTable() {
        if (this.type != 1) {
            return;
        }
        try {
            ((COM.hugin.HAPI.DiscreteChanceNode)this.getAPINode()).getFadingTable().delete();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    public boolean hasEvidence() throws ExceptionHugin {
        if (this.mode == 1) {
            return this.isDSepEvidence;
        }
        BeliefBarPanel beliefBarPanel = this.panel.projectFrame.getBeliefBarPanel();
        return !this.panel.isInEditMode() && (this instanceof DiscreteNode || this instanceof ContinuousChanceNode) && beliefBarPanel != null && beliefBarPanel.hasEvidence(this.getAPINode());
    }

    public boolean hasLikelihood() throws ExceptionHugin {
        if (this.mode == 1) {
            return false;
        }
        BeliefBarPanel beliefBarPanel = this.panel.projectFrame.getBeliefBarPanel();
        return !this.panel.isInEditMode() && this instanceof DiscreteNode && beliefBarPanel != null && beliefBarPanel.hasLikelihood(this.getAPINode());
    }

    protected boolean isSelected() {
        return this.selected;
    }

    protected static boolean isInput(COM.hugin.HAPI.Node node) {
        try {
            if (node.getHome() instanceof Class) {
                return node.getHomeClass().getInputs().contains(node);
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        return false;
    }

    protected static boolean isOutput(COM.hugin.HAPI.Node node) {
        try {
            if (node.getHome() instanceof Class) {
                return node.getHomeClass().getOutputs().contains(node);
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        return false;
    }

    protected boolean isOutputClone() {
        if (this.home instanceof Class) {
            for (Node node : this.panel.nodeList) {
                if (!(node instanceof InstanceNode) || !((InstanceNode)node).outputs.contains(this)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isInput() {
        return this.interfaceType == 1;
    }

    protected boolean isOutput() {
        return this.interfaceType == 2;
    }

    protected boolean isInterface() {
        return this.interfaceType == 1 || this.interfaceType == 2;
    }

    protected boolean isChance() {
        return this.type == 1 || this.type == 2;
    }

    protected boolean isEllipse() {
        return this.type == 1 || this.type == 2;
    }

    protected boolean isDiscrete() {
        return this.type == 1 || this.type == 4;
    }

    protected boolean isDiscreteChance() {
        return this.type == 1;
    }

    protected boolean isContinuousChance() {
        return this.type == 2;
    }

    protected boolean isDecision() {
        return this.type == 4;
    }

    protected boolean isUtility() {
        return this.type == 3;
    }

    protected boolean isInstance() {
        return this.type == 5;
    }

    protected boolean isRoundedRectangle() {
        return this.type == 5 && ((InstanceNode)this).isCollapsed();
    }

    protected boolean isDecisionOrUtility() {
        return this.type == 4 || this.type == 3;
    }

    protected boolean isPdagParent(Node node) throws ExceptionHugin {
        return node.apiNode.getPdagParents().contains(this.apiNode);
    }

    protected boolean sameTypeAs(Node node) {
        if (node == null || this.type != node.type) {
            return false;
        }
        if (this.isDiscrete()) {
            return ((DiscreteNode)((Object)this)).getSubtype() == ((DiscreteNode)((Object)node)).getSubtype();
        }
        return true;
    }

    protected boolean isBoolean() {
        return this instanceof DiscreteNode && ((DiscreteNode)((Object)this)).getSubtype() == 1;
    }

    protected boolean isNumbered() {
        return this instanceof DiscreteNode && ((DiscreteNode)((Object)this)).getSubtype() == 2;
    }

    protected boolean isInterval() {
        return this instanceof DiscreteNode && ((DiscreteNode)((Object)this)).getSubtype() == 3;
    }

    protected boolean canChangeInterfaceType() {
        return this.isDiscrete() && !this.hasBindings() && !this.isBound();
    }

    protected boolean canChangeType() {
        String string = null;
        try {
            string = this.home.getAttribute("HR_OOBN_CheckConsistency");
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
        if (string != null && string.equals("0")) {
            return this.isDiscrete();
        }
        return this.isDiscrete() && !this.hasBindings() && !this.isBound();
    }

    protected boolean canModifyStateLabels() {
        return this.canChangeType();
    }

    protected boolean canAddOrDeleteState() {
        String string = null;
        try {
            string = this.home.getAttribute("HR_OOBN_CheckConsistency");
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
        if (string != null && string.equals("0")) {
            return this.isDiscrete() && !this.isBoolean();
        }
        return this.isDiscrete() && !this.isBoolean() && !this.hasBindings() && !this.isBound();
    }

    protected boolean hasBindings() {
        if (!this.isInput()) {
            return false;
        }
        try {
            for (COM.hugin.HAPI.Node node : ((Class)this.home).getInstances()) {
                if (((COM.hugin.HAPI.InstanceNode)node).getInput(this.getAPINode()) == null) continue;
                return true;
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        return false;
    }

    private boolean isBound() {
        return this.isBound(null);
    }

    protected boolean isBound(InstanceNode instanceNode) {
        for (Link link : this.panel.linkList) {
            if (link.parent != this || link.child.host == null || instanceNode != null && link.child.host != instanceNode) continue;
            return true;
        }
        return this.isOutput() ? this.outputCloneIsBound() : false;
    }

    private boolean outputCloneIsBound() {
        if (this.home instanceof Class) {
            try {
                NodeList nodeList = ((Class)this.home).getInstances();
                for (COM.hugin.HAPI.Node node : nodeList) {
                    COM.hugin.HAPI.InstanceNode instanceNode = (COM.hugin.HAPI.InstanceNode)node;
                    NetworkPanel networkPanel = HuginGUIFrame.getNetworkPanel(instanceNode.getHome());
                    InstanceNode instanceNode2 = (InstanceNode)networkPanel.getNode(instanceNode);
                    if (!instanceNode2.getInterfaceNode(this).isBound()) continue;
                    return true;
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
        return false;
    }

    protected boolean consistentWith(Node node) {
        if (this.getAPINode().getClass() != node.getAPINode().getClass()) {
            return false;
        }
        if (this.isDiscrete()) {
            try {
                String string = "";
                String string2 = "";
                int n = ((DiscreteNode)((Object)node)).getSubtype();
                int n2 = ((DiscreteNode)((Object)this)).getSubtype();
                int n3 = ((COM.hugin.HAPI.DiscreteNode)this.getAPINode()).getNumberOfStates();
                int n4 = ((COM.hugin.HAPI.DiscreteNode)node.getAPINode()).getNumberOfStates();
                if (n3 != n4) {
                    return false;
                }
                COM.hugin.HAPI.Node node2 = this.getAPINode();
                COM.hugin.HAPI.Node node3 = node.getAPINode();
                if (node2 instanceof BooleanDCNode && !(node3 instanceof BooleanDCNode)) {
                    return false;
                }
                if (node2 instanceof BooleanDDNode && !(node3 instanceof BooleanDDNode)) {
                    return false;
                }
                if (n != 0) {
                    return true;
                }
                for (int i = 0; i < n3; ++i) {
                    if (this.type == 1) {
                        if (n2 == 0) {
                            string = ((COM.hugin.HAPI.DiscreteNode)this.getAPINode()).getStateLabel(i);
                            string2 = ((COM.hugin.HAPI.DiscreteNode)node.getAPINode()).getStateLabel(i);
                        }
                        if (n2 == 2) {
                            string = "" + ((NumberedDCNode)this.getAPINode()).getStateValue(i);
                            string2 = "" + ((NumberedDCNode)node.getAPINode()).getStateValue(i);
                        }
                        if (n2 == 3) {
                            string = ((IntervalDCNode)this.getAPINode()).getStateValue(i) + " - " + ((IntervalDCNode)this.getAPINode()).getStateValue(i + 1);
                            string2 = ((IntervalDCNode)node.getAPINode()).getStateValue(i) + " - " + ((IntervalDCNode)node.getAPINode()).getStateValue(i + 1);
                        }
                    } else {
                        if (n2 == 0) {
                            string = ((COM.hugin.HAPI.DiscreteNode)this.getAPINode()).getStateLabel(i);
                            string2 = ((COM.hugin.HAPI.DiscreteNode)node.getAPINode()).getStateLabel(i);
                        }
                        if (n2 == 2) {
                            string = "" + ((NumberedDDNode)this.getAPINode()).getStateValue(i);
                            string2 = "" + ((NumberedDDNode)node.getAPINode()).getStateValue(i);
                        }
                        if (n2 == 3) {
                            string = ((IntervalDDNode)this.getAPINode()).getStateValue(i) + " - " + ((IntervalDDNode)this.getAPINode()).getStateValue(i + 1);
                            string2 = ((IntervalDDNode)node.getAPINode()).getStateValue(i) + " - " + ((IntervalDDNode)node.getAPINode()).getStateValue(i + 1);
                        }
                    }
                    if (string.equals(string2)) continue;
                    return false;
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
        return true;
    }

    protected void displayTable() {
    }

    protected static LinkedList<Node> cloneNodeList(LinkedList<Node> linkedList) {
        LinkedList<Node> linkedList2 = new LinkedList<Node>(linkedList);
        for (int i = 0; i < linkedList.size(); ++i) {
            linkedList2.set(i, (Node)linkedList.get(i).clone());
        }
        return linkedList2;
    }

    protected void setInterfaceType() {
        this.interfaceType = Node.isInput(this.getAPINode()) ? 1 : (Node.isOutput(this.getAPINode()) ? 2 : 0);
        this.updateColor();
        this.setStroke();
    }

    protected void setInterfaceType(int n) throws ExceptionHugin {
        if (n == this.interfaceType) {
            return;
        }
        if (this.isInterface() && this.panel.checkForOOBNTrouble()) {
            return;
        }
        if (this.isInterface()) {
            this.removeLinks();
        }
        switch (n) {
            case 1: {
                if (this.isOutput()) {
                    this.getAPINode().removeFromOutputs();
                }
                this.getAPINode().addToInputs();
                break;
            }
            case 2: {
                if (this.isInput()) {
                    this.getAPINode().removeFromInputs();
                }
                this.getAPINode().addToOutputs();
                break;
            }
            case 0: {
                if (this.isInput()) {
                    this.getAPINode().removeFromInputs();
                    break;
                }
                if (!this.isOutput()) break;
                this.getAPINode().removeFromOutputs();
            }
        }
        this.updateInstances(n);
        this.interfaceType = n;
        this.updateColor();
        this.setStroke();
        this.repaint();
        this.panel.containsUnsavedChanges(true);
    }

    protected void removeLinks() throws ExceptionHugin {
        if (this.home instanceof Domain) {
            return;
        }
        for (COM.hugin.HAPI.Node node : ((Class)this.home).getInstances()) {
            COM.hugin.HAPI.InstanceNode instanceNode = (COM.hugin.HAPI.InstanceNode)node;
            NetworkPanel networkPanel = HuginGUIFrame.getNetworkPanel(instanceNode.getHome());
            InstanceNode instanceNode2 = (InstanceNode)networkPanel.getNode(instanceNode);
            if (this.isInput() && instanceNode.getInput(this.getAPINode()) != null) {
                networkPanel.repaint(this.unbind(instanceNode2));
                continue;
            }
            if (!this.isOutput()) continue;
            networkPanel.repaint(this.deleteCloneLinks(instanceNode2));
        }
    }

    protected void createInterfaceType() throws ExceptionHugin {
        this.setInterfaceType(this.cloneOf.cloneOf.interfaceType);
    }

    private void updateInstances(int n) throws ExceptionHugin {
        if (this.home instanceof Domain || this.home == null) {
            return;
        }
        for (COM.hugin.HAPI.Node node : ((Class)this.home).getInstances()) {
            COM.hugin.HAPI.InstanceNode instanceNode = (COM.hugin.HAPI.InstanceNode)node;
            NetworkPanel networkPanel = HuginGUIFrame.getNetworkPanel(instanceNode.getHome());
            InstanceNode instanceNode2 = (InstanceNode)networkPanel.getNode(instanceNode);
            Rectangle rectangle = new Rectangle(instanceNode2.boundingBox);
            rectangle.add(instanceNode2.update(this, n));
            networkPanel.repaint(rectangle);
        }
    }

    private void updateInstances(String string, String string2) throws ExceptionHugin {
        if (this.home instanceof Domain) {
            return;
        }
        NodeList nodeList = ((Class)this.home).getInstances();
        try {
            for (COM.hugin.HAPI.Node node : nodeList) {
                COM.hugin.HAPI.InstanceNode instanceNode = (COM.hugin.HAPI.InstanceNode)node;
                NetworkPanel networkPanel = HuginGUIFrame.getNetworkPanel(instanceNode.getHome());
                InstanceNode instanceNode2 = (InstanceNode)networkPanel.getNode(instanceNode);
                Node node2 = instanceNode2.getInterfaceNode(this);
                if (string.equals("name")) {
                    if (node2.isOutputClone()) {
                        node2.name = instanceNode2.getName() + "_" + string2;
                        node2.label = string2;
                    } else {
                        node2.name = string2;
                    }
                    if (node2.getAPINode() != null && node2.getAPINode() != this.getAPINode()) {
                        node2.getAPINode().setName(instanceNode2.getName() + "_" + string2);
                    }
                } else if (!node2.isOutputClone()) {
                    node2.label = string2;
                }
                networkPanel.repaint(node2);
            }
        }
        catch (ExceptionTwice exceptionTwice) {
            try {
                for (COM.hugin.HAPI.Node node : nodeList) {
                    COM.hugin.HAPI.InstanceNode instanceNode = (COM.hugin.HAPI.InstanceNode)node;
                    NetworkPanel networkPanel = HuginGUIFrame.getNetworkPanel(instanceNode.getHome());
                    InstanceNode instanceNode3 = (InstanceNode)networkPanel.getNode(instanceNode);
                    Node node3 = instanceNode3.getInterfaceNode(this);
                    node3.name = this.name;
                    if (node3.getAPINode() == null) continue;
                    node3.getAPINode().setName(instanceNode3.getName() + "_" + this.name);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw exceptionTwice;
        }
    }

    private Rectangle unbind(InstanceNode instanceNode) throws ExceptionHugin {
        COM.hugin.HAPI.Node node = ((COM.hugin.HAPI.InstanceNode)instanceNode.getAPINode()).getInput(this.getAPINode());
        if (node != null) {
            NetworkPanel networkPanel = HuginGUIFrame.getNetworkPanel(instanceNode.getAPINode().getHome());
            Link link = this.getBond(node, instanceNode);
            if (link != null) {
                networkPanel.linkList.remove(link);
                return link.kill();
            }
        }
        return new Rectangle();
    }

    private Rectangle deleteCloneLinks(InstanceNode instanceNode) throws ExceptionHugin {
        Rectangle rectangle = null;
        LinkedList<Link> linkedList = HuginGUIFrame.getNetworkPanel((NetworkModel)instanceNode.home).linkList;
        Node node = this.getOutputClone(instanceNode);
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            Link link = (Link)listIterator.next();
            if (link.parent != node) continue;
            if (rectangle == null) {
                rectangle = new Rectangle(link.kill());
            } else {
                rectangle.add(link.kill());
            }
            listIterator.remove();
        }
        return rectangle != null ? rectangle : new Rectangle();
    }

    protected Node getOutputClone(InstanceNode instanceNode) throws ExceptionHugin {
        for (Node node : instanceNode.outputs) {
            if (node.getAPINode().getMaster() != this.getAPINode()) continue;
            return node;
        }
        new HuginGUIError("Node.getOutPutClone", HuginGUIConstants.get("Output_clone_not_found") + "!");
        return null;
    }

    protected COM.hugin.HAPI.Node getOutputClone(COM.hugin.HAPI.Node node) throws ExceptionHugin {
        for (COM.hugin.HAPI.Node node2 : ((COM.hugin.HAPI.InstanceNode)node).getOutputs()) {
            if (node2.getMaster() != this.getAPINode()) continue;
            return node2;
        }
        new HuginGUIError("Node.getOutPutClone", HuginGUIConstants.get("Output_clone_not_found") + "!");
        return null;
    }

    private Link getBond(COM.hugin.HAPI.Node node, InstanceNode instanceNode) throws ExceptionHugin {
        NetworkPanel networkPanel = HuginGUIFrame.getNetworkPanel(node.getHome());
        Node node2 = networkPanel.getNode(node);
        Node node3 = networkPanel.getInputNode(this.apiNode, instanceNode);
        for (Link link : networkPanel.linkList) {
            if (link.parent != node2 || link.child != node3) continue;
            return link;
        }
        new HuginGUIError("Node.getBond", HuginGUIConstants.get("Bond_not_found"));
        return null;
    }

    protected LinkedList<Node> getChildren(boolean bl) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (Link link : this.panel.linkList) {
            Node node = link.parent.host == null ? link.parent : link.parent.host;
            if (node != this) continue;
            if (link.child.host == null) {
                linkedList.add(link.child);
                continue;
            }
            if (!bl) continue;
            linkedList.add(link.child.host);
        }
        return linkedList;
    }

    protected LinkedList<Node> getChildren() {
        return this.getChildren(false);
    }

    protected LinkedList<Node> getParents() {
        return this.getParents(false);
    }

    protected LinkedList<Node> getOriginalParents() {
        return this.getParents(true);
    }

    private LinkedList<Node> getParents(boolean bl) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (Link link : this.panel.linkList) {
            if (link.child != this) continue;
            if (bl && link.parent.cloneOf != null && link.parent.cloneOf.cloneOf != null) {
                linkedList.add(link.parent.cloneOf.cloneOf);
                continue;
            }
            linkedList.add(link.parent);
        }
        return linkedList;
    }

    protected String getName() {
        return this.name;
    }

    protected String getLabel() {
        return this.label;
    }

    protected static boolean nameIsLegal(String string) {
        return NetworkNamingPane.nameIsLegal(string);
    }

    protected static void illegalName(Component component) {
        NetworkNamingPane.illegalName(component, 4);
    }

    protected void setName(String string) throws ExceptionHugin {
        if (this.isInterface() && this.panel.checkForOOBNTrouble()) {
            return;
        }
        this.getAPINode().setName(string);
        if (this.isInterface()) {
            this.updateInstances("name", string);
        }
        if (!this.name.equals(string)) {
            this.panel.containsUnsavedChanges(true);
            this.name = string;
        }
        this.updateTable();
    }

    protected void setLabel(String string) throws ExceptionHugin {
        this.getAPINode().setLabel(string);
        if (this.interfaceType != 0) {
            this.updateInstances("label", string);
        }
        if (!this.label.equals(string)) {
            this.panel.containsUnsavedChanges(true);
            this.label = string;
        }
    }

    protected void setMonitorLocation(double d, boolean bl) {
        Point point;
        double d2 = this.monitor.getWidth();
        double d3 = this.monitor.getHeight();
        double d4 = this.monitor.getX();
        double d5 = this.monitor.getY();
        Point point2 = new Point((int)(d4 + d2 / d / 2.0), (int)(d5 + d3 / d / 2.0));
        Point point3 = point = bl ? new Point((int)(this.center.x / d), (int)(this.center.y / d)) : new Point((int)this.center.x, (int)this.center.y);
        if (point2.distance(point) < 10.0) {
            this.monitor.setLocation((int)(this.center.x - d2 / 2.0), (int)(this.center.y - d3 / 2.0));
        } else {
            if (this.monitorCenter == null) {
                this.monitorCenter = new Point2D.Double(d4 + d2 / 2.0, d5 + d3 / 2.0);
            }
            if (this.monitorCenter.distance(point2) > 10.0) {
                this.monitorCenter.setLocation(point2.x, point2.y);
            }
            if (bl) {
                this.monitor.setLocation((int)(d * d4), (int)(d * d5));
            } else {
                this.monitor.setLocation((int)(this.monitorCenter.x - d2 / 2.0), (int)(this.monitorCenter.y - d3 / 2.0));
            }
        }
    }

    protected void setMonitorLocation(boolean bl) {
        if (this.monitorLocation != null && !bl) {
            this.setMonitorLocation(this.monitorLocation);
        } else {
            this.monitorLocation = new Point((int)(this.center.x - (double)this.monitor.getWidth() / 2.0), (int)(this.center.y - (double)this.monitor.getHeight() / 2.0));
            this.setMonitorLocation(this.monitorLocation);
        }
        this.monitorLocation.x = Math.max(this.monitorLocation.x, 0);
        this.monitorLocation.y = Math.max(this.monitorLocation.y, 0);
    }

    protected Point getMonitorLocation() {
        return this.monitorLocation;
    }

    protected void setPoliciesWindowLocation(Point point) {
        this.policiesWindow.setLocation(point.x, point.y);
    }

    protected void setMonitorLocation(Point point) {
        this.monitor.setLocation(point.x, point.y);
        this.monitorLocation.setLocation(point);
    }

    protected void closeMonitor() {
        this.monitor.setVisible(false);
    }

    protected boolean directedPath(Node node, Link link) {
        for (Node node2 : this.panel.nodeList) {
            node2.marked = false;
        }
        return this.directedPathExists(node, link);
    }

    protected boolean directedPath(Node node) {
        for (Node node2 : this.panel.nodeList) {
            node2.marked = false;
        }
        return this.directedPathExists(node, null);
    }

    private boolean directedPathExists(Node node, Link link) {
        for (Node node2 : this.getChildren(true)) {
            if (node2.marked || link != null && link.parent == this && link.child == node2) continue;
            node2.marked = true;
            if (node2 != node && !node2.directedPathExists(node, link)) continue;
            return true;
        }
        return false;
    }

    protected Model getModel(NodeList nodeList) throws ExceptionHugin {
        if (this.table != null) {
            return this.table.getModel(nodeList);
        }
        return new Model(this.getAPINode(), nodeList);
    }

    protected int numberOfStates() {
        int n = 0;
        try {
            if (this.type == 1 || this.type == 4) {
                n = ((COM.hugin.HAPI.DiscreteNode)this.getAPINode()).getNumberOfStates();
            } else if (this.type == 2) {
                n = 2 + this.numberOfContinuousParents();
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        return n;
    }

    protected long numberOfParentStates() {
        if (this.isInstance()) {
            return 0L;
        }
        long l = 1L;
        try {
            for (COM.hugin.HAPI.Node node : this.apiNode.getParents()) {
                if (!(node instanceof COM.hugin.HAPI.DiscreteNode)) continue;
                l *= (long)((COM.hugin.HAPI.DiscreteNode)node).getNumberOfStates();
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        return l;
    }

    protected int numberOfContinuousParents() {
        int n = 0;
        try {
            for (COM.hugin.HAPI.Node node : this.apiNode.getParents()) {
                if (!(node instanceof COM.hugin.HAPI.ContinuousChanceNode)) continue;
                ++n;
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        return n;
    }

    protected int numberOfContinuousChildren() {
        int n = 0;
        try {
            for (COM.hugin.HAPI.Node node : this.apiNode.getChildren()) {
                if (!(node instanceof COM.hugin.HAPI.ContinuousChanceNode)) continue;
                ++n;
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        return n;
    }

    protected int numberOfDecisionChildren() {
        int n = 0;
        try {
            for (COM.hugin.HAPI.Node node : this.apiNode.getChildren()) {
                if (!(node instanceof COM.hugin.HAPI.DiscreteDecisionNode)) continue;
                ++n;
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        return n;
    }

    protected int numberOfDecisionParents() {
        int n = 0;
        try {
            for (COM.hugin.HAPI.Node node : this.apiNode.getParents()) {
                if (!(node instanceof COM.hugin.HAPI.DiscreteDecisionNode)) continue;
                ++n;
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        return n;
    }

    protected int numberOfUtilityChildren() {
        int n = 0;
        try {
            for (COM.hugin.HAPI.Node node : this.apiNode.getChildren()) {
                if (!(node instanceof COM.hugin.HAPI.UtilityNode)) continue;
                ++n;
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        return n;
    }

    protected int numberOfOutputChildren() {
        int n = 0;
        try {
            for (COM.hugin.HAPI.Node node : this.apiNode.getChildren()) {
                if (!Node.isOutput(node)) continue;
                ++n;
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        return n;
    }

    protected boolean canDoVOI() {
        return this instanceof DiscreteChanceNode;
    }

    protected boolean canDoDSeparation() {
        return !(this instanceof InstanceNode) && !(this instanceof DiscreteDecisionNode) && !(this instanceof UtilityNode);
    }

    protected boolean canBeAbsorbed() {
        if (!(this instanceof DiscreteChanceNode) || this.numberOfUtilityChildren() > 0 || this.numberOfDecisionChildren() > 0 || this.numberOfContinuousChildren() > 0) {
            return false;
        }
        if (this.isInput() || this.isBound()) {
            return false;
        }
        try {
            if (this.getAPINode().getAttribute("HR_CDVT_parent") != null) {
                return false;
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        return true;
    }

    protected long numberOfPdagParentStates() {
        long l = 1L;
        try {
            NodeList nodeList = this.apiNode.getPdagParents();
            for (COM.hugin.HAPI.Node node : nodeList) {
                l *= (long)((COM.hugin.HAPI.DiscreteNode)node).getNumberOfStates();
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        return l;
    }

    private long getCPTSize() {
        if (this.isUtility()) {
            return this.numberOfParentStates();
        }
        return (long)this.numberOfStates() * this.numberOfParentStates();
    }

    protected void cantCopyTable() {
        new JOptionPane();
        JOptionPane.showMessageDialog(this.panel, HuginGUIConstants.get("PASTE_TABLE_ERROR") + this.cloneOf.name, HuginGUIConstants.get("MISCELLANEOUS_Warning"), 0);
    }

    public void rereadPosition() throws ExceptionHugin {
        Point2D point2D = this.getAPINode().getPosition();
        this.moveTo(point2D.getX(), point2D.getY());
    }

    public String getString() {
        return this.label == null || this.label.equals("") ? this.name : this.label + " (" + this.name + ")";
    }

    public String getStringWithNoLineBreaks() {
        return this.getString().replace("\n", " ");
    }

    public String toString() {
        return this.getString();
    }

    public void reportSelection() {
        this.reportSelection(false);
    }

    public void reportSelection(boolean bl) {
        double d;
        Object object;
        Object object2;
        String string = this.getString() + " " + HuginGUIConstants.get("selected");
        boolean bl2 = false;
        try {
            object2 = this.getAPINode().getHome();
            bl2 = object2 instanceof Domain && ((Domain)object2).isCompiled() && ((Domain)object2).equilibriumIs(Domain.H_EQUILIBRIUM_SUM);
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
        object2 = "";
        object2 = this.isBoolean() ? HuginGUIConstants.get("NODE_PROPERTIES_boolean") : (this.isNumbered() ? HuginGUIConstants.get("NODE_PROPERTIES_numbered") : (this.isInterval() ? HuginGUIConstants.get("NODE_PROPERTIES_interval") : HuginGUIConstants.get("NODE_PROPERTIES_labelled")));
        if (this.isContinuousChance()) {
            string = string + " (" + HuginGUIConstants.get("Table_size") + " = " + this.getCPTSize() + ", " + HuginGUIConstants.get("type") + " = " + HuginGUIConstants.get("continuous");
            if (bl2) {
                try {
                    object = (COM.hugin.HAPI.ContinuousChanceNode)this.panel.projectFrame.beliefBars.getDomainNodeFor(this.getAPINode());
                    d = ((COM.hugin.HAPI.ContinuousChanceNode)object).getMean();
                    double d2 = ((COM.hugin.HAPI.ContinuousChanceNode)object).getVariance();
                    string = string + ", " + HuginGUIConstants.get("Avg") + " (" + this.getString() + ") = " + HuginGUIUtils.printDouble(d, this.panel.guiFrame.preferences.precision);
                    string = string + ", " + HuginGUIConstants.get("Var") + " (" + this.getString() + ") = " + HuginGUIUtils.printDouble(d2, this.panel.guiFrame.preferences.precision);
                }
                catch (ExceptionHugin exceptionHugin) {
                    new HuginGUIError(exceptionHugin.getMessage());
                }
            }
            string = string + ")";
        }
        if (this.isDiscreteChance()) {
            string = string + " (" + HuginGUIConstants.get("CPT_size") + " = " + this.getCPTSize() + ", " + HuginGUIConstants.get("type") + " = " + (String)object2 + ", " + HuginGUIConstants.get("states") + " = " + this.numberOfStates();
            if (bl && bl2) {
                object = (COM.hugin.HAPI.DiscreteChanceNode)this.panel.projectFrame.beliefBars.getDomainNodeFor(this.getAPINode());
                try {
                    d = ((COM.hugin.HAPI.DiscreteNode)object).getEntropy();
                    String string2 = HuginGUIUtils.printDouble(d, this.panel.guiFrame.preferences.precision);
                    string = string + ", H(" + this.getString() + ") = " + string2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl && bl2 && (this.isInterval() || this.isNumbered()) && !((Double)(object = HuginGUIUtils.average((COM.hugin.HAPI.DiscreteChanceNode)this.panel.projectFrame.beliefBars.getDomainNodeFor(this.getAPINode()), this.panel, true, this.getString()))).isNaN()) {
                string = string + ", " + HuginGUIConstants.get("Avg") + " (" + this.getString() + ") = " + HuginGUIUtils.printDouble((Double)object, this.panel.guiFrame.preferences.precision);
                Double d3 = HuginGUIUtils.variance((COM.hugin.HAPI.DiscreteChanceNode)this.panel.projectFrame.beliefBars.getDomainNodeFor(this.getAPINode()), this.panel);
                if (!d3.isNaN()) {
                    string = string + ", " + HuginGUIConstants.get("Var") + " (" + this.getString() + ") = " + HuginGUIUtils.printDouble(d3, this.panel.guiFrame.preferences.precision);
                }
            }
            string = string + ")";
        }
        if (this.isDecision()) {
            string = string + " (" + HuginGUIConstants.get("Policy_size") + " = " + this.getCPTSize() + ", " + HuginGUIConstants.get("type") + " = " + (String)object2 + ", " + HuginGUIConstants.get("states") + " = " + this.numberOfStates() + ")";
        }
        if (this.isUtility()) {
            string = string + " (" + HuginGUIConstants.get("Utility_function_size") + " = " + this.getCPTSize() + ")";
        }
        this.panel.writeStatus(string);
    }

    protected boolean setNormalMode() {
        boolean bl = this.mode != 0;
        this.mode = 0;
        this.isDSepEvidence = false;
        this.setEnabled(true);
        this.highLightColor = Color.black;
        this.setStroke();
        return bl;
    }

    protected boolean isDseparated() {
        return this.dSeparated;
    }

    protected boolean setDSepMode(boolean bl) {
        boolean bl2 = this.mode != 1;
        this.mode = 1;
        this.highLightColor = bl ? Color.red : Color.green;
        this.setStroke();
        return bl2;
    }

    protected void setMinimizeLimidMode(boolean bl) {
        this.mode = bl ? 3 : 4;
        this.highLightColor = bl ? Color.green : Color.red;
    }

    protected boolean setMarkovBlanketMode(boolean bl) {
        boolean bl2 = this.mode != 2;
        this.mode = 2;
        this.highLightColor = bl ? Color.green : Color.red;
        this.setStroke();
        return bl2;
    }

    protected void setDSeparated(boolean bl, boolean bl2) throws ExceptionHugin {
        this.setEnabled(true);
        this.dSeparated = bl;
        this.isDSepEvidence = bl2;
        this.setDSepMode(bl);
    }

    public void setEnabled(boolean bl) {
        if (this.enabled == bl) {
            return;
        }
        if (!bl) {
            this.oldText = this.textColor;
            this.textColor = Color.gray;
            this.actualFillColor = Color.white;
        } else if (this.oldText != null) {
            this.actualFillColor = this.fillColor;
            this.textColor = this.oldText;
        }
        this.enabled = bl;
    }

    @Override
    public int compareTo(Node node) {
        return this.getName().compareTo(node.getName());
    }

    protected boolean giveAbsorbWarning() {
        try {
            if (this.getAPINode().getModel() != null || this.getAPINode() instanceof COM.hugin.HAPI.DiscreteChanceNode && (((COM.hugin.HAPI.DiscreteChanceNode)this.getAPINode()).hasExperienceTable() || ((COM.hugin.HAPI.DiscreteChanceNode)this.getAPINode()).hasFadingTable())) {
                return true;
            }
            for (Node node : this.getChildren()) {
                if (node.getAPINode().getModel() == null && (!(node.getAPINode() instanceof COM.hugin.HAPI.DiscreteChanceNode) || !((COM.hugin.HAPI.DiscreteChanceNode)node.getAPINode()).hasExperienceTable() && !((COM.hugin.HAPI.DiscreteChanceNode)node.getAPINode()).hasFadingTable())) continue;
                return true;
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        return false;
    }

    public LinkedList<Link> absorb() throws ExceptionHugin {
        if (this.giveAbsorbWarning() && JOptionPane.showConfirmDialog(Hugin.mainFrame, HuginGUIConstants.get("MENU_EDIT_Reverse_will_erase"), HuginGUIConstants.get("MISCELLANEOUS_Warning"), 0) == 1) {
            return null;
        }
        LinkedList<Link> linkedList = new LinkedList<Link>();
        for (Link object : this.panel.linkList) {
            Node node = object.parent.host == null ? object.parent : object.parent.host;
            if (node != this || object.child.host != null) continue;
            linkedList.add(object);
        }
        LinkedList linkedList2 = new LinkedList();
        linkedList2.addAll(linkedList);
        try {
            while (linkedList.size() > 0) {
                ListIterator listIterator = linkedList.listIterator();
                while (listIterator.hasNext()) {
                    int n = ((Link)listIterator.next()).reverse(linkedList2, false);
                    if (n == 0) {
                        listIterator.remove();
                    }
                    if (n != -1) continue;
                    linkedList2.add(null);
                    return linkedList2;
                }
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        return linkedList2;
    }

    public LinkedList<Link> getAllLinks() {
        LinkedList<Link> linkedList = new LinkedList<Link>();
        for (Link link : this.panel.linkList) {
            Node node;
            Node node2 = node = link.child.host == null ? link.child : link.child.host;
            if (node == this) {
                linkedList.add(link);
                continue;
            }
            Node node3 = link.parent.host == null ? link.parent : link.parent.host;
            if (node3 != this) continue;
            linkedList.add(link);
        }
        return linkedList;
    }

    protected class BoundingBox
    extends Rectangle {
        protected static final int maxPenSize = 9;

        public BoundingBox(double d, double d2, double d3, double d4) {
            this.setBounds((int)d, (int)d2, (int)d3, (int)d4);
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            int n5 = 9;
            int n6 = 2 * n5;
            super.setBounds(n - n5, n2 - n5, n3 + n6, n4 + n6);
        }

        public void setBounds(double d, double d2, double d3, double d4) {
            this.setBounds((int)d, (int)d2, (int)d3, (int)d4);
        }

        public Rectangle getBounds(boolean bl) {
            if (!bl) {
                return super.getBounds();
            }
            int n = 9;
            int n2 = 2 * n;
            return new Rectangle(this.x + n, this.y + n, this.width - n2, this.height - n2);
        }

        public void setLocation(double d, double d2) {
            int n = 9;
            super.setLocation((int)d - n, (int)d2 - n);
        }

        public void setSize(double d, double d2) {
            int n = 18;
            super.setSize((int)(d + (double)n), (int)(d2 + (double)n));
        }
    }
}

