/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import java.awt.Color;

public class NodeGroup {
    public Color color;
    public int colorIndex;
    private int id;
    public String name;
    private String description;
    private static int[] r = new int[]{255, 192, 128, 0};
    private static int[] g = new int[]{255, 192, 128, 0};
    private static int[] b = new int[]{255, 192, 128, 0};
    private static final int MAX_COLORS = 64;

    public NodeGroup() {
    }

    public NodeGroup(String string, int n) {
        this.name = string;
        this.colorIndex = -1;
        this.color = null;
        this.id = n;
        this.description = "";
    }

    public NodeGroup(String string, int n, int n2) {
        this(string, n2);
        this.colorIndex = n;
        this.color = NodeGroup.index2color(n);
    }

    public NodeGroup(int n, String string, Color color) {
        this(string, n);
        this.color = color;
    }

    public NodeGroup(NodeGroup nodeGroup) {
        this.name = nodeGroup.name;
        this.color = nodeGroup.color;
        this.colorIndex = nodeGroup.colorIndex;
        this.id = nodeGroup.id;
        this.description = nodeGroup.description;
    }

    public String toString() {
        return this.name;
    }

    public void setID(int n) {
        this.id = n;
    }

    public int getID() {
        return this.id;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setColorIndex(int n) {
        this.colorIndex = n;
        this.color = NodeGroup.index2color(n);
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public static Color index2color(int n) {
        if (n < 0 || n >= 64) {
            return new Color(r[0], g[0], b[0]);
        }
        int n2 = n / 16;
        int n3 = (n - n2 * 16) / 4;
        int n4 = n - n2 * 16 - n3 * 4;
        return new Color(r[n3], g[n4], b[n2]);
    }

    public static int color2index(Color color) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = color.getRed();
        int n5 = color.getGreen();
        int n6 = color.getBlue();
        for (int i = 0; i < 4; ++i) {
            if (n4 == r[i]) {
                n = i;
            }
            if (n5 == g[i]) {
                n2 = i;
            }
            if (n6 != b[i]) continue;
            n3 = i;
        }
        if (n == -1 || n2 == -1 || n3 == -1) {
            return -1;
        }
        return n3 * 16 + n * 4 + n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof NodeGroup)) {
            return false;
        }
        return ((NodeGroup)object).getID() == this.id;
    }
}

