/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Attribute;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionInvalidExpression;
import COM.hugin.HAPI.ExceptionObjectNotAlive;
import COM.hugin.HAPI.Expression;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HAPI.IntervalDDNode;
import COM.hugin.HAPI.Model;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.NumberedDCNode;
import COM.hugin.HAPI.NumberedDDNode;
import COM.hugin.HAPI.Table;
import COM.hugin.HGUI.ChanceNode;
import COM.hugin.HGUI.ContinuousChanceNode;
import COM.hugin.HGUI.DiscreteNode;
import COM.hugin.HGUI.ExpressionTableModel;
import COM.hugin.HGUI.FunctionNode;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.UtilityNode;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeInformation {
    private static final int NO_SUBTYPE = -1;
    private Node node;
    private int type;
    private int subtype = -1;
    private LinkedList<Node> parents = null;
    protected LinkedList<Node> modelNodes = null;
    private String[] modelNodeMap;
    private String[] expressions = null;
    private long numberOfParentStates = -1L;
    private int numberOfContinuousParents = -1;
    private String[] stateNames = null;
    private double[] stateValues = null;
    private int cardinality = -1;
    private double[] data = null;
    private double[] alpha = null;
    private double[] gamma = null;
    private BetaList beta = null;
    private String[][] attributes = null;
    private String specialSize = null;

    public NodeInformation(Node node) throws ExceptionHugin {
        this.node = node;
        this.type = node.type;
        if (node.isDiscrete()) {
            this.storeSubtype();
            this.storeStates();
        }
        this.numberOfParentStates = node.numberOfParentStates();
        if (node.isContinuousChance()) {
            this.numberOfContinuousParents = ((ContinuousChanceNode)node).numberOfContinuousParents();
        }
        try {
            Object object;
            if (node instanceof ChanceNode || node instanceof UtilityNode) {
                this.parents = new LinkedList();
                for (COM.hugin.HAPI.Node node2 : node.getAPINode().getTable().getNodes()) {
                    object = node.panel.getNode(node2);
                    if (object.equals(node)) continue;
                    this.parents.add((Node)object);
                }
            } else {
                this.parents = node.getParents();
            }
            LinkedList<Attribute> linkedList = node.getAPINode().getAttributes();
            this.attributes = new String[linkedList.size()][2];
            int n = 0;
            object = linkedList.iterator();
            while (object.hasNext()) {
                Attribute attribute = (Attribute)object.next();
                this.attributes[n][0] = attribute.getKey();
                this.attributes[n][1] = attribute.getValue();
                ++n;
            }
            this.specialSize = node.getAPINode().getAttribute("HR_NodeSize");
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        if (!node.isInstance()) {
            this.storeTable();
        }
    }

    private void storeSubtype() {
        this.subtype = ((DiscreteNode)((Object)this.node)).getSubtype();
    }

    private void storeStates() {
        COM.hugin.HAPI.Node node = this.node.getAPINode();
        this.cardinality = ((DiscreteNode)((Object)this.node)).getNumberOfStates();
        if (node instanceof IntervalDCNode || node instanceof IntervalDDNode) {
            ++this.cardinality;
        }
        this.stateNames = ((DiscreteNode)((Object)this.node)).getStates();
        if (this.node.isDiscrete()) {
            try {
                this.stateValues = new double[this.cardinality];
                for (int i = 0; i < this.cardinality; ++i) {
                    if (node instanceof NumberedDCNode) {
                        this.stateValues[i] = ((NumberedDCNode)node).getStateValue(i);
                        continue;
                    }
                    if (node instanceof IntervalDCNode) {
                        this.stateValues[i] = ((IntervalDCNode)node).getStateValue(i);
                        continue;
                    }
                    if (node instanceof NumberedDDNode) {
                        this.stateValues[i] = ((NumberedDDNode)node).getStateValue(i);
                        continue;
                    }
                    if (!(node instanceof IntervalDDNode)) continue;
                    this.stateValues[i] = ((IntervalDDNode)node).getStateValue(i);
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
    }

    private void storeTable() {
        if (this.node.isInstance()) {
            return;
        }
        try {
            Object var1_1 = null;
            if ((this.node.isDecision() || this.node.isDiscreteChance() || this.node.isUtility() || this.node instanceof FunctionNode) && this.node.getAPINode().getModel() != null) {
                this.storeModel();
                return;
            }
            if (this.node.isDecision() || this.node.isDiscreteChance() || this.node.isUtility()) {
                this.data = this.node.getAPINode().getTable().getData();
            }
            if (this.node.isContinuousChance()) {
                this.storeContinuousData();
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    private void storeModel() throws ExceptionHugin {
        Model model = this.node.getAPINode().getModel();
        this.modelNodes = new LinkedList();
        for (Object object : model.getNodes()) {
            this.modelNodes.add(this.node.panel.getNode((COM.hugin.HAPI.Node)object));
        }
        this.expressions = new String[model.getSize()];
        for (int i = 0; i < this.expressions.length; ++i) {
            Object object;
            object = model.getExpression(i);
            this.expressions[i] = object != null ? ((Expression)object).expressionToString() : "";
        }
    }

    private void storeContinuousData() {
        ContinuousChanceNode continuousChanceNode = (ContinuousChanceNode)this.node;
        COM.hugin.HAPI.ContinuousChanceNode continuousChanceNode2 = (COM.hugin.HAPI.ContinuousChanceNode)this.node.getAPINode();
        try {
            NodeList nodeList = continuousChanceNode.getContinuousParents();
            this.alpha = new double[(int)this.numberOfParentStates];
            this.gamma = new double[(int)this.numberOfParentStates];
            this.beta = new BetaList();
            int n = 0;
            while ((long)n < this.numberOfParentStates) {
                this.alpha[n] = continuousChanceNode2.getAlpha(n);
                this.gamma[n] = continuousChanceNode2.getGamma(n);
                for (COM.hugin.HAPI.Node node : nodeList) {
                    COM.hugin.HAPI.ContinuousChanceNode continuousChanceNode3 = (COM.hugin.HAPI.ContinuousChanceNode)node;
                    this.beta.add(new Beta(continuousChanceNode3, n, continuousChanceNode2.getBeta(continuousChanceNode3, n)));
                }
                ++n;
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    protected void setModelNodeMap(String[] stringArray) {
        this.modelNodeMap = stringArray;
    }

    protected void restore(Node node) {
        int n;
        int n2 = n = node.isDiscrete() ? ((DiscreteNode)((Object)node)).getSubtype() : -1;
        if (node.type != this.type || n != this.subtype) {
            return;
        }
        if (node.isDiscrete()) {
            this.restoreSubtype(node);
        }
        try {
            COM.hugin.HAPI.Node node2 = node.getAPINode();
            if (!node.isInstance()) {
                if (node instanceof FunctionNode) {
                    if (node2.getModel() != null && this.expressions != null) {
                        this.restoreExpressions(node);
                    }
                } else if ((node.isDecision() || node.isUtility() || node.isDiscreteChance()) && node2.getModel() == null || node.isContinuousChance()) {
                    this.restoreTable(node);
                } else {
                    this.restoreExpressions(node);
                }
            }
            for (int i = 0; i < this.attributes.length; ++i) {
                node2.setAttribute(this.attributes[i][0], this.attributes[i][1]);
            }
            if (this.specialSize != null) {
                node.setSpecialSize(this.specialSize);
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(HuginGUIConstants.get("str_unable_to_copy_table_") + exceptionHugin.getMessage());
        }
    }

    protected void restoreCardinality(Node node) throws ExceptionHugin {
        if (node.isDiscrete() && this.subtype != 1) {
            this.restoreStates(node);
        }
    }

    private void restoreSubtype(Node node) {
        ((DiscreteNode)((Object)node)).setSubtype(this.subtype);
    }

    private void restoreStates(Node node) throws ExceptionHugin {
        COM.hugin.HAPI.Node node2 = node.getAPINode();
        int n = 0;
        if (node2 instanceof IntervalDCNode || node2 instanceof IntervalDDNode) {
            n = 1;
        }
        if (node.isDiscreteChance()) {
            ((COM.hugin.HAPI.DiscreteNode)node2).setNumberOfStates(this.cardinality - n);
            for (int i = 0; i < this.cardinality - n; ++i) {
                ((COM.hugin.HAPI.DiscreteNode)node2).setStateLabel(i, this.stateNames[i]);
                if (node2 instanceof NumberedDCNode) {
                    ((NumberedDCNode)node2).setStateValue(i, this.stateValues[i]);
                    continue;
                }
                if (!(node2 instanceof IntervalDCNode)) continue;
                ((IntervalDCNode)node2).setStateValue(i, this.stateValues[i]);
            }
            if (node2 instanceof IntervalDCNode) {
                ((IntervalDCNode)node2).setStateValue(this.cardinality - 1, this.stateValues[this.cardinality - 1]);
            }
        } else if (node.isDecision()) {
            ((COM.hugin.HAPI.DiscreteNode)node2).setNumberOfStates(this.cardinality - n);
            for (int i = 0; i < this.cardinality - n; ++i) {
                ((COM.hugin.HAPI.DiscreteNode)node2).setStateLabel(i, this.stateNames[i]);
                if (node2 instanceof NumberedDDNode) {
                    ((NumberedDDNode)node2).setStateValue(i, this.stateValues[i]);
                    continue;
                }
                if (!(node2 instanceof IntervalDDNode)) continue;
                ((IntervalDDNode)node2).setStateValue(i, this.stateValues[i]);
            }
            if (node2 instanceof IntervalDDNode) {
                ((IntervalDDNode)node2).setStateValue(this.cardinality - 1, this.stateValues[this.cardinality - 1]);
            }
        }
    }

    private void restoreTable(Node node) {
        if (this.numberOfParentStates != node.numberOfParentStates()) {
            node.cantCopyTable();
            return;
        }
        try {
            Table table;
            if (node.isDecision() || node.isDiscreteChance()) {
                table = node.getAPINode().getTable();
                NodeList nodeList = this.createFamilyList(node);
                table.reorderNodes(nodeList);
                table.setData(this.data);
            } else if (node.isContinuousChance()) {
                if (this.numberOfContinuousParents != ((ContinuousChanceNode)node).numberOfContinuousParents()) {
                    node.cantCopyTable();
                    return;
                }
                this.restoreContinuousData((ContinuousChanceNode)node);
            }
            if (node.isUtility()) {
                table = node.getAPINode().getTable();
                table.reorderNodes(this.createFamilyList(node));
                table.setData(this.data);
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    private void restoreExpressions(Node node) throws ExceptionHugin {
        Model model = node.getAPINode().getModel();
        if (model.getSize() != this.expressions.length) {
            new HuginGUIError(HuginGUIConstants.get("str_unable_to_copy_expressions"));
            return;
        }
        for (int i = 0; i < this.expressions.length; ++i) {
            try {
                if (this.expressions[i].length() <= 0) continue;
                model.setExpression(i, Expression.stringToExpression(this.mapExpression(this.expressions[i], this.modelNodeMap), model, null));
                continue;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                try {
                    model.setExpression(i, ExpressionTableModel.createValidExpression(this.mapExpression(this.expressions[i], this.modelNodeMap)));
                    continue;
                }
                catch (UnableToMapException unableToMapException) {
                    new HuginGUIError(HuginGUIConstants.get("str_unable_to_copy_expressions"));
                    return;
                }
            }
            catch (UnableToMapException unableToMapException) {
                new HuginGUIError(HuginGUIConstants.get("str_unable_to_copy_expressions"));
                return;
            }
        }
    }

    private String mapExpression(String string, String[] stringArray) throws UnableToMapException {
        for (int i = 0; i < stringArray.length / 2; ++i) {
            if (string == null || stringArray[i * 2] == null) {
                throw new UnableToMapException(HuginGUIConstants.get("str_could_not_map_") + string);
            }
            int n = string.indexOf(stringArray[i * 2]);
            while (n >= 0) {
                int n2 = n + stringArray[i * 2].length();
                if ((n == 0 || this.isSeparator(string.charAt(n - 1))) && (n2 >= string.length() - 1 || this.isSeparator(string.charAt(n2 + 1)))) {
                    string = string.substring(0, n) + stringArray[i * 2 + 1] + string.substring(n2);
                    n2 = n + stringArray[i * 2 + 1].length();
                }
                if (string == null || stringArray[i * 2] == null) {
                    throw new UnableToMapException(HuginGUIConstants.get("str_could_not_map_") + string);
                }
                n = string.indexOf(stringArray[i * 2], n2 + 1);
            }
        }
        return string;
    }

    private boolean isSeparator(char c) {
        return !Character.isLetterOrDigit(c) && c != '_';
    }

    private NodeList createFamilyList(Node node) throws ExceptionHugin {
        NodeList nodeList = new NodeList();
        try {
            COM.hugin.HAPI.Node node2 = node.getAPINode();
            NodeList nodeList2 = node2.getParents();
            if (node.isContinuousChance()) {
                boolean bl = false;
                for (Node node3 : this.parents) {
                    COM.hugin.HAPI.Node node4 = this.getNode(node3, node.getParents());
                    if (node3.isContinuousChance() && !bl) {
                        bl = true;
                        nodeList.add(node2);
                    }
                    nodeList.add(node4);
                }
                if (!bl) {
                    nodeList.add(node2);
                }
            } else {
                for (Node node5 : this.parents) {
                    nodeList.add(this.getNode(node5, node.getParents()));
                }
                if (!(node instanceof UtilityNode)) {
                    nodeList.add(node2);
                }
            }
        }
        catch (ExceptionObjectNotAlive exceptionObjectNotAlive) {
            new HuginGUIError(exceptionObjectNotAlive);
        }
        return nodeList;
    }

    private COM.hugin.HAPI.Node getNode(Node node, LinkedList<Node> linkedList) {
        for (Node node2 : linkedList) {
            if (!node2.getName().equals(node.getName())) continue;
            return node2.getAPINode();
        }
        for (Node node2 : linkedList) {
            if (node2.cloneOf == null || !node2.cloneOf.getName().equals(node.getName())) continue;
            return node2.getAPINode();
        }
        new HuginGUIError("NodeInformation.getCloneOfNode", HuginGUIConstants.get("str_node_name_not_recognized"));
        return null;
    }

    private COM.hugin.HAPI.Node getNode(Node node, NodeList nodeList) {
        try {
            String string = node.name;
            int n = nodeList.indexOf(node.getAPINode());
            if (n >= 0) {
                return (COM.hugin.HAPI.Node)nodeList.get(n);
            }
            for (COM.hugin.HAPI.Node node2 : nodeList) {
                if (!this.isCloneOf(node2, string)) continue;
                return node2;
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
            return null;
        }
        new HuginGUIError("NodeInformation.getNode", HuginGUIConstants.get("str_node_name_not_recognized"));
        return null;
    }

    private boolean isCloneOf(COM.hugin.HAPI.Node node, COM.hugin.HAPI.Node node2) throws ExceptionHugin {
        return this.isCloneOf(node, node2.getName());
    }

    private boolean isCloneOf(COM.hugin.HAPI.Node node, String string) throws ExceptionHugin {
        String string2 = node.getName();
        if (node.getMaster() == null) {
            int n = string2.indexOf(string);
            return n >= 0 && (string2.equals(string) || string2.lastIndexOf(95, string.length()) == string.length());
        }
        String string3 = string.substring(string.lastIndexOf(95) + 1);
        if (string.lastIndexOf(string3) - 1 < 0) {
            return false;
        }
        return string3.equals(string2.substring(string2.lastIndexOf(95) + 1)) && string2.startsWith(string.substring(0, string.lastIndexOf(string3) - 1));
    }

    private void restoreContinuousData(ContinuousChanceNode continuousChanceNode) {
        COM.hugin.HAPI.ContinuousChanceNode continuousChanceNode2 = (COM.hugin.HAPI.ContinuousChanceNode)continuousChanceNode.getAPINode();
        try {
            NodeList nodeList = continuousChanceNode.getContinuousParents();
            int n = 0;
            while ((long)n < this.numberOfParentStates) {
                continuousChanceNode2.setAlpha(this.alpha[n], n);
                continuousChanceNode2.setGamma(this.gamma[n], n);
                for (COM.hugin.HAPI.Node node : nodeList) {
                    COM.hugin.HAPI.ContinuousChanceNode continuousChanceNode3 = (COM.hugin.HAPI.ContinuousChanceNode)node;
                    continuousChanceNode2.setBeta(this.beta.getValue(continuousChanceNode3, n), continuousChanceNode3, n);
                }
                ++n;
            }
            continuousChanceNode2.getTable().reorderNodes(this.createFamilyList(continuousChanceNode));
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    protected LinkedList<Node> getParents() throws ExceptionHugin {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (Node node : this.parents) {
            if (!node.getAPINode().isAlive()) continue;
            linkedList.add(node);
        }
        return linkedList;
    }

    private class UnableToMapException
    extends Exception {
        public UnableToMapException(String string) {
            super(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BetaList
    extends LinkedList<Beta> {
        private BetaList() {
        }

        public double getValue(COM.hugin.HAPI.ContinuousChanceNode continuousChanceNode, int n) throws ExceptionHugin {
            for (Beta beta : this) {
                if (!NodeInformation.this.isCloneOf(continuousChanceNode, beta.parentID) || beta.index != n) continue;
                return beta.value;
            }
            return 1.0;
        }
    }

    private class Beta {
        int index;
        double value;
        String parentID;

        public Beta(COM.hugin.HAPI.ContinuousChanceNode continuousChanceNode, int n, double d) throws ExceptionHugin {
            this.parentID = continuousChanceNode.getName();
            this.index = n;
            this.value = d;
        }
    }
}

