/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.InstanceNode;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Vector;

public class NodeLayout {
    static int hgap = 20;
    static int vgap = 20;
    private static final int NODE_HEIGHT = 40;
    private static final int NODE_WIDTH = 80;
    static int[] levelWidth;
    static int[] levelHeight;
    public static final int TREE_LAYOUT = 0;
    public static final int DOT_LAYOUT = 1;

    public static void layoutNodes(NetworkModel networkModel) throws ExceptionHugin {
        for (Node node : networkModel.getNodes()) {
            for (Node node2 : node.getChildren()) {
                String string = node2.getName();
                if (node.getMaster() != null) {
                    String string2 = node.getName();
                    HuginGUIUtils.setLinkControlPointsInstance(node.getInstance(), string2, string, null);
                    HuginGUIUtils.setLinkModeInstance(node.getInstance(), string2, string, null);
                    continue;
                }
                HuginGUIUtils.setLinkControlPoints(node, string, null);
                HuginGUIUtils.setLinkMode(node, string, null);
            }
        }
        NodeLayout.layoutNodes(networkModel, Hugin.mainFrame.preferences.layout_mode == 1 ? 0 : 1);
    }

    public static void layoutNodes(NetworkModel networkModel, int n) throws ExceptionHugin {
        switch (n) {
            case 0: {
                NodeLayout.treeLayout(networkModel);
                break;
            }
            case 1: {
                try {
                    NodeLayout.useDot(networkModel);
                    break;
                }
                catch (Exception exception) {
                    new HuginGUIError(HuginGUIConstants.get("str_unable_to_complete_graph_layout_using_dot_lb") + exception.getMessage() + HuginGUIConstants.get("str_lb_trying_internal_layout_algorithm"));
                    try {
                        NodeLayout.treeLayout(networkModel);
                        break;
                    }
                    catch (Exception exception2) {
                        new HuginGUIError(HuginGUIConstants.get("str_unable_to_perform_any_graph_layout"));
                    }
                }
            }
        }
        HuginProjectFrame.flipNet(networkModel);
    }

    public static void treeLayout(NetworkModel networkModel) throws ExceptionHugin {
        Vector<NodeHolder> vector = new Vector<NodeHolder>();
        NodeList nodeList = networkModel.getNodes();
        for (Node node : nodeList) {
            node.setUserData(null);
        }
        for (Node node : nodeList) {
            if (node.getUserData() != null) continue;
            NodeHolder nodeHolder = new NodeHolder(node);
            nodeHolder.setRoot(true);
            vector.add(nodeHolder);
        }
        NodeHolder nodeHolder = new NodeHolder(vector);
        int n = NodeLayout.getDepth(nodeHolder);
        int n2 = 0;
        if (levelWidth == null || n != n2) {
            levelWidth = new int[n];
            levelHeight = new int[n];
            n2 = n;
        }
        nodeHolder.optimize();
        for (int i = 0; i < n; ++i) {
            NodeLayout.levelWidth[i] = 80;
            NodeLayout.levelHeight[i] = 0;
        }
        NodeLayout.layoutTree(nodeHolder, 0, 0);
        for (Node node : networkModel.getNodes()) {
            node.setUserData(null);
        }
        NodeLayout.alignNet(networkModel);
    }

    public static int getDepth(NodeHolder nodeHolder) throws ExceptionHugin {
        Vector<NodeHolder> vector = nodeHolder.getChildren();
        if (vector == null || vector.size() == 0) {
            return 1;
        }
        int n = 0;
        for (NodeHolder nodeHolder2 : vector) {
            if (!nodeHolder2.hasParent(nodeHolder)) continue;
            n = Math.max(n, NodeLayout.getDepth(nodeHolder2));
        }
        return n + 1;
    }

    public static int layoutTree(NodeHolder nodeHolder, int n, int n2) throws ExceptionHugin {
        boolean bl;
        int n3;
        int n4 = n3 = levelWidth[nodeHolder.getLevel()] > 0 ? levelWidth[nodeHolder.getLevel()] + hgap : 0;
        if (n < n3) {
            n = n3;
        }
        if (n3 == 0) {
            n = 0;
        }
        n = n3;
        int n5 = nodeHolder.getSize().width + n;
        Vector<NodeHolder> vector = nodeHolder.getChildren();
        boolean bl2 = bl = vector != null && vector.size() > 0;
        if (!bl) {
            NodeLayout.updateLevelWidth(nodeHolder.getLevel(), n5);
            nodeHolder.setPosition(new Point(n, n2));
            return n5;
        }
        int n6 = n;
        int n7 = n2;
        NodeLayout.levelHeight[nodeHolder.getLevel()] = Math.max(levelHeight[nodeHolder.getLevel()], n2);
        bl = false;
        n2 = levelHeight[nodeHolder.getLevel()] + vgap + 40;
        for (NodeHolder nodeHolder2 : nodeHolder.getChildren()) {
            if (!nodeHolder2.hasParent(nodeHolder)) continue;
            n5 = Math.max(n5, NodeLayout.layoutTree(nodeHolder2, n, 100 * nodeHolder2.getLevel()));
            int n8 = n + (n5 - (n + nodeHolder2.getSize().width)) / 2 - n;
            n = nodeHolder2.getSize().width + hgap + n8;
            bl = true;
        }
        if (!bl) {
            NodeLayout.updateLevelWidth(nodeHolder.getLevel(), n5);
            nodeHolder.setPosition(new Point(n, n7));
            return n5;
        }
        n = NodeLayout.getSubTreeCenter(nodeHolder) - nodeHolder.getSize().width / 2;
        if (n < n3) {
            NodeLayout.translate(nodeHolder, n3 - n, nodeHolder.getLevel());
            nodeHolder.setPosition(new Point(n3, n7));
            NodeLayout.updateLevelWidth(nodeHolder.getLevel(), n3 + nodeHolder.getSize().width);
        } else {
            nodeHolder.setPosition(new Point(n, n7));
            NodeLayout.updateLevelWidth(nodeHolder.getLevel(), n + nodeHolder.getSize().width);
        }
        return n5;
    }

    private static void updateLevelWidth(int n, int n2) {
        NodeLayout.levelWidth[n] = n2;
    }

    public static int getSubTreeCenter(NodeHolder nodeHolder) throws ExceptionHugin {
        NodeHolder nodeHolder2;
        Vector<NodeHolder> vector = nodeHolder.getChildren();
        if (vector == null) {
            return nodeHolder.getPosition().x + nodeHolder.getSize().width / 2;
        }
        boolean bl = false;
        Iterator<NodeHolder> iterator = vector.iterator();
        while (iterator.hasNext() && !(bl = (nodeHolder2 = iterator.next()).hasParent(nodeHolder))) {
        }
        if (!bl) {
            return nodeHolder.getPosition().x + nodeHolder.getSize().width / 2;
        }
        int n = 10000000;
        int n2 = 0;
        for (NodeHolder nodeHolder3 : vector) {
            if (!nodeHolder3.hasParent(nodeHolder)) continue;
            Point point = nodeHolder3.getPosition();
            n = Math.min(n, point.x);
            n2 = Math.max(n2, point.x + nodeHolder3.getSize().width);
        }
        return n + (n2 - n) / 2;
    }

    public static void translate(NodeHolder nodeHolder, int n, int n2) throws ExceptionHugin {
        Point point = nodeHolder.getPosition();
        nodeHolder.setPosition(new Point(point.x + n, point.y));
        NodeLayout.updateLevelWidth(n2, point.x + n + nodeHolder.getSize().width + hgap);
        Vector<NodeHolder> vector = nodeHolder.getChildren();
        if (vector == null || vector.size() == 0) {
            return;
        }
        for (NodeHolder nodeHolder2 : vector) {
            if (!nodeHolder2.hasParent(nodeHolder)) continue;
            NodeLayout.translate(nodeHolder2, n, n2 + 1);
        }
    }

    public static void alignNet(NetworkModel networkModel) throws ExceptionHugin {
        int n = 0;
        int n2 = 0;
        NodeList nodeList = networkModel.getNodes();
        for (Node node : nodeList) {
            n = Math.min(n, (int)node.getPosition().getX() - 80);
            n2 = Math.max(n2, (int)node.getPosition().getY() + 40);
        }
        for (Node node : nodeList) {
            node.setPosition(new Point((int)node.getPosition().getX() - n, -((int)node.getPosition().getY() - n2)));
        }
    }

    private static void useDot(NetworkModel networkModel) throws Exception {
        String string;
        Object object2;
        NodeList nodeList = networkModel.getNodes();
        Process process = Runtime.getRuntime().exec(Hugin.mainFrame.preferences.dot_location);
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(process.getOutputStream()));
        printWriter.println("digraph temp {");
        double d = 1.0;
        double d2 = 1.0;
        for (Object object2 : nodeList) {
            string = ((Node)object2).getAttribute("HR_NodeSize");
            if (string != null) {
                d = HuginGUIUtils.parseDouble(string, "(", ",") / 80.0;
                d2 = HuginGUIUtils.parseDouble(string, ",", ")") / 80.0;
            } else {
                d = Math.max(networkModel.getNodeSize().getX() / 80.0, 0.5);
                d2 = Math.max(networkModel.getNodeSize().getY() / 80.0, 0.5);
            }
            printWriter.println("  " + ((Node)object2).getName() + " [pos=\"0, 0\", " + "width=\"" + d + "\", " + "height=\"" + d2 + "\"];");
        }
        for (Object object2 : nodeList) {
            string = ((Node)object2).getName();
            for (Node node : ((Node)object2).getChildren()) {
                printWriter.println("  " + string + " -> " + node.getName() + ";");
            }
        }
        printWriter.println("}\n");
        printWriter.close();
        NodeLayout.parseDot(networkModel, process.getInputStream());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        object2 = bufferedReader.readLine();
        string = "";
        while (object2 != null) {
            string = string + (String)object2;
            object2 = bufferedReader.readLine();
        }
        if (string.length() > 0) {
            throw new ExceptionHugin(HuginGUIConstants.get("str_dot_returned_lb") + string);
        }
    }

    public static void parseDot(NetworkModel networkModel, InputStream inputStream) throws ExceptionHugin, IOException, FileNotFoundException {
        Node node;
        String string;
        String string2;
        int n;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        boolean bl = false;
        String string3 = bufferedReader.readLine();
        while (string3 != null && !bl) {
            bl = string3.indexOf("graph [") > 0;
            string3 = bufferedReader.readLine();
        }
        boolean bl2 = true;
        while (string3 != null && bl2) {
            string3 = string3.trim();
            n = string3.indexOf("\"");
            string2 = string3.substring(0, string3.indexOf(" "));
            string = string3.substring(n + 1, string3.indexOf("\"", n + 1));
            node = networkModel.getNodeByName(string2);
            n = string.indexOf(",");
            node.setPosition(new Point2D.Double(Double.parseDouble(string.substring(0, n)), Double.parseDouble(string.substring(n + 1))));
            string3 = bufferedReader.readLine();
            bl2 = string3 != null && string3.indexOf("->") < 0 && string3.indexOf("}") < 0;
        }
        boolean bl3 = string3 == null || string3.indexOf("}") >= 0;
        String string4 = "";
        while (string3 != null && !bl3) {
            string3 = string3.trim();
            n = string3.indexOf(" -> ");
            string2 = string3.substring(0, n);
            String string5 = string3.substring(n + 4, string3.indexOf(" ", n + 4));
            n = string3.indexOf("\"");
            string = string3.substring(n + 3, string3.indexOf("\"", n + 2));
            n = string.indexOf(" ", string.indexOf(" ") + 1);
            string = string.substring(n).trim();
            string4 = "(";
            n = string.indexOf(" ");
            while (n > 0) {
                string4 = string4 + string.substring(0, n) + ")";
                string = string.substring(n + 1);
                n = string.indexOf(" ");
                string4 = string4 + " (";
            }
            string4 = string4 + string + ")";
            node = networkModel.getNodeByName(string2);
            HuginGUIUtils.setLinkControlPoints(node, string5, string4);
            HuginGUIUtils.setLinkMode(node, string5, "1");
            string3 = bufferedReader.readLine();
            bl3 = string3.indexOf("}") >= 0;
        }
    }

    public static void main(String[] stringArray) {
        try {
            Domain domain = stringArray.length == 0 ? new Domain("test.hkb") : new Domain(stringArray[0]);
            domain.saveAsNet("layed.net");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeHolder {
        Node node;
        boolean root;
        Vector<NodeHolder> children;
        NodeHolder parent;
        int level;
        Point position;

        public NodeHolder(Node node) throws ExceptionHugin {
            this.level = 0;
            this.node = node;
            node.setUserData(this);
            this.children = new Vector();
            NodeList nodeList = node.getChildren();
            this.addChildInstances(node, nodeList);
            for (Node node2 : nodeList) {
                NodeHolder nodeHolder = node2.getUserData() == null ? new NodeHolder(node2) : (NodeHolder)node2.getUserData();
                nodeHolder.setRoot(false);
                this.children.add(nodeHolder);
            }
        }

        void addChildInstances(Node node, NodeList nodeList) throws ExceptionHugin {
            NetworkModel networkModel = node.getHome();
            block0: for (Node node2 : networkModel.getNodes()) {
                if (!(node2 instanceof InstanceNode)) continue;
                InstanceNode instanceNode = (InstanceNode)node2;
                for (Node node3 : instanceNode.getInstanceClass().getInputs()) {
                    Node node4 = instanceNode.getInput(node3);
                    if (node4 == null || node != node4 || nodeList.contains(instanceNode)) continue;
                    nodeList.add(instanceNode);
                    nodeList.addAll(instanceNode.getOutputs());
                    continue block0;
                }
            }
        }

        NodeList getChildren(InstanceNode instanceNode) throws ExceptionHugin {
            NodeList nodeList = new NodeList();
            NodeList nodeList2 = instanceNode.getHome().getNodes();
            for (Node node : instanceNode.getOutputs()) {
                for (Node node2 : node.getChildren()) {
                    if (nodeList.contains(node2)) continue;
                    nodeList.add(node2);
                }
                block2: for (Node node2 : nodeList2) {
                    if (node2 == instanceNode || !(node2 instanceof InstanceNode)) continue;
                    InstanceNode instanceNode2 = (InstanceNode)node2;
                    for (Node node3 : instanceNode2.getInstanceClass().getInputs()) {
                        Node node4 = instanceNode2.getInput(node3);
                        if (node4 == null || node != node4 || nodeList.contains(instanceNode2)) continue;
                        nodeList.add(instanceNode2);
                        continue block2;
                    }
                }
            }
            return nodeList;
        }

        public Dimension getSize() {
            if (this.node == null) {
                return new Dimension(5, 5);
            }
            try {
                String string = this.node.getAttribute("HR_NodeSize");
                if (string != null) {
                    return new Dimension((int)HuginGUIUtils.parseDouble(string, "(", ","), (int)HuginGUIUtils.parseDouble(string, ",", ")"));
                }
                Point2D point2D = this.node.getHome().getNodeSize();
                if (point2D.getX() < 20.0 || point2D.getY() < 20.0) {
                    return new Dimension(80, 40);
                }
                return new Dimension((int)point2D.getX(), (int)point2D.getY());
            }
            catch (Exception exception) {
                return new Dimension(80, 40);
            }
        }

        public Point getPosition() throws ExceptionHugin {
            if (this.node != null) {
                Point2D point2D = this.node.getPosition();
                return new Point((int)point2D.getX(), (int)point2D.getY());
            }
            if (!this.isRoot() && this.position != null) {
                return (Point)this.position.clone();
            }
            return new Point(0, 0);
        }

        public void setPosition(Point point) throws ExceptionHugin {
            if (this.node != null) {
                NodeLayout.levelHeight[this.level] = Math.max(levelHeight[this.level], point.y);
                this.node.setPosition(point);
            } else if (!this.isRoot()) {
                this.position = (Point)point.clone();
            }
        }

        public Vector<NodeHolder> getChildren() {
            return this.children;
        }

        public String toString() {
            try {
                if (this.isRoot()) {
                    return "ROOT";
                }
                if (this.node == null) {
                    return "TEMP";
                }
                return this.node.getName();
            }
            catch (Exception exception) {
                return "NO NAME";
            }
        }

        public NodeHolder(int n, NodeHolder nodeHolder) {
            this.node = null;
            this.root = false;
            this.level = n;
            this.children = new Vector();
            this.children.add(nodeHolder);
        }

        public NodeHolder(Vector<NodeHolder> vector) {
            this.node = null;
            this.root = true;
            this.level = 0;
            this.children = new Vector();
            for (NodeHolder nodeHolder : vector) {
                if (!nodeHolder.isRoot()) continue;
                nodeHolder.setRoot(false);
                this.children.add(nodeHolder);
                nodeHolder.setParent(this, this.level + 1);
            }
        }

        public void setRoot(boolean bl) {
            this.root = bl;
        }

        public boolean isRoot() {
            return this.root;
        }

        public void setParent(NodeHolder nodeHolder) {
            this.parent = nodeHolder;
        }

        public void setParent(NodeHolder nodeHolder, int n) {
            if (n > this.level) {
                this.parent = nodeHolder;
                this.level = n;
                for (NodeHolder nodeHolder2 : this.children) {
                    nodeHolder2.setParent(this, n + 1);
                }
            }
        }

        public boolean hasParent(NodeHolder nodeHolder) {
            return this.parent == nodeHolder;
        }

        public void optimize() {
            for (NodeHolder nodeHolder : this.children) {
                if (!nodeHolder.hasParent(this)) continue;
                nodeHolder.optimize();
            }
            int n = this.getOptimalLevel();
            int n2 = this.level;
            this.level = n;
        }

        private int getOptimalLevel() {
            int n = Integer.MAX_VALUE;
            for (NodeHolder nodeHolder : this.children) {
                n = Math.min(n, nodeHolder.getOptimalLevel() - 1);
            }
            if (n == Integer.MAX_VALUE) {
                return this.level;
            }
            return n;
        }

        private NodeHolder createIntermediateNodes(NodeHolder nodeHolder, int n, boolean bl) {
            NodeHolder nodeHolder2 = new NodeHolder(nodeHolder.getLevel() - 1, nodeHolder);
            if (bl) {
                nodeHolder.setParent(nodeHolder2);
            }
            for (int i = 0; i < n - 1; ++i) {
                nodeHolder = nodeHolder2;
                nodeHolder2 = new NodeHolder(nodeHolder.getLevel() - 1, nodeHolder);
                nodeHolder.setParent(nodeHolder2);
            }
            return nodeHolder2;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int n) {
            this.level = n;
        }

        public void createLinks() {
            for (NodeHolder nodeHolder : this.children) {
                if (nodeHolder.node == null && !nodeHolder.isRoot()) {
                    try {
                        String string = "";
                        while (nodeHolder.node == null) {
                            Point point = nodeHolder.getPosition();
                            string = string + "(" + (int)point.getX() + ", " + (int)point.getY() + ") ";
                            nodeHolder = nodeHolder.getChildren().get(0);
                        }
                        HuginGUIUtils.setLinkControlPoints(this.node, nodeHolder.node.getName(), string);
                        HuginGUIUtils.setLinkMode(this.node, nodeHolder.node.getName(), "1");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    continue;
                }
                nodeHolder.createLinks();
            }
        }
    }
}

