/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.BooleanDCNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HAPI.IntervalDDNode;
import COM.hugin.HAPI.LabelledDCNode;
import COM.hugin.HAPI.NumberedDCNode;
import COM.hugin.HAPI.NumberedDDNode;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginAnalysisDialog;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.NumberField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NodeStatesGeneratorPanel
extends JDialog {
    Node node;
    COM.hugin.HAPI.Node apiNodeOriginal;
    COM.hugin.HAPI.Node apiNode;
    NetworkPanel networkPanel;
    JButton ok;
    JButton apply;
    JButton cancel;
    JTabbedPane tabs;
    private int generalIndex = 0;
    private int numberIndex = 1;
    JSpinner numStates;
    JSpinner samplesPerInterval;
    NumberField minValue;
    NumberField maxValue;
    NumberField stepValue;
    JCheckBox inf;
    JCheckBox minusInf;
    JRadioButton copy;
    JRadioButton cartesian;
    JRadioButton pair;
    JRadioButton labels;
    JRadioButton stepRadio;
    JRadioButton maxRadio;
    JComboBox theCopyNode;
    Vector<Double> sampledValues;

    public NodeStatesGeneratorPanel(Node node) {
        super(Hugin.mainFrame, HuginGUIConstants.get("FUNCTIONS_States_Generator"), true);
        this.node = node;
        this.apiNodeOriginal = node.getAPINode();
        try {
            this.apiNode = (COM.hugin.HAPI.Node)this.apiNodeOriginal.clone();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new HuginGUIError(exception.getMessage());
        }
        this.networkPanel = Hugin.mainFrame.getSelectedProjectFrame().getNetworkPanel();
        this.setContentPane(this.createContentPane());
        this.setResizable(false);
    }

    public void dispose() {
        super.dispose();
        try {
            if (this.apiNode.isAlive()) {
                this.apiNode.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new HuginGUIError(exception.getMessage());
        }
    }

    private JPanel createContentPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tabs = new JTabbedPane();
        this.tabs.add((Component)this.createStatesPanel(), HuginGUIConstants.get("General"));
        if (this.node.isNumbered()) {
            this.tabs.add((Component)this.createNumberPanel(), HuginGUIConstants.get("Numbered"));
        }
        if (this.node.isInterval()) {
            this.tabs.add((Component)this.createNumberPanel(), HuginGUIConstants.get("Interval"));
        }
        jPanel.add(this.tabs);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        this.ok = new JButton(HuginGUIConstants.get("OK_button"));
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NodeStatesGeneratorPanel.this.dispose();
            }
        });
        jPanel2.add(this.ok);
        this.cancel = new JButton(HuginGUIConstants.get("cancel_button"));
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NodeStatesGeneratorPanel.this.dispose();
            }
        });
        jPanel2.add(this.cancel);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    protected JPanel createStatesPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        this.copy = new JRadioButton(HuginGUIConstants.get("Copy_states_from_node"));
        this.copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NodeStatesGeneratorPanel.this.theCopyNode.setEnabled(true);
            }
        });
        this.cartesian = new JRadioButton(HuginGUIConstants.get("Cartesian_product"));
        this.cartesian.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NodeStatesGeneratorPanel.this.theCopyNode.setEnabled(false);
            }
        });
        this.pair = new JRadioButton(HuginGUIConstants.get("Unordered_pair"));
        this.pair.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NodeStatesGeneratorPanel.this.theCopyNode.setEnabled(false);
            }
        });
        this.labels = new JRadioButton(HuginGUIConstants.get("Copy_state_values_to_labels"));
        this.labels.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NodeStatesGeneratorPanel.this.theCopyNode.setEnabled(false);
            }
        });
        this.copy.setSelected(true);
        this.labels.setSelected(false);
        this.cartesian.setSelected(false);
        this.pair.setSelected(false);
        this.copy.setEnabled(true);
        this.cartesian.setEnabled(this.node.getParents().size() > 0);
        this.labels.setEnabled(this.node.isNumbered() || this.node.isInterval());
        this.theCopyNode = new JComboBox(new HuginAnalysisDialog.NodeListModel(this.apiNode));
        this.theCopyNode.setSelectedIndex(-1);
        this.theCopyNode.setEnabled(true);
        buttonGroup.add(this.copy);
        buttonGroup.add(this.labels);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel2.add((Component)this.copy, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel2.add((Component)this.theCopyNode, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        jPanel2.add((Component)this.labels, gridBagConstraints);
        jPanel.add(jPanel2);
        jPanel.add((Component)this.getGeneralButtonPanel(), "South");
        return jPanel;
    }

    protected double getValue(Node node, int n) {
        try {
            if (node.isChance() && node.isInterval()) {
                IntervalDCNode intervalDCNode = (IntervalDCNode)node.getAPINode();
                return intervalDCNode.getStateValue(n);
            }
            if (node.isChance() && node.isNumbered()) {
                NumberedDCNode numberedDCNode = (NumberedDCNode)node.getAPINode();
                return numberedDCNode.getStateValue(n);
            }
            if (node.isDecision() && node.isInterval()) {
                IntervalDDNode intervalDDNode = (IntervalDDNode)node.getAPINode();
                return intervalDDNode.getStateValue(n);
            }
            if (node.isDecision() && node.isNumbered()) {
                NumberedDDNode numberedDDNode = (NumberedDDNode)node.getAPINode();
                return numberedDDNode.getStateValue(n);
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
            exceptionHugin.printStackTrace();
        }
        return 0.0;
    }

    protected double getInitMin(Node node) {
        return this.getValue(node, 0);
    }

    protected double getInitMax(Node node) {
        int n = node.numberOfStates();
        int n2 = 0;
        n2 = node.isInterval() ? n : n - 1;
        return this.getValue(node, n2);
    }

    protected double getInitMaxBeforeInf(Node node) {
        try {
            if (node.isChance() || node.isDecision()) {
                DiscreteNode discreteNode = (DiscreteNode)node.getAPINode();
                int n = discreteNode.getNumberOfStates();
                double d = 1.0;
                for (int i = 0; i < n; ++i) {
                    double d2 = this.getValue(node, i);
                    if (d2 == Domain.INFINITY()) continue;
                    d = d2;
                }
                if (d != Domain.INFINITY() && d != -Domain.INFINITY()) {
                    return d;
                }
                return 1.0;
            }
            return 1.0;
        }
        catch (ExceptionHugin exceptionHugin) {
            return 1.0;
        }
    }

    protected double getInitStep(Node node) {
        double d = 1.0;
        try {
            DiscreteNode discreteNode;
            int n = 0;
            if (this.getInitMin(node) == -Domain.INFINITY()) {
                n = 1;
            }
            if (node.isChance() && node.isInterval()) {
                discreteNode = (IntervalDCNode)node.getAPINode();
                if (n + 1 >= discreteNode.getNumberOfStates()) {
                    n = 0;
                }
                d = ((IntervalDCNode)discreteNode).getStateValue(n + 1) - ((IntervalDCNode)discreteNode).getStateValue(n);
            }
            if (node.isChance() && node.isNumbered()) {
                discreteNode = (NumberedDCNode)node.getAPINode();
                if (n + 1 >= discreteNode.getNumberOfStates()) {
                    n = 0;
                }
                d = ((NumberedDCNode)discreteNode).getStateValue(n + 1) - ((NumberedDCNode)discreteNode).getStateValue(n);
            }
            if (node.isDecision() && node.isInterval()) {
                discreteNode = (IntervalDDNode)node.getAPINode();
                if (n + 1 >= discreteNode.getNumberOfStates()) {
                    n = 0;
                }
                d = ((IntervalDDNode)discreteNode).getStateValue(n + 1) - ((IntervalDDNode)discreteNode).getStateValue(n);
            }
            if (node.isDecision() && node.isNumbered()) {
                discreteNode = (NumberedDDNode)node.getAPINode();
                if (n + 1 >= discreteNode.getNumberOfStates()) {
                    n = 0;
                }
                d = ((NumberedDDNode)discreteNode).getStateValue(n + 1) - ((NumberedDDNode)discreteNode).getStateValue(n);
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
            exceptionHugin.printStackTrace();
        }
        if (HuginGUIUtils.parseDouble("" + d) == Domain.INFINITY() || HuginGUIUtils.parseDouble("" + d) == Domain.INFINITY()) {
            d = 1.0;
        }
        return d;
    }

    protected JPanel createNumberPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(HuginGUIConstants.get("Number_of_states") + " : ");
        this.numStates = new JSpinner(new SpinnerNumberModel(this.node.numberOfStates(), 2, 1000000, 1));
        this.numStates.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
            }
        });
        JPanel jPanel3 = new JPanel(new FlowLayout());
        jPanel3.add(jLabel);
        jPanel3.add(this.numStates);
        JPanel jPanel4 = null;
        try {
            if (this.node.getAPINode().getModel() != null) {
                JLabel jLabel2 = new JLabel(HuginGUIConstants.get("MENU_TABLE_Samples_per_Interval") + " : ");
                int n = 20;
                n = this.node.getAPINode().getModel().getNumberOfSamplesPerInterval();
                this.samplesPerInterval = new JSpinner(new SpinnerNumberModel(n, 1, 100, 1));
                this.samplesPerInterval.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                    }
                });
                jPanel4 = new JPanel(new FlowLayout());
                jPanel4.add(jLabel2);
                jPanel4.add(this.samplesPerInterval);
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage() + HuginGUIConstants.get("str_does_table_have_a_model"));
            exceptionHugin.printStackTrace();
        }
        double d = this.getInitMin(this.node);
        double d2 = this.getInitMax(this.node);
        double d3 = this.getInitStep(this.node);
        this.minusInf = new JCheckBox(HuginGUIConstants.get("Include_minus_inf"));
        if (d == -Domain.INFINITY()) {
            d = this.getValue(this.node, 1);
            if (d == Domain.INFINITY() || d == -Domain.INFINITY()) {
                d = 0.0;
            }
            this.minusInf.setSelected(true);
        }
        JPanel jPanel5 = new JPanel(new FlowLayout());
        jPanel5.add(this.minusInf);
        this.inf = new JCheckBox(HuginGUIConstants.get("Include_inf"));
        if (d2 == Domain.INFINITY()) {
            this.inf.setSelected(true);
            d2 = this.getInitMaxBeforeInf(this.node);
        }
        JPanel jPanel6 = new JPanel(new FlowLayout());
        jPanel6.add(this.inf);
        this.minValue = new NumberField();
        this.minValue.setText(HuginGUIUtils.printDouble(d, Integer.parseInt("6")));
        this.minValue.setHorizontalAlignment(4);
        JLabel jLabel3 = new JLabel(HuginGUIConstants.get("Minimum_value") + " : ");
        JPanel jPanel7 = new JPanel(new FlowLayout());
        jPanel7.add(jLabel3);
        jPanel7.add(this.minValue);
        this.maxValue = new NumberField();
        this.maxValue.setText(HuginGUIUtils.printDouble(d2, Integer.parseInt("6")));
        this.maxValue.setHorizontalAlignment(4);
        JLabel jLabel4 = new JLabel(HuginGUIConstants.get("Maximum_value") + " : ");
        JPanel jPanel8 = new JPanel(new FlowLayout());
        jPanel8.add(jLabel4);
        jPanel8.add(this.maxValue);
        this.stepValue = new NumberField();
        this.stepValue.setText(HuginGUIUtils.printDouble(d3, Integer.parseInt("6")));
        this.stepValue.setHorizontalAlignment(4);
        JLabel jLabel5 = new JLabel(HuginGUIConstants.get("Step_size") + " : ");
        JPanel jPanel9 = new JPanel(new FlowLayout());
        jPanel9.add(jLabel5);
        jPanel9.add(this.stepValue);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.stepRadio = new JRadioButton(HuginGUIConstants.get("Step_size") + " : ");
        this.maxRadio = new JRadioButton(HuginGUIConstants.get("Maximum_value") + " : ");
        this.stepRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NodeStatesGeneratorPanel.this.maxValue.setEnabled(false);
                NodeStatesGeneratorPanel.this.stepValue.setEnabled(true);
            }
        });
        this.maxRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NodeStatesGeneratorPanel.this.maxValue.setEnabled(true);
                NodeStatesGeneratorPanel.this.stepValue.setEnabled(false);
            }
        });
        this.stepRadio.setSelected(true);
        this.maxRadio.setSelected(false);
        this.maxValue.setEnabled(false);
        buttonGroup.add(this.stepRadio);
        buttonGroup.add(this.maxRadio);
        jPanel8 = new JPanel(new FlowLayout());
        jPanel8.add(this.maxRadio);
        jPanel8.add(this.maxValue);
        jPanel9 = new JPanel(new FlowLayout());
        jPanel9.add(this.stepRadio);
        jPanel9.add(this.stepValue);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        int n = 0;
        JPanel jPanel10 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        jPanel10.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        jPanel10.add((Component)this.minValue, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        jPanel10.add((Component)this.stepRadio, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        jPanel10.add((Component)this.stepValue, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        jPanel10.add((Component)this.maxRadio, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        jPanel10.add((Component)this.maxValue, gridBagConstraints);
        n = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 2;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        if (jPanel4 != null) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 2;
            jPanel2.add((Component)jPanel4, gridBagConstraints);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        jPanel2.add((Component)jPanel5, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        jPanel2.add((Component)jPanel6, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        jPanel2.add((Component)jPanel10, gridBagConstraints);
        jPanel.add(jPanel2);
        jPanel.add((Component)this.getNumberButtonPanel(), "South");
        return jPanel;
    }

    protected void stepCreateStates(COM.hugin.HAPI.Node node, int n, double d, double d2, boolean bl, boolean bl2) throws ExceptionHugin {
        int n2;
        double d3;
        int n3;
        DiscreteNode discreteNode;
        if (node instanceof NumberedDCNode) {
            discreteNode = (NumberedDCNode)node;
            discreteNode.setNumberOfStates(n);
            n3 = 1;
            if (bl) {
                ((NumberedDCNode)discreteNode).setStateValue(0, -Domain.INFINITY());
                ((NumberedDCNode)discreteNode).setStateValue(1, d2);
                n3 = 2;
            } else {
                ((NumberedDCNode)discreteNode).setStateValue(0, d2);
            }
            d3 = d2 + d;
            n2 = n3;
            while (n2 < n) {
                ((NumberedDCNode)discreteNode).setStateValue(n2, d3);
                ++n2;
                d3 += d;
            }
            if (bl2) {
                ((NumberedDCNode)discreteNode).setStateValue(n - 1, Domain.INFINITY());
            }
        }
        if (node instanceof NumberedDDNode) {
            discreteNode = (NumberedDDNode)node;
            discreteNode.setNumberOfStates(n);
            n3 = 1;
            if (bl) {
                ((NumberedDDNode)discreteNode).setStateValue(0, -Domain.INFINITY());
                ((NumberedDDNode)discreteNode).setStateValue(1, d2);
                n3 = 2;
            } else {
                ((NumberedDDNode)discreteNode).setStateValue(0, d2);
            }
            d3 = d2 + d;
            n2 = n3;
            while (n2 < n) {
                ((NumberedDDNode)discreteNode).setStateValue(n2, d3);
                ++n2;
                d3 += d;
            }
            if (bl2) {
                ((NumberedDDNode)discreteNode).setStateValue(n - 1, Domain.INFINITY());
            }
        }
        if (node instanceof IntervalDCNode) {
            discreteNode = (IntervalDCNode)node;
            discreteNode.setNumberOfStates(n);
            n3 = 1;
            if (bl) {
                ((IntervalDCNode)discreteNode).setStateValue(0, -Domain.INFINITY());
                ((IntervalDCNode)discreteNode).setStateValue(1, d2);
                n3 = 2;
            } else {
                ((IntervalDCNode)discreteNode).setStateValue(0, d2);
            }
            d3 = d2 + d;
            n2 = n3;
            while (n2 <= n) {
                String string = HuginGUIUtils.printDouble(d3, Integer.parseInt("6"));
                d3 = HuginGUIUtils.parseDouble(string);
                ((IntervalDCNode)discreteNode).setStateValue(n2, d3);
                ++n2;
                d3 += d;
            }
            if (bl2) {
                ((IntervalDCNode)discreteNode).setStateValue(n, Domain.INFINITY());
            }
        }
        if (node instanceof IntervalDDNode) {
            discreteNode = (IntervalDDNode)node;
            discreteNode.setNumberOfStates(n);
            n3 = 1;
            if (bl) {
                ((IntervalDDNode)discreteNode).setStateValue(0, -Domain.INFINITY());
                ((IntervalDDNode)discreteNode).setStateValue(1, d2);
                n3 = 2;
            } else {
                ((IntervalDDNode)discreteNode).setStateValue(0, d2);
            }
            d3 = d2 + d;
            n2 = n3;
            while (n2 <= n) {
                ((IntervalDDNode)discreteNode).setStateValue(n2, d3);
                ++n2;
                d3 += d;
            }
            if (bl2) {
                ((IntervalDDNode)discreteNode).setStateValue(n, Domain.INFINITY());
            }
        }
    }

    protected void maxCreateStates(COM.hugin.HAPI.Node node, int n, double d, double d2, boolean bl, boolean bl2) throws ExceptionHugin {
        double d3 = 0.0;
        if (d2 <= d) {
            d = 0.0;
            d2 = 1.0;
        } else {
            int n2 = 0;
            if (bl2) {
                ++n2;
            }
            if (bl) {
                ++n2;
            }
            d3 = node instanceof NumberedDCNode || node instanceof NumberedDDNode ? (d2 - d) / (double)(n - n2 - 1) : (d2 - d) / (double)(n - n2);
        }
        this.stepCreateStates(node, n, d3, d, bl, bl2);
    }

    private JPanel getNumberButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout());
        JButton jButton = new JButton(HuginGUIConstants.get("apply_button"));
        jButton.setToolTipText(HuginGUIConstants.get("str_apply_setting_to_node") + " " + this.node.getName());
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    COM.hugin.HAPI.Node node = NodeStatesGeneratorPanel.this.node.getAPINode();
                    try {
                        if (node.getModel() != null) {
                            int n = (Integer)NodeStatesGeneratorPanel.this.samplesPerInterval.getValue();
                            node.getModel().setNumberOfSamplesPerInterval(n);
                        }
                    }
                    catch (ExceptionHugin exceptionHugin) {
                        exceptionHugin.printStackTrace();
                        new HuginGUIError(exceptionHugin.getMessage());
                    }
                    Number number = (Number)NodeStatesGeneratorPanel.this.numStates.getValue();
                    int n = 0;
                    n = (Integer)number;
                    if (NodeStatesGeneratorPanel.this.stepRadio.isSelected()) {
                        NodeStatesGeneratorPanel.this.stepCreateStates(node, n, NodeStatesGeneratorPanel.this.stepValue.getNumber(), NodeStatesGeneratorPanel.this.minValue.getNumber(), NodeStatesGeneratorPanel.this.minusInf.isSelected(), NodeStatesGeneratorPanel.this.inf.isSelected());
                    }
                    if (NodeStatesGeneratorPanel.this.maxRadio.isSelected()) {
                        NodeStatesGeneratorPanel.this.maxCreateStates(node, n, NodeStatesGeneratorPanel.this.minValue.getNumber(), NodeStatesGeneratorPanel.this.maxValue.getNumber(), NodeStatesGeneratorPanel.this.minusInf.isSelected(), NodeStatesGeneratorPanel.this.inf.isSelected());
                    }
                    NodeStatesGeneratorPanel.this.node.updateTable(true);
                    NodeStatesGeneratorPanel.this.node.updateChildTables();
                    NodeStatesGeneratorPanel.this.networkPanel.containsUnsavedChanges(true);
                    NodeStatesGeneratorPanel.this.networkPanel.containsUncompiledChanges(true);
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                    exception.printStackTrace();
                }
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    protected void copyValues(NumberedDCNode numberedDCNode) throws ExceptionHugin {
        NumberedDCNode numberedDCNode2 = (NumberedDCNode)this.apiNodeOriginal;
        int n = numberedDCNode.getNumberOfStates();
        numberedDCNode2.setNumberOfStates(n);
        for (int i = 0; i < n; ++i) {
            numberedDCNode2.setStateValue(i, numberedDCNode.getStateValue(i));
        }
    }

    protected void copyValues(IntervalDCNode intervalDCNode) throws ExceptionHugin {
        IntervalDCNode intervalDCNode2 = (IntervalDCNode)this.apiNodeOriginal;
        int n = intervalDCNode.getNumberOfStates();
        intervalDCNode2.setNumberOfStates(n);
        for (int i = 0; i <= n; ++i) {
            intervalDCNode2.setStateValue(i, intervalDCNode.getStateValue(i));
        }
    }

    protected void copyValues(NumberedDDNode numberedDDNode) throws ExceptionHugin {
        NumberedDDNode numberedDDNode2 = (NumberedDDNode)this.apiNodeOriginal;
        int n = numberedDDNode.getNumberOfStates();
        numberedDDNode2.setNumberOfStates(n);
        for (int i = 0; i < n; ++i) {
            numberedDDNode2.setStateValue(i, numberedDDNode.getStateValue(i));
        }
    }

    protected void copyValues(IntervalDDNode intervalDDNode) throws ExceptionHugin {
        IntervalDDNode intervalDDNode2 = (IntervalDDNode)this.apiNodeOriginal;
        int n = intervalDDNode.getNumberOfStates();
        intervalDDNode2.setNumberOfStates(n);
        for (int i = 0; i <= n; ++i) {
            intervalDDNode2.setStateValue(i, intervalDDNode.getStateValue(i));
        }
    }

    protected void copyLabels(DiscreteNode discreteNode) throws ExceptionHugin {
        DiscreteNode discreteNode2 = (DiscreteNode)this.apiNodeOriginal;
        int n = discreteNode.getNumberOfStates();
        discreteNode2.setNumberOfStates(n);
        for (int i = 0; i < n; ++i) {
            discreteNode2.setStateLabel(i, discreteNode.getStateLabel(i));
        }
    }

    protected void values2Labels() throws ExceptionHugin {
        if (this.apiNodeOriginal instanceof DiscreteNode) {
            DiscreteNode discreteNode = (DiscreteNode)this.apiNodeOriginal;
            int n = discreteNode.getNumberOfStates();
            String string = discreteNode.getAttribute("HR_Node_states");
            discreteNode.setAttribute("HR_Node_states", "states");
            for (int i = 0; i < n; ++i) {
                discreteNode.setStateLabel(i, HuginGUIUtils.getNodeStateLabel(discreteNode, i));
            }
            discreteNode.setAttribute("HR_Node_states", string);
        }
    }

    private JPanel getGeneralButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout());
        JButton jButton = new JButton(HuginGUIConstants.get("apply_button"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    COM.hugin.HAPI.Node node;
                    Object object;
                    if (NodeStatesGeneratorPanel.this.copy.isSelected()) {
                        object = (HuginAnalysisDialog.NodeWrapper)NodeStatesGeneratorPanel.this.theCopyNode.getSelectedItem();
                        node = null;
                        if (object != null) {
                            node = ((HuginAnalysisDialog.NodeWrapper)object).node;
                        }
                        if (node instanceof DiscreteNode) {
                            NodeStatesGeneratorPanel.this.copyLabels((DiscreteNode)node);
                        }
                        if (node instanceof NumberedDCNode) {
                            NodeStatesGeneratorPanel.this.copyValues((NumberedDCNode)node);
                        }
                        if (node instanceof IntervalDCNode) {
                            NodeStatesGeneratorPanel.this.copyValues((IntervalDCNode)node);
                        }
                        if (node instanceof NumberedDDNode) {
                            NodeStatesGeneratorPanel.this.copyValues((NumberedDDNode)node);
                        }
                        if (node instanceof IntervalDDNode) {
                            NodeStatesGeneratorPanel.this.copyValues((IntervalDDNode)node);
                        }
                    }
                    if (NodeStatesGeneratorPanel.this.pair.isSelected()) {
                        int n;
                        object = (DiscreteChanceNode)NodeStatesGeneratorPanel.this.apiNode;
                        node = (DiscreteChanceNode)NodeStatesGeneratorPanel.this.apiNode.getParents().get(0);
                        DiscreteChanceNode discreteChanceNode = (DiscreteChanceNode)NodeStatesGeneratorPanel.this.apiNode.getParents().get(1);
                        int n2 = ((DiscreteNode)node).getNumberOfStates();
                        int n3 = 0;
                        for (n = 1; n <= n2; ++n) {
                            n3 += n;
                        }
                        ((DiscreteNode)object).setNumberOfStates(n3);
                        n = 0;
                        for (int i = 0; i < n2; ++i) {
                            for (int j = i; j < n2; ++j) {
                                String string = "(";
                                string = string + HuginGUIUtils.getNodeStateLabel(node, i);
                                string = string + ", ";
                                string = string + HuginGUIUtils.getNodeStateLabel(discreteChanceNode, j);
                                string = string + ")";
                                ((DiscreteNode)object).setStateLabel(n, string);
                                ++n;
                            }
                        }
                    }
                    if (NodeStatesGeneratorPanel.this.labels.isSelected()) {
                        NodeStatesGeneratorPanel.this.values2Labels();
                    }
                    if (NodeStatesGeneratorPanel.this.cartesian.isSelected()) {
                        System.err.println("");
                    }
                    NodeStatesGeneratorPanel.this.node.updateTable(true);
                    NodeStatesGeneratorPanel.this.node.updateChildTables();
                    NodeStatesGeneratorPanel.this.networkPanel.containsUnsavedChanges(true);
                    NodeStatesGeneratorPanel.this.networkPanel.containsUncompiledChanges(true);
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                    exception.printStackTrace();
                }
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    protected boolean equal(DiscreteChanceNode discreteChanceNode, DiscreteChanceNode discreteChanceNode2) throws ExceptionHugin {
        int n = discreteChanceNode.getNumberOfStates();
        if (discreteChanceNode2.getNumberOfStates() != n) {
            return false;
        }
        if (discreteChanceNode instanceof LabelledDCNode && discreteChanceNode2 instanceof LabelledDCNode || discreteChanceNode instanceof BooleanDCNode && discreteChanceNode2 instanceof BooleanDCNode) {
            for (int i = 0; i < n; ++i) {
                if (discreteChanceNode.getStateLabel(i).equals(discreteChanceNode2.getStateLabel(i))) continue;
                return false;
            }
            return true;
        }
        if (discreteChanceNode instanceof NumberedDCNode && discreteChanceNode2 instanceof NumberedDCNode) {
            for (int i = 0; i < n; ++i) {
                if (discreteChanceNode.getStateLabel(i).equals(discreteChanceNode2.getStateLabel(i))) continue;
                return false;
            }
            NumberedDCNode numberedDCNode = (NumberedDCNode)discreteChanceNode;
            NumberedDCNode numberedDCNode2 = (NumberedDCNode)discreteChanceNode2;
            for (int i = 0; i < n; ++i) {
                if (numberedDCNode.getStateValue(i) == numberedDCNode2.getStateValue(i)) continue;
                return false;
            }
            return true;
        }
        if (discreteChanceNode instanceof IntervalDCNode && discreteChanceNode2 instanceof IntervalDCNode) {
            for (int i = 0; i < n + 1; ++i) {
                if (discreteChanceNode.getStateLabel(i).equals(discreteChanceNode2.getStateLabel(i))) continue;
                return false;
            }
            IntervalDCNode intervalDCNode = (IntervalDCNode)discreteChanceNode;
            IntervalDCNode intervalDCNode2 = (IntervalDCNode)discreteChanceNode2;
            for (int i = 0; i < n + 1; ++i) {
                if (intervalDCNode.getStateValue(i) == intervalDCNode2.getStateValue(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean twoEqualParents() {
        try {
            COM.hugin.HAPI.Node node = this.node.getAPINode();
            if (node.getParents().size() != 2) {
                return false;
            }
            DiscreteChanceNode discreteChanceNode = (DiscreteChanceNode)node.getParents().get(0);
            DiscreteChanceNode discreteChanceNode2 = (DiscreteChanceNode)node.getParents().get(1);
            return this.equal(discreteChanceNode, discreteChanceNode2);
        }
        catch (ExceptionHugin exceptionHugin) {
            return false;
        }
    }
}

