/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteDecisionNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.FunctionNode;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.UtilityNode;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.NodeTableColumn;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTableColumnModel
extends DefaultTableColumnModel {
    NodeTableColumn root;
    int columnCount;
    int[] transformArray;
    int position = 0;
    int visibleColumns = 0;
    LinkedList<ColumnStateListener> columnStateListeners = new LinkedList();
    CollapseList collapsedColumns = new CollapseList();
    int[] cellWidths;
    Node node = null;
    int width;

    @Override
    protected ListSelectionModel createSelectionModel() {
        return new NodeTableSelectionModel();
    }

    protected boolean hasAnchor() {
        return ((NodeTableSelectionModel)this.getSelectionModel()).hasAnchor();
    }

    public void setNode(Node node) throws ExceptionHugin {
        this.node = node;
        this.root = this.createRoot(node);
        this.columnCount = this.root != null ? this.root.index(0) : 0;
        this.transformArray = new int[this.columnCount];
        for (int i = 0; i < this.transformArray.length; ++i) {
            this.transformArray[i] = i;
        }
        this.visibleColumns = this.columnCount;
        this.position = 0;
    }

    NodeTableColumn createRoot(Node node) throws ExceptionHugin {
        NodeList nodeList = null;
        if (node instanceof DiscreteDecisionNode) {
            nodeList = node.getTable().getNodes();
        }
        if (node instanceof DiscreteChanceNode || node instanceof ContinuousChanceNode || node instanceof UtilityNode) {
            nodeList = node.getTable().getNodes();
        }
        if (node instanceof FunctionNode) {
            nodeList = new NodeList();
        }
        if (nodeList != null) {
            nodeList.remove(node);
        }
        this.cellWidths = this.buildCellWidthArray(nodeList);
        this.visibleColumns = this.calculateVisibleColumns();
        if (this.visibleColumns == 0) {
            return null;
        }
        this.transformArray = this.collapsedColumns.getTransformArray(this, this.position, this.visibleColumns);
        ListIterator listIterator = nodeList.listIterator();
        while (listIterator.hasNext()) {
            Node node2 = (Node)listIterator.next();
            if (!(node2 instanceof ContinuousChanceNode)) continue;
            listIterator.remove();
        }
        this.root = new NodeTableColumn(node, 0, nodeList, this.collapsedColumns, 0, 0, this.position, this.getLastVisibleColumnIndex(), this.cellWidths);
        return this.root;
    }

    public void setNodeList(NodeList nodeList, boolean bl) throws ExceptionHugin {
        this.root = new NodeTableColumn("", null);
        NodeTableColumn nodeTableColumn = null;
        NodeTableColumn nodeTableColumn2 = this.root;
        if (!bl) {
            for (Node node : nodeList) {
                if (!(node instanceof DiscreteNode)) continue;
                nodeTableColumn = new NodeTableColumn(HuginGUIUtils.getNodeTitle(node), null);
                nodeTableColumn2.getIterator().add(nodeTableColumn);
                nodeTableColumn2 = nodeTableColumn;
            }
        }
        if (nodeTableColumn != null) {
            nodeTableColumn.setResizable(true);
        }
        this.columnCount = this.root.index(0);
        this.transformArray = new int[1];
        this.transformArray[0] = 0;
        this.visibleColumns = 1;
        this.cellWidths = new int[1];
        this.cellWidths[0] = 1;
        this.node = null;
    }

    public void addColumnStateListener(ColumnStateListener columnStateListener) {
        this.columnStateListeners.add(columnStateListener);
    }

    public void removeColumnStateListener(ColumnStateListener columnStateListener) {
        this.columnStateListeners.remove(columnStateListener);
    }

    protected void fireColumnCollapsing(int n) {
        for (ColumnStateListener columnStateListener : this.columnStateListeners) {
            columnStateListener.columnCollapsing(n);
        }
    }

    protected void fireColumnCollapsed(int n) {
        for (ColumnStateListener columnStateListener : this.columnStateListeners) {
            columnStateListener.columnCollapsed(n);
        }
    }

    protected void fireColumnExpanded(int n) {
        for (ColumnStateListener columnStateListener : this.columnStateListeners) {
            columnStateListener.columnExpanded(n);
        }
    }

    @Override
    public TableColumn getColumn(int n) {
        TableColumn tableColumn = null;
        try {
            tableColumn = this.root.getColumn(this.transformArray[n]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            tableColumn = this.root.getColumn(0);
        }
        return tableColumn;
    }

    @Override
    public int getColumnCount() {
        if (super.getColumnCount() > 0) {
            return this.visibleColumns;
        }
        return 0;
    }

    @Override
    public int[] getSelectedColumns() {
        if (!(this.getSelectionModel() instanceof NodeTableSelectionModel)) {
            return super.getSelectedColumns();
        }
        NodeTableSelectionModel nodeTableSelectionModel = (NodeTableSelectionModel)this.getSelectionModel();
        int n = Math.min(nodeTableSelectionModel.getLead(), nodeTableSelectionModel.getAnchor());
        int n2 = Math.max(nodeTableSelectionModel.getLead(), nodeTableSelectionModel.getAnchor());
        int[] nArray = new int[1 + (n2 - n)];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i + n;
        }
        return nArray;
    }

    protected int getTrueColumnCount() {
        if (super.getColumnCount() > 0 && this.cellWidths != null) {
            return this.collapsedColumns.getColumnCount(this.cellWidths[0]);
        }
        return 0;
    }

    protected int getFullColumnCount() {
        if (super.getColumnCount() > 0 && this.cellWidths != null) {
            return this.cellWidths[0];
        }
        return 0;
    }

    @Override
    public Enumeration<TableColumn> getColumns() {
        if (this.root == null) {
            return null;
        }
        Vector<TableColumn> vector = new Vector<TableColumn>(this.columnCount);
        this.root.getColumns(vector, this.position, this.getLastVisibleColumnIndex());
        return vector.elements();
    }

    @Override
    public int getTotalColumnWidth() {
        if (this.getTrueColumnCount() == 0 || this.root == null) {
            return 0;
        }
        return this.root.getWidth(this.position, this.getLastVisibleColumnIndex());
    }

    public int getMaxTotalColumnWidth() {
        if (this.cellWidths == null) {
            return 0;
        }
        int n = NodeTableColumn.PREFERRED_WIDTH;
        if (this.root != null) {
            n = this.root.getSharedWidth();
        }
        return this.collapsedColumns.getMaxWidth(this.cellWidths[0], n);
    }

    protected int getLastVisibleColumnIndex() {
        if (this.transformArray == null || this.transformArray.length == 0) {
            return 0;
        }
        if (this.transformArray.length >= this.visibleColumns) {
            return this.transformArray[this.visibleColumns - 1] + 1;
        }
        return this.visibleColumns;
    }

    public void setColumnWidth(int n) {
        if (this.root != null) {
            this.root.setColumnWidth(n);
        }
    }

    public int getDepth() {
        if (this.root == null) {
            return 0;
        }
        return this.root.getDepth();
    }

    protected int[] getCellWidths() {
        return this.cellWidths;
    }

    public NodeTableColumn getRoot() {
        return this.root;
    }

    public NodeTableColumn getColumn(int n, int n2) {
        return this.root.getColumn(n, n2);
    }

    public void setViewable(int n, int n2, boolean bl) {
        this.root.getColumn(n, n2).setViewable(bl);
        this.rebuildTransformArray();
    }

    public void setViewable(NodeTableColumn nodeTableColumn, boolean bl) {
        nodeTableColumn.setViewable(bl);
        this.rebuildTransformArray();
    }

    public void collapseColumn(NodeTableColumn nodeTableColumn) throws ExceptionHugin {
        if (this.node == null) {
            return;
        }
        this.fireColumnCollapsing(nodeTableColumn.getModelIndex());
        this.collapsedColumns.add(nodeTableColumn.collapse());
        this.root = this.createRoot(this.node);
        this.fireColumnCollapsed(nodeTableColumn.getModelIndex());
    }

    protected void expandAll() throws ExceptionHugin {
        this.completeExpand(this.root);
    }

    private void completeExpand(NodeTableColumn nodeTableColumn) throws ExceptionHugin {
        if (nodeTableColumn.isCollapsed()) {
            this.expandColumn(nodeTableColumn);
        }
        for (NodeTableColumn nodeTableColumn2 : nodeTableColumn.children) {
            this.completeExpand(nodeTableColumn2);
        }
    }

    public void expandColumn(NodeTableColumn nodeTableColumn) throws ExceptionHugin {
        if (this.node == null) {
            return;
        }
        this.collapsedColumns.remove(nodeTableColumn.expand());
        this.root = this.createRoot(this.node);
        this.fireColumnExpanded(nodeTableColumn.getModelIndex());
    }

    private void rebuildTransformArray() {
        if (this.root == null) {
            return;
        }
        for (int i = 0; i < this.transformArray.length; ++i) {
            this.transformArray[i] = -1;
        }
        this.columnCount = this.root.transformColumns(0, this.transformArray);
    }

    public void setViewPosition(int n) throws ExceptionHugin {
        this.position = this.collapsedColumns.getViewPosition(n);
        this.root = this.createRoot(this.node);
        this.setAvailableWidth(this.width);
        ((NodeTableSelectionModel)this.getSelectionModel()).setPosition(this.position);
    }

    public int getViewPosition() {
        return this.position;
    }

    public void setVisibleColumns(int n) {
    }

    public int getVisibleColumns() {
        return this.visibleColumns;
    }

    protected int setAvailableWidth(int n) throws ExceptionHugin {
        this.width = n;
        this.position = Math.min(this.position, this.collapsedColumns.getMaxPosition(this.getFullColumnCount(), n));
        int n2 = this.visibleColumns;
        this.visibleColumns = this.calculateVisibleColumns();
        if (this.visibleColumns != n2) {
            this.root = this.createRoot(this.node);
        }
        if (this.root != null) {
            int n3 = this.root.getCollapsedColumnCount();
            int n4 = this.getVisibleColumns();
            if (n4 != n3) {
                int n5 = (n - n3 * NodeTableColumn.COLLAPSED_WIDTH) / (n4 - n3);
                this.root.setColumnWidth(n5);
            }
        }
        return this.visibleColumns;
    }

    int calculateVisibleColumns() {
        if (this.cellWidths == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.position;
        while (n3 < this.cellWidths[0] && n2 <= this.width) {
            if (this.collapsedColumns.isColumnCollapsed(n3)) {
                int n4 = this.collapsedColumns.getNextVisible(n3);
                if ((n2 += NodeTableColumn.COLLAPSED_WIDTH) <= this.width) {
                    ++n;
                }
                n3 = n4;
                continue;
            }
            ++n3;
            if ((n2 += NodeTableColumn.PREFERRED_WIDTH) > this.width) continue;
            ++n;
        }
        return Math.max(n, 1);
    }

    protected int[] buildCellWidthArray(NodeList nodeList) throws ExceptionHugin {
        int n = 0;
        for (Node node : nodeList) {
            if (!(node instanceof DiscreteNode)) continue;
            ++n;
        }
        Object object = new int[n + 1];
        if (((Object)object).length == 0) {
            return object;
        }
        object[((Object)object).length - 1] = true;
        if (((Object)object).length == 1) {
            return object;
        }
        int n2 = ((Object)object).length - 1;
        ListIterator listIterator = nodeList.listIterator(nodeList.size());
        while (listIterator.hasPrevious()) {
            Node node = (Node)listIterator.previous();
            if (!(node instanceof DiscreteNode)) continue;
            object[n2 - 1] = object[n2] * ((DiscreteNode)node).getNumberOfStates();
            --n2;
        }
        return object;
    }

    public boolean canCollapse(NodeTableColumn nodeTableColumn) {
        return this.collapsedColumns.canCollapse(new Collapse(nodeTableColumn.leftIndex, nodeTableColumn.rightIndex, nodeTableColumn.depth));
    }

    @Override
    public void moveColumn(int n, int n2) {
    }

    public Vector<TableColumn> getColumnsVector() {
        return this.tableColumns;
    }

    public static interface ColumnStateListener
    extends EventListener {
        public void columnCollapsing(int var1);

        public void columnCollapsed(int var1);

        public void columnExpanded(int var1);
    }

    static class Collapse {
        int leftIndex;
        int rightIndex;
        int depth;

        public Collapse(int n, int n2, int n3) {
            this.leftIndex = n;
            this.rightIndex = n2;
            this.depth = n3;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Collapse)) {
                return false;
            }
            Collapse collapse = (Collapse)object;
            return collapse.depth == this.depth && (collapse.rightIndex <= this.rightIndex && collapse.leftIndex >= this.leftIndex || collapse.rightIndex >= this.rightIndex && collapse.leftIndex <= this.leftIndex);
        }

        public String toString() {
            return "[" + this.leftIndex + "; " + this.rightIndex + ") at " + this.depth;
        }

        public Object clone() {
            return new Collapse(this.leftIndex, this.rightIndex, this.depth);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CollapseList
    extends LinkedList<Collapse> {
        private LinkedList<Collapse> collapseSum;
        private int PREFERRED_WIDTH = NodeTableColumn.PREFERRED_WIDTH;

        public CollapseList() {
            this.collapseSum = new LinkedList();
        }

        protected void setPreferredWidth(int n) {
            this.PREFERRED_WIDTH = n;
        }

        @Override
        public boolean add(Collapse collapse) {
            boolean bl = super.add(collapse);
            if (bl) {
                this.addToSum((Collapse)collapse.clone());
            }
            return bl;
        }

        public boolean remove(Collapse collapse) {
            boolean bl = super.remove(collapse);
            if (bl) {
                this.removeFromSum(collapse);
            }
            return bl;
        }

        public boolean canCollapse(Collapse collapse) {
            for (Collapse collapse2 : this) {
                if (collapse2.leftIndex > collapse.leftIndex || collapse2.rightIndex < collapse.rightIndex || collapse2.depth <= collapse.depth) continue;
                return false;
            }
            return true;
        }

        private void addToSum(Collapse collapse) {
            boolean bl = false;
            boolean bl2 = false;
            ListIterator<Collapse> listIterator = this.collapseSum.listIterator();
            while (listIterator.hasNext() && !bl) {
                Collapse collapse2 = (Collapse)listIterator.next();
                bl = collapse2.leftIndex >= collapse.rightIndex;
                boolean bl3 = bl2 = collapse2.leftIndex <= collapse.leftIndex && collapse2.rightIndex >= collapse.rightIndex;
                if (collapse.leftIndex > collapse2.leftIndex || collapse.rightIndex < collapse2.rightIndex) continue;
                listIterator.remove();
                collapse.leftIndex = Math.min(collapse2.leftIndex, collapse.leftIndex);
                collapse.rightIndex = Math.max(collapse2.rightIndex, collapse.rightIndex);
            }
            if (bl && listIterator.hasPrevious()) {
                listIterator.previous();
            }
            if (!bl2) {
                listIterator.add(collapse);
            }
        }

        private void removeFromSum(Collapse collapse) {
            Collapse collapse2 = null;
            ListIterator listIterator = this.collapseSum.listIterator();
            while (listIterator.hasNext()) {
                collapse2 = (Collapse)listIterator.next();
                if (collapse2.leftIndex > collapse.leftIndex || collapse2.rightIndex < collapse.rightIndex) continue;
            }
            if (collapse2 == null || collapse2.leftIndex > collapse.leftIndex || collapse2.rightIndex < collapse.rightIndex) {
                return;
            }
            listIterator.remove();
            for (Collapse collapse3 : this) {
                if (collapse3.leftIndex < collapse2.leftIndex || collapse3.rightIndex > collapse2.rightIndex) continue;
                this.addToSum(collapse3);
            }
        }

        public boolean isColumnCollapsed(int n) {
            for (Collapse collapse : this.collapseSum) {
                if (collapse.leftIndex <= n && collapse.rightIndex > n) {
                    return true;
                }
                if (collapse.rightIndex <= n) continue;
                return false;
            }
            return false;
        }

        public int getViewPosition(int n) {
            for (Collapse collapse : this.collapseSum) {
                if (collapse.leftIndex < n) {
                    n += collapse.rightIndex - collapse.leftIndex - 1;
                }
                if (collapse.leftIndex != n && collapse.rightIndex <= n) continue;
                return n;
            }
            return n;
        }

        public boolean isCollapsed(Collapse collapse) {
            for (Collapse collapse2 : this.collapseSum) {
                if (collapse2.depth >= collapse.depth && collapse2.leftIndex <= collapse.leftIndex && collapse2.rightIndex >= collapse.rightIndex) {
                    return true;
                }
                if (collapse2.rightIndex <= collapse.leftIndex) continue;
                return false;
            }
            return false;
        }

        public int getNextVisible(int n) {
            for (Collapse collapse : this.collapseSum) {
                if (collapse.leftIndex <= n && collapse.rightIndex > n) {
                    return collapse.rightIndex;
                }
                if (collapse.leftIndex < n) continue;
                break;
            }
            return n + 1;
        }

        public int[] getTransformArray(NodeTableColumnModel nodeTableColumnModel, int n, int n2) {
            int n3 = 0;
            int n4 = n;
            int n5 = 0;
            int[] nArray = new int[nodeTableColumnModel.getFullColumnCount() + 1];
            while (n3 < n2 && n4 <= nodeTableColumnModel.getFullColumnCount()) {
                nArray[n5++] = n4;
                if (this.isColumnCollapsed(n4)) {
                    n4 = this.getNextVisible(n4);
                    continue;
                }
                ++n4;
            }
            int[] nArray2 = new int[n5];
            for (n5 = 0; n5 < nArray2.length; ++n5) {
                nArray2[n5] = nArray[n5];
            }
            return nArray2;
        }

        public int getColumnCount(int n) {
            for (Collapse collapse : this.collapseSum) {
                n -= collapse.rightIndex - 1 - collapse.leftIndex;
            }
            return n;
        }

        public int getMaxWidth(int n, int n2) {
            int n3 = n * n2;
            for (Collapse collapse : this.collapseSum) {
                n3 -= (collapse.rightIndex - collapse.leftIndex) * n2 - NodeTableColumn.COLLAPSED_WIDTH;
            }
            return n3;
        }

        public int getMaxPosition(int n, int n2) {
            int n3 = n;
            int n4 = 0;
            ListIterator<Collapse> listIterator = this.collapseSum.listIterator(this.collapseSum.size());
            while (listIterator.hasPrevious()) {
                Collapse collapse = listIterator.previous();
                while (n3 > collapse.rightIndex && n4 <= n2) {
                    if ((n4 += this.PREFERRED_WIDTH) > n2) continue;
                    --n3;
                }
                if ((n4 += NodeTableColumn.COLLAPSED_WIDTH) > n2) continue;
                n3 = collapse.leftIndex;
            }
            while (n4 <= n2) {
                if ((n4 += NodeTableColumn.PREFERRED_WIDTH) > n2) continue;
                --n3;
            }
            return Math.max(0, n3);
        }
    }

    private class NodeTableSelectionModel
    extends DefaultListSelectionModel {
        private int anchor = 0;
        private int lead = -1;
        private int position = 0;

        private NodeTableSelectionModel() {
        }

        public void setPosition(int n) {
            this.position = n;
        }

        public void setAnchorSelectionIndex(int n) {
            this.lead = this.anchor = n + this.position;
            super.setAnchorSelectionIndex(n);
        }

        public void setLeadSelectionIndex(int n) {
            this.lead = n + this.position;
            super.setLeadSelectionIndex(n);
        }

        public void setSelectionInterval(int n, int n2) {
            this.anchor = this.position + n;
            this.lead = this.position + n2;
            super.setSelectionInterval(n, n2);
        }

        public int getSelectionMode() {
            return 1;
        }

        public void clearSelection() {
            this.anchor = -1;
            this.lead = -1;
        }

        public boolean isSelectedIndex(int n) {
            int n2 = Math.max(this.lead, this.anchor);
            int n3 = Math.min(this.lead, this.anchor);
            return n + this.position >= n3 && n + this.position <= n2;
        }

        public int getLead() {
            return this.lead;
        }

        public int getAnchorSelectionIndex() {
            return this.anchor - this.position;
        }

        protected boolean hasAnchor() {
            return super.getAnchorSelectionIndex() >= 0;
        }

        public int getAnchor() {
            return this.anchor;
        }
    }
}

