/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginFileLoader;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class NodeTableExportPanel
extends JDialog {
    File result;
    String chosenDelimiter;
    int operation;
    public static final int STYLE_FULL = 0;
    public static final int STYLE_STATES = 1;
    public static final int STYLE_CLEAN = 2;
    int style = 0;
    boolean fileEdited;
    private final int[] operations = new int[]{0, 1};
    JButton ok;
    JButton cancel;
    JTabbedPane tabs;
    JComboBox delimiter;
    JTextField writeDelimitedFile;
    JTextField writeLatexFile;
    JTextField writeExcelFile;
    JRadioButton styleFull;
    JRadioButton styleStates;
    JRadioButton styleClean;
    StyleExample styleExamples;

    public NodeTableExportPanel(int n) {
        super(Hugin.mainFrame, HuginGUIConstants.get("EXPORT_TABLE"), true);
        this.setContentPane(this.createContentPane(n));
        this.result = null;
        this.chosenDelimiter = null;
        this.fileEdited = false;
    }

    private JPanel createContentPane(int n) {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tabs = new JTabbedPane();
        this.tabs.add(this.createDelimitedPanel());
        jPanel.add(this.tabs);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        this.ok = new JButton(HuginGUIConstants.get("OK_button"));
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NodeTableExportPanel.this.operation = NodeTableExportPanel.this.operations[NodeTableExportPanel.this.tabs.getSelectedIndex()];
                switch (NodeTableExportPanel.this.operation) {
                    case 0: {
                        NodeTableExportPanel.this.chosenDelimiter = NodeTableExportPanel.this.delimiter.getSelectedItem() instanceof Delimiter ? ((Delimiter)NodeTableExportPanel.this.delimiter.getSelectedItem()).getDelimiter() : (String)NodeTableExportPanel.this.delimiter.getSelectedItem();
                        NodeTableExportPanel.this.result = new File(NodeTableExportPanel.this.writeDelimitedFile.getText());
                        break;
                    }
                    case 1: {
                        NodeTableExportPanel.this.result = new File(NodeTableExportPanel.this.writeLatexFile.getText());
                        break;
                    }
                    case 2: {
                        NodeTableExportPanel.this.result = new File(NodeTableExportPanel.this.writeExcelFile.getText());
                        NodeTableExportPanel.this.style = NodeTableExportPanel.this.styleExamples.getStyle();
                    }
                }
                if (NodeTableExportPanel.this.fileEdited && NodeTableExportPanel.this.result.exists() && JOptionPane.showConfirmDialog(Hugin.mainFrame, HuginGUIConstants.get("MISCELLANEOUS_overwrite_file"), HuginGUIConstants.get("EXPORT_TABLE"), 0, 3, null) == 1) {
                    NodeTableExportPanel.this.result = null;
                    return;
                }
                NodeTableExportPanel.this.dispose();
            }
        });
        jPanel2.add(this.ok);
        this.cancel = new JButton(HuginGUIConstants.get("cancel_button"));
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NodeTableExportPanel.this.chosenDelimiter = null;
                NodeTableExportPanel.this.dispose();
            }
        });
        jPanel2.add(this.cancel);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private JPanel createDelimitedPanel() {
        JPanel jPanel = new JPanel(new VerticalFlowLayout());
        jPanel.setName(HuginGUIConstants.get("EXPORT_TABLE_Delimited"));
        JPanel jPanel2 = new JPanel(new VerticalFlowLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("EXPORT_TABLE_Delimiter")));
        JLabel jLabel = new JLabel(HuginGUIConstants.get("EXPORT_TABLE_Choose_Delimiter"));
        Delimiter[] delimiterArray = new Delimiter[]{new Delimiter(","), new Delimiter("\t", "<tab>"), new Delimiter(" ", "<space>")};
        this.delimiter = new JComboBox<Delimiter>(delimiterArray);
        this.delimiter.setEditable(true);
        jPanel.add(jLabel);
        jPanel.add(this.delimiter);
        JPanel jPanel3 = new JPanel(new FlowLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("EXPORT_TABLE_File")));
        JPanel jPanel4 = new JPanel(new VerticalFlowLayout());
        this.writeDelimitedFile = new JTextField(15);
        this.writeDelimitedFile.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                NodeTableExportPanel.this.fileEdited = true;
            }
        });
        jPanel4.add(this.writeDelimitedFile);
        JButton jButton = new JButton(HuginGUIConstants.get("BUG_REPORT_SELECT_FILE"));
        SelectFileListener selectFileListener = new SelectFileListener();
        selectFileListener.setDestination(this.writeDelimitedFile);
        jButton.addActionListener(selectFileListener);
        jPanel4.add(jButton);
        jPanel3.add(jPanel4);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private JPanel createLatexPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setName(HuginGUIConstants.get("EXPORT_TABLE_Latex"));
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("EXPORT_TABLE_File")));
        JPanel jPanel3 = new JPanel(new VerticalFlowLayout());
        this.writeLatexFile = new JTextField(15);
        this.writeLatexFile.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                NodeTableExportPanel.this.fileEdited = true;
            }
        });
        jPanel3.add(this.writeLatexFile);
        JButton jButton = new JButton(HuginGUIConstants.get("BUG_REPORT_SELECT_FILE"));
        SelectFileListener selectFileListener = new SelectFileListener();
        selectFileListener.setDestination(this.writeLatexFile);
        jButton.addActionListener(selectFileListener);
        jPanel3.add(jButton);
        jPanel2.add(jPanel3);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JPanel createExcelPanel(int n) {
        if (n >= Short.MAX_VALUE) {
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel(HuginGUIConstants.get("str_cannot_export_more_than_") + Short.MAX_VALUE + HuginGUIConstants.get("str__cells")));
            jPanel.setName(HuginGUIConstants.get("EXPORT_TABLE_Excel"));
            return jPanel;
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setName(HuginGUIConstants.get("EXPORT_TABLE_Excel"));
        JPanel jPanel2 = new JPanel(new VerticalFlowLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("EXPORT_TABLE_File")));
        JPanel jPanel3 = new JPanel(new VerticalFlowLayout());
        this.writeExcelFile = new JTextField(15);
        this.writeExcelFile.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                NodeTableExportPanel.this.fileEdited = true;
            }
        });
        jPanel3.add(this.writeExcelFile);
        JButton jButton = new JButton(HuginGUIConstants.get("BUG_REPORT_SELECT_FILE"));
        SelectFileListener selectFileListener = new SelectFileListener();
        selectFileListener.setDestination(this.writeExcelFile);
        jButton.addActionListener(selectFileListener);
        jPanel3.add(jButton);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("EXPORT_TABLE_Excel_style")));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.styleFull = new JRadioButton(HuginGUIConstants.get("EXPORT_TABLE_Excel_style_full"));
        this.styleFull.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NodeTableExportPanel.this.styleExamples.setStyle(0);
            }
        });
        this.styleFull.setSelected(true);
        this.styleStates = new JRadioButton(HuginGUIConstants.get("EXPORT_TABLE_Excel_style_states"));
        this.styleStates.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NodeTableExportPanel.this.styleExamples.setStyle(1);
            }
        });
        this.styleClean = new JRadioButton(HuginGUIConstants.get("EXPORT_TABLE_Excel_style_clean"));
        this.styleClean.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NodeTableExportPanel.this.styleExamples.setStyle(2);
            }
        });
        buttonGroup.add(this.styleFull);
        buttonGroup.add(this.styleStates);
        buttonGroup.add(this.styleClean);
        JPanel jPanel5 = new JPanel(new GridLayout(3, 1));
        jPanel5.add(this.styleFull);
        jPanel5.add(this.styleStates);
        jPanel5.add(this.styleClean);
        jPanel4.add((Component)jPanel5, "North");
        this.styleExamples = new StyleExample();
        jPanel4.add((Component)this.styleExamples, "South");
        jPanel2.add(jPanel3);
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    protected File getFile() {
        return this.result;
    }

    protected String getDelimiter() {
        return this.chosenDelimiter;
    }

    protected int getOperation() {
        return this.operation;
    }

    protected int getStyle() {
        return this.style;
    }

    private class SelectFileListener
    implements ActionListener {
        HuginFileLoader loader = new HuginFileLoader(11, 4);
        JTextField dest = null;

        public void actionPerformed(ActionEvent actionEvent) {
            File file = new File(this.dest.getText());
            if (file.exists()) {
                this.loader.setCurrentDirectory(file);
            } else {
                this.loader.setCurrentDirectory(Hugin.mainFrame.getMostRecentDataFile());
            }
            if (this.dest == null) {
                return;
            }
            if (this.loader.showSaveDialog(Hugin.mainFrame) == 0) {
                this.dest.setText(this.loader.getSelectedFile().getPath());
                NodeTableExportPanel.this.fileEdited = false;
            }
        }

        public void setDestination(JTextField jTextField) {
            this.dest = jTextField;
        }
    }

    private class Delimiter {
        String delimiter;
        String text;

        public Delimiter(String string) {
            this(string, string);
        }

        public Delimiter(String string, String string2) {
            this.delimiter = string;
            this.text = string2;
        }

        public String toString() {
            return this.text;
        }

        public String getDelimiter() {
            return this.delimiter;
        }
    }

    private class StyleExample
    extends JPanel {
        private JPanel table_header;
        private JPanel table;
        private JPanel header;
        private JPanel states;
        private JPanel state_parents;
        private JPanel parents;
        private int style;
        public static final int STYLE_FULL = 0;
        public static final int STYLE_STATES = 1;
        public static final int STYLE_CLEAN = 2;

        public StyleExample() {
            JLabel jLabel;
            int n;
            super(new BorderLayout());
            this.style = 0;
            this.table = new JPanel(new GridLayout(2, 4));
            this.header = new JPanel(new GridLayout(2, 1));
            this.table_header = new JPanel(new GridLayout(2, 1));
            this.table_header.add(this.header);
            this.table_header.add(this.table);
            this.add(this.table_header);
            this.states = new JPanel(new GridLayout(2, 1));
            this.parents = new JPanel(new GridLayout(2, 1));
            this.state_parents = new JPanel(new GridLayout(2, 1));
            this.state_parents.add(this.parents);
            this.state_parents.add(this.states);
            this.add((Component)this.state_parents, "West");
            for (n = 0; n < 8; ++n) {
                jLabel = new JLabel("" + n);
                jLabel.setBackground(Color.white);
                jLabel.setOpaque(true);
                jLabel.setBorder(BorderFactory.createLineBorder(Color.gray));
                jLabel.setHorizontalAlignment(4);
                this.table.add(jLabel);
            }
            for (n = 0; n < 2; ++n) {
                jLabel = new JLabel(HuginGUIConstants.get("str_state_") + (n + 1));
                jLabel.setBorder(BorderFactory.createLineBorder(Color.black));
                this.states.add(jLabel);
            }
            for (n = 0; n < 2; ++n) {
                jLabel = new JLabel("P" + (n + 1));
                jLabel.setBorder(BorderFactory.createRaisedBevelBorder());
                jLabel.setHorizontalAlignment(0);
                this.parents.add(jLabel);
            }
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            for (int i = 0; i < 2; ++i) {
                jLabel = new JLabel(HuginGUIConstants.get("str_state_") + (i + 1));
                jLabel.setBorder(BorderFactory.createLineBorder(Color.black));
                jLabel.setHorizontalAlignment(0);
                jPanel.add(jLabel);
            }
            JPanel jPanel2 = new JPanel(new GridLayout(1, 4));
            for (int i = 0; i < 4; ++i) {
                jLabel = new JLabel(HuginGUIConstants.get("str_state_") + (i % 2 + 1));
                jLabel.setBorder(BorderFactory.createLineBorder(Color.black));
                jLabel.setHorizontalAlignment(0);
                jPanel2.add(jLabel);
            }
            this.header.add(jPanel);
            this.header.add(jPanel2);
        }

        public void setStyle(int n) {
            this.style = n;
            switch (n) {
                case 0: {
                    this.removeAll();
                    this.table_header.removeAll();
                    this.state_parents.removeAll();
                    this.table_header.add(this.header);
                    this.table_header.add(this.table);
                    this.add(this.table_header);
                    this.state_parents.add(this.parents);
                    this.state_parents.add(this.states);
                    this.add((Component)this.state_parents, "West");
                    break;
                }
                case 1: {
                    this.removeAll();
                    this.add(this.table);
                    this.add((Component)this.states, "West");
                    break;
                }
                case 2: {
                    this.removeAll();
                    this.add(this.table);
                }
            }
            this.revalidate();
            this.repaint();
        }

        public int getStyle() {
            return this.style;
        }
    }
}

