/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.BooleanDCNode;
import COM.hugin.HAPI.BooleanDDNode;
import COM.hugin.HAPI.DiscreteDecisionNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.FunctionNode;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HAPI.IntervalDDNode;
import COM.hugin.HAPI.Model;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.NumberedDCNode;
import COM.hugin.HAPI.NumberedDDNode;
import COM.hugin.HAPI.UtilityNode;
import COM.hugin.HGUI.ContinuousChanceNode;
import COM.hugin.HGUI.DiscreteChanceNode;
import COM.hugin.HGUI.DiscreteChanceNodeTableModel;
import COM.hugin.HGUI.DiscreteDecisionNodeTableModel;
import COM.hugin.HGUI.DiscreteNode;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIEventHandler;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginHelpConstants;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.NodeNamingPane;
import COM.hugin.HGUI.NodeTable;
import COM.hugin.HGUI.NodeTableFrameEvents;
import COM.hugin.HGUI.NodeTableFrameInterface;
import COM.hugin.HGUI.TableWrapper;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.EventListener;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class NodeTableFrame
extends JInternalFrame
implements NodeTableFrameInterface {
    JMenuBar menu = null;
    NodeTable table;
    Node node;
    private static final double MAX_VICINITY_RADIUS = 20.0;
    private LinkedList<TableUpdateListener> updateListeners;
    ImageIcon huginIcon;
    JMenuItem edit_copy;
    JMenuItem edit_paste;
    JMenuItem edit_rename;
    JMenuItem randomize;
    JMenuItem normalize;
    JMenu reset;
    JMenuItem resetCPT;
    JMenuItem resetExperience;
    JMenuItem resetFading;
    JMenuItem function_create_fading;
    JMenuItem function_create_experience;
    JMenuItem function_delete_fading;
    JMenuItem function_delete_experience;
    JMenu fadingExperienceItems;
    JMenu expressions;
    JMenuItem showExpressions;
    JMenuItem showManual;
    JMenuItem generateTable;
    JMenuItem transferTable;
    JMenuItem buildExpression;
    JMenuItem samplesInterval;
    JMenu addModelNode;
    JMenu removeModelNode;
    JMenu convertNode;
    JMenuItem toLabelled;
    JMenuItem toBoolean;
    JMenuItem toNumbered;
    JMenuItem toInterval;
    JMenuItem exportTable;
    JMenuItem importTable;
    JMenuItem statesGenerator;
    JMenuItem view_display_node;
    JMenuItem view_toggle_fading;
    JMenuItem view_toggle_experience;
    JMenuItem view_bar_mode;
    JMenuItem view_normal_mode;
    JMenuItem view_pure_bar_mode;
    JMenuItem auto_normalize;
    JMenuItem view_toggle_state_labels;
    JMenuItem view_table_precision;
    JMenuItem view_table_mode;
    JMenuItem view_node_properties;
    JMenuItem view_colorchart_normalization;
    JMenu displayMode;
    JMenu colorChartMode;
    private boolean tableStructureChanged = false;
    private static final char DESC_SEP_CHAR = HuginGUIConstants.get("DESC_SEP_CHAR").charAt(0);

    public NodeTableFrame(Node node, int n, int n2) throws ExceptionHugin {
        this(node);
        Dimension dimension = this.getPreferredSize();
        dimension.width = Math.min(n, dimension.width);
        dimension.height = Math.min(n2, dimension.height);
        this.setSize(dimension.width, dimension.height);
    }

    public NodeTableFrame(Node node) throws ExceptionHugin {
        super("Dummy", true, true);
        this.setDefaultCloseOperation(0);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                if (Hugin.mainFrame.preferences.node_table_connection_mode == 0) {
                    NodeTableFrame.this.node.panel.deselectNode(NodeTableFrame.this.node);
                } else {
                    NodeTableFrame.this.node.hideTable();
                }
            }
        });
        this.node = node;
        String string = HuginGUIUtils.getNodeTitle(node.getAPINode());
        this.setTitle(string);
        this.table = new NodeTable(node);
        this.table.addStateTableChangeListener(new StateTableChangeListener(){

            public void stateTableChanged() {
                try {
                    for (Node node : NodeTableFrame.this.node.getChildren()) {
                        node.updateTableParentStateNames();
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        this.table.addTableChangeListener(new TableChangeListener(){

            public void tableChanged() {
                NodeTableFrame.this.node.panel.containsUncompiledChanges(true);
                NodeTableFrame.this.node.panel.containsUnsavedChanges(true);
            }
        });
        this.table.addStateTableResizedListener(new StateTableResizedListener(){

            public void stateTableResized() {
                NodeTableFrame.this.checkMinimumSizeConstraint();
            }
        });
        this.table.addNeedsFakeResizeListener(new NeedsFakeResizeListener());
        this.setContentPane(new TableWrapper(this.table, this.table, this.table.getGUINode().getVisualCPT()));
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
                if (NodeTableFrame.this.menu == null) {
                    try {
                        NodeTableFrame.this.menu = NodeTableFrame.this.createMenu();
                        NodeTableFrame.this.setJMenuBar(NodeTableFrame.this.menu);
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                    }
                    NodeTableFrame.this.tableStructureChanged();
                }
            }
        });
        JComponent jComponent = ((BasicInternalFrameUI)this.getUI()).getNorthPane();
        if (jComponent != null) {
            jComponent.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.isControlDown() || SwingUtilities.isRightMouseButton(mouseEvent)) {
                        NodeNamingPane nodeNamingPane = new NodeNamingPane(Hugin.mainFrame.getSelectedProjectFrame(), NodeTableFrame.this.node);
                        Point point = new Point(0, 0);
                        SwingUtilities.convertPointToScreen(point, NodeTableFrame.this);
                        nodeNamingPane.setLocation((int)point.getX(), (int)point.getY());
                        nodeNamingPane.pack();
                        nodeNamingPane.setVisible(true);
                        try {
                            NodeTableFrame.this.node.updateChildTables();
                        }
                        catch (Exception exception) {
                            new HuginGUIError(HuginGUIConstants.get("str_unable_to_update_the_tables_of_all_child_nodes_lb") + exception.getMessage());
                        }
                        try {
                            NodeTableFrame.this.setTitle(HuginGUIUtils.getNodeTitle(NodeTableFrame.this.node.getAPINode()));
                        }
                        catch (Exception exception) {
                            new HuginGUIError(exception);
                        }
                        Hugin.mainFrame.getSelectedProjectFrame().getNetworkPanel().repaint(NodeTableFrame.this.node.getBoundingBox(false));
                    }
                }
            });
        }
        this.huginIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("icons/hugin.gif")));
        this.updateListeners = new LinkedList();
    }

    public Icon getFrameIcon() {
        return this.huginIcon;
    }

    protected boolean inVicinityOf(int n, int n2) {
        double d;
        double d2 = this.getX() - n;
        return Math.sqrt(d2 * d2 + (d = (double)(this.getY() - n2)) * d) < 20.0;
    }

    protected boolean inVicinityOfX(int n) {
        return (double)Math.abs(this.getX() - n) < 20.0;
    }

    protected boolean inVicinityOfY(int n) {
        return (double)Math.abs(this.getY() - n) < 20.0;
    }

    public Node getNode() {
        return this.node;
    }

    public NodeTable getTable() {
        return this.table;
    }

    public void restoreTable() throws ExceptionHugin {
        this.table.setMaxBounds(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.setContentPane(new TableWrapper(this.table, this.table, this.table.getGUINode().getVisualCPT()));
        this.setJMenuBar(this.getMenu());
    }

    public void updateStateNames() throws ExceptionHugin {
        this.setTitle(HuginGUIUtils.getNodeTitle(this.node.getAPINode()));
        this.setSize(this.getWidth() + 1, this.getHeight());
        this.setSize(this.getWidth() - 1, this.getHeight());
        this.createAddModelNodeMenu();
        this.fireTableUpdated();
    }

    public void update() throws ExceptionHugin {
        this.setTitle(HuginGUIUtils.getNodeTitle(this.node.getAPINode()));
        boolean bl = false;
        if (this.table.canShowExpressions() && this.node.getAPINode().getModel() == null && this.table.showExpressions()) {
            this.table.modelDeleted(false);
            bl = true;
        }
        this.table.setNode(this.node.getAPINode());
        if (bl) {
            this.showExpressions(false);
        }
        if (this.table.showExpressions()) {
            this.table.forceVisibleExpressionsRepaint();
        }
        this.setSize(this.getWidth() + 1, this.getHeight());
        this.setSize(this.getWidth() - 1, this.getHeight());
        this.createAddModelNodeMenu();
        this.fireTableUpdated();
    }

    public void addTableChangeListener(TableChangeListener tableChangeListener) {
        this.table.addTableChangeListener(tableChangeListener);
    }

    public void removeTableChangeListener(TableChangeListener tableChangeListener) {
        this.table.removeTableChangeListener(tableChangeListener);
    }

    public void dispose() {
        this.table.getCPT().stopEditing();
        if (this.table.showExpressions()) {
            this.table.getExpressionTable().stopEditing();
        }
        this.table.dispose();
        super.dispose();
    }

    protected JMenuBar getMenu() throws ExceptionHugin {
        if (this.menu == null) {
            this.menu = this.createMenu();
        }
        return this.menu;
    }

    private JMenuBar createMenu() throws ExceptionHugin {
        MouseHandler mouseHandler = new MouseHandler(Hugin.mainFrame.getStatusBar());
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(new NodeTableFrameEvents.EDIT_Action());
        jMenu.addMenuListener(new EditMenuListener());
        Hugin.helpManager.registerComponent(jMenu, HuginHelpConstants.HELP_FILE_node_table_tutorial_edit);
        this.edit_copy = new JMenuItem(new NodeTableFrameEvents.EDIT_Copy_Action(this));
        this.edit_copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.edit_copy.addMouseListener(mouseHandler);
        jMenu.add(this.edit_copy);
        Hugin.helpManager.registerComponent(this.edit_copy, HuginHelpConstants.HELP_FILE_node_table_tutorial_edit);
        this.edit_paste = new JMenuItem(new NodeTableFrameEvents.EDIT_Paste_Action(this));
        this.edit_paste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.edit_paste.addMouseListener(mouseHandler);
        jMenu.add(this.edit_paste);
        Hugin.helpManager.registerComponent(this.edit_paste, HuginHelpConstants.HELP_FILE_node_table_tutorial_edit);
        this.edit_rename = new JMenuItem(new NodeTableFrameEvents.EDIT_Rename_Action(this));
        this.edit_rename.addMouseListener(mouseHandler);
        jMenu.add(this.edit_rename);
        Hugin.helpManager.registerComponent(this.edit_rename, HuginHelpConstants.HELP_FILE_node_table_tutorial_edit);
        this.normalize = new JMenuItem(new NodeTableFrameEvents.EDIT_Normalize_Action(this));
        this.normalize.addMouseListener(mouseHandler);
        jMenu.add(this.normalize);
        Hugin.helpManager.registerComponent(this.normalize, HuginHelpConstants.HELP_FILE_node_table_tutorial_edit);
        this.reset = new JMenu(new NodeTableFrameEvents.EDIT_Reset_Action(this));
        Hugin.helpManager.registerComponent(this.reset, HuginHelpConstants.HELP_FILE_node_table_tutorial_edit);
        this.resetCPT = new JMenuItem(new NodeTableFrameEvents.EDIT_Reset_CPT_Action(this));
        this.resetCPT.addMouseListener(mouseHandler);
        this.resetCPT.setEnabled(!this.table.showExpressions());
        this.reset.add(this.resetCPT);
        this.resetExperience = new JMenuItem(new NodeTableFrameEvents.EDIT_Reset_Experience_Action(this));
        this.resetExperience.addMouseListener(mouseHandler);
        this.resetExperience.setEnabled(this.table.showExperience());
        this.reset.add(this.resetExperience);
        this.resetFading = new JMenuItem(new NodeTableFrameEvents.EDIT_Reset_Fading_Action(this));
        this.resetFading.addMouseListener(mouseHandler);
        this.resetFading.setEnabled(this.table.showFading());
        this.reset.add(this.resetFading);
        jMenu.add(this.reset);
        this.randomize = new JMenuItem(new NodeTableFrameEvents.EDIT_Randomize_Action(this));
        this.randomize.addMouseListener(mouseHandler);
        jMenu.add(this.randomize);
        Hugin.helpManager.registerComponent(this.randomize, HuginHelpConstants.HELP_FILE_node_table_tutorial_edit);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu(new NodeTableFrameEvents.FUNCTIONS_Action());
        jMenu2.addMenuListener(new FunctionMenuListener());
        Hugin.helpManager.registerComponent(jMenu2, HuginHelpConstants.HELP_FILE_node_table_tutorial_functions);
        this.fadingExperienceItems = new JMenu(new NodeTableFrameEvents.FUNCTIONS_Fading_Experience_Action());
        this.function_create_experience = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Create_Experience_Action(this));
        this.function_create_experience.addMouseListener(mouseHandler);
        this.fadingExperienceItems.add(this.function_create_experience);
        Hugin.helpManager.registerComponent(this.function_create_experience, HuginHelpConstants.HELP_FILE_experience_table);
        this.function_create_fading = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Create_Fading_Action(this));
        this.function_create_fading.addMouseListener(mouseHandler);
        this.fadingExperienceItems.add(this.function_create_fading);
        Hugin.helpManager.registerComponent(this.function_create_fading, HuginHelpConstants.HELP_FILE_fading_table);
        this.function_delete_experience = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Delete_Experience_Action(this));
        this.function_delete_experience.addMouseListener(mouseHandler);
        this.fadingExperienceItems.add(this.function_delete_experience);
        this.function_delete_fading = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Delete_Fading_Action(this));
        this.function_delete_fading.addMouseListener(mouseHandler);
        this.fadingExperienceItems.add(this.function_delete_fading);
        jMenu2.add(this.fadingExperienceItems);
        boolean bl = this.table.getNode() instanceof FunctionNode;
        this.expressions = new JMenu(new NodeTableFrameEvents.FUNCTIONS_Expressions_Action());
        this.expressions.setEnabled(this.table.canShowExpressions());
        this.showExpressions = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Switch_To_Expression_Action(this));
        this.showExpressions.setEnabled(!this.table.showExpressions());
        this.showExpressions.addMouseListener(mouseHandler);
        this.expressions.add(this.showExpressions);
        Hugin.helpManager.registerComponent(this.showExpressions, HuginHelpConstants.HELP_FILE_expressions);
        this.showManual = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Switch_To_Manual_Action(this));
        this.showManual.setEnabled(!bl && this.table.showExpressions());
        this.showManual.addMouseListener(mouseHandler);
        this.expressions.add(this.showManual);
        Hugin.helpManager.registerComponent(this.showManual, HuginHelpConstants.HELP_FILE_manual_table);
        this.generateTable = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Generate_Table_Action(this));
        this.generateTable.addMouseListener(mouseHandler);
        this.generateTable.setEnabled(!bl && this.table.showExpressions());
        this.expressions.add(this.generateTable);
        this.transferTable = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Transfer_Table_Action(this));
        this.transferTable.addMouseListener(mouseHandler);
        this.transferTable.setEnabled(!bl && this.table.showExpressions());
        this.expressions.add(this.transferTable);
        this.buildExpression = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Build_Expression_Action(this));
        this.buildExpression.addMouseListener(mouseHandler);
        this.buildExpression.setEnabled(this.table.canShowExpressions());
        this.expressions.add(this.buildExpression);
        Hugin.helpManager.registerComponent(this.buildExpression, HuginHelpConstants.HELP_FILE_expression_builder);
        this.samplesInterval = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Samples_per_Interval_Action(this));
        this.samplesInterval.addMouseListener(mouseHandler);
        this.samplesInterval.setEnabled(this.table.showExpressions());
        this.expressions.add(this.samplesInterval);
        this.addModelNode = new JMenu(new NodeTableFrameEvents.FUNCTIONS_Add_Model_Node_Item_Action());
        this.createAddModelNodeMenu();
        this.addModelNode.setEnabled(this.table.showExpressions());
        this.expressions.add(this.addModelNode);
        Hugin.helpManager.registerComponent(this.addModelNode, HuginHelpConstants.HELP_FILE_model);
        this.removeModelNode = new JMenu(new NodeTableFrameEvents.FUNCTIONS_Remove_Model_Node_Item_Action());
        this.createRemoveModelNodeMenu();
        this.removeModelNode.setEnabled(this.table.showExpressions());
        this.expressions.add(this.removeModelNode);
        Hugin.helpManager.registerComponent(this.removeModelNode, HuginHelpConstants.HELP_FILE_model);
        jMenu2.add(this.expressions);
        this.convertNode = new JMenu(new NodeTableFrameEvents.FUNCTIONS_Convert_Node_Action());
        this.toLabelled = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Convert_Node_To_Labelled_Action(this));
        this.toLabelled.addMouseListener(mouseHandler);
        this.convertNode.add(this.toLabelled);
        Hugin.helpManager.registerComponent(this.toLabelled, HuginHelpConstants.HELP_FILE_node_type);
        this.toBoolean = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Convert_Node_To_Boolean_Action(this));
        this.toBoolean.addMouseListener(mouseHandler);
        this.convertNode.add(this.toBoolean);
        Hugin.helpManager.registerComponent(this.toBoolean, HuginHelpConstants.HELP_FILE_node_type);
        this.toNumbered = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Convert_Node_To_Numbered_Action(this));
        this.toNumbered.addMouseListener(mouseHandler);
        this.convertNode.add(this.toNumbered);
        Hugin.helpManager.registerComponent(this.toNumbered, HuginHelpConstants.HELP_FILE_node_type);
        this.toInterval = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Convert_Node_To_Interval_Action(this));
        this.toInterval.addMouseListener(mouseHandler);
        this.convertNode.add(this.toInterval);
        Hugin.helpManager.registerComponent(this.toInterval, HuginHelpConstants.HELP_FILE_node_type);
        jMenu2.add(this.convertNode);
        this.exportTable = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Export_Table_Action(this));
        this.exportTable.addMouseListener(mouseHandler);
        jMenu2.add(this.exportTable);
        this.importTable = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Import_Table_Action(this));
        this.importTable.addMouseListener(mouseHandler);
        jMenu2.add(this.importTable);
        this.statesGenerator = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_States_Generator_Action(this));
        this.statesGenerator.addMouseListener(mouseHandler);
        jMenu2.add(this.statesGenerator);
        this.statesGenerator.setEnabled(this.node.isDiscrete() && !this.node.isBoolean());
        jMenuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu(new NodeTableFrameEvents.VIEW_Action());
        jMenu3.addMenuListener(new ViewMenuListener());
        Hugin.helpManager.registerComponent(jMenu3, HuginHelpConstants.HELP_FILE_node_table_tutorial_view);
        this.displayMode = new JMenu(new NodeTableFrameEvents.VIEW_Display_Mode_Action());
        this.view_normal_mode = new JMenuItem(new NodeTableFrameEvents.VIEW_Normal_Mode_Action(this));
        this.view_normal_mode.addMouseListener(mouseHandler);
        this.displayMode.add(this.view_normal_mode);
        this.view_bar_mode = new JMenuItem(new NodeTableFrameEvents.VIEW_Bar_Mode_Action(this));
        this.view_bar_mode.addMouseListener(mouseHandler);
        this.displayMode.add(this.view_bar_mode);
        this.view_pure_bar_mode = new JMenuItem(new NodeTableFrameEvents.VIEW_Pure_Bars_Mode_Action(this));
        this.view_pure_bar_mode.addMouseListener(mouseHandler);
        this.displayMode.add(this.view_pure_bar_mode);
        this.auto_normalize = new JMenuItem(new NodeTableFrameEvents.VIEW_Auto_Normalize_Action(this));
        this.auto_normalize.addMouseListener(mouseHandler);
        this.displayMode.add(this.auto_normalize);
        jMenu3.add(this.displayMode);
        this.view_colorchart_normalization = new JMenuItem(new NodeTableFrameEvents.VIEW_colorchart_normalization_Action(this.table.getGUINode().getVisualCPT()));
        this.view_colorchart_normalization.addMouseListener(mouseHandler);
        jMenu3.add(this.view_colorchart_normalization);
        this.view_display_node = new JMenuItem(new NodeTableFrameEvents.VIEW_Show_Node_Action(this));
        this.view_display_node.addMouseListener(mouseHandler);
        jMenu3.add(this.view_display_node);
        this.view_toggle_experience = new JMenuItem(new NodeTableFrameEvents.VIEW_Toggle_Experience_Action(this));
        this.view_toggle_experience.addMouseListener(mouseHandler);
        jMenu3.add(this.view_toggle_experience);
        this.view_toggle_fading = new JMenuItem(new NodeTableFrameEvents.VIEW_Toggle_Fading_Action(this));
        this.view_toggle_fading.addMouseListener(mouseHandler);
        jMenu3.add(this.view_toggle_fading);
        this.view_toggle_state_labels = new JMenuItem(new NodeTableFrameEvents.VIEW_Toggle_State_Value_Labels_Action(this));
        this.view_toggle_state_labels.addMouseListener(mouseHandler);
        jMenu3.add(this.view_toggle_state_labels);
        this.view_table_precision = new JMenuItem(new NodeTableFrameEvents.VIEW_Table_Precision_Action(this));
        this.view_table_precision.addMouseListener(mouseHandler);
        jMenu3.add(this.view_table_precision);
        this.view_table_mode = new JMenuItem(new NodeTableFrameEvents.VIEW_Table_Mode_Action());
        this.view_table_mode.addMouseListener(mouseHandler);
        jMenu3.add(this.view_table_mode);
        Hugin.helpManager.registerComponent(this.view_table_mode, HuginHelpConstants.HELP_FILE_node_table_tutorial);
        jMenu3.addSeparator();
        this.view_node_properties = new JMenuItem(new HuginGUIEventHandler.MENU_EDIT_Node_PropertiesAction(Hugin.mainFrame, this.getNode()));
        this.view_node_properties.addMouseListener(mouseHandler);
        jMenu3.add(this.view_node_properties);
        Hugin.helpManager.registerComponent(this.view_node_properties, HuginHelpConstants.HELP_FILE_node_properties);
        jMenuBar.add(jMenu3);
        return jMenuBar;
    }

    public void showExpressions(boolean bl) throws ExceptionHugin {
        if (bl == this.table.showExpressions()) {
            return;
        }
        this.table.showExpressions(bl);
        if (this.showExpressions != null) {
            if (this.table.getNode() instanceof FunctionNode) {
                this.showExpressions.setEnabled(!bl);
                this.showManual.setEnabled(false);
                this.generateTable.setEnabled(false);
                this.transferTable.setEnabled(false);
                this.buildExpression.setEnabled(this.table.canShowExpressions());
                this.samplesInterval.setEnabled(bl);
                this.addModelNode.setEnabled(bl);
                this.removeModelNode.setEnabled(bl);
            } else {
                this.showExpressions.setEnabled(!bl);
                this.showManual.setEnabled(bl);
                this.generateTable.setEnabled(bl);
                this.transferTable.setEnabled(bl);
                this.buildExpression.setEnabled(this.table.canShowExpressions());
                this.samplesInterval.setEnabled(bl);
                this.addModelNode.setEnabled(bl);
                this.removeModelNode.setEnabled(bl);
            }
        }
        this.table.getGUINode().getVisualCPT().repaint();
        this.tableStructureChanged();
    }

    public void setSelected(boolean bl) throws PropertyVetoException {
        super.setSelected(bl);
        if (!bl) {
            this.table.stopEditing();
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension;
        Insets insets = this.getInsets();
        Dimension dimension2 = this.getContentPane().getPreferredSize();
        Dimension dimension3 = new Dimension(insets.left + insets.right + dimension2.width, insets.top + insets.bottom + dimension2.height);
        BasicInternalFrameUI basicInternalFrameUI = (BasicInternalFrameUI)this.getUI();
        if (basicInternalFrameUI.getNorthPane() != null) {
            dimension = basicInternalFrameUI.getNorthPane().getPreferredSize();
            dimension3.width = Math.max(dimension3.width, dimension.width);
            dimension3.height += dimension.height;
        }
        if (this.getJMenuBar() != null) {
            dimension = this.getJMenuBar().getPreferredSize();
            dimension3.width = Math.max(dimension3.width, dimension.width);
            dimension3.height += dimension.height;
        } else {
            dimension = new JMenu("test").getPreferredSize();
            dimension3.height += dimension.height + 2;
        }
        return dimension3;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.getContentPane().getMinimumSize();
        if (this.menu != null) {
            dimension.height += this.menu.getPreferredSize().height;
            if (this.getJMenuBar() != null) {
                dimension.width = Math.max(dimension.width, this.getJMenuBar().getPreferredSize().width);
            }
        }
        if (((BasicInternalFrameUI)this.getUI()).getNorthPane() != null) {
            dimension.height += ((BasicInternalFrameUI)this.getUI()).getNorthPane().getPreferredSize().height;
        }
        Insets insets = this.getInsets();
        dimension.height += insets.top + insets.bottom;
        dimension.width += insets.left + insets.right;
        return dimension;
    }

    protected Model getModel(NodeList nodeList) throws ExceptionHugin {
        return this.table.getModel(nodeList);
    }

    private void tableStructureChanged() {
        this.tableStructureChanged = true;
    }

    public void checkMinimumSizeConstraint() {
        Dimension dimension = this.getMinimumSize();
        if (dimension == null) {
            return;
        }
        Dimension dimension2 = this.getSize();
        dimension2.width = Math.max(dimension.width, dimension2.width);
        dimension2.height = Math.max(dimension.height, dimension2.height);
        this.reshape(this.getX(), this.getY(), dimension2.width + 1, dimension2.height);
        this.setSize(dimension2.width, dimension2.height);
        this.tableStructureChanged = false;
    }

    protected void paintComponent(Graphics graphics) {
        if (this.tableStructureChanged) {
            this.checkMinimumSizeConstraint();
        }
        super.paintComponent(graphics);
    }

    private void createAddModelNodeMenu() throws ExceptionHugin {
        if (this.addModelNode == null) {
            return;
        }
        NodeList nodeList = this.node.getAPINode().getParents();
        Model model = null;
        if (this.table.canShowExpressions()) {
            model = this.node.getAPINode().getModel();
        }
        if (model == null) {
            return;
        }
        NodeList nodeList2 = model.getNodes();
        boolean bl = false;
        this.addModelNode.removeAll();
        for (COM.hugin.HAPI.Node node : nodeList) {
            if (!(node instanceof COM.hugin.HAPI.DiscreteNode) || nodeList2.contains(node)) continue;
            this.addModelNode.add(new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Add_Model_Node_Action(this, node)));
            bl = true;
        }
        if (!bl) {
            this.addModelNode.add(new JMenuItem(HuginGUIConstants.get("str_no_valid_parents")));
        }
    }

    private void createRemoveModelNodeMenu() throws ExceptionHugin {
        if (this.removeModelNode == null) {
            return;
        }
        Model model = null;
        if (this.table.canShowExpressions()) {
            model = this.node.getAPINode().getModel();
        }
        if (model == null) {
            return;
        }
        NodeList nodeList = model.getNodes();
        boolean bl = false;
        this.removeModelNode.removeAll();
        for (COM.hugin.HAPI.Node node : nodeList) {
            this.removeModelNode.add(new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Remove_Model_Node_Action(this, node)));
            bl = true;
        }
        if (!bl) {
            this.removeModelNode.add(new JMenuItem(HuginGUIConstants.get("str_no_model_nodes_available")));
        }
    }

    protected void expandAllColumns() throws ExceptionHugin {
        this.expandAllCPTColumns();
        this.expandAllExpressionColumns();
    }

    protected void expandAllCPTColumns() throws ExceptionHugin {
        this.table.getCPT().expandAllColumns();
    }

    protected void expandAllExpressionColumns() throws ExceptionHugin {
        if (this.table.getExpressionTable() != null) {
            this.table.getExpressionTable().expandAllColumns();
        }
    }

    public void addTableUpdateListener(TableUpdateListener tableUpdateListener) {
        if (!this.updateListeners.contains(tableUpdateListener)) {
            this.updateListeners.add(tableUpdateListener);
        }
    }

    public void removeTableUpdateListener(TableUpdateListener tableUpdateListener) {
        this.updateListeners.remove(tableUpdateListener);
    }

    protected void fireTableUpdated() {
        for (TableUpdateListener tableUpdateListener : this.updateListeners) {
            tableUpdateListener.tableUpdated(this);
        }
    }

    private String getConsDesc(String string, boolean bl) {
        int n;
        String string2 = string.substring(0, string.lastIndexOf(DESC_SEP_CHAR));
        boolean bl2 = false;
        int n2 = bl ? 0 : (n = bl2 ? string2.lastIndexOf(DESC_SEP_CHAR) + 1 : string2.indexOf(DESC_SEP_CHAR) + 1);
        int n3 = bl ? string2.indexOf(DESC_SEP_CHAR) : (bl2 ? string2.length() : string2.lastIndexOf(DESC_SEP_CHAR));
        return string2.substring(n, n3);
    }

    private class MouseHandler
    extends MouseAdapter {
        private HuginGUIFrame.StatusBar status;

        public MouseHandler(HuginGUIFrame.StatusBar statusBar) {
            this.status = statusBar;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            AbstractButton abstractButton;
            Action action;
            if (mouseEvent.getSource() instanceof AbstractButton && (action = (abstractButton = (AbstractButton)mouseEvent.getSource()).getAction()) != null) {
                String string = (String)action.getValue("LongDescription");
                String string2 = NodeTableFrame.this.getConsDesc(string, action.isEnabled());
                this.status.write(string2);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof AbstractButton && ((AbstractButton)mouseEvent.getSource()).getAction() != null) {
                this.status.clear();
            }
        }
    }

    private class ViewMenuListener
    implements MenuListener {
        ImageIcon off = new ImageIcon(ClassLoader.getSystemResource("icons/empty.gif"));
        ImageIcon on = new ImageIcon(ClassLoader.getSystemResource("icons/ok.gif"));

        private ViewMenuListener() {
        }

        public void menuSelected(MenuEvent menuEvent) {
            boolean bl = true;
            if (NodeTableFrame.this.node.getAPINode() instanceof COM.hugin.HAPI.DiscreteChanceNode) {
                bl = ((DiscreteChanceNodeTableModel)NodeTableFrame.this.node.getTable().getTable().getTable().getModel()).getInvalidTable();
            }
            if (NodeTableFrame.this.node.getAPINode() instanceof DiscreteDecisionNode) {
                bl = ((DiscreteDecisionNodeTableModel)NodeTableFrame.this.node.getTable().getTable().getTable().getModel()).getInvalidTable();
            }
            NodeTableFrame.this.displayMode.setEnabled(NodeTableFrame.this.node instanceof DiscreteNode && !bl);
            NodeTableFrame.this.view_normal_mode.setEnabled(NodeTableFrame.this.table.getDisplayMode() != 0);
            NodeTableFrame.this.view_bar_mode.setEnabled(NodeTableFrame.this.table.getDisplayMode() != 1);
            NodeTableFrame.this.view_pure_bar_mode.setEnabled(NodeTableFrame.this.table.getDisplayMode() != 3);
            ((NodeTableFrameEvents.VIEW_Toggle_Experience_Action)NodeTableFrame.this.view_toggle_experience.getAction()).setMode(NodeTableFrame.this.table.showExperience());
            ((NodeTableFrameEvents.VIEW_Toggle_Fading_Action)NodeTableFrame.this.view_toggle_fading.getAction()).setMode(NodeTableFrame.this.table.showFading());
            ImageIcon imageIcon = NodeTableFrame.this.getTable().autoNormalize() ? this.on : this.off;
            NodeTableFrame.this.auto_normalize.getAction().putValue("SmallIcon", imageIcon);
            NodeTableFrame.this.auto_normalize.setEnabled(NodeTableFrame.this.table.getDisplayMode() != 0);
            try {
                NodeTableFrame.this.view_toggle_experience.setEnabled(NodeTableFrame.this.table.hasExperience());
                NodeTableFrame.this.view_toggle_fading.setEnabled(NodeTableFrame.this.table.hasFading());
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            NodeTableFrame.this.view_toggle_state_labels.setEnabled(NodeTableFrame.this.table.getNode() instanceof NumberedDCNode || NodeTableFrame.this.table.getNode() instanceof IntervalDCNode || NodeTableFrame.this.table.getNode() instanceof BooleanDCNode || NodeTableFrame.this.table.getNode() instanceof NumberedDDNode || NodeTableFrame.this.table.getNode() instanceof IntervalDDNode || NodeTableFrame.this.table.getNode() instanceof BooleanDDNode);
            ((NodeTableFrameEvents.VIEW_Toggle_State_Value_Labels_Action)NodeTableFrame.this.view_toggle_state_labels.getAction()).setMode(NodeTableFrame.this.getTable().getStateDisplayMode());
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }
    }

    private class FunctionMenuListener
    implements MenuListener {
        private FunctionMenuListener() {
        }

        public void menuSelected(MenuEvent menuEvent) {
            try {
                NodeTableFrame.this.fadingExperienceItems.setEnabled(NodeTableFrame.this.node instanceof DiscreteChanceNode || NodeTableFrame.this.node instanceof ContinuousChanceNode);
                NodeTableFrame.this.function_create_experience.setEnabled(!NodeTableFrame.this.table.hasExperience());
                NodeTableFrame.this.function_create_fading.setEnabled(!(NodeTableFrame.this.node instanceof ContinuousChanceNode) && !NodeTableFrame.this.table.hasFading());
                NodeTableFrame.this.function_delete_experience.setEnabled(NodeTableFrame.this.table.hasExperience());
                NodeTableFrame.this.function_delete_fading.setEnabled(!(NodeTableFrame.this.node instanceof ContinuousChanceNode) && NodeTableFrame.this.table.hasFading());
                NodeTableFrame.this.convertNode.setEnabled(NodeTableFrame.this.node.isDiscrete() && NodeTableFrame.this.node.canChangeType());
                if (NodeTableFrame.this.node.isDiscrete()) {
                    int n = ((DiscreteNode)((Object)NodeTableFrame.this.node)).getSubtype();
                    NodeTableFrame.this.toLabelled.setEnabled(n != 0);
                    NodeTableFrame.this.toBoolean.setEnabled(n != 1);
                    NodeTableFrame.this.toNumbered.setEnabled(n != 2);
                    NodeTableFrame.this.toInterval.setEnabled(n != 3);
                }
                NodeTableFrame.this.createAddModelNodeMenu();
                NodeTableFrame.this.createRemoveModelNodeMenu();
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }
    }

    private class EditMenuListener
    implements MenuListener {
        private EditMenuListener() {
        }

        public void menuSelected(MenuEvent menuEvent) {
            if (NodeTableFrame.this.table.getNode() instanceof FunctionNode) {
                NodeTableFrame.this.edit_copy.setEnabled(NodeTableFrame.this.table.canCopy());
                NodeTableFrame.this.edit_paste.setEnabled(NodeTableFrame.this.table.canPaste());
                NodeTableFrame.this.reset.setEnabled(false);
                NodeTableFrame.this.resetCPT.setEnabled(false);
                NodeTableFrame.this.resetExperience.setEnabled(false);
                NodeTableFrame.this.resetFading.setEnabled(false);
                NodeTableFrame.this.normalize.setEnabled(false);
                NodeTableFrame.this.randomize.setEnabled(false);
                return;
            }
            boolean bl = NodeTableFrame.this.table.getNode() instanceof COM.hugin.HAPI.ContinuousChanceNode || NodeTableFrame.this.table.getNode() instanceof UtilityNode;
            boolean bl2 = NodeTableFrame.this.table.getNode() instanceof UtilityNode;
            NodeTableFrame.this.edit_copy.setEnabled(NodeTableFrame.this.table.canCopy());
            NodeTableFrame.this.edit_paste.setEnabled(NodeTableFrame.this.table.canPaste());
            NodeTableFrame.this.reset.setEnabled(!bl2);
            NodeTableFrame.this.resetCPT.setEnabled(!NodeTableFrame.this.table.showExpressions());
            NodeTableFrame.this.resetExperience.setEnabled(NodeTableFrame.this.table.showExperience());
            NodeTableFrame.this.resetFading.setEnabled(NodeTableFrame.this.table.showFading());
            NodeTableFrame.this.normalize.setEnabled(!NodeTableFrame.this.table.showExpressions() && !bl);
            NodeTableFrame.this.randomize.setEnabled(!NodeTableFrame.this.table.showExpressions() && !bl);
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }
    }

    static class TableUpdateListener
    implements EventListener {
        TableUpdateListener() {
        }

        public void tableUpdated(NodeTableFrame nodeTableFrame) {
        }
    }

    static class TableChangeListener
    implements EventListener {
        TableChangeListener() {
        }

        public void tableChanged() {
        }
    }

    static class StateTableResizedListener
    implements EventListener {
        StateTableResizedListener() {
        }

        public void stateTableResized() {
        }
    }

    class StateTableChangeListener
    implements EventListener {
        StateTableChangeListener() {
        }

        public void stateTableChanged() {
        }
    }

    class NeedsFakeResizeListener
    implements EventListener {
        NeedsFakeResizeListener() {
        }

        public void makeFakeResize() {
            if (NodeTableFrame.this.getParent() == null) {
                JSplitPane jSplitPane = Hugin.mainFrame.getSelectedProjectFrame().editModePanel;
                int n = jSplitPane.getDividerLocation();
                jSplitPane.invalidate();
                jSplitPane.setDividerLocation(n + 10);
                jSplitPane.validate();
                jSplitPane.repaint();
                jSplitPane.setDividerLocation(n);
                jSplitPane.revalidate();
            } else {
                NodeTableFrame.this.setSize(NodeTableFrame.this.getWidth() + 1, NodeTableFrame.this.getHeight());
                NodeTableFrame.this.setSize(NodeTableFrame.this.getWidth() - 1, NodeTableFrame.this.getHeight());
            }
        }
    }
}

