/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.NumberField;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;

public class NumberFieldLong
extends NumberField {
    public NumberFieldLong() {
        super(8);
        this.addKeyListener(new EnsureNumberListener());
    }

    public NumberFieldLong(Long l) {
        super(8);
        this.setText(l.toString());
        this.addKeyListener(new EnsureNumberListener());
    }

    public long getLong() {
        try {
            return Long.parseLong(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 42L;
        }
    }

    public boolean isNumber() {
        try {
            Long.parseLong(this.getText());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private class EnsureNumberListener
    extends KeyAdapter {
        private EnsureNumberListener() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            JTextField jTextField = (JTextField)keyEvent.getSource();
            String string = jTextField.getText();
            if (keyEvent.getKeyChar() == '\b' && jTextField.getCaretPosition() > 0) {
                return;
            }
            if (keyEvent.getKeyChar() == 'E' && jTextField.getCaretPosition() == string.length()) {
                if (string.indexOf("E") >= 0) {
                    keyEvent.consume();
                }
                return;
            }
            string = string.substring(0, jTextField.getCaretPosition()) + keyEvent.getKeyChar() + string.substring(jTextField.getCaretPosition());
            try {
                if (!string.equals("+") && !string.equals("-")) {
                    Long.parseLong(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                keyEvent.consume();
            }
        }
    }
}

