/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.DatabaseDataSource;
import COM.hugin.HGUI.DatabaseException;
import COM.hugin.HGUI.DatabaseTable;
import COM.hugin.HGUI.HuginGUIConstants;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDataSource
extends DatabaseDataSource {
    private String host;
    private String port;
    private String sid;
    private String user;
    private String driverPath;
    private int lineNumber = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OracleDataSource(String string, String string2, String string3, String string4, String string5, String string6) throws DatabaseException {
        try {
            this.driverPath = string;
            this.host = string2;
            this.port = string3;
            this.sid = string4;
            this.user = string5;
            if (string.length() == 0) throw new DatabaseException("Unable to use the database.\nMake sure the database driver directory is set in preferences.\n");
            ArrayList<String> arrayList = this.loadDrivers(string);
            if (arrayList.size() <= 0) throw new DatabaseException("Unable to use the database.\nThe classes for the driver could not be found.\nMake sure that your classpath is set up to include these.");
            for (int i = 0; i < arrayList.size(); ++i) {
                Class.forName(arrayList.get(i));
            }
            this.database = DriverManager.getConnection("jdbc:oracle:thin:@(description=(address=(host=" + string2 + ")" + "(protocol=tcp)" + "(port=" + string3 + "))" + "(connect_data=" + "(sid=" + string4 + ")))", string5, string6);
            this.statement = null;
            return;
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new DatabaseException(HuginGUIConstants.get("str_unable_to_use_oracle_lb_classes_for_oracledriver_not_found_etc"));
        }
    }

    @Override
    protected String getUser() {
        return this.user;
    }

    @Override
    protected Vector<DatabaseTable> getTables() throws SQLException {
        Vector<DatabaseTable> vector = new Vector<DatabaseTable>();
        DatabaseMetaData databaseMetaData = this.database.getMetaData();
        String[] stringArray = new String[]{"TABLE"};
        ResultSet resultSet = databaseMetaData.getTables(null, null, null, stringArray);
        while (resultSet.next()) {
            String string = resultSet.getString(2);
            if (string.toUpperCase().equals("SYSTEM") || string.toUpperCase().equals("SYS")) continue;
            if (!string.toUpperCase().equals(this.user.toUpperCase())) {
                vector.add(new DatabaseTable(resultSet.getString(2) + "." + resultSet.getString(3)));
                continue;
            }
            vector.add(new DatabaseTable(resultSet.getString(3)));
        }
        resultSet.close();
        this.fillInVariables(vector);
        return vector;
    }
}

