/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteDecisionNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionInconsistencyOrUnderflow;
import COM.hugin.HAPI.ExceptionParse;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HAPI.IntervalDDNode;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.ParseListener;
import COM.hugin.HAPI.UtilityNode;
import COM.hugin.HGUI.BeliefBarPanel;
import COM.hugin.HGUI.CaseBank;
import COM.hugin.HGUI.ConstraintsPanel;
import COM.hugin.HGUI.HelpPanel;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginFileLoader;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.LearningWizard;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.PsPanel;
import COM.hugin.HGUI.StreamData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.ProgressMonitor;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterSensitivityWizard
extends JDialog {
    private final boolean useChooser = false;
    public static final int CONSTRAINT_MODE = 0;
    public static final int PARAMETER_MODE = 1;
    public static final int TWO_WAY_MODE = 2;
    public static final int INFLUENCE_MODE = 3;
    private HuginGUIFrame guiFrame;
    protected HuginProjectFrame projectFrame;
    private Domain domain;
    private ParameterSensitivityWizard psw;
    private JPanel influencePanel;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JPanel mainPanel;
    private JTabbedPane tabbedPane;
    private HelpPanel helpPanel;
    private JLabel fileLabel;
    private JLabel numberOfCasesLabel;
    private JButton closeButton;
    private JButton helpButton;
    private JButton caseFileButton;
    private JButton clearButton;
    private JButton dataSourceButton;
    private JScrollPane viewCasePanel;
    private Vector<DiscreteChanceNode> dcNodes;
    private Vector<DiscreteDecisionNode> ddNodes;
    private int mode;
    private boolean sensitivityDataComputed = false;
    private boolean constraintSensitivityComputed = false;
    PsPanel pspPanel;
    ConstraintsPanel constraintsPanel;
    private CaseBank caseBank;
    private COM.hugin.HAPI.Node computedNode;
    private ChangeListener valueChangeListener;
    private Vector<ChangeListener> caseListeners = new Vector();
    private int tabbedHeight;
    PsPanel twoWayPspPanel;
    private int[] selectedRows = new int[0];

    public ParameterSensitivityWizard(HuginProjectFrame huginProjectFrame, HuginGUIFrame huginGUIFrame) {
        super(Hugin.mainFrame, HuginGUIConstants.get("PSW_Title"), true);
        this.psw = this;
        this.projectFrame = huginProjectFrame;
        this.guiFrame = huginGUIFrame;
        this.domain = this.projectFrame.getBeliefBarPanel().getDomain();
        if (!this.checkDomain(this.projectFrame)) {
            return;
        }
        this.storeExistingCases(this.domain);
        try {
            this.dcNodes = this.getAllDiscreteChanceNodes(this.domain.getNodes());
            this.ddNodes = this.getAllDiscreteDecisionNodes(this.domain.getNodes());
        }
        catch (ExceptionHugin exceptionHugin) {
            // empty catch block
        }
        this.tabbedPane = new JTabbedPane();
        this.helpPanel = new HelpPanel(this);
        this.createConstraintsPanel();
        this.createPsPanel();
        this.createTwoWayPsPanel();
        this.createInfluencePanel();
        this.tabbedPane.addTab(HuginGUIConstants.get("PSW_Tab_Psp"), this.pspPanel);
        this.tabbedPane.addTab(HuginGUIConstants.get("PSW_Tab_Two_Way"), this.twoWayPspPanel);
        this.tabbedPane.addTab(HuginGUIConstants.get("PSW_Tab_Constraints"), this.constraintsPanel);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                int n = ParameterSensitivityWizard.this.tabbedPane.getSelectedIndex();
                ParameterSensitivityWizard.this.pspPanel.closeNetworkPanel();
                if (n != ParameterSensitivityWizard.this.tabbedPane.indexOfTab(HuginGUIConstants.get("PSW_Tab_Psp")) && n != ParameterSensitivityWizard.this.tabbedPane.indexOfTab(HuginGUIConstants.get("PSW_Tab_Two_Way"))) {
                    ParameterSensitivityWizard.this.pspPanel.clear();
                    ParameterSensitivityWizard.this.twoWayPspPanel.clear();
                }
            }
        });
        this.createButtonPanel();
        this.createBottomPanel();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.mainPanel.add(this.tabbedPane);
        this.mainPanel.add(this.bottomPanel);
        this.setLayout(new GridLayout(1, 1));
        this.getContentPane().add(this.mainPanel);
        this.pack();
        this.tabbedHeight = this.tabbedPane.getHeight();
        this.tabbedPane.setMinimumSize(new Dimension(620, this.tabbedHeight));
        HuginGUIUtils.centerComponent(Hugin.mainFrame, (Window)this);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new CloseListener(this.domain, this.projectFrame.getNetworkPanel()));
        this.addComponentListener(new ResizedListener(this));
        this.propagate();
        Dimension dimension = new Dimension(620, this.getHeight());
        this.setSize(dimension);
        this.setVisible(true);
    }

    protected Domain getDomain() {
        return this.domain;
    }

    protected HuginProjectFrame getProjectFrame() {
        return this.projectFrame;
    }

    private void createConstraintsPanel() {
        this.constraintsPanel = new ConstraintsPanel(this.domain, this);
    }

    private void createPsPanel() {
        this.pspPanel = new PsPanel(this, 1);
    }

    private void createTwoWayPsPanel() {
        this.twoWayPspPanel = new PsPanel(this, 2);
    }

    private void createInfluencePanel() {
        this.influencePanel = new JPanel();
    }

    private void createButtonPanel() {
        this.buttonPanel = new JPanel();
    }

    private void createBottomPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.bottomPanel = new JPanel(new BorderLayout());
        this.bottomPanel.setBorder(BorderFactory.createEtchedBorder());
        this.viewCasePanel = new JScrollPane();
        this.viewCasePanel.setPreferredSize(new Dimension(500, 150));
        this.viewCasePanel.getViewport().setBackground(Color.white);
        this.fileLabel = new JLabel(HuginGUIConstants.get("AW_Data_file") + ": " + "---");
        this.numberOfCasesLabel = new JLabel(HuginGUIConstants.get("AW_Data_number_of_cases") + "0", 4);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.add(this.fileLabel);
        jPanel2.add(this.numberOfCasesLabel);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.viewCasePanel, "Center");
        this.bottomPanel.add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.helpButton = new JButton(HuginGUIConstants.get("help_button"));
        this.helpButton.setAlignmentX(2.0f);
        String[] stringArray = new String[]{HuginGUIConstants.get("SA_Sensitivity_help_page"), HuginGUIConstants.get("SA_Two_Way_Sensitivity_help_page"), HuginGUIConstants.get("SA_Constraints_help_page")};
        this.helpButton.addActionListener(new HelpListener(stringArray));
        this.closeButton = new JButton(HuginGUIConstants.get("CLOSE_BUTTON_LABEL"));
        this.closeButton.setAlignmentX(4.0f);
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParameterSensitivityWizard.this.cleanUp();
                ParameterSensitivityWizard.this.psw.dispose();
            }
        });
        this.clearButton = new JButton(HuginGUIConstants.get("SA_Clear"));
        this.clearButton.setToolTipText(HuginGUIConstants.get("SA_ToolTip_Clear"));
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParameterSensitivityWizard.this.clear();
            }
        });
        this.dataSourceButton = new JButton(HuginGUIConstants.get("AW_Data_database"));
        this.dataSourceButton.setToolTipText(HuginGUIConstants.get("AW_ToolTip_Select_File"));
        this.dataSourceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearningWizard learningWizard = new LearningWizard(ParameterSensitivityWizard.this.psw, ((ParameterSensitivityWizard)ParameterSensitivityWizard.this).guiFrame.preferences, ParameterSensitivityWizard.this.domain, new DomainCasesListener());
                learningWizard.setLocation(100, 100);
                learningWizard.setVisible(true);
            }
        });
        jPanel3.add((Component)this.helpButton, "West");
        JPanel jPanel4 = new JPanel(new GridLayout(1, 3));
        jPanel4.add(this.dataSourceButton);
        jPanel4.add(this.clearButton);
        jPanel4.add(this.closeButton);
        jPanel3.add((Component)jPanel4, "East");
        this.bottomPanel.add((Component)jPanel3, "South");
    }

    protected void enableClearButton(boolean bl) {
        this.clearButton.setEnabled(bl);
    }

    private Vector<DiscreteChanceNode> getAllDiscreteChanceNodes(NodeList nodeList) {
        Vector<DiscreteChanceNode> vector = new Vector<DiscreteChanceNode>();
        for (COM.hugin.HAPI.Node node : nodeList) {
            if (!(node instanceof DiscreteChanceNode)) continue;
            vector.add((DiscreteChanceNode)node);
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    private Vector<DiscreteDecisionNode> getAllDiscreteDecisionNodes(NodeList nodeList) throws ExceptionHugin {
        Vector<DiscreteDecisionNode> vector = new Vector<DiscreteDecisionNode>();
        for (COM.hugin.HAPI.Node node : nodeList) {
            if (!(node instanceof DiscreteDecisionNode)) continue;
            vector.add((DiscreteDecisionNode)node);
        }
        return vector;
    }

    public Vector<DiscreteChanceNode> getDCNodeList() {
        return this.dcNodes;
    }

    public Vector<DiscreteDecisionNode> getDDNodesNotInstantiated() throws ExceptionHugin {
        Vector<DiscreteDecisionNode> vector = new Vector<DiscreteDecisionNode>();
        for (DiscreteDecisionNode discreteDecisionNode : this.ddNodes) {
            if (discreteDecisionNode.evidenceIsEntered()) continue;
            vector.add(discreteDecisionNode);
        }
        return vector;
    }

    protected Vector<String> getNodeStatesDescription(DiscreteChanceNode discreteChanceNode) {
        Vector<String> vector = new Vector<String>();
        try {
            int n = discreteChanceNode.getNumberOfStates();
            for (int i = 0; i < n; ++i) {
                vector.add(HuginGUIUtils.getNodeStateLabel(discreteChanceNode, i));
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            // empty catch block
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    protected void setMode(int n) {
        this.mode = n;
    }

    protected int getMode() {
        return this.mode;
    }

    private boolean checkDomain(HuginProjectFrame huginProjectFrame) {
        boolean bl = false;
        try {
            if (!huginProjectFrame.runMode || this.domain == null || !this.domain.isCompiled()) {
                JOptionPane.showMessageDialog(this, HuginGUIConstants.get("AW_Dialog_domain_error"));
                return false;
            }
            bl = true;
            if (this.domain.isCompressed()) {
                JOptionPane.showMessageDialog(this, HuginGUIConstants.get("AW_Dialog_domain_compressed_error"));
                return false;
            }
            bl = true;
            boolean bl2 = false;
            for (COM.hugin.HAPI.Node node : this.domain.getNodes()) {
                if (!(node instanceof DiscreteChanceNode)) continue;
                bl2 = true;
            }
            if (!bl2) {
                JOptionPane.showMessageDialog(this, HuginGUIConstants.get("AW_Dialog_domain_no_dcc_nodes"));
                return false;
            }
            bl = true;
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        return bl;
    }

    protected double computeSensitivityValue(double[] dArray, double d) {
        if (dArray != null && dArray.length == 4) {
            double d2 = (dArray[0] * dArray[3] - dArray[1] * dArray[2]) / ((dArray[2] * d + dArray[3]) * (dArray[2] * d + dArray[3]));
            if (new Double(d2).equals(Double.NaN)) {
                d2 = 0.0;
            }
            return d2;
        }
        return Double.MAX_VALUE;
    }

    protected double computeInput1SensitivityValue(double[] dArray, double d, double d2) {
        double d3 = dArray[0];
        double d4 = dArray[1];
        double d5 = dArray[2];
        double d6 = dArray[3];
        double d7 = dArray[4];
        double d8 = dArray[5];
        return ((d3 * d7 - d4 * d6) * d2 + d3 * d8 - d6 * d5) / Math.pow(d6 * d + d7 * d2 + d8, 2.0);
    }

    protected double computeInput2SensitivityValue(double[] dArray, double d, double d2) {
        double d3 = dArray[0];
        double d4 = dArray[1];
        double d5 = dArray[2];
        double d6 = dArray[3];
        double d7 = dArray[4];
        double d8 = dArray[5];
        return ((d4 * d6 - d3 * d7) * d + d4 * d8 - d7 * d5) / Math.pow(d6 * d + d7 * d2 + d8, 2.0);
    }

    protected double computeSensitivityFunction(double[] dArray, double d, double d2) {
        double d3 = d < 0.0 ? 0.0 : (d = d > 1.0 ? 1.0 : d);
        double d4 = d2 < 0.0 ? 0.0 : (d2 = d2 > 1.0 ? 1.0 : d2);
        if (dArray != null && dArray.length == 6) {
            double d5;
            double d6 = dArray[0];
            double d7 = dArray[1];
            double d8 = dArray[2];
            double d9 = dArray[3];
            double d10 = dArray[4];
            double d11 = dArray[5];
            double d12 = (d6 * d + d7 * d2 + d8) / (d9 * d + d10 * d2 + d11);
            double d13 = d12 < 0.0 ? 0.0 : (d5 = d12 > 1.0 ? 1.0 : d12);
            if (new Double(d5).equals(Double.NaN)) {
                d5 = 0.0;
            }
            return d5;
        }
        return Double.MAX_VALUE;
    }

    protected double computeSensitivityFunction(double[] dArray, double[] dArray2, double d, double d2) {
        double d3 = d < 0.0 ? 0.0 : (d = d > 1.0 ? 1.0 : d);
        double d4 = d2 < 0.0 ? 0.0 : (d2 = d2 > 1.0 ? 1.0 : d2);
        if (dArray != null && dArray.length == 4 && dArray2 != null && dArray2.length == 4) {
            double d5;
            double d6 = dArray[0];
            double d7 = dArray[1];
            double d8 = dArray[2];
            double d9 = dArray[3];
            double d10 = dArray2[0];
            double d11 = dArray2[1];
            double d12 = dArray2[2];
            double d13 = dArray2[3];
            double d14 = (d6 * d * d2 + d7 * d + d8 * d2 + d9) / (d10 * d * d2 + d11 * d + d12 * d2 + d13);
            double d15 = d14 < 0.0 ? 0.0 : (d5 = d14 > 1.0 ? 1.0 : d14);
            if (new Double(d5).equals(Double.NaN)) {
                d5 = 0.0;
            }
            return d5;
        }
        return Double.MAX_VALUE;
    }

    public boolean computeSensitivityData(DiscreteChanceNode discreteChanceNode) {
        return this.computeSensitivityData(discreteChanceNode, true);
    }

    public boolean computeSensitivityData(DiscreteChanceNode discreteChanceNode, boolean bl) {
        block11: {
            this.sensitivityComputed(false, discreteChanceNode);
            this.constraintSensitivityComputed = false;
            if (discreteChanceNode != null) {
                try {
                    if (!this.checkDomain(this.projectFrame)) {
                        return false;
                    }
                    if (this.domain.evidenceToPropagate()) {
                        this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                        if (bl) {
                            this.propagationUpdate();
                        }
                    }
                    if (!discreteChanceNode.evidenceIsEntered()) {
                        NodeList nodeList = new NodeList();
                        Vector<Integer> vector = new Vector<Integer>();
                        for (int i = 0; i < discreteChanceNode.getNumberOfStates(); ++i) {
                            nodeList.add(discreteChanceNode);
                            vector.add(i);
                        }
                        Object[] objectArray = vector.toArray();
                        int[] nArray = new int[nodeList.size()];
                        for (int i = 0; i < nArray.length; ++i) {
                            nArray[i] = (Integer)objectArray[i];
                        }
                        this.domain.computeSensitivityData(nodeList, nArray);
                        this.sensitivityComputed(true, discreteChanceNode);
                    } else {
                        this.sensitivityComputed(false, discreteChanceNode);
                        if (bl) {
                            new HuginGUIError(HuginGUIConstants.get("SA_Cant_Compute_Evidence_Entered", new String[]{HuginGUIUtils.getNodeTitle(discreteChanceNode)}));
                        }
                    }
                }
                catch (ExceptionHugin exceptionHugin) {
                    this.sensitivityComputed(false, discreteChanceNode);
                    if (!bl) break block11;
                    this.projectFrame.repaint();
                    new HuginGUIError(exceptionHugin.getMessage());
                }
            }
        }
        return this.sensitivityDataComputed;
    }

    public void computeSensitivityForSelectedCases(DiscreteChanceNode discreteChanceNode, int n, PsPanel psPanel) {
        psPanel.clearGraph(false);
        int n2 = 0;
        ProgressMonitor progressMonitor = new ProgressMonitor(this.psw, HuginGUIConstants.get("SA_Computing_Across_Cases"), "", 0, this.selectedRows.length);
        progressMonitor.setMillisToDecideToPopup(0);
        boolean bl = false;
        for (int i = 0; i < this.selectedRows.length && !bl; ++i) {
            progressMonitor.setProgress(i);
            progressMonitor.setNote(HuginGUIConstants.get("SA_Case") + " : " + i);
            try {
                this.domain.enterCase(this.selectedRows[i]);
                boolean bl2 = this.computeSensitivityData(discreteChanceNode, false);
                if (bl2) {
                    Color color = psPanel.getColor(n2);
                    ++n2;
                    psPanel.addLineToGraph(n, "" + this.selectedRows[i], color);
                }
                if (!progressMonitor.isCanceled()) continue;
                this.psw.toFront();
                progressMonitor.close();
                bl = true;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.psw.toFront();
        progressMonitor.close();
        psPanel.createTableView();
        try {
            this.sensitivityComputed(false, discreteChanceNode);
            this.retractFindings();
            this.enterInitialCase();
            this.propagate();
            this.guiFrame.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Vector<PsPanel.LineData3D> computeTwoWayTwoCPTSensitivityForSelectedCases(DiscreteChanceNode discreteChanceNode, PsPanel.TableCell tableCell, PsPanel.TableCell tableCell2, PsPanel psPanel) {
        psPanel.clearGraph(false);
        Vector<PsPanel.LineData3D> vector = new Vector<PsPanel.LineData3D>();
        boolean bl = false;
        ProgressMonitor progressMonitor = new ProgressMonitor(this.psw, HuginGUIConstants.get("SA_Computing_Across_Cases"), "", 0, this.selectedRows.length);
        progressMonitor.setMillisToDecideToPopup(0);
        for (int i = 0; i < this.selectedRows.length && !bl; ++i) {
            progressMonitor.setProgress(i);
            progressMonitor.setNote(HuginGUIConstants.get("SA_Case") + " : " + i);
            try {
                this.domain.enterCase(this.selectedRows[i]);
                if (discreteChanceNode.evidenceIsEntered()) continue;
                double[] dArray = psPanel.getSensitivityConstants(tableCell, tableCell2, psPanel.getSelectedState());
                double[] dArray2 = psPanel.getSensitivityConstants(tableCell, tableCell2);
                this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                double d = this.computeSensitivityFunction(dArray, dArray2, tableCell.getValue(), tableCell2.getValue());
                double[][] dArray3 = psPanel.create3DPlotData(dArray, dArray2);
                vector.add(psPanel.createLineData(dArray, dArray2, psPanel.getSelectedStateName(), d, tableCell.getValue(), tableCell2.getValue(), dArray3, this.selectedRows[i]));
                if (!progressMonitor.isCanceled()) continue;
                this.psw.toFront();
                progressMonitor.close();
                bl = true;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.psw.toFront();
        progressMonitor.close();
        try {
            this.sensitivityComputed(false, discreteChanceNode);
            this.retractFindings();
            this.enterInitialCase();
            this.propagate();
            this.guiFrame.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }

    public Vector<PsPanel.LineData3D> computeTwoWaySensitivityForSelectedCases(DiscreteChanceNode discreteChanceNode, PsPanel.TableCell tableCell, PsPanel.TableCell tableCell2, PsPanel psPanel) {
        psPanel.clearGraph(false);
        Vector<PsPanel.LineData3D> vector = new Vector<PsPanel.LineData3D>();
        boolean bl = false;
        ProgressMonitor progressMonitor = new ProgressMonitor(this.psw, HuginGUIConstants.get("SA_Computing_Across_Cases"), "", 0, this.selectedRows.length);
        progressMonitor.setMillisToDecideToPopup(0);
        for (int i = 0; i < this.selectedRows.length && !bl; ++i) {
            progressMonitor.setProgress(i);
            progressMonitor.setNote(HuginGUIConstants.get("SA_Case") + " : " + i);
            try {
                this.domain.enterCase(this.selectedRows[i]);
                boolean bl2 = this.computeSensitivityData(discreteChanceNode, false);
                if (bl2) {
                    vector = psPanel.addLineTo3DGraph(vector, tableCell, tableCell2, this.selectedRows[i]);
                }
                if (!progressMonitor.isCanceled()) continue;
                this.psw.toFront();
                progressMonitor.close();
                bl = true;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.psw.toFront();
        progressMonitor.close();
        try {
            this.sensitivityComputed(false, discreteChanceNode);
            this.retractFindings();
            this.enterInitialCase();
            this.propagate();
            this.guiFrame.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }

    public boolean computeSensitivityData(NodeList nodeList, int[] nArray) {
        this.constraintSensitivityComputed = false;
        this.clearMinMaxSensitivityValues(false);
        this.sensitivityComputed(false, null);
        try {
            NodeList nodeList2;
            if (!this.checkDomain(this.projectFrame)) {
                return false;
            }
            if (this.domain.evidenceToPropagate()) {
                this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                this.propagationUpdate();
            }
            if ((nodeList2 = this.getNodesWithEvidence(nodeList)) == null) {
                if (nodeList.size() > 0 && nArray.length == nodeList.size()) {
                    this.domain.computeSensitivityData(nodeList, nArray);
                    this.constraintSensitivityComputed = true;
                }
            } else {
                this.constraintSensitivityComputed = false;
                this.projectFrame.repaint();
                String[] stringArray = new String[nodeList2.size()];
                int n = -1;
                for (COM.hugin.HAPI.Node node : nodeList2) {
                    stringArray[++n] = HuginGUIUtils.getNodeTitle(node);
                }
                new HuginGUIError(HuginGUIConstants.get("SA_Cant_Compute_Evidence_Entered", stringArray));
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            this.constraintSensitivityComputed = false;
            this.projectFrame.repaint();
            new HuginGUIError(exceptionHugin.getMessage());
        }
        return this.constraintSensitivityComputed;
    }

    protected NodeList getNodesWithEvidence(NodeList nodeList) throws ExceptionHugin {
        NodeList nodeList2 = new NodeList();
        for (COM.hugin.HAPI.Node node : nodeList) {
            if (!node.evidenceIsEntered()) continue;
            nodeList2.add(node);
        }
        if (nodeList2.size() == 0) {
            nodeList2 = null;
        }
        return nodeList2;
    }

    protected void computeMinMaxSensitivtyValues(DiscreteChanceNode discreteChanceNode, int n) throws ExceptionHugin {
        if (!this.isSensitivityComputedFor(discreteChanceNode)) {
            this.clearMinMaxSensitivityValues(true);
            return;
        }
        this.clearMinMaxSensitivityValues(false);
        for (DiscreteChanceNode discreteChanceNode2 : this.dcNodes) {
            int n2;
            if (discreteChanceNode2 == null) continue;
            double d = -1.7976931348623157E308;
            double d2 = Double.MAX_VALUE;
            double d3 = 0.0;
            int n3 = n2 = discreteChanceNode2.getTable().getSize();
            for (int i = 0; i < n2; ++i) {
                try {
                    double[] dArray = discreteChanceNode2.getSensitivityConstants(i, n);
                    double d4 = discreteChanceNode2.getTable().getDataItem(i);
                    double d5 = this.computeSensitivityValue(dArray, d4);
                    if (d5 != Double.MAX_VALUE) {
                        if (d5 > d) {
                            d = d5;
                        }
                        if (d5 < d2) {
                            d2 = d5;
                        }
                    }
                    d3 += Math.abs(d5);
                    continue;
                }
                catch (ExceptionHugin exceptionHugin) {
                    --n3;
                }
            }
            try {
                Node node = this.projectFrame.getNetworkPanel().getNode(discreteChanceNode2.getName());
                node.setMaxSensitivityValue(d);
                node.setMinSensitivityValue(d2);
                node.setAvgSensitivityValue(d3 / (double)n2);
            }
            catch (ExceptionHugin exceptionHugin) {}
        }
        this.fireMinMaxValuesChanged();
    }

    protected void computeMinMaxForAllStatesAndAllVariables(DiscreteChanceNode discreteChanceNode) throws ExceptionHugin {
        if (!this.isSensitivityComputedFor(discreteChanceNode)) {
            this.clearMinMaxSensitivityValues(true);
            return;
        }
        if (discreteChanceNode == null) {
            this.clearMinMaxSensitivityValues(true);
            return;
        }
        this.clearMinMaxSensitivityValues(false);
        int n = discreteChanceNode.getNumberOfStates();
        for (int i = 0; i < n; ++i) {
            for (DiscreteChanceNode discreteChanceNode2 : this.dcNodes) {
                int n2;
                double d = -1.7976931348623157E308;
                double d2 = Double.MAX_VALUE;
                double d3 = 0.0;
                int n3 = n2 = discreteChanceNode2.getTable().getSize();
                for (int j = 0; j < n2; ++j) {
                    try {
                        double[] dArray = discreteChanceNode2.getSensitivityConstants(j, i);
                        double d4 = discreteChanceNode2.getTable().getDataItem(j);
                        double d5 = this.computeSensitivityValue(dArray, d4);
                        if (d5 != Double.MAX_VALUE) {
                            if (d5 > d) {
                                d = d5;
                            }
                            if (d5 < d2) {
                                d2 = d5;
                            }
                        }
                        d3 += Math.abs(d5);
                        continue;
                    }
                    catch (ExceptionHugin exceptionHugin) {
                        --n3;
                    }
                }
                try {
                    Node node = this.projectFrame.getNetworkPanel().getNode(discreteChanceNode2.getName());
                    double d6 = node.getMaxSensitivityValue();
                    double d7 = node.getMinSensitivityValue();
                    double d8 = node.getAvgSensitivityValue();
                    if (d > d6) {
                        node.setMaxSensitivityValue(d);
                    }
                    if (d2 < d7) {
                        node.setMinSensitivityValue(d2);
                    }
                    if (d8 != -1.7976931348623157E308) {
                        node.setAvgSensitivityValue((d8 + d3) / (double)(n2 + 1));
                        continue;
                    }
                    node.setAvgSensitivityValue(d3 / (double)n2);
                }
                catch (ExceptionHugin exceptionHugin) {}
            }
        }
        this.fireMinMaxValuesChanged();
    }

    protected void clearMinMaxSensitivityValues() {
        this.clearMinMaxSensitivityValues(true);
    }

    private void clearMinMaxSensitivityValues(boolean bl) {
        try {
            for (DiscreteChanceNode discreteChanceNode : this.dcNodes) {
                if (discreteChanceNode == null) continue;
                Node node = this.projectFrame.getNetworkPanel().getNode(discreteChanceNode.getName());
                node.setMaxSensitivityValue(-1.7976931348623157E308);
                node.setMinSensitivityValue(Double.MAX_VALUE);
                node.setAvgSensitivityValue(-1.7976931348623157E308);
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            // empty catch block
        }
        if (bl) {
            this.fireMinMaxValuesChanged();
        }
    }

    private String getNodeName(COM.hugin.HAPI.Node node) {
        try {
            String string = this.domain.getAttribute("HR_Node_Label_Style");
            String string2 = node.getName();
            String string3 = node.getLabel();
            if (string != null) {
                if (string.equals("1")) {
                    return string2;
                }
                if (string.equals("2")) {
                    return string3.equals("") ? string2 : string3 + " (" + string2 + ")";
                }
            }
            return string3.equals("") ? string2 : string3;
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
            return "";
        }
    }

    protected void propagate() {
        try {
            this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
            this.propagationUpdate();
        }
        catch (ExceptionHugin exceptionHugin) {
            // empty catch block
        }
    }

    public void showData(String string, StreamData streamData) {
        try {
            if (this.domain.getNumberOfCases() > 0) {
                this.clear(false);
                this.fileLabel.setText(HuginGUIConstants.get("AW_Data_file") + string);
                this.numberOfCasesLabel.setText(HuginGUIConstants.get("AW_Data_number_of_cases") + this.domain.getNumberOfCases());
                this.clearButton.setEnabled(true);
                JTable jTable = new JTable(new ViewCaseModel(this.domain)){

                    public boolean isCellEditable(int n, int n2) {
                        return false;
                    }
                };
                jTable.getTableHeader().setDefaultRenderer(new RaisedHeader());
                this.addTableToScrollPane(jTable, this.viewCasePanel);
                FileCaseListener fileCaseListener = new FileCaseListener(jTable);
                ListSelectionModel listSelectionModel = jTable.getSelectionModel();
                this.pspPanel.selectedCases(false);
                this.twoWayPspPanel.selectedCases(false);
                listSelectionModel.addListSelectionListener(fileCaseListener);
            }
        }
        catch (ExceptionParse exceptionParse) {
        }
        catch (ExceptionHugin exceptionHugin) {
            // empty catch block
        }
    }

    protected Dimension minimumSize(JTable jTable) {
        TableModel tableModel = jTable.getModel();
        TableColumn tableColumn = null;
        Component component = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        TableCellRenderer tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumn = jTable.getColumnModel().getColumn(i);
            component = tableCellRenderer.getTableCellRendererComponent(null, tableColumn.getHeaderValue(), false, false, 0, 0);
            n = component.getPreferredSize().width;
            n2 = 0;
            for (int j = 0; j < jTable.getRowCount(); ++j) {
                component = jTable.getDefaultRenderer(tableModel.getColumnClass(i)).getTableCellRendererComponent(jTable, jTable.getValueAt(j, i), false, false, j, i);
                n2 = Math.max(n2, component.getPreferredSize().width + 15);
            }
            n3 += Math.max(n, n2);
            tableColumn.setPreferredWidth(Math.max(n, n2));
        }
        return new Dimension(n3, jTable.getPreferredSize().height);
    }

    protected void addTableToScrollPane(JTable jTable, JScrollPane jScrollPane) {
        ComponentListener[] componentListenerArray;
        jTable.setPreferredSize(this.psw.minimumSize(jTable));
        Dimension dimension = jTable.getPreferredSize();
        if (jTable.getPreferredSize().width > jScrollPane.getSize().width) {
            jTable.setAutoResizeMode(0);
        } else {
            jTable.setAutoResizeMode(4);
        }
        for (ComponentListener componentListener : componentListenerArray = jScrollPane.getComponentListeners()) {
            jScrollPane.removeComponentListener(componentListener);
        }
        jScrollPane.addComponentListener(new ScrollPanelListener(jTable, dimension));
        jScrollPane.setViewportView(jTable);
    }

    private void clear() {
        this.clear(true);
    }

    private void clear(boolean bl) {
        this.selectedRows = new int[0];
        this.pspPanel.selectedCases(false);
        this.twoWayPspPanel.selectedCases(false);
        if (bl) {
            this.restoreExistingCases(this.domain);
        } else {
            this.retractFindings();
        }
        this.sensitivityComputed(false, null);
        this.pspPanel.clear();
        this.twoWayPspPanel.clear();
        this.constraintsPanel.clear();
        this.fileLabel.setText(HuginGUIConstants.get("AW_Data_file") + "---");
        this.numberOfCasesLabel.setText(HuginGUIConstants.get("AW_Data_number_of_cases") + "0");
        this.viewCasePanel.setViewportView(null);
    }

    protected void initialize() {
        this.initializeNetwork(this.guiFrame);
    }

    protected void retractFindings() {
        try {
            this.domain.retractFindings();
            Hugin.mainFrame.getSelectedProjectFrame().getNetworkPanel().repaint();
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
    }

    private void initializeNetwork(HuginGUIFrame huginGUIFrame) {
        BeliefBarPanel beliefBarPanel = ((HuginProjectFrame)this.guiFrame.desktop.getSelectedFrame()).getBeliefBarPanel();
        try {
            this.domain.setNumberOfCases(0);
            beliefBarPanel.initialize();
            Hugin.mainFrame.getSelectedProjectFrame().getNetworkPanel().repaint();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        String string = HuginGUIConstants.get("MENU_NETWORK_Initialize_LONG_DESC");
        int n = Math.max(-1, string.lastIndexOf(HuginGUIConstants.get("DESC_SEP_CHAR")));
        string = string.substring(n + 1);
        Hugin.mainFrame.getStatusBar().write(string);
    }

    protected void sensitivityComputed(boolean bl, COM.hugin.HAPI.Node node) {
        this.sensitivityDataComputed = bl;
        this.computedNode = node;
    }

    protected boolean isSensitivityComputed() {
        return this.sensitivityDataComputed;
    }

    protected boolean isSensitivityComputedFor(COM.hugin.HAPI.Node node) {
        return this.isSensitivityComputed() && this.computedNode != null && this.computedNode.equals(node);
    }

    public void addValueChangeListener(ChangeListener changeListener) {
        this.valueChangeListener = changeListener;
    }

    public void removeValueChangeListener() {
        this.valueChangeListener = null;
        this.pspPanel.networkButton.setEnabled(this.selectedRows.length == 0);
    }

    private void fireMinMaxValuesChanged() {
        if (this.valueChangeListener != null) {
            this.valueChangeListener.stateChanged(new ChangeEvent(new Object()));
        }
    }

    public void addNewCaseInsertedListener(ChangeListener changeListener) {
        this.caseListeners.add(changeListener);
    }

    public void removeNewCaseInsertedListener() {
        this.caseListeners.removeAllElements();
    }

    public void fireCaseInserted() {
        for (ChangeListener changeListener : this.caseListeners) {
            if (changeListener == null) continue;
            changeListener.stateChanged(new ChangeEvent(new Object()));
        }
    }

    protected DiscreteChanceNode getSelectedHypothesisNode() {
        return this.pspPanel.getSelectedHypothesisNode();
    }

    private void propagationUpdate() {
        this.constraintsPanel.propagationUpdate();
        this.validate();
    }

    private void cleanUp() {
        this.removeValueChangeListener();
        this.removeNewCaseInsertedListener();
        this.clearMinMaxSensitivityValues();
        this.restoreExistingCases(this.domain);
        this.projectFrame.getNetworkPanel().updateBackpointers();
    }

    private void storeExistingCases(Domain domain) {
        try {
            this.caseBank = new CaseBank(domain);
            this.caseBank.newCase();
            this.caseBank.copyCasesFromDomain();
            this.caseBank.enterCase(0);
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    private void restoreExistingCases(Domain domain) {
        try {
            domain.retractFindings();
            this.caseBank.enterCase(0);
            domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
            domain.setNumberOfCases(0);
            this.caseBank.copyCasesToDomain(1, this.caseBank.getNumberOfCases() - 1);
            this.guiFrame.getSelectedProjectFrame().getNetworkPanel().repaint();
            this.guiFrame.getSelectedProjectFrame().repaint();
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
    }

    private void enterInitialCase() {
        try {
            this.caseBank.enterCase(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void syncClassToDomain(Node node) {
        try {
            if (node.isDiscreteChance()) {
                DiscreteChanceNode discreteChanceNode = (DiscreteChanceNode)node.getAPINode();
                DiscreteChanceNode discreteChanceNode2 = (DiscreteChanceNode)this.domain.getNodeByName(discreteChanceNode.getName());
                discreteChanceNode2.getTable().setData(discreteChanceNode.getTable().getData());
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
    }

    protected void syncDomainToClass(Node node) {
        try {
            if (node.isDiscreteChance()) {
                DiscreteChanceNode discreteChanceNode = (DiscreteChanceNode)node.getAPINode();
                DiscreteChanceNode discreteChanceNode2 = (DiscreteChanceNode)this.domain.getNodeByName(discreteChanceNode.getName());
                discreteChanceNode.getTable().setData(discreteChanceNode2.getTable().getData());
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    static /* synthetic */ int[] access$1202(ParameterSensitivityWizard parameterSensitivityWizard, int[] nArray) {
        parameterSensitivityWizard.selectedRows = nArray;
        return nArray;
    }

    private class ResizedListener
    extends ComponentAdapter {
        ParameterSensitivityWizard frame;

        public ResizedListener(ParameterSensitivityWizard parameterSensitivityWizard2) {
            this.frame = parameterSensitivityWizard2;
        }

        public void componentResized(ComponentEvent componentEvent) {
            int n = 600;
            int n2 = this.frame.getWidth();
            int n3 = this.frame.getHeight();
            boolean bl = false;
            if (n2 < 620) {
                n2 = 620;
                bl = true;
            }
            if (n3 < n) {
                n3 = n;
                bl = true;
            }
            if (bl) {
                this.frame.setSize(n2, n3);
            }
        }
    }

    public class RaisedHeader
    implements TableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = new JLabel(" " + object.toString() + " ");
            jLabel.setToolTipText(object.toString());
            jLabel.setHorizontalAlignment(0);
            jLabel.setBorder(BorderFactory.createRaisedBevelBorder());
            return jLabel;
        }
    }

    private class FileCaseListener
    implements ListSelectionListener {
        JTable table;

        public FileCaseListener(JTable jTable) {
            this.table = jTable;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (!listSelectionModel.isSelectionEmpty() && !listSelectionModel.getValueIsAdjusting()) {
                try {
                    int n = -1;
                    int[] nArray = this.table.getSelectedRows();
                    ParameterSensitivityWizard.this.sensitivityComputed(false, null);
                    if (nArray.length == 1) {
                        ParameterSensitivityWizard.access$1202(ParameterSensitivityWizard.this, new int[0]);
                        ParameterSensitivityWizard.this.pspPanel.selectedCases(false);
                        ParameterSensitivityWizard.this.twoWayPspPanel.selectedCases(false);
                        n = nArray[0];
                    } else {
                        ParameterSensitivityWizard.this.retractFindings();
                        ParameterSensitivityWizard.this.enterInitialCase();
                        ParameterSensitivityWizard.this.pspPanel.selectedCases(true);
                        ParameterSensitivityWizard.this.twoWayPspPanel.selectedCases(true);
                        ParameterSensitivityWizard.access$1202(ParameterSensitivityWizard.this, nArray);
                    }
                    if (n != -1) {
                        ParameterSensitivityWizard.this.domain.enterCase(n);
                    }
                    ParameterSensitivityWizard.this.propagate();
                    ParameterSensitivityWizard.this.projectFrame.repaint();
                    ParameterSensitivityWizard.this.projectFrame.getNetworkPanel().repaint();
                    ParameterSensitivityWizard.this.fireCaseInserted();
                }
                catch (ExceptionHugin exceptionHugin) {
                    ParameterSensitivityWizard.this.projectFrame.repaint();
                    ParameterSensitivityWizard.this.projectFrame.getNetworkPanel().repaint();
                    ParameterSensitivityWizard.this.fireCaseInserted();
                    new HuginGUIError(exceptionHugin.getMessage());
                }
            }
        }
    }

    class ScrollPanelListener
    implements ComponentListener {
        private JTable table;
        Dimension dim;

        public ScrollPanelListener(JTable jTable, Dimension dimension) {
            this.table = jTable;
            this.dim = dimension;
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            Object object = componentEvent.getSource();
            if (object instanceof JScrollPane) {
                JScrollPane jScrollPane = (JScrollPane)componentEvent.getSource();
                if (this.dim.width > jScrollPane.getSize().width) {
                    this.table.setPreferredSize(ParameterSensitivityWizard.this.psw.minimumSize(this.table));
                    this.table.setAutoResizeMode(0);
                } else {
                    this.table.setAutoResizeMode(4);
                }
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
        }
    }

    class CaseOrDataParseListener
    implements ParseListener {
        String errMsg = "";
        int line = 0;
        boolean errors = false;

        public void parseError(int n, String string) {
            if (!this.errors) {
                this.line = n;
                this.errMsg = string;
                this.errors = true;
            } else if (n > this.line) {
                new HuginGUIError(HuginGUIConstants.get("str_error_in_data_file_line_ARG0_lb_ARG1", new String[]{"" + n, string}));
            } else if (n < this.line) {
                new HuginGUIError(HuginGUIConstants.get("str_error_in_case_file_line_ARG0_lb_ARG1", new String[]{"" + this.line, this.errMsg}));
            } else if (n == this.line) {
                if (this.errMsg.equals(string)) {
                    new HuginGUIError(HuginGUIConstants.get("str_error_in_file_line_ARG0_lb_ARG1", new String[]{"" + n, string}));
                } else {
                    new HuginGUIError(HuginGUIConstants.get("str_error_in_case_lb_or_lb_data_file_line_ARG0_lb_ARG1", new String[]{"" + this.line, this.errMsg}));
                }
            }
        }
    }

    private class CaseFileListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            HuginFileLoader huginFileLoader = new HuginFileLoader(9, Hugin.mainFrame.getMostRecentDataFile(), 0);
            huginFileLoader.setLocation(100, 100);
            int n = huginFileLoader.showDialog(ParameterSensitivityWizard.this.psw);
            if (n == 0) {
                File file = huginFileLoader.getSelectedFile();
                Hugin.mainFrame.setMostRecentDataFile(file);
                try {
                    ParameterSensitivityWizard.this.clear();
                    CaseOrDataParseListener caseOrDataParseListener = new CaseOrDataParseListener();
                    boolean bl = false;
                    try {
                        ParameterSensitivityWizard.this.domain.parseCase(file.getPath(), caseOrDataParseListener);
                    }
                    catch (ExceptionParse exceptionParse) {
                        bl = true;
                    }
                    if (bl) {
                        ParameterSensitivityWizard.this.domain.parseCases(file.getPath(), caseOrDataParseListener);
                    } else {
                        HuginGUIUtils.createCaseFromEnteredEvidence(ParameterSensitivityWizard.this.domain);
                        ParameterSensitivityWizard.this.projectFrame.addCaseName(file.getName());
                    }
                    ParameterSensitivityWizard.this.propagate();
                    ParameterSensitivityWizard.this.projectFrame.repaint();
                    if (ParameterSensitivityWizard.this.domain.getNumberOfCases() > 0) {
                        ParameterSensitivityWizard.this.fileLabel.setText(HuginGUIConstants.get("AW_Data_file") + file.getName());
                        ParameterSensitivityWizard.this.numberOfCasesLabel.setText(HuginGUIConstants.get("AW_Data_number_of_cases") + ParameterSensitivityWizard.this.domain.getNumberOfCases());
                        ParameterSensitivityWizard.this.clearButton.setEnabled(true);
                        JTable jTable = new JTable(new ViewCaseModel(ParameterSensitivityWizard.this.domain)){

                            public boolean isCellEditable(int n, int n2) {
                                return false;
                            }
                        };
                        jTable.getTableHeader().setDefaultRenderer(new RaisedHeader());
                        ParameterSensitivityWizard.this.addTableToScrollPane(jTable, ParameterSensitivityWizard.this.viewCasePanel);
                        FileCaseListener fileCaseListener = new FileCaseListener(jTable);
                        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
                        ParameterSensitivityWizard.this.pspPanel.selectedCases(false);
                        ParameterSensitivityWizard.this.twoWayPspPanel.selectedCases(false);
                        listSelectionModel.addListSelectionListener(fileCaseListener);
                    }
                }
                catch (ExceptionInconsistencyOrUnderflow exceptionInconsistencyOrUnderflow) {
                    JOptionPane.showMessageDialog(ParameterSensitivityWizard.this.psw, HuginGUIConstants.get("str_inconsistency_detected_impossible_cases"));
                    ParameterSensitivityWizard.this.clear();
                    file = null;
                }
                catch (ExceptionParse exceptionParse) {
                    ParameterSensitivityWizard.this.clear();
                    file = null;
                }
                catch (ExceptionHugin exceptionHugin) {
                    // empty catch block
                }
            }
        }
    }

    private class DomainCasesListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            StreamData streamData = (StreamData)changeEvent.getSource();
            String string = streamData.getSourceName();
            ParameterSensitivityWizard.this.showData(string, streamData);
        }
    }

    private class ViewCaseModel
    extends DefaultTableModel {
        Domain domain;
        COM.hugin.HAPI.Node[] nodes;
        int numRows;

        public ViewCaseModel(Domain domain) throws ExceptionHugin {
            this.domain = domain;
            this.numRows = domain.getNumberOfCases();
            NodeList nodeList = domain.getNodes();
            NodeList nodeList2 = new NodeList();
            for (COM.hugin.HAPI.Node node : nodeList) {
                if (!(node instanceof UtilityNode)) continue;
                nodeList2.add(node);
            }
            for (COM.hugin.HAPI.Node node : nodeList2) {
                nodeList.remove(node);
            }
            this.nodes = nodeList.toArray(new COM.hugin.HAPI.Node[0]);
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return "" + n;
            }
            --n2;
            try {
                if (this.nodes[n2] instanceof DiscreteChanceNode) {
                    if (((DiscreteChanceNode)this.nodes[n2]).caseIsSet(n)) {
                        if (this.nodes[n2] instanceof IntervalDCNode) {
                            return "" + HuginGUIUtils.printInf(((IntervalDCNode)this.nodes[n2]).getStateValue(((IntervalDCNode)this.nodes[n2]).getCaseState(n))) + " - " + HuginGUIUtils.printInf(((IntervalDCNode)this.nodes[n2]).getStateValue(((IntervalDCNode)this.nodes[n2]).getCaseState(n) + 1));
                        }
                        return ((DiscreteChanceNode)this.nodes[n2]).getStateLabel(((DiscreteChanceNode)this.nodes[n2]).getCaseState(n));
                    }
                    return HuginGUIConstants.get("str_NA");
                }
                if (this.nodes[n2] instanceof DiscreteDecisionNode) {
                    if (((DiscreteDecisionNode)this.nodes[n2]).caseIsSet(n)) {
                        if (this.nodes[n2] instanceof IntervalDDNode) {
                            return "" + HuginGUIUtils.printInf(((IntervalDDNode)this.nodes[n2]).getStateValue(((IntervalDDNode)this.nodes[n2]).getCaseState(n))) + " - " + HuginGUIUtils.printInf(((IntervalDDNode)this.nodes[n2]).getStateValue(((IntervalDDNode)this.nodes[n2]).getCaseState(n) + 1));
                        }
                        return ((DiscreteDecisionNode)this.nodes[n2]).getStateLabel(((DiscreteDecisionNode)this.nodes[n2]).getCaseState(n));
                    }
                    return HuginGUIConstants.get("str_NA");
                }
                if (this.nodes[n2] instanceof ContinuousChanceNode) {
                    if (((ContinuousChanceNode)this.nodes[n2]).caseIsSet(n)) {
                        return new Double(((ContinuousChanceNode)this.nodes[n2]).getCaseValue(n)).toString();
                    }
                    return HuginGUIConstants.get("str_NA");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "-";
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return HuginGUIConstants.get("AW_Accuracy_case_no");
            }
            --n;
            String string = HuginGUIConstants.get("str_error_detected");
            try {
                String string2;
                string = string2 = ParameterSensitivityWizard.this.getNodeName(this.nodes[n]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string;
        }

        public int getColumnCount() {
            return this.nodes.length + 1;
        }

        public int getRowCount() {
            return this.numRows;
        }
    }

    private class HelpListener
    implements ActionListener {
        String[] helpPages;

        public HelpListener(String[] stringArray) {
            this.helpPages = stringArray;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ParameterSensitivityWizard.this.tabbedPane.getSelectedIndex();
            if (n >= 0 && n < this.helpPages.length) {
                ParameterSensitivityWizard.this.helpPanel.setHelpPage(this.helpPages[n]);
                if (!ParameterSensitivityWizard.this.helpPanel.isVisible()) {
                    int n2 = ParameterSensitivityWizard.this.getX() - ParameterSensitivityWizard.this.helpPanel.getWidth();
                    if (n2 < 5 && (n2 = ParameterSensitivityWizard.this.getX() + ParameterSensitivityWizard.this.getWidth()) + ParameterSensitivityWizard.this.helpPanel.getWidth() > Toolkit.getDefaultToolkit().getScreenSize().width - 5) {
                        n2 = 5;
                    }
                    ParameterSensitivityWizard.this.helpPanel.setLocation(n2, ParameterSensitivityWizard.this.getY());
                    ParameterSensitivityWizard.this.helpPanel.setVisible(true);
                }
            }
        }
    }

    private class CloseListener
    implements WindowListener {
        private Domain domain;
        private NetworkPanel networkPanel;

        public CloseListener(Domain domain, NetworkPanel networkPanel) {
            this.domain = domain;
            this.networkPanel = networkPanel;
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            ParameterSensitivityWizard.this.cleanUp();
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }
    }
}

