/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.BooleanDCNode;
import COM.hugin.HAPI.BooleanDDNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HAPI.IntervalDDNode;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.NumberedDCNode;
import COM.hugin.HAPI.NumberedDDNode;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.PastingTextField;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ListIterator;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.Popup;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentListener;

public class ParentInserterField
extends PastingTextField {
    NodeList parents;
    JPopupMenu popup;
    Popup infoPopup;
    int x;
    DocumentListener listener;
    String info = "Testing the info popup";
    ParentInserterField pif;
    PopupListener popupListener;
    JInternalFrame frame;
    int ttStart;
    int ttEnd;
    String ttSelectionColor;

    public ParentInserterField(NodeList nodeList) {
        this.parents = nodeList;
        this.populatePopup();
        this.pif = this;
        this.ttStart = 0;
        this.ttEnd = 0;
        this.ttSelectionColor = "red";
    }

    public ParentInserterField(NodeList nodeList, String string) {
        super(string);
        this.parents = nodeList;
        this.populatePopup();
        this.pif = this;
        this.ttStart = 0;
        this.ttEnd = 0;
        this.ttSelectionColor = "red";
    }

    public ParentInserterField(int n) {
        super(n);
        this.parents = null;
        this.pif = this;
        this.ttStart = 0;
        this.ttEnd = 0;
        this.ttSelectionColor = "red";
    }

    public ParentInserterField(NodeList nodeList, int n) {
        super(n);
        this.parents = nodeList;
        this.populatePopup();
        this.pif = this;
        this.ttStart = 0;
        this.ttEnd = 0;
        this.ttSelectionColor = "red";
    }

    public ParentInserterField(NodeList nodeList, String string, int n) {
        super(string, n);
        this.parents = nodeList;
        this.populatePopup();
        this.pif = this;
        this.ttStart = 0;
        this.ttEnd = 0;
        this.ttSelectionColor = "red";
    }

    private void populatePopup() {
        this.popup = new JPopupMenu();
        if (this.parents != null && this.parents.size() > 0) {
            try {
                ListIterator listIterator = this.parents.listIterator();
                while (listIterator.hasNext()) {
                    Node node = (Node)listIterator.next();
                    PopupObject popupObject = new PopupObject(node);
                    JMenu jMenu = new JMenu(popupObject.toString());
                    String string = this.getType(node);
                    JMenuItem jMenuItem = new JMenuItem(popupObject.toString());
                    jMenuItem.addActionListener(new InsertListener(popupObject));
                    if (string.length() > 0) {
                        jMenu.setToolTipText(string);
                        jMenuItem.setToolTipText(string);
                    }
                    jMenu.add(jMenuItem);
                    if (node instanceof DiscreteNode) {
                        int n = ((DiscreteNode)node).getNumberOfStates();
                        for (int i = 0; i < n; ++i) {
                            PopupObject popupObject2 = new PopupObject((DiscreteNode)node, i);
                            JMenuItem jMenuItem2 = new JMenuItem(popupObject2.toString());
                            jMenuItem2.addActionListener(new InsertListener(popupObject2));
                            jMenu.add(jMenuItem2);
                        }
                    }
                    this.popup.add(jMenu);
                }
            }
            catch (ExceptionHugin exceptionHugin) {}
        } else {
            JMenuItem jMenuItem = new JMenuItem(HuginGUIConstants.get("EBW_Msg_No_Parents"));
            this.popup.add(jMenuItem);
        }
        this.popupListener = new PopupListener();
        this.addMouseListener(this.popupListener);
    }

    public void addExpressionListener(DocumentListener documentListener) {
        this.listener = documentListener;
    }

    private String getType(Node node) {
        String string = "";
        if (node instanceof DiscreteNode) {
            string = node instanceof BooleanDCNode || node instanceof BooleanDDNode ? HuginGUIConstants.get("NODE_PROPERTIES_boolean") : (node instanceof NumberedDCNode || node instanceof NumberedDDNode ? HuginGUIConstants.get("NODE_PROPERTIES_numbered") : (node instanceof IntervalDCNode || node instanceof IntervalDDNode ? HuginGUIConstants.get("NODE_PROPERTIES_interval") : HuginGUIConstants.get("NODE_PROPERTIES_labelled")));
        }
        return string;
    }

    public void setToolTipSelection(int n, int n2) {
        this.ttStart = n;
        this.ttEnd = n2;
    }

    public void setToolTipSelectionColor(Color color) {
        String string = Integer.toHexString(color.getRed());
        String string2 = Integer.toHexString(color.getGreen());
        String string3 = Integer.toHexString(color.getBlue());
        if (string.length() == 1) {
            string = "0" + string;
        }
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        this.ttSelectionColor = "#" + string + string2 + string3;
    }

    public int getToolTipSelectionStart() {
        return this.ttStart;
    }

    public int getToolTipSelectionEnd() {
        return this.ttEnd;
    }

    public boolean hasToolTipSelection() {
        return this.ttStart < this.ttEnd && this.ttStart >= 0 && this.ttEnd <= this.getText().length();
    }

    public void setToolTipText(String string) {
        String string2 = "";
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth(this.getText());
        int n2 = Toolkit.getDefaultToolkit().getScreenSize().width;
        int n3 = this.ttStart;
        int n4 = this.ttEnd;
        if (n > n2 && string != null && string.length() > 0) {
            char[] cArray = string.toCharArray();
            int n5 = 0;
            String string3 = "";
            String string4 = "<br>";
            int n6 = string4.length();
            for (int i = 0; i < cArray.length; ++i) {
                ++n5;
                string2 = string2 + cArray[i];
                if (fontMetrics.stringWidth(string3 = string3 + cArray[i]) < n2 - 20) continue;
                if (this.hasToolTipSelection()) {
                    if (this.ttStart > i) {
                        n3 += n6;
                        n4 += n6;
                    } else if (this.ttEnd > i) {
                        n4 += n6;
                    }
                }
                string2 = string2 + string4;
                string3 = "";
            }
        }
        int n7 = Integer.MAX_VALUE;
        ToolTipManager.sharedInstance().setDismissDelay(n7);
        if (string2.length() == 0) {
            string2 = string;
        }
        super.setToolTipText(this.formatText(string2, n3, n4));
    }

    private String formatText(String string, int n, int n2) {
        try {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n, n2);
            String string4 = string.substring(n2, string.length());
            String string5 = "<HTML><BODY><DIV  TEXT-JUSTIFICATION: JUSTIFY;>" + string2 + "<B><FONT: COLOR = \"" + this.ttSelectionColor + "\">" + string3 + "</FONT></B>" + string4 + "</DIV></BODY></HTML>";
            return string5;
        }
        catch (Exception exception) {
            return "<html><body><div text-justification: justify;>" + string + "</div></body></html>";
        }
    }

    private boolean isInfinity(String string) {
        return string.toLowerCase().indexOf("inf".toLowerCase()) != -1;
    }

    class PopupObject {
        String display = "";
        String value = "";

        public PopupObject(String string, String string2) {
            this.display = string;
            this.value = string2;
        }

        public PopupObject(Node node) {
            try {
                this.display = HuginGUIUtils.getNodeTitle(node, 2);
                this.value = node.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public PopupObject(DiscreteNode discreteNode, int n) {
            this.initialize(discreteNode, n);
        }

        public void initialize(DiscreteNode discreteNode, int n) {
            String string = "and";
            String string2 = "(";
            String string3 = ")";
            String string4 = ",";
            String string5 = "<";
            String string6 = ">";
            try {
                if (discreteNode instanceof BooleanDCNode || discreteNode instanceof BooleanDDNode || discreteNode instanceof NumberedDCNode || discreteNode instanceof NumberedDDNode) {
                    this.value = this.display = HuginGUIUtils.getNodeStateLabel(discreteNode, n);
                } else if (discreteNode instanceof IntervalDDNode) {
                    this.display = HuginGUIUtils.getNodeStateLabel(discreteNode, n);
                    String string7 = HuginGUIUtils.printDouble(((IntervalDDNode)discreteNode).getStateValue(n));
                    String string8 = HuginGUIUtils.printDouble(((IntervalDDNode)discreteNode).getStateValue(n + 1));
                    if (ParentInserterField.this.isInfinity(string7) && ParentInserterField.this.isInfinity(string8)) {
                        this.value = "";
                    }
                    if (ParentInserterField.this.isInfinity(string7) && !ParentInserterField.this.isInfinity(string8)) {
                        this.value = discreteNode.getName() + " " + string5 + " " + string8;
                    }
                    if (!ParentInserterField.this.isInfinity(string7) && ParentInserterField.this.isInfinity(string8)) {
                        this.value = discreteNode.getName() + " " + string6 + " " + string7;
                    }
                    if (!ParentInserterField.this.isInfinity(string7) && !ParentInserterField.this.isInfinity(string8)) {
                        this.value = string + string2 + discreteNode.getName() + " " + string6 + " " + string7 + string4 + " " + discreteNode.getName() + " " + string5 + " " + string8 + string3;
                    }
                } else if (discreteNode instanceof IntervalDCNode) {
                    this.display = HuginGUIUtils.getNodeStateLabel(discreteNode, n);
                    String string9 = HuginGUIUtils.printDouble(((IntervalDCNode)discreteNode).getStateValue(n));
                    String string10 = HuginGUIUtils.printDouble(((IntervalDCNode)discreteNode).getStateValue(n + 1));
                    if (ParentInserterField.this.isInfinity(string9) && ParentInserterField.this.isInfinity(string10)) {
                        this.value = "";
                    }
                    if (ParentInserterField.this.isInfinity(string9) && !ParentInserterField.this.isInfinity(string10)) {
                        this.value = discreteNode.getName() + " " + string5 + " " + string10;
                    }
                    if (!ParentInserterField.this.isInfinity(string9) && ParentInserterField.this.isInfinity(string10)) {
                        this.value = discreteNode.getName() + " " + string6 + " " + string9;
                    }
                    if (!ParentInserterField.this.isInfinity(string9) && !ParentInserterField.this.isInfinity(string10)) {
                        this.value = string + string2 + discreteNode.getName() + " " + string6 + " " + string9 + string4 + " " + discreteNode.getName() + " " + string5 + " " + string10 + string3;
                    }
                } else {
                    this.display = HuginGUIUtils.getNodeStateLabel(discreteNode, n);
                    this.value = "\"" + this.display + "\"";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String toString() {
            return this.display;
        }

        public String getValue() {
            return this.value;
        }
    }

    class InsertListener
    implements ActionListener {
        PopupObject obj;

        public InsertListener(PopupObject popupObject) {
            this.obj = popupObject;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ParentInserterField.this.replaceSelection(this.obj.getValue());
        }
    }

    public class PopupListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void showPopup(MouseEvent mouseEvent) {
            if (ParentInserterField.this.popup != null && (mouseEvent.isPopupTrigger() || mouseEvent.paramString().indexOf("mods=4") == 0) && ParentInserterField.this.isEnabled()) {
                ParentInserterField.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                ParentInserterField.this.x = mouseEvent.getX();
            }
        }
    }
}

