/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Class;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIEventHandler;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.NetworkInformation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PopupClassesList
extends JMenu {
    HuginGUIFrame owner;
    final JComponent addTo;
    LinkedList<PopupClass> classesList = null;
    int size = 0;

    public PopupClassesList(JMenu jMenu) {
        this.addTo = jMenu;
    }

    public PopupClassesList(JComboBox jComboBox) {
        this.addTo = jComboBox;
    }

    public PopupClassesList(JPopupMenu jPopupMenu) {
        this.addTo = jPopupMenu;
    }

    public void orderClasses(HuginGUIFrame huginGUIFrame, Class clazz) {
        Serializable serializable;
        Object exception;
        this.owner = huginGUIFrame;
        this.classesList = PopupClassesList.createClassesList(clazz);
        HuginProjectFrame huginProjectFrame = (HuginProjectFrame)huginGUIFrame.desktop.getSelectedFrame();
        final MyAbstractListModel myAbstractListModel = new MyAbstractListModel();
        for (PopupClass object22 : this.classesList) {
            try {
                exception = object22.homeClass;
                serializable = new HuginGUIEventHandler.POPUP_MENU_instance_class(huginProjectFrame, (NetworkModel)exception, object22.getName());
                if (object22.isLegal) {
                    myAbstractListModel.add(new ClassItem(huginProjectFrame, (AbstractAction)serializable, object22));
                }
                ++this.size;
            }
            catch (Exception exception2) {
                new HuginGUIError(exception2);
            }
        }
        final JList jList = new JList(myAbstractListModel);
        jList.setCellRenderer(new MyClassCellRenderer());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                int n = jList.locationToIndex(mouseEvent.getPoint());
                if (n > -1) {
                    ClassItem classItem = myAbstractListModel.getElementAt(n);
                    try {
                        classItem._projectFrame.getNetworkPanel().setInstanceNodeClass(classItem._net.homeClass);
                        classItem._projectFrame.getNetworkPanel().setEditMode(6);
                        PopupClassesList.this.addTo.setVisible(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        exception = new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                System.out.println(jList.locationToIndex(mouseEvent.getPoint()));
            }
        };
        jList.addMouseListener(mouseAdapter);
        serializable = new JScrollPane(jList){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = Math.min(dimension.width, 200);
                dimension.width += this.getVerticalScrollBar().getPreferredSize().width;
                dimension.height = Math.min(dimension.height, 16 * myAbstractListModel.getSize());
                dimension.height += this.getHorizontalScrollBar().getPreferredSize().height;
                return dimension;
            }
        };
        this.addTo.add((Component)serializable);
    }

    private static LinkedList<PopupClass> createClassesList(NetworkModel networkModel) {
        boolean bl = false;
        if (Hugin.mainFrame != null) {
            if (HuginGUIFrame.getProjectFrame(networkModel) != null) {
                if (HuginGUIFrame.getProjectFrame(networkModel).getNetworkPanel() != null) {
                    bl = HuginGUIFrame.getProjectFrame(networkModel).getNetworkPanel().hasCDVT();
                }
            }
        }
        LinkedList<PopupClass> linkedList = new LinkedList<PopupClass>();
        NetworkInformation networkInformation = new NetworkInformation();
        NetworkInformation networkInformation2 = new NetworkInformation();
        if (networkModel instanceof Domain) {
            return linkedList;
        }
        networkInformation2.evaluate(networkModel);
        for (HuginProjectFrame huginProjectFrame : HuginGUIFrame.getProjectFrames()) {
            NetworkModel networkModel2;
            if (huginProjectFrame.getNetworkPanel() == null || huginProjectFrame.getNetworkPanel().getHome() == null || (networkModel2 = huginProjectFrame.getHomeClass()) == null) continue;
            networkInformation.evaluate(networkModel2);
            if (networkModel2.equals(networkModel) || huginProjectFrame.getNetworkPanel().hasCDVT() || bl) continue;
            linkedList.add(new PopupClass(huginProjectFrame, networkInformation2, networkInformation));
        }
        Comparator<PopupClass> comparator = new Comparator<PopupClass>(){

            @Override
            public int compare(PopupClass popupClass, PopupClass popupClass2) {
                Class clazz = popupClass.homeClass;
                Class clazz2 = popupClass2.homeClass;
                try {
                    return clazz.getName().compareTo(clazz2.getName());
                }
                catch (Exception exception) {
                    return -1;
                }
            }
        };
        Collections.sort(linkedList, comparator);
        return linkedList;
    }

    public int getClassCount() {
        return this.size;
    }

    public NetworkModel get(int n) {
        if (this.classesList == null || n < 0 || n >= this.size) {
            return null;
        }
        return this.classesList.get((int)n).homeClass;
    }

    public static int getClassCount(NetworkModel networkModel) {
        return PopupClassesList.createClassesList(networkModel).size();
    }

    public static class PopupClass {
        Class homeClass;
        boolean isLegal;
        boolean isPre60;
        boolean containsInstanceOf;
        boolean isConsistent;
        HuginProjectFrame project;

        public PopupClass(HuginProjectFrame huginProjectFrame, NetworkInformation networkInformation, NetworkInformation networkInformation2) {
            this.project = huginProjectFrame;
            this.homeClass = huginProjectFrame.getNetworkPanel().getHomeClass();
            this.isPre60 = huginProjectFrame.isPre60();
            this.containsInstanceOf = HuginProjectFrame.containsInstanceOf(networkInformation2.homeClass, networkInformation.homeClass);
            this.isConsistent = !networkInformation2.isContinuous && !networkInformation2.isDecision || !networkInformation.isContinuous && !networkInformation.isDecision || networkInformation.isContinuous == networkInformation2.isContinuous && networkInformation.isDecision == networkInformation2.isDecision;
            this.isLegal = !this.isPre60 && !this.containsInstanceOf && this.isConsistent;
        }

        public String getName() throws ExceptionHugin {
            if (this.homeClass instanceof Class) {
                return this.homeClass.getName();
            }
            return this.project.getTitle();
        }
    }

    public static class ClassItem
    extends JMenuItem {
        public PopupClass _net;
        AbstractAction _action;
        HuginProjectFrame _projectFrame;

        public ClassItem(HuginProjectFrame huginProjectFrame, AbstractAction abstractAction, PopupClass popupClass) {
            super(abstractAction);
            this._projectFrame = huginProjectFrame;
            this._action = abstractAction;
            this._net = popupClass;
            this.addMouseListener(new ClassListMouseListener(popupClass));
        }

        private static class ClassListMouseListener
        extends MouseAdapter {
            PopupClass net;

            public ClassListMouseListener(PopupClass popupClass) {
                this.net = popupClass;
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                if (this.net.isLegal) {
                    try {
                        String string = HuginGUIConstants.get("INSTANTIATE_THIS1");
                        String string2 = HuginGUIConstants.get("INSTANTIATE_THIS2");
                        Hugin.mainFrame.statusBar.write(string + this.net.getName() + string2);
                    }
                    catch (ExceptionHugin exceptionHugin) {
                        new HuginGUIError(exceptionHugin);
                    }
                } else if (this.net.isPre60) {
                    Hugin.mainFrame.statusBar.write(HuginGUIConstants.get("CANT_INSTANTIATE_PRE60"));
                } else if (this.net.containsInstanceOf) {
                    Hugin.mainFrame.statusBar.write(HuginGUIConstants.get("CANT_INSTANTIATE_RECURSIVELY"));
                } else if (!this.net.isConsistent) {
                    Hugin.mainFrame.statusBar.write(HuginGUIConstants.get("CANT_INSTANTIATE_INCONSISTENT_NETS"));
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                Hugin.mainFrame.statusBar.clear();
            }
        }
    }

    public static class MyClassCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MyClassCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ClassItem classItem = (ClassItem)object;
            PopupClass popupClass = classItem._net;
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
                if (popupClass.isLegal) {
                    try {
                        String string = HuginGUIConstants.get("INSTANTIATE_THIS1");
                        String string2 = HuginGUIConstants.get("INSTANTIATE_THIS2");
                        Hugin.mainFrame.statusBar.write(string + popupClass.getName() + string2);
                    }
                    catch (ExceptionHugin exceptionHugin) {
                        new HuginGUIError(exceptionHugin);
                    }
                } else if (popupClass.isPre60) {
                    Hugin.mainFrame.statusBar.write(HuginGUIConstants.get("CANT_INSTANTIATE_PRE60"));
                } else if (popupClass.containsInstanceOf) {
                    Hugin.mainFrame.statusBar.write(HuginGUIConstants.get("CANT_INSTANTIATE_RECURSIVELY"));
                } else if (!popupClass.isConsistent) {
                    Hugin.mainFrame.statusBar.write(HuginGUIConstants.get("CANT_INSTANTIATE_INCONSISTENT_NETS"));
                }
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            try {
                this.setText(classItem._net.getName());
            }
            catch (ExceptionHugin exceptionHugin) {
                new HuginGUIError(exceptionHugin);
            }
            return this;
        }
    }

    public static class MyAbstractListModel
    extends AbstractListModel {
        Vector<ClassItem> classes = new Vector();

        public int getSize() {
            return this.classes.size();
        }

        public ClassItem getElementAt(int n) {
            return this.classes.get(n);
        }

        public void add(ClassItem classItem) {
            this.classes.add(classItem);
        }
    }
}

