/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.InvalidPreProcessNodeException;
import COM.hugin.HGUI.PreProcessNotInitializedException;
import COM.hugin.HGUI.PreProcessingException;
import javax.swing.JPanel;

public abstract class PreProcess {
    private int index;
    protected String name;
    private String errorMessage = HuginGUIConstants.get("str_no_error");

    public PreProcess() {
        this.name = null;
        this.index = -1;
    }

    public abstract String process(String var1) throws PreProcessingException;

    public boolean providesInterface() {
        return false;
    }

    public JPanel getInterface() {
        return null;
    }

    public boolean storeValues() {
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return "Abstract Preprocess";
    }

    public boolean multiplePreprocessesAllowed() {
        return false;
    }

    public boolean equals(Object object) {
        return object instanceof PreProcess && ((PreProcess)object).getName().equals(this.getName());
    }

    protected PreProcess(String string) {
        this.name = string;
        this.index = -1;
    }

    protected String[] process(String[] stringArray) throws PreProcessingException {
        if (this.index < 0) {
            throw new PreProcessNotInitializedException(HuginGUIConstants.get("str_the_replace_process_has_not_been_initialized_and_cannot_go_on"));
        }
        if (stringArray.length <= this.index) {
            throw new PreProcessingException(HuginGUIConstants.get("str_not_enough_fields_in_data"));
        }
        String string = stringArray[this.index];
        if (string == null) {
            return stringArray;
        }
        stringArray[this.index] = this.process(string);
        return stringArray;
    }

    protected void initialize(String[] stringArray) throws InvalidPreProcessNodeException {
        if (stringArray == null) {
            throw new InvalidPreProcessNodeException(HuginGUIConstants.get("str_no_nodes_in_set"));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                if (stringArray[i] == null || !stringArray[i].equals(this.getName()) && !HuginGUIUtils.getLegalName(stringArray[i], null).equals(this.getName())) continue;
                this.index = i;
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new InvalidPreProcessNodeException(HuginGUIConstants.get("str_the_specified_preprocess_name_") + this.name + HuginGUIConstants.get("str__does_not_match_any_in_the_file"));
    }

    protected void setName(String string) {
        this.name = string;
    }

    protected String getNodeName() {
        return this.name;
    }

    public String toString() {
        return this.getDescription();
    }
}

