/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Domain;
import COM.hugin.HGUI.DomainAttributes;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.NodeGroup;
import java.awt.Color;
import java.util.Vector;

public class Preferences {
    protected HuginGUIFrame guiFrame;
    public int recently_used;
    public int autosave;
    public int language;
    public int latest_message;
    public boolean beep_on_errors;
    public boolean display_errors;
    public boolean display_oobn_warnings;
    public int error_list_size;
    public int compilation_warning;
    public int grain_size;
    public int level_of_concurrency;
    public boolean use_wallpaper;
    public boolean show_belief_bar;
    public boolean check_update;
    public String wallpaper_name;
    public String default_browser;
    public int drag_mode;
    public static final int NODE_TABLE_CONNECTION_TIGHT = 0;
    public static final int NODE_TABLE_CONNECTION_LOOSE = 1;
    public int node_table_connection_mode;
    public Vector<Color> barColors;
    public static final int TABLE_MODE_FRAMES = 0;
    public static final int TABLE_MODE_TABBED = 1;
    public int table_mode;
    public static final int CELL_MODE_NORMAL = 0;
    public static final int CELL_MODE_BARS = 1;
    public static final int CELL_MODE_PURE_BARS = 2;
    public int cell_mode;
    public boolean antiAliasing = false;
    public String driverdir = "";
    public String urlList = "";
    public String defaultapplications = "";
    public static final int LAYOUT_DOT = 0;
    public static final int LAYOUT_INTERNAL = 1;
    public String dot_location = "bin\\dot.exe";
    public String logdir = "";
    public int layout_mode = 1;
    public int node_width = 80;
    public int node_height = 40;
    public int grid_x = Integer.parseInt("40");
    public int grid_y = Integer.parseInt("40");
    public int font_size = -Integer.parseInt("-12");
    public int font_style = 0 + (Integer.parseInt("400") >= 700 && "0".equals("1") ? 3 : (Integer.parseInt("400") >= 700 ? 1 : ("0".equals("1") ? 2 : 0)));
    public String font_name = HuginGUIConstants.DEFAULT_HR_Font_Name;
    public boolean snap = "0".equals("1");
    public boolean show_grid = "0".equals("1");
    public boolean use_default_triangulation = "0".equals("0");
    public boolean use_optimization = false;
    public boolean saveToMemory = "0".equals("1");
    public boolean compress = "0".equals("1");
    public boolean approximate = "0".equals("1");
    public int triangulation_method = Integer.parseInt("0");
    public long max_number_of_separators = Long.parseLong("100000");
    public double epsilon = Double.parseDouble("0.00001");
    public boolean auto_propagate = "1".equals("1");
    public int propagation_method = 3 - (2 * Integer.parseInt("1") + Integer.parseInt("1"));
    public Vector<NodeGroup> defaultGroups;
    public Vector<NodeGroup> userGroups;
    public boolean open_graphs = "0".equals("1");
    public int use_SD = Integer.parseInt("2");
    public int graph_precision = Integer.parseInt("100");
    public int init_states = Integer.parseInt("5");
    public boolean monitor_chance_utility = Integer.parseInt("1") == 1;
    public int monitor_utility_arrange = Integer.parseInt("0");
    public boolean monitor_mean_variance = Integer.parseInt("1") == 1;
    public String description = "";
    public boolean auto_layout_when_expanding;
    public boolean check_consistency;
    public int precision = 2;
    public boolean displayInitialTableTip = true;

    public Preferences(HuginGUIFrame huginGUIFrame) {
        this.guiFrame = huginGUIFrame;
        this.recently_used = 4;
        this.autosave = 0;
        this.language = 0;
        this.latest_message = 0;
        this.beep_on_errors = true;
        this.display_errors = true;
        this.display_oobn_warnings = true;
        this.compilation_warning = 0;
        this.error_list_size = 5;
        this.level_of_concurrency = 1;
        this.grain_size = 10000;
        this.use_wallpaper = false;
        this.wallpaper_name = "icons/background.gif";
        this.default_browser = "";
        if (System.getProperty("mrj.version") != null) {
            this.default_browser = "/Applications/Safari.app/Contents/MacOS/Safari";
        }
        this.drag_mode = 1;
        this.check_update = true;
        this.barColors = new Vector();
        this.barColors.add(new Color(0, 255, 0));
        this.barColors.add(new Color(255, 0, 0));
        this.barColors.add(new Color(190, 190, 190));
        this.barColors.add(new Color(0, 0, 255));
        this.barColors.add(new Color(255, 0, 255));
        this.barColors.add(new Color(0, 128, 0));
        this.barColors.add(new Color(153, 255, 255));
        this.defaultGroups = new Vector();
        this.defaultGroups.add(new NodeGroup(HuginGUIConstants.get("NETWORK_PROPERTIES_discrete_node"), Integer.parseInt("16"), 0));
        this.defaultGroups.add(new NodeGroup(HuginGUIConstants.get("NETWORK_PROPERTIES_continuous_node"), Integer.parseInt("48"), 1));
        this.defaultGroups.add(new NodeGroup(HuginGUIConstants.get("NETWORK_PROPERTIES_utility_node"), Integer.parseInt("36"), 2));
        this.defaultGroups.add(new NodeGroup(HuginGUIConstants.get("NETWORK_PROPERTIES_decision_node"), Integer.parseInt("17"), 3));
        this.defaultGroups.add(new NodeGroup(HuginGUIConstants.get("NETWORK_PROPERTIES_interface_node"), Integer.parseInt("21"), 4));
        this.defaultGroups.add(new NodeGroup(HuginGUIConstants.get("NETWORK_PROPERTIES_instance_node"), Integer.parseInt("0"), 5));
        this.defaultGroups.add(new NodeGroup(HuginGUIConstants.get("NETWORK_PROPERTIES_function_node"), Integer.parseInt("4"), 6));
        this.userGroups = new Vector();
        this.auto_layout_when_expanding = true;
        this.check_consistency = true;
        this.show_belief_bar = true;
        this.table_mode = 1;
        this.node_table_connection_mode = 1;
    }

    public String toString() {
        String string = "";
        string = string + "[recently used]=\"" + this.recently_used + "\"\n";
        string = string + "[auto save]=\"" + this.autosave + "\"\n";
        string = string + "[language]=\"" + this.language + "\"\n";
        string = string + "[latest message]=\"" + this.latest_message + "\"\n";
        string = string + "[beep on errors]=\"" + this.beep_on_errors + "\"\n";
        string = string + "[display errors]=\"" + this.display_errors + "\"\n";
        string = string + "[display oobn warnings]=\"" + this.display_oobn_warnings + "\"\n";
        string = string + "[compilation warning]=\"" + this.compilation_warning + "\"\n";
        string = string + "[error list size]=\"" + this.error_list_size + "\"\n";
        string = string + "[level of concurrency]=\"" + this.level_of_concurrency + "\"\n";
        string = string + "[grain size]=\"" + this.grain_size + "\"\n";
        string = string + "[show belief bar]=\"" + this.show_belief_bar + "\"\n";
        string = string + "[belief precision]=\"" + this.precision + "\"\n";
        string = string + "[use wallpaper]=\"" + this.use_wallpaper + "\"\n";
        string = this.wallpaper_name.equals("icons/background.gif") ? string + "[wallpaper name]=\"default\"\n" : string + "[wallpaper name]=\"" + this.wallpaper_name + "\"\n";
        string = string + "[default browser]=\"" + this.default_browser + "\"\n";
        string = string + "[drag mode]=\"" + (this.drag_mode == 1 ? "outline" : "live") + "\"\n";
        string = string + "[check for updates]=\"" + (this.check_update ? "true" : "false") + "\"\n";
        Color color = this.barColors.get(0);
        string = string + "[belief bar color]=\"" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "\"\n";
        color = this.barColors.get(1);
        string = string + "[finding bar color]=\"" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "\"\n";
        color = this.barColors.get(2);
        string = string + "[inconsistent bar color]=\"" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "\"\n";
        color = this.barColors.get(3);
        string = string + "[likelihood bar color]=\"" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "\"\n";
        color = this.barColors.get(4);
        string = string + "[lock findings bar color]=\"" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "\"\n";
        color = this.barColors.get(5);
        string = string + "[utility bar color]=\"" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "\"\n";
        color = this.barColors.get(6);
        string = string + "[function bar color]=\"" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "\"\n";
        string = string + "\n";
        string = string + "[table mode]=\"" + (this.table_mode == 1 ? "tabbed" : "frames") + "\"\n";
        string = string + "[node table connection mode]=\"" + (this.node_table_connection_mode == 1 ? "loose" : "tight") + "\"\n";
        string = string + "[display initial table tip]=\"" + (this.displayInitialTableTip ? "yes" : "no") + "\"\n";
        string = string + "\n";
        string = string + "[graph layout mode]=\"" + (this.layout_mode == 1 ? "internal" : "dot") + "\"\n";
        string = string + "[dot executable]=\"" + this.dot_location + "\"\n";
        string = string + "\n";
        string = string + "[anti alias]=\"" + (this.antiAliasing ? "yes" : "no") + "\"\n";
        string = string + "\n";
        string = string + "[node width]=\"" + this.node_width + "\"\n";
        string = string + "[node height]=\"" + this.node_height + "\"\n";
        string = string + "[font size]=\"" + this.font_size + "\"\n";
        string = string + "[font style]=\"" + this.font_style + "\"\n";
        string = string + "[font name]=\"" + this.font_name + "\"\n";
        string = string + "[grid x]=\"" + this.grid_x + "\"\n";
        string = string + "[grid y]=\"" + this.grid_y + "\"\n";
        string = string + "[snap to grid]=\"" + this.snap + "\"\n";
        string = string + "[show grid]=\"" + this.show_grid + "\"\n";
        string = string + "\n";
        string = string + "[use default triangulation]=\"" + this.use_default_triangulation + "\"\n";
        string = string + "[triangulation method]=\"" + this.triangulation_method + "\"\n";
        string = string + "[max number of separators]=\"" + this.max_number_of_separators + "\"\n";
        string = string + "[use optimization]=\"" + this.use_optimization + "\"\n";
        string = string + "[save-to-memory]=\"" + this.saveToMemory + "\"\n";
        string = string + "[compress]=\"" + this.compress + "\"\n";
        string = string + "[approximate]=\"" + this.approximate + "\"\n";
        string = string + "[epsilon]=\"" + this.epsilon + "\"\n";
        string = string + "\n";
        string = string + "[auto propagate]=\"" + this.auto_propagate + "\"\n";
        string = string + "[propagation method]=\"" + this.propagation_method + "\"\n";
        string = string + "\n";
        string = string + "[display monitor states]=\"" + this.init_states + "\"\n";
        string = string + "[open graph display]=\"" + this.open_graphs + "\"\n";
        string = string + "[use standard deviation]=\"" + this.use_SD + "\"\n";
        string = string + "[graph precision]=\"" + this.graph_precision + "\"\n";
        string = string + "[display utility for chance nodes in monitors]=\"" + this.monitor_chance_utility + "\"\n";
        string = string + "[display mean and variance for numeric nodes in monitors]=\"" + this.monitor_mean_variance + "\"\n";
        string = string + "[arrangement of beliefbars in monitors]=\"" + this.monitor_utility_arrange + "\"\n";
        string = string + "\n";
        NodeGroup nodeGroup = this.defaultGroups.get(0);
        string = string + "[discrete chance node group]=\"" + nodeGroup.getColorIndex() + "\"\n";
        nodeGroup = this.defaultGroups.get(1);
        string = string + "[continuous chance node group]=\"" + nodeGroup.getColorIndex() + "\"\n";
        nodeGroup = this.defaultGroups.get(2);
        string = string + "[utility node group]=\"" + nodeGroup.getColorIndex() + "\"\n";
        nodeGroup = this.defaultGroups.get(3);
        string = string + "[decision node group]=\"" + nodeGroup.getColorIndex() + "\"\n";
        nodeGroup = this.defaultGroups.get(4);
        string = string + "[interface node group]=\"" + nodeGroup.getColorIndex() + "\"\n";
        nodeGroup = this.defaultGroups.get(5);
        string = string + "[instance node group]=\"" + nodeGroup.getColorIndex() + "\"\n";
        for (NodeGroup nodeGroup2 : this.userGroups) {
            string = string + "[user group]=\"" + nodeGroup2.getName() + "," + nodeGroup2.getColorIndex() + "\"\n";
        }
        string = string + "\n";
        string = string + "[description]=\"" + this.description + "\"\n";
        string = string + "\n";
        string = string + "[OOBN auto layout]=\"" + this.auto_layout_when_expanding + "\"\n";
        string = string + "[OOBN check consistency]=\"" + this.check_consistency + "\"\n";
        string = this.logdir.equals(this.guiFrame.getUserHome() + "logs") ? string + "[log dir]=\"\"\n" : string + "[log dir]=\"" + this.logdir + "\"\n";
        string = string + "[default applications]=\"" + this.defaultapplications + "\"\n";
        string = string + "[driver dir]=\"" + this.driverdir + "\"\n";
        string = string + "[url list]=\"" + this.urlList + "\"\n";
        string = string + "\n";
        return string;
    }

    void toDomainAttributes() {
        DomainAttributes.basicNodeWidth = this.node_width;
        DomainAttributes.basicNodeHeight = this.node_height;
        DomainAttributes.set("HR_Grid_X", "" + this.grid_x);
        DomainAttributes.set("HR_Grid_Y", "" + this.grid_y);
        DomainAttributes.set("HR_Grid_GridSnap", this.snap ? "1" : "0");
        DomainAttributes.set("HR_Grid_GridShow", this.show_grid ? "1" : "0");
        DomainAttributes.set("HR_Font_Name", this.font_name);
        DomainAttributes.set("HR_Font_Size", "-" + this.font_size);
        DomainAttributes.set("HR_Font_Weight", this.font_style == 1 || this.font_style == 3 ? "700" : "400");
        DomainAttributes.set("HR_Font_Italic", this.font_style == 2 || this.font_style == 3 ? "1" : "0");
        DomainAttributes.set("HR_Propagate_Auto", this.auto_propagate ? "1" : "0");
        DomainAttributes.set("HR_Propagate_AutoSum", this.propagation_method == 0 || this.propagation_method == 1 ? "1" : "0");
        DomainAttributes.set("HR_Propagate_AutoNormal", this.propagation_method == 0 || this.propagation_method == 2 ? "1" : "0");
        if (!(this.use_default_triangulation || this.triangulation_method >= 0 && this.triangulation_method <= 6)) {
            this.triangulation_method = 4;
        }
        DomainAttributes.set("HR_Compile_TriangMethod", this.use_default_triangulation ? "0" : "" + this.triangulation_method);
        DomainAttributes.set("HR_Compile_MaxMinimalSeparators", "" + this.max_number_of_separators);
        DomainAttributes.set("HR_Compile_Compress", this.compress ? "1" : "0");
        DomainAttributes.set("HR_Compile_SaveToMemory", this.saveToMemory ? "1" : "0");
        DomainAttributes.set("HR_Compile_Approximate", this.approximate ? "1" : "0");
        DomainAttributes.set("HR_Compile_ApproxEpsilon", "" + this.epsilon);
        DomainAttributes.set("HR_Monitor_GraphPrecision", "" + this.graph_precision);
        DomainAttributes.set("HR_Monitor_OpenGraph", this.open_graphs ? "1" : "0");
        DomainAttributes.set("HR_Monitor_InitSD", "" + this.use_SD);
        DomainAttributes.set("HR_Monitor_InitStates", "" + this.init_states);
        DomainAttributes.set("HR_Monitor_Chance_Utility", "" + (this.monitor_chance_utility ? 1 : 0));
        DomainAttributes.set("HR_Monitor_Mean_Variance", "" + (this.monitor_mean_variance ? 1 : 0));
        DomainAttributes.set("HR_Monitor_Utility_Arrange", "" + this.monitor_utility_arrange);
        DomainAttributes.set("HR_Color_DiscreteChance", "" + this.defaultGroups.get(0).getColorIndex());
        DomainAttributes.set("HR_Color_ContinuousChance", "" + this.defaultGroups.get(1).getColorIndex());
        DomainAttributes.set("HR_Color_Utility", "" + this.defaultGroups.get(2).getColorIndex());
        DomainAttributes.set("HR_Color_Decision", "" + this.defaultGroups.get(3).getColorIndex());
        DomainAttributes.set("HR_Color_Interface", "" + this.defaultGroups.get(4).getColorIndex());
        DomainAttributes.set("HR_Color_Instance", "" + this.defaultGroups.get(5).getColorIndex());
        DomainAttributes.set("HR_Color_Function", "" + this.defaultGroups.get(6).getColorIndex());
        DomainAttributes.set("HR_Groups_UserGroupsNo", "" + this.userGroups.size());
        String string = "";
        String string2 = "";
        String string3 = "";
        if (this.userGroups.size() > 0) {
            string = string + this.userGroups.get(0).getName();
            string3 = "" + this.userGroups.get(0).getColorIndex();
            if (string3.length() == 1) {
                string3 = "0" + string3;
            }
            string2 = string2 + string3;
        }
        for (int i = 1; i < this.userGroups.size(); ++i) {
            string = string + "\t" + this.userGroups.get(i).getName();
            string3 = "" + this.userGroups.get(i).getColorIndex();
            if (string3.length() == 1) {
                string3 = "0" + string3;
            }
            string2 = string2 + string3;
        }
        DomainAttributes.set("HR_Groups_GroupNames", string);
        DomainAttributes.set("HR_Groups_GroupColors", string2);
        DomainAttributes.set("HR_OOBN_FitExpand", this.auto_layout_when_expanding ? "1" : "0");
        DomainAttributes.set("HR_OOBN_CheckConsistency", this.check_consistency ? "1" : "0");
        DomainAttributes.set("HR_Desc", this.description);
    }

    void fromDomainAttributes() {
        this.node_width = DomainAttributes.basicNodeWidth;
        this.node_height = DomainAttributes.basicNodeHeight;
        this.grid_x = Integer.parseInt(DomainAttributes.get("HR_Grid_X"));
        this.grid_y = Integer.parseInt(DomainAttributes.get("HR_Grid_Y"));
        this.snap = DomainAttributes.get("HR_Grid_GridSnap").equals("1");
        this.show_grid = DomainAttributes.get("HR_Grid_GridShow").equals("1");
        this.font_name = DomainAttributes.get("HR_Font_Name");
        this.font_size = -Integer.parseInt(DomainAttributes.get("HR_Font_Size"));
        this.font_style = 0;
        if (Integer.parseInt(DomainAttributes.get("HR_Font_Weight")) >= 700) {
            ++this.font_style;
        }
        this.font_style += DomainAttributes.get("HR_Font_Italic").equals("1") ? 2 : 0;
        this.auto_propagate = DomainAttributes.get("HR_Propagate_Auto").equals("1");
        this.propagation_method = 3 - (2 * Integer.parseInt(DomainAttributes.get("HR_Propagate_AutoSum")) + Integer.parseInt(DomainAttributes.get("HR_Propagate_AutoNormal")));
        this.use_default_triangulation = !DomainAttributes.get("HR_Compile_TriangMethod").equals("0");
        this.triangulation_method = Integer.parseInt(DomainAttributes.get("HR_Compile_TriangMethod"));
        this.max_number_of_separators = Long.parseLong(DomainAttributes.get("HR_Compile_MaxMinimalSeparators"));
        this.compress = DomainAttributes.get("HR_Compile_Compress").equals("1");
        this.saveToMemory = DomainAttributes.get("HR_Compile_SaveToMemory").equals("1");
        this.use_optimization = this.compress;
        this.approximate = DomainAttributes.get("HR_Compile_Approximate").equals("1");
        this.epsilon = Double.parseDouble(DomainAttributes.get("HR_Compile_ApproxEpsilon"));
        this.graph_precision = Integer.parseInt(DomainAttributes.get("HR_Monitor_GraphPrecision"));
        this.open_graphs = DomainAttributes.get("HR_Monitor_OpenGraph").equals("1");
        this.use_SD = Integer.parseInt(DomainAttributes.get("HR_Monitor_InitSD"));
        this.init_states = Integer.parseInt(DomainAttributes.get("HR_Monitor_InitStates"));
        this.monitor_chance_utility = Integer.parseInt(DomainAttributes.get("HR_Monitor_Chance_Utility")) == 1;
        this.monitor_mean_variance = Integer.parseInt(DomainAttributes.get("HR_Monitor_Mean_Variance")) == 1;
        this.monitor_utility_arrange = Integer.parseInt(DomainAttributes.get("HR_Monitor_Utility_Arrange"));
        this.defaultGroups.get(0).setColorIndex(Integer.parseInt(DomainAttributes.get("HR_Color_DiscreteChance")));
        this.defaultGroups.get(1).setColorIndex(Integer.parseInt(DomainAttributes.get("HR_Color_ContinuousChance")));
        this.defaultGroups.get(2).setColorIndex(Integer.parseInt(DomainAttributes.get("HR_Color_Utility")));
        this.defaultGroups.get(3).setColorIndex(Integer.parseInt(DomainAttributes.get("HR_Color_Decision")));
        this.defaultGroups.get(4).setColorIndex(Integer.parseInt(DomainAttributes.get("HR_Color_Interface")));
        this.defaultGroups.get(5).setColorIndex(Integer.parseInt(DomainAttributes.get("HR_Color_Instance")));
        this.defaultGroups.get(6).setColorIndex(Integer.parseInt(DomainAttributes.get("HR_Color_Function")));
        this.userGroups = new Vector();
        int n = Integer.parseInt(DomainAttributes.get("HR_Groups_UserGroupsNo"));
        if (n > 0) {
            String string = DomainAttributes.get("HR_Groups_GroupNames");
            String string2 = DomainAttributes.get("HR_Groups_GroupColors");
            int n2 = string.indexOf("\t");
            int n3 = 0;
            for (int i = 0; i < n - 1 && n2 >= 0; ++i) {
                this.userGroups.add(new NodeGroup(string.substring(n3, n2), Integer.parseInt(string2.substring(i * 2, i * 2 + 2))));
                n3 = n2 + 1;
                n2 = string.indexOf("\t", n3);
            }
            this.userGroups.add(new NodeGroup(string.substring(n3), Integer.parseInt(string2.substring((n - 1) * 2, (n - 1) * 2 + 2))));
        }
        this.auto_layout_when_expanding = DomainAttributes.get("HR_OOBN_FitExpand").equals("1");
        this.check_consistency = DomainAttributes.get("HR_OOBN_CheckConsistency").equals("1");
        this.description = DomainAttributes.get("HR_Desc");
    }

    void fromDomain(Domain domain) {
        try {
            this.node_width = (int)domain.getNodeSize().getX();
            this.node_height = (int)domain.getNodeSize().getY();
            this.grid_x = Integer.parseInt(domain.getAttribute("HR_Grid_X"));
            this.grid_y = Integer.parseInt(domain.getAttribute("HR_Grid_Y"));
            this.snap = domain.getAttribute("HR_Grid_GridSnap").equals("1");
            this.show_grid = domain.getAttribute("HR_Grid_GridShow").equals("1");
            this.font_name = domain.getAttribute("HR_Font_Name");
            this.font_size = -Integer.parseInt(domain.getAttribute("HR_Font_Size"));
            this.font_style = 0;
            if (Integer.parseInt(domain.getAttribute("HR_Font_Weight")) >= 700) {
                ++this.font_style;
            }
            this.font_style += domain.getAttribute("HR_Font_Italic").equals("1") ? 2 : 0;
            this.auto_propagate = domain.getAttribute("HR_Propagate_Auto").equals("1");
            this.propagation_method = 3 - (2 * Integer.parseInt(domain.getAttribute("HR_Propagate_AutoSum")) + Integer.parseInt(domain.getAttribute("HR_Propagate_AutoNormal")));
            this.use_default_triangulation = domain.getAttribute("HR_Compile_TriangMethod").equals("1");
            this.triangulation_method = Integer.parseInt(domain.getAttribute("HR_Compile_TriangMethod"));
            this.max_number_of_separators = Long.parseLong(domain.getAttribute("HR_Compile_MaxMinimalSeparators"));
            this.compress = domain.getAttribute("HR_Compile_Compress").equals("1");
            this.saveToMemory = domain.getAttribute("HR_Compile_SaveToMemory").equals("1");
            this.approximate = domain.getAttribute("HR_Compile_Approximate").equals("1");
            this.epsilon = Double.parseDouble(domain.getAttribute("HR_Compile_ApproxEpsilon"));
            this.graph_precision = Integer.parseInt(domain.getAttribute("HR_Monitor_GraphPrecision"));
            this.open_graphs = domain.getAttribute("HR_Monitor_OpenGraph").equals("1");
            this.use_SD = Integer.parseInt(domain.getAttribute("HR_Monitor_InitSD"));
            this.init_states = Integer.parseInt(domain.getAttribute("HR_Monitor_InitStates"));
            this.monitor_chance_utility = Integer.parseInt(domain.getAttribute("HR_Monitor_Chance_Utility")) == 1;
            this.monitor_mean_variance = Integer.parseInt(domain.getAttribute("HR_Monitor_Mean_Variance")) == 1;
            this.monitor_utility_arrange = Integer.parseInt(domain.getAttribute("HR_Monitor_Utility_Arrange"));
            this.defaultGroups.get(0).setColorIndex(Integer.parseInt(domain.getAttribute("HR_Color_DiscreteChance")));
            this.defaultGroups.get(1).setColorIndex(Integer.parseInt(domain.getAttribute("HR_Color_ContinuousChance")));
            this.defaultGroups.get(2).setColorIndex(Integer.parseInt(domain.getAttribute("HR_Color_Decision")));
            this.defaultGroups.get(3).setColorIndex(Integer.parseInt(domain.getAttribute("HR_Color_Utility")));
            this.defaultGroups.get(4).setColorIndex(Integer.parseInt(domain.getAttribute("HR_Color_Interface")));
            this.defaultGroups.get(5).setColorIndex(Integer.parseInt(domain.getAttribute("HR_Color_Instance")));
            this.defaultGroups.get(6).setColorIndex(Integer.parseInt(domain.getAttribute("HR_Color_Function")));
            this.userGroups = new Vector();
            int n = Integer.parseInt(domain.getAttribute("HR_Groups_UserGroupsNo"));
            if (n > 0) {
                String string = domain.getAttribute("HR_Groups_GroupNames");
                String string2 = domain.getAttribute("HR_Groups_GroupColors");
                int n2 = string.indexOf("\t");
                int n3 = 0;
                for (int i = 0; i < n - 1; ++i) {
                    this.userGroups.add(new NodeGroup(string.substring(n3, n2), Integer.parseInt(string2.substring(i * 2, i * 2 + 2))));
                    n3 = n2 + 1;
                    n2 = string.indexOf("\t");
                }
                this.userGroups.add(new NodeGroup(string.substring(n3), Integer.parseInt(string2.substring((n - 1) * 2, (n - 1) * 2 + 2))));
            }
            this.description = domain.getAttribute("HR_Desc");
            this.auto_layout_when_expanding = domain.getAttribute("HR_OOBN_FitExpand").equals("1");
            this.check_consistency = domain.getAttribute("HR_OOBN_CheckConsistency").equals("1");
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }
}

