/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HGUI.AutoSaveDaemon;
import COM.hugin.HGUI.CounterField;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginFileLoader;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.NumberOutOfRangeException;
import COM.hugin.HGUI.PastingTextField;
import COM.hugin.HGUI.Preferences;
import COM.hugin.HGUI.SizedButton;
import COM.hugin.HGUI.TitledPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class PreferencesPane
extends JDialog {
    JTabbedPane pane;
    HuginGUIFrame frame;
    Box general;
    Box beliefBar;
    JPanel displayPane;
    PreferencesPane self = this;
    Preferences prefs;
    JPanel buttons;
    JButton ok;
    JButton cancel;
    JButton apply;
    JButton help;
    JComboBox language;
    CounterField recentlyUsed;
    CounterField autosave;
    CounterField mouseSensitivity;
    CounterField compilationWarning;
    CounterField grainSize;
    CounterField levelOfConcurrency;
    CounterField errorListSize;
    JCheckBox beepOnErrors;
    JCheckBox displayError;
    JCheckBox displayOOBNWarnings;
    JCheckBox useWallpaper;
    JCheckBox soundsEnabled;
    JCheckBox shadowsEnabled;
    JCheckBox showBeliefBar;
    PastingTextField chosenFileName;
    File chosenFile;
    File driverFile;
    JLabel wallpaper;
    JButton chooseFile;
    JButton chooseLogDir;
    PastingTextField defaultBrowserFile;
    PastingTextField logFileDir;
    PastingTextField driverField;
    File chosenLogFileDir = null;
    JLabel logFileLabel;
    JLabel driverLabel;
    JLabel defaultBrowser;
    JButton chooseBrowser;
    JButton driverButton;
    JCheckBox liveDrag;
    JCheckBox checkUpdates;
    SizedButton beliefBarButton;
    SizedButton findingBarButton;
    SizedButton inconsistentBarButton;
    SizedButton likelihoodBarButton;
    SizedButton lockFindingBarButton;
    SizedButton utilityFindingBarButton;
    SizedButton functionBarButton;
    SizedButton defaultButton;
    BeliefBarPainting painting;
    JCheckBox useAntiAliasing;
    Vector<Color> oldColors;
    boolean showBeliefBarChanged;
    private JRadioButton tableModeTabs;
    private JRadioButton tableModeFrames;
    private JRadioButton tableConnectionLoose;
    private JRadioButton tableConnectionTight;
    private JRadioButton layoutModeInternal;
    private JRadioButton layoutModeDot;
    private JTextField dotLocation;
    private JButton browseDot;
    private JLabel dotLocationLabel;

    public PreferencesPane(Preferences preferences, HuginGUIFrame huginGUIFrame) {
        super(Hugin.mainFrame, HuginGUIConstants.get("PREFERENCES"), true);
        this.setResizable(false);
        this.prefs = preferences;
        this.frame = huginGUIFrame;
        this.oldColors = new Vector<Color>(preferences.barColors);
        this.pane = new JTabbedPane();
        this.general = new Box(1);
        this.beliefBar = new Box(1);
        this.drawGeneralPane();
        this.drawBeliefBarPane();
        this.displayPane = this.drawDisplayPane();
        this.pane.add((Component)this.general, HuginGUIConstants.get("PREFERENCES_general_options"));
        this.pane.add((Component)this.displayPane, HuginGUIConstants.get("PREFERENCES_display_options"));
        this.pane.add((Component)this.beliefBar, HuginGUIConstants.get("PREFERENCES_belief_bar_colors"));
        this.buttons = new JPanel();
        this.ok = new JButton(HuginGUIConstants.get("OK_button"));
        this.ok.addActionListener(new ApplyOKListener());
        this.cancel = new JButton(HuginGUIConstants.get("cancel_button"));
        this.cancel.addActionListener(new CancelListener());
        this.help = new JButton(HuginGUIConstants.get("help_button"));
        this.help.addActionListener(new HelpListener());
        this.buttons.add(this.ok);
        this.buttons.add(this.cancel);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.pane, "Center");
        container.add((Component)this.buttons, "South");
        if (System.getProperty("os.name").equals("Linux")) {
            this.setSize((int)this.getPreferredSize().getWidth() + 10, (int)this.getPreferredSize().getHeight() + 30);
        }
        this.getRootPane().setDefaultButton(this.ok);
        this.showBeliefBarChanged = false;
    }

    private void drawGeneralPane() {
        JPanel jPanel = new JPanel(new GridLayout(14, 1));
        JPanel jPanel2 = new JPanel(new GridLayout(14, 1));
        JPanel jPanel3 = new JPanel(new GridLayout(14, 1));
        TitledPanel titledPanel = new TitledPanel(HuginGUIConstants.get("PREFERENCES_general_options"));
        String[] stringArray = new String[]{HuginGUIConstants.get("PREFERENCES_language_english"), HuginGUIConstants.get("PREFERENCES_language_japanese")};
        this.language = new JComboBox<String>(stringArray);
        this.language.setSelectedIndex(this.prefs.language);
        jPanel.add(new JLabel(HuginGUIConstants.get("PREFERENCES_language")));
        jPanel2.add(this.language);
        jPanel3.add(new JLabel(""));
        this.recentlyUsed = new CounterField(HuginGUIConstants.get("str_file_number"), 0, 9, this.prefs.recently_used);
        jPanel.add(new JLabel(HuginGUIConstants.get("PREFERENCES_recently_used")));
        jPanel2.add(this.recentlyUsed);
        jPanel3.add(new JLabel(HuginGUIConstants.get("PREFERENCES_file_menu_entries")));
        this.autosave = new CounterField(HuginGUIConstants.get("str_autosave_interval"), 0, 60, this.prefs.autosave);
        JLabel jLabel = new JLabel(HuginGUIConstants.get("PREFERENCES_autosave_every"));
        JLabel jLabel2 = new JLabel(HuginGUIConstants.get("PREFERENCES_autosave_minutes"));
        jPanel.add(jLabel);
        jPanel2.add(this.autosave);
        jPanel3.add(jLabel2);
        boolean bl = this.frame.getUserHome() != null && this.frame.getUserHome().length() > 0;
        jLabel.setEnabled(bl);
        this.autosave.setEnabled(bl);
        jLabel2.setEnabled(bl);
        this.beepOnErrors = new JCheckBox();
        this.beepOnErrors.setSelected(this.prefs.beep_on_errors);
        jPanel.add(new JLabel(HuginGUIConstants.get("PREFERENCES_when_errors_occur")));
        jPanel2.add(this.beepOnErrors);
        jPanel3.add(new JLabel(HuginGUIConstants.get("PREFERENCES_beep")));
        this.displayError = new JCheckBox();
        this.displayError.setSelected(this.prefs.display_errors);
        jPanel.add(new JLabel(""));
        jPanel2.add(this.displayError);
        jPanel3.add(new JLabel(HuginGUIConstants.get("PREFERENCES_display_error")));
        this.errorListSize = new CounterField(HuginGUIConstants.get("str_size_of_error_list"), 0, 30, this.prefs.error_list_size, 2);
        jPanel.add(new JLabel(HuginGUIConstants.get("PREFERENCES_errors_in_errorlist")));
        jPanel2.add(this.errorListSize);
        jPanel3.add(new JLabel(""));
        this.displayOOBNWarnings = new JCheckBox();
        this.displayOOBNWarnings.setSelected(this.prefs.display_oobn_warnings);
        jPanel.add(new JLabel(HuginGUIConstants.get("PREFERENCES_display_oobn_warnings")));
        jPanel2.add(this.displayOOBNWarnings);
        jPanel3.add(new JLabel(""));
        this.compilationWarning = new CounterField(HuginGUIConstants.get("str_limit_on_jt_size"), 0, 100000, this.prefs.compilation_warning, 6);
        jPanel.add(new JLabel(HuginGUIConstants.get("PREFERENCES_compilation_warning")));
        jPanel2.add(this.compilationWarning);
        jPanel3.add(new JLabel(HuginGUIConstants.get("str__zero_to_disable_")));
        this.levelOfConcurrency = new CounterField(HuginGUIConstants.get("PREFERENCES_level_of_concurrency"), 1, 10000000, this.prefs.level_of_concurrency, 6);
        jPanel.add(new JLabel(HuginGUIConstants.get("PREFERENCES_level_of_concurrency")));
        jPanel2.add(this.levelOfConcurrency);
        jPanel3.add(new JLabel(HuginGUIConstants.get("str__one_to_disable_")));
        this.grainSize = new CounterField(HuginGUIConstants.get("PREFERENCES_grain_size"), 1, 1000000000, this.prefs.grain_size, 6);
        this.grainSize.setFieldMaximumSize(70);
        jPanel.add(new JLabel(HuginGUIConstants.get("PREFERENCES_grain_size")));
        jPanel2.add(this.grainSize);
        jPanel3.add(new JLabel(""));
        jPanel.add(new JLabel(HuginGUIConstants.get("PREFERENCES_show_belief_bar")));
        this.showBeliefBar = new JCheckBox();
        this.showBeliefBar.setSelected(this.prefs.show_belief_bar);
        this.showBeliefBar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesPane.this.showBeliefBarChanged = !PreferencesPane.this.showBeliefBarChanged;
            }
        });
        jPanel2.add(this.showBeliefBar);
        jPanel3.add(new JLabel(""));
        this.liveDrag = new JCheckBox();
        this.liveDrag.setSelected(this.prefs.drag_mode == 0);
        jPanel.add(new JLabel(HuginGUIConstants.get("PREFERENCES_live_drag")));
        jPanel2.add(this.liveDrag);
        jPanel3.add(new JLabel(""));
        this.checkUpdates = new JCheckBox();
        this.checkUpdates.setSelected(this.prefs.check_update);
        jPanel.add(new JLabel(HuginGUIConstants.get("PREFERENCES_check_updates")));
        jPanel2.add(this.checkUpdates);
        jPanel3.add(new JLabel(""));
        this.useWallpaper = new JCheckBox();
        this.useWallpaper.setSelected(this.prefs.use_wallpaper);
        this.useWallpaper.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesPane.this.chosenFileName.setEnabled(PreferencesPane.this.useWallpaper.isSelected());
                PreferencesPane.this.chooseFile.setEnabled(PreferencesPane.this.useWallpaper.isSelected());
                PreferencesPane.this.wallpaper.setEnabled(PreferencesPane.this.useWallpaper.isSelected());
            }
        });
        jPanel.add(new JLabel(HuginGUIConstants.get("PREFERENCES_use_wallpaper")));
        jPanel2.add(this.useWallpaper);
        jPanel3.add(new JLabel(""));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(jPanel);
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        JPanel jPanel5 = new JPanel(new BorderLayout(5, 5));
        JPanel jPanel6 = new JPanel(new GridLayout(4, 1));
        JPanel jPanel7 = new JPanel(new GridLayout(4, 1));
        JPanel jPanel8 = new JPanel(new GridLayout(4, 1));
        this.chosenFileName = new PastingTextField();
        this.chosenFile = null;
        if (this.prefs.wallpaper_name.equals("icons/background.gif")) {
            this.chosenFileName.setText(HuginGUIConstants.get("str_default"));
        } else {
            this.chosenFile = new File(this.prefs.wallpaper_name);
            this.chosenFileName.setText(this.chosenFile.getName());
            this.useWallpaper.setSelected(this.prefs.use_wallpaper && this.chosenFile.exists());
        }
        this.chooseFile = new JButton(HuginGUIConstants.get("PREFERENCES_choose"));
        this.chooseFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HuginFileLoader huginFileLoader = new HuginFileLoader(7, PreferencesPane.this.chosenFile, 0);
                int n = huginFileLoader.showDialog(PreferencesPane.this);
                if (n == 0) {
                    PreferencesPane.this.chosenFile = huginFileLoader.getSelectedFile();
                    PreferencesPane.this.chosenFileName.setText(PreferencesPane.this.chosenFile.getName());
                }
            }
        });
        this.wallpaper = new JLabel(HuginGUIConstants.get("PREFERENCES_wallpaper"));
        this.chosenFileName.setEnabled(this.useWallpaper.isSelected());
        this.chooseFile.setEnabled(this.useWallpaper.isSelected());
        this.wallpaper.setEnabled(this.useWallpaper.isSelected());
        jPanel6.add(this.wallpaper);
        jPanel7.add(this.chosenFileName);
        jPanel8.add(this.chooseFile);
        String string = this.frame.getUserHome() + "logs";
        if (this.prefs.logdir.length() != 0) {
            string = this.prefs.logdir;
        }
        this.chosenLogFileDir = new File(string);
        this.chooseLogDir = new JButton(HuginGUIConstants.get("PREFERENCES_choose"));
        this.chooseLogDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HuginFileLoader huginFileLoader = new HuginFileLoader(101, PreferencesPane.this.chosenLogFileDir, 0);
                int n = huginFileLoader.showDialog(PreferencesPane.this);
                if (n == 0) {
                    PreferencesPane.this.chosenLogFileDir = !huginFileLoader.getSelectedFile().isDirectory() ? huginFileLoader.getSelectedFile().getParentFile() : huginFileLoader.getSelectedFile();
                    if (PreferencesPane.this.chosenLogFileDir != null) {
                        PreferencesPane.this.logFileDir.setText(PreferencesPane.this.chosenLogFileDir.getPath());
                    }
                }
            }
        });
        this.logFileDir = new PastingTextField(string);
        this.logFileLabel = new JLabel(HuginGUIConstants.get("PREFERENCES_log_file_dir"));
        jPanel6.add(this.logFileLabel);
        jPanel7.add(this.logFileDir);
        jPanel8.add(this.chooseLogDir);
        String string2 = "";
        if (this.prefs.driverdir.length() != 0) {
            string2 = this.prefs.driverdir;
        }
        this.driverFile = new File(string2);
        this.driverButton = new JButton(HuginGUIConstants.get("PREFERENCES_choose"));
        this.driverButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HuginFileLoader huginFileLoader = new HuginFileLoader(15, PreferencesPane.this.driverFile, 0);
                int n = huginFileLoader.showDialog(PreferencesPane.this);
                if (n == 0) {
                    PreferencesPane.this.driverFile = huginFileLoader.getSelectedFile();
                    if (PreferencesPane.this.driverFile != null) {
                        PreferencesPane.this.driverField.setText(PreferencesPane.this.driverFile.getPath());
                    }
                }
            }
        });
        this.driverField = new PastingTextField(string2);
        this.driverLabel = new JLabel(HuginGUIConstants.get("PREFERENCES_driver_dir"));
        jPanel6.add(this.driverLabel);
        jPanel7.add(this.driverField);
        jPanel8.add(this.driverButton);
        this.defaultBrowser = new JLabel(HuginGUIConstants.get("PREFERENCES_browser"));
        this.defaultBrowserFile = new PastingTextField(this.prefs.default_browser);
        this.chooseBrowser = new JButton(HuginGUIConstants.get("PREFERENCES_choose_browser"));
        this.chooseBrowser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HuginFileLoader huginFileLoader = new HuginFileLoader(11, PreferencesPane.this.chosenFile, 0);
                int n = huginFileLoader.showDialog(PreferencesPane.this);
                if (n == 0) {
                    try {
                        PreferencesPane.this.defaultBrowserFile.setText(huginFileLoader.getSelectedFile().getCanonicalPath());
                    }
                    catch (Exception exception) {
                        new HuginGUIError(HuginGUIConstants.get("str_the_chosen_file_is_not_valid"));
                    }
                }
            }
        });
        jPanel6.add(this.defaultBrowser);
        jPanel7.add(this.defaultBrowserFile);
        jPanel8.add(this.chooseBrowser);
        jPanel5.add((Component)jPanel6, "West");
        jPanel5.add((Component)jPanel7, "Center");
        jPanel5.add((Component)jPanel8, "East");
        JPanel jPanel9 = new JPanel(new BorderLayout());
        jPanel9.add((Component)jPanel5, "North");
        titledPanel.setLayout(new BorderLayout());
        titledPanel.add((Component)jPanel4, "North");
        titledPanel.add((Component)jPanel9, "Center");
        JPanel jPanel10 = new JPanel(new BorderLayout());
        jPanel10.add((Component)titledPanel, "North");
        Box box = new Box(0){

            public float getAlignmentX() {
                return 0.0f;
            }
        };
        JLabel jLabel3 = new JLabel(new ImageIcon(ClassLoader.getSystemResource("icons/nodeicon.gif")));
        jLabel3.setAlignmentY(0.0f);
        jPanel10.setAlignmentY(0.0f);
        box.add(jLabel3);
        box.add(Box.createRigidArea(new Dimension(10, 10)));
        box.add(jPanel10);
        this.general.add(box);
    }

    private JPanel drawDisplayPane() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        TitledPanel titledPanel = new TitledPanel(HuginGUIConstants.get("PREFERENCES_tables"));
        titledPanel.setLayout(new GridLayout(2, 1));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1));
        JPanel jPanel4 = new JPanel(new GridLayout(2, 1));
        this.tableModeTabs = new JRadioButton(HuginGUIConstants.get("PREFERENCES_table_mode_tabbed"));
        this.tableModeTabs.setSelected(this.prefs.table_mode == 1);
        this.tableModeFrames = new JRadioButton(HuginGUIConstants.get("PREFERENCES_table_mode_framed"));
        this.tableModeFrames.setSelected(this.prefs.table_mode == 0);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.tableModeTabs);
        buttonGroup.add(this.tableModeFrames);
        jPanel3.add(new JLabel(HuginGUIConstants.get("PREFERENCES_table_mode")));
        jPanel4.add(this.tableModeTabs);
        jPanel4.add(this.tableModeFrames);
        jPanel2.add((Component)jPanel3, "West");
        jPanel2.add(jPanel4);
        titledPanel.add(jPanel2);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        JPanel jPanel6 = new JPanel(new GridLayout(2, 1));
        JPanel jPanel7 = new JPanel(new GridLayout(2, 1));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        jPanel6.add(new JLabel(HuginGUIConstants.get("PREFERENCES_table_activator")));
        this.tableConnectionTight = new JRadioButton(HuginGUIConstants.get("PREFERENCES_table_activator_selection"));
        this.tableConnectionLoose = new JRadioButton(HuginGUIConstants.get("PREFERENCES_table_activator_ctrl_click"));
        buttonGroup2.add(this.tableConnectionLoose);
        buttonGroup2.add(this.tableConnectionTight);
        this.tableConnectionLoose.setSelected(Hugin.mainFrame.preferences.node_table_connection_mode == 1);
        this.tableConnectionTight.setSelected(!this.tableConnectionLoose.isSelected());
        jPanel7.add(this.tableConnectionLoose);
        jPanel7.add(this.tableConnectionTight);
        jPanel5.add(jPanel7);
        jPanel5.add((Component)jPanel6, "West");
        titledPanel.add(jPanel5);
        TitledPanel titledPanel2 = new TitledPanel(HuginGUIConstants.get("PREFERENCES_graph_layout"));
        this.layoutModeInternal = new JRadioButton(HuginGUIConstants.get("PREFERENCES_layout_mode_internal"));
        this.layoutModeInternal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesPane.this.enableDotLocation();
            }
        });
        this.layoutModeDot = new JRadioButton(HuginGUIConstants.get("PREFERENCES_layout_mode_dot"));
        this.layoutModeDot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesPane.this.enableDotLocation();
            }
        });
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add(this.layoutModeInternal);
        buttonGroup3.add(this.layoutModeDot);
        this.layoutModeInternal.setSelected(Hugin.mainFrame.preferences.layout_mode == 1);
        this.layoutModeDot.setSelected(Hugin.mainFrame.preferences.layout_mode == 0);
        this.dotLocation = new JTextField(Hugin.mainFrame.preferences.dot_location);
        this.browseDot = new JButton(HuginGUIConstants.get("PREFERENCES_browse"));
        this.browseDot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HuginFileLoader huginFileLoader = new HuginFileLoader(11, new File(PreferencesPane.this.dotLocation.getText()), 0);
                int n = huginFileLoader.showDialog(PreferencesPane.this);
                if (n == 0) {
                    try {
                        PreferencesPane.this.dotLocation.setText(huginFileLoader.getSelectedFile().getCanonicalPath());
                    }
                    catch (Exception exception) {
                        new HuginGUIError(HuginGUIConstants.get("str_the_chosen_file_is_not_valid"));
                    }
                }
            }
        });
        titledPanel2.setLayout(new GridLayout(3, 1));
        titledPanel2.add(this.layoutModeInternal);
        titledPanel2.add(this.layoutModeDot);
        JPanel jPanel8 = new JPanel(new BorderLayout());
        this.dotLocationLabel = new JLabel(HuginGUIConstants.get("PREFERENCES_location_of_dot"));
        jPanel8.add((Component)this.dotLocationLabel, "West");
        jPanel8.add(this.dotLocation);
        jPanel8.add((Component)this.browseDot, "East");
        titledPanel2.add(jPanel8);
        this.enableDotLocation();
        JLabel jLabel = new JLabel(new ImageIcon(ClassLoader.getSystemResource("icons/display.gif")));
        JPanel jPanel9 = new JPanel(new BorderLayout());
        jPanel9.add((Component)jLabel, "North");
        this.useAntiAliasing = new JCheckBox(HuginGUIConstants.get("PREFERENCES_use_antialiasing"));
        this.useAntiAliasing.setSelected(Hugin.mainFrame.preferences.antiAliasing);
        JPanel jPanel10 = new JPanel(new BorderLayout());
        jPanel10.add((Component)titledPanel, "North");
        jPanel10.add(titledPanel2);
        jPanel10.add((Component)this.useAntiAliasing, "South");
        JPanel jPanel11 = new JPanel(new BorderLayout());
        jPanel11.add((Component)jPanel10, "North");
        jPanel.add((Component)jPanel9, "West");
        jPanel.add(jPanel11);
        return jPanel;
    }

    private void enableDotLocation() {
        boolean bl = this.layoutModeDot.isSelected();
        this.browseDot.setEnabled(bl);
        this.dotLocation.setEnabled(bl);
        this.dotLocationLabel.setEnabled(bl);
    }

    public void drawBeliefBarPane() {
        Box box = new Box(1);
        this.beliefBarButton = new SizedButton(HuginGUIConstants.get("PREFERENCES_belief_bar"), 130);
        this.beliefBarButton.addActionListener(new ColorButtonListener());
        this.findingBarButton = new SizedButton(HuginGUIConstants.get("PREFERENCES_finding_bar"), 130);
        this.findingBarButton.addActionListener(new ColorButtonListener());
        this.inconsistentBarButton = new SizedButton(HuginGUIConstants.get("PREFERENCES_inconsistent_bar"), 130);
        this.inconsistentBarButton.addActionListener(new ColorButtonListener());
        this.likelihoodBarButton = new SizedButton(HuginGUIConstants.get("PREFERENCES_likelihood_bar"), 130);
        this.likelihoodBarButton.addActionListener(new ColorButtonListener());
        this.lockFindingBarButton = new SizedButton(HuginGUIConstants.get("PREFERENCES_lock_findings_bar"), 130);
        this.lockFindingBarButton.addActionListener(new ColorButtonListener());
        this.utilityFindingBarButton = new SizedButton(HuginGUIConstants.get("PREFERENCES_utility_bar"), 130);
        this.utilityFindingBarButton.addActionListener(new ColorButtonListener());
        this.functionBarButton = new SizedButton(HuginGUIConstants.get("PREFERENCES_function_bar"), 130);
        this.functionBarButton.addActionListener(new ColorButtonListener());
        this.defaultButton = new SizedButton(HuginGUIConstants.get("PREFERENCES_default"), 130);
        this.defaultButton.addActionListener(new ColorButtonListener());
        this.beliefBarButton.setAlignmentX(0.0f);
        this.findingBarButton.setAlignmentX(0.0f);
        this.inconsistentBarButton.setAlignmentX(0.0f);
        this.likelihoodBarButton.setAlignmentX(0.0f);
        this.lockFindingBarButton.setAlignmentX(0.0f);
        this.utilityFindingBarButton.setAlignmentX(0.0f);
        this.functionBarButton.setAlignmentX(0.0f);
        box.add(this.beliefBarButton);
        box.add(Box.createVerticalGlue());
        box.add(this.findingBarButton);
        box.add(Box.createVerticalGlue());
        box.add(this.inconsistentBarButton);
        box.add(Box.createVerticalGlue());
        box.add(this.likelihoodBarButton);
        box.add(Box.createVerticalGlue());
        box.add(this.lockFindingBarButton);
        box.add(Box.createVerticalGlue());
        box.add(this.utilityFindingBarButton);
        box.add(Box.createVerticalGlue());
        box.add(this.functionBarButton);
        box.add(Box.createVerticalGlue());
        box.add(this.defaultButton);
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(200, 260));
        this.painting = new BeliefBarPainting(this.prefs.barColors);
        jPanel.setLayout(new GridLayout());
        jPanel.add(this.painting);
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        TitledPanel titledPanel = new TitledPanel(HuginGUIConstants.get("PREFERENCES_bar_colors"));
        titledPanel.setLayout(new BoxLayout(titledPanel, 0));
        titledPanel.add(box);
        titledPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        titledPanel.add(jPanel);
        titledPanel.setAlignmentY(0.0f);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(titledPanel);
        Box box2 = new Box(0){

            public float getAlignmentX() {
                return 0.0f;
            }
        };
        JLabel jLabel = new JLabel(new ImageIcon(ClassLoader.getSystemResource("icons/bars.gif")));
        jPanel2.setAlignmentY(0.0f);
        jLabel.setAlignmentY(0.0f);
        box2.add(jLabel);
        box2.add(Box.createRigidArea(new Dimension(10, 10)));
        box2.add(titledPanel);
        this.beliefBar.add(box2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BeliefBarPainting
    extends JPanel {
        Vector<Color> colors;
        Vector<BarDrawer> bars;

        public BeliefBarPainting(Vector<Color> vector) {
            this.colors = vector;
            this.bars = new Vector();
            BarDrawer barDrawer = new BarDrawer(HuginGUIConstants.get("PREFERENCES_belief_bar"), 25, 5, 39.75f, 60.25f);
            barDrawer.setColor(vector.get(0));
            this.bars.add(barDrawer);
            barDrawer = new BarDrawer(HuginGUIConstants.get("PREFERENCES_finding_bar"), 25, 55, 100.0f, 0.0f);
            barDrawer.setColor(vector.get(1));
            this.bars.add(barDrawer);
            barDrawer = new BarDrawer(HuginGUIConstants.get("PREFERENCES_inconsistent_bar"), 25, 105, 39.7f, 60.3f);
            barDrawer.setColor(vector.get(2));
            this.bars.add(barDrawer);
            barDrawer = new BarDrawer(HuginGUIConstants.get("PREFERENCES_likelihood_bar"), 25, 155, 30.33f, 63.77f);
            barDrawer.setColor(vector.get(3));
            this.bars.add(barDrawer);
            barDrawer = new BarDrawer(HuginGUIConstants.get("PREFERENCES_lock_findings_bar"), 25, 205, 88.75f, 100.0f);
            barDrawer.setColor(vector.get(4));
            this.bars.add(barDrawer);
            barDrawer = new BarDrawer(HuginGUIConstants.get("PREFERENCES_utility_bar"), 25, 255, 17.0f, 28.0f);
            barDrawer.setColor(vector.get(5));
            this.bars.add(barDrawer);
            barDrawer = new BarDrawer(HuginGUIConstants.get("PREFERENCES_function_bar"), 25, 305, 0.0f, 0.0f);
            barDrawer.setColor(vector.get(6));
            this.bars.add(barDrawer);
        }

        public void updateColors(Vector<Color> vector) {
            this.colors = vector;
            ListIterator<BarDrawer> listIterator = this.bars.listIterator();
            for (Color color : vector) {
                listIterator.next().setColor(color);
            }
        }

        @Override
        public void paint(Graphics graphics) {
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setColor(Color.white);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            for (BarDrawer barDrawer : this.bars) {
                barDrawer.paint(graphics);
            }
        }

        @Override
        public float getAlignmentY() {
            return 0.5f;
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(150, 300);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(150, 300);
        }

        private class BarDrawer {
            int x;
            int y;
            float yes;
            float no;
            Color color;
            String name;
            static final int ovalWidth = 18;
            static final int ovalHeight = 13;
            static final int barHeight = 10;
            static final int markerWidth = 7;

            public BarDrawer(String string, int n, int n2, float f, float f2) {
                this.x = n;
                this.y = n2;
                this.yes = f;
                this.no = f2;
                this.name = string;
            }

            public void setColor(Color color) {
                this.color = color;
            }

            public void paint(Graphics graphics) {
                graphics.setColor(this.color);
                graphics.fillOval(this.x, this.y, 18, 13);
                graphics.fillRect(this.x + 9 + 7 + 4, this.y + 15, (int)((double)this.yes / 1.5), 10);
                graphics.fillRect(this.x + 9 + 7 + 4, this.y + 30, (int)((double)this.no / 1.5), 10);
                graphics.setColor(new Color(100, 100, 100));
                if (this.yes > 0.0f) {
                    graphics.drawLine(this.x + 9 + 7 + 5, this.y + 16 + 10, this.x + 9 + 7 + 6 + (int)((double)this.yes / 1.5), this.y + 16 + 10);
                    graphics.drawLine(this.x + 9 + 7 + 6 + (int)((double)this.yes / 1.5), this.y + 16 + 10, this.x + 9 + 7 + 6 + (int)((double)this.yes / 1.5), this.y + 16);
                }
                if (this.no > 0.0f) {
                    graphics.drawLine(this.x + 9 + 7 + 5, this.y + 31 + 10, this.x + 9 + 7 + 6 + (int)((double)this.no / 1.5), this.y + 31 + 10);
                    graphics.drawLine(this.x + 9 + 7 + 6 + (int)((double)this.no / 1.5), this.y + 31 + 10, this.x + 9 + 7 + 6 + (int)((double)this.no / 1.5), this.y + 31);
                }
                graphics.setColor(Color.black);
                graphics.drawOval(this.x, this.y, 18, 13);
                graphics.drawLine(this.x + 9, this.y + 13 + 2, this.x + 9, this.y + 30 + 5);
                graphics.drawLine(this.x + 9, this.y + 15 + 5, this.x + 9 + 7, this.y + 15 + 5);
                graphics.drawLine(this.x + 9, this.y + 30 + 5, this.x + 9 + 7, this.y + 30 + 5);
                if (this.yes == 0.0f) {
                    graphics.drawLine(this.x + 9 + 7 + 5, this.y + 15 + 5, this.x + 9 + 7 + 10, this.y + 15 + 5);
                }
                if (this.no == 0.0f) {
                    graphics.drawLine(this.x + 9 + 7 + 5, this.y + 30 + 5, this.x + 9 + 7 + 10, this.y + 30 + 5);
                }
                graphics.setFont(new Font(HuginGUIConstants.defaultFont.getName(), 1, 12));
                graphics.drawString(this.name, this.x + 9 + 7 + 6, this.y + 10);
                graphics.drawString(HuginGUIConstants.get("PREFERENCES_yes"), this.x + 9 + 7 + 120, this.y + 15 + 10);
                graphics.drawString(HuginGUIConstants.get("PREFERENCES_no"), this.x + 9 + 7 + 120, this.y + 30 + 10);
                String string = new Float(this.yes).toString();
                String string2 = "" + this.no;
                graphics.setFont(new Font(HuginGUIConstants.defaultFont.getName(), 0, 12));
                Rectangle2D.Float float_ = (Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(string, graphics);
                Rectangle2D.Float float_2 = (Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(string2, graphics);
                graphics.drawString(string, this.x + 9 + 7 + (115 - (int)float_.getWidth()), this.y + 15 + 10);
                graphics.drawString(string2, this.x + 9 + 7 + (115 - (int)float_2.getWidth()), this.y + 30 + 10);
            }
        }
    }

    private class ColorButtonListener
    implements ActionListener {
        String[] commands = new String[]{HuginGUIConstants.get("PREFERENCES_belief_bar"), HuginGUIConstants.get("PREFERENCES_finding_bar"), HuginGUIConstants.get("PREFERENCES_inconsistent_bar"), HuginGUIConstants.get("PREFERENCES_likelihood_bar"), HuginGUIConstants.get("PREFERENCES_lock_findings_bar"), HuginGUIConstants.get("PREFERENCES_utility_bar"), HuginGUIConstants.get("PREFERENCES_function_bar")};

        private ColorButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(HuginGUIConstants.get("PREFERENCES_default"))) {
                PreferencesPane.this.prefs.barColors.set(0, new Color(0, 255, 0));
                PreferencesPane.this.prefs.barColors.set(1, new Color(255, 0, 0));
                PreferencesPane.this.prefs.barColors.set(2, new Color(190, 190, 190));
                PreferencesPane.this.prefs.barColors.set(3, new Color(0, 0, 255));
                PreferencesPane.this.prefs.barColors.set(4, new Color(255, 0, 255));
                PreferencesPane.this.prefs.barColors.set(5, new Color(0, 128, 0));
                PreferencesPane.this.prefs.barColors.set(6, new Color(153, 255, 255));
                PreferencesPane.this.painting.updateColors(PreferencesPane.this.prefs.barColors);
                PreferencesPane.this.painting.repaint();
                return;
            }
            int n = -1;
            int n2 = 0;
            while (n == -1) {
                if (this.commands[n2].equals(string)) {
                    n = n2;
                }
                ++n2;
            }
            Color color = JColorChooser.showDialog(Hugin.mainFrame, HuginGUIConstants.get("str_choose__color"), PreferencesPane.this.prefs.barColors.get(n));
            if (color != null) {
                PreferencesPane.this.prefs.barColors.set(n, color);
            }
            PreferencesPane.this.painting.updateColors(PreferencesPane.this.prefs.barColors);
        }
    }

    private class HelpListener
    implements ActionListener {
        private HelpListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JOptionPane.showMessageDialog(new Frame(), HuginGUIConstants.get("str_sorry_no_help_available"), HuginGUIConstants.get("str_sad_smiley"), 2);
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < PreferencesPane.this.oldColors.size(); ++i) {
                PreferencesPane.this.prefs.barColors.setElementAt(PreferencesPane.this.oldColors.get(i), i);
            }
            PreferencesPane.this.self.dispose();
        }
    }

    private class ApplyOKListener
    implements ActionListener {
        private ApplyOKListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                block18: {
                    PreferencesPane.this.prefs.logdir = PreferencesPane.this.logFileDir.getText().equals(PreferencesPane.this.frame.getUserHome() + "logs") ? "" : PreferencesPane.this.logFileDir.getText();
                    PreferencesPane.this.prefs.driverdir = PreferencesPane.this.driverField.getText();
                    PreferencesPane.this.prefs.recently_used = PreferencesPane.this.recentlyUsed.getValue();
                    if (PreferencesPane.this.prefs.language != PreferencesPane.this.language.getSelectedIndex()) {
                        JOptionPane.showMessageDialog(null, HuginGUIConstants.get("PREFERENCES_language_restart"), HuginGUIConstants.get("PREFERENCES_language_restart_TITLE"), 1);
                    }
                    PreferencesPane.this.prefs.language = PreferencesPane.this.language.getSelectedIndex();
                    Hugin.mainFrame.fileList.setSize(PreferencesPane.this.prefs.recently_used);
                    Hugin.mainFrame.updateFileListMenu();
                    PreferencesPane.this.prefs.autosave = PreferencesPane.this.autosave.getValue();
                    if (!(PreferencesPane.this.prefs.autosave <= 0 || Hugin.mainFrame.autoSaver != null && Hugin.mainFrame.autoSaver.isAlive())) {
                        Hugin.mainFrame.autoSaver = new AutoSaveDaemon();
                        Hugin.mainFrame.autoSaver.start();
                    }
                    PreferencesPane.this.prefs.beep_on_errors = PreferencesPane.this.beepOnErrors.isSelected();
                    PreferencesPane.this.prefs.display_errors = PreferencesPane.this.displayError.isSelected();
                    PreferencesPane.this.prefs.display_oobn_warnings = PreferencesPane.this.displayOOBNWarnings.isSelected();
                    PreferencesPane.this.prefs.error_list_size = PreferencesPane.this.errorListSize.getValue();
                    PreferencesPane.this.prefs.compilation_warning = PreferencesPane.this.compilationWarning.getValue();
                    PreferencesPane.this.prefs.level_of_concurrency = PreferencesPane.this.levelOfConcurrency.getValue();
                    PreferencesPane.this.prefs.grain_size = PreferencesPane.this.grainSize.getValue();
                    PreferencesPane.this.prefs.show_belief_bar = PreferencesPane.this.showBeliefBar.isSelected();
                    JInternalFrame[] jInternalFrameArray = Hugin.mainFrame.desktop.getAllFrames();
                    for (int i = 0; i < jInternalFrameArray.length; ++i) {
                        if (PreferencesPane.this.showBeliefBarChanged && ((HuginProjectFrame)jInternalFrameArray[i]).runMode) {
                            if (PreferencesPane.this.showBeliefBar.isSelected()) {
                                ((HuginProjectFrame)jInternalFrameArray[i]).enableBeliefBar();
                                continue;
                            }
                            ((HuginProjectFrame)jInternalFrameArray[i]).disableBeliefBar();
                            continue;
                        }
                        ((HuginProjectFrame)jInternalFrameArray[i]).setBeliefBarsShown(PreferencesPane.this.prefs.show_belief_bar);
                    }
                    PreferencesPane.this.prefs.use_wallpaper = PreferencesPane.this.useWallpaper.isSelected();
                    try {
                        PreferencesPane.this.prefs.wallpaper_name = PreferencesPane.this.chosenFileName.getText().equals(HuginGUIConstants.get("str_default")) || PreferencesPane.this.chosenFileName.getText().equals("") ? "icons/background.gif" : PreferencesPane.this.chosenFile.getCanonicalPath();
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                        PreferencesPane.this.prefs.use_wallpaper = false;
                    }
                    PreferencesPane.this.prefs.default_browser = PreferencesPane.this.defaultBrowserFile.getText();
                    if (!PreferencesPane.this.prefs.use_wallpaper && PreferencesPane.this.frame.background != null) {
                        PreferencesPane.this.frame.desktop.remove(PreferencesPane.this.frame.background);
                        PreferencesPane.this.frame.background = null;
                    }
                    if (PreferencesPane.this.prefs.use_wallpaper) {
                        try {
                            PreferencesPane.this.frame.wallPaperImage = !PreferencesPane.this.prefs.wallpaper_name.equals("icons/background.gif") ? Toolkit.getDefaultToolkit().createImage(new File(PreferencesPane.this.prefs.wallpaper_name).toURI().toURL()) : Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource(PreferencesPane.this.prefs.wallpaper_name));
                            if (PreferencesPane.this.frame.background != null) {
                                PreferencesPane.this.frame.desktop.remove(PreferencesPane.this.frame.background);
                            }
                            PreferencesPane.this.frame.wallPaper = new ImageIcon(PreferencesPane.this.frame.wallPaperImage);
                            PreferencesPane.this.frame.background = new JLabel(PreferencesPane.this.frame.wallPaper);
                            PreferencesPane.this.frame.background.setBounds(0, 0, PreferencesPane.this.frame.wallPaper.getIconWidth(), PreferencesPane.this.frame.wallPaper.getIconHeight());
                            PreferencesPane.this.frame.desktop.add((Component)PreferencesPane.this.frame.background, new Integer(Integer.MIN_VALUE));
                            PreferencesPane.this.frame.updateBackground();
                        }
                        catch (Exception exception) {
                            PreferencesPane.this.prefs.use_wallpaper = false;
                            if (PreferencesPane.this.frame.background == null) break block18;
                            PreferencesPane.this.frame.desktop.remove(PreferencesPane.this.frame.background);
                            PreferencesPane.this.frame.background = null;
                        }
                    }
                }
                PreferencesPane.this.prefs.drag_mode = PreferencesPane.this.liveDrag.isSelected() ? 0 : 1;
                PreferencesPane.this.frame.desktop.setDragMode(PreferencesPane.this.prefs.drag_mode);
                PreferencesPane.this.frame.repaint();
                PreferencesPane.this.prefs.check_update = PreferencesPane.this.checkUpdates.isSelected();
                PreferencesPane.this.prefs.table_mode = PreferencesPane.this.tableModeTabs.isSelected() ? 1 : 0;
                PreferencesPane.this.prefs.node_table_connection_mode = PreferencesPane.this.tableConnectionLoose.isSelected() ? 1 : 0;
                PreferencesPane.this.prefs.antiAliasing = PreferencesPane.this.useAntiAliasing.isSelected();
                PreferencesPane.this.prefs.layout_mode = PreferencesPane.this.layoutModeInternal.isSelected() ? 1 : 0;
                PreferencesPane.this.prefs.dot_location = PreferencesPane.this.dotLocation.getText();
                HuginProjectFrame huginProjectFrame = Hugin.mainFrame.getSelectedProjectFrame();
                if (huginProjectFrame != null) {
                    huginProjectFrame.setTableMode(PreferencesPane.this.prefs.table_mode);
                }
                Hugin.mainFrame.writeDotFile();
                if (actionEvent.getActionCommand().equals(HuginGUIConstants.get("OK_button"))) {
                    PreferencesPane.this.self.dispose();
                }
            }
            catch (NumberOutOfRangeException numberOutOfRangeException) {
            }
            catch (ExceptionHugin exceptionHugin) {
                new HuginGUIError(HuginGUIConstants.get("str_unable_to_toggle_table_mode_") + exceptionHugin.getMessage());
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
    }
}

