/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.Hugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class ProgressPane {
    private Point positionXY = new Point();
    private int DEFAULT_RED = 110;
    private int DEFAULT_GREEN = 110;
    private int DEFAULT_BLUE = 180;
    int position = 0;
    int direction = 1;
    int stepSize = 5;
    int gradSize = 6;
    int barFraction = 2;
    int barLength;
    double dRed;
    double dBlue;
    double dGreen;
    double red;
    double green;
    double blue;
    Dimension dim;
    Color back = UIManager.getDefaults().getColor("Panel.background");
    boolean started = false;

    public ProgressPane() {
        Color color = UIManager.getDefaults().getColor("MenuItem.selectionBackground");
        this.DEFAULT_BLUE = color.getBlue();
        this.DEFAULT_RED = color.getRed();
        this.DEFAULT_GREEN = color.getGreen();
        this.dim = new Dimension(100, 20);
        this.calculateLengthAndColors();
    }

    private void calculateLengthAndColors() {
        this.barLength = this.dim.width / this.barFraction;
        this.dRed = (double)(this.gradSize * (this.back.getRed() - this.DEFAULT_RED)) / (double)this.barLength;
        this.dGreen = (double)(this.gradSize * (this.back.getGreen() - this.DEFAULT_GREEN)) / (double)this.barLength;
        this.dBlue = (double)(this.gradSize * (this.back.getBlue() - this.DEFAULT_BLUE)) / (double)this.barLength;
    }

    public void makeProgress() {
        this.position += this.stepSize * this.direction;
        if (this.dim != null && this.position > this.dim.width + this.barLength) {
            this.direction = -this.direction;
            this.position = this.dim.width;
        }
        if (this.position < 0 - this.barLength) {
            this.direction = -this.direction;
            this.position = 0;
        }
    }

    public void setSizeAndPosition() {
        JPanel jPanel = Hugin.mainFrame.getStatusBar().getConflictField();
        this.dim = jPanel.getSize();
        Insets insets = jPanel.getInsets(null);
        this.positionXY = jPanel.getLocationOnScreen();
        Point point = Hugin.mainFrame.getLocationOnScreen();
        this.positionXY.setLocation(this.positionXY.x - point.x + insets.left, this.positionXY.y - point.y + insets.top);
        this.dim.setSize(this.dim.width - insets.left - insets.right, this.dim.height - insets.top - insets.bottom);
    }

    public void reset() {
        this.position = 0;
        this.direction = 1;
    }

    public void paintBar() {
        Graphics graphics = Hugin.mainFrame.getGraphics();
        this.red = this.DEFAULT_RED;
        this.green = this.DEFAULT_GREEN;
        this.blue = this.DEFAULT_BLUE;
        graphics.translate(this.positionXY.x, this.positionXY.y);
        graphics.setClip(0, 0, this.dim.width, this.dim.height);
        graphics.setColor(this.back);
        graphics.fillRect(0, 0, this.dim.width, this.dim.height);
        for (int i = 0; i < this.barLength; i += this.gradSize) {
            graphics.setColor(new Color((int)this.red, (int)this.green, (int)this.blue));
            this.red += this.dRed;
            this.green += this.dGreen;
            this.blue += this.dBlue;
            graphics.fillRect(this.position - (i - this.gradSize) * this.direction, 0, this.gradSize, this.dim.height);
        }
        graphics.translate(-this.positionXY.x, -this.positionXY.y);
    }
}

