/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class Questionnaire
extends JPanel {
    private QuestionnaireModel model;
    private String title;
    private JButton next;
    private JButton back;
    private JButton finish;
    private int index;
    private JPanel[] panels;
    private JPanel buttons;
    private Dimension prefSize;
    private boolean numbering;

    public Questionnaire(String string) {
        this.setLayout(new BorderLayout());
        this.model = new QuestionnaireModel();
        this.model.addQuestionnaireChangeListener(new QuestionnaireChangeListener(){

            public void questionnaireChanged() {
                Questionnaire.this.rebuildQuestionnaire();
            }
        });
        this.title = string;
        this.numbering = true;
        this.index = 0;
        this.createQuestionnaire();
        this.rebuildQuestionnaire();
        this.buttons = this.createButtons();
        this.add((Component)this.buttons, "South");
        this.prefSize = new Dimension(0, 0);
        QuestionnaireSection[] questionnaireSectionArray = this.model.getSections();
        for (int i = 0; i < this.panels.length; ++i) {
            Dimension dimension = this.panels[i].getPreferredSize();
            this.prefSize.width = Math.max(this.prefSize.width, dimension.width);
            this.prefSize.height = Math.max(this.prefSize.height, dimension.height + questionnaireSectionArray[i].getTotalSpacing());
        }
        this.prefSize.height += this.buttons.getPreferredSize().height;
        this.prefSize.width = Math.max(this.prefSize.width, this.buttons.getPreferredSize().width);
        this.next.setEnabled(this.model.numberOfSections() > 1);
        this.back.setEnabled(false);
    }

    private void createQuestionnaire() {
        QuestionnaireSection questionnaireSection = new QuestionnaireSection(HuginGUIConstants.get("str_page_one_of_three"));
        int n = 1;
        Question question = new SingleChoiceQuestion(HuginGUIConstants.get("str_for_how_long_have_you_been_using_hugin"), new String[]{HuginGUIConstants.get("str_zero_six_months"), HuginGUIConstants.get("str_six_twelve_months"), HuginGUIConstants.get("str_one_two_years"), HuginGUIConstants.get("str_two_five_years"), HuginGUIConstants.get("str_more_than_five_years")});
        questionnaireSection.add(question);
        question = new SingleChoiceQuestion(HuginGUIConstants.get("str_for_which_purpose_do_you_use_hugin"), new String[]{HuginGUIConstants.get("str_commercial"), HuginGUIConstants.get("str_educational"), HuginGUIConstants.get("str_evaluation"), HuginGUIConstants.get("str_other")});
        FreeTextQuestion freeTextQuestion = new FreeTextQuestion(HuginGUIConstants.get("str_which_"));
        freeTextQuestion.setHeight(3);
        question.setSubQuestion(freeTextQuestion, HuginGUIConstants.get("str_other"));
        questionnaireSection.add(question);
        question = new MultipleChoiceQuestion(HuginGUIConstants.get("str_which_apis_do_you_use"), new String[]{HuginGUIConstants.get("str_c"), HuginGUIConstants.get("str_c_plus_plus"), HuginGUIConstants.get("str_java"), HuginGUIConstants.get("str_activex"), HuginGUIConstants.get("str_c_sharp_dot_net"), HuginGUIConstants.get("str_none")});
        questionnaireSection.add(question);
        question = new SingleChoiceQuestion(HuginGUIConstants.get("str_should_hugin_offer_other_apis"), new String[]{HuginGUIConstants.get("str_no"), HuginGUIConstants.get("str_yes")});
        freeTextQuestion = new FreeTextQuestion(HuginGUIConstants.get("str_which"));
        freeTextQuestion.setHeight(3);
        question.setSubQuestion(freeTextQuestion, HuginGUIConstants.get("str_yes"));
        questionnaireSection.add(question);
        n = questionnaireSection.number(n);
        this.addSection(questionnaireSection);
        questionnaireSection = new QuestionnaireSection(HuginGUIConstants.get("str_page_two_of_three"));
        question = new MultipleChoiceQuestion(HuginGUIConstants.get("str_which_features_are_useful_to_you"), new String[]{HuginGUIConstants.get("str_em_learning"), HuginGUIConstants.get("str_structural_learning"), HuginGUIConstants.get("str_adaptation"), HuginGUIConstants.get("str_learning_wizard"), HuginGUIConstants.get("str_object_orientation"), HuginGUIConstants.get("str_continuous_variables"), HuginGUIConstants.get("str_junction_trees"), HuginGUIConstants.get("str_conflict_analysis"), HuginGUIConstants.get("str_expressions"), HuginGUIConstants.get("str_propagation"), HuginGUIConstants.get("str_other")});
        freeTextQuestion = new FreeTextQuestion(HuginGUIConstants.get("str_which_"));
        freeTextQuestion.setHeight(3);
        question.setSubQuestion(freeTextQuestion, HuginGUIConstants.get("str_other"));
        questionnaireSection.add(question);
        question = new MultipleChoiceQuestion(HuginGUIConstants.get("str_which_features_do_you_miss"), new String[]{HuginGUIConstants.get("str_oobn_learning"), HuginGUIConstants.get("str_cg_learning"), HuginGUIConstants.get("str_d_separation"), HuginGUIConstants.get("str_sensitivity_analysis"), HuginGUIConstants.get("str_value_of_information"), HuginGUIConstants.get("str_adaptation_wizard"), HuginGUIConstants.get("str_classification_wizard"), HuginGUIConstants.get("str_improved_logging"), HuginGUIConstants.get("str_cross_validation_model_scoring"), HuginGUIConstants.get("str_limids"), HuginGUIConstants.get("str_auto_layout"), HuginGUIConstants.get("str_triangulation_tool"), HuginGUIConstants.get("str_inheritance_in_oobns"), HuginGUIConstants.get("str_auto_documentation"), HuginGUIConstants.get("str_explanation"), HuginGUIConstants.get("str_other")});
        ((MultipleChoiceQuestion)question).setNumberOfColumns(3);
        freeTextQuestion = new FreeTextQuestion(HuginGUIConstants.get("str_which_"));
        freeTextQuestion.setHeight(3);
        question.setSubQuestion(freeTextQuestion, HuginGUIConstants.get("str_other"));
        questionnaireSection.add(question);
        n = questionnaireSection.number(n);
        this.addSection(questionnaireSection);
        questionnaireSection = new QuestionnaireSection(HuginGUIConstants.get("str_page_three_of_three"));
        question = new SingleChoiceQuestion(HuginGUIConstants.get("str_have_you_used_other_tools_for_probabilistic_graphical_models"), new String[]{HuginGUIConstants.get("str_no"), HuginGUIConstants.get("str_yes")});
        freeTextQuestion = new FreeTextQuestion(HuginGUIConstants.get("str_which"));
        freeTextQuestion.setHeight(3);
        question.setSubQuestion(freeTextQuestion, HuginGUIConstants.get("str_yes"));
        questionnaireSection.add(question);
        question = new SingleChoiceQuestion(HuginGUIConstants.get("str_are_you_satisfied_with_the_service_hugin_offers"), new String[]{HuginGUIConstants.get("str_no"), HuginGUIConstants.get("str_yes")});
        freeTextQuestion = new FreeTextQuestion(HuginGUIConstants.get("str_why_not"));
        freeTextQuestion.setHeight(4);
        question.setSubQuestion(freeTextQuestion, HuginGUIConstants.get("str_no"));
        questionnaireSection.add(question);
        question = new FreeTextQuestion(HuginGUIConstants.get("str_other_comments"));
        ((FreeTextQuestion)question).setHeight(10);
        questionnaireSection.add(question);
        questionnaireSection.number(n);
        this.addSection(questionnaireSection);
    }

    public Dimension getMinimumSize() {
        return new Dimension(300, 300);
    }

    public Dimension getPreferredSize() {
        return (Dimension)this.prefSize.clone();
    }

    public void addSection(QuestionnaireSection questionnaireSection) {
        this.model.add(questionnaireSection);
    }

    public void removeSection(QuestionnaireSection questionnaireSection) {
        this.model.remove(questionnaireSection);
    }

    private void rebuildQuestionnaire() {
        this.removeAll();
        if (this.model.numberOfSections() == 0) {
            this.add(new JLabel(HuginGUIConstants.get("str_empty")));
            return;
        }
        QuestionnaireSection[] questionnaireSectionArray = this.model.getSections();
        this.panels = new JPanel[questionnaireSectionArray.length];
        for (int i = 0; i < this.panels.length; ++i) {
            this.panels[i] = questionnaireSectionArray[i].getPanel();
        }
        this.add(this.panels[this.index]);
    }

    private JPanel createButtons() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.next = new JButton(HuginGUIConstants.get("str_next"));
        this.next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Questionnaire.this.remove(Questionnaire.this.panels[Questionnaire.this.index]);
                Questionnaire.this.add(Questionnaire.this.panels[++Questionnaire.this.index]);
                Questionnaire.this.back.setEnabled(true);
                Questionnaire.this.next.setEnabled(Questionnaire.this.index < Questionnaire.this.model.numberOfSections() - 1);
                Questionnaire.this.revalidate();
                Questionnaire.this.repaint();
            }
        });
        this.back = new JButton(HuginGUIConstants.get("str_back"));
        this.back.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Questionnaire.this.remove(Questionnaire.this.panels[Questionnaire.this.index]);
                Questionnaire.this.add(Questionnaire.this.panels[--Questionnaire.this.index]);
                Questionnaire.this.next.setEnabled(true);
                Questionnaire.this.back.setEnabled(Questionnaire.this.index > 0);
                Questionnaire.this.revalidate();
                Questionnaire.this.repaint();
            }
        });
        this.finish = new JButton(HuginGUIConstants.get("str_finish"));
        this.finish.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Questionnaire.this.sendResult();
                ((Window)Questionnaire.this.getTopLevelAncestor()).dispose();
            }
        });
        JButton jButton = new JButton(HuginGUIConstants.get("CANCEL_BUTTON_LABEL"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Window)Questionnaire.this.getTopLevelAncestor()).dispose();
            }
        });
        jPanel.add(jButton);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanel.add(this.back);
        jPanel.add(this.next);
        jPanel.add(this.finish);
        return jPanel;
    }

    private JDialog createFinishDialog(String string) {
        final JDialog jDialog = new JDialog(Hugin.mainFrame, string, true);
        JTextArea jTextArea = new JTextArea(6, 30);
        jTextArea.setText(HuginGUIConstants.get("str_thank_you_for_your_assistance_etc"));
        jTextArea.setLineWrap(true);
        jTextArea.setEnabled(false);
        jTextArea.setDisabledTextColor(Color.black);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        jDialog.getContentPane().setLayout(new BorderLayout(10, 10));
        jDialog.getContentPane().add(jTextArea);
        JButton jButton = new JButton(HuginGUIConstants.get("CLOSE_BUTTON_LABEL"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(jButton);
        jDialog.getContentPane().add((Component)jPanel, "South");
        return jDialog;
    }

    private void sendResult(boolean bl) {
        QuestionnaireSection[] questionnaireSectionArray = this.model.getSections();
    }

    private void sendResult() {
        try {
            Socket socket = new Socket("bug.hugin.dk", 3333);
            this.printQuestionnaire(new PrintWriter(socket.getOutputStream(), true));
            socket.close();
        }
        catch (UnknownHostException unknownHostException) {
            new HuginGUIError(HuginGUIConstants.get("str_unknown_host_hugin_dk"));
            return;
        }
        catch (IOException iOException) {
            new HuginGUIError(HuginGUIConstants.get("str_couldnt_get_io_for_conn_to_hugin_dk"));
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void printQuestionnaire(PrintWriter printWriter) {
        QuestionnaireSection[] questionnaireSectionArray = this.model.getSections();
        printWriter.println("From: Hugin user");
        printWriter.println("Subject: " + this.title);
        printWriter.println(NetworkModel.getPackageName() + " " + "7.3");
        for (int i = 0; i < questionnaireSectionArray.length; ++i) {
            printWriter.println(questionnaireSectionArray[i]);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setContentPane(new Questionnaire(HuginGUIConstants.get("str_user_feedback_for_gui_") + "7.3"));
        jFrame.pack();
        jFrame.setLocation(200, 200);
        jFrame.setVisible(true);
    }

    private class FreeTextQuestion
    implements Question {
        private String question;
        private JTextArea answer;
        private int limit;
        private int height;
        private JPanel panel;
        private boolean enabled;
        JTextArea label;

        public FreeTextQuestion(String string) {
            this(string, 10000);
        }

        public FreeTextQuestion(String string, int n) {
            this.question = string;
            this.limit = n;
            this.panel = this.createPanel();
            this.enabled = true;
        }

        public void setSubQuestion(Question question, String string) {
        }

        public JPanel getPanel() {
            return this.panel;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setHeight(int n) {
            this.height = n;
            this.panel = this.createPanel();
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
            this.answer.setEnabled(bl);
            if (bl) {
                this.label.setDisabledTextColor(Color.black);
            } else {
                this.label.setDisabledTextColor(UIManager.getDefaults().getColor("Button.disabledText"));
            }
            this.label.repaint();
        }

        private JPanel createPanel() {
            JPanel jPanel = new JPanel(new BorderLayout());
            this.label = new JTextArea(this.question);
            this.label.setEnabled(false);
            this.label.setDisabledTextColor(Color.black);
            this.label.setLineWrap(true);
            this.label.setWrapStyleWord(true);
            this.label.setBackground(UIManager.getDefaults().getColor("Panel.background"));
            jPanel.add((Component)this.label, "North");
            this.answer = new JTextArea(this.height, 20);
            this.answer.setLineWrap(true);
            this.answer.setWrapStyleWord(true);
            this.answer.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent keyEvent) {
                    if (FreeTextQuestion.this.limit > 0 && keyEvent.getKeyChar() != '\b' && FreeTextQuestion.this.answer.getText().length() > FreeTextQuestion.this.limit) {
                        keyEvent.consume();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.answer);
            jScrollPane.setHorizontalScrollBarPolicy(30);
            jScrollPane.setVerticalScrollBarPolicy(20);
            jPanel.add(jScrollPane);
            return jPanel;
        }

        public String toString() {
            String string = this.question + " :: [ " + this.answer.getText() + " ]";
            return string;
        }
    }

    private class MultipleChoiceQuestion
    implements Question {
        private String question;
        private String[] choices;
        private JCheckBox[] selections;
        private int numColumns;
        private JPanel panel;
        private Question subQuestion;
        private String subQuestionActivator;
        private boolean enabled;
        JTextArea label;

        public MultipleChoiceQuestion(String string, String[] stringArray) {
            this.question = string;
            this.choices = stringArray;
            this.selections = new JCheckBox[stringArray.length];
            this.numColumns = 2;
            this.panel = this.createPanel();
            this.enabled = true;
        }

        public void setNumberOfColumns(int n) {
            this.numColumns = n;
        }

        public JPanel getPanel() {
            return this.panel;
        }

        public void setSubQuestion(Question question, String string) {
            this.subQuestion = question;
            this.subQuestionActivator = string;
            this.panel = this.createPanel();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
            for (int i = 0; i < this.selections.length; ++i) {
                this.selections[i].setEnabled(bl);
            }
            if (bl) {
                this.label.setDisabledTextColor(Color.black);
            } else {
                this.label.setDisabledTextColor(UIManager.getDefaults().getColor("Button.disabledText"));
            }
            this.label.repaint();
        }

        private JPanel createPanel() {
            JPanel jPanel = new JPanel(new BorderLayout());
            this.label = new JTextArea(this.question);
            this.label.setLineWrap(true);
            this.label.setEnabled(false);
            this.label.setDisabledTextColor(Color.black);
            this.label.setWrapStyleWord(true);
            this.label.setBackground(UIManager.getDefaults().getColor("Panel.background"));
            jPanel.add((Component)this.label, "North");
            int n = this.selections.length / this.numColumns;
            if (this.selections.length % this.numColumns != 0) {
                ++n;
            }
            JPanel jPanel2 = new JPanel(new GridLayout(n, this.numColumns));
            for (int i = 0; i < this.selections.length; ++i) {
                this.selections[i] = new JCheckBox(this.choices[i]);
                jPanel2.add(this.selections[i]);
            }
            jPanel.add((Component)jPanel2, "West");
            if (this.subQuestion != null) {
                jPanel.add((Component)this.subQuestion.getPanel(), "South");
                this.subQuestion.setEnabled(false);
                ActionListener actionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (MultipleChoiceQuestion.this.subQuestion == null) {
                            return;
                        }
                        JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                        if (jCheckBox.getText().equals(MultipleChoiceQuestion.this.subQuestionActivator)) {
                            MultipleChoiceQuestion.this.subQuestion.setEnabled(jCheckBox.isSelected());
                        }
                    }
                };
                for (int i = 0; i < this.selections.length; ++i) {
                    this.selections[i].addActionListener(actionListener);
                }
            }
            return jPanel;
        }

        public String toString() {
            String string = this.question + " :: ";
            boolean bl = false;
            for (int i = 0; i < this.selections.length; ++i) {
                if (!this.selections[i].isSelected()) continue;
                string = string + (bl ? ", " : "") + this.choices[i];
                bl = true;
            }
            if (this.subQuestion != null && this.subQuestion.isEnabled()) {
                string = string + " ( " + this.subQuestion.toString() + " )";
            }
            if (!bl) {
                string = string + "null";
            }
            return string;
        }
    }

    private class SingleChoiceQuestion
    implements Question {
        private String question;
        private String[] choices;
        private JPanel panel;
        private Question subQuestion;
        private String subQuestionActivator;
        private boolean enabled;
        JComboBox choice;
        JTextArea label;

        public SingleChoiceQuestion(String string, String[] stringArray) {
            this.question = string;
            this.choices = stringArray;
            this.panel = this.createPanel();
            this.subQuestion = null;
            this.enabled = true;
        }

        public JPanel getPanel() {
            return this.panel;
        }

        public void setSubQuestion(Question question, String string) {
            this.subQuestion = question;
            this.subQuestionActivator = string;
            this.panel = this.createPanel();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
            this.choice.setEnabled(bl);
            if (bl) {
                this.label.setDisabledTextColor(Color.black);
            } else {
                this.label.setDisabledTextColor(UIManager.getDefaults().getColor("Button.disabledText"));
            }
            this.label.repaint();
        }

        private JPanel createPanel() {
            JPanel jPanel = new JPanel(new BorderLayout());
            this.label = new JTextArea(this.question);
            this.label.setLineWrap(true);
            this.label.setEnabled(false);
            this.label.setDisabledTextColor(Color.black);
            this.label.setWrapStyleWord(true);
            this.label.setBackground(UIManager.getDefaults().getColor("Panel.background"));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            this.choice = new JComboBox<String>(this.choices);
            this.choice.setSelectedIndex(-1);
            this.choice.setEditable(false);
            jPanel2.add((Component)this.choice, "North");
            jPanel.add(this.label);
            jPanel.add((Component)jPanel2, "East");
            if (this.subQuestion != null) {
                jPanel.add((Component)this.subQuestion.getPanel(), "South");
                this.subQuestion.setEnabled(false);
                this.choice.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SingleChoiceQuestion.this.subQuestion == null) {
                            return;
                        }
                        SingleChoiceQuestion.this.subQuestion.setEnabled(SingleChoiceQuestion.this.choice.getSelectedItem().toString().equals(SingleChoiceQuestion.this.subQuestionActivator));
                    }
                });
            }
            return jPanel;
        }

        public String toString() {
            String string = this.question + " :: " + this.choice.getSelectedItem();
            if (this.choice.getSelectedItem() != null && this.subQuestion != null && this.choice.getSelectedItem().toString().equals(this.subQuestionActivator)) {
                string = string + " ( " + this.subQuestion.toString() + " )";
            }
            return string;
        }
    }

    private static interface Question {
        public JPanel getPanel();

        public void setSubQuestion(Question var1, String var2);

        public void setEnabled(boolean var1);

        public boolean isEnabled();
    }

    protected class QuestionnaireSection {
        private String name;
        private LinkedList<Question> questions;
        private int spacing;
        private int number;
        private JPanel panel;

        public QuestionnaireSection(String string) {
            this.name = string;
            this.questions = new LinkedList();
            this.spacing = 15;
            this.number = -1;
        }

        public int getTotalSpacing() {
            return (this.questions.size() - 1) * 15;
        }

        public void add(Question question) {
            this.questions.add(question);
            this.panel = this.getPanel();
        }

        public void remove(Question question) {
            this.questions.remove(question);
            this.panel = this.getPanel();
        }

        public int number(int n) {
            this.number = n;
            this.panel = this.getPanel();
            return n + this.questions.size();
        }

        public JPanel getPanel() {
            VerticalFlowLayout verticalFlowLayout = new VerticalFlowLayout(0);
            verticalFlowLayout.setRaggedEdges(false);
            JPanel jPanel = new JPanel(verticalFlowLayout);
            jPanel.setBorder(BorderFactory.createTitledBorder(this.name));
            int n = this.number;
            ListIterator listIterator = this.questions.listIterator();
            while (listIterator.hasNext()) {
                JPanel jPanel2 = ((Question)listIterator.next()).getPanel();
                if (this.number >= 0) {
                    JPanel jPanel3 = new JPanel(new BorderLayout(5, 0));
                    JPanel jPanel4 = new JPanel(new BorderLayout(0, 0));
                    jPanel4.add((Component)new JLabel(n++ + ". "), "North");
                    jPanel3.add((Component)jPanel4, "West");
                    jPanel3.add(jPanel2);
                    jPanel.add(jPanel3);
                } else {
                    jPanel.add(jPanel2);
                }
                if (!listIterator.hasNext() || this.spacing <= 0) continue;
                jPanel.add(Box.createRigidArea(new Dimension(5, this.spacing)));
            }
            return jPanel;
        }

        public String toString() {
            String string = this.name + " :\n";
            for (Question question : this.questions) {
                string = string + "  " + question + "\n";
            }
            return string;
        }
    }

    private class QuestionnaireModel {
        LinkedList<QuestionnaireSection> sections = new LinkedList();
        LinkedList<QuestionnaireChangeListener> changeListeners = new LinkedList();

        public QuestionnaireSection[] getSections() {
            return this.sections.toArray(new QuestionnaireSection[this.sections.size()]);
        }

        public int numberOfSections() {
            return this.sections.size();
        }

        public void add(QuestionnaireSection questionnaireSection) {
            this.sections.add(questionnaireSection);
            this.fireQuestionnaireChanged();
        }

        public void remove(QuestionnaireSection questionnaireSection) {
            this.sections.remove(questionnaireSection);
            this.fireQuestionnaireChanged();
        }

        public void clear() {
            this.sections.clear();
            this.fireQuestionnaireChanged();
        }

        public void addQuestionnaireChangeListener(QuestionnaireChangeListener questionnaireChangeListener) {
            this.changeListeners.add(questionnaireChangeListener);
        }

        public void removeQuestionnaireChangeListener(QuestionnaireChangeListener questionnaireChangeListener) {
            this.changeListeners.remove(questionnaireChangeListener);
        }

        protected void fireQuestionnaireChanged() {
            for (QuestionnaireChangeListener questionnaireChangeListener : this.changeListeners) {
                questionnaireChangeListener.questionnaireChanged();
            }
        }
    }

    private static interface QuestionnaireChangeListener {
        public void questionnaireChanged();
    }
}

