/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteDecisionNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.Table;
import COM.hugin.HGUI.BeliefBarPanel;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.NodeTable;
import COM.hugin.HGUI.NodeTableColumnModel;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.PaintEvent;
import java.util.EventListener;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class RunModePoliciesWindow
extends JInternalFrame {
    Node node;
    DiscreteNode apiNode;
    HuginProjectFrame project;
    PoliciesPanel panel;
    boolean display = true;
    Dimension mySize = new Dimension(500, 400);
    int mouseX = 0;
    int mouseY = 0;
    BeliefBarPanel.PolicyUpdateListener myUpdateListener = new BeliefBarPanel.PolicyUpdateListener(){

        public void policyUpdated() {
            RunModePoliciesWindow.this.updateApiNode();
        }
    };

    public RunModePoliciesWindow(Node node, HuginProjectFrame huginProjectFrame) throws ExceptionHugin {
        super(HuginGUIUtils.getNodeTitle(node.getAPINode(), (short)0), true, true);
        this.setFrameIcon(new ImageIcon(Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("icons/fileIcon.gif"))));
        this.node = node;
        this.project = huginProjectFrame;
        BeliefBarPanel beliefBarPanel = huginProjectFrame.getBeliefBarPanel();
        Domain domain = beliefBarPanel.getDomain();
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                RunModePoliciesWindow.this.node.setPoliciesWindowLocation(componentEvent.getComponent().getLocation());
                RunModePoliciesWindow.this.repaint();
            }

            public void componentResized(ComponentEvent componentEvent) {
                RunModePoliciesWindow.this.mySize = RunModePoliciesWindow.this.getSize();
            }
        });
        this.apiNode = (DiscreteNode)beliefBarPanel.getDomainNodeFor(node.getAPINode());
        this.setBackground(Color.white);
        if (!(this.apiNode instanceof DiscreteDecisionNode)) {
            return;
        }
        this.panel = new PoliciesPanel();
        this.setContentPane(this.panel);
        this.pack();
        this.updateSize();
        this.updateApiNode();
        Point point = new Point((int)(node.center.x - (double)this.getWidth() / 2.0), (int)(node.center.y - (double)this.getHeight() / 2.0));
        this.setLocation(point);
        this.setDefaultCloseOperation(1);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                RunModePoliciesWindow.this.display = false;
            }
        });
        this.addMouseListener(new PolicyMouseListener());
        for (Component component : this.getComponents()) {
            component.addMouseListener(new PolicyMouseListener());
        }
    }

    protected void updateSize() {
        Dimension dimension = this.panel != null ? new Dimension(this.panel.nodeTable.getCPT().getTrueColumnCount() * 75 + 75, this.getPreferredSize().height) : this.mySize;
        Dimension dimension2 = new Dimension(Math.min(dimension.width, this.mySize.width), Math.min(dimension.height, this.mySize.height));
        this.setMaximumSize(dimension);
        this.setMinimumSize(new Dimension(100, 50));
        this.setSize(dimension2);
    }

    protected void setNotAlive() {
        this.panel = null;
        this.setContentPane(new JPanel());
    }

    protected void updateApiNode() {
        try {
            AWTEvent aWTEvent;
            Domain domain = this.project.getBeliefBarPanel().getDomain();
            DiscreteNode discreteNode = this.apiNode;
            this.apiNode = (DiscreteDecisionNode)domain.getNodeByName(this.node.getName());
            this.setTitle(HuginGUIUtils.getNodeTitle(this.node.getAPINode(), (short)0));
            if (this.apiNode.evidenceIsEntered() && this.panel != null) {
                this.panel = null;
                JPanel jPanel = new JPanel();
                jPanel.add(new JLabel(HuginGUIConstants.get("MISCELLANEOUS_Evidence_is_entered")));
                jPanel.addMouseMotionListener(new PolicyMouseMotionListener());
                jPanel.addMouseListener(new PolicyMouseListener());
                this.setContentPane(jPanel);
                return;
            }
            if (discreteNode != this.apiNode || !this.apiNode.evidenceIsEntered() && this.panel == null) {
                this.panel = new PoliciesPanel();
                this.setContentPane(this.panel);
            }
            if ((aWTEvent = EventQueue.getCurrentEvent()) != null && !(aWTEvent instanceof PaintEvent) && !(aWTEvent instanceof InvocationEvent) && aWTEvent.getID() != 506) {
                Hugin.mainFrame.repaint();
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    public void paint(Graphics graphics) {
        this.updateApiNode();
        super.paint(graphics);
    }

    protected class PolicyMouseMotionListener
    extends MouseMotionAdapter {
        int x;
        int y;

        protected PolicyMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            this.x = (int)(RunModePoliciesWindow.this.getLocation().getX() + (double)(mouseEvent.getX() - RunModePoliciesWindow.this.mouseX));
            this.y = (int)(RunModePoliciesWindow.this.getLocation().getY() + (double)(mouseEvent.getY() - RunModePoliciesWindow.this.mouseY));
            RunModePoliciesWindow.this.setLocation(this.x, this.y);
        }
    }

    protected class PolicyMouseListener
    extends MouseAdapter {
        protected PolicyMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            RunModePoliciesWindow.this.moveToFront();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            RunModePoliciesWindow.this.mouseX = mouseEvent.getX();
            RunModePoliciesWindow.this.mouseY = mouseEvent.getY();
        }
    }

    protected class PoliciesPanel
    extends JPanel {
        public NodeTable nodeTable = null;

        /*
         * WARNING - void declaration
         */
        public PoliciesPanel() {
            try {
                DiscreteNode discreteNode;
                Cloneable cloneable;
                this.nodeTable = new NodeTable(null, RunModePoliciesWindow.this.apiNode);
                if (this.nodeTable.getExpressionTable() != null) {
                    this.nodeTable.getExpressionTable().setEnabled(false);
                }
                this.nodeTable.getTable().setEnabled(false);
                this.nodeTable.getStateTable().setEnabled(false);
                this.nodeTable.getStateTable().setCellSelectionEnabled(false);
                for (MouseListener object : this.nodeTable.getCPT().getTableHeader().getMouseListeners()) {
                    this.nodeTable.getCPT().getTableHeader().removeMouseListener(object);
                }
                for (MouseListener mouseListener : this.nodeTable.getStateTable().getTableHeader().getMouseListeners()) {
                    this.nodeTable.getStateTable().getTableHeader().removeMouseListener(mouseListener);
                }
                for (MouseListener mouseListener : this.nodeTable.getStateTable().getMouseListeners()) {
                    this.nodeTable.getStateTable().removeMouseListener(mouseListener);
                }
                for (EventListener eventListener : this.nodeTable.getCPT().getTableHeader().getMouseMotionListeners()) {
                    this.nodeTable.getCPT().getTableHeader().removeMouseMotionListener((MouseMotionListener)eventListener);
                }
                for (EventListener eventListener : this.nodeTable.getStateTable().getTableHeader().getMouseMotionListeners()) {
                    this.nodeTable.getStateTable().getTableHeader().removeMouseMotionListener((MouseMotionListener)eventListener);
                }
                for (EventListener eventListener : this.nodeTable.getStateTable().getMouseMotionListeners()) {
                    this.nodeTable.getStateTable().removeMouseMotionListener((MouseMotionListener)eventListener);
                }
                this.setLayout(new GridLayout(1, 1));
                this.add(this.nodeTable);
                this.addMouseListener(new PolicyMouseListener());
                this.addMouseMotionListener(new PolicyMouseMotionListener());
                this.nodeTable.getTable().addMouseListener(new PolicyMouseListener());
                this.nodeTable.getTable().addMouseMotionListener(new PolicyMouseMotionListener());
                this.nodeTable.getStateTable().addMouseListener(new PolicyMouseListener());
                this.nodeTable.getStateTable().addMouseMotionListener(new PolicyMouseMotionListener());
                this.nodeTable.getCPT().getTableHeader().addMouseListener(new PolicyMouseListener());
                this.nodeTable.getCPT().getTableHeader().addMouseMotionListener(new PolicyMouseMotionListener());
                Table table = RunModePoliciesWindow.this.apiNode.getTable();
                NodeList nodeList = table.getNodes();
                nodeList.removeLast();
                int n = 1;
                for (COM.hugin.HAPI.Node node : nodeList) {
                    cloneable = (DiscreteNode)node;
                    n *= ((DiscreteNode)cloneable).getNumberOfStates();
                }
                boolean bl = false;
                int n2 = 1;
                cloneable = RunModePoliciesWindow.this.project.getBeliefBarPanel().getDomain();
                NodeTableColumnModel nodeTableColumnModel = (NodeTableColumnModel)this.nodeTable.getCPT().getTableHeader().getColumnModel();
                DiscreteNode discreteNode2 = discreteNode = nodeList.size() > 0 ? (DiscreteNode)nodeList.removeLast() : null;
                while (discreteNode != null) {
                    void var5_20;
                    int n3 = discreteNode.getNumberOfStates();
                    for (int i = 0; i < n3; ++i) {
                        boolean bl2;
                        boolean bl3 = bl2 = !((Domain)cloneable).evidenceToPropagate() && !((Domain)cloneable).tablesToPropagate();
                        if (!(bl2 ? discreteNode.getBelief(i) == 0.0 : discreteNode.getEnteredFinding(i) == 0.0)) continue;
                        for (int j = 0; j < n; j += n3 * n2) {
                            int n4 = i * n2;
                            int n5 = n4 + n2;
                            nodeTableColumnModel.collapsedColumns.add(new NodeTableColumnModel.Collapse(j + n4, j + n5, (int)var5_20));
                        }
                    }
                    n2 *= n3;
                    ++var5_20;
                    discreteNode = nodeList.size() > 0 ? (DiscreteNode)nodeList.removeLast() : null;
                }
                this.nodeTable.resizeTable();
                this.nodeTable.revalidate();
                this.nodeTable.repaint();
            }
            catch (ExceptionHugin exceptionHugin) {
                System.err.println(exceptionHugin);
                new HuginGUIError(exceptionHugin);
            }
        }
    }
}

