/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.Expression;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.PastingTextField;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.Caret;

public class SelectionTable
extends JTable {
    boolean clicked;
    boolean selectionEnabled = false;
    CellEditor editor;

    public SelectionTable(TableModel tableModel) {
        super(tableModel);
        this.init();
    }

    public SelectionTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.init();
    }

    public SelectionTable() {
        this.init();
    }

    private void init() {
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 9) {
                    SelectionTable.this.editor.stopCellEditing();
                    SelectionTable.this.firePropertyChange("Tabbed", false, true);
                    keyEvent.consume();
                }
            }
        });
        this.editor = new CellEditor(new PastingTextField());
        this.setDefaultEditor(Object.class, this.editor);
        this.setDefaultRenderer(Object.class, new CellRenderer());
    }

    protected void stopEditing() {
        this.getDefaultEditor(Object.class).stopCellEditing();
    }

    protected void updateExpression(Expression expression) throws ExceptionHugin {
        String string = HuginGUIConstants.get("str_undefined");
        JTextField jTextField = (JTextField)this.getEditorComponent();
        if (expression != null && jTextField != null) {
            string = HuginGUIUtils.convertOctals(expression.expressionToString());
            jTextField.setText(string);
        }
    }

    public boolean editCellAt(int n, int n2) {
        JTextField jTextField;
        boolean bl = super.editCellAt(n, n2);
        if (!this.selectionEnabled && (jTextField = (JTextField)this.getEditorComponent()) != null) {
            jTextField.setHorizontalAlignment(2);
            Caret caret = jTextField.getCaret();
            caret.setSelectionVisible(true);
            caret.setVisible(true);
            jTextField.selectAll();
        }
        return bl;
    }

    class CellEditor
    extends DefaultCellEditor {
        public CellEditor(JTextField jTextField) {
            super(jTextField);
        }

        private class HuginCellEditor
        extends PastingTextField {
            JTextField temp;
            boolean shown;

            public HuginCellEditor(String string) {
                super(string);
                this.shown = false;
                this.temp = new JTextField(string);
            }

            public void paint(Graphics graphics) {
                if (!this.shown) {
                    this.shown = true;
                    JOptionPane.showConfirmDialog(this, "a", "b", 0);
                }
                super.paint(graphics);
            }
        }
    }

    class CellRenderer
    extends PastingTextField
    implements TableCellRenderer {
        public CellRenderer() {
            this.setOpaque(true);
            this.setEditable(false);
            this.setBorder(null);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = object == null ? "" : object.toString();
            this.setText(string);
            if (bl2) {
                this.setHorizontalAlignment(2);
                this.selectAll();
                this.setCaretPosition(string.length());
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setCaretPosition(0);
                this.setHorizontalAlignment(4);
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            return this;
        }
    }
}

