/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Class;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.ContinuousChanceNode;
import COM.hugin.HGUI.DiscreteChanceNode;
import COM.hugin.HGUI.HStroke;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.Link;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.ParameterSensitivityWizard;
import COM.hugin.HGUI.SensitivitySetDialog;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JViewport;

public class SensitivityNetworkPanel
extends NetworkPanel {
    private double threshold = 0.0;
    private ParameterSensitivityWizard spPanel = null;
    private SensitivitySetDialog dialog = null;

    public SensitivityNetworkPanel(SensitivitySetDialog sensitivitySetDialog, ParameterSensitivityWizard parameterSensitivityWizard, Domain domain, HuginProjectFrame huginProjectFrame, MouseListener mouseListener, MouseMotionListener mouseMotionListener) {
        this.dialog = sensitivitySetDialog;
        this.setBackground(Color.white);
        this.loadNet(domain);
        this.showGrid(false);
        this.addMouseListener(mouseListener);
        this.addMouseMotionListener(mouseMotionListener);
        this.projectFrame = huginProjectFrame;
        this.spPanel = parameterSensitivityWizard;
    }

    protected Rectangle getViewRect() {
        Rectangle rectangle = null;
        try {
            rectangle = ((JViewport)this.getParent()).getViewRect();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        return rectangle;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        try {
            for (Node node : this.nodeList) {
                node.actualFillColor = Color.WHITE;
                if (node.actualFillColor == Color.WHITE) {
                    node.textColor = Color.black;
                }
                int n = (int)Math.round(12.0 * node.getScaleFactor());
                COM.hugin.HAPI.Node node2 = node.getAPINode();
                if (!(node2 instanceof DiscreteNode) && !(node2 instanceof COM.hugin.HAPI.ContinuousChanceNode) || !node2.evidenceIsEntered()) continue;
                Stroke stroke = ((Graphics2D)graphics).getStroke();
                Color color = graphics.getColor();
                ((Graphics2D)graphics).setStroke(HStroke.BASIC_STROKE);
                graphics.setColor(Color.white);
                graphics.fillRect(node.getX() + node.getWidth() - n, node.getY() + node.getHeight() - n, n, n);
                graphics.setColor(Color.black);
                graphics.drawRect(node.getX() + node.getWidth() - n, node.getY() + node.getHeight() - n, n, n);
                ((Graphics2D)graphics).setStroke(stroke);
                graphics.setColor(Hugin.mainFrame.preferences.barColors.get(1));
                graphics.setFont(graphics.getFont().deriveFont(1, (float)(12.0 * this.getScaleFactor())));
                graphics.drawString("e", node.getX() + node.getWidth() - n + (int)Math.round(4.0 * this.getScaleFactor()), node.getY() + node.getHeight() - n + (int)Math.round(11.0 * this.getScaleFactor()));
                graphics.setColor(color);
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
    }

    protected void loadNet(NetworkModel networkModel, boolean bl) {
        this.home = networkModel;
        try {
            this.readDomainAttributes();
            NodeList nodeList = networkModel.getNodes();
            for (COM.hugin.HAPI.Node node : nodeList) {
                if (SensitivityNetworkPanel.isOutputClone(node)) continue;
                Node node2 = this.createNodeFromAPINode(node);
                if (node2 != null) {
                    this.nodeList.add(node2);
                    if (networkModel instanceof Class) {
                        node2.setInterfaceType();
                    }
                    this.isEmpty(false);
                    continue;
                }
                new HuginGUIError("NetworkPanel.loadNet", "Unknown node class!");
            }
            for (COM.hugin.HAPI.Node node : nodeList) {
                for (COM.hugin.HAPI.Node node3 : node.getChildren()) {
                    this.linkList.add(new Link(this.getNode(node), this.getNode(node3), this.scaleFactor));
                }
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            this.snapToGrid = true;
            this.showGrid = false;
        }
        this.readNodeAttributes();
        this.updateButtonAndMenuStates();
        this.setGraphicsSize();
    }

    protected void updateSensitivityColors() {
        Node node;
        COM.hugin.HAPI.DiscreteChanceNode discreteChanceNode = this.spPanel.getSelectedHypothesisNode();
        DiscreteChanceNode discreteChanceNode2 = (DiscreteChanceNode)this.getNode(discreteChanceNode);
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        for (Node node2 : this.nodeList) {
            node = this.projectFrame.getNetworkPanel().getNode(node2.getName());
            d3 = Math.min(d3, node.getMinSensitivityValue());
            d = Math.max(d, node.getMaxSensitivityValue());
            d2 = Math.max(d2, node.getAvgSensitivityValue());
        }
        for (Node node2 : this.nodeList) {
            node = this.projectFrame.getNetworkPanel().getNode(node2.getName());
            node2.setMaxSensitivityValue(node.getMaxSensitivityValue());
            node2.setAvgSensitivityValue(node.getAvgSensitivityValue());
            node2.setMinSensitivityValue(node.getMinSensitivityValue());
            if (!(node2 instanceof DiscreteChanceNode) && !(node2 instanceof ContinuousChanceNode)) continue;
            node2.identifySensitivityColors(discreteChanceNode2, d3, d2, d);
        }
        this.paint(this.getGraphics());
    }

    protected double getMinSensitivityValue() {
        double d = Double.POSITIVE_INFINITY;
        for (Node node : this.nodeList) {
            d = Math.min(d, node.getMinSensitivityValue());
        }
        return d;
    }

    protected double getMaxSensitivityValue() {
        double d = Double.NEGATIVE_INFINITY;
        for (Node node : this.nodeList) {
            d = Math.max(d, node.getMaxSensitivityValue());
        }
        return d;
    }

    protected void setThreshold(double d) {
        for (Node node : this.nodeList) {
            if (node instanceof DiscreteChanceNode) {
                boolean bl;
                boolean bl2 = bl = node.getMaxSensitivityValue() >= d;
                if (node.isVisible() != bl) {
                    node.setVisible(bl);
                    node.setVisible(bl);
                    Rectangle rectangle = new Rectangle();
                    rectangle.add(node.getBoundingBox(true));
                    this.repaint(rectangle);
                }
            }
            this.threshold = d;
        }
    }
}

