/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HGUI.HuginAnalysisDialog;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginInsets;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.ParameterSensitivityWizard;
import COM.hugin.HGUI.SensitivityNetworkPanel;
import COM.hugin.HGUI.SensitivitySetSlider;
import COM.hugin.HGUI.TitledPanel;
import COM.hugin.HGUI.ZoomingPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SensitivitySetDialog
extends HuginAnalysisDialog {
    protected HuginProjectFrame projectFrame;
    protected SensitivityNetworkPanel networkPanel = null;
    protected SensitivitySetSlider slider = null;
    protected ParameterSensitivityWizard swPanel = null;
    protected Domain domain = null;
    private ChangeListener parameterListener;
    protected JButton zoomIn;
    protected JButton zoomOut;
    protected JButton zoomFit;
    protected JButton stretchScaleButton;
    protected JButton compressScaleButton;
    protected JLabel statusLabel = null;
    protected JLabel nameLabel = null;
    protected int mode = 0;

    public SensitivitySetDialog(ParameterSensitivityWizard parameterSensitivityWizard, HuginProjectFrame huginProjectFrame) {
        super(parameterSensitivityWizard, huginProjectFrame, HuginGUIConstants.get("SA_Sensitivity_Set_Graph"), false);
        this.projectFrame = huginProjectFrame;
        this.swPanel = parameterSensitivityWizard;
        this.domain = this.domain = huginProjectFrame.getBeliefBarPanel().getDomain();
        this.helpPage = HuginGUIConstants.get("SA_Sensitivity_set_help_page");
        this.setResizable(true);
        HuginGUIUtils.placeNextTo(parameterSensitivityWizard, this);
        this.setContentPane(this.createContent());
        parameterSensitivityWizard.addValueChangeListener(new ValueChangeListener());
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new CloseListener());
        this.setVisible(true);
    }

    protected JPanel createContent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        MouseListener mouseListener = new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Node node = SensitivitySetDialog.this.networkPanel.whichNode(mouseEvent.getPoint());
                if (node != null) {
                    SensitivitySetDialog.this.networkPanel.deselectNodes();
                    try {
                        node.select(false);
                        SensitivitySetDialog.this.networkPanel.selectedNodes.add(node);
                        if (node.getAPINode() instanceof DiscreteChanceNode && SensitivitySetDialog.this.parameterListener != null) {
                            SensitivitySetDialog.this.parameterListener.stateChanged(new ChangeEvent(node.getAPINode()));
                        }
                    }
                    catch (ExceptionHugin exceptionHugin) {}
                } else {
                    SensitivitySetDialog.this.networkPanel.deselectNodes();
                    SensitivitySetDialog.this.statusLabel.setText(" ");
                    SensitivitySetDialog.this.nameLabel.setText(" ");
                }
                SensitivitySetDialog.this.networkPanel.repaint();
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }
        };
        MouseMotionListener mouseMotionListener = new MouseMotionListener(){

            public void mouseDragged(MouseEvent mouseEvent) {
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                block7: {
                    Node node = SensitivitySetDialog.this.networkPanel.whichNode(mouseEvent.getPoint());
                    if (node != null) {
                        SensitivitySetDialog.this.networkPanel.deselectNodes();
                        try {
                            node.select(false);
                            SensitivitySetDialog.this.networkPanel.selectedNodes.add(node);
                            if (node.getAPINode() instanceof DiscreteChanceNode) {
                                Node node2 = SensitivitySetDialog.this.projectFrame.getNetworkPanel().getNode(node.getName());
                                Double d = node2.getMaxSensitivityValue();
                                Double d2 = node2.getMinSensitivityValue();
                                Double d3 = node2.getAvgSensitivityValue();
                                if (d == -1.7976931348623157E308 || d2 == Double.MAX_VALUE) {
                                    SensitivitySetDialog.this.nameLabel.setText("" + node2);
                                    SensitivitySetDialog.this.statusLabel.setText(HuginGUIConstants.get("SA_MSG_Failed"));
                                } else {
                                    SensitivitySetDialog.this.nameLabel.setText("" + node2);
                                    SensitivitySetDialog.this.statusLabel.setText("<html>" + HuginGUIConstants.get("SA_Sensitivity_Values") + "<p>" + HuginGUIConstants.get("SA_MSG_Max_ARG0_Min_ARG1_Avg_ARG2", new String[]{HuginGUIUtils.printDouble(d, SensitivitySetDialog.this.projectFrame.guiFrame.preferences.precision), HuginGUIUtils.printDouble(d2, SensitivitySetDialog.this.projectFrame.guiFrame.preferences.precision), HuginGUIUtils.printDouble(d3, SensitivitySetDialog.this.projectFrame.guiFrame.preferences.precision)}) + "</html>");
                                }
                                break block7;
                            }
                            SensitivitySetDialog.this.nameLabel.setText(" ");
                            SensitivitySetDialog.this.statusLabel.setText(" ");
                        }
                        catch (ExceptionHugin exceptionHugin) {}
                    } else {
                        SensitivitySetDialog.this.networkPanel.deselectNodes();
                        SensitivitySetDialog.this.nameLabel.setText(" ");
                        SensitivitySetDialog.this.statusLabel.setText(" ");
                    }
                }
                SensitivitySetDialog.this.networkPanel.repaint();
            }
        };
        this.networkPanel = new SensitivityNetworkPanel(this, this.swPanel, this.domain, this.projectFrame, mouseListener, mouseMotionListener);
        JScrollPane jScrollPane = new JScrollPane(this.networkPanel);
        jScrollPane.setPreferredSize(new Dimension(450, 300));
        JToolBar jToolBar = new JToolBar();
        JButton jButton = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/magnify-plus.gif")));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    double d = SensitivitySetDialog.this.networkPanel.zoom(1.1111111111111112);
                    SensitivitySetDialog.this.zoomOut.setEnabled(SensitivitySetDialog.this.networkPanel.getScaleFactor() > 0.1);
                    SensitivitySetDialog.this.zoomIn.setEnabled(SensitivitySetDialog.this.networkPanel.getScaleFactor() < 10.0);
                    SensitivitySetDialog.this.statusLabel.setText(HuginGUIConstants.get("str_zoom_ARG0_percent", new String[]{"" + Math.round(d * 100.0)}));
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        jButton.setText("");
        jButton.setToolTipText(HuginGUIConstants.get("str_zoom_in_by_ten_percent"));
        jButton.setMargin(new HuginInsets());
        this.zoomIn = jButton;
        jToolBar.add(jButton);
        jButton = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/magnify-minus.gif")));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    double d = SensitivitySetDialog.this.networkPanel.zoom(0.9);
                    SensitivitySetDialog.this.zoomOut.setEnabled(SensitivitySetDialog.this.networkPanel.getScaleFactor() > 0.1);
                    SensitivitySetDialog.this.zoomIn.setEnabled(SensitivitySetDialog.this.networkPanel.getScaleFactor() < 10.0);
                    SensitivitySetDialog.this.statusLabel.setText(HuginGUIConstants.get("str_zoom_ARG0_percent", new String[]{"" + Math.round(d * 100.0)}));
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        jButton.setText("");
        jButton.setToolTipText("Zoom out by 10%");
        jButton.setMargin(new HuginInsets());
        this.zoomOut = jButton;
        jToolBar.add(jButton);
        jButton = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/zoom-fit.gif")));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    double d = 0.0;
                    d = ZoomingPane.computeFitFactor(SensitivitySetDialog.this.networkPanel);
                    SensitivitySetDialog.this.networkPanel.setScaleFactor(d);
                    SensitivitySetDialog.this.zoomOut.setEnabled(true);
                    SensitivitySetDialog.this.zoomIn.setEnabled(true);
                    SensitivitySetDialog.this.statusLabel.setText(HuginGUIConstants.get("str_scaled_to_fit"));
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        jButton.setText("");
        jButton.setToolTipText(HuginGUIConstants.get("str_zoom_to_fit"));
        jButton.setMargin(new HuginInsets());
        this.zoomFit = jButton;
        jToolBar.add(jButton);
        jToolBar.setFloatable(false);
        this.statusLabel = new JLabel("            \n  ");
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SensitivitySetDialog.this.readSlider();
            }
        };
        this.nameLabel = new JLabel("                      ");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)this.nameLabel, "North");
        jPanel3.add((Component)this.statusLabel, "South");
        TitledPanel titledPanel = new TitledPanel(HuginGUIConstants.get("SA_Sensitivity_set"));
        titledPanel.setLayout(new BorderLayout());
        titledPanel.add((Component)jToolBar, "North");
        titledPanel.add((Component)jScrollPane, "Center");
        titledPanel.add((Component)jPanel3, "South");
        jPanel.add((Component)titledPanel, "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
        this.pack();
        return jPanel;
    }

    protected void readSlider() {
        if (this.slider != null && this.networkPanel != null) {
            double d = this.slider.getValue();
            this.networkPanel.setThreshold(d);
            this.statusLabel.setText(HuginGUIConstants.get("str_threshold_set_to_ARG0", new String[]{"" + HuginGUIUtils.printDouble(d)}));
        }
    }

    protected JButton getOKButton() {
        JButton jButton = new JButton(HuginGUIConstants.get("SA_BUTTON_Update"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SensitivitySetDialog.this.updateColors();
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
                SensitivitySetDialog.this.networkPanel.repaint();
            }
        });
        return jButton;
    }

    protected JButton getCancelButton() {
        JButton jButton = new JButton(HuginGUIConstants.get("cancel_button"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SensitivitySetDialog.this.swPanel.removeValueChangeListener();
                SensitivitySetDialog.this.dispose();
            }
        });
        return jButton;
    }

    public void dispose() {
        this.swPanel.removeValueChangeListener();
        super.dispose();
    }

    protected void updateColors() {
        this.networkPanel.updateSensitivityColors();
    }

    protected JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        this.cancel = this.getCancelButton();
        this.ok = this.getOKButton();
        jPanel3.add(this.cancel);
        this.help = this.getHelpButton();
        jPanel2.add(this.help);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        return jPanel;
    }

    public void addParameterListener(ChangeListener changeListener) {
        this.parameterListener = changeListener;
    }

    protected JButton getPerformButton() {
        return null;
    }

    private class ValueChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            try {
                SensitivitySetDialog.this.updateColors();
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            SensitivitySetDialog.this.networkPanel.repaint();
        }
    }

    private class CloseListener
    implements WindowListener {
        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
            SensitivitySetDialog.this.swPanel.removeValueChangeListener();
        }
    }
}

