/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.WizardConstants;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeListener;

public class SensitivitySetSlider
extends JPanel {
    private JSlider slider = new JSlider(1);
    private TicksPanel ticks;
    private boolean isEnabled = true;
    private boolean canStretch = true;
    private boolean canCompress = true;
    protected double minValue;
    protected double maxValue;
    protected double SCALE_FACTOR = 2.0;
    protected double scaleValue;
    private JButton stretchButton;
    private JButton compressButton;
    private JLabel statusLabel;

    public SensitivitySetSlider(double d, double d2, ChangeListener changeListener, JButton jButton, JButton jButton2, JLabel jLabel) {
        this.slider.setInverted(true);
        this.minValue = d;
        this.maxValue = d2;
        this.scaleValue = (d2 - d) / 10.0;
        this.slider.addChangeListener(changeListener);
        this.slider.setMinimum((int)Math.floor(d));
        this.slider.setMaximum((int)Math.ceil(d2));
        this.slider.setValue((int)Math.rint((d2 - d) / 2.0 + d));
        this.slider.setPaintTicks(true);
        this.slider.setSnapToTicks(true);
        this.slider.setMinorTickSpacing((int)(this.scaleValue / 10.0));
        this.slider.setMajorTickSpacing((int)this.scaleValue);
        this.slider.setPaintLabels(false);
        this.ticks = new TicksPanel();
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.slider);
        this.add(this.ticks);
        this.stretchButton = jButton;
        this.compressButton = jButton2;
        this.statusLabel = jLabel;
        this.canStretch = this.stretchScale();
        this.stretchButton.setEnabled(this.canStretch);
        this.canCompress = this.compressScale();
        this.compressButton.setEnabled(this.canCompress);
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
        this.slider.setEnabled(this.isEnabled);
        this.ticks.setEnabled(this.isEnabled);
    }

    protected JSlider getSlider() {
        return this.slider;
    }

    protected double getValue() {
        return this.slider.getValue();
    }

    protected void setValue(double d) {
        this.slider.setValue((int)Math.rint(d));
    }

    protected boolean stretchScale() {
        this.reScale(this.SCALE_FACTOR);
        return this.scaleValue < 10000.0;
    }

    protected boolean compressScale() {
        this.reScale(1.0 / this.SCALE_FACTOR);
        return this.scaleValue > 1.0;
    }

    private void reScale(double d) {
        this.scaleValue *= d;
        this.slider.setMinorTickSpacing((int)this.scaleValue / 10);
        this.slider.setMajorTickSpacing((int)this.scaleValue);
        this.repaint();
    }

    private class TicksPanel
    extends JPanel {
        static final int MAJOR_TICK = 10;
        static final int MINOR_TICK = 5;
        static final int Y_OFFSET = 7;
        private Color ticksColor = Color.black;
        int lastY;
        int stretchDegree;
        Cursor defaultCursor;
        Cursor scaleCursor;

        public TicksPanel() {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Point point = WizardConstants.SCALE_CURSOR_HOTSPOT;
            Image image = WizardConstants.SCALE_CURSOR_IMAGE;
            this.scaleCursor = toolkit.createCustomCursor(image, point, HuginGUIConstants.get("str_scale_cursor"));
            this.defaultCursor = Cursor.getDefaultCursor();
            this.addMouseListener(new MouseListener());
            this.addMouseMotionListener(new DragListener());
        }

        public void paintComponent(Graphics graphics) {
            double d = SensitivitySetSlider.this.scaleValue;
            double d2 = 0.95 * ((double)SensitivitySetSlider.this.slider.getHeight() / d);
            double d3 = Math.rint(d);
            int n = 0;
            graphics.setColor(this.ticksColor);
            for (double d4 = 0.0; d4 <= d3; d4 += 10.0) {
                int n2 = (int)(d2 * d4) + 7;
                graphics.drawLine(n, n2, n + 10, n2);
                for (double d5 = d4 + 1.0; d5 < d4 + 10.0 && d5 < d3; d5 += 1.0) {
                    n2 = (int)(d2 * d5) + 7;
                    graphics.drawLine(n, n2, n + 5, n2);
                }
            }
        }

        public void setEnabled(boolean bl) {
            this.ticksColor = bl ? Color.black : Color.gray;
        }

        private class DragListener
        extends MouseMotionAdapter {
            private DragListener() {
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (!SensitivitySetSlider.this.canCompress && !SensitivitySetSlider.this.canStretch) {
                    return;
                }
                int n = mouseEvent.getY() - TicksPanel.this.lastY;
                if (SensitivitySetSlider.this.isEnabled && Math.abs(n) > 9) {
                    if (n > 0 && SensitivitySetSlider.this.canStretch) {
                        SensitivitySetSlider.this.stretchButton.setEnabled(SensitivitySetSlider.this.canStretch = SensitivitySetSlider.this.stretchScale());
                        SensitivitySetSlider.this.compressButton.setEnabled(SensitivitySetSlider.this.canCompress = true);
                        ++TicksPanel.this.stretchDegree;
                        this.writeStatus();
                    }
                    if (n < 0 && SensitivitySetSlider.this.canCompress) {
                        SensitivitySetSlider.this.compressButton.setEnabled(SensitivitySetSlider.this.canCompress = SensitivitySetSlider.this.compressScale());
                        SensitivitySetSlider.this.stretchButton.setEnabled(SensitivitySetSlider.this.canStretch = true);
                        --TicksPanel.this.stretchDegree;
                        this.writeStatus();
                    }
                    TicksPanel.this.lastY = mouseEvent.getY();
                }
            }

            private void writeStatus() {
                String string;
                double d = Math.pow(SensitivitySetSlider.this.SCALE_FACTOR, Math.abs(TicksPanel.this.stretchDegree));
                String string2 = string = TicksPanel.this.stretchDegree > 0 ? HuginGUIConstants.get("str_stretched") : HuginGUIConstants.get("str_compressed");
                if (d == 1.0) {
                    SensitivitySetSlider.this.statusLabel.setText("");
                } else {
                    SensitivitySetSlider.this.statusLabel.setText(HuginGUIConstants.get("str_slider_scale_ARG0_by_a_factor_of_ARG1", new String[]{string, "" + d}));
                }
            }
        }

        private class MouseListener
        extends MouseAdapter {
            private MouseListener() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (SensitivitySetSlider.this.isEnabled) {
                    TicksPanel.this.lastY = mouseEvent.getY();
                    TicksPanel.this.stretchDegree = 0;
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                if (SensitivitySetSlider.this.isEnabled && mouseEvent.getModifiers() == 0 && (SensitivitySetSlider.this.canCompress || SensitivitySetSlider.this.canStretch)) {
                    TicksPanel.this.setCursor(TicksPanel.this.scaleCursor);
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (SensitivitySetSlider.this.isEnabled && mouseEvent.getModifiers() == 0 && (SensitivitySetSlider.this.canCompress || SensitivitySetSlider.this.canStretch)) {
                    TicksPanel.this.setCursor(TicksPanel.this.defaultCursor);
                }
            }
        }
    }
}

