/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Attribute;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.DataSourceException;
import COM.hugin.HGUI.DataStream;
import COM.hugin.HGUI.HuginAnalysisDialog;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.NumberField;
import COM.hugin.HGUI.PreProcessingException;
import COM.hugin.HGUI.WizardError;
import COM.hugin.HGUI.WizardNetworkPanel;
import COM.hugin.HGUI.WizardPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class StructuralLearningPanel
extends WizardPanel {
    int nextButtonIndex = -1;
    Domain domain = null;
    WizardNetworkPanel networkPanel;
    DataStream stream = null;
    NumberField significanceLevel;
    JCheckBox skip;
    JCheckBox toLinksCheckBox;
    JComboBox targetNode;
    JComboBox rootNode;
    HuginAnalysisDialog.NodeWrapper selectedTarget = null;
    HuginAnalysisDialog.NodeWrapper selectedRoot = null;
    private int selectedLearningAlgorithm = 2;

    public StructuralLearningPanel(WizardNetworkPanel wizardNetworkPanel, JButton[] jButtonArray, int n) {
        super("Structure Learning", jButtonArray);
        this.setImage(Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("images/structural_learning.jpg")));
        this.nextButtonIndex = n;
        this.networkPanel = wizardNetworkPanel;
        this.setInterior(this.createInterior());
        this.addComponents();
    }

    private Component createInterior() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.significanceLevel = new NumberField(new Double(0.05));
        this.significanceLevel.setHorizontalAlignment(4);
        this.significanceLevel.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                boolean bl = StructuralLearningPanel.this.significanceLevel.isNumber();
                if (bl) {
                    double d = StructuralLearningPanel.this.significanceLevel.getNumber();
                    bl = d > 0.0 && d < 1.0;
                }
                StructuralLearningPanel.this.buttons[StructuralLearningPanel.this.nextButtonIndex].setEnabled(bl);
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new GridLayout(3, 2));
        jPanel3.add(new JLabel("Level of Significance"));
        jPanel3.add(this.significanceLevel);
        JTextArea jTextArea = new JTextArea("The Learning Wizard has now gathered the required information, and is ready to learn the structure of the model for the specified data.");
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setBackground(jPanel.getBackground());
        JTextArea jTextArea2 = new JTextArea("The structure learning may be performed using different algorithms. Please select the one you wish to employ.");
        jTextArea2.setLineWrap(true);
        jTextArea2.setWrapStyleWord(true);
        jTextArea2.setEditable(false);
        jTextArea2.setBackground(jPanel.getBackground());
        JTextArea jTextArea3 = new JTextArea(HuginGUIConstants.get("learning_parameter_info"));
        jTextArea3.setLineWrap(true);
        jTextArea3.setWrapStyleWord(true);
        jTextArea3.setEditable(false);
        jTextArea3.setBackground(jPanel.getBackground());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        JPanel jPanel5 = new JPanel(new BorderLayout());
        JPanel jPanel6 = new JPanel(new GridLayout(4, 1));
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton(HuginGUIConstants.get("PC_LABEL"), this.selectedLearningAlgorithm == 1);
        JRadioButton jRadioButton2 = new JRadioButton(HuginGUIConstants.get("NPC_LABEL"), this.selectedLearningAlgorithm == 2);
        JRadioButton jRadioButton3 = new JRadioButton(HuginGUIConstants.get("CHOWLIU_LABEL"), this.selectedLearningAlgorithm == 5);
        JRadioButton jRadioButton4 = new JRadioButton(HuginGUIConstants.get("TAN_LABEL"), this.selectedLearningAlgorithm == 4);
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StructuralLearningPanel.this.selectedLearningAlgorithm = 1;
                StructuralLearningPanel.this.significanceLevel.setEnabled(true);
                StructuralLearningPanel.this.targetNode.setEnabled(false);
                StructuralLearningPanel.this.rootNode.setEnabled(false);
            }
        });
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StructuralLearningPanel.this.selectedLearningAlgorithm = 2;
                StructuralLearningPanel.this.significanceLevel.setEnabled(true);
                StructuralLearningPanel.this.targetNode.setEnabled(false);
                StructuralLearningPanel.this.rootNode.setEnabled(false);
            }
        });
        jRadioButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StructuralLearningPanel.this.selectedLearningAlgorithm = 5;
                StructuralLearningPanel.this.significanceLevel.setEnabled(false);
                StructuralLearningPanel.this.targetNode.setEnabled(false);
                StructuralLearningPanel.this.rootNode.setEnabled(true);
            }
        });
        jRadioButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StructuralLearningPanel.this.selectedLearningAlgorithm = 4;
                StructuralLearningPanel.this.significanceLevel.setEnabled(false);
                StructuralLearningPanel.this.targetNode.setEnabled(true);
                StructuralLearningPanel.this.rootNode.setEnabled(true);
            }
        });
        this.rootNode = new JComboBox(new HuginAnalysisDialog.NodeListModel((Domain)this.networkPanel.getHome(), null));
        this.rootNode.setSelectedIndex(-1);
        this.rootNode.setEnabled(false);
        this.rootNode.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                StructuralLearningPanel.this.selectedRoot = (HuginAnalysisDialog.NodeWrapper)StructuralLearningPanel.this.rootNode.getSelectedItem();
                if (StructuralLearningPanel.this.selectedRoot != null) {
                    try {
                        Node node = StructuralLearningPanel.this.selectedRoot.node;
                        if (!(node instanceof DiscreteChanceNode)) {
                            JOptionPane.showMessageDialog(StructuralLearningPanel.this, HuginGUIConstants.get("FSA_Only_discrete_chance_nodes_can_be_target"));
                            StructuralLearningPanel.this.rootNode.setSelectedIndex(-1);
                        } else if (StructuralLearningPanel.this.targetNode.getSelectedItem() != null && StructuralLearningPanel.this.selectedRoot.node == StructuralLearningPanel.this.selectedTarget.node) {
                            StructuralLearningPanel.this.targetNode.setSelectedIndex(-1);
                        }
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception.getMessage());
                    }
                }
            }
        });
        JLabel jLabel = new JLabel(HuginGUIConstants.get("Select_root_node"));
        this.targetNode = new JComboBox(new HuginAnalysisDialog.NodeListModel((Domain)this.networkPanel.getHome(), null));
        this.targetNode.setSelectedIndex(-1);
        this.targetNode.setEnabled(false);
        this.targetNode.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                StructuralLearningPanel.this.selectedTarget = (HuginAnalysisDialog.NodeWrapper)StructuralLearningPanel.this.targetNode.getSelectedItem();
                if (StructuralLearningPanel.this.selectedTarget != null) {
                    try {
                        Node node = StructuralLearningPanel.this.selectedTarget.node;
                        if (!(node instanceof DiscreteChanceNode)) {
                            JOptionPane.showMessageDialog(StructuralLearningPanel.this, HuginGUIConstants.get("FSA_Only_discrete_chance_nodes_can_be_root"));
                            StructuralLearningPanel.this.targetNode.setSelectedIndex(-1);
                        } else if (StructuralLearningPanel.this.rootNode.getSelectedItem() != null && StructuralLearningPanel.this.selectedTarget.node == StructuralLearningPanel.this.selectedRoot.node) {
                            StructuralLearningPanel.this.rootNode.setSelectedIndex(-1);
                        }
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception.getMessage());
                    }
                }
            }
        });
        JLabel jLabel2 = new JLabel(HuginGUIConstants.get("Select_target_node"));
        jPanel3.add(jLabel);
        jPanel3.add(this.rootNode);
        jPanel3.add(jLabel2);
        jPanel3.add(this.targetNode);
        jPanel2.add((Component)jPanel3, "North");
        JPanel jPanel7 = new JPanel(new BorderLayout());
        jPanel7.add((Component)jTextArea3, "North");
        jPanel7.add((Component)jPanel2, "Center");
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
        jPanel6.add(jRadioButton2);
        jPanel6.add(jRadioButton);
        jPanel6.add(jRadioButton3);
        jPanel6.add(jRadioButton4);
        jPanel5.add((Component)jPanel6, "North");
        this.skip = new JCheckBox(HuginGUIConstants.get("str_skip_structural_learning"));
        this.skip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (StructuralLearningPanel.this.skip.isSelected()) {
                    StructuralLearningPanel.this.buttons[2].setText("Finish");
                } else {
                    StructuralLearningPanel.this.buttons[2].setText("Next >");
                }
                StructuralLearningPanel.this.toLinksCheckBox.setEnabled(StructuralLearningPanel.this.skip.isSelected());
            }
        });
        this.toLinksCheckBox = new JCheckBox(HuginGUIConstants.get("str_constraints_to_Links"));
        this.toLinksCheckBox.setToolTipText(HuginGUIConstants.get("str_long_constraints_to_Links"));
        this.toLinksCheckBox.setEnabled(false);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 1));
        jPanel8.add(Box.createRigidArea(new Dimension(0, 15)));
        jPanel8.add(this.skip);
        jPanel8.add(this.toLinksCheckBox);
        jPanel4.add((Component)jTextArea2, "North");
        jPanel4.add((Component)jPanel5, "Center");
        jPanel.add(jTextArea);
        jPanel.add(jPanel4);
        jPanel.add(jPanel7);
        jPanel.add(jPanel8);
        return jPanel;
    }

    public boolean getSkip() {
        return this.skip.isSelected();
    }

    public boolean getConstraintsToLinks() {
        return this.toLinksCheckBox.isSelected();
    }

    public int getSelectedLearningAlgorithm() {
        return this.selectedLearningAlgorithm;
    }

    public void back() {
        this.previous.reInitialize();
        if (this.stream == null) {
            return;
        }
        try {
            this.stream.updateVariables();
        }
        catch (ExceptionHugin exceptionHugin) {
            WizardError.showError(HuginGUIConstants.get("str_error"), exceptionHugin.getMessage() + HuginGUIConstants.get("str_lb_the_wizard_may_not_be_able_to_complete"), this);
        }
    }

    public void reInitialize() {
        this.networkPanel.removeLinks();
    }

    public double getSignificanceLevel() {
        return this.significanceLevel.getNumber();
    }

    public DiscreteChanceNode getSelectedRoot() {
        if (this.selectedRoot == null) {
            return null;
        }
        return (DiscreteChanceNode)this.selectedRoot.node;
    }

    public DiscreteChanceNode getSelectedTarget() {
        if (this.selectedTarget == null) {
            return null;
        }
        return (DiscreteChanceNode)this.selectedTarget.node;
    }

    public void setDomain(DataStream dataStream) {
        this.stream = dataStream;
        this.domain = dataStream.getCaseTemplate().getDomain();
    }

    public void learnStructure(DataStream dataStream, int n) throws ExceptionHugin, DataSourceException, PreProcessingException {
        this.stream = dataStream;
        this.domain = dataStream.getCaseTemplate().getDomain();
        this.domain.setSignificanceLevel(this.getSignificanceLevel());
        dataStream.updateVariables();
        switch (n) {
            case 2: {
                this.domain.learnStructureNPC();
                break;
            }
            case 1: {
                this.domain.learnStructure();
                break;
            }
            case 5: {
                this.domain.learnChowLiuTree(this.getSelectedRoot(), null);
                break;
            }
            case 4: {
                this.domain.learnChowLiuTree(this.getSelectedRoot(), this.getSelectedTarget());
                break;
            }
            default: {
                new HuginGUIError("StructuralLearningPanel.learnStructure()", HuginGUIConstants.get("str_unknown_algorithm"));
            }
        }
    }

    public void skipLearning(Domain domain) throws ExceptionHugin, DataSourceException, PreProcessingException {
        this.domain = domain;
        if (this.getConstraintsToLinks()) {
            this.arrowConstraintsToLinks();
        }
    }

    public void arrowConstraintsToLinks() throws ExceptionHugin, DataSourceException, PreProcessingException {
        NodeList nodeList = this.domain.getNodes();
        for (Node node : nodeList) {
            for (Attribute attribute : node.getAttributes()) {
                String string;
                if (attribute.getKey().indexOf("HR_Constraint_") != 0 || (string = attribute.getKey().substring(14)).equals(node.getName())) continue;
                Node node2 = this.domain.getNodeByName(string);
                String string2 = attribute.getValue();
                if (!string2.equalsIgnoreCase("arrow")) continue;
                node2.addParent(node);
            }
        }
    }

    public Domain getDomain() {
        return this.domain;
    }
}

