/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.NodeTableFrame;
import COM.hugin.HGUI.TableHolder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TablePanel
extends JDesktopPane
implements TableHolder {
    private HuginProjectFrame projectFrame;
    private LinkedList<NodeTableFrame> visibleTables = new LinkedList();
    private LinkedList<NodeTableFrame> hiddenTables = new LinkedList();
    protected static final int MAX_TABLE_HEIGHT = 150;
    NodeTableFrame selected = null;
    private Dimension tablesSize = new Dimension();
    private JScrollPane tableScroller;
    private Rectangle tableRect = new Rectangle();

    public TablePanel(HuginProjectFrame huginProjectFrame) {
        this.projectFrame = huginProjectFrame;
        this.setBackground(Color.white);
        this.setDesktopManager(new DefaultDesktopManager(){

            public void endDraggingFrame(JComponent jComponent) {
                TablePanel.this.checkScrolling();
                super.endDraggingFrame(jComponent);
            }

            public void endResizingFrame(JComponent jComponent) {
                TablePanel.this.checkScrolling();
                super.endResizingFrame(jComponent);
            }
        });
        this.tableScroller = new JScrollPane(this);
        this.tableScroller.getHorizontalScrollBar().setUnitIncrement(15);
        this.tableScroller.getVerticalScrollBar().setUnitIncrement(15);
        this.tableScroller.setPreferredSize(new Dimension(200, 200));
    }

    @Override
    public void setSelectedFrame(JInternalFrame jInternalFrame) {
        super.setSelectedFrame(jInternalFrame);
        this.selected = (NodeTableFrame)jInternalFrame;
    }

    @Override
    public NodeTableFrame getSelectedTable() {
        return this.selected;
    }

    @Override
    public void addTable(NodeTableFrame nodeTableFrame) {
        this.addTable(-1, nodeTableFrame);
        this.checkScrolling();
    }

    private void addTable(int n, NodeTableFrame nodeTableFrame) {
        if (this.visibleTables.contains(nodeTableFrame) || this.hiddenTables.contains(nodeTableFrame)) {
            return;
        }
        this.add(nodeTableFrame);
        nodeTableFrame.pack();
        this.hiddenTables.add(nodeTableFrame);
        this.showTable(n, nodeTableFrame);
    }

    @Override
    public void addTable(boolean bl, NodeTableFrame nodeTableFrame) {
        if (this.visibleTables.contains(nodeTableFrame) || this.hiddenTables.contains(nodeTableFrame)) {
            return;
        }
        this.add(nodeTableFrame);
        nodeTableFrame.pack();
        this.hiddenTables.add(nodeTableFrame);
        if (bl) {
            this.showTable(-1, nodeTableFrame);
        }
    }

    @Override
    public void hideTable(NodeTableFrame nodeTableFrame) {
        if (!this.visibleTables.contains(nodeTableFrame)) {
            return;
        }
        nodeTableFrame.setVisible(false);
        this.visibleTables.remove(nodeTableFrame);
        this.hiddenTables.add(nodeTableFrame);
        this.checkScrolling();
    }

    @Override
    public void clear() {
        for (NodeTableFrame nodeTableFrame : this.hiddenTables) {
            nodeTableFrame.dispose();
        }
        this.hiddenTables.clear();
        for (NodeTableFrame nodeTableFrame : this.visibleTables) {
            nodeTableFrame.dispose();
        }
        this.visibleTables.clear();
        this.removeAll();
    }

    @Override
    public void disposeTable(NodeTableFrame nodeTableFrame) {
        if (this.visibleTables.contains(nodeTableFrame)) {
            nodeTableFrame.setVisible(false);
            this.visibleTables.remove(nodeTableFrame);
        } else if (this.hiddenTables.contains(nodeTableFrame)) {
            this.hiddenTables.remove(nodeTableFrame);
        } else {
            nodeTableFrame.dispose();
            return;
        }
        this.remove(nodeTableFrame);
        nodeTableFrame.dispose();
        this.setSelectedFrame(this.getComponentCount() == 0 ? null : this.getAllFrames()[0]);
        this.checkScrolling();
    }

    @Override
    public void updateTable(NodeTableFrame nodeTableFrame, NodeTableFrame nodeTableFrame2) {
        int n = this.visibleTables.indexOf(nodeTableFrame);
        this.disposeTable(nodeTableFrame);
        this.addTable(n, nodeTableFrame2);
        nodeTableFrame2.setLocation(nodeTableFrame.getLocation());
        this.checkScrolling();
    }

    @Override
    public void updateHiddenTable(NodeTableFrame nodeTableFrame, NodeTableFrame nodeTableFrame2) {
        int n = this.hiddenTables.indexOf(nodeTableFrame);
        if (n < 0) {
            return;
        }
        this.disposeTable(nodeTableFrame);
        this.addTable(n, nodeTableFrame2);
        nodeTableFrame2.setLocation(nodeTableFrame.getLocation());
        this.hideTable(nodeTableFrame2);
    }

    @Override
    public void showTable(NodeTableFrame nodeTableFrame, boolean bl) {
        this.showTable(nodeTableFrame);
    }

    @Override
    public void showTable(NodeTableFrame nodeTableFrame) {
        this.showTable(-1, nodeTableFrame);
        this.checkScrolling();
    }

    private void showTable(int n, NodeTableFrame nodeTableFrame) {
        if (!this.hiddenTables.contains(nodeTableFrame)) {
            return;
        }
        nodeTableFrame.setLocation(this.getVacantLocation(nodeTableFrame));
        nodeTableFrame.setVisible(true);
        nodeTableFrame.revalidate();
        nodeTableFrame.repaint();
        this.hiddenTables.remove(nodeTableFrame);
        if (n >= 0) {
            this.visibleTables.add(n, nodeTableFrame);
        } else {
            this.visibleTables.add(nodeTableFrame);
        }
    }

    @Override
    public void arrangeTables() {
        ArrayList<NodeTableFrame> arrayList = new ArrayList<NodeTableFrame>(this.visibleTables);
        for (NodeTableFrame nodeTableFrame : arrayList) {
            this.hideTable(nodeTableFrame);
        }
        for (NodeTableFrame nodeTableFrame : arrayList) {
            this.showTable(-1, nodeTableFrame);
        }
        this.checkScrolling();
    }

    @Override
    public LinkedList<NodeTableFrame> getVisibleTables() {
        return new LinkedList<NodeTableFrame>(this.visibleTables);
    }

    @Override
    public LinkedList<NodeTableFrame> getHiddenTables() {
        return new LinkedList<NodeTableFrame>(this.hiddenTables);
    }

    private Point getVacantLocation(NodeTableFrame nodeTableFrame) {
        boolean bl;
        int n = 0;
        int n2 = nodeTableFrame.getParent().getWidth();
        boolean bl2 = nodeTableFrame.getPreferredSize().width > n2;
        boolean bl3 = bl = nodeTableFrame.getPreferredSize().height > 150;
        if (bl2 || bl) {
            int n3 = bl2 ? n2 : nodeTableFrame.getPreferredSize().width;
            int n4 = bl ? 150 : nodeTableFrame.getPreferredSize().height;
            nodeTableFrame.reshape(nodeTableFrame.getX(), nodeTableFrame.getY(), n3, n4);
        }
        int n5 = 0;
        while (n5 < Integer.MAX_VALUE) {
            int n6 = this.minX(n5);
            while (n6 < Integer.MAX_VALUE && n6 + nodeTableFrame.getWidth() < n2) {
                if (this.tableFits(nodeTableFrame, n6, n5)) {
                    return new Point(n6, n5);
                }
                n6 = this.nextX(n6, n5);
            }
            n = n5;
            n5 = this.minYGreaterThan(n5);
        }
        return new Point(0, n);
    }

    private int minYGreaterThan(int n) {
        if (this.visibleTables.size() == 0) {
            return Integer.MAX_VALUE;
        }
        int n2 = Integer.MAX_VALUE;
        for (NodeTableFrame nodeTableFrame : this.visibleTables) {
            int n3 = nodeTableFrame.getY() + nodeTableFrame.getHeight();
            if (n3 <= n || n3 >= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private int minX(int n) {
        if (this.visibleTables.size() == 0) {
            return 0;
        }
        if (n == 0) {
            int n2 = 0;
            for (NodeTableFrame nodeTableFrame : this.visibleTables) {
                if (!nodeTableFrame.inVicinityOfY(n)) continue;
                n2 = Math.max(n2, nodeTableFrame.getX() + nodeTableFrame.getWidth());
            }
            return n2;
        }
        int n3 = Integer.MAX_VALUE;
        for (NodeTableFrame nodeTableFrame : this.visibleTables) {
            if (!nodeTableFrame.inVicinityOfY(n - nodeTableFrame.getHeight())) continue;
            n3 = Math.min(n3, nodeTableFrame.getX());
        }
        return n3;
    }

    private int nextX(int n, int n2) {
        for (NodeTableFrame nodeTableFrame : this.visibleTables) {
            if (!nodeTableFrame.inVicinityOf(n, n2)) continue;
            return nodeTableFrame.getX() + nodeTableFrame.getWidth();
        }
        return Integer.MAX_VALUE;
    }

    private boolean tableFits(NodeTableFrame nodeTableFrame, int n, int n2) {
        if (n + nodeTableFrame.getWidth() > nodeTableFrame.getParent().getWidth()) {
            return false;
        }
        this.tableRect.setBounds(n, n2, nodeTableFrame.getWidth(), nodeTableFrame.getHeight());
        for (NodeTableFrame nodeTableFrame2 : this.visibleTables) {
            if (!this.tableRect.intersects(this.getTableRect(nodeTableFrame2))) continue;
            return false;
        }
        return true;
    }

    private Rectangle getTableRect(NodeTableFrame nodeTableFrame) {
        return new Rectangle(nodeTableFrame.getX(), nodeTableFrame.getY(), nodeTableFrame.getWidth(), nodeTableFrame.getHeight());
    }

    @Override
    public void checkScrolling() {
        this.setTablesSize();
        this.setPreferredSize(this.tablesSize);
        this.revalidate();
    }

    private void setTablesSize() {
        int n = 0;
        int n2 = 0;
        for (NodeTableFrame nodeTableFrame : this.visibleTables) {
            n = Math.max(n, nodeTableFrame.getX() + nodeTableFrame.getWidth());
            n2 = Math.max(n2, nodeTableFrame.getY() + nodeTableFrame.getHeight());
        }
        this.tablesSize.setSize(n, n2);
    }

    @Override
    public void setMaxTableWidth(int n, boolean bl) {
        ArrayList<NodeTableFrame> arrayList = new ArrayList<NodeTableFrame>(this.visibleTables);
        ArrayList<NodeTableFrame> arrayList2 = new ArrayList<NodeTableFrame>(this.hiddenTables);
        for (NodeTableFrame nodeTableFrame : arrayList) {
            if (nodeTableFrame.getX() + nodeTableFrame.getWidth() <= n) continue;
            try {
                nodeTableFrame.getNode().updateTable(bl);
            }
            catch (ExceptionHugin exceptionHugin) {
                new HuginGUIError(exceptionHugin);
            }
        }
        for (NodeTableFrame nodeTableFrame : arrayList2) {
            if (nodeTableFrame.getX() + nodeTableFrame.getWidth() <= n) continue;
            try {
                nodeTableFrame.getNode().updateTable(bl);
            }
            catch (ExceptionHugin exceptionHugin) {
                new HuginGUIError(exceptionHugin);
            }
        }
    }

    @Override
    public void update(LinkedList<NodeTableFrame> linkedList, LinkedList<NodeTableFrame> linkedList2) throws ExceptionHugin {
        while (this.visibleTables.size() > 0) {
            this.hideTable(this.visibleTables.get(0));
        }
        for (NodeTableFrame nodeTableFrame : linkedList) {
            nodeTableFrame.restoreTable();
            this.addTable(false, nodeTableFrame);
            this.showTable(nodeTableFrame);
        }
        for (NodeTableFrame nodeTableFrame : linkedList2) {
            nodeTableFrame.restoreTable();
            this.addTable(false, nodeTableFrame);
        }
    }

    @Override
    public boolean isTableVisible(NodeTableFrame nodeTableFrame) {
        return this.visibleTables.contains(nodeTableFrame);
    }
}

