/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.UtilityNode;
import COM.hugin.HGUI.ColorChart;
import COM.hugin.HGUI.ModeGraphicTable;
import COM.hugin.HGUI.NodeTable;
import COM.hugin.HGUI.NodeTableFrame;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TableWrapper
extends JPanel {
    private ColorChart visibleCPT = null;
    public NodeTable nodeTable = null;
    JSplitPane contents;
    JComponent visualizedTable;
    JScrollPane tableScrollPane;

    public TableWrapper(JComponent jComponent, NodeTable nodeTable, ColorChart colorChart) {
        this.visibleCPT = colorChart;
        this.nodeTable = nodeTable;
        this.visualizedTable = jComponent;
        this.setLayout(new GridLayout(1, 1));
        try {
            Object object;
            if (!(this.nodeTable.getGUINode().getAPINode() instanceof UtilityNode)) {
                object = (DiscreteNode)this.nodeTable.getGUINode().getAPINode();
            }
            this.contents = new JSplitPane(1, this.visibleCPT, jComponent);
            this.contents.setDividerLocation(0);
            this.add(this.contents);
            object = new NodeTableFrame.TableChangeListener(){

                public void tableChanged() {
                    TableWrapper.this.visibleCPT.repaint();
                }
            };
            this.nodeTable.addTableChangeListener((NodeTableFrame.TableChangeListener)object);
        }
        catch (Exception exception) {
            this.add(jComponent);
        }
    }

    public TableWrapper() {
    }

    public void wrapInScrollPane() {
        JPanel jPanel;
        if (this.visibleCPT instanceof ModeGraphicTable) {
            jPanel = (ModeGraphicTable)this.visibleCPT;
            ((ModeGraphicTable)jPanel).addSelectedListener(new SelectedListener());
        }
        jPanel = new JPanel(new GridLayout(1, 1));
        jPanel.add(this.visualizedTable);
        this.tableScrollPane = new JScrollPane();
        this.tableScrollPane.setViewportView(jPanel);
        this.visualizedTable.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth() - 5, (int)this.visualizedTable.getPreferredSize().getHeight()));
        if (this.contents != null) {
            this.contents.remove(this.visualizedTable);
            this.contents.setRightComponent(this.tableScrollPane);
            this.contents.validate();
        } else {
            this.removeAll();
            this.add(this.tableScrollPane);
        }
    }

    public void scrollToSelection() {
        if (this.tableScrollPane != null) {
            int n = this.nodeTable.getTable().getSelectedRow();
            int n2 = this.nodeTable.getTable().getSelectedColumn();
            int n3 = this.nodeTable.getTable().getRowHeight();
            JViewport jViewport = this.tableScrollPane.getViewport();
            int n4 = 0;
            if (this.nodeTable.showExpressions()) {
                n4 = this.nodeTable.getExpressionTable().getHeight();
            }
            n4 += this.nodeTable.getTable().getTableHeader().getPreferredSize().height;
            Rectangle rectangle = this.nodeTable.getTable().getCellRect(n, 1, true);
            if (jViewport.getHeight() < this.nodeTable.getHeight()) {
                jViewport.setViewPosition(new Point(0, (int)rectangle.getY() + n4));
                this.tableScrollPane.validate();
            }
            this.contents.validate();
        }
    }

    private class SelectedListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            int n = TableWrapper.this.nodeTable.getTable().getSelectedRow();
            int n2 = TableWrapper.this.nodeTable.getTable().getSelectedColumn();
            int n3 = TableWrapper.this.nodeTable.getTable().getRowHeight();
            JViewport jViewport = TableWrapper.this.tableScrollPane.getViewport();
            int n4 = 0;
            if (TableWrapper.this.nodeTable.showExpressions()) {
                n4 = TableWrapper.this.nodeTable.getExpressionTable().getHeight();
            }
            n4 += TableWrapper.this.nodeTable.getTable().getTableHeader().getPreferredSize().height;
            Rectangle rectangle = TableWrapper.this.nodeTable.getTable().getCellRect(n, 1, true);
            if (jViewport.getHeight() < TableWrapper.this.nodeTable.getHeight()) {
                jViewport.setViewPosition(new Point(0, (int)rectangle.getY() + n4));
                TableWrapper.this.tableScrollPane.validate();
            }
            TableWrapper.this.contents.validate();
        }
    }
}

