/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.UncertainEdge;
import COM.hugin.HGUI.AmbiguousRegion;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.Link;
import COM.hugin.HGUI.Node;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.EventListener;
import java.util.LinkedList;

public class UncertainLink
extends Link {
    private LinkedList<LinkSelectionListener> selectionListeners;
    private boolean partSelected = false;
    private UncertainEdge edge;
    private AmbiguousRegion region;

    public UncertainLink(Node node, Node node2, UncertainEdge uncertainEdge, double d, AmbiguousRegion ambiguousRegion) {
        super(node, node2, d);
        this.edge = uncertainEdge;
        this.selectionListeners = new LinkedList();
        this.isDirected(false);
        this.region = ambiguousRegion;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void select() {
        if (this.isSelected()) {
            return;
        }
        super.select();
        this.partSelected = true;
        this.fireUncertainLinkSelected(true);
    }

    public void coSelect() {
        this.partSelected = true;
        if (this.isSelected()) {
            return;
        }
        this.selected = false;
    }

    public void deselect() {
        this.partSelected = false;
        if (!this.isSelected()) {
            return;
        }
        super.deselect();
        this.fireUncertainLinkSelected(false);
    }

    public void coDeselect() {
        this.partSelected = false;
        if (!this.isSelected()) {
            return;
        }
        super.deselect();
    }

    public boolean isSelected() {
        return this.selected;
    }

    protected UncertainEdge getEdge() {
        return this.edge;
    }

    protected AmbiguousRegion getAmbiguousRegion() {
        return this.region;
    }

    public void addLinkSelectionListener(LinkSelectionListener linkSelectionListener) {
        this.selectionListeners.add(linkSelectionListener);
    }

    public void removeLinkSelectionListener(LinkSelectionListener linkSelectionListener) {
        this.selectionListeners.remove(linkSelectionListener);
    }

    protected void fireUncertainLinkSelected(boolean bl) {
        if (bl) {
            for (LinkSelectionListener linkSelectionListener : this.selectionListeners) {
                linkSelectionListener.linkSelected(this);
            }
        } else {
            for (LinkSelectionListener linkSelectionListener : this.selectionListeners) {
                linkSelectionListener.linkDeselected(this);
            }
        }
    }

    public void paint(Graphics2D graphics2D) {
        boolean bl = this.selected;
        this.selected = this.partSelected;
        super.paint(graphics2D);
        this.selected = bl;
        if (!this.selected && this.partSelected) {
            this.outline(graphics2D);
        }
    }

    private void outline(Graphics2D graphics2D) {
        if (!this.isVisible() || this.x1 == this.x2 && this.y1 == this.y2) {
            return;
        }
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(((BasicStroke)stroke).getLineWidth() - 2.0f));
        graphics2D.setPaint(Color.white);
        if (this.isDirected()) {
            double d = Point2D.distance(this.x1, this.y1, this.x2, this.y2);
            double d2 = (double)(this.x2 - this.x1) / d;
            double d3 = (double)(this.y2 - this.y1) / d;
            int n = (int)Math.rint(this.getScaleFactor() * (double)((BasicStroke)stroke).getLineWidth());
            graphics2D.drawLine((int)this.x1, (int)this.y1, (int)((double)this.x2 - (double)n * d2), (int)((double)this.y2 - (double)n * d3));
            this.drawArrowHead(graphics2D, d2, d3, n);
        } else {
            graphics2D.drawLine((int)this.x1, (int)this.y1, (int)this.x2, (int)this.y2);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof UncertainLink)) {
            return false;
        }
        if (this.isDirected()) {
            return this.parent.getName().equals(((Link)object).parent.getName()) && this.child.getName().equals(((Link)object).child.getName());
        }
        return !(!this.parent.getName().equals(((Link)object).parent.getName()) && !this.parent.getName().equals(((Link)object).child.getName()) || !this.child.getName().equals(((Link)object).parent.getName()) && !this.child.getName().equals(((Link)object).child.getName()));
    }

    public String toString() {
        try {
            return this.parent.getName() + " - " + this.child.getName();
        }
        catch (Exception exception) {
            return HuginGUIConstants.get("str_error");
        }
    }

    public static interface LinkSelectionListener
    extends EventListener {
        public void linkSelected(Link var1);

        public void linkDeselected(Link var1);
    }
}

