/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionIO;
import COM.hugin.HAPI.ExceptionInappropriateArguments;
import COM.hugin.HAPI.ExceptionInsufficientStateRange;
import COM.hugin.HAPI.ExceptionInvalidExpression;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.Table;
import COM.hugin.HAPI.UtilityNode;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.NodeTableModel;

public class UtilityNodeTableModel
extends NodeTableModel {
    UtilityNode node;
    Table table;
    private boolean invalidTable;
    boolean dataMode = true;

    public void setNode(Node node) {
        this.node = (UtilityNode)node;
        this.fireTableStructureChanged();
    }

    public void setDataMode(boolean bl) {
        this.dataMode = bl;
    }

    public void setExpressionMode(boolean bl) {
        this.expressionMode = bl;
    }

    public void invalidateModel() {
        this.invalidTable = true;
        this.fireTableRowsUpdated(0, this.getColumnCount());
    }

    public boolean getInvalidTable() {
        return this.invalidTable;
    }

    public void generate() throws ExceptionHugin {
        if (this.node == null) {
            return;
        }
        try {
            if (this.expressionMode) {
                this.node.generateTable();
            }
            this.invalidTable = false;
        }
        catch (ExceptionInvalidExpression exceptionInvalidExpression) {
            this.invalidTable = true;
            exceptionInvalidExpression.fillInStackTrace();
            throw exceptionInvalidExpression;
        }
        catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
            this.invalidTable = true;
            exceptionInappropriateArguments.fillInStackTrace();
            throw exceptionInappropriateArguments;
        }
        catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
            this.invalidTable = true;
            exceptionInsufficientStateRange.fillInStackTrace();
            throw exceptionInsufficientStateRange;
        }
        catch (ExceptionIO exceptionIO) {
            this.invalidTable = true;
            exceptionIO.fillInStackTrace();
            throw exceptionIO;
        }
        finally {
            this.fireTableStructureChanged();
        }
    }

    public Object getValueAt(int n, int n2) {
        if (!this.dataMode) {
            return HuginGUIConstants.get("str_utility");
        }
        if (n2 < 0) {
            return "...";
        }
        if (!this.invalidTable) {
            try {
                return new Double(this.node.getTable().getDataItem(n2));
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
        return "?";
    }

    public void setValueAt(Object object, int n, int n2) {
        if (!this.dataMode || n2 < 0) {
            return;
        }
        try {
            this.node.getTable().setDataItem(n2, Double.parseDouble(object.toString()));
            this.fireModelDataChanged();
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isCellEditable(int n, int n2) {
        return this.dataMode && n2 >= 0 && !this.expressionMode;
    }

    public int getRowCount() {
        return this.node == null ? 0 : 1;
    }

    public void restore() {
        this.invalidTable = false;
        super.restore();
    }

    public int getColumnCount() {
        if (this.node != null) {
            try {
                return this.node.getTable().getSize();
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
        return 0;
    }
}

