/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.Node;
import COM.hugin.HGUI.BeliefBarPanel;
import COM.hugin.HGUI.HuginAnalysisDialog;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.VOIResultPanel;
import COM.hugin.HGUI.VOIScore;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VOIDialog
extends HuginAnalysisDialog {
    DiscreteChanceNode target;
    VOIResultPanel voiResult;
    JTextArea targetEntropy = null;
    private JTabbedPane tabs = null;
    private int voiAnalysisIndex = 0;
    private int infoVarsIndex = 1;
    JList voiList;
    Vector<VOIScore> voiListData;

    public VOIDialog(HuginProjectFrame huginProjectFrame, String string, boolean bl) {
        super(huginProjectFrame, string, bl);
    }

    public VOIDialog(HuginProjectFrame huginProjectFrame, DiscreteChanceNode discreteChanceNode) {
        super(huginProjectFrame, HuginGUIConstants.get("VOI"), true);
        this.helpPage = HuginGUIConstants.get("VOI_help_page");
        this.target = discreteChanceNode;
        this.setResizable(true);
        try {
            this.setContentPane(this.createContent());
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
            this.dispose();
        }
        this.groupDefiner = new HuginAnalysisDialog.GroupDefiner(this, huginProjectFrame.getNetworkPanel(), this.target);
        this.groupDefiner.pack();
    }

    @Override
    protected JPanel createContent() throws ExceptionHugin {
        return this.createContent(HuginGUIConstants.get("VOI_Analysis"), HuginGUIConstants.get("VOI_Info_Vars"));
    }

    protected JPanel createContent(String string, String string2) throws ExceptionHugin {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tabs = new JTabbedPane();
        this.tabs.add((Component)this.createAnalysisTab(), string);
        this.tabs.add((Component)this.createInfoVarsTab(), string2);
        this.tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (VOIDialog.this.tabs.getSelectedIndex() == VOIDialog.this.infoVarsIndex) {
                    VOIDialog.this.perform.setEnabled(false);
                } else {
                    VOIDialog.this.perform.setEnabled(true);
                }
            }
        });
        jPanel.add(this.tabs);
        jPanel.add((Component)this.getButtonPanel(1), "South");
        this.pack();
        return jPanel;
    }

    protected JPanel createAnalysisTab() {
        Object object;
        Object object2;
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        JTextArea jTextArea = null;
        try {
            object = object2 = HuginGUIUtils.getNodeTitle(this.target);
            jTextArea = new JTextArea((String)object + "\n");
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setEditable(false);
            jTextArea.setBackground(jPanel2.getBackground());
            double d = this.target.getEntropy();
            String string = "H(" + (String)object2 + ") = " + HuginGUIUtils.printDouble(d, this.projectFrame.guiFrame.preferences.precision);
            this.targetEntropy = new JTextArea(string);
            this.targetEntropy.setLineWrap(true);
            this.targetEntropy.setWrapStyleWord(true);
            this.targetEntropy.setEditable(false);
            this.targetEntropy.setBackground(jPanel2.getBackground());
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
        jPanel2.add(jTextArea);
        jPanel2.add(this.targetEntropy);
        object2 = new JPanel(new BorderLayout());
        ((Container)object2).add((Component)jPanel2, "North");
        this.voiListData = new Vector();
        this.voiResult = new VOIResultPanel(this.target, this.projectFrame);
        this.voiResult.setBorder(BorderFactory.createLoweredBevelBorder());
        object = new JScrollPane(this.voiResult);
        ((JComponent)object).setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("VOI_MutualInformation")));
        JScrollPane jScrollPane = new JScrollPane((Component)object2);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("VOI_HypothesisVariable")));
        jScrollPane.setPreferredSize(new Dimension(180, 180));
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, (Component)object);
        jPanel.add(jSplitPane);
        return jPanel;
    }

    @Override
    protected JButton getPerformButton() {
        JButton jButton = new JButton(HuginGUIConstants.get("ANALYSIS_Calculate"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string;
                    String string2 = string = HuginGUIUtils.getNodeTitle(VOIDialog.this.target);
                    double d = VOIDialog.this.target.getEntropy();
                    String string3 = "H(" + string + ") = " + HuginGUIUtils.printDouble(d, VOIDialog.this.projectFrame.guiFrame.preferences.precision);
                    VOIDialog.this.targetEntropy.setText(string3);
                    VOIDialog.this.voiListData.clear();
                    BeliefBarPanel beliefBarPanel = VOIDialog.this.projectFrame.getBeliefBarPanel();
                    for (HuginAnalysisDialog.ListItem listItem : VOIDialog.this.getInfoVars()) {
                        Node node = listItem.getNode();
                        try {
                            double d2 = node.getMutualInformation(VOIDialog.this.target);
                            if (d2 < Math.pow(10.0, -6.0)) {
                                d2 = 0.0;
                            }
                            VOIScore vOIScore = new VOIScore(node, VOIDialog.this.target, d2);
                            VOIDialog.this.voiListData.add(vOIScore);
                        }
                        catch (Exception exception) {}
                    }
                    Collections.sort(VOIDialog.this.voiListData);
                    VOIDialog.this.voiResult.setResult(VOIDialog.this.voiListData, d);
                    VOIDialog.this.voiResult.revalidate();
                    VOIDialog.this.voiResult.repaint();
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        return jButton;
    }

    private Vector<HuginAnalysisDialog.ListItem> getInfoVars() {
        Vector<HuginAnalysisDialog.ListItem> vector = new Vector<HuginAnalysisDialog.ListItem>();
        if (this.checks[this.checks.length - 1].isSelected()) {
            vector.addAll(this.customGroupData);
        }
        for (int i = 0; i < this.checks.length - 1; ++i) {
            if (!this.checks[i].isSelected()) continue;
            for (Node node : this.groups[i].getNodes()) {
                HuginAnalysisDialog.ListItem listItem;
                if (node == this.target || vector.contains(listItem = new HuginAnalysisDialog.ListItem(node))) continue;
                vector.add(listItem);
            }
        }
        return vector;
    }

    @Override
    protected Vector<HuginAnalysisDialog.ListItem> customGroupNodes(Node node) {
        return this.customGroupNodes(node, true);
    }

    @Override
    protected boolean includeCG() {
        return true;
    }
}

