/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteDecisionNode;
import COM.hugin.HAPI.Node;
import COM.hugin.HGUI.BeliefBarPanel;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.VOIScore;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VOIResultPanel
extends JPanel {
    Vector<VOIScore> data = null;
    private static final int BARLENGTH = 200;
    double max = 0.0;
    double step = 0.0;
    Node target = null;
    final BeliefBarPanel beliefBarPanel;

    VOIResultPanel(Node node, HuginProjectFrame huginProjectFrame) {
        this.target = node;
        this.beliefBarPanel = huginProjectFrame.getBeliefBarPanel();
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getY();
                int n2 = VOIResultPanel.this.getHeight() - VOIResultPanel.this.getInsets().bottom - 25;
                if (VOIResultPanel.this.data != null) {
                    for (int i = VOIResultPanel.this.data.size() - 1; i >= 0; --i) {
                        if (n < n2 + 3 && n > n2 - 12) {
                            VOIScore vOIScore = VOIResultPanel.this.data.get(i);
                            Node node = vOIScore.getNode();
                            VOIResultPanel.this.beliefBarPanel.collapseTree();
                            VOIResultPanel.this.beliefBarPanel.setSelectedNode(node);
                            VOIResultPanel.this.beliefBarPanel.expandNode(node);
                            return;
                        }
                        n2 -= 20;
                    }
                }
            }
        });
    }

    public void setResult(Vector<VOIScore> vector, double d) {
        this.data = vector;
        this.max = d;
    }

    public void setResult(Vector<VOIScore> vector, double d, double d2) {
        this.data = vector;
        this.max = d;
        this.step = d2;
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (this.data == null) {
            return new Dimension(100, 100);
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            for (int i = 0; i < this.data.size(); ++i) {
                VOIScore vOIScore = this.data.get(i);
                n = Math.max(n, SwingUtilities.computeStringWidth(fontMetrics, HuginGUIUtils.getNodeTitle(vOIScore.getNode())));
                n2 = Math.max(n2, SwingUtilities.computeStringWidth(fontMetrics, "" + HuginGUIUtils.printDouble(vOIScore.getValue(), Hugin.mainFrame.preferences.precision)));
            }
            n3 = 25 + 20 * this.data.size();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return new Dimension(5 + n + 15 + 200 + 5 + n2, n3);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.data == null) {
            return;
        }
        try {
            int n = 0;
            int n2 = this.getHeight() - this.getInsets().bottom - 25;
            graphics.setColor(Color.black);
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            for (int i = this.data.size() - 1; i >= 0; --i) {
                VOIScore vOIScore = this.data.get(i);
                graphics.drawString(HuginGUIUtils.getNodeTitle(vOIScore.getNode()), 5, n2);
                n = Math.max(n, SwingUtilities.computeStringWidth(fontMetrics, HuginGUIUtils.getNodeTitle(vOIScore.getNode())));
                n2 -= 20;
                this.max = Math.max(this.max, vOIScore.getValue());
            }
            if (this.data.size() > 0) {
                Object object;
                int n3;
                graphics.drawLine(n + 5, n2, n + 5, this.getHeight() - this.getInsets().bottom - 15);
                graphics.drawLine(n, this.getHeight() - this.getInsets().bottom - 20, n + 200 + 10, this.getHeight() - this.getInsets().bottom - 20);
                double d = 0.0;
                if (this.target instanceof DiscreteChanceNode) {
                    graphics.setColor(Color.gray);
                    for (n3 = 50; n3 <= 200; n3 += 50) {
                        graphics.drawLine(n + 5 + n3, n2, n + 5 + n3, this.getHeight() - this.getInsets().bottom - 15);
                    }
                    graphics.drawString("0", n + 5 - SwingUtilities.computeStringWidth(fontMetrics, "0") / 2, this.getHeight() - this.getInsets().bottom);
                    graphics.drawString("", n + 5 + 50 - SwingUtilities.computeStringWidth(fontMetrics, "0") / 2, this.getHeight() - this.getInsets().bottom);
                    graphics.drawString("H(T)/2", n + 5 + 100 - SwingUtilities.computeStringWidth(fontMetrics, "H(T)/2") / 2, this.getHeight() - this.getInsets().bottom);
                    graphics.drawString("", n + 5 + 150 - SwingUtilities.computeStringWidth(fontMetrics, "0") / 2, this.getHeight() - this.getInsets().bottom);
                    graphics.drawString("H(T)", n + 5 + 200 - SwingUtilities.computeStringWidth(fontMetrics, "H(T)") / 2, this.getHeight() - this.getInsets().bottom);
                    d = this.max;
                } else if (this.target instanceof DiscreteDecisionNode) {
                    int n4;
                    n3 = 0;
                    n3 = Math.abs(this.step) <= 0.001 ? 1 : (int)(this.max / this.step) + 1;
                    graphics.setColor(Color.gray);
                    for (n4 = 200 / n3; n4 <= 200; n4 += 200 / n3) {
                        graphics.drawLine(n + 5 + n4, n2, n + 5 + n4, this.getHeight() - this.getInsets().bottom - 15);
                    }
                    for (n4 = 0; n4 < n3; ++n4) {
                        graphics.drawString("", n + 5 + 200 / n3 - SwingUtilities.computeStringWidth(fontMetrics, "0") / 2, this.getHeight() - this.getInsets().bottom);
                    }
                    graphics.drawString("0", n + 5 - SwingUtilities.computeStringWidth(fontMetrics, "0") / 2, this.getHeight() - this.getInsets().bottom);
                    object = "";
                    if (n3 > 1) {
                        object = (String)object + "" + n3 + "*";
                    }
                    object = (String)object + "|meu(D)|";
                    graphics.drawString((String)object, n + 5 + 200 - SwingUtilities.computeStringWidth(fontMetrics, (String)object) / 2, this.getHeight() - this.getInsets().bottom);
                    d = (double)n3 * this.step;
                }
                n2 = this.getHeight() - this.getInsets().bottom - 25;
                for (n3 = this.data.size() - 1; n3 >= 0; --n3) {
                    object = this.data.get(n3);
                    graphics.setColor(Color.black);
                    graphics.drawString("" + HuginGUIUtils.printDouble(((VOIScore)object).getValue(), Hugin.mainFrame.preferences.precision), n + 5 + 200 + 5, n2);
                    graphics.setColor(Color.green);
                    graphics.fillRect(n + 5 + 1, n2 - 12, (int)(200.0 * (((VOIScore)object).getValue() / d)), 15);
                    n2 -= 20;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

