/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.PastingTextField;
import COM.hugin.HGUI.TitledPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ZoomingPane
extends JDialog {
    private ZoomingPane self;
    private PastingTextField zoomField;
    private int zoom;
    private HuginProjectFrame project;
    private JRadioButton mag200 = new JRadioButton("200%");
    private JRadioButton mag100 = new JRadioButton("100%");
    private JRadioButton mag75 = new JRadioButton("75%");
    private JRadioButton mag50 = new JRadioButton("50%");
    private JRadioButton mag25 = new JRadioButton("25%");
    private JRadioButton magFit = new JRadioButton(HuginGUIConstants.get("str_fit_network"));
    private JRadioButton magSelected = new JRadioButton(HuginGUIConstants.get("str_zoom_to_selected"));
    private JRadioButton magCustom = new JRadioButton(HuginGUIConstants.get("str_custom"));
    private static final int FIT_MARGIN = 10;

    public ZoomingPane(HuginProjectFrame huginProjectFrame) {
        super(Hugin.mainFrame, HuginGUIConstants.get("ZOOMING_PANE_TITLE"), true);
        this.self = this;
        this.project = huginProjectFrame;
        this.mag200.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ZoomingPane.this.zoom = 200;
                ZoomingPane.this.zoomField.setText(String.valueOf(ZoomingPane.this.zoom));
            }
        });
        this.mag200.setToolTipText(HuginGUIConstants.get("str_try_ctlr_arrow_up_to_zoom_in"));
        this.mag100.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ZoomingPane.this.zoom = 100;
                ZoomingPane.this.zoomField.setText(String.valueOf(ZoomingPane.this.zoom));
            }
        });
        this.mag100.setToolTipText(HuginGUIConstants.get("str_try_cltr_numpad5_to_zoom_to_hundred_percent"));
        this.mag75.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ZoomingPane.this.zoom = 75;
                ZoomingPane.this.zoomField.setText(String.valueOf(ZoomingPane.this.zoom));
            }
        });
        this.mag75.setToolTipText(HuginGUIConstants.get("str_try_ctlr_arrow_down_to_zoom_out"));
        this.mag50.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ZoomingPane.this.zoom = 50;
                ZoomingPane.this.zoomField.setText(String.valueOf(ZoomingPane.this.zoom));
            }
        });
        this.mag50.setToolTipText(HuginGUIConstants.get("str_try_ctlr_arrow_down_to_zoom_out"));
        this.mag25.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ZoomingPane.this.zoom = 25;
                ZoomingPane.this.zoomField.setText(String.valueOf(ZoomingPane.this.zoom));
            }
        });
        this.mag25.setToolTipText(HuginGUIConstants.get("str_try_ctlr_arrow_down_to_zoom_out"));
        this.magFit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ZoomingPane.this.zoom = ZoomingPane.this.computeFitZoom();
                ZoomingPane.this.zoomField.setText(String.valueOf(ZoomingPane.this.zoom));
            }
        });
        this.magFit.setToolTipText(HuginGUIConstants.get("str_fit_network_to_window"));
        if (huginProjectFrame.getNetworkPanel().nodeList.size() == 0) {
            this.magFit.setEnabled(false);
        }
        this.magSelected.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ZoomingPane.this.zoom = ZoomingPane.computeSelectedFitZoom(ZoomingPane.this.project.getNetworkPanel());
                ZoomingPane.this.zoomField.setText(String.valueOf(ZoomingPane.this.zoom));
            }
        });
        this.magSelected.setToolTipText(HuginGUIConstants.get("str_fit_selected_nodes_to_window"));
        this.magSelected.setEnabled(huginProjectFrame.getNetworkPanel().selectedNodes.size() > 0);
        double d = huginProjectFrame.getNetworkPanel().getScaleFactor();
        if (d == 2.0) {
            this.mag200.setSelected(true);
        } else if (d == 1.0) {
            this.mag100.setSelected(true);
        } else if (d == 0.75) {
            this.mag75.setSelected(true);
        } else if (d == 0.5) {
            this.mag50.setSelected(true);
        } else if (d == 0.25) {
            this.mag25.setSelected(true);
        } else {
            this.magCustom.setSelected(true);
        }
        TitledPanel titledPanel = new TitledPanel(HuginGUIConstants.get("ZOOMING_TITLE"));
        this.mag200.getModel().setActionCommand("200");
        this.mag100.getModel().setActionCommand("100");
        this.mag75.getModel().setActionCommand("75");
        this.mag50.getModel().setActionCommand("50");
        this.mag25.getModel().setActionCommand("25");
        this.magFit.getModel().setActionCommand("fit");
        this.magSelected.getModel().setActionCommand("fitSelected");
        this.magCustom.getModel().setActionCommand("custom");
        JPanel jPanel = new JPanel(new GridLayout(7, 1));
        this.zoom = (int)(d * 100.0);
        this.zoomField = new PastingTextField(String.valueOf(this.zoom));
        this.zoomField.setHorizontalAlignment(4);
        this.zoomField.setBackground(Color.white);
        this.zoomField.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ZoomingPane.this.magCustom.setSelected(true);
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.magCustom);
        jPanel2.add(this.zoomField);
        jPanel2.add(new JLabel("%"));
        jPanel.add(this.mag200);
        jPanel.add(this.mag100);
        jPanel.add(this.mag75);
        jPanel.add(this.mag50);
        jPanel.add(this.mag25);
        jPanel.add(this.magFit);
        jPanel.add(this.magSelected);
        jPanel.add(jPanel2);
        final ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mag200);
        buttonGroup.add(this.mag100);
        buttonGroup.add(this.mag75);
        buttonGroup.add(this.mag50);
        buttonGroup.add(this.mag25);
        buttonGroup.add(this.magFit);
        buttonGroup.add(this.magSelected);
        buttonGroup.add(this.magCustom);
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 5, 5));
        JButton jButton = new JButton(HuginGUIConstants.get("OK_button"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = buttonGroup.getSelection().getActionCommand();
                double d = (double)ZoomingPane.this.zoom / 100.0;
                if (string.equals("custom")) {
                    try {
                        d = (double)Integer.parseInt(ZoomingPane.this.zoomField.getText()) / 100.0;
                    }
                    catch (NumberFormatException numberFormatException) {
                        ZoomingPane.illegalZoom(ZoomingPane.this);
                        return;
                    }
                }
                if (d > 0.01 && d < 100.0) {
                    try {
                        ZoomingPane.this.project.getNetworkPanel().setScaleFactor(d);
                        if (string.equals("fitSelected")) {
                            ZoomingPane.this.project.getNetworkPanel().scrollToSelected();
                        }
                        ZoomingPane.this.self.dispose();
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                    }
                } else {
                    ZoomingPane.illegalZoom(ZoomingPane.this);
                }
            }
        });
        JButton jButton2 = new JButton(HuginGUIConstants.get("cancel_button"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ZoomingPane.this.self.dispose();
            }
        });
        this.getRootPane().setDefaultButton(jButton);
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        titledPanel.setLayout(new BorderLayout(0, 5));
        titledPanel.add((Component)jPanel, "Center");
        titledPanel.add((Component)jPanel3, "South");
        this.getContentPane().setLayout(new BorderLayout(0, 5));
        this.getContentPane().add((Component)titledPanel, "Center");
        if (System.getProperty("os.name").equals("Linux")) {
            this.setSize((int)this.getPreferredSize().getWidth() + 10, (int)this.getPreferredSize().getHeight() + 30);
        }
        this.setResizable(false);
    }

    private int computeFitZoom() {
        return (int)Math.rint(100.0 * ZoomingPane.computeFitFactor(this.project.getNetworkPanel()));
    }

    protected static double computeFitFactor(NetworkPanel networkPanel) {
        Rectangle rectangle = networkPanel.getTightBoundingBox(true);
        Rectangle rectangle2 = networkPanel.getViewRect();
        return networkPanel.getScaleFactor() * Math.min((double)rectangle2.width / (double)(rectangle.width + 10), (double)rectangle2.height / (double)(rectangle.height + 10));
    }

    protected static int computeSelectedFitZoom(NetworkPanel networkPanel) {
        Rectangle rectangle = null;
        for (Node node : networkPanel.selectedNodes) {
            if (rectangle == null) {
                rectangle = node.getBoundingBox(false);
                continue;
            }
            rectangle.add(node.getBoundingBox(false));
        }
        Rectangle rectangle2 = networkPanel.getViewRect();
        if (rectangle == null) {
            rectangle = rectangle2;
        }
        double d = Math.min((double)rectangle2.width / (double)rectangle.width, (double)rectangle2.height / (double)rectangle.height);
        return (int)Math.rint(100.0 * d * networkPanel.getScaleFactor());
    }

    protected static void illegalZoom(Component component) {
        new JOptionPane();
        JOptionPane.showMessageDialog(component, "Only positive integers in the range [1..10000] are allowed.\nPlease try again.", HuginGUIConstants.get("ZOOMING_ERROR"), 0);
    }
}

