/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI.zoom;

import COM.hugin.HGUI.zoom.ZoomableComponent;
import COM.hugin.HGUI.zoom.ZoomablePopupMenu;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class ZoomableCombobox
extends JComboBox
implements ZoomableComponent {
    double scaleFactor = 1.0;
    ComboBoxButton button;
    ZoomablePopupMenu menu;

    public ZoomableCombobox() {
        this.initialize(null);
    }

    public ZoomableCombobox(ComboBoxModel comboBoxModel) {
        this.setModel(comboBoxModel);
        this.initialize(null);
    }

    public ZoomableCombobox(Vector vector) {
        this.setModel(new DefaultComboBoxModel(vector));
        this.initialize(null);
    }

    public ZoomableCombobox(Object[] objectArray) {
        this.setModel(new DefaultComboBoxModel<Object>(objectArray));
        this.initialize(objectArray);
    }

    public void initialize(Object[] objectArray) {
        this.setFont(this.getFont().deriveFont((float)(12.0 * this.scaleFactor)));
        if (objectArray.length > 0) {
            this.setSelectedItem(objectArray[0]);
        }
        this.removeAll();
        this.menu = new ZoomablePopupMenu(this);
        this.menu.setRenderer(new ZoomableItemRenderer());
        this.button = new ComboBoxButton();
        this.button.setFocusPainted(false);
        this.setLayout(new BorderLayout());
        this.add(this.button);
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ZoomableCombobox.this.button.update();
                }
            }
        });
        this.button.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                ZoomableCombobox.this.button.showing = ZoomableCombobox.this.menu.isVisible() && ZoomableCombobox.this.button.contains(mouseEvent.getX(), mouseEvent.getY());
            }
        });
        this.setScaleFactor(this.scaleFactor);
    }

    public void setPopupVisible(boolean bl) {
        if (bl) {
            this.menu.show(this, 0, this.getPreferredSize().height);
        }
    }

    public Dimension getPreferredSize() {
        return this.button.getPreferredSize();
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(Color.red);
        Rectangle rectangle = graphics.getClipBounds();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
        this.button.setScaleFactor(d);
        this.menu.setScaleFactor(d);
        this.revalidate();
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().setLayout(new BorderLayout());
        Object[] objectArray = new String[]{"a", "test", "longer", "shrt"};
        ZoomableCombobox zoomableCombobox = new ZoomableCombobox(objectArray);
        JPanel jPanel = new JPanel(new BorderLayout());
        jFrame.getContentPane().add((Component)zoomableCombobox, "North");
        jFrame.setSize(200, 200);
        jFrame.setLocation(200, 200);
        jFrame.setVisible(true);
    }

    private class ComboBoxButton
    extends JButton
    implements ZoomableComponent {
        Font font;
        Dimension defaultSize;
        boolean showing = false;

        public ComboBoxButton() {
            this.setText();
            this.setIcon(new ComboBoxIcon());
            this.setHorizontalTextPosition(2);
            this.setHorizontalAlignment(2);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ComboBoxButton.this.showing) {
                        ZoomableCombobox.this.hidePopup();
                    } else {
                        ZoomableCombobox.this.showPopup();
                    }
                    ComboBoxButton.this.showing = !ComboBoxButton.this.showing;
                }
            });
            this.font = this.getFont();
            this.defaultSize = super.getPreferredSize();
        }

        public Insets getInsets() {
            return new Insets(5, 5, 5, 5);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension(this.getWidth(), this.getHeight());
            return dimension;
        }

        public int getHeight() {
            return (int)((double)this.defaultSize.height * ZoomableCombobox.this.scaleFactor);
        }

        public void setScaleFactor(double d) {
            this.setFont(this.font.deriveFont((float)((double)this.font.getSize2D() * d)));
        }

        public double getScaleFactor() {
            return ZoomableCombobox.this.scaleFactor;
        }

        public void update() {
            this.setText();
            this.showing = false;
        }

        private void setText() {
            String string = "";
            if (ZoomableCombobox.this.getSelectedItem() != null) {
                string = ZoomableCombobox.this.getSelectedItem().toString();
            }
            this.setToolTipText(string);
            this.setText(string);
        }

        private class ComboBoxIcon
        implements Icon {
            int width = 16;
            int height = 16;

            public int getIconWidth() {
                return (int)((double)this.width * ZoomableCombobox.this.scaleFactor);
            }

            public int getIconHeight() {
                return (int)((double)this.height * ZoomableCombobox.this.scaleFactor);
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                graphics.setColor(component.getForeground());
                int[] nArray = new int[]{(int)(3.0 * ZoomableCombobox.this.scaleFactor), (int)((double)(this.width - 2) * ZoomableCombobox.this.scaleFactor), (int)(((double)this.width / 2.0 + 1.0) * ZoomableCombobox.this.scaleFactor), (int)((double)this.width / 2.0 * ZoomableCombobox.this.scaleFactor), (int)(3.0 * ZoomableCombobox.this.scaleFactor)};
                int[] nArray2 = new int[]{(int)(3.0 * ZoomableCombobox.this.scaleFactor), (int)(3.0 * ZoomableCombobox.this.scaleFactor), (int)((double)(this.height - 6) * ZoomableCombobox.this.scaleFactor), (int)((double)(this.height - 6) * ZoomableCombobox.this.scaleFactor), (int)(3.0 * ZoomableCombobox.this.scaleFactor)};
                graphics.translate((int)((double)(component.getWidth() - this.getIconWidth()) - (double)ComboBoxButton.this.getInsets().right * ZoomableCombobox.this.scaleFactor), (component.getHeight() - this.getIconHeight()) / 2);
                graphics.fillPolygon(new Polygon(nArray, nArray2, nArray.length));
                graphics.translate(-((int)((double)(component.getWidth() - this.getIconWidth()) - (double)ComboBoxButton.this.getInsets().right * ZoomableCombobox.this.scaleFactor)), -(component.getHeight() - this.getIconHeight()) / 2);
            }
        }
    }

    private class ZoomableItemRenderer
    extends JLabel
    implements ListCellRenderer {
        Font defaultFont;
        Color fore;
        Color back;
        Color selectBack;
        Color selectFore;

        public ZoomableItemRenderer() {
            this.setOpaque(true);
            this.defaultFont = this.getFont();
            this.fore = UIManager.getDefaults().getColor("ComboBox.foreground");
            this.back = UIManager.getDefaults().getColor("ComboBox.background");
            this.selectBack = UIManager.getDefaults().getColor("ComboBox.selectionBackground");
            this.selectFore = UIManager.getDefaults().getColor("ComboBox.selectionForeground");
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(object.toString());
            this.setFont(this.defaultFont.deriveFont((float)((double)this.defaultFont.getSize2D() * ZoomableCombobox.this.scaleFactor)));
            this.setBackground(bl ? this.selectBack : this.back);
            this.setForeground(bl ? this.selectFore : this.fore);
            return this;
        }
    }
}

