/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.MODEL;

import COM.hugin.LOG.Log;
import COM.hugin.MODEL.BooleanDCNode;
import COM.hugin.MODEL.BooleanDDNode;
import COM.hugin.MODEL.ContinuousChanceNode;
import COM.hugin.MODEL.DiscreteNode;
import COM.hugin.MODEL.IntervalDCNode;
import COM.hugin.MODEL.IntervalDDNode;
import COM.hugin.MODEL.LabelledDCNode;
import COM.hugin.MODEL.LabelledDDNode;
import COM.hugin.MODEL.Node;
import COM.hugin.MODEL.NumberedDCNode;
import COM.hugin.MODEL.NumberedDDNode;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Network
implements Serializable {
    public static final int STATE_EVIDENCE_TO_PROPAGATE = 0;
    public static final int STATE_OK = 1;
    public static final int STATE_DESTROYED = 666;
    private int state;
    private String name;
    private ArrayList<Node> nodes;
    private double expectedUtility;
    private double normalizationConstant;
    private Point nodeSize;

    public Network(ArrayList<Node> arrayList, String string, Point point, double d, double d2, int n) {
        this.nodes = arrayList;
        this.name = string;
        this.state = n;
        this.expectedUtility = d;
        this.normalizationConstant = d2;
        this.nodeSize = point;
    }

    public void updateFromNetwork(Network network) {
        try {
            this.state = network.state;
            this.expectedUtility = network.expectedUtility;
            this.normalizationConstant = network.normalizationConstant;
            for (Node node : this.nodes) {
                if (node instanceof LabelledDCNode) {
                    ((LabelledDCNode)node).updateFromNode((LabelledDCNode)network.getNodeByName(node.getName()));
                } else if (node instanceof BooleanDCNode) {
                    ((BooleanDCNode)node).updateFromNode((BooleanDCNode)network.getNodeByName(node.getName()));
                } else if (node instanceof NumberedDCNode) {
                    ((NumberedDCNode)node).updateFromNode((NumberedDCNode)network.getNodeByName(node.getName()));
                } else if (node instanceof IntervalDCNode) {
                    ((IntervalDCNode)node).updateFromNode((IntervalDCNode)network.getNodeByName(node.getName()));
                } else if (node instanceof LabelledDDNode) {
                    ((LabelledDDNode)node).updateFromNode((LabelledDDNode)network.getNodeByName(node.getName()));
                } else if (node instanceof BooleanDDNode) {
                    ((BooleanDDNode)node).updateFromNode((BooleanDDNode)network.getNodeByName(node.getName()));
                } else if (node instanceof NumberedDDNode) {
                    ((NumberedDDNode)node).updateFromNode((NumberedDDNode)network.getNodeByName(node.getName()));
                } else if (node instanceof IntervalDDNode) {
                    ((IntervalDDNode)node).updateFromNode((IntervalDDNode)network.getNodeByName(node.getName()));
                } else if (node instanceof ContinuousChanceNode) {
                    ((ContinuousChanceNode)node).updateFromNode((ContinuousChanceNode)network.getNodeByName(node.getName()));
                }
                Node node2 = this.getNodeByName(node.getName());
            }
        }
        catch (Exception exception) {
            Log.printStackTrace(exception);
            this.state = 666;
        }
    }

    protected void setEvidenceToPropagate() {
        if (this.state != 666) {
            this.state = 0;
        }
    }

    public Point getNodeSize() {
        return this.nodeSize;
    }

    public boolean evidenceToPropagate() {
        return this.state == 0;
    }

    public ArrayList<Node> getNodes() {
        return this.nodes;
    }

    public Node getNodeByName(String string) {
        for (Node node : this.nodes) {
            if (!node.getName().equals(string)) continue;
            return node;
        }
        return null;
    }

    public double getExpectedUtility() {
        return this.expectedUtility;
    }

    public double getNormalizationConstant() {
        return this.normalizationConstant;
    }

    public String getName() {
        return this.name;
    }

    public void retractFindings() {
        for (Node node : this.nodes) {
            if (node instanceof DiscreteNode) {
                ((DiscreteNode)node).retractFindings();
                continue;
            }
            if (!(node instanceof ContinuousChanceNode)) continue;
            ((ContinuousChanceNode)node).retractFindings();
        }
    }
}

